# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EipArgs', 'Eip']

@pulumi.input_type
class EipArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 associate_with_private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_border_group: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface: Optional[pulumi.Input[builtins.str]] = None,
                 public_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Eip resource.
        :param pulumi.Input[builtins.str] address: IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
        :param pulumi.Input[builtins.str] associate_with_private_ip: User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        :param pulumi.Input[builtins.str] customer_owned_ipv4_pool: ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
        :param pulumi.Input[builtins.str] domain: Indicates if this EIP is for use in VPC (`vpc`).
        :param pulumi.Input[builtins.str] instance: EC2 instance ID.
        :param pulumi.Input[builtins.str] ipam_pool_id: The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
        :param pulumi.Input[builtins.str] network_border_group: Location from which the IP address is advertised. Use this parameter to limit the address to this location.
        :param pulumi.Input[builtins.str] network_interface: Network interface ID to associate with.
        :param pulumi.Input[builtins.str] public_ipv4_pool: EC2 IPv4 address pool identifier or `amazon`.
               This option is only available for VPC EIPs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both.
               Including both will **not** return an error from the AWS API, but will have undefined behavior.
               See the relevant [AssociateAddress API Call][1] for more information.
               
               > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error, however, only `address` will be used if both options are defined as the API only requires one of the two.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if associate_with_private_ip is not None:
            pulumi.set(__self__, "associate_with_private_ip", associate_with_private_ip)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if ipam_pool_id is not None:
            pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if network_border_group is not None:
            pulumi.set(__self__, "network_border_group", network_border_group)
        if network_interface is not None:
            pulumi.set(__self__, "network_interface", network_interface)
        if public_ipv4_pool is not None:
            pulumi.set(__self__, "public_ipv4_pool", public_ipv4_pool)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="associateWithPrivateIp")
    def associate_with_private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        """
        return pulumi.get(self, "associate_with_private_ip")

    @associate_with_private_ip.setter
    def associate_with_private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "associate_with_private_ip", value)

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates if this EIP is for use in VPC (`vpc`).
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EC2 instance ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
        """
        return pulumi.get(self, "ipam_pool_id")

    @ipam_pool_id.setter
    def ipam_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipam_pool_id", value)

    @property
    @pulumi.getter(name="networkBorderGroup")
    def network_border_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location from which the IP address is advertised. Use this parameter to limit the address to this location.
        """
        return pulumi.get(self, "network_border_group")

    @network_border_group.setter
    def network_border_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_border_group", value)

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network interface ID to associate with.
        """
        return pulumi.get(self, "network_interface")

    @network_interface.setter
    def network_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_interface", value)

    @property
    @pulumi.getter(name="publicIpv4Pool")
    def public_ipv4_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EC2 IPv4 address pool identifier or `amazon`.
        This option is only available for VPC EIPs.
        """
        return pulumi.get(self, "public_ipv4_pool")

    @public_ipv4_pool.setter
    def public_ipv4_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ipv4_pool", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both.
        Including both will **not** return an error from the AWS API, but will have undefined behavior.
        See the relevant [AssociateAddress API Call][1] for more information.

        > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error, however, only `address` will be used if both options are defined as the API only requires one of the two.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EipState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 associate_with_private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 association_id: Optional[pulumi.Input[builtins.str]] = None,
                 carrier_ip: Optional[pulumi.Input[builtins.str]] = None,
                 customer_owned_ip: Optional[pulumi.Input[builtins.str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_border_group: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface: Optional[pulumi.Input[builtins.str]] = None,
                 private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 ptr_record: Optional[pulumi.Input[builtins.str]] = None,
                 public_dns: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[builtins.str]] = None,
                 public_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Eip resources.
        :param pulumi.Input[builtins.str] address: IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
        :param pulumi.Input[builtins.str] allocation_id: ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
        :param pulumi.Input[builtins.str] associate_with_private_ip: User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        :param pulumi.Input[builtins.str] association_id: ID representing the association of the address with an instance in a VPC.
        :param pulumi.Input[builtins.str] carrier_ip: Carrier IP address.
        :param pulumi.Input[builtins.str] customer_owned_ip: Customer owned IP.
        :param pulumi.Input[builtins.str] customer_owned_ipv4_pool: ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
        :param pulumi.Input[builtins.str] domain: Indicates if this EIP is for use in VPC (`vpc`).
        :param pulumi.Input[builtins.str] instance: EC2 instance ID.
        :param pulumi.Input[builtins.str] ipam_pool_id: The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
        :param pulumi.Input[builtins.str] network_border_group: Location from which the IP address is advertised. Use this parameter to limit the address to this location.
        :param pulumi.Input[builtins.str] network_interface: Network interface ID to associate with.
        :param pulumi.Input[builtins.str] private_dns: The Private DNS associated with the Elastic IP address (if in VPC).
        :param pulumi.Input[builtins.str] private_ip: Contains the private IP address (if in VPC).
        :param pulumi.Input[builtins.str] ptr_record: The DNS pointer (PTR) record for the IP address.
        :param pulumi.Input[builtins.str] public_dns: Public DNS associated with the Elastic IP address.
        :param pulumi.Input[builtins.str] public_ip: Contains the public IP address.
        :param pulumi.Input[builtins.str] public_ipv4_pool: EC2 IPv4 address pool identifier or `amazon`.
               This option is only available for VPC EIPs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both.
               Including both will **not** return an error from the AWS API, but will have undefined behavior.
               See the relevant [AssociateAddress API Call][1] for more information.
               
               > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error, however, only `address` will be used if both options are defined as the API only requires one of the two.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if associate_with_private_ip is not None:
            pulumi.set(__self__, "associate_with_private_ip", associate_with_private_ip)
        if association_id is not None:
            pulumi.set(__self__, "association_id", association_id)
        if carrier_ip is not None:
            pulumi.set(__self__, "carrier_ip", carrier_ip)
        if customer_owned_ip is not None:
            pulumi.set(__self__, "customer_owned_ip", customer_owned_ip)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if ipam_pool_id is not None:
            pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if network_border_group is not None:
            pulumi.set(__self__, "network_border_group", network_border_group)
        if network_interface is not None:
            pulumi.set(__self__, "network_interface", network_interface)
        if private_dns is not None:
            pulumi.set(__self__, "private_dns", private_dns)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if ptr_record is not None:
            pulumi.set(__self__, "ptr_record", ptr_record)
        if public_dns is not None:
            pulumi.set(__self__, "public_dns", public_dns)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ipv4_pool is not None:
            pulumi.set(__self__, "public_ipv4_pool", public_ipv4_pool)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="associateWithPrivateIp")
    def associate_with_private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        """
        return pulumi.get(self, "associate_with_private_ip")

    @associate_with_private_ip.setter
    def associate_with_private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "associate_with_private_ip", value)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID representing the association of the address with an instance in a VPC.
        """
        return pulumi.get(self, "association_id")

    @association_id.setter
    def association_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "association_id", value)

    @property
    @pulumi.getter(name="carrierIp")
    def carrier_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Carrier IP address.
        """
        return pulumi.get(self, "carrier_ip")

    @carrier_ip.setter
    def carrier_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "carrier_ip", value)

    @property
    @pulumi.getter(name="customerOwnedIp")
    def customer_owned_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Customer owned IP.
        """
        return pulumi.get(self, "customer_owned_ip")

    @customer_owned_ip.setter
    def customer_owned_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_owned_ip", value)

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates if this EIP is for use in VPC (`vpc`).
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EC2 instance ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
        """
        return pulumi.get(self, "ipam_pool_id")

    @ipam_pool_id.setter
    def ipam_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipam_pool_id", value)

    @property
    @pulumi.getter(name="networkBorderGroup")
    def network_border_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location from which the IP address is advertised. Use this parameter to limit the address to this location.
        """
        return pulumi.get(self, "network_border_group")

    @network_border_group.setter
    def network_border_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_border_group", value)

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network interface ID to associate with.
        """
        return pulumi.get(self, "network_interface")

    @network_interface.setter
    def network_interface(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_interface", value)

    @property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Private DNS associated with the Elastic IP address (if in VPC).
        """
        return pulumi.get(self, "private_dns")

    @private_dns.setter
    def private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_dns", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Contains the private IP address (if in VPC).
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="ptrRecord")
    def ptr_record(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS pointer (PTR) record for the IP address.
        """
        return pulumi.get(self, "ptr_record")

    @ptr_record.setter
    def ptr_record(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ptr_record", value)

    @property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Public DNS associated with the Elastic IP address.
        """
        return pulumi.get(self, "public_dns")

    @public_dns.setter
    def public_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_dns", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Contains the public IP address.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="publicIpv4Pool")
    def public_ipv4_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EC2 IPv4 address pool identifier or `amazon`.
        This option is only available for VPC EIPs.
        """
        return pulumi.get(self, "public_ipv4_pool")

    @public_ipv4_pool.setter
    def public_ipv4_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ipv4_pool", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both.
        Including both will **not** return an error from the AWS API, but will have undefined behavior.
        See the relevant [AssociateAddress API Call][1] for more information.

        > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error, however, only `address` will be used if both options are defined as the API only requires one of the two.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:ec2/eip:Eip")
class Eip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 associate_with_private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_border_group: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface: Optional[pulumi.Input[builtins.str]] = None,
                 public_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an Elastic IP resource.

        > **Note:** EIP may require IGW to exist prior to association. Use `depends_on` to set an explicit dependency on the IGW.

        > **Note:** Do not use `network_interface` to associate the EIP to `lb.LoadBalancer` or `ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.

        ## Example Usage

        ### Single EIP associated with an instance

        ```python
        import pulumi
        import pulumi_aws as aws

        lb = aws.ec2.Eip("lb",
            instance=web["id"],
            domain="vpc")
        ```

        ### Multiple EIPs associated with a single network interface

        ```python
        import pulumi
        import pulumi_aws as aws

        multi_ip = aws.ec2.NetworkInterface("multi-ip",
            subnet_id=main["id"],
            private_ips=[
                "10.0.0.10",
                "10.0.0.11",
            ])
        one = aws.ec2.Eip("one",
            domain="vpc",
            network_interface=multi_ip.id,
            associate_with_private_ip="10.0.0.10")
        two = aws.ec2.Eip("two",
            domain="vpc",
            network_interface=multi_ip.id,
            associate_with_private_ip="10.0.0.11")
        ```

        ### Attaching an EIP to an Instance with a pre-assigned private ip (VPC Only)

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.ec2.Vpc("default",
            cidr_block="10.0.0.0/16",
            enable_dns_hostnames=True)
        gw = aws.ec2.InternetGateway("gw", vpc_id=default.id)
        my_test_subnet = aws.ec2.Subnet("my_test_subnet",
            vpc_id=default.id,
            cidr_block="10.0.0.0/24",
            map_public_ip_on_launch=True,
            opts = pulumi.ResourceOptions(depends_on=[gw]))
        foo = aws.ec2.Instance("foo",
            ami="ami-5189a661",
            instance_type=aws.ec2.InstanceType.T2_MICRO,
            private_ip="10.0.0.12",
            subnet_id=my_test_subnet.id)
        bar = aws.ec2.Eip("bar",
            domain="vpc",
            instance=foo.id,
            associate_with_private_ip="10.0.0.12",
            opts = pulumi.ResourceOptions(depends_on=[gw]))
        ```

        ### Allocating EIP from the BYOIP pool

        ```python
        import pulumi
        import pulumi_aws as aws

        byoip_ip = aws.ec2.Eip("byoip-ip",
            domain="vpc",
            public_ipv4_pool="ipv4pool-ec2-012345")
        ```

        ### Allocating EIP from the IPAM Pool

        ```python
        import pulumi
        import pulumi_aws as aws

        ipam_ip = aws.ec2.Eip("ipam-ip",
            domain="vpc",
            ipam_pool_id="ipam-pool-07ccc86aa41bef7ce")
        ```

        ## Import

        Using `pulumi import`, import EIPs in a VPC using their Allocation ID. For example:

        ```sh
        $ pulumi import aws:ec2/eip:Eip bar eipalloc-00a10e96
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
        :param pulumi.Input[builtins.str] associate_with_private_ip: User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        :param pulumi.Input[builtins.str] customer_owned_ipv4_pool: ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
        :param pulumi.Input[builtins.str] domain: Indicates if this EIP is for use in VPC (`vpc`).
        :param pulumi.Input[builtins.str] instance: EC2 instance ID.
        :param pulumi.Input[builtins.str] ipam_pool_id: The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
        :param pulumi.Input[builtins.str] network_border_group: Location from which the IP address is advertised. Use this parameter to limit the address to this location.
        :param pulumi.Input[builtins.str] network_interface: Network interface ID to associate with.
        :param pulumi.Input[builtins.str] public_ipv4_pool: EC2 IPv4 address pool identifier or `amazon`.
               This option is only available for VPC EIPs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both.
               Including both will **not** return an error from the AWS API, but will have undefined behavior.
               See the relevant [AssociateAddress API Call][1] for more information.
               
               > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error, however, only `address` will be used if both options are defined as the API only requires one of the two.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EipArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic IP resource.

        > **Note:** EIP may require IGW to exist prior to association. Use `depends_on` to set an explicit dependency on the IGW.

        > **Note:** Do not use `network_interface` to associate the EIP to `lb.LoadBalancer` or `ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.

        ## Example Usage

        ### Single EIP associated with an instance

        ```python
        import pulumi
        import pulumi_aws as aws

        lb = aws.ec2.Eip("lb",
            instance=web["id"],
            domain="vpc")
        ```

        ### Multiple EIPs associated with a single network interface

        ```python
        import pulumi
        import pulumi_aws as aws

        multi_ip = aws.ec2.NetworkInterface("multi-ip",
            subnet_id=main["id"],
            private_ips=[
                "10.0.0.10",
                "10.0.0.11",
            ])
        one = aws.ec2.Eip("one",
            domain="vpc",
            network_interface=multi_ip.id,
            associate_with_private_ip="10.0.0.10")
        two = aws.ec2.Eip("two",
            domain="vpc",
            network_interface=multi_ip.id,
            associate_with_private_ip="10.0.0.11")
        ```

        ### Attaching an EIP to an Instance with a pre-assigned private ip (VPC Only)

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.ec2.Vpc("default",
            cidr_block="10.0.0.0/16",
            enable_dns_hostnames=True)
        gw = aws.ec2.InternetGateway("gw", vpc_id=default.id)
        my_test_subnet = aws.ec2.Subnet("my_test_subnet",
            vpc_id=default.id,
            cidr_block="10.0.0.0/24",
            map_public_ip_on_launch=True,
            opts = pulumi.ResourceOptions(depends_on=[gw]))
        foo = aws.ec2.Instance("foo",
            ami="ami-5189a661",
            instance_type=aws.ec2.InstanceType.T2_MICRO,
            private_ip="10.0.0.12",
            subnet_id=my_test_subnet.id)
        bar = aws.ec2.Eip("bar",
            domain="vpc",
            instance=foo.id,
            associate_with_private_ip="10.0.0.12",
            opts = pulumi.ResourceOptions(depends_on=[gw]))
        ```

        ### Allocating EIP from the BYOIP pool

        ```python
        import pulumi
        import pulumi_aws as aws

        byoip_ip = aws.ec2.Eip("byoip-ip",
            domain="vpc",
            public_ipv4_pool="ipv4pool-ec2-012345")
        ```

        ### Allocating EIP from the IPAM Pool

        ```python
        import pulumi
        import pulumi_aws as aws

        ipam_ip = aws.ec2.Eip("ipam-ip",
            domain="vpc",
            ipam_pool_id="ipam-pool-07ccc86aa41bef7ce")
        ```

        ## Import

        Using `pulumi import`, import EIPs in a VPC using their Allocation ID. For example:

        ```sh
        $ pulumi import aws:ec2/eip:Eip bar eipalloc-00a10e96
        ```

        :param str resource_name: The name of the resource.
        :param EipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 associate_with_private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_border_group: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface: Optional[pulumi.Input[builtins.str]] = None,
                 public_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipArgs.__new__(EipArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["associate_with_private_ip"] = associate_with_private_ip
            __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
            __props__.__dict__["domain"] = domain
            __props__.__dict__["instance"] = instance
            __props__.__dict__["ipam_pool_id"] = ipam_pool_id
            __props__.__dict__["network_border_group"] = network_border_group
            __props__.__dict__["network_interface"] = network_interface
            __props__.__dict__["public_ipv4_pool"] = public_ipv4_pool
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["allocation_id"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["association_id"] = None
            __props__.__dict__["carrier_ip"] = None
            __props__.__dict__["customer_owned_ip"] = None
            __props__.__dict__["private_dns"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["ptr_record"] = None
            __props__.__dict__["public_dns"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["tags_all"] = None
        super(Eip, __self__).__init__(
            'aws:ec2/eip:Eip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[builtins.str]] = None,
            allocation_id: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            associate_with_private_ip: Optional[pulumi.Input[builtins.str]] = None,
            association_id: Optional[pulumi.Input[builtins.str]] = None,
            carrier_ip: Optional[pulumi.Input[builtins.str]] = None,
            customer_owned_ip: Optional[pulumi.Input[builtins.str]] = None,
            customer_owned_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
            domain: Optional[pulumi.Input[builtins.str]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            network_border_group: Optional[pulumi.Input[builtins.str]] = None,
            network_interface: Optional[pulumi.Input[builtins.str]] = None,
            private_dns: Optional[pulumi.Input[builtins.str]] = None,
            private_ip: Optional[pulumi.Input[builtins.str]] = None,
            ptr_record: Optional[pulumi.Input[builtins.str]] = None,
            public_dns: Optional[pulumi.Input[builtins.str]] = None,
            public_ip: Optional[pulumi.Input[builtins.str]] = None,
            public_ipv4_pool: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Eip':
        """
        Get an existing Eip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
        :param pulumi.Input[builtins.str] allocation_id: ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
        :param pulumi.Input[builtins.str] associate_with_private_ip: User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        :param pulumi.Input[builtins.str] association_id: ID representing the association of the address with an instance in a VPC.
        :param pulumi.Input[builtins.str] carrier_ip: Carrier IP address.
        :param pulumi.Input[builtins.str] customer_owned_ip: Customer owned IP.
        :param pulumi.Input[builtins.str] customer_owned_ipv4_pool: ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
        :param pulumi.Input[builtins.str] domain: Indicates if this EIP is for use in VPC (`vpc`).
        :param pulumi.Input[builtins.str] instance: EC2 instance ID.
        :param pulumi.Input[builtins.str] ipam_pool_id: The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
        :param pulumi.Input[builtins.str] network_border_group: Location from which the IP address is advertised. Use this parameter to limit the address to this location.
        :param pulumi.Input[builtins.str] network_interface: Network interface ID to associate with.
        :param pulumi.Input[builtins.str] private_dns: The Private DNS associated with the Elastic IP address (if in VPC).
        :param pulumi.Input[builtins.str] private_ip: Contains the private IP address (if in VPC).
        :param pulumi.Input[builtins.str] ptr_record: The DNS pointer (PTR) record for the IP address.
        :param pulumi.Input[builtins.str] public_dns: Public DNS associated with the Elastic IP address.
        :param pulumi.Input[builtins.str] public_ip: Contains the public IP address.
        :param pulumi.Input[builtins.str] public_ipv4_pool: EC2 IPv4 address pool identifier or `amazon`.
               This option is only available for VPC EIPs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both.
               Including both will **not** return an error from the AWS API, but will have undefined behavior.
               See the relevant [AssociateAddress API Call][1] for more information.
               
               > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error, however, only `address` will be used if both options are defined as the API only requires one of the two.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipState.__new__(_EipState)

        __props__.__dict__["address"] = address
        __props__.__dict__["allocation_id"] = allocation_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["associate_with_private_ip"] = associate_with_private_ip
        __props__.__dict__["association_id"] = association_id
        __props__.__dict__["carrier_ip"] = carrier_ip
        __props__.__dict__["customer_owned_ip"] = customer_owned_ip
        __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
        __props__.__dict__["domain"] = domain
        __props__.__dict__["instance"] = instance
        __props__.__dict__["ipam_pool_id"] = ipam_pool_id
        __props__.__dict__["network_border_group"] = network_border_group
        __props__.__dict__["network_interface"] = network_interface
        __props__.__dict__["private_dns"] = private_dns
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["ptr_record"] = ptr_record
        __props__.__dict__["public_dns"] = public_dns
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["public_ipv4_pool"] = public_ipv4_pool
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Eip(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> pulumi.Output[builtins.str]:
        """
        ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
        """
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associateWithPrivateIp")
    def associate_with_private_ip(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
        """
        return pulumi.get(self, "associate_with_private_ip")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[builtins.str]:
        """
        ID representing the association of the address with an instance in a VPC.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="carrierIp")
    def carrier_ip(self) -> pulumi.Output[builtins.str]:
        """
        Carrier IP address.
        """
        return pulumi.get(self, "carrier_ip")

    @property
    @pulumi.getter(name="customerOwnedIp")
    def customer_owned_ip(self) -> pulumi.Output[builtins.str]:
        """
        Customer owned IP.
        """
        return pulumi.get(self, "customer_owned_ip")

    @property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[builtins.str]:
        """
        Indicates if this EIP is for use in VPC (`vpc`).
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        EC2 instance ID.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4 CIDR provisioned to it.
        """
        return pulumi.get(self, "ipam_pool_id")

    @property
    @pulumi.getter(name="networkBorderGroup")
    def network_border_group(self) -> pulumi.Output[builtins.str]:
        """
        Location from which the IP address is advertised. Use this parameter to limit the address to this location.
        """
        return pulumi.get(self, "network_border_group")

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> pulumi.Output[builtins.str]:
        """
        Network interface ID to associate with.
        """
        return pulumi.get(self, "network_interface")

    @property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> pulumi.Output[builtins.str]:
        """
        The Private DNS associated with the Elastic IP address (if in VPC).
        """
        return pulumi.get(self, "private_dns")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[builtins.str]:
        """
        Contains the private IP address (if in VPC).
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="ptrRecord")
    def ptr_record(self) -> pulumi.Output[builtins.str]:
        """
        The DNS pointer (PTR) record for the IP address.
        """
        return pulumi.get(self, "ptr_record")

    @property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> pulumi.Output[builtins.str]:
        """
        Public DNS associated with the Elastic IP address.
        """
        return pulumi.get(self, "public_dns")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[builtins.str]:
        """
        Contains the public IP address.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIpv4Pool")
    def public_ipv4_pool(self) -> pulumi.Output[builtins.str]:
        """
        EC2 IPv4 address pool identifier or `amazon`.
        This option is only available for VPC EIPs.
        """
        return pulumi.get(self, "public_ipv4_pool")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both.
        Including both will **not** return an error from the AWS API, but will have undefined behavior.
        See the relevant [AssociateAddress API Call][1] for more information.

        > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error, however, only `address` will be used if both options are defined as the API only requires one of the two.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

