# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 launch_template_configs: pulumi.Input[Sequence[pulumi.Input['FleetLaunchTemplateConfigArgs']]],
                 target_capacity_specification: pulumi.Input['FleetTargetCapacitySpecificationArgs'],
                 context: Optional[pulumi.Input[builtins.str]] = None,
                 excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_instance_sets: Optional[pulumi.Input[Sequence[pulumi.Input['FleetFleetInstanceSetArgs']]]] = None,
                 fleet_state: Optional[pulumi.Input[builtins.str]] = None,
                 fulfilled_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 fulfilled_on_demand_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 on_demand_options: Optional[pulumi.Input['FleetOnDemandOptionsArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_options: Optional[pulumi.Input['FleetSpotOptionsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 terminate_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 valid_from: Optional[pulumi.Input[builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[Sequence[pulumi.Input['FleetLaunchTemplateConfigArgs']]] launch_template_configs: Nested argument containing EC2 Launch Template configurations. Defined below.
        :param pulumi.Input['FleetTargetCapacitySpecificationArgs'] target_capacity_specification: Nested argument containing target capacity configurations. Defined below.
        :param pulumi.Input[builtins.str] context: Reserved.
        :param pulumi.Input[builtins.str] excess_capacity_termination_policy: Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
        :param pulumi.Input[Sequence[pulumi.Input['FleetFleetInstanceSetArgs']]] fleet_instance_sets: Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
        :param pulumi.Input[builtins.str] fleet_state: The state of the EC2 Fleet.
        :param pulumi.Input[builtins.float] fulfilled_capacity: The number of units fulfilled by this request compared to the set target capacity.
        :param pulumi.Input[builtins.float] fulfilled_on_demand_capacity: The number of units fulfilled by this request compared to the set target On-Demand capacity.
        :param pulumi.Input['FleetOnDemandOptionsArgs'] on_demand_options: Nested argument containing On-Demand configurations. Defined below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_unhealthy_instances: Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
        :param pulumi.Input['FleetSpotOptionsArgs'] spot_options: Nested argument containing Spot configurations. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.bool] terminate_instances: Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
        :param pulumi.Input[builtins.bool] terminate_instances_with_expiration: Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
        :param pulumi.Input[builtins.str] type: The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
        :param pulumi.Input[builtins.str] valid_from: The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[builtins.str] valid_until: The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
        """
        pulumi.set(__self__, "launch_template_configs", launch_template_configs)
        pulumi.set(__self__, "target_capacity_specification", target_capacity_specification)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if excess_capacity_termination_policy is not None:
            pulumi.set(__self__, "excess_capacity_termination_policy", excess_capacity_termination_policy)
        if fleet_instance_sets is not None:
            pulumi.set(__self__, "fleet_instance_sets", fleet_instance_sets)
        if fleet_state is not None:
            pulumi.set(__self__, "fleet_state", fleet_state)
        if fulfilled_capacity is not None:
            pulumi.set(__self__, "fulfilled_capacity", fulfilled_capacity)
        if fulfilled_on_demand_capacity is not None:
            pulumi.set(__self__, "fulfilled_on_demand_capacity", fulfilled_on_demand_capacity)
        if on_demand_options is not None:
            pulumi.set(__self__, "on_demand_options", on_demand_options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replace_unhealthy_instances is not None:
            pulumi.set(__self__, "replace_unhealthy_instances", replace_unhealthy_instances)
        if spot_options is not None:
            pulumi.set(__self__, "spot_options", spot_options)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terminate_instances is not None:
            pulumi.set(__self__, "terminate_instances", terminate_instances)
        if terminate_instances_with_expiration is not None:
            pulumi.set(__self__, "terminate_instances_with_expiration", terminate_instances_with_expiration)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)

    @property
    @pulumi.getter(name="launchTemplateConfigs")
    def launch_template_configs(self) -> pulumi.Input[Sequence[pulumi.Input['FleetLaunchTemplateConfigArgs']]]:
        """
        Nested argument containing EC2 Launch Template configurations. Defined below.
        """
        return pulumi.get(self, "launch_template_configs")

    @launch_template_configs.setter
    def launch_template_configs(self, value: pulumi.Input[Sequence[pulumi.Input['FleetLaunchTemplateConfigArgs']]]):
        pulumi.set(self, "launch_template_configs", value)

    @property
    @pulumi.getter(name="targetCapacitySpecification")
    def target_capacity_specification(self) -> pulumi.Input['FleetTargetCapacitySpecificationArgs']:
        """
        Nested argument containing target capacity configurations. Defined below.
        """
        return pulumi.get(self, "target_capacity_specification")

    @target_capacity_specification.setter
    def target_capacity_specification(self, value: pulumi.Input['FleetTargetCapacitySpecificationArgs']):
        pulumi.set(self, "target_capacity_specification", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="excessCapacityTerminationPolicy")
    def excess_capacity_termination_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
        """
        return pulumi.get(self, "excess_capacity_termination_policy")

    @excess_capacity_termination_policy.setter
    def excess_capacity_termination_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "excess_capacity_termination_policy", value)

    @property
    @pulumi.getter(name="fleetInstanceSets")
    def fleet_instance_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetFleetInstanceSetArgs']]]]:
        """
        Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
        """
        return pulumi.get(self, "fleet_instance_sets")

    @fleet_instance_sets.setter
    def fleet_instance_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetFleetInstanceSetArgs']]]]):
        pulumi.set(self, "fleet_instance_sets", value)

    @property
    @pulumi.getter(name="fleetState")
    def fleet_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the EC2 Fleet.
        """
        return pulumi.get(self, "fleet_state")

    @fleet_state.setter
    def fleet_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_state", value)

    @property
    @pulumi.getter(name="fulfilledCapacity")
    def fulfilled_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of units fulfilled by this request compared to the set target capacity.
        """
        return pulumi.get(self, "fulfilled_capacity")

    @fulfilled_capacity.setter
    def fulfilled_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "fulfilled_capacity", value)

    @property
    @pulumi.getter(name="fulfilledOnDemandCapacity")
    def fulfilled_on_demand_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of units fulfilled by this request compared to the set target On-Demand capacity.
        """
        return pulumi.get(self, "fulfilled_on_demand_capacity")

    @fulfilled_on_demand_capacity.setter
    def fulfilled_on_demand_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "fulfilled_on_demand_capacity", value)

    @property
    @pulumi.getter(name="onDemandOptions")
    def on_demand_options(self) -> Optional[pulumi.Input['FleetOnDemandOptionsArgs']]:
        """
        Nested argument containing On-Demand configurations. Defined below.
        """
        return pulumi.get(self, "on_demand_options")

    @on_demand_options.setter
    def on_demand_options(self, value: Optional[pulumi.Input['FleetOnDemandOptionsArgs']]):
        pulumi.set(self, "on_demand_options", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replaceUnhealthyInstances")
    def replace_unhealthy_instances(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
        """
        return pulumi.get(self, "replace_unhealthy_instances")

    @replace_unhealthy_instances.setter
    def replace_unhealthy_instances(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replace_unhealthy_instances", value)

    @property
    @pulumi.getter(name="spotOptions")
    def spot_options(self) -> Optional[pulumi.Input['FleetSpotOptionsArgs']]:
        """
        Nested argument containing Spot configurations. Defined below.
        """
        return pulumi.get(self, "spot_options")

    @spot_options.setter
    def spot_options(self, value: Optional[pulumi.Input['FleetSpotOptionsArgs']]):
        pulumi.set(self, "spot_options", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="terminateInstances")
    def terminate_instances(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instances")

    @terminate_instances.setter
    def terminate_instances(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_instances", value)

    @property
    @pulumi.getter(name="terminateInstancesWithExpiration")
    def terminate_instances_with_expiration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instances_with_expiration")

    @terminate_instances_with_expiration.setter
    def terminate_instances_with_expiration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_instances_with_expiration", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_from", value)

    @property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_until", value)


@pulumi.input_type
class _FleetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 context: Optional[pulumi.Input[builtins.str]] = None,
                 excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_instance_sets: Optional[pulumi.Input[Sequence[pulumi.Input['FleetFleetInstanceSetArgs']]]] = None,
                 fleet_state: Optional[pulumi.Input[builtins.str]] = None,
                 fulfilled_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 fulfilled_on_demand_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FleetLaunchTemplateConfigArgs']]]] = None,
                 on_demand_options: Optional[pulumi.Input['FleetOnDemandOptionsArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_options: Optional[pulumi.Input['FleetSpotOptionsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_capacity_specification: Optional[pulumi.Input['FleetTargetCapacitySpecificationArgs']] = None,
                 terminate_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 valid_from: Optional[pulumi.Input[builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Fleet resources.
        :param pulumi.Input[builtins.str] arn: The ARN of the fleet
        :param pulumi.Input[builtins.str] context: Reserved.
        :param pulumi.Input[builtins.str] excess_capacity_termination_policy: Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
        :param pulumi.Input[Sequence[pulumi.Input['FleetFleetInstanceSetArgs']]] fleet_instance_sets: Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
        :param pulumi.Input[builtins.str] fleet_state: The state of the EC2 Fleet.
        :param pulumi.Input[builtins.float] fulfilled_capacity: The number of units fulfilled by this request compared to the set target capacity.
        :param pulumi.Input[builtins.float] fulfilled_on_demand_capacity: The number of units fulfilled by this request compared to the set target On-Demand capacity.
        :param pulumi.Input[Sequence[pulumi.Input['FleetLaunchTemplateConfigArgs']]] launch_template_configs: Nested argument containing EC2 Launch Template configurations. Defined below.
        :param pulumi.Input['FleetOnDemandOptionsArgs'] on_demand_options: Nested argument containing On-Demand configurations. Defined below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_unhealthy_instances: Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
        :param pulumi.Input['FleetSpotOptionsArgs'] spot_options: Nested argument containing Spot configurations. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['FleetTargetCapacitySpecificationArgs'] target_capacity_specification: Nested argument containing target capacity configurations. Defined below.
        :param pulumi.Input[builtins.bool] terminate_instances: Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
        :param pulumi.Input[builtins.bool] terminate_instances_with_expiration: Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
        :param pulumi.Input[builtins.str] type: The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
        :param pulumi.Input[builtins.str] valid_from: The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[builtins.str] valid_until: The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if excess_capacity_termination_policy is not None:
            pulumi.set(__self__, "excess_capacity_termination_policy", excess_capacity_termination_policy)
        if fleet_instance_sets is not None:
            pulumi.set(__self__, "fleet_instance_sets", fleet_instance_sets)
        if fleet_state is not None:
            pulumi.set(__self__, "fleet_state", fleet_state)
        if fulfilled_capacity is not None:
            pulumi.set(__self__, "fulfilled_capacity", fulfilled_capacity)
        if fulfilled_on_demand_capacity is not None:
            pulumi.set(__self__, "fulfilled_on_demand_capacity", fulfilled_on_demand_capacity)
        if launch_template_configs is not None:
            pulumi.set(__self__, "launch_template_configs", launch_template_configs)
        if on_demand_options is not None:
            pulumi.set(__self__, "on_demand_options", on_demand_options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replace_unhealthy_instances is not None:
            pulumi.set(__self__, "replace_unhealthy_instances", replace_unhealthy_instances)
        if spot_options is not None:
            pulumi.set(__self__, "spot_options", spot_options)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_capacity_specification is not None:
            pulumi.set(__self__, "target_capacity_specification", target_capacity_specification)
        if terminate_instances is not None:
            pulumi.set(__self__, "terminate_instances", terminate_instances)
        if terminate_instances_with_expiration is not None:
            pulumi.set(__self__, "terminate_instances_with_expiration", terminate_instances_with_expiration)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the fleet
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="excessCapacityTerminationPolicy")
    def excess_capacity_termination_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
        """
        return pulumi.get(self, "excess_capacity_termination_policy")

    @excess_capacity_termination_policy.setter
    def excess_capacity_termination_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "excess_capacity_termination_policy", value)

    @property
    @pulumi.getter(name="fleetInstanceSets")
    def fleet_instance_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetFleetInstanceSetArgs']]]]:
        """
        Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
        """
        return pulumi.get(self, "fleet_instance_sets")

    @fleet_instance_sets.setter
    def fleet_instance_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetFleetInstanceSetArgs']]]]):
        pulumi.set(self, "fleet_instance_sets", value)

    @property
    @pulumi.getter(name="fleetState")
    def fleet_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the EC2 Fleet.
        """
        return pulumi.get(self, "fleet_state")

    @fleet_state.setter
    def fleet_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_state", value)

    @property
    @pulumi.getter(name="fulfilledCapacity")
    def fulfilled_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of units fulfilled by this request compared to the set target capacity.
        """
        return pulumi.get(self, "fulfilled_capacity")

    @fulfilled_capacity.setter
    def fulfilled_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "fulfilled_capacity", value)

    @property
    @pulumi.getter(name="fulfilledOnDemandCapacity")
    def fulfilled_on_demand_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of units fulfilled by this request compared to the set target On-Demand capacity.
        """
        return pulumi.get(self, "fulfilled_on_demand_capacity")

    @fulfilled_on_demand_capacity.setter
    def fulfilled_on_demand_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "fulfilled_on_demand_capacity", value)

    @property
    @pulumi.getter(name="launchTemplateConfigs")
    def launch_template_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetLaunchTemplateConfigArgs']]]]:
        """
        Nested argument containing EC2 Launch Template configurations. Defined below.
        """
        return pulumi.get(self, "launch_template_configs")

    @launch_template_configs.setter
    def launch_template_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetLaunchTemplateConfigArgs']]]]):
        pulumi.set(self, "launch_template_configs", value)

    @property
    @pulumi.getter(name="onDemandOptions")
    def on_demand_options(self) -> Optional[pulumi.Input['FleetOnDemandOptionsArgs']]:
        """
        Nested argument containing On-Demand configurations. Defined below.
        """
        return pulumi.get(self, "on_demand_options")

    @on_demand_options.setter
    def on_demand_options(self, value: Optional[pulumi.Input['FleetOnDemandOptionsArgs']]):
        pulumi.set(self, "on_demand_options", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replaceUnhealthyInstances")
    def replace_unhealthy_instances(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
        """
        return pulumi.get(self, "replace_unhealthy_instances")

    @replace_unhealthy_instances.setter
    def replace_unhealthy_instances(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replace_unhealthy_instances", value)

    @property
    @pulumi.getter(name="spotOptions")
    def spot_options(self) -> Optional[pulumi.Input['FleetSpotOptionsArgs']]:
        """
        Nested argument containing Spot configurations. Defined below.
        """
        return pulumi.get(self, "spot_options")

    @spot_options.setter
    def spot_options(self, value: Optional[pulumi.Input['FleetSpotOptionsArgs']]):
        pulumi.set(self, "spot_options", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetCapacitySpecification")
    def target_capacity_specification(self) -> Optional[pulumi.Input['FleetTargetCapacitySpecificationArgs']]:
        """
        Nested argument containing target capacity configurations. Defined below.
        """
        return pulumi.get(self, "target_capacity_specification")

    @target_capacity_specification.setter
    def target_capacity_specification(self, value: Optional[pulumi.Input['FleetTargetCapacitySpecificationArgs']]):
        pulumi.set(self, "target_capacity_specification", value)

    @property
    @pulumi.getter(name="terminateInstances")
    def terminate_instances(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instances")

    @terminate_instances.setter
    def terminate_instances(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_instances", value)

    @property
    @pulumi.getter(name="terminateInstancesWithExpiration")
    def terminate_instances_with_expiration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instances_with_expiration")

    @terminate_instances_with_expiration.setter
    def terminate_instances_with_expiration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_instances_with_expiration", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_from", value)

    @property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_until", value)


@pulumi.type_token("aws:ec2/fleet:Fleet")
class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 context: Optional[pulumi.Input[builtins.str]] = None,
                 excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_instance_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetFleetInstanceSetArgs', 'FleetFleetInstanceSetArgsDict']]]]] = None,
                 fleet_state: Optional[pulumi.Input[builtins.str]] = None,
                 fulfilled_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 fulfilled_on_demand_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetLaunchTemplateConfigArgs', 'FleetLaunchTemplateConfigArgsDict']]]]] = None,
                 on_demand_options: Optional[pulumi.Input[Union['FleetOnDemandOptionsArgs', 'FleetOnDemandOptionsArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_options: Optional[pulumi.Input[Union['FleetSpotOptionsArgs', 'FleetSpotOptionsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_capacity_specification: Optional[pulumi.Input[Union['FleetTargetCapacitySpecificationArgs', 'FleetTargetCapacitySpecificationArgsDict']]] = None,
                 terminate_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 valid_from: Optional[pulumi.Input[builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage EC2 Fleets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.Fleet("example",
            launch_template_configs=[{
                "launch_template_specification": {
                    "launch_template_id": example_aws_launch_template["id"],
                    "version": example_aws_launch_template["latestVersion"],
                },
            }],
            target_capacity_specification={
                "default_target_capacity_type": "spot",
                "total_target_capacity": 5,
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_ec2_fleet` using the Fleet identifier. For example:

        ```sh
        $ pulumi import aws:ec2/fleet:Fleet example fleet-b9b55d27-c5fc-41ac-a6f3-48fcc91f080c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] context: Reserved.
        :param pulumi.Input[builtins.str] excess_capacity_termination_policy: Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetFleetInstanceSetArgs', 'FleetFleetInstanceSetArgsDict']]]] fleet_instance_sets: Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
        :param pulumi.Input[builtins.str] fleet_state: The state of the EC2 Fleet.
        :param pulumi.Input[builtins.float] fulfilled_capacity: The number of units fulfilled by this request compared to the set target capacity.
        :param pulumi.Input[builtins.float] fulfilled_on_demand_capacity: The number of units fulfilled by this request compared to the set target On-Demand capacity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetLaunchTemplateConfigArgs', 'FleetLaunchTemplateConfigArgsDict']]]] launch_template_configs: Nested argument containing EC2 Launch Template configurations. Defined below.
        :param pulumi.Input[Union['FleetOnDemandOptionsArgs', 'FleetOnDemandOptionsArgsDict']] on_demand_options: Nested argument containing On-Demand configurations. Defined below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_unhealthy_instances: Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
        :param pulumi.Input[Union['FleetSpotOptionsArgs', 'FleetSpotOptionsArgsDict']] spot_options: Nested argument containing Spot configurations. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['FleetTargetCapacitySpecificationArgs', 'FleetTargetCapacitySpecificationArgsDict']] target_capacity_specification: Nested argument containing target capacity configurations. Defined below.
        :param pulumi.Input[builtins.bool] terminate_instances: Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
        :param pulumi.Input[builtins.bool] terminate_instances_with_expiration: Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
        :param pulumi.Input[builtins.str] type: The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
        :param pulumi.Input[builtins.str] valid_from: The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[builtins.str] valid_until: The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage EC2 Fleets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.Fleet("example",
            launch_template_configs=[{
                "launch_template_specification": {
                    "launch_template_id": example_aws_launch_template["id"],
                    "version": example_aws_launch_template["latestVersion"],
                },
            }],
            target_capacity_specification={
                "default_target_capacity_type": "spot",
                "total_target_capacity": 5,
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_ec2_fleet` using the Fleet identifier. For example:

        ```sh
        $ pulumi import aws:ec2/fleet:Fleet example fleet-b9b55d27-c5fc-41ac-a6f3-48fcc91f080c
        ```

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 context: Optional[pulumi.Input[builtins.str]] = None,
                 excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_instance_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetFleetInstanceSetArgs', 'FleetFleetInstanceSetArgsDict']]]]] = None,
                 fleet_state: Optional[pulumi.Input[builtins.str]] = None,
                 fulfilled_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 fulfilled_on_demand_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetLaunchTemplateConfigArgs', 'FleetLaunchTemplateConfigArgsDict']]]]] = None,
                 on_demand_options: Optional[pulumi.Input[Union['FleetOnDemandOptionsArgs', 'FleetOnDemandOptionsArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_options: Optional[pulumi.Input[Union['FleetSpotOptionsArgs', 'FleetSpotOptionsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_capacity_specification: Optional[pulumi.Input[Union['FleetTargetCapacitySpecificationArgs', 'FleetTargetCapacitySpecificationArgsDict']]] = None,
                 terminate_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 valid_from: Optional[pulumi.Input[builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            __props__.__dict__["context"] = context
            __props__.__dict__["excess_capacity_termination_policy"] = excess_capacity_termination_policy
            __props__.__dict__["fleet_instance_sets"] = fleet_instance_sets
            __props__.__dict__["fleet_state"] = fleet_state
            __props__.__dict__["fulfilled_capacity"] = fulfilled_capacity
            __props__.__dict__["fulfilled_on_demand_capacity"] = fulfilled_on_demand_capacity
            if launch_template_configs is None and not opts.urn:
                raise TypeError("Missing required property 'launch_template_configs'")
            __props__.__dict__["launch_template_configs"] = launch_template_configs
            __props__.__dict__["on_demand_options"] = on_demand_options
            __props__.__dict__["region"] = region
            __props__.__dict__["replace_unhealthy_instances"] = replace_unhealthy_instances
            __props__.__dict__["spot_options"] = spot_options
            __props__.__dict__["tags"] = tags
            if target_capacity_specification is None and not opts.urn:
                raise TypeError("Missing required property 'target_capacity_specification'")
            __props__.__dict__["target_capacity_specification"] = target_capacity_specification
            __props__.__dict__["terminate_instances"] = terminate_instances
            __props__.__dict__["terminate_instances_with_expiration"] = terminate_instances_with_expiration
            __props__.__dict__["type"] = type
            __props__.__dict__["valid_from"] = valid_from
            __props__.__dict__["valid_until"] = valid_until
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Fleet, __self__).__init__(
            'aws:ec2/fleet:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            context: Optional[pulumi.Input[builtins.str]] = None,
            excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
            fleet_instance_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetFleetInstanceSetArgs', 'FleetFleetInstanceSetArgsDict']]]]] = None,
            fleet_state: Optional[pulumi.Input[builtins.str]] = None,
            fulfilled_capacity: Optional[pulumi.Input[builtins.float]] = None,
            fulfilled_on_demand_capacity: Optional[pulumi.Input[builtins.float]] = None,
            launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetLaunchTemplateConfigArgs', 'FleetLaunchTemplateConfigArgsDict']]]]] = None,
            on_demand_options: Optional[pulumi.Input[Union['FleetOnDemandOptionsArgs', 'FleetOnDemandOptionsArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
            spot_options: Optional[pulumi.Input[Union['FleetSpotOptionsArgs', 'FleetSpotOptionsArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_capacity_specification: Optional[pulumi.Input[Union['FleetTargetCapacitySpecificationArgs', 'FleetTargetCapacitySpecificationArgsDict']]] = None,
            terminate_instances: Optional[pulumi.Input[builtins.bool]] = None,
            terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            valid_from: Optional[pulumi.Input[builtins.str]] = None,
            valid_until: Optional[pulumi.Input[builtins.str]] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The ARN of the fleet
        :param pulumi.Input[builtins.str] context: Reserved.
        :param pulumi.Input[builtins.str] excess_capacity_termination_policy: Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetFleetInstanceSetArgs', 'FleetFleetInstanceSetArgsDict']]]] fleet_instance_sets: Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
        :param pulumi.Input[builtins.str] fleet_state: The state of the EC2 Fleet.
        :param pulumi.Input[builtins.float] fulfilled_capacity: The number of units fulfilled by this request compared to the set target capacity.
        :param pulumi.Input[builtins.float] fulfilled_on_demand_capacity: The number of units fulfilled by this request compared to the set target On-Demand capacity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetLaunchTemplateConfigArgs', 'FleetLaunchTemplateConfigArgsDict']]]] launch_template_configs: Nested argument containing EC2 Launch Template configurations. Defined below.
        :param pulumi.Input[Union['FleetOnDemandOptionsArgs', 'FleetOnDemandOptionsArgsDict']] on_demand_options: Nested argument containing On-Demand configurations. Defined below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_unhealthy_instances: Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
        :param pulumi.Input[Union['FleetSpotOptionsArgs', 'FleetSpotOptionsArgsDict']] spot_options: Nested argument containing Spot configurations. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['FleetTargetCapacitySpecificationArgs', 'FleetTargetCapacitySpecificationArgsDict']] target_capacity_specification: Nested argument containing target capacity configurations. Defined below.
        :param pulumi.Input[builtins.bool] terminate_instances: Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
        :param pulumi.Input[builtins.bool] terminate_instances_with_expiration: Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
        :param pulumi.Input[builtins.str] type: The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
        :param pulumi.Input[builtins.str] valid_from: The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[builtins.str] valid_until: The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetState.__new__(_FleetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["context"] = context
        __props__.__dict__["excess_capacity_termination_policy"] = excess_capacity_termination_policy
        __props__.__dict__["fleet_instance_sets"] = fleet_instance_sets
        __props__.__dict__["fleet_state"] = fleet_state
        __props__.__dict__["fulfilled_capacity"] = fulfilled_capacity
        __props__.__dict__["fulfilled_on_demand_capacity"] = fulfilled_on_demand_capacity
        __props__.__dict__["launch_template_configs"] = launch_template_configs
        __props__.__dict__["on_demand_options"] = on_demand_options
        __props__.__dict__["region"] = region
        __props__.__dict__["replace_unhealthy_instances"] = replace_unhealthy_instances
        __props__.__dict__["spot_options"] = spot_options
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_capacity_specification"] = target_capacity_specification
        __props__.__dict__["terminate_instances"] = terminate_instances
        __props__.__dict__["terminate_instances_with_expiration"] = terminate_instances_with_expiration
        __props__.__dict__["type"] = type
        __props__.__dict__["valid_from"] = valid_from
        __props__.__dict__["valid_until"] = valid_until
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the fleet
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="excessCapacityTerminationPolicy")
    def excess_capacity_termination_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
        """
        return pulumi.get(self, "excess_capacity_termination_policy")

    @property
    @pulumi.getter(name="fleetInstanceSets")
    def fleet_instance_sets(self) -> pulumi.Output[Sequence['outputs.FleetFleetInstanceSet']]:
        """
        Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
        """
        return pulumi.get(self, "fleet_instance_sets")

    @property
    @pulumi.getter(name="fleetState")
    def fleet_state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the EC2 Fleet.
        """
        return pulumi.get(self, "fleet_state")

    @property
    @pulumi.getter(name="fulfilledCapacity")
    def fulfilled_capacity(self) -> pulumi.Output[builtins.float]:
        """
        The number of units fulfilled by this request compared to the set target capacity.
        """
        return pulumi.get(self, "fulfilled_capacity")

    @property
    @pulumi.getter(name="fulfilledOnDemandCapacity")
    def fulfilled_on_demand_capacity(self) -> pulumi.Output[builtins.float]:
        """
        The number of units fulfilled by this request compared to the set target On-Demand capacity.
        """
        return pulumi.get(self, "fulfilled_on_demand_capacity")

    @property
    @pulumi.getter(name="launchTemplateConfigs")
    def launch_template_configs(self) -> pulumi.Output[Sequence['outputs.FleetLaunchTemplateConfig']]:
        """
        Nested argument containing EC2 Launch Template configurations. Defined below.
        """
        return pulumi.get(self, "launch_template_configs")

    @property
    @pulumi.getter(name="onDemandOptions")
    def on_demand_options(self) -> pulumi.Output[Optional['outputs.FleetOnDemandOptions']]:
        """
        Nested argument containing On-Demand configurations. Defined below.
        """
        return pulumi.get(self, "on_demand_options")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replaceUnhealthyInstances")
    def replace_unhealthy_instances(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
        """
        return pulumi.get(self, "replace_unhealthy_instances")

    @property
    @pulumi.getter(name="spotOptions")
    def spot_options(self) -> pulumi.Output[Optional['outputs.FleetSpotOptions']]:
        """
        Nested argument containing Spot configurations. Defined below.
        """
        return pulumi.get(self, "spot_options")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetCapacitySpecification")
    def target_capacity_specification(self) -> pulumi.Output['outputs.FleetTargetCapacitySpecification']:
        """
        Nested argument containing target capacity configurations. Defined below.
        """
        return pulumi.get(self, "target_capacity_specification")

    @property
    @pulumi.getter(name="terminateInstances")
    def terminate_instances(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instances")

    @property
    @pulumi.getter(name="terminateInstancesWithExpiration")
    def terminate_instances_with_expiration(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
        """
        return pulumi.get(self, "terminate_instances_with_expiration")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
        """
        return pulumi.get(self, "valid_until")

