# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlowLogArgs', 'FlowLog']

@pulumi.input_type
class FlowLogArgs:
    def __init__(__self__, *,
                 deliver_cross_account_role: Optional[pulumi.Input[builtins.str]] = None,
                 destination_options: Optional[pulumi.Input['FlowLogDestinationOptionsArgs']] = None,
                 eni_id: Optional[pulumi.Input[builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_format: Optional[pulumi.Input[builtins.str]] = None,
                 max_aggregation_interval: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 traffic_type: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FlowLog resource.
        :param pulumi.Input[builtins.str] deliver_cross_account_role: ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
        :param pulumi.Input['FlowLogDestinationOptionsArgs'] destination_options: Describes the destination options for a flow log. More details below.
        :param pulumi.Input[builtins.str] eni_id: Elastic Network Interface ID to attach to.
        :param pulumi.Input[builtins.str] iam_role_arn: ARN of the IAM role that's used to post flow logs to a CloudWatch Logs log group.
        :param pulumi.Input[builtins.str] log_destination: ARN of the logging destination.
        :param pulumi.Input[builtins.str] log_destination_type: Logging destination type. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
        :param pulumi.Input[builtins.str] log_format: The fields to include in the flow log record. Accepted format example: `"$${interface-id} $${srcaddr} $${dstaddr} $${srcport} $${dstport}"`.
        :param pulumi.Input[builtins.int] max_aggregation_interval: The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
               Valid Values: `60` seconds (1 minute) or `600` seconds (10 minutes). Default: `600`.
               When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] subnet_id: Subnet ID to attach to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** One of `eni_id`, `subnet_id`, `transit_gateway_id`, `transit_gateway_attachment_id`, or `vpc_id` must be specified.
        :param pulumi.Input[builtins.str] traffic_type: The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: Transit Gateway Attachment ID to attach to.
        :param pulumi.Input[builtins.str] transit_gateway_id: Transit Gateway ID to attach to.
        :param pulumi.Input[builtins.str] vpc_id: VPC ID to attach to.
        """
        if deliver_cross_account_role is not None:
            pulumi.set(__self__, "deliver_cross_account_role", deliver_cross_account_role)
        if destination_options is not None:
            pulumi.set(__self__, "destination_options", destination_options)
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if log_destination is not None:
            pulumi.set(__self__, "log_destination", log_destination)
        if log_destination_type is not None:
            pulumi.set(__self__, "log_destination_type", log_destination_type)
        if log_format is not None:
            pulumi.set(__self__, "log_format", log_format)
        if max_aggregation_interval is not None:
            pulumi.set(__self__, "max_aggregation_interval", max_aggregation_interval)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_type is not None:
            pulumi.set(__self__, "traffic_type", traffic_type)
        if transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transit_gateway_attachment_id", transit_gateway_attachment_id)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="deliverCrossAccountRole")
    def deliver_cross_account_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
        """
        return pulumi.get(self, "deliver_cross_account_role")

    @deliver_cross_account_role.setter
    def deliver_cross_account_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deliver_cross_account_role", value)

    @property
    @pulumi.getter(name="destinationOptions")
    def destination_options(self) -> Optional[pulumi.Input['FlowLogDestinationOptionsArgs']]:
        """
        Describes the destination options for a flow log. More details below.
        """
        return pulumi.get(self, "destination_options")

    @destination_options.setter
    def destination_options(self, value: Optional[pulumi.Input['FlowLogDestinationOptionsArgs']]):
        pulumi.set(self, "destination_options", value)

    @property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Elastic Network Interface ID to attach to.
        """
        return pulumi.get(self, "eni_id")

    @eni_id.setter
    def eni_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "eni_id", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM role that's used to post flow logs to a CloudWatch Logs log group.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the logging destination.
        """
        return pulumi.get(self, "log_destination")

    @log_destination.setter
    def log_destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_destination", value)

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Logging destination type. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
        """
        return pulumi.get(self, "log_destination_type")

    @log_destination_type.setter
    def log_destination_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_destination_type", value)

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fields to include in the flow log record. Accepted format example: `"$${interface-id} $${srcaddr} $${dstaddr} $${srcport} $${dstport}"`.
        """
        return pulumi.get(self, "log_format")

    @log_format.setter
    def log_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_format", value)

    @property
    @pulumi.getter(name="maxAggregationInterval")
    def max_aggregation_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
        Valid Values: `60` seconds (1 minute) or `600` seconds (10 minutes). Default: `600`.
        When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
        """
        return pulumi.get(self, "max_aggregation_interval")

    @max_aggregation_interval.setter
    def max_aggregation_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_aggregation_interval", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet ID to attach to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** One of `eni_id`, `subnet_id`, `transit_gateway_id`, `transit_gateway_attachment_id`, or `vpc_id` must be specified.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
        """
        return pulumi.get(self, "traffic_type")

    @traffic_type.setter
    def traffic_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traffic_type", value)

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Transit Gateway Attachment ID to attach to.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @transit_gateway_attachment_id.setter
    def transit_gateway_attachment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_attachment_id", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Transit Gateway ID to attach to.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        VPC ID to attach to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _FlowLogState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 deliver_cross_account_role: Optional[pulumi.Input[builtins.str]] = None,
                 destination_options: Optional[pulumi.Input['FlowLogDestinationOptionsArgs']] = None,
                 eni_id: Optional[pulumi.Input[builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_format: Optional[pulumi.Input[builtins.str]] = None,
                 max_aggregation_interval: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 traffic_type: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlowLog resources.
        :param pulumi.Input[builtins.str] arn: ARN of the Flow Log.
        :param pulumi.Input[builtins.str] deliver_cross_account_role: ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
        :param pulumi.Input['FlowLogDestinationOptionsArgs'] destination_options: Describes the destination options for a flow log. More details below.
        :param pulumi.Input[builtins.str] eni_id: Elastic Network Interface ID to attach to.
        :param pulumi.Input[builtins.str] iam_role_arn: ARN of the IAM role that's used to post flow logs to a CloudWatch Logs log group.
        :param pulumi.Input[builtins.str] log_destination: ARN of the logging destination.
        :param pulumi.Input[builtins.str] log_destination_type: Logging destination type. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
        :param pulumi.Input[builtins.str] log_format: The fields to include in the flow log record. Accepted format example: `"$${interface-id} $${srcaddr} $${dstaddr} $${srcport} $${dstport}"`.
        :param pulumi.Input[builtins.int] max_aggregation_interval: The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
               Valid Values: `60` seconds (1 minute) or `600` seconds (10 minutes). Default: `600`.
               When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] subnet_id: Subnet ID to attach to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** One of `eni_id`, `subnet_id`, `transit_gateway_id`, `transit_gateway_attachment_id`, or `vpc_id` must be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] traffic_type: The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: Transit Gateway Attachment ID to attach to.
        :param pulumi.Input[builtins.str] transit_gateway_id: Transit Gateway ID to attach to.
        :param pulumi.Input[builtins.str] vpc_id: VPC ID to attach to.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if deliver_cross_account_role is not None:
            pulumi.set(__self__, "deliver_cross_account_role", deliver_cross_account_role)
        if destination_options is not None:
            pulumi.set(__self__, "destination_options", destination_options)
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if log_destination is not None:
            pulumi.set(__self__, "log_destination", log_destination)
        if log_destination_type is not None:
            pulumi.set(__self__, "log_destination_type", log_destination_type)
        if log_format is not None:
            pulumi.set(__self__, "log_format", log_format)
        if max_aggregation_interval is not None:
            pulumi.set(__self__, "max_aggregation_interval", max_aggregation_interval)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if traffic_type is not None:
            pulumi.set(__self__, "traffic_type", traffic_type)
        if transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transit_gateway_attachment_id", transit_gateway_attachment_id)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Flow Log.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="deliverCrossAccountRole")
    def deliver_cross_account_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
        """
        return pulumi.get(self, "deliver_cross_account_role")

    @deliver_cross_account_role.setter
    def deliver_cross_account_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deliver_cross_account_role", value)

    @property
    @pulumi.getter(name="destinationOptions")
    def destination_options(self) -> Optional[pulumi.Input['FlowLogDestinationOptionsArgs']]:
        """
        Describes the destination options for a flow log. More details below.
        """
        return pulumi.get(self, "destination_options")

    @destination_options.setter
    def destination_options(self, value: Optional[pulumi.Input['FlowLogDestinationOptionsArgs']]):
        pulumi.set(self, "destination_options", value)

    @property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Elastic Network Interface ID to attach to.
        """
        return pulumi.get(self, "eni_id")

    @eni_id.setter
    def eni_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "eni_id", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM role that's used to post flow logs to a CloudWatch Logs log group.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the logging destination.
        """
        return pulumi.get(self, "log_destination")

    @log_destination.setter
    def log_destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_destination", value)

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Logging destination type. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
        """
        return pulumi.get(self, "log_destination_type")

    @log_destination_type.setter
    def log_destination_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_destination_type", value)

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fields to include in the flow log record. Accepted format example: `"$${interface-id} $${srcaddr} $${dstaddr} $${srcport} $${dstport}"`.
        """
        return pulumi.get(self, "log_format")

    @log_format.setter
    def log_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_format", value)

    @property
    @pulumi.getter(name="maxAggregationInterval")
    def max_aggregation_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
        Valid Values: `60` seconds (1 minute) or `600` seconds (10 minutes). Default: `600`.
        When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
        """
        return pulumi.get(self, "max_aggregation_interval")

    @max_aggregation_interval.setter
    def max_aggregation_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_aggregation_interval", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet ID to attach to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** One of `eni_id`, `subnet_id`, `transit_gateway_id`, `transit_gateway_attachment_id`, or `vpc_id` must be specified.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
        """
        return pulumi.get(self, "traffic_type")

    @traffic_type.setter
    def traffic_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traffic_type", value)

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Transit Gateway Attachment ID to attach to.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @transit_gateway_attachment_id.setter
    def transit_gateway_attachment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_attachment_id", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Transit Gateway ID to attach to.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        VPC ID to attach to.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws:ec2/flowLog:FlowLog")
class FlowLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deliver_cross_account_role: Optional[pulumi.Input[builtins.str]] = None,
                 destination_options: Optional[pulumi.Input[Union['FlowLogDestinationOptionsArgs', 'FlowLogDestinationOptionsArgsDict']]] = None,
                 eni_id: Optional[pulumi.Input[builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_format: Optional[pulumi.Input[builtins.str]] = None,
                 max_aggregation_interval: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 traffic_type: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC/Subnet/ENI/Transit Gateway/Transit Gateway Attachment Flow Log to capture IP traffic for a specific network
        interface, subnet, or VPC. Logs are sent to a CloudWatch Log Group, a S3 Bucket, or Amazon Kinesis Data Firehose

        ## Example Usage

        ### CloudWatch Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        example_log_group = aws.cloudwatch.LogGroup("example", name="example")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["vpc-flow-logs.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role.json)
        example_flow_log = aws.ec2.FlowLog("example",
            iam_role_arn=example_role.arn,
            log_destination=example_log_group.arn,
            traffic_type="ALL",
            vpc_id=example_aws_vpc["id"])
        example = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": [
                "logs:CreateLogGroup",
                "logs:CreateLogStream",
                "logs:PutLogEvents",
                "logs:DescribeLogGroups",
                "logs:DescribeLogStreams",
            ],
            "resources": ["*"],
        }])
        example_role_policy = aws.iam.RolePolicy("example",
            name="example",
            role=example_role.id,
            policy=example.json)
        ```

        ### S3 Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example", bucket="example")
        example = aws.ec2.FlowLog("example",
            log_destination=example_bucket.arn,
            log_destination_type="s3",
            traffic_type="ALL",
            vpc_id=example_aws_vpc["id"])
        ```

        ### S3 Logging in Apache Parquet format with per-hour partitions

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example", bucket="example")
        example = aws.ec2.FlowLog("example",
            log_destination=example_bucket.arn,
            log_destination_type="s3",
            traffic_type="ALL",
            vpc_id=example_aws_vpc["id"],
            destination_options={
                "file_format": "parquet",
                "per_hour_partition": True,
            })
        ```

        ## Import

        Using `pulumi import`, import Flow Logs using the `id`. For example:

        ```sh
        $ pulumi import aws:ec2/flowLog:FlowLog test_flow_log fl-1a2b3c4d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] deliver_cross_account_role: ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
        :param pulumi.Input[Union['FlowLogDestinationOptionsArgs', 'FlowLogDestinationOptionsArgsDict']] destination_options: Describes the destination options for a flow log. More details below.
        :param pulumi.Input[builtins.str] eni_id: Elastic Network Interface ID to attach to.
        :param pulumi.Input[builtins.str] iam_role_arn: ARN of the IAM role that's used to post flow logs to a CloudWatch Logs log group.
        :param pulumi.Input[builtins.str] log_destination: ARN of the logging destination.
        :param pulumi.Input[builtins.str] log_destination_type: Logging destination type. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
        :param pulumi.Input[builtins.str] log_format: The fields to include in the flow log record. Accepted format example: `"$${interface-id} $${srcaddr} $${dstaddr} $${srcport} $${dstport}"`.
        :param pulumi.Input[builtins.int] max_aggregation_interval: The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
               Valid Values: `60` seconds (1 minute) or `600` seconds (10 minutes). Default: `600`.
               When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] subnet_id: Subnet ID to attach to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** One of `eni_id`, `subnet_id`, `transit_gateway_id`, `transit_gateway_attachment_id`, or `vpc_id` must be specified.
        :param pulumi.Input[builtins.str] traffic_type: The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: Transit Gateway Attachment ID to attach to.
        :param pulumi.Input[builtins.str] transit_gateway_id: Transit Gateway ID to attach to.
        :param pulumi.Input[builtins.str] vpc_id: VPC ID to attach to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FlowLogArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC/Subnet/ENI/Transit Gateway/Transit Gateway Attachment Flow Log to capture IP traffic for a specific network
        interface, subnet, or VPC. Logs are sent to a CloudWatch Log Group, a S3 Bucket, or Amazon Kinesis Data Firehose

        ## Example Usage

        ### CloudWatch Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        example_log_group = aws.cloudwatch.LogGroup("example", name="example")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["vpc-flow-logs.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role.json)
        example_flow_log = aws.ec2.FlowLog("example",
            iam_role_arn=example_role.arn,
            log_destination=example_log_group.arn,
            traffic_type="ALL",
            vpc_id=example_aws_vpc["id"])
        example = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": [
                "logs:CreateLogGroup",
                "logs:CreateLogStream",
                "logs:PutLogEvents",
                "logs:DescribeLogGroups",
                "logs:DescribeLogStreams",
            ],
            "resources": ["*"],
        }])
        example_role_policy = aws.iam.RolePolicy("example",
            name="example",
            role=example_role.id,
            policy=example.json)
        ```

        ### S3 Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example", bucket="example")
        example = aws.ec2.FlowLog("example",
            log_destination=example_bucket.arn,
            log_destination_type="s3",
            traffic_type="ALL",
            vpc_id=example_aws_vpc["id"])
        ```

        ### S3 Logging in Apache Parquet format with per-hour partitions

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example", bucket="example")
        example = aws.ec2.FlowLog("example",
            log_destination=example_bucket.arn,
            log_destination_type="s3",
            traffic_type="ALL",
            vpc_id=example_aws_vpc["id"],
            destination_options={
                "file_format": "parquet",
                "per_hour_partition": True,
            })
        ```

        ## Import

        Using `pulumi import`, import Flow Logs using the `id`. For example:

        ```sh
        $ pulumi import aws:ec2/flowLog:FlowLog test_flow_log fl-1a2b3c4d
        ```

        :param str resource_name: The name of the resource.
        :param FlowLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deliver_cross_account_role: Optional[pulumi.Input[builtins.str]] = None,
                 destination_options: Optional[pulumi.Input[Union['FlowLogDestinationOptionsArgs', 'FlowLogDestinationOptionsArgsDict']]] = None,
                 eni_id: Optional[pulumi.Input[builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_format: Optional[pulumi.Input[builtins.str]] = None,
                 max_aggregation_interval: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 traffic_type: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowLogArgs.__new__(FlowLogArgs)

            __props__.__dict__["deliver_cross_account_role"] = deliver_cross_account_role
            __props__.__dict__["destination_options"] = destination_options
            __props__.__dict__["eni_id"] = eni_id
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["log_destination"] = log_destination
            __props__.__dict__["log_destination_type"] = log_destination_type
            __props__.__dict__["log_format"] = log_format
            __props__.__dict__["max_aggregation_interval"] = max_aggregation_interval
            __props__.__dict__["region"] = region
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["traffic_type"] = traffic_type
            __props__.__dict__["transit_gateway_attachment_id"] = transit_gateway_attachment_id
            __props__.__dict__["transit_gateway_id"] = transit_gateway_id
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(FlowLog, __self__).__init__(
            'aws:ec2/flowLog:FlowLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            deliver_cross_account_role: Optional[pulumi.Input[builtins.str]] = None,
            destination_options: Optional[pulumi.Input[Union['FlowLogDestinationOptionsArgs', 'FlowLogDestinationOptionsArgsDict']]] = None,
            eni_id: Optional[pulumi.Input[builtins.str]] = None,
            iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            log_destination: Optional[pulumi.Input[builtins.str]] = None,
            log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
            log_format: Optional[pulumi.Input[builtins.str]] = None,
            max_aggregation_interval: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            traffic_type: Optional[pulumi.Input[builtins.str]] = None,
            transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
            transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[builtins.str]] = None) -> 'FlowLog':
        """
        Get an existing FlowLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the Flow Log.
        :param pulumi.Input[builtins.str] deliver_cross_account_role: ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
        :param pulumi.Input[Union['FlowLogDestinationOptionsArgs', 'FlowLogDestinationOptionsArgsDict']] destination_options: Describes the destination options for a flow log. More details below.
        :param pulumi.Input[builtins.str] eni_id: Elastic Network Interface ID to attach to.
        :param pulumi.Input[builtins.str] iam_role_arn: ARN of the IAM role that's used to post flow logs to a CloudWatch Logs log group.
        :param pulumi.Input[builtins.str] log_destination: ARN of the logging destination.
        :param pulumi.Input[builtins.str] log_destination_type: Logging destination type. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
        :param pulumi.Input[builtins.str] log_format: The fields to include in the flow log record. Accepted format example: `"$${interface-id} $${srcaddr} $${dstaddr} $${srcport} $${dstport}"`.
        :param pulumi.Input[builtins.int] max_aggregation_interval: The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
               Valid Values: `60` seconds (1 minute) or `600` seconds (10 minutes). Default: `600`.
               When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] subnet_id: Subnet ID to attach to.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** One of `eni_id`, `subnet_id`, `transit_gateway_id`, `transit_gateway_attachment_id`, or `vpc_id` must be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] traffic_type: The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: Transit Gateway Attachment ID to attach to.
        :param pulumi.Input[builtins.str] transit_gateway_id: Transit Gateway ID to attach to.
        :param pulumi.Input[builtins.str] vpc_id: VPC ID to attach to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlowLogState.__new__(_FlowLogState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["deliver_cross_account_role"] = deliver_cross_account_role
        __props__.__dict__["destination_options"] = destination_options
        __props__.__dict__["eni_id"] = eni_id
        __props__.__dict__["iam_role_arn"] = iam_role_arn
        __props__.__dict__["log_destination"] = log_destination
        __props__.__dict__["log_destination_type"] = log_destination_type
        __props__.__dict__["log_format"] = log_format
        __props__.__dict__["max_aggregation_interval"] = max_aggregation_interval
        __props__.__dict__["region"] = region
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["traffic_type"] = traffic_type
        __props__.__dict__["transit_gateway_attachment_id"] = transit_gateway_attachment_id
        __props__.__dict__["transit_gateway_id"] = transit_gateway_id
        __props__.__dict__["vpc_id"] = vpc_id
        return FlowLog(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Flow Log.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deliverCrossAccountRole")
    def deliver_cross_account_role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
        """
        return pulumi.get(self, "deliver_cross_account_role")

    @property
    @pulumi.getter(name="destinationOptions")
    def destination_options(self) -> pulumi.Output[Optional['outputs.FlowLogDestinationOptions']]:
        """
        Describes the destination options for a flow log. More details below.
        """
        return pulumi.get(self, "destination_options")

    @property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Elastic Network Interface ID to attach to.
        """
        return pulumi.get(self, "eni_id")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the IAM role that's used to post flow logs to a CloudWatch Logs log group.
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the logging destination.
        """
        return pulumi.get(self, "log_destination")

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Logging destination type. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
        """
        return pulumi.get(self, "log_destination_type")

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> pulumi.Output[builtins.str]:
        """
        The fields to include in the flow log record. Accepted format example: `"$${interface-id} $${srcaddr} $${dstaddr} $${srcport} $${dstport}"`.
        """
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="maxAggregationInterval")
    def max_aggregation_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
        Valid Values: `60` seconds (1 minute) or `600` seconds (10 minutes). Default: `600`.
        When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
        """
        return pulumi.get(self, "max_aggregation_interval")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Subnet ID to attach to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** One of `eni_id`, `subnet_id`, `transit_gateway_id`, `transit_gateway_attachment_id`, or `vpc_id` must be specified.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
        """
        return pulumi.get(self, "traffic_type")

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Transit Gateway Attachment ID to attach to.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Transit Gateway ID to attach to.
        """
        return pulumi.get(self, "transit_gateway_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        VPC ID to attach to.
        """
        return pulumi.get(self, "vpc_id")

