# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAmiIdsResult',
    'AwaitableGetAmiIdsResult',
    'get_ami_ids',
    'get_ami_ids_output',
]

@pulumi.output_type
class GetAmiIdsResult:
    """
    A collection of values returned by getAmiIds.
    """
    def __init__(__self__, executable_users=None, filters=None, id=None, ids=None, include_deprecated=None, name_regex=None, owners=None, region=None, sort_ascending=None):
        if executable_users and not isinstance(executable_users, list):
            raise TypeError("Expected argument 'executable_users' to be a list")
        pulumi.set(__self__, "executable_users", executable_users)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if include_deprecated and not isinstance(include_deprecated, bool):
            raise TypeError("Expected argument 'include_deprecated' to be a bool")
        pulumi.set(__self__, "include_deprecated", include_deprecated)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if owners and not isinstance(owners, list):
            raise TypeError("Expected argument 'owners' to be a list")
        pulumi.set(__self__, "owners", owners)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if sort_ascending and not isinstance(sort_ascending, bool):
            raise TypeError("Expected argument 'sort_ascending' to be a bool")
        pulumi.set(__self__, "sort_ascending", sort_ascending)

    @property
    @pulumi.getter(name="executableUsers")
    def executable_users(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "executable_users")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAmiIdsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[builtins.str]:
        """
        is set to the list of AMI IDs, sorted by creation time according to `sort_ascending`.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="includeDeprecated")
    def include_deprecated(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "include_deprecated")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def owners(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "owners")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sortAscending")
    def sort_ascending(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "sort_ascending")


class AwaitableGetAmiIdsResult(GetAmiIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAmiIdsResult(
            executable_users=self.executable_users,
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            include_deprecated=self.include_deprecated,
            name_regex=self.name_regex,
            owners=self.owners,
            region=self.region,
            sort_ascending=self.sort_ascending)


def get_ami_ids(executable_users: Optional[Sequence[builtins.str]] = None,
                filters: Optional[Sequence[Union['GetAmiIdsFilterArgs', 'GetAmiIdsFilterArgsDict']]] = None,
                include_deprecated: Optional[builtins.bool] = None,
                name_regex: Optional[builtins.str] = None,
                owners: Optional[Sequence[builtins.str]] = None,
                region: Optional[builtins.str] = None,
                sort_ascending: Optional[builtins.bool] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAmiIdsResult:
    """
    Use this data source to get a list of AMI IDs matching the specified criteria.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    ubuntu = aws.ec2.get_ami_ids(owners=["099720109477"],
        filters=[{
            "name": "name",
            "values": ["ubuntu/images/ubuntu-*-*-amd64-server-*"],
        }])
    ```


    :param Sequence[builtins.str] executable_users: Limit search to users with *explicit* launch
           permission on  the image. Valid items are the numeric account ID or `self`.
    :param Sequence[Union['GetAmiIdsFilterArgs', 'GetAmiIdsFilterArgsDict']] filters: One or more name/value pairs to filter off of. There
           are several valid keys, for a full reference, check out
           [describe-images in the AWS CLI reference][1].
    :param builtins.bool include_deprecated: If true, all deprecated AMIs are included in the response.
           If false, no deprecated AMIs are included in the response. If no value is specified, the default value is `false`.
    :param builtins.str name_regex: Regex string to apply to the AMI list returned
           by AWS. This allows more advanced filtering not supported from the AWS API.
           This filtering is done locally on what AWS returns, and could have a performance
           impact if the result is large. Combine this with other
           options to narrow down the list AWS returns.
    :param Sequence[builtins.str] owners: List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.bool sort_ascending: Used to sort AMIs by creation time.
           If no value is specified, the default value is `false`.
    """
    __args__ = dict()
    __args__['executableUsers'] = executable_users
    __args__['filters'] = filters
    __args__['includeDeprecated'] = include_deprecated
    __args__['nameRegex'] = name_regex
    __args__['owners'] = owners
    __args__['region'] = region
    __args__['sortAscending'] = sort_ascending
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getAmiIds:getAmiIds', __args__, opts=opts, typ=GetAmiIdsResult).value

    return AwaitableGetAmiIdsResult(
        executable_users=pulumi.get(__ret__, 'executable_users'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        include_deprecated=pulumi.get(__ret__, 'include_deprecated'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        owners=pulumi.get(__ret__, 'owners'),
        region=pulumi.get(__ret__, 'region'),
        sort_ascending=pulumi.get(__ret__, 'sort_ascending'))
def get_ami_ids_output(executable_users: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAmiIdsFilterArgs', 'GetAmiIdsFilterArgsDict']]]]] = None,
                       include_deprecated: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                       name_regex: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       owners: Optional[pulumi.Input[Sequence[builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       sort_ascending: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAmiIdsResult]:
    """
    Use this data source to get a list of AMI IDs matching the specified criteria.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    ubuntu = aws.ec2.get_ami_ids(owners=["099720109477"],
        filters=[{
            "name": "name",
            "values": ["ubuntu/images/ubuntu-*-*-amd64-server-*"],
        }])
    ```


    :param Sequence[builtins.str] executable_users: Limit search to users with *explicit* launch
           permission on  the image. Valid items are the numeric account ID or `self`.
    :param Sequence[Union['GetAmiIdsFilterArgs', 'GetAmiIdsFilterArgsDict']] filters: One or more name/value pairs to filter off of. There
           are several valid keys, for a full reference, check out
           [describe-images in the AWS CLI reference][1].
    :param builtins.bool include_deprecated: If true, all deprecated AMIs are included in the response.
           If false, no deprecated AMIs are included in the response. If no value is specified, the default value is `false`.
    :param builtins.str name_regex: Regex string to apply to the AMI list returned
           by AWS. This allows more advanced filtering not supported from the AWS API.
           This filtering is done locally on what AWS returns, and could have a performance
           impact if the result is large. Combine this with other
           options to narrow down the list AWS returns.
    :param Sequence[builtins.str] owners: List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.bool sort_ascending: Used to sort AMIs by creation time.
           If no value is specified, the default value is `false`.
    """
    __args__ = dict()
    __args__['executableUsers'] = executable_users
    __args__['filters'] = filters
    __args__['includeDeprecated'] = include_deprecated
    __args__['nameRegex'] = name_regex
    __args__['owners'] = owners
    __args__['region'] = region
    __args__['sortAscending'] = sort_ascending
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getAmiIds:getAmiIds', __args__, opts=opts, typ=GetAmiIdsResult)
    return __ret__.apply(lambda __response__: GetAmiIdsResult(
        executable_users=pulumi.get(__response__, 'executable_users'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        include_deprecated=pulumi.get(__response__, 'include_deprecated'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        owners=pulumi.get(__response__, 'owners'),
        region=pulumi.get(__response__, 'region'),
        sort_ascending=pulumi.get(__response__, 'sort_ascending')))
