# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceTypeResult',
    'AwaitableGetInstanceTypeResult',
    'get_instance_type',
    'get_instance_type_output',
]

@pulumi.output_type
class GetInstanceTypeResult:
    """
    A collection of values returned by getInstanceType.
    """
    def __init__(__self__, auto_recovery_supported=None, bandwidth_weightings=None, bare_metal=None, boot_modes=None, burstable_performance_supported=None, current_generation=None, dedicated_hosts_supported=None, default_cores=None, default_network_card_index=None, default_threads_per_core=None, default_vcpus=None, ebs_encryption_support=None, ebs_nvme_support=None, ebs_optimized_support=None, ebs_performance_baseline_bandwidth=None, ebs_performance_baseline_iops=None, ebs_performance_baseline_throughput=None, ebs_performance_maximum_bandwidth=None, ebs_performance_maximum_iops=None, ebs_performance_maximum_throughput=None, efa_maximum_interfaces=None, efa_supported=None, ena_srd_supported=None, ena_support=None, encryption_in_transit_supported=None, fpgas=None, free_tier_eligible=None, gpuses=None, hibernation_supported=None, hypervisor=None, id=None, inference_accelerators=None, instance_disks=None, instance_storage_supported=None, instance_type=None, ipv6_supported=None, maximum_ipv4_addresses_per_interface=None, maximum_ipv6_addresses_per_interface=None, maximum_network_cards=None, maximum_network_interfaces=None, media_accelerators=None, memory_size=None, network_cards=None, network_performance=None, neuron_devices=None, nitro_enclaves_support=None, nitro_tpm_support=None, nitro_tpm_supported_versions=None, phc_support=None, region=None, supported_architectures=None, supported_cpu_features=None, supported_placement_strategies=None, supported_root_device_types=None, supported_usages_classes=None, supported_virtualization_types=None, sustained_clock_speed=None, total_fpga_memory=None, total_gpu_memory=None, total_inference_memory=None, total_instance_storage=None, total_media_memory=None, total_neuron_device_memory=None, valid_cores=None, valid_threads_per_cores=None):
        if auto_recovery_supported and not isinstance(auto_recovery_supported, bool):
            raise TypeError("Expected argument 'auto_recovery_supported' to be a bool")
        pulumi.set(__self__, "auto_recovery_supported", auto_recovery_supported)
        if bandwidth_weightings and not isinstance(bandwidth_weightings, list):
            raise TypeError("Expected argument 'bandwidth_weightings' to be a list")
        pulumi.set(__self__, "bandwidth_weightings", bandwidth_weightings)
        if bare_metal and not isinstance(bare_metal, bool):
            raise TypeError("Expected argument 'bare_metal' to be a bool")
        pulumi.set(__self__, "bare_metal", bare_metal)
        if boot_modes and not isinstance(boot_modes, list):
            raise TypeError("Expected argument 'boot_modes' to be a list")
        pulumi.set(__self__, "boot_modes", boot_modes)
        if burstable_performance_supported and not isinstance(burstable_performance_supported, bool):
            raise TypeError("Expected argument 'burstable_performance_supported' to be a bool")
        pulumi.set(__self__, "burstable_performance_supported", burstable_performance_supported)
        if current_generation and not isinstance(current_generation, bool):
            raise TypeError("Expected argument 'current_generation' to be a bool")
        pulumi.set(__self__, "current_generation", current_generation)
        if dedicated_hosts_supported and not isinstance(dedicated_hosts_supported, bool):
            raise TypeError("Expected argument 'dedicated_hosts_supported' to be a bool")
        pulumi.set(__self__, "dedicated_hosts_supported", dedicated_hosts_supported)
        if default_cores and not isinstance(default_cores, int):
            raise TypeError("Expected argument 'default_cores' to be a int")
        pulumi.set(__self__, "default_cores", default_cores)
        if default_network_card_index and not isinstance(default_network_card_index, int):
            raise TypeError("Expected argument 'default_network_card_index' to be a int")
        pulumi.set(__self__, "default_network_card_index", default_network_card_index)
        if default_threads_per_core and not isinstance(default_threads_per_core, int):
            raise TypeError("Expected argument 'default_threads_per_core' to be a int")
        pulumi.set(__self__, "default_threads_per_core", default_threads_per_core)
        if default_vcpus and not isinstance(default_vcpus, int):
            raise TypeError("Expected argument 'default_vcpus' to be a int")
        pulumi.set(__self__, "default_vcpus", default_vcpus)
        if ebs_encryption_support and not isinstance(ebs_encryption_support, str):
            raise TypeError("Expected argument 'ebs_encryption_support' to be a str")
        pulumi.set(__self__, "ebs_encryption_support", ebs_encryption_support)
        if ebs_nvme_support and not isinstance(ebs_nvme_support, str):
            raise TypeError("Expected argument 'ebs_nvme_support' to be a str")
        pulumi.set(__self__, "ebs_nvme_support", ebs_nvme_support)
        if ebs_optimized_support and not isinstance(ebs_optimized_support, str):
            raise TypeError("Expected argument 'ebs_optimized_support' to be a str")
        pulumi.set(__self__, "ebs_optimized_support", ebs_optimized_support)
        if ebs_performance_baseline_bandwidth and not isinstance(ebs_performance_baseline_bandwidth, int):
            raise TypeError("Expected argument 'ebs_performance_baseline_bandwidth' to be a int")
        pulumi.set(__self__, "ebs_performance_baseline_bandwidth", ebs_performance_baseline_bandwidth)
        if ebs_performance_baseline_iops and not isinstance(ebs_performance_baseline_iops, int):
            raise TypeError("Expected argument 'ebs_performance_baseline_iops' to be a int")
        pulumi.set(__self__, "ebs_performance_baseline_iops", ebs_performance_baseline_iops)
        if ebs_performance_baseline_throughput and not isinstance(ebs_performance_baseline_throughput, float):
            raise TypeError("Expected argument 'ebs_performance_baseline_throughput' to be a float")
        pulumi.set(__self__, "ebs_performance_baseline_throughput", ebs_performance_baseline_throughput)
        if ebs_performance_maximum_bandwidth and not isinstance(ebs_performance_maximum_bandwidth, int):
            raise TypeError("Expected argument 'ebs_performance_maximum_bandwidth' to be a int")
        pulumi.set(__self__, "ebs_performance_maximum_bandwidth", ebs_performance_maximum_bandwidth)
        if ebs_performance_maximum_iops and not isinstance(ebs_performance_maximum_iops, int):
            raise TypeError("Expected argument 'ebs_performance_maximum_iops' to be a int")
        pulumi.set(__self__, "ebs_performance_maximum_iops", ebs_performance_maximum_iops)
        if ebs_performance_maximum_throughput and not isinstance(ebs_performance_maximum_throughput, float):
            raise TypeError("Expected argument 'ebs_performance_maximum_throughput' to be a float")
        pulumi.set(__self__, "ebs_performance_maximum_throughput", ebs_performance_maximum_throughput)
        if efa_maximum_interfaces and not isinstance(efa_maximum_interfaces, int):
            raise TypeError("Expected argument 'efa_maximum_interfaces' to be a int")
        pulumi.set(__self__, "efa_maximum_interfaces", efa_maximum_interfaces)
        if efa_supported and not isinstance(efa_supported, bool):
            raise TypeError("Expected argument 'efa_supported' to be a bool")
        pulumi.set(__self__, "efa_supported", efa_supported)
        if ena_srd_supported and not isinstance(ena_srd_supported, bool):
            raise TypeError("Expected argument 'ena_srd_supported' to be a bool")
        pulumi.set(__self__, "ena_srd_supported", ena_srd_supported)
        if ena_support and not isinstance(ena_support, str):
            raise TypeError("Expected argument 'ena_support' to be a str")
        pulumi.set(__self__, "ena_support", ena_support)
        if encryption_in_transit_supported and not isinstance(encryption_in_transit_supported, bool):
            raise TypeError("Expected argument 'encryption_in_transit_supported' to be a bool")
        pulumi.set(__self__, "encryption_in_transit_supported", encryption_in_transit_supported)
        if fpgas and not isinstance(fpgas, list):
            raise TypeError("Expected argument 'fpgas' to be a list")
        pulumi.set(__self__, "fpgas", fpgas)
        if free_tier_eligible and not isinstance(free_tier_eligible, bool):
            raise TypeError("Expected argument 'free_tier_eligible' to be a bool")
        pulumi.set(__self__, "free_tier_eligible", free_tier_eligible)
        if gpuses and not isinstance(gpuses, list):
            raise TypeError("Expected argument 'gpuses' to be a list")
        pulumi.set(__self__, "gpuses", gpuses)
        if hibernation_supported and not isinstance(hibernation_supported, bool):
            raise TypeError("Expected argument 'hibernation_supported' to be a bool")
        pulumi.set(__self__, "hibernation_supported", hibernation_supported)
        if hypervisor and not isinstance(hypervisor, str):
            raise TypeError("Expected argument 'hypervisor' to be a str")
        pulumi.set(__self__, "hypervisor", hypervisor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inference_accelerators and not isinstance(inference_accelerators, list):
            raise TypeError("Expected argument 'inference_accelerators' to be a list")
        pulumi.set(__self__, "inference_accelerators", inference_accelerators)
        if instance_disks and not isinstance(instance_disks, list):
            raise TypeError("Expected argument 'instance_disks' to be a list")
        pulumi.set(__self__, "instance_disks", instance_disks)
        if instance_storage_supported and not isinstance(instance_storage_supported, bool):
            raise TypeError("Expected argument 'instance_storage_supported' to be a bool")
        pulumi.set(__self__, "instance_storage_supported", instance_storage_supported)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_supported and not isinstance(ipv6_supported, bool):
            raise TypeError("Expected argument 'ipv6_supported' to be a bool")
        pulumi.set(__self__, "ipv6_supported", ipv6_supported)
        if maximum_ipv4_addresses_per_interface and not isinstance(maximum_ipv4_addresses_per_interface, int):
            raise TypeError("Expected argument 'maximum_ipv4_addresses_per_interface' to be a int")
        pulumi.set(__self__, "maximum_ipv4_addresses_per_interface", maximum_ipv4_addresses_per_interface)
        if maximum_ipv6_addresses_per_interface and not isinstance(maximum_ipv6_addresses_per_interface, int):
            raise TypeError("Expected argument 'maximum_ipv6_addresses_per_interface' to be a int")
        pulumi.set(__self__, "maximum_ipv6_addresses_per_interface", maximum_ipv6_addresses_per_interface)
        if maximum_network_cards and not isinstance(maximum_network_cards, int):
            raise TypeError("Expected argument 'maximum_network_cards' to be a int")
        pulumi.set(__self__, "maximum_network_cards", maximum_network_cards)
        if maximum_network_interfaces and not isinstance(maximum_network_interfaces, int):
            raise TypeError("Expected argument 'maximum_network_interfaces' to be a int")
        pulumi.set(__self__, "maximum_network_interfaces", maximum_network_interfaces)
        if media_accelerators and not isinstance(media_accelerators, list):
            raise TypeError("Expected argument 'media_accelerators' to be a list")
        pulumi.set(__self__, "media_accelerators", media_accelerators)
        if memory_size and not isinstance(memory_size, int):
            raise TypeError("Expected argument 'memory_size' to be a int")
        pulumi.set(__self__, "memory_size", memory_size)
        if network_cards and not isinstance(network_cards, list):
            raise TypeError("Expected argument 'network_cards' to be a list")
        pulumi.set(__self__, "network_cards", network_cards)
        if network_performance and not isinstance(network_performance, str):
            raise TypeError("Expected argument 'network_performance' to be a str")
        pulumi.set(__self__, "network_performance", network_performance)
        if neuron_devices and not isinstance(neuron_devices, list):
            raise TypeError("Expected argument 'neuron_devices' to be a list")
        pulumi.set(__self__, "neuron_devices", neuron_devices)
        if nitro_enclaves_support and not isinstance(nitro_enclaves_support, str):
            raise TypeError("Expected argument 'nitro_enclaves_support' to be a str")
        pulumi.set(__self__, "nitro_enclaves_support", nitro_enclaves_support)
        if nitro_tpm_support and not isinstance(nitro_tpm_support, str):
            raise TypeError("Expected argument 'nitro_tpm_support' to be a str")
        pulumi.set(__self__, "nitro_tpm_support", nitro_tpm_support)
        if nitro_tpm_supported_versions and not isinstance(nitro_tpm_supported_versions, list):
            raise TypeError("Expected argument 'nitro_tpm_supported_versions' to be a list")
        pulumi.set(__self__, "nitro_tpm_supported_versions", nitro_tpm_supported_versions)
        if phc_support and not isinstance(phc_support, str):
            raise TypeError("Expected argument 'phc_support' to be a str")
        pulumi.set(__self__, "phc_support", phc_support)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if supported_architectures and not isinstance(supported_architectures, list):
            raise TypeError("Expected argument 'supported_architectures' to be a list")
        pulumi.set(__self__, "supported_architectures", supported_architectures)
        if supported_cpu_features and not isinstance(supported_cpu_features, list):
            raise TypeError("Expected argument 'supported_cpu_features' to be a list")
        pulumi.set(__self__, "supported_cpu_features", supported_cpu_features)
        if supported_placement_strategies and not isinstance(supported_placement_strategies, list):
            raise TypeError("Expected argument 'supported_placement_strategies' to be a list")
        pulumi.set(__self__, "supported_placement_strategies", supported_placement_strategies)
        if supported_root_device_types and not isinstance(supported_root_device_types, list):
            raise TypeError("Expected argument 'supported_root_device_types' to be a list")
        pulumi.set(__self__, "supported_root_device_types", supported_root_device_types)
        if supported_usages_classes and not isinstance(supported_usages_classes, list):
            raise TypeError("Expected argument 'supported_usages_classes' to be a list")
        pulumi.set(__self__, "supported_usages_classes", supported_usages_classes)
        if supported_virtualization_types and not isinstance(supported_virtualization_types, list):
            raise TypeError("Expected argument 'supported_virtualization_types' to be a list")
        pulumi.set(__self__, "supported_virtualization_types", supported_virtualization_types)
        if sustained_clock_speed and not isinstance(sustained_clock_speed, float):
            raise TypeError("Expected argument 'sustained_clock_speed' to be a float")
        pulumi.set(__self__, "sustained_clock_speed", sustained_clock_speed)
        if total_fpga_memory and not isinstance(total_fpga_memory, int):
            raise TypeError("Expected argument 'total_fpga_memory' to be a int")
        pulumi.set(__self__, "total_fpga_memory", total_fpga_memory)
        if total_gpu_memory and not isinstance(total_gpu_memory, int):
            raise TypeError("Expected argument 'total_gpu_memory' to be a int")
        pulumi.set(__self__, "total_gpu_memory", total_gpu_memory)
        if total_inference_memory and not isinstance(total_inference_memory, int):
            raise TypeError("Expected argument 'total_inference_memory' to be a int")
        pulumi.set(__self__, "total_inference_memory", total_inference_memory)
        if total_instance_storage and not isinstance(total_instance_storage, int):
            raise TypeError("Expected argument 'total_instance_storage' to be a int")
        pulumi.set(__self__, "total_instance_storage", total_instance_storage)
        if total_media_memory and not isinstance(total_media_memory, int):
            raise TypeError("Expected argument 'total_media_memory' to be a int")
        pulumi.set(__self__, "total_media_memory", total_media_memory)
        if total_neuron_device_memory and not isinstance(total_neuron_device_memory, int):
            raise TypeError("Expected argument 'total_neuron_device_memory' to be a int")
        pulumi.set(__self__, "total_neuron_device_memory", total_neuron_device_memory)
        if valid_cores and not isinstance(valid_cores, list):
            raise TypeError("Expected argument 'valid_cores' to be a list")
        pulumi.set(__self__, "valid_cores", valid_cores)
        if valid_threads_per_cores and not isinstance(valid_threads_per_cores, list):
            raise TypeError("Expected argument 'valid_threads_per_cores' to be a list")
        pulumi.set(__self__, "valid_threads_per_cores", valid_threads_per_cores)

    @property
    @pulumi.getter(name="autoRecoverySupported")
    def auto_recovery_supported(self) -> builtins.bool:
        """
        `true` if auto recovery is supported.
        """
        return pulumi.get(self, "auto_recovery_supported")

    @property
    @pulumi.getter(name="bandwidthWeightings")
    def bandwidth_weightings(self) -> Sequence[builtins.str]:
        """
        A set of strings of valid settings for [configurable bandwidth weighting](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-bandwidth-weighting.html), if supported.
        """
        return pulumi.get(self, "bandwidth_weightings")

    @property
    @pulumi.getter(name="bareMetal")
    def bare_metal(self) -> builtins.bool:
        """
        `true` if it is a bare metal instance type.
        """
        return pulumi.get(self, "bare_metal")

    @property
    @pulumi.getter(name="bootModes")
    def boot_modes(self) -> Sequence[builtins.str]:
        """
        A set of strings of supported boot modes.
        """
        return pulumi.get(self, "boot_modes")

    @property
    @pulumi.getter(name="burstablePerformanceSupported")
    def burstable_performance_supported(self) -> builtins.bool:
        """
        `true` if the instance type is a burstable performance instance type.
        """
        return pulumi.get(self, "burstable_performance_supported")

    @property
    @pulumi.getter(name="currentGeneration")
    def current_generation(self) -> builtins.bool:
        """
        `true`  if the instance type is a current generation.
        """
        return pulumi.get(self, "current_generation")

    @property
    @pulumi.getter(name="dedicatedHostsSupported")
    def dedicated_hosts_supported(self) -> builtins.bool:
        """
        `true` if Dedicated Hosts are supported on the instance type.
        """
        return pulumi.get(self, "dedicated_hosts_supported")

    @property
    @pulumi.getter(name="defaultCores")
    def default_cores(self) -> builtins.int:
        """
        Default number of cores for the instance type.
        """
        return pulumi.get(self, "default_cores")

    @property
    @pulumi.getter(name="defaultNetworkCardIndex")
    def default_network_card_index(self) -> builtins.int:
        """
        The index of the default network card, starting at `0`.
        """
        return pulumi.get(self, "default_network_card_index")

    @property
    @pulumi.getter(name="defaultThreadsPerCore")
    def default_threads_per_core(self) -> builtins.int:
        """
        The  default  number of threads per core for the instance type.
        """
        return pulumi.get(self, "default_threads_per_core")

    @property
    @pulumi.getter(name="defaultVcpus")
    def default_vcpus(self) -> builtins.int:
        """
        Default number of vCPUs for the instance type.
        """
        return pulumi.get(self, "default_vcpus")

    @property
    @pulumi.getter(name="ebsEncryptionSupport")
    def ebs_encryption_support(self) -> builtins.str:
        """
        Indicates whether Amazon EBS encryption is supported.
        """
        return pulumi.get(self, "ebs_encryption_support")

    @property
    @pulumi.getter(name="ebsNvmeSupport")
    def ebs_nvme_support(self) -> builtins.str:
        """
        Whether non-volatile memory express (NVMe) is supported.
        """
        return pulumi.get(self, "ebs_nvme_support")

    @property
    @pulumi.getter(name="ebsOptimizedSupport")
    def ebs_optimized_support(self) -> builtins.str:
        """
        Indicates that the instance type is Amazon EBS-optimized.
        """
        return pulumi.get(self, "ebs_optimized_support")

    @property
    @pulumi.getter(name="ebsPerformanceBaselineBandwidth")
    def ebs_performance_baseline_bandwidth(self) -> builtins.int:
        """
        The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
        """
        return pulumi.get(self, "ebs_performance_baseline_bandwidth")

    @property
    @pulumi.getter(name="ebsPerformanceBaselineIops")
    def ebs_performance_baseline_iops(self) -> builtins.int:
        """
        The baseline input/output storage operations per seconds for an EBS-optimized instance type.
        """
        return pulumi.get(self, "ebs_performance_baseline_iops")

    @property
    @pulumi.getter(name="ebsPerformanceBaselineThroughput")
    def ebs_performance_baseline_throughput(self) -> builtins.float:
        """
        The baseline throughput performance for an EBS-optimized instance type, in MBps.
        """
        return pulumi.get(self, "ebs_performance_baseline_throughput")

    @property
    @pulumi.getter(name="ebsPerformanceMaximumBandwidth")
    def ebs_performance_maximum_bandwidth(self) -> builtins.int:
        """
        The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
        """
        return pulumi.get(self, "ebs_performance_maximum_bandwidth")

    @property
    @pulumi.getter(name="ebsPerformanceMaximumIops")
    def ebs_performance_maximum_iops(self) -> builtins.int:
        """
        The maximum input/output storage operations per second for an EBS-optimized instance type.
        """
        return pulumi.get(self, "ebs_performance_maximum_iops")

    @property
    @pulumi.getter(name="ebsPerformanceMaximumThroughput")
    def ebs_performance_maximum_throughput(self) -> builtins.float:
        """
        The maximum throughput performance for an EBS-optimized instance type, in MBps.
        """
        return pulumi.get(self, "ebs_performance_maximum_throughput")

    @property
    @pulumi.getter(name="efaMaximumInterfaces")
    def efa_maximum_interfaces(self) -> builtins.int:
        """
        The maximum number of Elastic Fabric Adapters for the instance type.
        """
        return pulumi.get(self, "efa_maximum_interfaces")

    @property
    @pulumi.getter(name="efaSupported")
    def efa_supported(self) -> builtins.bool:
        """
        `true` if Elastic Fabric Adapter (EFA) is supported.
        """
        return pulumi.get(self, "efa_supported")

    @property
    @pulumi.getter(name="enaSrdSupported")
    def ena_srd_supported(self) -> builtins.bool:
        """
        `true` if the instance type supports [ENA Express](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ena-express.html).
        """
        return pulumi.get(self, "ena_srd_supported")

    @property
    @pulumi.getter(name="enaSupport")
    def ena_support(self) -> builtins.str:
        """
        Indicates whether Elastic Network Adapter (ENA) is `"supported"`, `"required"`, or `"unsupported"`.
        """
        return pulumi.get(self, "ena_support")

    @property
    @pulumi.getter(name="encryptionInTransitSupported")
    def encryption_in_transit_supported(self) -> builtins.bool:
        """
        `true` if encryption in-transit between instances is supported.
        """
        return pulumi.get(self, "encryption_in_transit_supported")

    @property
    @pulumi.getter
    def fpgas(self) -> Sequence['outputs.GetInstanceTypeFpgaResult']:
        """
        Describes the FPGA accelerator settings for the instance type.
        * `fpgas.#.count` - The count of FPGA accelerators for the instance type.
        * `fpgas.#.manufacturer` - The manufacturer of the FPGA accelerator.
        * `fpgas.#.memory_size` - The size (in MiB) of the memory available to the FPGA accelerator.
        * `fpgas.#.name` - The name of the FPGA accelerator.
        """
        return pulumi.get(self, "fpgas")

    @property
    @pulumi.getter(name="freeTierEligible")
    def free_tier_eligible(self) -> builtins.bool:
        """
        `true` if the instance type is eligible for the free tier.
        """
        return pulumi.get(self, "free_tier_eligible")

    @property
    @pulumi.getter
    def gpuses(self) -> Sequence['outputs.GetInstanceTypeGpusResult']:
        """
        Describes the GPU accelerators for the instance type.
        * `gpus.#.count` - The number of GPUs for the instance type.
        * `gpus.#.manufacturer` - The manufacturer of the GPU accelerator.
        * `gpus.#.memory_size` - The size (in MiB) of the memory available to the GPU accelerator.
        * `gpus.#.name` - The name of the GPU accelerator.
        """
        return pulumi.get(self, "gpuses")

    @property
    @pulumi.getter(name="hibernationSupported")
    def hibernation_supported(self) -> builtins.bool:
        """
        `true` if On-Demand hibernation is supported.
        """
        return pulumi.get(self, "hibernation_supported")

    @property
    @pulumi.getter
    def hypervisor(self) -> builtins.str:
        """
        Hypervisor used for the instance type.
        """
        return pulumi.get(self, "hypervisor")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inferenceAccelerators")
    def inference_accelerators(self) -> Sequence['outputs.GetInstanceTypeInferenceAcceleratorResult']:
        """
        Describes the Inference accelerators for the instance type.
        * `inference_accelerators.#.count` - The number of Inference accelerators for the instance type.
        * `inference_accelerators.#.manufacturer` - The manufacturer of the Inference accelerator.
        * `inference_accelerators.#.memory_size` - The size (in MiB) of the memory available to the inference accelerator.
        * `inference_accelerators.#.name` - The name of the Inference accelerator.
        """
        return pulumi.get(self, "inference_accelerators")

    @property
    @pulumi.getter(name="instanceDisks")
    def instance_disks(self) -> Sequence['outputs.GetInstanceTypeInstanceDiskResult']:
        """
        Describes the disks for the instance type.
        * `instance_disks.#.count` - The number of disks with this configuration.
        * `instance_disks.#.size` - The size of the disk in GB.
        * `instance_disks.#.type` - The type of disk.
        """
        return pulumi.get(self, "instance_disks")

    @property
    @pulumi.getter(name="instanceStorageSupported")
    def instance_storage_supported(self) -> builtins.bool:
        """
        `true` if instance storage is supported.
        """
        return pulumi.get(self, "instance_storage_supported")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipv6Supported")
    def ipv6_supported(self) -> builtins.bool:
        """
        `true` if IPv6 is supported.
        """
        return pulumi.get(self, "ipv6_supported")

    @property
    @pulumi.getter(name="maximumIpv4AddressesPerInterface")
    def maximum_ipv4_addresses_per_interface(self) -> builtins.int:
        """
        The maximum number of IPv4 addresses per network interface.
        """
        return pulumi.get(self, "maximum_ipv4_addresses_per_interface")

    @property
    @pulumi.getter(name="maximumIpv6AddressesPerInterface")
    def maximum_ipv6_addresses_per_interface(self) -> builtins.int:
        """
        The maximum number of IPv6 addresses per network interface.
        """
        return pulumi.get(self, "maximum_ipv6_addresses_per_interface")

    @property
    @pulumi.getter(name="maximumNetworkCards")
    def maximum_network_cards(self) -> builtins.int:
        """
        The maximum number of physical network cards that can be allocated to the instance.
        """
        return pulumi.get(self, "maximum_network_cards")

    @property
    @pulumi.getter(name="maximumNetworkInterfaces")
    def maximum_network_interfaces(self) -> builtins.int:
        """
        The maximum number of network interfaces for the instance type.
        """
        return pulumi.get(self, "maximum_network_interfaces")

    @property
    @pulumi.getter(name="mediaAccelerators")
    def media_accelerators(self) -> Sequence['outputs.GetInstanceTypeMediaAcceleratorResult']:
        """
        Describes the media accelerator settings for the instance type.
        * `media_accelerators.#.count` - The number of media accelerators for the instance type.
        * `media_accelerators.#.manufacturer` - The manufacturer of the media accelerator.
        * `media_accelerators.#.memory_size` - The size (in MiB) of the memory available to each media accelerator.
        * `media_accelerators.#.name` - The name of the media accelerator.
        """
        return pulumi.get(self, "media_accelerators")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> builtins.int:
        """
        Size of the instance memory, in MiB.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter(name="networkCards")
    def network_cards(self) -> Sequence['outputs.GetInstanceTypeNetworkCardResult']:
        """
        Describes the network cards for the instance type.
        * `network_cards.#.baseline_bandwidth` - The baseline network performance (in Gbps) of the network card.
        * `network_cards.#.index` - The index of the network card.
        * `network_cards.#.maximum_interfaces` - The maximum number of network interfaces for the /network card.
        * `network_cards.#.performance` - Describes the network performance of the network card.
        * `network_cards.#.peak_bandwidth` - The peak (burst) network performance (in Gbps) of the network card.
        """
        return pulumi.get(self, "network_cards")

    @property
    @pulumi.getter(name="networkPerformance")
    def network_performance(self) -> builtins.str:
        """
        Describes the network performance.
        """
        return pulumi.get(self, "network_performance")

    @property
    @pulumi.getter(name="neuronDevices")
    def neuron_devices(self) -> Sequence['outputs.GetInstanceTypeNeuronDeviceResult']:
        """
        Describes the Neuron accelerator settings for the instance type.
        * `neuron_devices.#.core_count` - The number of cores available to the neuron accelerator.
        * `neuron_devices.#.core_version` - A number representing the version of the neuron accelerator.
        * `neuron_devices.#.count` - The number of neuron accelerators for the instance type.
        * `neuron_devices.#.memory_size` - The size (in MiB) of the memory available to the neuron accelerator.
        * `neuron_devices.#.name` - The name of the neuron accelerator.
        """
        return pulumi.get(self, "neuron_devices")

    @property
    @pulumi.getter(name="nitroEnclavesSupport")
    def nitro_enclaves_support(self) -> builtins.str:
        """
        Indicates whether Nitro Enclaves is `"supported"` or `"unsupported"`.
        """
        return pulumi.get(self, "nitro_enclaves_support")

    @property
    @pulumi.getter(name="nitroTpmSupport")
    def nitro_tpm_support(self) -> builtins.str:
        """
        Indicates whether NitroTPM is `"supported"` or `"unsupported"`.
        """
        return pulumi.get(self, "nitro_tpm_support")

    @property
    @pulumi.getter(name="nitroTpmSupportedVersions")
    def nitro_tpm_supported_versions(self) -> Sequence[builtins.str]:
        """
        A set of strings indicating the supported NitroTPM versions.
        """
        return pulumi.get(self, "nitro_tpm_supported_versions")

    @property
    @pulumi.getter(name="phcSupport")
    def phc_support(self) -> builtins.str:
        """
        `true` if a local Precision Time Protocol (PTP) hardware clock (PHC) is supported.
        """
        return pulumi.get(self, "phc_support")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="supportedArchitectures")
    def supported_architectures(self) -> Sequence[builtins.str]:
        """
        A list of strings of architectures supported by the instance type.
        """
        return pulumi.get(self, "supported_architectures")

    @property
    @pulumi.getter(name="supportedCpuFeatures")
    def supported_cpu_features(self) -> Sequence[builtins.str]:
        """
        A set of strings indicating supported CPU features.
        """
        return pulumi.get(self, "supported_cpu_features")

    @property
    @pulumi.getter(name="supportedPlacementStrategies")
    def supported_placement_strategies(self) -> Sequence[builtins.str]:
        """
        A list of supported placement groups types.
        """
        return pulumi.get(self, "supported_placement_strategies")

    @property
    @pulumi.getter(name="supportedRootDeviceTypes")
    def supported_root_device_types(self) -> Sequence[builtins.str]:
        """
        A list of supported root device types.
        """
        return pulumi.get(self, "supported_root_device_types")

    @property
    @pulumi.getter(name="supportedUsagesClasses")
    def supported_usages_classes(self) -> Sequence[builtins.str]:
        """
        A list of supported usage classes.  Usage classes are `"spot"`, `"on-demand"`, or `"capacity-block"`.
        """
        return pulumi.get(self, "supported_usages_classes")

    @property
    @pulumi.getter(name="supportedVirtualizationTypes")
    def supported_virtualization_types(self) -> Sequence[builtins.str]:
        """
        The supported virtualization types.
        """
        return pulumi.get(self, "supported_virtualization_types")

    @property
    @pulumi.getter(name="sustainedClockSpeed")
    def sustained_clock_speed(self) -> builtins.float:
        """
        The speed of the processor, in GHz.
        """
        return pulumi.get(self, "sustained_clock_speed")

    @property
    @pulumi.getter(name="totalFpgaMemory")
    def total_fpga_memory(self) -> builtins.int:
        """
        Total memory of all FPGA accelerators for the instance type (in MiB).
        """
        return pulumi.get(self, "total_fpga_memory")

    @property
    @pulumi.getter(name="totalGpuMemory")
    def total_gpu_memory(self) -> builtins.int:
        """
        Total size of the memory for the GPU accelerators for the instance type (in MiB).
        """
        return pulumi.get(self, "total_gpu_memory")

    @property
    @pulumi.getter(name="totalInferenceMemory")
    def total_inference_memory(self) -> builtins.int:
        """
        The total size of the memory for the neuron accelerators for the instance type (in MiB).
        """
        return pulumi.get(self, "total_inference_memory")

    @property
    @pulumi.getter(name="totalInstanceStorage")
    def total_instance_storage(self) -> builtins.int:
        """
        The total size of the instance disks, in GB.
        """
        return pulumi.get(self, "total_instance_storage")

    @property
    @pulumi.getter(name="totalMediaMemory")
    def total_media_memory(self) -> builtins.int:
        """
        The total size of the memory for the media accelerators for the instance type (in MiB).
        """
        return pulumi.get(self, "total_media_memory")

    @property
    @pulumi.getter(name="totalNeuronDeviceMemory")
    def total_neuron_device_memory(self) -> builtins.int:
        """
        The total size of the memory for the neuron accelerators for the instance type (in MiB).
        """
        return pulumi.get(self, "total_neuron_device_memory")

    @property
    @pulumi.getter(name="validCores")
    def valid_cores(self) -> Sequence[builtins.int]:
        """
        List of the valid number of cores that can be configured for the instance type.
        """
        return pulumi.get(self, "valid_cores")

    @property
    @pulumi.getter(name="validThreadsPerCores")
    def valid_threads_per_cores(self) -> Sequence[builtins.int]:
        """
        List of the valid number of threads per core that can be configured for the instance type.
        """
        return pulumi.get(self, "valid_threads_per_cores")


class AwaitableGetInstanceTypeResult(GetInstanceTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceTypeResult(
            auto_recovery_supported=self.auto_recovery_supported,
            bandwidth_weightings=self.bandwidth_weightings,
            bare_metal=self.bare_metal,
            boot_modes=self.boot_modes,
            burstable_performance_supported=self.burstable_performance_supported,
            current_generation=self.current_generation,
            dedicated_hosts_supported=self.dedicated_hosts_supported,
            default_cores=self.default_cores,
            default_network_card_index=self.default_network_card_index,
            default_threads_per_core=self.default_threads_per_core,
            default_vcpus=self.default_vcpus,
            ebs_encryption_support=self.ebs_encryption_support,
            ebs_nvme_support=self.ebs_nvme_support,
            ebs_optimized_support=self.ebs_optimized_support,
            ebs_performance_baseline_bandwidth=self.ebs_performance_baseline_bandwidth,
            ebs_performance_baseline_iops=self.ebs_performance_baseline_iops,
            ebs_performance_baseline_throughput=self.ebs_performance_baseline_throughput,
            ebs_performance_maximum_bandwidth=self.ebs_performance_maximum_bandwidth,
            ebs_performance_maximum_iops=self.ebs_performance_maximum_iops,
            ebs_performance_maximum_throughput=self.ebs_performance_maximum_throughput,
            efa_maximum_interfaces=self.efa_maximum_interfaces,
            efa_supported=self.efa_supported,
            ena_srd_supported=self.ena_srd_supported,
            ena_support=self.ena_support,
            encryption_in_transit_supported=self.encryption_in_transit_supported,
            fpgas=self.fpgas,
            free_tier_eligible=self.free_tier_eligible,
            gpuses=self.gpuses,
            hibernation_supported=self.hibernation_supported,
            hypervisor=self.hypervisor,
            id=self.id,
            inference_accelerators=self.inference_accelerators,
            instance_disks=self.instance_disks,
            instance_storage_supported=self.instance_storage_supported,
            instance_type=self.instance_type,
            ipv6_supported=self.ipv6_supported,
            maximum_ipv4_addresses_per_interface=self.maximum_ipv4_addresses_per_interface,
            maximum_ipv6_addresses_per_interface=self.maximum_ipv6_addresses_per_interface,
            maximum_network_cards=self.maximum_network_cards,
            maximum_network_interfaces=self.maximum_network_interfaces,
            media_accelerators=self.media_accelerators,
            memory_size=self.memory_size,
            network_cards=self.network_cards,
            network_performance=self.network_performance,
            neuron_devices=self.neuron_devices,
            nitro_enclaves_support=self.nitro_enclaves_support,
            nitro_tpm_support=self.nitro_tpm_support,
            nitro_tpm_supported_versions=self.nitro_tpm_supported_versions,
            phc_support=self.phc_support,
            region=self.region,
            supported_architectures=self.supported_architectures,
            supported_cpu_features=self.supported_cpu_features,
            supported_placement_strategies=self.supported_placement_strategies,
            supported_root_device_types=self.supported_root_device_types,
            supported_usages_classes=self.supported_usages_classes,
            supported_virtualization_types=self.supported_virtualization_types,
            sustained_clock_speed=self.sustained_clock_speed,
            total_fpga_memory=self.total_fpga_memory,
            total_gpu_memory=self.total_gpu_memory,
            total_inference_memory=self.total_inference_memory,
            total_instance_storage=self.total_instance_storage,
            total_media_memory=self.total_media_memory,
            total_neuron_device_memory=self.total_neuron_device_memory,
            valid_cores=self.valid_cores,
            valid_threads_per_cores=self.valid_threads_per_cores)


def get_instance_type(instance_type: Optional[builtins.str] = None,
                      region: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceTypeResult:
    """
    Get characteristics for a single EC2 Instance Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_instance_type(instance_type="t2.micro")
    ```


    :param builtins.str instance_type: Instance
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['instanceType'] = instance_type
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getInstanceType:getInstanceType', __args__, opts=opts, typ=GetInstanceTypeResult).value

    return AwaitableGetInstanceTypeResult(
        auto_recovery_supported=pulumi.get(__ret__, 'auto_recovery_supported'),
        bandwidth_weightings=pulumi.get(__ret__, 'bandwidth_weightings'),
        bare_metal=pulumi.get(__ret__, 'bare_metal'),
        boot_modes=pulumi.get(__ret__, 'boot_modes'),
        burstable_performance_supported=pulumi.get(__ret__, 'burstable_performance_supported'),
        current_generation=pulumi.get(__ret__, 'current_generation'),
        dedicated_hosts_supported=pulumi.get(__ret__, 'dedicated_hosts_supported'),
        default_cores=pulumi.get(__ret__, 'default_cores'),
        default_network_card_index=pulumi.get(__ret__, 'default_network_card_index'),
        default_threads_per_core=pulumi.get(__ret__, 'default_threads_per_core'),
        default_vcpus=pulumi.get(__ret__, 'default_vcpus'),
        ebs_encryption_support=pulumi.get(__ret__, 'ebs_encryption_support'),
        ebs_nvme_support=pulumi.get(__ret__, 'ebs_nvme_support'),
        ebs_optimized_support=pulumi.get(__ret__, 'ebs_optimized_support'),
        ebs_performance_baseline_bandwidth=pulumi.get(__ret__, 'ebs_performance_baseline_bandwidth'),
        ebs_performance_baseline_iops=pulumi.get(__ret__, 'ebs_performance_baseline_iops'),
        ebs_performance_baseline_throughput=pulumi.get(__ret__, 'ebs_performance_baseline_throughput'),
        ebs_performance_maximum_bandwidth=pulumi.get(__ret__, 'ebs_performance_maximum_bandwidth'),
        ebs_performance_maximum_iops=pulumi.get(__ret__, 'ebs_performance_maximum_iops'),
        ebs_performance_maximum_throughput=pulumi.get(__ret__, 'ebs_performance_maximum_throughput'),
        efa_maximum_interfaces=pulumi.get(__ret__, 'efa_maximum_interfaces'),
        efa_supported=pulumi.get(__ret__, 'efa_supported'),
        ena_srd_supported=pulumi.get(__ret__, 'ena_srd_supported'),
        ena_support=pulumi.get(__ret__, 'ena_support'),
        encryption_in_transit_supported=pulumi.get(__ret__, 'encryption_in_transit_supported'),
        fpgas=pulumi.get(__ret__, 'fpgas'),
        free_tier_eligible=pulumi.get(__ret__, 'free_tier_eligible'),
        gpuses=pulumi.get(__ret__, 'gpuses'),
        hibernation_supported=pulumi.get(__ret__, 'hibernation_supported'),
        hypervisor=pulumi.get(__ret__, 'hypervisor'),
        id=pulumi.get(__ret__, 'id'),
        inference_accelerators=pulumi.get(__ret__, 'inference_accelerators'),
        instance_disks=pulumi.get(__ret__, 'instance_disks'),
        instance_storage_supported=pulumi.get(__ret__, 'instance_storage_supported'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        ipv6_supported=pulumi.get(__ret__, 'ipv6_supported'),
        maximum_ipv4_addresses_per_interface=pulumi.get(__ret__, 'maximum_ipv4_addresses_per_interface'),
        maximum_ipv6_addresses_per_interface=pulumi.get(__ret__, 'maximum_ipv6_addresses_per_interface'),
        maximum_network_cards=pulumi.get(__ret__, 'maximum_network_cards'),
        maximum_network_interfaces=pulumi.get(__ret__, 'maximum_network_interfaces'),
        media_accelerators=pulumi.get(__ret__, 'media_accelerators'),
        memory_size=pulumi.get(__ret__, 'memory_size'),
        network_cards=pulumi.get(__ret__, 'network_cards'),
        network_performance=pulumi.get(__ret__, 'network_performance'),
        neuron_devices=pulumi.get(__ret__, 'neuron_devices'),
        nitro_enclaves_support=pulumi.get(__ret__, 'nitro_enclaves_support'),
        nitro_tpm_support=pulumi.get(__ret__, 'nitro_tpm_support'),
        nitro_tpm_supported_versions=pulumi.get(__ret__, 'nitro_tpm_supported_versions'),
        phc_support=pulumi.get(__ret__, 'phc_support'),
        region=pulumi.get(__ret__, 'region'),
        supported_architectures=pulumi.get(__ret__, 'supported_architectures'),
        supported_cpu_features=pulumi.get(__ret__, 'supported_cpu_features'),
        supported_placement_strategies=pulumi.get(__ret__, 'supported_placement_strategies'),
        supported_root_device_types=pulumi.get(__ret__, 'supported_root_device_types'),
        supported_usages_classes=pulumi.get(__ret__, 'supported_usages_classes'),
        supported_virtualization_types=pulumi.get(__ret__, 'supported_virtualization_types'),
        sustained_clock_speed=pulumi.get(__ret__, 'sustained_clock_speed'),
        total_fpga_memory=pulumi.get(__ret__, 'total_fpga_memory'),
        total_gpu_memory=pulumi.get(__ret__, 'total_gpu_memory'),
        total_inference_memory=pulumi.get(__ret__, 'total_inference_memory'),
        total_instance_storage=pulumi.get(__ret__, 'total_instance_storage'),
        total_media_memory=pulumi.get(__ret__, 'total_media_memory'),
        total_neuron_device_memory=pulumi.get(__ret__, 'total_neuron_device_memory'),
        valid_cores=pulumi.get(__ret__, 'valid_cores'),
        valid_threads_per_cores=pulumi.get(__ret__, 'valid_threads_per_cores'))
def get_instance_type_output(instance_type: Optional[pulumi.Input[builtins.str]] = None,
                             region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceTypeResult]:
    """
    Get characteristics for a single EC2 Instance Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_instance_type(instance_type="t2.micro")
    ```


    :param builtins.str instance_type: Instance
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['instanceType'] = instance_type
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getInstanceType:getInstanceType', __args__, opts=opts, typ=GetInstanceTypeResult)
    return __ret__.apply(lambda __response__: GetInstanceTypeResult(
        auto_recovery_supported=pulumi.get(__response__, 'auto_recovery_supported'),
        bandwidth_weightings=pulumi.get(__response__, 'bandwidth_weightings'),
        bare_metal=pulumi.get(__response__, 'bare_metal'),
        boot_modes=pulumi.get(__response__, 'boot_modes'),
        burstable_performance_supported=pulumi.get(__response__, 'burstable_performance_supported'),
        current_generation=pulumi.get(__response__, 'current_generation'),
        dedicated_hosts_supported=pulumi.get(__response__, 'dedicated_hosts_supported'),
        default_cores=pulumi.get(__response__, 'default_cores'),
        default_network_card_index=pulumi.get(__response__, 'default_network_card_index'),
        default_threads_per_core=pulumi.get(__response__, 'default_threads_per_core'),
        default_vcpus=pulumi.get(__response__, 'default_vcpus'),
        ebs_encryption_support=pulumi.get(__response__, 'ebs_encryption_support'),
        ebs_nvme_support=pulumi.get(__response__, 'ebs_nvme_support'),
        ebs_optimized_support=pulumi.get(__response__, 'ebs_optimized_support'),
        ebs_performance_baseline_bandwidth=pulumi.get(__response__, 'ebs_performance_baseline_bandwidth'),
        ebs_performance_baseline_iops=pulumi.get(__response__, 'ebs_performance_baseline_iops'),
        ebs_performance_baseline_throughput=pulumi.get(__response__, 'ebs_performance_baseline_throughput'),
        ebs_performance_maximum_bandwidth=pulumi.get(__response__, 'ebs_performance_maximum_bandwidth'),
        ebs_performance_maximum_iops=pulumi.get(__response__, 'ebs_performance_maximum_iops'),
        ebs_performance_maximum_throughput=pulumi.get(__response__, 'ebs_performance_maximum_throughput'),
        efa_maximum_interfaces=pulumi.get(__response__, 'efa_maximum_interfaces'),
        efa_supported=pulumi.get(__response__, 'efa_supported'),
        ena_srd_supported=pulumi.get(__response__, 'ena_srd_supported'),
        ena_support=pulumi.get(__response__, 'ena_support'),
        encryption_in_transit_supported=pulumi.get(__response__, 'encryption_in_transit_supported'),
        fpgas=pulumi.get(__response__, 'fpgas'),
        free_tier_eligible=pulumi.get(__response__, 'free_tier_eligible'),
        gpuses=pulumi.get(__response__, 'gpuses'),
        hibernation_supported=pulumi.get(__response__, 'hibernation_supported'),
        hypervisor=pulumi.get(__response__, 'hypervisor'),
        id=pulumi.get(__response__, 'id'),
        inference_accelerators=pulumi.get(__response__, 'inference_accelerators'),
        instance_disks=pulumi.get(__response__, 'instance_disks'),
        instance_storage_supported=pulumi.get(__response__, 'instance_storage_supported'),
        instance_type=pulumi.get(__response__, 'instance_type'),
        ipv6_supported=pulumi.get(__response__, 'ipv6_supported'),
        maximum_ipv4_addresses_per_interface=pulumi.get(__response__, 'maximum_ipv4_addresses_per_interface'),
        maximum_ipv6_addresses_per_interface=pulumi.get(__response__, 'maximum_ipv6_addresses_per_interface'),
        maximum_network_cards=pulumi.get(__response__, 'maximum_network_cards'),
        maximum_network_interfaces=pulumi.get(__response__, 'maximum_network_interfaces'),
        media_accelerators=pulumi.get(__response__, 'media_accelerators'),
        memory_size=pulumi.get(__response__, 'memory_size'),
        network_cards=pulumi.get(__response__, 'network_cards'),
        network_performance=pulumi.get(__response__, 'network_performance'),
        neuron_devices=pulumi.get(__response__, 'neuron_devices'),
        nitro_enclaves_support=pulumi.get(__response__, 'nitro_enclaves_support'),
        nitro_tpm_support=pulumi.get(__response__, 'nitro_tpm_support'),
        nitro_tpm_supported_versions=pulumi.get(__response__, 'nitro_tpm_supported_versions'),
        phc_support=pulumi.get(__response__, 'phc_support'),
        region=pulumi.get(__response__, 'region'),
        supported_architectures=pulumi.get(__response__, 'supported_architectures'),
        supported_cpu_features=pulumi.get(__response__, 'supported_cpu_features'),
        supported_placement_strategies=pulumi.get(__response__, 'supported_placement_strategies'),
        supported_root_device_types=pulumi.get(__response__, 'supported_root_device_types'),
        supported_usages_classes=pulumi.get(__response__, 'supported_usages_classes'),
        supported_virtualization_types=pulumi.get(__response__, 'supported_virtualization_types'),
        sustained_clock_speed=pulumi.get(__response__, 'sustained_clock_speed'),
        total_fpga_memory=pulumi.get(__response__, 'total_fpga_memory'),
        total_gpu_memory=pulumi.get(__response__, 'total_gpu_memory'),
        total_inference_memory=pulumi.get(__response__, 'total_inference_memory'),
        total_instance_storage=pulumi.get(__response__, 'total_instance_storage'),
        total_media_memory=pulumi.get(__response__, 'total_media_memory'),
        total_neuron_device_memory=pulumi.get(__response__, 'total_neuron_device_memory'),
        valid_cores=pulumi.get(__response__, 'valid_cores'),
        valid_threads_per_cores=pulumi.get(__response__, 'valid_threads_per_cores')))
