# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLocalGatewayRouteTableResult',
    'AwaitableGetLocalGatewayRouteTableResult',
    'get_local_gateway_route_table',
    'get_local_gateway_route_table_output',
]

@pulumi.output_type
class GetLocalGatewayRouteTableResult:
    """
    A collection of values returned by getLocalGatewayRouteTable.
    """
    def __init__(__self__, filters=None, id=None, local_gateway_id=None, local_gateway_route_table_id=None, outpost_arn=None, region=None, state=None, tags=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_gateway_id and not isinstance(local_gateway_id, str):
            raise TypeError("Expected argument 'local_gateway_id' to be a str")
        pulumi.set(__self__, "local_gateway_id", local_gateway_id)
        if local_gateway_route_table_id and not isinstance(local_gateway_route_table_id, str):
            raise TypeError("Expected argument 'local_gateway_route_table_id' to be a str")
        pulumi.set(__self__, "local_gateway_route_table_id", local_gateway_route_table_id)
        if outpost_arn and not isinstance(outpost_arn, str):
            raise TypeError("Expected argument 'outpost_arn' to be a str")
        pulumi.set(__self__, "outpost_arn", outpost_arn)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLocalGatewayRouteTableFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localGatewayId")
    def local_gateway_id(self) -> builtins.str:
        return pulumi.get(self, "local_gateway_id")

    @property
    @pulumi.getter(name="localGatewayRouteTableId")
    def local_gateway_route_table_id(self) -> builtins.str:
        return pulumi.get(self, "local_gateway_route_table_id")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> builtins.str:
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetLocalGatewayRouteTableResult(GetLocalGatewayRouteTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocalGatewayRouteTableResult(
            filters=self.filters,
            id=self.id,
            local_gateway_id=self.local_gateway_id,
            local_gateway_route_table_id=self.local_gateway_route_table_id,
            outpost_arn=self.outpost_arn,
            region=self.region,
            state=self.state,
            tags=self.tags)


def get_local_gateway_route_table(filters: Optional[Sequence[Union['GetLocalGatewayRouteTableFilterArgs', 'GetLocalGatewayRouteTableFilterArgsDict']]] = None,
                                  local_gateway_id: Optional[builtins.str] = None,
                                  local_gateway_route_table_id: Optional[builtins.str] = None,
                                  outpost_arn: Optional[builtins.str] = None,
                                  region: Optional[builtins.str] = None,
                                  state: Optional[builtins.str] = None,
                                  tags: Optional[Mapping[str, builtins.str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocalGatewayRouteTableResult:
    """
    Provides details about an EC2 Local Gateway Route Table.

    This data source can prove useful when a module accepts a local gateway route table id as
    an input variable and needs to, for example, find the associated Outpost or Local Gateway.

    ## Example Usage

    The following example returns a specific local gateway route table ID

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    aws_ec2_local_gateway_route_table = config.require_object("awsEc2LocalGatewayRouteTable")
    selected = aws.ec2.get_local_gateway_route_table(local_gateway_route_table_id=aws_ec2_local_gateway_route_table)
    ```


    :param builtins.str local_gateway_id: ID of the specific local gateway route table to retrieve.
    :param builtins.str local_gateway_route_table_id: Local Gateway Route Table Id assigned to desired local gateway route table
    :param builtins.str outpost_arn: ARN of the Outpost the local gateway route table is associated with.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str state: State of the local gateway route table.
    :param Mapping[str, builtins.str] tags: Mapping of tags, each pair of which must exactly match
           a pair on the desired local gateway route table.
           
           The arguments of this data source act as filters for querying the available
           Local Gateway Route Tables in the current region. The given filters must match exactly one
           Local Gateway Route Table whose data will be exported as attributes.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['localGatewayId'] = local_gateway_id
    __args__['localGatewayRouteTableId'] = local_gateway_route_table_id
    __args__['outpostArn'] = outpost_arn
    __args__['region'] = region
    __args__['state'] = state
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getLocalGatewayRouteTable:getLocalGatewayRouteTable', __args__, opts=opts, typ=GetLocalGatewayRouteTableResult).value

    return AwaitableGetLocalGatewayRouteTableResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        local_gateway_id=pulumi.get(__ret__, 'local_gateway_id'),
        local_gateway_route_table_id=pulumi.get(__ret__, 'local_gateway_route_table_id'),
        outpost_arn=pulumi.get(__ret__, 'outpost_arn'),
        region=pulumi.get(__ret__, 'region'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_local_gateway_route_table_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLocalGatewayRouteTableFilterArgs', 'GetLocalGatewayRouteTableFilterArgsDict']]]]] = None,
                                         local_gateway_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         local_gateway_route_table_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         outpost_arn: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocalGatewayRouteTableResult]:
    """
    Provides details about an EC2 Local Gateway Route Table.

    This data source can prove useful when a module accepts a local gateway route table id as
    an input variable and needs to, for example, find the associated Outpost or Local Gateway.

    ## Example Usage

    The following example returns a specific local gateway route table ID

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    aws_ec2_local_gateway_route_table = config.require_object("awsEc2LocalGatewayRouteTable")
    selected = aws.ec2.get_local_gateway_route_table(local_gateway_route_table_id=aws_ec2_local_gateway_route_table)
    ```


    :param builtins.str local_gateway_id: ID of the specific local gateway route table to retrieve.
    :param builtins.str local_gateway_route_table_id: Local Gateway Route Table Id assigned to desired local gateway route table
    :param builtins.str outpost_arn: ARN of the Outpost the local gateway route table is associated with.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str state: State of the local gateway route table.
    :param Mapping[str, builtins.str] tags: Mapping of tags, each pair of which must exactly match
           a pair on the desired local gateway route table.
           
           The arguments of this data source act as filters for querying the available
           Local Gateway Route Tables in the current region. The given filters must match exactly one
           Local Gateway Route Table whose data will be exported as attributes.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['localGatewayId'] = local_gateway_id
    __args__['localGatewayRouteTableId'] = local_gateway_route_table_id
    __args__['outpostArn'] = outpost_arn
    __args__['region'] = region
    __args__['state'] = state
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getLocalGatewayRouteTable:getLocalGatewayRouteTable', __args__, opts=opts, typ=GetLocalGatewayRouteTableResult)
    return __ret__.apply(lambda __response__: GetLocalGatewayRouteTableResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        local_gateway_id=pulumi.get(__response__, 'local_gateway_id'),
        local_gateway_route_table_id=pulumi.get(__response__, 'local_gateway_route_table_id'),
        outpost_arn=pulumi.get(__response__, 'outpost_arn'),
        region=pulumi.get(__response__, 'region'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
