# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedPrefixListResult',
    'AwaitableGetManagedPrefixListResult',
    'get_managed_prefix_list',
    'get_managed_prefix_list_output',
]

@pulumi.output_type
class GetManagedPrefixListResult:
    """
    A collection of values returned by getManagedPrefixList.
    """
    def __init__(__self__, address_family=None, arn=None, entries=None, filters=None, id=None, max_entries=None, name=None, owner_id=None, region=None, tags=None, version=None):
        if address_family and not isinstance(address_family, str):
            raise TypeError("Expected argument 'address_family' to be a str")
        pulumi.set(__self__, "address_family", address_family)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_entries and not isinstance(max_entries, int):
            raise TypeError("Expected argument 'max_entries' to be a int")
        pulumi.set(__self__, "max_entries", max_entries)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> builtins.str:
        """
        Address family of the prefix list. Valid values are `IPv4` and `IPv6`.
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the selected prefix list.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetManagedPrefixListEntryResult']:
        """
        Set of entries in this prefix list. Each entry is an object with `cidr` and `description`.
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedPrefixListFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the selected prefix list.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxEntries")
    def max_entries(self) -> builtins.int:
        """
        When then prefix list is managed, the maximum number of entries it supports, or null otherwise.
        """
        return pulumi.get(self, "max_entries")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the selected prefix list.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> builtins.str:
        """
        Account ID of the owner of a customer-managed prefix list, or `AWS` otherwise.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        return pulumi.get(self, "version")


class AwaitableGetManagedPrefixListResult(GetManagedPrefixListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedPrefixListResult(
            address_family=self.address_family,
            arn=self.arn,
            entries=self.entries,
            filters=self.filters,
            id=self.id,
            max_entries=self.max_entries,
            name=self.name,
            owner_id=self.owner_id,
            region=self.region,
            tags=self.tags,
            version=self.version)


def get_managed_prefix_list(filters: Optional[Sequence[Union['GetManagedPrefixListFilterArgs', 'GetManagedPrefixListFilterArgsDict']]] = None,
                            id: Optional[builtins.str] = None,
                            name: Optional[builtins.str] = None,
                            region: Optional[builtins.str] = None,
                            tags: Optional[Mapping[str, builtins.str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedPrefixListResult:
    """
    `ec2.ManagedPrefixList` provides details about a specific AWS prefix list or
    customer-managed prefix list in the current region.

    ## Example Usage

    ### Find the regional DynamoDB prefix list

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.get_region()
    example = aws.ec2.get_managed_prefix_list(name=f"com.amazonaws.{current.region}.dynamodb")
    ```

    ### Find a managed prefix list using filters

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_managed_prefix_list(filters=[{
        "name": "prefix-list-name",
        "values": ["my-prefix-list"],
    }])
    ```


    :param Sequence[Union['GetManagedPrefixListFilterArgs', 'GetManagedPrefixListFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
           
           The arguments of this data source act as filters for querying the available
           prefix lists. The given filters must match exactly one prefix list
           whose data will be exported as attributes.
    :param builtins.str id: ID of the prefix list to select.
    :param builtins.str name: Name of the prefix list to select.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getManagedPrefixList:getManagedPrefixList', __args__, opts=opts, typ=GetManagedPrefixListResult).value

    return AwaitableGetManagedPrefixListResult(
        address_family=pulumi.get(__ret__, 'address_family'),
        arn=pulumi.get(__ret__, 'arn'),
        entries=pulumi.get(__ret__, 'entries'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        max_entries=pulumi.get(__ret__, 'max_entries'),
        name=pulumi.get(__ret__, 'name'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        version=pulumi.get(__ret__, 'version'))
def get_managed_prefix_list_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedPrefixListFilterArgs', 'GetManagedPrefixListFilterArgsDict']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedPrefixListResult]:
    """
    `ec2.ManagedPrefixList` provides details about a specific AWS prefix list or
    customer-managed prefix list in the current region.

    ## Example Usage

    ### Find the regional DynamoDB prefix list

    ```python
    import pulumi
    import pulumi_aws as aws

    current = aws.get_region()
    example = aws.ec2.get_managed_prefix_list(name=f"com.amazonaws.{current.region}.dynamodb")
    ```

    ### Find a managed prefix list using filters

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_managed_prefix_list(filters=[{
        "name": "prefix-list-name",
        "values": ["my-prefix-list"],
    }])
    ```


    :param Sequence[Union['GetManagedPrefixListFilterArgs', 'GetManagedPrefixListFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
           
           The arguments of this data source act as filters for querying the available
           prefix lists. The given filters must match exactly one prefix list
           whose data will be exported as attributes.
    :param builtins.str id: ID of the prefix list to select.
    :param builtins.str name: Name of the prefix list to select.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getManagedPrefixList:getManagedPrefixList', __args__, opts=opts, typ=GetManagedPrefixListResult)
    return __ret__.apply(lambda __response__: GetManagedPrefixListResult(
        address_family=pulumi.get(__response__, 'address_family'),
        arn=pulumi.get(__response__, 'arn'),
        entries=pulumi.get(__response__, 'entries'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        max_entries=pulumi.get(__response__, 'max_entries'),
        name=pulumi.get(__response__, 'name'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        version=pulumi.get(__response__, 'version')))
