# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkInsightsPathResult',
    'AwaitableGetNetworkInsightsPathResult',
    'get_network_insights_path',
    'get_network_insights_path_output',
]

@pulumi.output_type
class GetNetworkInsightsPathResult:
    """
    A collection of values returned by getNetworkInsightsPath.
    """
    def __init__(__self__, arn=None, destination=None, destination_arn=None, destination_ip=None, destination_port=None, filter_at_destinations=None, filter_at_sources=None, filters=None, id=None, network_insights_path_id=None, protocol=None, region=None, source=None, source_arn=None, source_ip=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if destination and not isinstance(destination, str):
            raise TypeError("Expected argument 'destination' to be a str")
        pulumi.set(__self__, "destination", destination)
        if destination_arn and not isinstance(destination_arn, str):
            raise TypeError("Expected argument 'destination_arn' to be a str")
        pulumi.set(__self__, "destination_arn", destination_arn)
        if destination_ip and not isinstance(destination_ip, str):
            raise TypeError("Expected argument 'destination_ip' to be a str")
        pulumi.set(__self__, "destination_ip", destination_ip)
        if destination_port and not isinstance(destination_port, int):
            raise TypeError("Expected argument 'destination_port' to be a int")
        pulumi.set(__self__, "destination_port", destination_port)
        if filter_at_destinations and not isinstance(filter_at_destinations, list):
            raise TypeError("Expected argument 'filter_at_destinations' to be a list")
        pulumi.set(__self__, "filter_at_destinations", filter_at_destinations)
        if filter_at_sources and not isinstance(filter_at_sources, list):
            raise TypeError("Expected argument 'filter_at_sources' to be a list")
        pulumi.set(__self__, "filter_at_sources", filter_at_sources)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_insights_path_id and not isinstance(network_insights_path_id, str):
            raise TypeError("Expected argument 'network_insights_path_id' to be a str")
        pulumi.set(__self__, "network_insights_path_id", network_insights_path_id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if source_arn and not isinstance(source_arn, str):
            raise TypeError("Expected argument 'source_arn' to be a str")
        pulumi.set(__self__, "source_arn", source_arn)
        if source_ip and not isinstance(source_ip, str):
            raise TypeError("Expected argument 'source_ip' to be a str")
        pulumi.set(__self__, "source_ip", source_ip)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the selected Network Insights Path.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        """
        AWS resource that is the destination of the path.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> builtins.str:
        """
        ARN of the destination.
        """
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> builtins.str:
        """
        IP address of the AWS resource that is the destination of the path.
        """
        return pulumi.get(self, "destination_ip")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> builtins.int:
        """
        Destination port.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="filterAtDestinations")
    def filter_at_destinations(self) -> Sequence['outputs.GetNetworkInsightsPathFilterAtDestinationResult']:
        """
        Filters of the network paths at the destination.
        """
        return pulumi.get(self, "filter_at_destinations")

    @property
    @pulumi.getter(name="filterAtSources")
    def filter_at_sources(self) -> Sequence['outputs.GetNetworkInsightsPathFilterAtSourceResult']:
        """
        Filters of the network paths at the source.
        """
        return pulumi.get(self, "filter_at_sources")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNetworkInsightsPathFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkInsightsPathId")
    def network_insights_path_id(self) -> builtins.str:
        return pulumi.get(self, "network_insights_path_id")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        Protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        AWS resource that is the source of the path.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> builtins.str:
        """
        ARN of the source.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> builtins.str:
        """
        IP address of the AWS resource that is the source of the path.
        """
        return pulumi.get(self, "source_ip")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNetworkInsightsPathResult(GetNetworkInsightsPathResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkInsightsPathResult(
            arn=self.arn,
            destination=self.destination,
            destination_arn=self.destination_arn,
            destination_ip=self.destination_ip,
            destination_port=self.destination_port,
            filter_at_destinations=self.filter_at_destinations,
            filter_at_sources=self.filter_at_sources,
            filters=self.filters,
            id=self.id,
            network_insights_path_id=self.network_insights_path_id,
            protocol=self.protocol,
            region=self.region,
            source=self.source,
            source_arn=self.source_arn,
            source_ip=self.source_ip,
            tags=self.tags)


def get_network_insights_path(filters: Optional[Sequence[Union['GetNetworkInsightsPathFilterArgs', 'GetNetworkInsightsPathFilterArgsDict']]] = None,
                              network_insights_path_id: Optional[builtins.str] = None,
                              region: Optional[builtins.str] = None,
                              tags: Optional[Mapping[str, builtins.str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkInsightsPathResult:
    """
    `ec2.NetworkInsightsPath` provides details about a specific Network Insights Path.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_network_insights_path(network_insights_path_id=example_aws_ec2_network_insights_path["id"])
    ```


    :param Sequence[Union['GetNetworkInsightsPathFilterArgs', 'GetNetworkInsightsPathFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
           
           The arguments of this data source act as filters for querying the available
           Network Insights Paths. The given filters must match exactly one Network Insights Path
           whose data will be exported as attributes.
    :param builtins.str network_insights_path_id: ID of the Network Insights Path to select.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['networkInsightsPathId'] = network_insights_path_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getNetworkInsightsPath:getNetworkInsightsPath', __args__, opts=opts, typ=GetNetworkInsightsPathResult).value

    return AwaitableGetNetworkInsightsPathResult(
        arn=pulumi.get(__ret__, 'arn'),
        destination=pulumi.get(__ret__, 'destination'),
        destination_arn=pulumi.get(__ret__, 'destination_arn'),
        destination_ip=pulumi.get(__ret__, 'destination_ip'),
        destination_port=pulumi.get(__ret__, 'destination_port'),
        filter_at_destinations=pulumi.get(__ret__, 'filter_at_destinations'),
        filter_at_sources=pulumi.get(__ret__, 'filter_at_sources'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        network_insights_path_id=pulumi.get(__ret__, 'network_insights_path_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        region=pulumi.get(__ret__, 'region'),
        source=pulumi.get(__ret__, 'source'),
        source_arn=pulumi.get(__ret__, 'source_arn'),
        source_ip=pulumi.get(__ret__, 'source_ip'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_insights_path_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkInsightsPathFilterArgs', 'GetNetworkInsightsPathFilterArgsDict']]]]] = None,
                                     network_insights_path_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkInsightsPathResult]:
    """
    `ec2.NetworkInsightsPath` provides details about a specific Network Insights Path.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_network_insights_path(network_insights_path_id=example_aws_ec2_network_insights_path["id"])
    ```


    :param Sequence[Union['GetNetworkInsightsPathFilterArgs', 'GetNetworkInsightsPathFilterArgsDict']] filters: Configuration block(s) for filtering. Detailed below.
           
           The arguments of this data source act as filters for querying the available
           Network Insights Paths. The given filters must match exactly one Network Insights Path
           whose data will be exported as attributes.
    :param builtins.str network_insights_path_id: ID of the Network Insights Path to select.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['networkInsightsPathId'] = network_insights_path_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getNetworkInsightsPath:getNetworkInsightsPath', __args__, opts=opts, typ=GetNetworkInsightsPathResult)
    return __ret__.apply(lambda __response__: GetNetworkInsightsPathResult(
        arn=pulumi.get(__response__, 'arn'),
        destination=pulumi.get(__response__, 'destination'),
        destination_arn=pulumi.get(__response__, 'destination_arn'),
        destination_ip=pulumi.get(__response__, 'destination_ip'),
        destination_port=pulumi.get(__response__, 'destination_port'),
        filter_at_destinations=pulumi.get(__response__, 'filter_at_destinations'),
        filter_at_sources=pulumi.get(__response__, 'filter_at_sources'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        network_insights_path_id=pulumi.get(__response__, 'network_insights_path_id'),
        protocol=pulumi.get(__response__, 'protocol'),
        region=pulumi.get(__response__, 'region'),
        source=pulumi.get(__response__, 'source'),
        source_arn=pulumi.get(__response__, 'source_arn'),
        source_ip=pulumi.get(__response__, 'source_ip'),
        tags=pulumi.get(__response__, 'tags')))
