# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkInterfaceResult',
    'AwaitableGetNetworkInterfaceResult',
    'get_network_interface',
    'get_network_interface_output',
]

@pulumi.output_type
class GetNetworkInterfaceResult:
    """
    A collection of values returned by getNetworkInterface.
    """
    def __init__(__self__, arn=None, associations=None, attachments=None, availability_zone=None, description=None, filters=None, id=None, interface_type=None, ipv6_addresses=None, mac_address=None, outpost_arn=None, owner_id=None, private_dns_name=None, private_ip=None, private_ips=None, region=None, requester_id=None, security_groups=None, subnet_id=None, tags=None, vpc_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if attachments and not isinstance(attachments, list):
            raise TypeError("Expected argument 'attachments' to be a list")
        pulumi.set(__self__, "attachments", attachments)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interface_type and not isinstance(interface_type, str):
            raise TypeError("Expected argument 'interface_type' to be a str")
        pulumi.set(__self__, "interface_type", interface_type)
        if ipv6_addresses and not isinstance(ipv6_addresses, list):
            raise TypeError("Expected argument 'ipv6_addresses' to be a list")
        pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if mac_address and not isinstance(mac_address, str):
            raise TypeError("Expected argument 'mac_address' to be a str")
        pulumi.set(__self__, "mac_address", mac_address)
        if outpost_arn and not isinstance(outpost_arn, str):
            raise TypeError("Expected argument 'outpost_arn' to be a str")
        pulumi.set(__self__, "outpost_arn", outpost_arn)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if private_dns_name and not isinstance(private_dns_name, str):
            raise TypeError("Expected argument 'private_dns_name' to be a str")
        pulumi.set(__self__, "private_dns_name", private_dns_name)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if private_ips and not isinstance(private_ips, list):
            raise TypeError("Expected argument 'private_ips' to be a list")
        pulumi.set(__self__, "private_ips", private_ips)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if requester_id and not isinstance(requester_id, str):
            raise TypeError("Expected argument 'requester_id' to be a str")
        pulumi.set(__self__, "requester_id", requester_id)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the network interface.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetNetworkInterfaceAssociationResult']:
        """
        Association information for an Elastic IP address (IPv4) associated with the network interface. See supported fields below.
        """
        return pulumi.get(self, "associations")

    @property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetNetworkInterfaceAttachmentResult']:
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> builtins.str:
        """
        Availability Zone.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the network interface.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNetworkInterfaceFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interfaceType")
    def interface_type(self) -> builtins.str:
        """
        Type of interface.
        """
        return pulumi.get(self, "interface_type")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Sequence[builtins.str]:
        """
        List of IPv6 addresses to assign to the ENI.
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> builtins.str:
        """
        MAC address.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> builtins.str:
        """
        ARN of the Outpost.
        """
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> builtins.str:
        """
        AWS account ID of the owner of the network interface.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="privateDnsName")
    def private_dns_name(self) -> builtins.str:
        """
        Private DNS name.
        """
        return pulumi.get(self, "private_dns_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        """
        Private IPv4 address of the network interface within the subnet.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[builtins.str]:
        """
        Private IPv4 addresses associated with the network interface.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="requesterId")
    def requester_id(self) -> builtins.str:
        """
        ID of the entity that launched the instance on your behalf.
        """
        return pulumi.get(self, "requester_id")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[builtins.str]:
        """
        List of security groups for the network interface.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        ID of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Any tags assigned to the network interface.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetNetworkInterfaceResult(GetNetworkInterfaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkInterfaceResult(
            arn=self.arn,
            associations=self.associations,
            attachments=self.attachments,
            availability_zone=self.availability_zone,
            description=self.description,
            filters=self.filters,
            id=self.id,
            interface_type=self.interface_type,
            ipv6_addresses=self.ipv6_addresses,
            mac_address=self.mac_address,
            outpost_arn=self.outpost_arn,
            owner_id=self.owner_id,
            private_dns_name=self.private_dns_name,
            private_ip=self.private_ip,
            private_ips=self.private_ips,
            region=self.region,
            requester_id=self.requester_id,
            security_groups=self.security_groups,
            subnet_id=self.subnet_id,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_network_interface(filters: Optional[Sequence[Union['GetNetworkInterfaceFilterArgs', 'GetNetworkInterfaceFilterArgsDict']]] = None,
                          id: Optional[builtins.str] = None,
                          region: Optional[builtins.str] = None,
                          tags: Optional[Mapping[str, builtins.str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkInterfaceResult:
    """
    Use this data source to get information about a Network Interface.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    bar = aws.ec2.get_network_interface(id="eni-01234567")
    ```


    :param Sequence[Union['GetNetworkInterfaceFilterArgs', 'GetNetworkInterfaceFilterArgsDict']] filters: One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
    :param builtins.str id: Identifier for the network interface.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Any tags assigned to the network interface.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getNetworkInterface:getNetworkInterface', __args__, opts=opts, typ=GetNetworkInterfaceResult).value

    return AwaitableGetNetworkInterfaceResult(
        arn=pulumi.get(__ret__, 'arn'),
        associations=pulumi.get(__ret__, 'associations'),
        attachments=pulumi.get(__ret__, 'attachments'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        description=pulumi.get(__ret__, 'description'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        interface_type=pulumi.get(__ret__, 'interface_type'),
        ipv6_addresses=pulumi.get(__ret__, 'ipv6_addresses'),
        mac_address=pulumi.get(__ret__, 'mac_address'),
        outpost_arn=pulumi.get(__ret__, 'outpost_arn'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        private_dns_name=pulumi.get(__ret__, 'private_dns_name'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        private_ips=pulumi.get(__ret__, 'private_ips'),
        region=pulumi.get(__ret__, 'region'),
        requester_id=pulumi.get(__ret__, 'requester_id'),
        security_groups=pulumi.get(__ret__, 'security_groups'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_network_interface_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkInterfaceFilterArgs', 'GetNetworkInterfaceFilterArgsDict']]]]] = None,
                                 id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkInterfaceResult]:
    """
    Use this data source to get information about a Network Interface.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    bar = aws.ec2.get_network_interface(id="eni-01234567")
    ```


    :param Sequence[Union['GetNetworkInterfaceFilterArgs', 'GetNetworkInterfaceFilterArgsDict']] filters: One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
    :param builtins.str id: Identifier for the network interface.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Any tags assigned to the network interface.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getNetworkInterface:getNetworkInterface', __args__, opts=opts, typ=GetNetworkInterfaceResult)
    return __ret__.apply(lambda __response__: GetNetworkInterfaceResult(
        arn=pulumi.get(__response__, 'arn'),
        associations=pulumi.get(__response__, 'associations'),
        attachments=pulumi.get(__response__, 'attachments'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        description=pulumi.get(__response__, 'description'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        interface_type=pulumi.get(__response__, 'interface_type'),
        ipv6_addresses=pulumi.get(__response__, 'ipv6_addresses'),
        mac_address=pulumi.get(__response__, 'mac_address'),
        outpost_arn=pulumi.get(__response__, 'outpost_arn'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        private_dns_name=pulumi.get(__response__, 'private_dns_name'),
        private_ip=pulumi.get(__response__, 'private_ip'),
        private_ips=pulumi.get(__response__, 'private_ips'),
        region=pulumi.get(__response__, 'region'),
        requester_id=pulumi.get(__response__, 'requester_id'),
        security_groups=pulumi.get(__response__, 'security_groups'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
