# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityGroupResult',
    'AwaitableGetSecurityGroupResult',
    'get_security_group',
    'get_security_group_output',
]

@pulumi.output_type
class GetSecurityGroupResult:
    """
    A collection of values returned by getSecurityGroup.
    """
    def __init__(__self__, arn=None, description=None, filters=None, id=None, name=None, region=None, tags=None, vpc_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        Computed ARN of the security group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the security group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityGroupFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetSecurityGroupResult(GetSecurityGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGroupResult(
            arn=self.arn,
            description=self.description,
            filters=self.filters,
            id=self.id,
            name=self.name,
            region=self.region,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_security_group(filters: Optional[Sequence[Union['GetSecurityGroupFilterArgs', 'GetSecurityGroupFilterArgsDict']]] = None,
                       id: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       tags: Optional[Mapping[str, builtins.str]] = None,
                       vpc_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGroupResult:
    """
    `ec2.SecurityGroup` provides details about a specific Security Group.

    This resource can prove useful when a module accepts a Security Group id as
    an input variable and needs to, for example, determine the id of the
    VPC that the security group belongs to.

    ## Example Usage

    The following example shows how one might accept a Security Group id as a variable
    and use this data source to obtain the data necessary to create a subnet.

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    security_group_id = config.require_object("securityGroupId")
    selected = aws.ec2.get_security_group(id=security_group_id)
    subnet = aws.ec2.Subnet("subnet",
        vpc_id=selected.vpc_id,
        cidr_block="10.0.1.0/24")
    ```


    :param Sequence[Union['GetSecurityGroupFilterArgs', 'GetSecurityGroupFilterArgsDict']] filters: Custom filter block as described below.
    :param builtins.str id: Id of the specific security group to retrieve.
    :param builtins.str name: Name of the field to filter by, as defined by
           [the underlying AWS API](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html).
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired security group.
    :param builtins.str vpc_id: Id of the VPC that the desired security group belongs to.
           
           More complex filters can be expressed using one or more `filter` sub-blocks,
           which take the following arguments:
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getSecurityGroup:getSecurityGroup', __args__, opts=opts, typ=GetSecurityGroupResult).value

    return AwaitableGetSecurityGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_security_group_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityGroupFilterArgs', 'GetSecurityGroupFilterArgsDict']]]]] = None,
                              id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                              vpc_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityGroupResult]:
    """
    `ec2.SecurityGroup` provides details about a specific Security Group.

    This resource can prove useful when a module accepts a Security Group id as
    an input variable and needs to, for example, determine the id of the
    VPC that the security group belongs to.

    ## Example Usage

    The following example shows how one might accept a Security Group id as a variable
    and use this data source to obtain the data necessary to create a subnet.

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    security_group_id = config.require_object("securityGroupId")
    selected = aws.ec2.get_security_group(id=security_group_id)
    subnet = aws.ec2.Subnet("subnet",
        vpc_id=selected.vpc_id,
        cidr_block="10.0.1.0/24")
    ```


    :param Sequence[Union['GetSecurityGroupFilterArgs', 'GetSecurityGroupFilterArgsDict']] filters: Custom filter block as described below.
    :param builtins.str id: Id of the specific security group to retrieve.
    :param builtins.str name: Name of the field to filter by, as defined by
           [the underlying AWS API](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html).
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired security group.
    :param builtins.str vpc_id: Id of the VPC that the desired security group belongs to.
           
           More complex filters can be expressed using one or more `filter` sub-blocks,
           which take the following arguments:
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getSecurityGroup:getSecurityGroup', __args__, opts=opts, typ=GetSecurityGroupResult)
    return __ret__.apply(lambda __response__: GetSecurityGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
