# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcIpamResult',
    'AwaitableGetVpcIpamResult',
    'get_vpc_ipam',
    'get_vpc_ipam_output',
]

@pulumi.output_type
class GetVpcIpamResult:
    """
    A collection of values returned by getVpcIpam.
    """
    def __init__(__self__, arn=None, default_resource_discovery_association_id=None, default_resource_discovery_id=None, description=None, enable_private_gua=None, id=None, ipam_region=None, operating_regions=None, owner_id=None, private_default_scope_id=None, public_default_scope_id=None, region=None, resource_discovery_association_count=None, scope_count=None, state=None, state_message=None, tags=None, tier=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if default_resource_discovery_association_id and not isinstance(default_resource_discovery_association_id, str):
            raise TypeError("Expected argument 'default_resource_discovery_association_id' to be a str")
        pulumi.set(__self__, "default_resource_discovery_association_id", default_resource_discovery_association_id)
        if default_resource_discovery_id and not isinstance(default_resource_discovery_id, str):
            raise TypeError("Expected argument 'default_resource_discovery_id' to be a str")
        pulumi.set(__self__, "default_resource_discovery_id", default_resource_discovery_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enable_private_gua and not isinstance(enable_private_gua, bool):
            raise TypeError("Expected argument 'enable_private_gua' to be a bool")
        pulumi.set(__self__, "enable_private_gua", enable_private_gua)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipam_region and not isinstance(ipam_region, str):
            raise TypeError("Expected argument 'ipam_region' to be a str")
        pulumi.set(__self__, "ipam_region", ipam_region)
        if operating_regions and not isinstance(operating_regions, list):
            raise TypeError("Expected argument 'operating_regions' to be a list")
        pulumi.set(__self__, "operating_regions", operating_regions)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if private_default_scope_id and not isinstance(private_default_scope_id, str):
            raise TypeError("Expected argument 'private_default_scope_id' to be a str")
        pulumi.set(__self__, "private_default_scope_id", private_default_scope_id)
        if public_default_scope_id and not isinstance(public_default_scope_id, str):
            raise TypeError("Expected argument 'public_default_scope_id' to be a str")
        pulumi.set(__self__, "public_default_scope_id", public_default_scope_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_discovery_association_count and not isinstance(resource_discovery_association_count, int):
            raise TypeError("Expected argument 'resource_discovery_association_count' to be a int")
        pulumi.set(__self__, "resource_discovery_association_count", resource_discovery_association_count)
        if scope_count and not isinstance(scope_count, int):
            raise TypeError("Expected argument 'scope_count' to be a int")
        pulumi.set(__self__, "scope_count", scope_count)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_message and not isinstance(state_message, str):
            raise TypeError("Expected argument 'state_message' to be a str")
        pulumi.set(__self__, "state_message", state_message)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the IPAM.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultResourceDiscoveryAssociationId")
    def default_resource_discovery_association_id(self) -> builtins.str:
        """
        The default resource discovery association ID.
        """
        return pulumi.get(self, "default_resource_discovery_association_id")

    @property
    @pulumi.getter(name="defaultResourceDiscoveryId")
    def default_resource_discovery_id(self) -> builtins.str:
        """
        The default resource discovery ID.
        """
        return pulumi.get(self, "default_resource_discovery_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description for the IPAM.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enablePrivateGua")
    def enable_private_gua(self) -> builtins.bool:
        """
        If private GUA is enabled.
        """
        return pulumi.get(self, "enable_private_gua")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the IPAM resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipamRegion")
    def ipam_region(self) -> builtins.str:
        """
        Region that the IPAM exists in.
        """
        return pulumi.get(self, "ipam_region")

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> Sequence['outputs.GetVpcIpamOperatingRegionResult']:
        """
        Regions that the IPAM is configured to operate in.
        """
        return pulumi.get(self, "operating_regions")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> builtins.str:
        """
        ID of the account that owns this IPAM.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="privateDefaultScopeId")
    def private_default_scope_id(self) -> builtins.str:
        """
        ID of the default private scope.
        """
        return pulumi.get(self, "private_default_scope_id")

    @property
    @pulumi.getter(name="publicDefaultScopeId")
    def public_default_scope_id(self) -> builtins.str:
        """
        ID of the default public scope.
        """
        return pulumi.get(self, "public_default_scope_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceDiscoveryAssociationCount")
    def resource_discovery_association_count(self) -> builtins.int:
        """
        Number of resource discovery associations.
        """
        return pulumi.get(self, "resource_discovery_association_count")

    @property
    @pulumi.getter(name="scopeCount")
    def scope_count(self) -> builtins.int:
        """
        Number of scopes on this IPAM.
        """
        return pulumi.get(self, "scope_count")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Current state of the IPAM.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> builtins.str:
        """
        State message of the IPAM.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Tags of the IPAM resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> builtins.str:
        """
        IPAM Tier.
        """
        return pulumi.get(self, "tier")


class AwaitableGetVpcIpamResult(GetVpcIpamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcIpamResult(
            arn=self.arn,
            default_resource_discovery_association_id=self.default_resource_discovery_association_id,
            default_resource_discovery_id=self.default_resource_discovery_id,
            description=self.description,
            enable_private_gua=self.enable_private_gua,
            id=self.id,
            ipam_region=self.ipam_region,
            operating_regions=self.operating_regions,
            owner_id=self.owner_id,
            private_default_scope_id=self.private_default_scope_id,
            public_default_scope_id=self.public_default_scope_id,
            region=self.region,
            resource_discovery_association_count=self.resource_discovery_association_count,
            scope_count=self.scope_count,
            state=self.state,
            state_message=self.state_message,
            tags=self.tags,
            tier=self.tier)


def get_vpc_ipam(id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcIpamResult:
    """
    Data source for managing a VPC IPAM.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_ipam(id="ipam-abcd1234")
    ```


    :param builtins.str id: ID of the IPAM.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getVpcIpam:getVpcIpam', __args__, opts=opts, typ=GetVpcIpamResult).value

    return AwaitableGetVpcIpamResult(
        arn=pulumi.get(__ret__, 'arn'),
        default_resource_discovery_association_id=pulumi.get(__ret__, 'default_resource_discovery_association_id'),
        default_resource_discovery_id=pulumi.get(__ret__, 'default_resource_discovery_id'),
        description=pulumi.get(__ret__, 'description'),
        enable_private_gua=pulumi.get(__ret__, 'enable_private_gua'),
        id=pulumi.get(__ret__, 'id'),
        ipam_region=pulumi.get(__ret__, 'ipam_region'),
        operating_regions=pulumi.get(__ret__, 'operating_regions'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        private_default_scope_id=pulumi.get(__ret__, 'private_default_scope_id'),
        public_default_scope_id=pulumi.get(__ret__, 'public_default_scope_id'),
        region=pulumi.get(__ret__, 'region'),
        resource_discovery_association_count=pulumi.get(__ret__, 'resource_discovery_association_count'),
        scope_count=pulumi.get(__ret__, 'scope_count'),
        state=pulumi.get(__ret__, 'state'),
        state_message=pulumi.get(__ret__, 'state_message'),
        tags=pulumi.get(__ret__, 'tags'),
        tier=pulumi.get(__ret__, 'tier'))
def get_vpc_ipam_output(id: Optional[pulumi.Input[builtins.str]] = None,
                        region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcIpamResult]:
    """
    Data source for managing a VPC IPAM.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_ipam(id="ipam-abcd1234")
    ```


    :param builtins.str id: ID of the IPAM.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getVpcIpam:getVpcIpam', __args__, opts=opts, typ=GetVpcIpamResult)
    return __ret__.apply(lambda __response__: GetVpcIpamResult(
        arn=pulumi.get(__response__, 'arn'),
        default_resource_discovery_association_id=pulumi.get(__response__, 'default_resource_discovery_association_id'),
        default_resource_discovery_id=pulumi.get(__response__, 'default_resource_discovery_id'),
        description=pulumi.get(__response__, 'description'),
        enable_private_gua=pulumi.get(__response__, 'enable_private_gua'),
        id=pulumi.get(__response__, 'id'),
        ipam_region=pulumi.get(__response__, 'ipam_region'),
        operating_regions=pulumi.get(__response__, 'operating_regions'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        private_default_scope_id=pulumi.get(__response__, 'private_default_scope_id'),
        public_default_scope_id=pulumi.get(__response__, 'public_default_scope_id'),
        region=pulumi.get(__response__, 'region'),
        resource_discovery_association_count=pulumi.get(__response__, 'resource_discovery_association_count'),
        scope_count=pulumi.get(__response__, 'scope_count'),
        state=pulumi.get(__response__, 'state'),
        state_message=pulumi.get(__response__, 'state_message'),
        tags=pulumi.get(__response__, 'tags'),
        tier=pulumi.get(__response__, 'tier')))
