# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcIpamsResult',
    'AwaitableGetVpcIpamsResult',
    'get_vpc_ipams',
    'get_vpc_ipams_output',
]

@pulumi.output_type
class GetVpcIpamsResult:
    """
    A collection of values returned by getVpcIpams.
    """
    def __init__(__self__, filters=None, id=None, ipam_ids=None, ipams=None, region=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipam_ids and not isinstance(ipam_ids, list):
            raise TypeError("Expected argument 'ipam_ids' to be a list")
        pulumi.set(__self__, "ipam_ids", ipam_ids)
        if ipams and not isinstance(ipams, list):
            raise TypeError("Expected argument 'ipams' to be a list")
        pulumi.set(__self__, "ipams", ipams)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpcIpamsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipamIds")
    def ipam_ids(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "ipam_ids")

    @property
    @pulumi.getter
    def ipams(self) -> Sequence['outputs.GetVpcIpamsIpamResult']:
        """
        List of IPAM resources matching the provided arguments.
        """
        return pulumi.get(self, "ipams")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetVpcIpamsResult(GetVpcIpamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcIpamsResult(
            filters=self.filters,
            id=self.id,
            ipam_ids=self.ipam_ids,
            ipams=self.ipams,
            region=self.region)


def get_vpc_ipams(filters: Optional[Sequence[Union['GetVpcIpamsFilterArgs', 'GetVpcIpamsFilterArgsDict']]] = None,
                  ipam_ids: Optional[Sequence[builtins.str]] = None,
                  region: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcIpamsResult:
    """
    Data source for managing VPC IPAMs.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_ipams(ipam_ids=["ipam-abcd1234"])
    ```

    ### Filter by `tags`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_ipams(filters=[{
        "name": "tags.Some",
        "values": ["Value"],
    }])
    ```

    ### Filter by `tier`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_ipams(filters=[{
        "name": "tier",
        "values": ["free"],
    }])
    ```


    :param Sequence[Union['GetVpcIpamsFilterArgs', 'GetVpcIpamsFilterArgsDict']] filters: Custom filter block as described below.
           
           The arguments of this data source act as filters for querying the available IPAMs.
    :param Sequence[builtins.str] ipam_ids: IDs of the IPAM resources to query for.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipamIds'] = ipam_ids
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getVpcIpams:getVpcIpams', __args__, opts=opts, typ=GetVpcIpamsResult).value

    return AwaitableGetVpcIpamsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ipam_ids=pulumi.get(__ret__, 'ipam_ids'),
        ipams=pulumi.get(__ret__, 'ipams'),
        region=pulumi.get(__ret__, 'region'))
def get_vpc_ipams_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcIpamsFilterArgs', 'GetVpcIpamsFilterArgsDict']]]]] = None,
                         ipam_ids: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                         region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcIpamsResult]:
    """
    Data source for managing VPC IPAMs.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_ipams(ipam_ids=["ipam-abcd1234"])
    ```

    ### Filter by `tags`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_ipams(filters=[{
        "name": "tags.Some",
        "values": ["Value"],
    }])
    ```

    ### Filter by `tier`

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_vpc_ipams(filters=[{
        "name": "tier",
        "values": ["free"],
    }])
    ```


    :param Sequence[Union['GetVpcIpamsFilterArgs', 'GetVpcIpamsFilterArgsDict']] filters: Custom filter block as described below.
           
           The arguments of this data source act as filters for querying the available IPAMs.
    :param Sequence[builtins.str] ipam_ids: IDs of the IPAM resources to query for.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipamIds'] = ipam_ids
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getVpcIpams:getVpcIpams', __args__, opts=opts, typ=GetVpcIpamsResult)
    return __ret__.apply(lambda __response__: GetVpcIpamsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ipam_ids=pulumi.get(__response__, 'ipam_ids'),
        ipams=pulumi.get(__response__, 'ipams'),
        region=pulumi.get(__response__, 'region')))
