# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 ami: Optional[pulumi.Input[builtins.str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']] = None,
                 cpu_options: Optional[pulumi.Input['InstanceCpuOptionsArgs']] = None,
                 credit_specification: Optional[pulumi.Input['InstanceCreditSpecificationArgs']] = None,
                 disable_api_stop: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[builtins.bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 enclave_options: Optional[pulumi.Input['InstanceEnclaveOptionsArgs']] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]] = None,
                 get_password_data: Optional[pulumi.Input[builtins.bool]] = None,
                 hibernation: Optional[pulumi.Input[builtins.bool]] = None,
                 host_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 instance_market_options: Optional[pulumi.Input['InstanceInstanceMarketOptionsArgs']] = None,
                 instance_type: Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template: Optional[pulumi.Input['InstanceLaunchTemplateArgs']] = None,
                 maintenance_options: Optional[pulumi.Input['InstanceMaintenanceOptionsArgs']] = None,
                 metadata_options: Optional[pulumi.Input['InstanceMetadataOptionsArgs']] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]] = None,
                 placement_group: Optional[pulumi.Input[builtins.str]] = None,
                 placement_partition_number: Optional[pulumi.Input[builtins.int]] = None,
                 private_dns_name_options: Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_block_device: Optional[pulumi.Input['InstanceRootBlockDeviceArgs']] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenancy: Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[builtins.str]] = None,
                 user_data_replace_on_change: Optional[pulumi.Input[builtins.bool]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[builtins.str] availability_zone: AZ to start the instance in.
        :param pulumi.Input['InstanceCapacityReservationSpecificationArgs'] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input['InstanceCpuOptionsArgs'] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input['InstanceCreditSpecificationArgs'] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        :param pulumi.Input[builtins.bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[builtins.bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        :param pulumi.Input['InstanceEnclaveOptionsArgs'] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[builtins.bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[builtins.bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[builtins.str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[builtins.str] host_resource_group_arn: ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        :param pulumi.Input[builtins.str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input['InstanceInstanceMarketOptionsArgs'] instance_market_options: Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
        :param pulumi.Input[Union[builtins.str, 'InstanceType']] instance_type: Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[builtins.int] ipv6_address_count: Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[builtins.str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input['InstanceLaunchTemplateArgs'] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        :param pulumi.Input['InstanceMaintenanceOptionsArgs'] maintenance_options: Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input['InstanceMetadataOptionsArgs'] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[builtins.bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[builtins.str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[builtins.int] placement_partition_number: Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input['InstancePrivateDnsNameOptionsArgs'] private_dns_name_options: Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[builtins.str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['InstanceRootBlockDeviceArgs'] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] secondary_private_ips: List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: List of security group names to associate with.
               
               > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        :param pulumi.Input[builtins.bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[builtins.str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union[builtins.str, 'Tenancy']] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        :param pulumi.Input[builtins.str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[builtins.str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[builtins.bool] user_data_replace_on_change: When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] volume_tags: Map of tags to assign, at instance-creation time, to root and EBS volumes.
               
               > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_ids: List of security group IDs to associate with.
        """
        if ami is not None:
            pulumi.set(__self__, "ami", ami)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if disable_api_stop is not None:
            pulumi.set(__self__, "disable_api_stop", disable_api_stop)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if enable_primary_ipv6 is not None:
            pulumi.set(__self__, "enable_primary_ipv6", enable_primary_ipv6)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if get_password_data is not None:
            pulumi.set(__self__, "get_password_data", get_password_data)
        if hibernation is not None:
            pulumi.set(__self__, "hibernation", hibernation)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if host_resource_group_arn is not None:
            pulumi.set(__self__, "host_resource_group_arn", host_resource_group_arn)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_market_options is not None:
            pulumi.set(__self__, "instance_market_options", instance_market_options)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if maintenance_options is not None:
            pulumi.set(__self__, "maintenance_options", maintenance_options)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if placement_partition_number is not None:
            pulumi.set(__self__, "placement_partition_number", placement_partition_number)
        if private_dns_name_options is not None:
            pulumi.set(__self__, "private_dns_name_options", private_dns_name_options)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_block_device is not None:
            pulumi.set(__self__, "root_block_device", root_block_device)
        if secondary_private_ips is not None:
            pulumi.set(__self__, "secondary_private_ips", secondary_private_ips)
        if security_groups is not None:
            warnings.warn("""Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""", DeprecationWarning)
            pulumi.log.warn("""security_groups is deprecated: Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""")
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_data_base64 is not None:
            pulumi.set(__self__, "user_data_base64", user_data_base64)
        if user_data_replace_on_change is not None:
            pulumi.set(__self__, "user_data_replace_on_change", user_data_replace_on_change)
        if volume_tags is not None:
            pulumi.set(__self__, "volume_tags", volume_tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter
    def ami(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @ami.setter
    def ami(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ami", value)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']]:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @capacity_reservation_specification.setter
    def capacity_reservation_specification(self, value: Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']]):
        pulumi.set(self, "capacity_reservation_specification", value)

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['InstanceCpuOptionsArgs']]:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['InstanceCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['InstanceCreditSpecificationArgs']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['InstanceCreditSpecificationArgs']]):
        pulumi.set(self, "credit_specification", value)

    @property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        """
        return pulumi.get(self, "disable_api_stop")

    @disable_api_stop.setter
    def disable_api_stop(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_api_stop", value)

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @enable_primary_ipv6.setter
    def enable_primary_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_primary_ipv6", value)

    @property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['InstanceEnclaveOptionsArgs']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['InstanceEnclaveOptionsArgs']]):
        pulumi.set(self, "enclave_options", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @get_password_data.setter
    def get_password_data(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "get_password_data", value)

    @property
    @pulumi.getter
    def hibernation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @hibernation.setter
    def hibernation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "hibernation", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        """
        return pulumi.get(self, "host_resource_group_arn")

    @host_resource_group_arn.setter
    def host_resource_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_resource_group_arn", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @property
    @pulumi.getter(name="instanceMarketOptions")
    def instance_market_options(self) -> Optional[pulumi.Input['InstanceInstanceMarketOptionsArgs']]:
        """
        Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
        """
        return pulumi.get(self, "instance_market_options")

    @instance_market_options.setter
    def instance_market_options(self, value: Optional[pulumi.Input['InstanceInstanceMarketOptionsArgs']]):
        pulumi.set(self, "instance_market_options", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]]:
        """
        Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['InstanceLaunchTemplateArgs']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['InstanceLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> Optional[pulumi.Input['InstanceMaintenanceOptionsArgs']]:
        """
        Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @maintenance_options.setter
    def maintenance_options(self, value: Optional[pulumi.Input['InstanceMaintenanceOptionsArgs']]):
        pulumi.set(self, "maintenance_options", value)

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['InstanceMetadataOptionsArgs']]:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['InstanceMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @placement_partition_number.setter
    def placement_partition_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "placement_partition_number", value)

    @property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']]:
        """
        Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @private_dns_name_options.setter
    def private_dns_name_options(self, value: Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']]):
        pulumi.set(self, "private_dns_name_options", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> Optional[pulumi.Input['InstanceRootBlockDeviceArgs']]:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @root_block_device.setter
    def root_block_device(self, value: Optional[pulumi.Input['InstanceRootBlockDeviceArgs']]):
        pulumi.set(self, "root_block_device", value)

    @property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @secondary_private_ips.setter
    def secondary_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secondary_private_ips", value)

    @property
    @pulumi.getter(name="securityGroups")
    @_utilities.deprecated("""Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group names to associate with.

        > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]]):
        pulumi.set(self, "tenancy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @user_data_base64.setter
    def user_data_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data_base64", value)

    @property
    @pulumi.getter(name="userDataReplaceOnChange")
    def user_data_replace_on_change(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        """
        return pulumi.get(self, "user_data_replace_on_change")

    @user_data_replace_on_change.setter
    def user_data_replace_on_change(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "user_data_replace_on_change", value)

    @property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign, at instance-creation time, to root and EBS volumes.

        > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        """
        return pulumi.get(self, "volume_tags")

    @volume_tags.setter
    def volume_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "volume_tags", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 ami: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']] = None,
                 cpu_options: Optional[pulumi.Input['InstanceCpuOptionsArgs']] = None,
                 credit_specification: Optional[pulumi.Input['InstanceCreditSpecificationArgs']] = None,
                 disable_api_stop: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[builtins.bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 enclave_options: Optional[pulumi.Input['InstanceEnclaveOptionsArgs']] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]] = None,
                 get_password_data: Optional[pulumi.Input[builtins.bool]] = None,
                 hibernation: Optional[pulumi.Input[builtins.bool]] = None,
                 host_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 instance_lifecycle: Optional[pulumi.Input[builtins.str]] = None,
                 instance_market_options: Optional[pulumi.Input['InstanceInstanceMarketOptionsArgs']] = None,
                 instance_state: Optional[pulumi.Input[builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template: Optional[pulumi.Input['InstanceLaunchTemplateArgs']] = None,
                 maintenance_options: Optional[pulumi.Input['InstanceMaintenanceOptionsArgs']] = None,
                 metadata_options: Optional[pulumi.Input['InstanceMetadataOptionsArgs']] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]] = None,
                 outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 password_data: Optional[pulumi.Input[builtins.str]] = None,
                 placement_group: Optional[pulumi.Input[builtins.str]] = None,
                 placement_partition_number: Optional[pulumi.Input[builtins.int]] = None,
                 primary_network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_dns: Optional[pulumi.Input[builtins.str]] = None,
                 private_dns_name_options: Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 public_dns: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_block_device: Optional[pulumi.Input['InstanceRootBlockDeviceArgs']] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_instance_request_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenancy: Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[builtins.str]] = None,
                 user_data_replace_on_change: Optional[pulumi.Input[builtins.bool]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[builtins.str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[builtins.str] arn: ARN of the instance.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[builtins.str] availability_zone: AZ to start the instance in.
        :param pulumi.Input['InstanceCapacityReservationSpecificationArgs'] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input['InstanceCpuOptionsArgs'] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input['InstanceCreditSpecificationArgs'] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        :param pulumi.Input[builtins.bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[builtins.bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        :param pulumi.Input['InstanceEnclaveOptionsArgs'] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[builtins.bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[builtins.bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[builtins.str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[builtins.str] host_resource_group_arn: ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        :param pulumi.Input[builtins.str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[builtins.str] instance_lifecycle: Indicates whether this is a Spot Instance or a Scheduled Instance.
        :param pulumi.Input['InstanceInstanceMarketOptionsArgs'] instance_market_options: Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
        :param pulumi.Input[builtins.str] instance_state: State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
        :param pulumi.Input[Union[builtins.str, 'InstanceType']] instance_type: Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[builtins.int] ipv6_address_count: Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[builtins.str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input['InstanceLaunchTemplateArgs'] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        :param pulumi.Input['InstanceMaintenanceOptionsArgs'] maintenance_options: Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input['InstanceMetadataOptionsArgs'] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[builtins.bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[builtins.str] outpost_arn: ARN of the Outpost the instance is assigned to.
        :param pulumi.Input[builtins.str] password_data: Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[builtins.str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[builtins.int] placement_partition_number: Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[builtins.str] primary_network_interface_id: ID of the instance's primary network interface.
        :param pulumi.Input[builtins.str] private_dns: Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input['InstancePrivateDnsNameOptionsArgs'] private_dns_name_options: Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[builtins.str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[builtins.str] public_dns: Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[builtins.str] public_ip: Public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['InstanceRootBlockDeviceArgs'] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] secondary_private_ips: List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: List of security group names to associate with.
               
               > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        :param pulumi.Input[builtins.bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[builtins.str] spot_instance_request_id: If the request is a Spot Instance request, the ID of the request.
        :param pulumi.Input[builtins.str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union[builtins.str, 'Tenancy']] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        :param pulumi.Input[builtins.str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[builtins.str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[builtins.bool] user_data_replace_on_change: When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] volume_tags: Map of tags to assign, at instance-creation time, to root and EBS volumes.
               
               > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_ids: List of security group IDs to associate with.
        """
        if ami is not None:
            pulumi.set(__self__, "ami", ami)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if capacity_reservation_specification is not None:
            pulumi.set(__self__, "capacity_reservation_specification", capacity_reservation_specification)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if disable_api_stop is not None:
            pulumi.set(__self__, "disable_api_stop", disable_api_stop)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if enable_primary_ipv6 is not None:
            pulumi.set(__self__, "enable_primary_ipv6", enable_primary_ipv6)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if get_password_data is not None:
            pulumi.set(__self__, "get_password_data", get_password_data)
        if hibernation is not None:
            pulumi.set(__self__, "hibernation", hibernation)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if host_resource_group_arn is not None:
            pulumi.set(__self__, "host_resource_group_arn", host_resource_group_arn)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_lifecycle is not None:
            pulumi.set(__self__, "instance_lifecycle", instance_lifecycle)
        if instance_market_options is not None:
            pulumi.set(__self__, "instance_market_options", instance_market_options)
        if instance_state is not None:
            pulumi.set(__self__, "instance_state", instance_state)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if maintenance_options is not None:
            pulumi.set(__self__, "maintenance_options", maintenance_options)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if password_data is not None:
            pulumi.set(__self__, "password_data", password_data)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if placement_partition_number is not None:
            pulumi.set(__self__, "placement_partition_number", placement_partition_number)
        if primary_network_interface_id is not None:
            pulumi.set(__self__, "primary_network_interface_id", primary_network_interface_id)
        if private_dns is not None:
            pulumi.set(__self__, "private_dns", private_dns)
        if private_dns_name_options is not None:
            pulumi.set(__self__, "private_dns_name_options", private_dns_name_options)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_dns is not None:
            pulumi.set(__self__, "public_dns", public_dns)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_block_device is not None:
            pulumi.set(__self__, "root_block_device", root_block_device)
        if secondary_private_ips is not None:
            pulumi.set(__self__, "secondary_private_ips", secondary_private_ips)
        if security_groups is not None:
            warnings.warn("""Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""", DeprecationWarning)
            pulumi.log.warn("""security_groups is deprecated: Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""")
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if spot_instance_request_id is not None:
            pulumi.set(__self__, "spot_instance_request_id", spot_instance_request_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_data_base64 is not None:
            pulumi.set(__self__, "user_data_base64", user_data_base64)
        if user_data_replace_on_change is not None:
            pulumi.set(__self__, "user_data_replace_on_change", user_data_replace_on_change)
        if volume_tags is not None:
            pulumi.set(__self__, "volume_tags", volume_tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter
    def ami(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @ami.setter
    def ami(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ami", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the instance.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']]:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @capacity_reservation_specification.setter
    def capacity_reservation_specification(self, value: Optional[pulumi.Input['InstanceCapacityReservationSpecificationArgs']]):
        pulumi.set(self, "capacity_reservation_specification", value)

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['InstanceCpuOptionsArgs']]:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['InstanceCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['InstanceCreditSpecificationArgs']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['InstanceCreditSpecificationArgs']]):
        pulumi.set(self, "credit_specification", value)

    @property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        """
        return pulumi.get(self, "disable_api_stop")

    @disable_api_stop.setter
    def disable_api_stop(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_api_stop", value)

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @enable_primary_ipv6.setter
    def enable_primary_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_primary_ipv6", value)

    @property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['InstanceEnclaveOptionsArgs']]:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['InstanceEnclaveOptionsArgs']]):
        pulumi.set(self, "enclave_options", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @get_password_data.setter
    def get_password_data(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "get_password_data", value)

    @property
    @pulumi.getter
    def hibernation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @hibernation.setter
    def hibernation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "hibernation", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        """
        return pulumi.get(self, "host_resource_group_arn")

    @host_resource_group_arn.setter
    def host_resource_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_resource_group_arn", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @property
    @pulumi.getter(name="instanceLifecycle")
    def instance_lifecycle(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether this is a Spot Instance or a Scheduled Instance.
        """
        return pulumi.get(self, "instance_lifecycle")

    @instance_lifecycle.setter
    def instance_lifecycle(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_lifecycle", value)

    @property
    @pulumi.getter(name="instanceMarketOptions")
    def instance_market_options(self) -> Optional[pulumi.Input['InstanceInstanceMarketOptionsArgs']]:
        """
        Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
        """
        return pulumi.get(self, "instance_market_options")

    @instance_market_options.setter
    def instance_market_options(self, value: Optional[pulumi.Input['InstanceInstanceMarketOptionsArgs']]):
        pulumi.set(self, "instance_market_options", value)

    @property
    @pulumi.getter(name="instanceState")
    def instance_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
        """
        return pulumi.get(self, "instance_state")

    @instance_state.setter
    def instance_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_state", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]]:
        """
        Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['InstanceLaunchTemplateArgs']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['InstanceLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> Optional[pulumi.Input['InstanceMaintenanceOptionsArgs']]:
        """
        Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @maintenance_options.setter
    def maintenance_options(self, value: Optional[pulumi.Input['InstanceMaintenanceOptionsArgs']]):
        pulumi.set(self, "maintenance_options", value)

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['InstanceMetadataOptionsArgs']]:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['InstanceMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Outpost the instance is assigned to.
        """
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outpost_arn", value)

    @property
    @pulumi.getter(name="passwordData")
    def password_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "password_data")

    @password_data.setter
    def password_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password_data", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @placement_partition_number.setter
    def placement_partition_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "placement_partition_number", value)

    @property
    @pulumi.getter(name="primaryNetworkInterfaceId")
    def primary_network_interface_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the instance's primary network interface.
        """
        return pulumi.get(self, "primary_network_interface_id")

    @primary_network_interface_id.setter
    def primary_network_interface_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_network_interface_id", value)

    @property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "private_dns")

    @private_dns.setter
    def private_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_dns", value)

    @property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']]:
        """
        Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @private_dns_name_options.setter
    def private_dns_name_options(self, value: Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']]):
        pulumi.set(self, "private_dns_name_options", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "public_dns")

    @public_dns.setter
    def public_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_dns", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> Optional[pulumi.Input['InstanceRootBlockDeviceArgs']]:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @root_block_device.setter
    def root_block_device(self, value: Optional[pulumi.Input['InstanceRootBlockDeviceArgs']]):
        pulumi.set(self, "root_block_device", value)

    @property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @secondary_private_ips.setter
    def secondary_private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secondary_private_ips", value)

    @property
    @pulumi.getter(name="securityGroups")
    @_utilities.deprecated("""Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group names to associate with.

        > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter(name="spotInstanceRequestId")
    def spot_instance_request_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the request is a Spot Instance request, the ID of the request.
        """
        return pulumi.get(self, "spot_instance_request_id")

    @spot_instance_request_id.setter
    def spot_instance_request_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_instance_request_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]]):
        pulumi.set(self, "tenancy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @user_data_base64.setter
    def user_data_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_data_base64", value)

    @property
    @pulumi.getter(name="userDataReplaceOnChange")
    def user_data_replace_on_change(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        """
        return pulumi.get(self, "user_data_replace_on_change")

    @user_data_replace_on_change.setter
    def user_data_replace_on_change(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "user_data_replace_on_change", value)

    @property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign, at instance-creation time, to root and EBS volumes.

        > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        """
        return pulumi.get(self, "volume_tags")

    @volume_tags.setter
    def volume_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "volume_tags", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.type_token("aws:ec2/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami: Optional[pulumi.Input[builtins.str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input[Union['InstanceCapacityReservationSpecificationArgs', 'InstanceCapacityReservationSpecificationArgsDict']]] = None,
                 cpu_options: Optional[pulumi.Input[Union['InstanceCpuOptionsArgs', 'InstanceCpuOptionsArgsDict']]] = None,
                 credit_specification: Optional[pulumi.Input[Union['InstanceCreditSpecificationArgs', 'InstanceCreditSpecificationArgsDict']]] = None,
                 disable_api_stop: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[builtins.bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 enclave_options: Optional[pulumi.Input[Union['InstanceEnclaveOptionsArgs', 'InstanceEnclaveOptionsArgsDict']]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]]] = None,
                 get_password_data: Optional[pulumi.Input[builtins.bool]] = None,
                 hibernation: Optional[pulumi.Input[builtins.bool]] = None,
                 host_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 instance_market_options: Optional[pulumi.Input[Union['InstanceInstanceMarketOptionsArgs', 'InstanceInstanceMarketOptionsArgsDict']]] = None,
                 instance_type: Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template: Optional[pulumi.Input[Union['InstanceLaunchTemplateArgs', 'InstanceLaunchTemplateArgsDict']]] = None,
                 maintenance_options: Optional[pulumi.Input[Union['InstanceMaintenanceOptionsArgs', 'InstanceMaintenanceOptionsArgsDict']]] = None,
                 metadata_options: Optional[pulumi.Input[Union['InstanceMetadataOptionsArgs', 'InstanceMetadataOptionsArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]]] = None,
                 placement_group: Optional[pulumi.Input[builtins.str]] = None,
                 placement_partition_number: Optional[pulumi.Input[builtins.int]] = None,
                 private_dns_name_options: Optional[pulumi.Input[Union['InstancePrivateDnsNameOptionsArgs', 'InstancePrivateDnsNameOptionsArgsDict']]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_block_device: Optional[pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenancy: Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[builtins.str]] = None,
                 user_data_replace_on_change: Optional[pulumi.Input[builtins.bool]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an EC2 instance resource. This allows instances to be created, updated, and deleted.

        ## Example Usage

        ### Basic example using AMI lookup

        Using a data source

        ```python
        import pulumi
        import pulumi_aws as aws

        ubuntu = aws.ec2.get_ami(most_recent=True,
            filters=[
                {
                    "name": "name",
                    "values": ["ubuntu/images/hvm-ssd/ubuntu-jammy-22.04-amd64-server-*"],
                },
                {
                    "name": "virtualization-type",
                    "values": ["hvm"],
                },
            ],
            owners=["099720109477"])
        web = aws.ec2.Instance("web",
            ami=ubuntu.id,
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            tags={
                "Name": "HelloWorld",
            })
        ```

        Using AWS Systems Manager Parameter Store

        ```python
        import pulumi
        import pulumi_aws as aws

        web = aws.ec2.Instance("web",
            ami="resolve:ssm:/aws/service/ami-amazon-linux-latest/al2023-ami-kernel-default-x86_64",
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            tags={
                "Name": "HelloWorld",
            })
        ```

        ### Spot instance example

        ```python
        import pulumi
        import pulumi_aws as aws

        this = aws.ec2.get_ami(most_recent=True,
            owners=["amazon"],
            filters=[
                {
                    "name": "architecture",
                    "values": ["arm64"],
                },
                {
                    "name": "name",
                    "values": ["al2023-ami-2023*"],
                },
            ])
        this_instance = aws.ec2.Instance("this",
            ami=this.id,
            instance_market_options={
                "market_type": "spot",
                "spot_options": {
                    "max_price": "0.0031",
                },
            },
            instance_type=aws.ec2.InstanceType.T4G_NANO,
            tags={
                "Name": "test-spot",
            })
        ```

        ### Network and credit specification example

        ```python
        import pulumi
        import pulumi_aws as aws

        my_vpc = aws.ec2.Vpc("my_vpc",
            cidr_block="172.16.0.0/16",
            tags={
                "Name": "tf-example",
            })
        my_subnet = aws.ec2.Subnet("my_subnet",
            vpc_id=my_vpc.id,
            cidr_block="172.16.10.0/24",
            availability_zone="us-west-2a",
            tags={
                "Name": "tf-example",
            })
        foo = aws.ec2.NetworkInterface("foo",
            subnet_id=my_subnet.id,
            private_ips=["172.16.10.100"],
            tags={
                "Name": "primary_network_interface",
            })
        foo_instance = aws.ec2.Instance("foo",
            ami="ami-005e54dee72cc1d00",
            instance_type=aws.ec2.InstanceType.T2_MICRO,
            network_interfaces=[{
                "network_interface_id": foo.id,
                "device_index": 0,
            }],
            credit_specification={
                "cpu_credits": "unlimited",
            })
        ```

        ### CPU options example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.Vpc("example",
            cidr_block="172.16.0.0/16",
            tags={
                "Name": "tf-example",
            })
        example_subnet = aws.ec2.Subnet("example",
            vpc_id=example.id,
            cidr_block="172.16.10.0/24",
            availability_zone="us-east-2a",
            tags={
                "Name": "tf-example",
            })
        amzn_linux_2023_ami = aws.ec2.get_ami(most_recent=True,
            owners=["amazon"],
            filters=[{
                "name": "name",
                "values": ["al2023-ami-2023.*-x86_64"],
            }])
        example_instance = aws.ec2.Instance("example",
            ami=amzn_linux_2023_ami.id,
            instance_type=aws.ec2.InstanceType.C6A_2_X_LARGE,
            subnet_id=example_subnet.id,
            cpu_options={
                "core_count": 2,
                "threads_per_core": 2,
            },
            tags={
                "Name": "tf-example",
            })
        ```

        ### Host resource group or License Manager registered AMI example

        A host resource group is a collection of Dedicated Hosts that you can manage as a single entity. As you launch instances, License Manager allocates the hosts and launches instances on them based on the settings that you configured. You can add existing Dedicated Hosts to a host resource group and take advantage of automated host management through License Manager.

        > **NOTE:** A dedicated host is automatically associated with a License Manager host resource group if **Allocate hosts automatically** is enabled. Otherwise, use the `host_resource_group_arn` argument to explicitly associate the instance with the host resource group.

        ```python
        import pulumi
        import pulumi_aws as aws

        this = aws.ec2.Instance("this",
            ami="ami-0dcc1e21636832c5d",
            instance_type=aws.ec2.InstanceType.M5_LARGE,
            host_resource_group_arn="arn:aws:resource-groups:us-west-2:123456789012:group/win-testhost",
            tenancy="host")
        ```

        ## Tag Guide

        These are the five types of tags you might encounter relative to an `ec2.Instance`:

        1. **Instance tags**: Applied to instances but not to `ebs_block_device` and `root_block_device` volumes.
        2. **Default tags**: Applied to the instance and to `ebs_block_device` and `root_block_device` volumes.
        3. **Volume tags**: Applied during creation to `ebs_block_device` and `root_block_device` volumes.
        4. **Root block device tags**: Applied only to the `root_block_device` volume. These conflict with `volume_tags`.
        5. **EBS block device tags**: Applied only to the specific `ebs_block_device` volume you configure them for and cannot be updated. These conflict with `volume_tags`.

        Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.

        ## Import

        Using `pulumi import`, import instances using the `id`. For example:

        ```sh
        $ pulumi import aws:ec2/instance:Instance web i-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[builtins.str] availability_zone: AZ to start the instance in.
        :param pulumi.Input[Union['InstanceCapacityReservationSpecificationArgs', 'InstanceCapacityReservationSpecificationArgsDict']] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[Union['InstanceCpuOptionsArgs', 'InstanceCpuOptionsArgsDict']] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input[Union['InstanceCreditSpecificationArgs', 'InstanceCreditSpecificationArgsDict']] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        :param pulumi.Input[builtins.bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[builtins.bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        :param pulumi.Input[Union['InstanceEnclaveOptionsArgs', 'InstanceEnclaveOptionsArgsDict']] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[builtins.bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[builtins.bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[builtins.str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[builtins.str] host_resource_group_arn: ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        :param pulumi.Input[builtins.str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[Union['InstanceInstanceMarketOptionsArgs', 'InstanceInstanceMarketOptionsArgsDict']] instance_market_options: Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
        :param pulumi.Input[Union[builtins.str, 'InstanceType']] instance_type: Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[builtins.int] ipv6_address_count: Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[builtins.str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input[Union['InstanceLaunchTemplateArgs', 'InstanceLaunchTemplateArgsDict']] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        :param pulumi.Input[Union['InstanceMaintenanceOptionsArgs', 'InstanceMaintenanceOptionsArgsDict']] maintenance_options: Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input[Union['InstanceMetadataOptionsArgs', 'InstanceMetadataOptionsArgsDict']] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[builtins.bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[builtins.str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[builtins.int] placement_partition_number: Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[Union['InstancePrivateDnsNameOptionsArgs', 'InstancePrivateDnsNameOptionsArgsDict']] private_dns_name_options: Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[builtins.str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] secondary_private_ips: List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: List of security group names to associate with.
               
               > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        :param pulumi.Input[builtins.bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[builtins.str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union[builtins.str, 'Tenancy']] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        :param pulumi.Input[builtins.str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[builtins.str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[builtins.bool] user_data_replace_on_change: When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] volume_tags: Map of tags to assign, at instance-creation time, to root and EBS volumes.
               
               > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_ids: List of security group IDs to associate with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EC2 instance resource. This allows instances to be created, updated, and deleted.

        ## Example Usage

        ### Basic example using AMI lookup

        Using a data source

        ```python
        import pulumi
        import pulumi_aws as aws

        ubuntu = aws.ec2.get_ami(most_recent=True,
            filters=[
                {
                    "name": "name",
                    "values": ["ubuntu/images/hvm-ssd/ubuntu-jammy-22.04-amd64-server-*"],
                },
                {
                    "name": "virtualization-type",
                    "values": ["hvm"],
                },
            ],
            owners=["099720109477"])
        web = aws.ec2.Instance("web",
            ami=ubuntu.id,
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            tags={
                "Name": "HelloWorld",
            })
        ```

        Using AWS Systems Manager Parameter Store

        ```python
        import pulumi
        import pulumi_aws as aws

        web = aws.ec2.Instance("web",
            ami="resolve:ssm:/aws/service/ami-amazon-linux-latest/al2023-ami-kernel-default-x86_64",
            instance_type=aws.ec2.InstanceType.T3_MICRO,
            tags={
                "Name": "HelloWorld",
            })
        ```

        ### Spot instance example

        ```python
        import pulumi
        import pulumi_aws as aws

        this = aws.ec2.get_ami(most_recent=True,
            owners=["amazon"],
            filters=[
                {
                    "name": "architecture",
                    "values": ["arm64"],
                },
                {
                    "name": "name",
                    "values": ["al2023-ami-2023*"],
                },
            ])
        this_instance = aws.ec2.Instance("this",
            ami=this.id,
            instance_market_options={
                "market_type": "spot",
                "spot_options": {
                    "max_price": "0.0031",
                },
            },
            instance_type=aws.ec2.InstanceType.T4G_NANO,
            tags={
                "Name": "test-spot",
            })
        ```

        ### Network and credit specification example

        ```python
        import pulumi
        import pulumi_aws as aws

        my_vpc = aws.ec2.Vpc("my_vpc",
            cidr_block="172.16.0.0/16",
            tags={
                "Name": "tf-example",
            })
        my_subnet = aws.ec2.Subnet("my_subnet",
            vpc_id=my_vpc.id,
            cidr_block="172.16.10.0/24",
            availability_zone="us-west-2a",
            tags={
                "Name": "tf-example",
            })
        foo = aws.ec2.NetworkInterface("foo",
            subnet_id=my_subnet.id,
            private_ips=["172.16.10.100"],
            tags={
                "Name": "primary_network_interface",
            })
        foo_instance = aws.ec2.Instance("foo",
            ami="ami-005e54dee72cc1d00",
            instance_type=aws.ec2.InstanceType.T2_MICRO,
            network_interfaces=[{
                "network_interface_id": foo.id,
                "device_index": 0,
            }],
            credit_specification={
                "cpu_credits": "unlimited",
            })
        ```

        ### CPU options example

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.Vpc("example",
            cidr_block="172.16.0.0/16",
            tags={
                "Name": "tf-example",
            })
        example_subnet = aws.ec2.Subnet("example",
            vpc_id=example.id,
            cidr_block="172.16.10.0/24",
            availability_zone="us-east-2a",
            tags={
                "Name": "tf-example",
            })
        amzn_linux_2023_ami = aws.ec2.get_ami(most_recent=True,
            owners=["amazon"],
            filters=[{
                "name": "name",
                "values": ["al2023-ami-2023.*-x86_64"],
            }])
        example_instance = aws.ec2.Instance("example",
            ami=amzn_linux_2023_ami.id,
            instance_type=aws.ec2.InstanceType.C6A_2_X_LARGE,
            subnet_id=example_subnet.id,
            cpu_options={
                "core_count": 2,
                "threads_per_core": 2,
            },
            tags={
                "Name": "tf-example",
            })
        ```

        ### Host resource group or License Manager registered AMI example

        A host resource group is a collection of Dedicated Hosts that you can manage as a single entity. As you launch instances, License Manager allocates the hosts and launches instances on them based on the settings that you configured. You can add existing Dedicated Hosts to a host resource group and take advantage of automated host management through License Manager.

        > **NOTE:** A dedicated host is automatically associated with a License Manager host resource group if **Allocate hosts automatically** is enabled. Otherwise, use the `host_resource_group_arn` argument to explicitly associate the instance with the host resource group.

        ```python
        import pulumi
        import pulumi_aws as aws

        this = aws.ec2.Instance("this",
            ami="ami-0dcc1e21636832c5d",
            instance_type=aws.ec2.InstanceType.M5_LARGE,
            host_resource_group_arn="arn:aws:resource-groups:us-west-2:123456789012:group/win-testhost",
            tenancy="host")
        ```

        ## Tag Guide

        These are the five types of tags you might encounter relative to an `ec2.Instance`:

        1. **Instance tags**: Applied to instances but not to `ebs_block_device` and `root_block_device` volumes.
        2. **Default tags**: Applied to the instance and to `ebs_block_device` and `root_block_device` volumes.
        3. **Volume tags**: Applied during creation to `ebs_block_device` and `root_block_device` volumes.
        4. **Root block device tags**: Applied only to the `root_block_device` volume. These conflict with `volume_tags`.
        5. **EBS block device tags**: Applied only to the specific `ebs_block_device` volume you configure them for and cannot be updated. These conflict with `volume_tags`.

        Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.

        ## Import

        Using `pulumi import`, import instances using the `id`. For example:

        ```sh
        $ pulumi import aws:ec2/instance:Instance web i-12345678
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami: Optional[pulumi.Input[builtins.str]] = None,
                 associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_reservation_specification: Optional[pulumi.Input[Union['InstanceCapacityReservationSpecificationArgs', 'InstanceCapacityReservationSpecificationArgsDict']]] = None,
                 cpu_options: Optional[pulumi.Input[Union['InstanceCpuOptionsArgs', 'InstanceCpuOptionsArgsDict']]] = None,
                 credit_specification: Optional[pulumi.Input[Union['InstanceCreditSpecificationArgs', 'InstanceCreditSpecificationArgsDict']]] = None,
                 disable_api_stop: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_api_termination: Optional[pulumi.Input[builtins.bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 enclave_options: Optional[pulumi.Input[Union['InstanceEnclaveOptionsArgs', 'InstanceEnclaveOptionsArgsDict']]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]]] = None,
                 get_password_data: Optional[pulumi.Input[builtins.bool]] = None,
                 hibernation: Optional[pulumi.Input[builtins.bool]] = None,
                 host_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 instance_market_options: Optional[pulumi.Input[Union['InstanceInstanceMarketOptionsArgs', 'InstanceInstanceMarketOptionsArgsDict']]] = None,
                 instance_type: Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template: Optional[pulumi.Input[Union['InstanceLaunchTemplateArgs', 'InstanceLaunchTemplateArgsDict']]] = None,
                 maintenance_options: Optional[pulumi.Input[Union['InstanceMaintenanceOptionsArgs', 'InstanceMaintenanceOptionsArgsDict']]] = None,
                 metadata_options: Optional[pulumi.Input[Union['InstanceMetadataOptionsArgs', 'InstanceMetadataOptionsArgsDict']]] = None,
                 monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]]] = None,
                 placement_group: Optional[pulumi.Input[builtins.str]] = None,
                 placement_partition_number: Optional[pulumi.Input[builtins.int]] = None,
                 private_dns_name_options: Optional[pulumi.Input[Union['InstancePrivateDnsNameOptionsArgs', 'InstancePrivateDnsNameOptionsArgsDict']]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 root_block_device: Optional[pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']]] = None,
                 secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenancy: Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]] = None,
                 user_data: Optional[pulumi.Input[builtins.str]] = None,
                 user_data_base64: Optional[pulumi.Input[builtins.str]] = None,
                 user_data_replace_on_change: Optional[pulumi.Input[builtins.bool]] = None,
                 volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["ami"] = ami
            __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["capacity_reservation_specification"] = capacity_reservation_specification
            __props__.__dict__["cpu_options"] = cpu_options
            __props__.__dict__["credit_specification"] = credit_specification
            __props__.__dict__["disable_api_stop"] = disable_api_stop
            __props__.__dict__["disable_api_termination"] = disable_api_termination
            __props__.__dict__["ebs_block_devices"] = ebs_block_devices
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["enable_primary_ipv6"] = enable_primary_ipv6
            __props__.__dict__["enclave_options"] = enclave_options
            __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
            __props__.__dict__["get_password_data"] = get_password_data
            __props__.__dict__["hibernation"] = hibernation
            __props__.__dict__["host_id"] = host_id
            __props__.__dict__["host_resource_group_arn"] = host_resource_group_arn
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
            __props__.__dict__["instance_market_options"] = instance_market_options
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["maintenance_options"] = maintenance_options
            __props__.__dict__["metadata_options"] = metadata_options
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["placement_group"] = placement_group
            __props__.__dict__["placement_partition_number"] = placement_partition_number
            __props__.__dict__["private_dns_name_options"] = private_dns_name_options
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["region"] = region
            __props__.__dict__["root_block_device"] = root_block_device
            __props__.__dict__["secondary_private_ips"] = secondary_private_ips
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["source_dest_check"] = source_dest_check
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenancy"] = tenancy
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["user_data_base64"] = user_data_base64
            __props__.__dict__["user_data_replace_on_change"] = user_data_replace_on_change
            __props__.__dict__["volume_tags"] = volume_tags
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["arn"] = None
            __props__.__dict__["instance_lifecycle"] = None
            __props__.__dict__["instance_state"] = None
            __props__.__dict__["outpost_arn"] = None
            __props__.__dict__["password_data"] = None
            __props__.__dict__["primary_network_interface_id"] = None
            __props__.__dict__["private_dns"] = None
            __props__.__dict__["public_dns"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["spot_instance_request_id"] = None
            __props__.__dict__["tags_all"] = None
        super(Instance, __self__).__init__(
            'aws:ec2/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ami: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
            availability_zone: Optional[pulumi.Input[builtins.str]] = None,
            capacity_reservation_specification: Optional[pulumi.Input[Union['InstanceCapacityReservationSpecificationArgs', 'InstanceCapacityReservationSpecificationArgsDict']]] = None,
            cpu_options: Optional[pulumi.Input[Union['InstanceCpuOptionsArgs', 'InstanceCpuOptionsArgsDict']]] = None,
            credit_specification: Optional[pulumi.Input[Union['InstanceCreditSpecificationArgs', 'InstanceCreditSpecificationArgsDict']]] = None,
            disable_api_stop: Optional[pulumi.Input[builtins.bool]] = None,
            disable_api_termination: Optional[pulumi.Input[builtins.bool]] = None,
            ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]]] = None,
            ebs_optimized: Optional[pulumi.Input[builtins.bool]] = None,
            enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
            enclave_options: Optional[pulumi.Input[Union['InstanceEnclaveOptionsArgs', 'InstanceEnclaveOptionsArgsDict']]] = None,
            ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]]] = None,
            get_password_data: Optional[pulumi.Input[builtins.bool]] = None,
            hibernation: Optional[pulumi.Input[builtins.bool]] = None,
            host_id: Optional[pulumi.Input[builtins.str]] = None,
            host_resource_group_arn: Optional[pulumi.Input[builtins.str]] = None,
            iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
            instance_initiated_shutdown_behavior: Optional[pulumi.Input[builtins.str]] = None,
            instance_lifecycle: Optional[pulumi.Input[builtins.str]] = None,
            instance_market_options: Optional[pulumi.Input[Union['InstanceInstanceMarketOptionsArgs', 'InstanceInstanceMarketOptionsArgsDict']]] = None,
            instance_state: Optional[pulumi.Input[builtins.str]] = None,
            instance_type: Optional[pulumi.Input[Union[builtins.str, 'InstanceType']]] = None,
            ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            key_name: Optional[pulumi.Input[builtins.str]] = None,
            launch_template: Optional[pulumi.Input[Union['InstanceLaunchTemplateArgs', 'InstanceLaunchTemplateArgsDict']]] = None,
            maintenance_options: Optional[pulumi.Input[Union['InstanceMaintenanceOptionsArgs', 'InstanceMaintenanceOptionsArgsDict']]] = None,
            metadata_options: Optional[pulumi.Input[Union['InstanceMetadataOptionsArgs', 'InstanceMetadataOptionsArgsDict']]] = None,
            monitoring: Optional[pulumi.Input[builtins.bool]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]]] = None,
            outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
            password_data: Optional[pulumi.Input[builtins.str]] = None,
            placement_group: Optional[pulumi.Input[builtins.str]] = None,
            placement_partition_number: Optional[pulumi.Input[builtins.int]] = None,
            primary_network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
            private_dns: Optional[pulumi.Input[builtins.str]] = None,
            private_dns_name_options: Optional[pulumi.Input[Union['InstancePrivateDnsNameOptionsArgs', 'InstancePrivateDnsNameOptionsArgsDict']]] = None,
            private_ip: Optional[pulumi.Input[builtins.str]] = None,
            public_dns: Optional[pulumi.Input[builtins.str]] = None,
            public_ip: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            root_block_device: Optional[pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']]] = None,
            secondary_private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
            spot_instance_request_id: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tenancy: Optional[pulumi.Input[Union[builtins.str, 'Tenancy']]] = None,
            user_data: Optional[pulumi.Input[builtins.str]] = None,
            user_data_base64: Optional[pulumi.Input[builtins.str]] = None,
            user_data_replace_on_change: Optional[pulumi.Input[builtins.bool]] = None,
            volume_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ami: AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        :param pulumi.Input[builtins.str] arn: ARN of the instance.
        :param pulumi.Input[builtins.bool] associate_public_ip_address: Whether to associate a public IP address with an instance in a VPC.
        :param pulumi.Input[builtins.str] availability_zone: AZ to start the instance in.
        :param pulumi.Input[Union['InstanceCapacityReservationSpecificationArgs', 'InstanceCapacityReservationSpecificationArgsDict']] capacity_reservation_specification: Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        :param pulumi.Input[Union['InstanceCpuOptionsArgs', 'InstanceCpuOptionsArgsDict']] cpu_options: The CPU options for the instance. See CPU Options below for more details.
        :param pulumi.Input[Union['InstanceCreditSpecificationArgs', 'InstanceCreditSpecificationArgsDict']] credit_specification: Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        :param pulumi.Input[builtins.bool] disable_api_stop: If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        :param pulumi.Input[builtins.bool] disable_api_termination: If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]] ebs_block_devices: One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[builtins.bool] ebs_optimized: If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        :param pulumi.Input[Union['InstanceEnclaveOptionsArgs', 'InstanceEnclaveOptionsArgsDict']] enclave_options: Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        :param pulumi.Input[builtins.bool] get_password_data: If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[builtins.bool] hibernation: If true, the launched EC2 instance will support hibernation.
        :param pulumi.Input[builtins.str] host_id: ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        :param pulumi.Input[builtins.str] host_resource_group_arn: ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        :param pulumi.Input[builtins.str] iam_instance_profile: IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        :param pulumi.Input[builtins.str] instance_initiated_shutdown_behavior: Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        :param pulumi.Input[builtins.str] instance_lifecycle: Indicates whether this is a Spot Instance or a Scheduled Instance.
        :param pulumi.Input[Union['InstanceInstanceMarketOptionsArgs', 'InstanceInstanceMarketOptionsArgsDict']] instance_market_options: Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
        :param pulumi.Input[builtins.str] instance_state: State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
        :param pulumi.Input[Union[builtins.str, 'InstanceType']] instance_type: Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        :param pulumi.Input[builtins.int] ipv6_address_count: Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_addresses: Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        :param pulumi.Input[builtins.str] key_name: Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        :param pulumi.Input[Union['InstanceLaunchTemplateArgs', 'InstanceLaunchTemplateArgsDict']] launch_template: Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        :param pulumi.Input[Union['InstanceMaintenanceOptionsArgs', 'InstanceMaintenanceOptionsArgsDict']] maintenance_options: Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        :param pulumi.Input[Union['InstanceMetadataOptionsArgs', 'InstanceMetadataOptionsArgsDict']] metadata_options: Customize the metadata options of the instance. See Metadata Options below for more details.
        :param pulumi.Input[builtins.bool] monitoring: If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]] network_interfaces: Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        :param pulumi.Input[builtins.str] outpost_arn: ARN of the Outpost the instance is assigned to.
        :param pulumi.Input[builtins.str] password_data: Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        :param pulumi.Input[builtins.str] placement_group: Placement Group to start the instance in.
        :param pulumi.Input[builtins.int] placement_partition_number: Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        :param pulumi.Input[builtins.str] primary_network_interface_id: ID of the instance's primary network interface.
        :param pulumi.Input[builtins.str] private_dns: Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[Union['InstancePrivateDnsNameOptionsArgs', 'InstancePrivateDnsNameOptionsArgsDict']] private_dns_name_options: Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        :param pulumi.Input[builtins.str] private_ip: Private IP address to associate with the instance in a VPC.
        :param pulumi.Input[builtins.str] public_dns: Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[builtins.str] public_ip: Public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']] root_block_device: Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] secondary_private_ips: List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: List of security group names to associate with.
               
               > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        :param pulumi.Input[builtins.bool] source_dest_check: Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        :param pulumi.Input[builtins.str] spot_instance_request_id: If the request is a Spot Instance request, the ID of the request.
        :param pulumi.Input[builtins.str] subnet_id: VPC Subnet ID to launch in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union[builtins.str, 'Tenancy']] tenancy: Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        :param pulumi.Input[builtins.str] user_data: User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[builtins.str] user_data_base64: Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        :param pulumi.Input[builtins.bool] user_data_replace_on_change: When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] volume_tags: Map of tags to assign, at instance-creation time, to root and EBS volumes.
               
               > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_ids: List of security group IDs to associate with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["ami"] = ami
        __props__.__dict__["arn"] = arn
        __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["capacity_reservation_specification"] = capacity_reservation_specification
        __props__.__dict__["cpu_options"] = cpu_options
        __props__.__dict__["credit_specification"] = credit_specification
        __props__.__dict__["disable_api_stop"] = disable_api_stop
        __props__.__dict__["disable_api_termination"] = disable_api_termination
        __props__.__dict__["ebs_block_devices"] = ebs_block_devices
        __props__.__dict__["ebs_optimized"] = ebs_optimized
        __props__.__dict__["enable_primary_ipv6"] = enable_primary_ipv6
        __props__.__dict__["enclave_options"] = enclave_options
        __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__.__dict__["get_password_data"] = get_password_data
        __props__.__dict__["hibernation"] = hibernation
        __props__.__dict__["host_id"] = host_id
        __props__.__dict__["host_resource_group_arn"] = host_resource_group_arn
        __props__.__dict__["iam_instance_profile"] = iam_instance_profile
        __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
        __props__.__dict__["instance_lifecycle"] = instance_lifecycle
        __props__.__dict__["instance_market_options"] = instance_market_options
        __props__.__dict__["instance_state"] = instance_state
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["launch_template"] = launch_template
        __props__.__dict__["maintenance_options"] = maintenance_options
        __props__.__dict__["metadata_options"] = metadata_options
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["outpost_arn"] = outpost_arn
        __props__.__dict__["password_data"] = password_data
        __props__.__dict__["placement_group"] = placement_group
        __props__.__dict__["placement_partition_number"] = placement_partition_number
        __props__.__dict__["primary_network_interface_id"] = primary_network_interface_id
        __props__.__dict__["private_dns"] = private_dns
        __props__.__dict__["private_dns_name_options"] = private_dns_name_options
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_dns"] = public_dns
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["root_block_device"] = root_block_device
        __props__.__dict__["secondary_private_ips"] = secondary_private_ips
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["source_dest_check"] = source_dest_check
        __props__.__dict__["spot_instance_request_id"] = spot_instance_request_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tenancy"] = tenancy
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["user_data_base64"] = user_data_base64
        __props__.__dict__["user_data_replace_on_change"] = user_data_replace_on_change
        __props__.__dict__["volume_tags"] = volume_tags
        __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ami(self) -> pulumi.Output[builtins.str]:
        """
        AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
        """
        return pulumi.get(self, "ami")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the instance.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to associate a public IP address with an instance in a VPC.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[builtins.str]:
        """
        AZ to start the instance in.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="capacityReservationSpecification")
    def capacity_reservation_specification(self) -> pulumi.Output['outputs.InstanceCapacityReservationSpecification']:
        """
        Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
        """
        return pulumi.get(self, "capacity_reservation_specification")

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> pulumi.Output['outputs.InstanceCpuOptions']:
        """
        The CPU options for the instance. See CPU Options below for more details.
        """
        return pulumi.get(self, "cpu_options")

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> pulumi.Output[Optional['outputs.InstanceCreditSpecification']]:
        """
        Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
        """
        return pulumi.get(self, "credit_specification")

    @property
    @pulumi.getter(name="disableApiStop")
    def disable_api_stop(self) -> pulumi.Output[builtins.bool]:
        """
        If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
        """
        return pulumi.get(self, "disable_api_stop")

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> pulumi.Output[builtins.bool]:
        """
        If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
        """
        return pulumi.get(self, "disable_api_termination")

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> pulumi.Output[Sequence['outputs.InstanceEbsBlockDevice']]:
        """
        One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ebs_block_devices")

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[builtins.bool]:
        """
        If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
        """
        return pulumi.get(self, "ebs_optimized")

    @property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to assign a primary IPv6 Global Unicast Address (GUA) to the instance when launched in a dual-stack or IPv6-only subnet. A primary IPv6 address ensures a consistent IPv6 address for the instance and is automatically assigned by AWS to the ENI. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains until the instance is terminated or the ENI is detached. Disabling `enable_primary_ipv6` after it has been enabled forces recreation of the instance.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> pulumi.Output['outputs.InstanceEnclaveOptions']:
        """
        Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
        """
        return pulumi.get(self, "enclave_options")

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> pulumi.Output[Sequence['outputs.InstanceEphemeralBlockDevice']]:
        """
        One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @property
    @pulumi.getter(name="getPasswordData")
    def get_password_data(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "get_password_data")

    @property
    @pulumi.getter
    def hibernation(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, the launched EC2 instance will support hibernation.
        """
        return pulumi.get(self, "hibernation")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
        """
        return pulumi.get(self, "host_resource_group_arn")

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[builtins.str]:
        """
        IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
        """
        return pulumi.get(self, "iam_instance_profile")

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> pulumi.Output[builtins.str]:
        """
        Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @property
    @pulumi.getter(name="instanceLifecycle")
    def instance_lifecycle(self) -> pulumi.Output[builtins.str]:
        """
        Indicates whether this is a Spot Instance or a Scheduled Instance.
        """
        return pulumi.get(self, "instance_lifecycle")

    @property
    @pulumi.getter(name="instanceMarketOptions")
    def instance_market_options(self) -> pulumi.Output['outputs.InstanceInstanceMarketOptions']:
        """
        Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
        """
        return pulumi.get(self, "instance_market_options")

    @property
    @pulumi.getter(name="instanceState")
    def instance_state(self) -> pulumi.Output[builtins.str]:
        """
        State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
        """
        return pulumi.get(self, "instance_state")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[builtins.str]:
        """
        Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[builtins.str]:
        """
        Key name of the Key Pair to use for the instance; which can be managed using the `ec2.KeyPair` resource.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output[Optional['outputs.InstanceLaunchTemplate']]:
        """
        Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="maintenanceOptions")
    def maintenance_options(self) -> pulumi.Output['outputs.InstanceMaintenanceOptions']:
        """
        Maintenance and recovery options for the instance. See Maintenance Options below for more details.
        """
        return pulumi.get(self, "maintenance_options")

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> pulumi.Output['outputs.InstanceMetadataOptions']:
        """
        Customize the metadata options of the instance. See Metadata Options below for more details.
        """
        return pulumi.get(self, "metadata_options")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[builtins.bool]:
        """
        If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.InstanceNetworkInterface']]:
        """
        Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Outpost the instance is assigned to.
        """
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter(name="passwordData")
    def password_data(self) -> pulumi.Output[builtins.str]:
        """
        Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
        """
        return pulumi.get(self, "password_data")

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> pulumi.Output[builtins.str]:
        """
        Placement Group to start the instance in.
        """
        return pulumi.get(self, "placement_group")

    @property
    @pulumi.getter(name="placementPartitionNumber")
    def placement_partition_number(self) -> pulumi.Output[builtins.int]:
        """
        Number of the partition the instance is in. Valid only if the `ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
        """
        return pulumi.get(self, "placement_partition_number")

    @property
    @pulumi.getter(name="primaryNetworkInterfaceId")
    def primary_network_interface_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the instance's primary network interface.
        """
        return pulumi.get(self, "primary_network_interface_id")

    @property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "private_dns")

    @property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> pulumi.Output['outputs.InstancePrivateDnsNameOptions']:
        """
        Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
        """
        return pulumi.get(self, "private_dns_name_options")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[builtins.str]:
        """
        Private IP address to associate with the instance in a VPC.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> pulumi.Output[builtins.str]:
        """
        Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "public_dns")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[builtins.str]:
        """
        Public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootBlockDevice")
    def root_block_device(self) -> pulumi.Output['outputs.InstanceRootBlockDevice']:
        """
        Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
        """
        return pulumi.get(self, "root_block_device")

    @property
    @pulumi.getter(name="secondaryPrivateIps")
    def secondary_private_ips(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
        """
        return pulumi.get(self, "secondary_private_ips")

    @property
    @pulumi.getter(name="securityGroups")
    @_utilities.deprecated("""Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.""")
    def security_groups(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of security group names to associate with.

        > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
        """
        return pulumi.get(self, "source_dest_check")

    @property
    @pulumi.getter(name="spotInstanceRequestId")
    def spot_instance_request_id(self) -> pulumi.Output[builtins.str]:
        """
        If the request is a Spot Instance request, the ID of the request.
        """
        return pulumi.get(self, "spot_instance_request_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        VPC Subnet ID to launch in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def tenancy(self) -> pulumi.Output[builtins.str]:
        """
        Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
        """
        return pulumi.get(self, "tenancy")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="userDataBase64")
    def user_data_base64(self) -> pulumi.Output[builtins.str]:
        """
        Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate of the EC2 instance.
        """
        return pulumi.get(self, "user_data_base64")

    @property
    @pulumi.getter(name="userDataReplaceOnChange")
    def user_data_replace_on_change(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate of the EC2 instance when set to `true`. Defaults to `false` if not set.
        """
        return pulumi.get(self, "user_data_replace_on_change")

    @property
    @pulumi.getter(name="volumeTags")
    def volume_tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign, at instance-creation time, to root and EBS volumes.

        > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `ec2.Instance` configuration, such as using `tags` in an `ebs.Volume` resource attached via `ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
        """
        return pulumi.get(self, "volume_tags")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of security group IDs to associate with.
        """
        return pulumi.get(self, "vpc_security_group_ids")

