# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkInterfaceArgs', 'NetworkInterface']

@pulumi.input_type
class NetworkInterfaceArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[builtins.str],
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceAttachmentArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 interface_type: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_address_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv6_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 private_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ips_count: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkInterface resource.
        :param pulumi.Input[builtins.str] subnet_id: Subnet ID to create the ENI in.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceAttachmentArgs']]] attachments: Configuration block to define the attachment of the ENI. See Attachment below for more details!
        :param pulumi.Input[builtins.str] description: Description for the network interface.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: Enables assigning a primary IPv6 Global Unicast Address (GUA) to the network interface (ENI) in dual-stack or IPv6-only subnets. This ensures the instance attached to the ENI retains a consistent IPv6 address. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains assigned until the instance is terminated or the ENI is detached. Enabling and subsequent disabling forces recreation of the ENI.
        :param pulumi.Input[builtins.str] interface_type: Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
        :param pulumi.Input[builtins.int] ipv4_prefix_count: Number of IPv4 prefixes that AWS automatically assigns to the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv4_prefixes: One or more IPv4 prefixes assigned to the network interface.
        :param pulumi.Input[builtins.int] ipv6_address_count: Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
        :param pulumi.Input[builtins.bool] ipv6_address_list_enabled: Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_address_lists: List of private IPs to assign to the ENI in sequential order.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_addresses: One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
        :param pulumi.Input[builtins.int] ipv6_prefix_count: Number of IPv6 prefixes that AWS automatically assigns to the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_prefixes: One or more IPv6 prefixes assigned to the network interface.
        :param pulumi.Input[builtins.bool] private_ip_list_enabled: Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] private_ip_lists: List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] private_ips: List of private IPs to assign to the ENI without regard to order.
        :param pulumi.Input[builtins.int] private_ips_count: Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: List of security group IDs to assign to the ENI.
        :param pulumi.Input[builtins.bool] source_dest_check: Whether to enable source destination checking for the ENI. Default true.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_primary_ipv6 is not None:
            pulumi.set(__self__, "enable_primary_ipv6", enable_primary_ipv6)
        if interface_type is not None:
            pulumi.set(__self__, "interface_type", interface_type)
        if ipv4_prefix_count is not None:
            pulumi.set(__self__, "ipv4_prefix_count", ipv4_prefix_count)
        if ipv4_prefixes is not None:
            pulumi.set(__self__, "ipv4_prefixes", ipv4_prefixes)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_address_list_enabled is not None:
            pulumi.set(__self__, "ipv6_address_list_enabled", ipv6_address_list_enabled)
        if ipv6_address_lists is not None:
            pulumi.set(__self__, "ipv6_address_lists", ipv6_address_lists)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if ipv6_prefix_count is not None:
            pulumi.set(__self__, "ipv6_prefix_count", ipv6_prefix_count)
        if ipv6_prefixes is not None:
            pulumi.set(__self__, "ipv6_prefixes", ipv6_prefixes)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_list_enabled is not None:
            pulumi.set(__self__, "private_ip_list_enabled", private_ip_list_enabled)
        if private_ip_lists is not None:
            pulumi.set(__self__, "private_ip_lists", private_ip_lists)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_ips_count is not None:
            pulumi.set(__self__, "private_ips_count", private_ips_count)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        Subnet ID to create the ENI in.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceAttachmentArgs']]]]:
        """
        Configuration block to define the attachment of the ENI. See Attachment below for more details!
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the network interface.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables assigning a primary IPv6 Global Unicast Address (GUA) to the network interface (ENI) in dual-stack or IPv6-only subnets. This ensures the instance attached to the ENI retains a consistent IPv6 address. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains assigned until the instance is terminated or the ENI is detached. Enabling and subsequent disabling forces recreation of the ENI.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @enable_primary_ipv6.setter
    def enable_primary_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_primary_ipv6", value)

    @property
    @pulumi.getter(name="interfaceType")
    def interface_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
        """
        return pulumi.get(self, "interface_type")

    @interface_type.setter
    def interface_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_type", value)

    @property
    @pulumi.getter(name="ipv4PrefixCount")
    def ipv4_prefix_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of IPv4 prefixes that AWS automatically assigns to the network interface.
        """
        return pulumi.get(self, "ipv4_prefix_count")

    @ipv4_prefix_count.setter
    def ipv4_prefix_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv4_prefix_count", value)

    @property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more IPv4 prefixes assigned to the network interface.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @ipv4_prefixes.setter
    def ipv4_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv4_prefixes", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6AddressListEnabled")
    def ipv6_address_list_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default is `false`.
        """
        return pulumi.get(self, "ipv6_address_list_enabled")

    @ipv6_address_list_enabled.setter
    def ipv6_address_list_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ipv6_address_list_enabled", value)

    @property
    @pulumi.getter(name="ipv6AddressLists")
    def ipv6_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of private IPs to assign to the ENI in sequential order.
        """
        return pulumi.get(self, "ipv6_address_lists")

    @ipv6_address_lists.setter
    def ipv6_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_address_lists", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="ipv6PrefixCount")
    def ipv6_prefix_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of IPv6 prefixes that AWS automatically assigns to the network interface.
        """
        return pulumi.get(self, "ipv6_prefix_count")

    @ipv6_prefix_count.setter
    def ipv6_prefix_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_prefix_count", value)

    @property
    @pulumi.getter(name="ipv6Prefixes")
    def ipv6_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more IPv6 prefixes assigned to the network interface.
        """
        return pulumi.get(self, "ipv6_prefixes")

    @ipv6_prefixes.setter
    def ipv6_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_prefixes", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateIpListEnabled")
    def private_ip_list_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default is `false`.
        """
        return pulumi.get(self, "private_ip_list_enabled")

    @private_ip_list_enabled.setter
    def private_ip_list_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "private_ip_list_enabled", value)

    @property
    @pulumi.getter(name="privateIpLists")
    def private_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
        """
        return pulumi.get(self, "private_ip_lists")

    @private_ip_lists.setter
    def private_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "private_ip_lists", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of private IPs to assign to the ENI without regard to order.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateIpsCount")
    def private_ips_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
        """
        return pulumi.get(self, "private_ips_count")

    @private_ips_count.setter
    def private_ips_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "private_ips_count", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group IDs to assign to the ENI.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable source destination checking for the ENI. Default true.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NetworkInterfaceState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceAttachmentArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 interface_type: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_address_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv6_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mac_address: Optional[pulumi.Input[builtins.str]] = None,
                 outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_dns_name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 private_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ips_count: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetworkInterface resources.
        :param pulumi.Input[builtins.str] arn: ARN of the network interface.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceAttachmentArgs']]] attachments: Configuration block to define the attachment of the ENI. See Attachment below for more details!
        :param pulumi.Input[builtins.str] description: Description for the network interface.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: Enables assigning a primary IPv6 Global Unicast Address (GUA) to the network interface (ENI) in dual-stack or IPv6-only subnets. This ensures the instance attached to the ENI retains a consistent IPv6 address. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains assigned until the instance is terminated or the ENI is detached. Enabling and subsequent disabling forces recreation of the ENI.
        :param pulumi.Input[builtins.str] interface_type: Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
        :param pulumi.Input[builtins.int] ipv4_prefix_count: Number of IPv4 prefixes that AWS automatically assigns to the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv4_prefixes: One or more IPv4 prefixes assigned to the network interface.
        :param pulumi.Input[builtins.int] ipv6_address_count: Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
        :param pulumi.Input[builtins.bool] ipv6_address_list_enabled: Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_address_lists: List of private IPs to assign to the ENI in sequential order.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_addresses: One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
        :param pulumi.Input[builtins.int] ipv6_prefix_count: Number of IPv6 prefixes that AWS automatically assigns to the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_prefixes: One or more IPv6 prefixes assigned to the network interface.
        :param pulumi.Input[builtins.str] mac_address: MAC address of the network interface.
        :param pulumi.Input[builtins.str] owner_id: AWS account ID of the owner of the network interface.
        :param pulumi.Input[builtins.str] private_dns_name: Private DNS name of the network interface (IPv4).
        :param pulumi.Input[builtins.bool] private_ip_list_enabled: Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] private_ip_lists: List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] private_ips: List of private IPs to assign to the ENI without regard to order.
        :param pulumi.Input[builtins.int] private_ips_count: Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: List of security group IDs to assign to the ENI.
        :param pulumi.Input[builtins.bool] source_dest_check: Whether to enable source destination checking for the ENI. Default true.
        :param pulumi.Input[builtins.str] subnet_id: Subnet ID to create the ENI in.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_primary_ipv6 is not None:
            pulumi.set(__self__, "enable_primary_ipv6", enable_primary_ipv6)
        if interface_type is not None:
            pulumi.set(__self__, "interface_type", interface_type)
        if ipv4_prefix_count is not None:
            pulumi.set(__self__, "ipv4_prefix_count", ipv4_prefix_count)
        if ipv4_prefixes is not None:
            pulumi.set(__self__, "ipv4_prefixes", ipv4_prefixes)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_address_list_enabled is not None:
            pulumi.set(__self__, "ipv6_address_list_enabled", ipv6_address_list_enabled)
        if ipv6_address_lists is not None:
            pulumi.set(__self__, "ipv6_address_lists", ipv6_address_lists)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if ipv6_prefix_count is not None:
            pulumi.set(__self__, "ipv6_prefix_count", ipv6_prefix_count)
        if ipv6_prefixes is not None:
            pulumi.set(__self__, "ipv6_prefixes", ipv6_prefixes)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if private_dns_name is not None:
            pulumi.set(__self__, "private_dns_name", private_dns_name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_list_enabled is not None:
            pulumi.set(__self__, "private_ip_list_enabled", private_ip_list_enabled)
        if private_ip_lists is not None:
            pulumi.set(__self__, "private_ip_lists", private_ip_lists)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_ips_count is not None:
            pulumi.set(__self__, "private_ips_count", private_ips_count)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the network interface.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceAttachmentArgs']]]]:
        """
        Configuration block to define the attachment of the ENI. See Attachment below for more details!
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the network interface.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables assigning a primary IPv6 Global Unicast Address (GUA) to the network interface (ENI) in dual-stack or IPv6-only subnets. This ensures the instance attached to the ENI retains a consistent IPv6 address. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains assigned until the instance is terminated or the ENI is detached. Enabling and subsequent disabling forces recreation of the ENI.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @enable_primary_ipv6.setter
    def enable_primary_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_primary_ipv6", value)

    @property
    @pulumi.getter(name="interfaceType")
    def interface_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
        """
        return pulumi.get(self, "interface_type")

    @interface_type.setter
    def interface_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_type", value)

    @property
    @pulumi.getter(name="ipv4PrefixCount")
    def ipv4_prefix_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of IPv4 prefixes that AWS automatically assigns to the network interface.
        """
        return pulumi.get(self, "ipv4_prefix_count")

    @ipv4_prefix_count.setter
    def ipv4_prefix_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv4_prefix_count", value)

    @property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more IPv4 prefixes assigned to the network interface.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @ipv4_prefixes.setter
    def ipv4_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv4_prefixes", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6AddressListEnabled")
    def ipv6_address_list_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default is `false`.
        """
        return pulumi.get(self, "ipv6_address_list_enabled")

    @ipv6_address_list_enabled.setter
    def ipv6_address_list_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ipv6_address_list_enabled", value)

    @property
    @pulumi.getter(name="ipv6AddressLists")
    def ipv6_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of private IPs to assign to the ENI in sequential order.
        """
        return pulumi.get(self, "ipv6_address_lists")

    @ipv6_address_lists.setter
    def ipv6_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_address_lists", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="ipv6PrefixCount")
    def ipv6_prefix_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of IPv6 prefixes that AWS automatically assigns to the network interface.
        """
        return pulumi.get(self, "ipv6_prefix_count")

    @ipv6_prefix_count.setter
    def ipv6_prefix_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_prefix_count", value)

    @property
    @pulumi.getter(name="ipv6Prefixes")
    def ipv6_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more IPv6 prefixes assigned to the network interface.
        """
        return pulumi.get(self, "ipv6_prefixes")

    @ipv6_prefixes.setter
    def ipv6_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_prefixes", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        MAC address of the network interface.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outpost_arn", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS account ID of the owner of the network interface.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="privateDnsName")
    def private_dns_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private DNS name of the network interface (IPv4).
        """
        return pulumi.get(self, "private_dns_name")

    @private_dns_name.setter
    def private_dns_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_dns_name", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateIpListEnabled")
    def private_ip_list_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default is `false`.
        """
        return pulumi.get(self, "private_ip_list_enabled")

    @private_ip_list_enabled.setter
    def private_ip_list_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "private_ip_list_enabled", value)

    @property
    @pulumi.getter(name="privateIpLists")
    def private_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
        """
        return pulumi.get(self, "private_ip_lists")

    @private_ip_lists.setter
    def private_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "private_ip_lists", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of private IPs to assign to the ENI without regard to order.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateIpsCount")
    def private_ips_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
        """
        return pulumi.get(self, "private_ips_count")

    @private_ips_count.setter
    def private_ips_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "private_ips_count", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group IDs to assign to the ENI.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable source destination checking for the ENI. Default true.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet ID to create the ENI in.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:ec2/networkInterface:NetworkInterface")
class NetworkInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceAttachmentArgs', 'NetworkInterfaceAttachmentArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 interface_type: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_address_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv6_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 private_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ips_count: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an Elastic network interface (ENI) resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.ec2.NetworkInterface("test",
            subnet_id=public_a["id"],
            private_ips=["10.0.0.50"],
            security_groups=[web["id"]],
            attachments=[{
                "instance": test_aws_instance["id"],
                "device_index": 1,
            }])
        ```

        ### Example of Managing Multiple IPs on a Network Interface

        By default, private IPs are managed through the `private_ips` and `private_ips_count` arguments which manage IPs as a set of IPs that are configured without regard to order. For a new network interface, the same primary IP address is consistently selected from a given set of addresses, regardless of the order provided. However, modifications of the set of addresses of an existing interface will not alter the current primary IP address unless it has been removed from the set.

        In order to manage the private IPs as a sequentially ordered list, configure `private_ip_list_enabled` to `true` and use `private_ip_list` to manage the IPs. This will disable the `private_ips` and `private_ips_count` settings, which must be removed from the config file but are still exported. Note that changing the first address of `private_ip_list`, which is the primary, always requires a new interface.

        If you are managing a specific set or list of IPs, instead of just using `private_ips_count`, this is a potential workflow for also leveraging `private_ips_count` to have AWS automatically assign additional IP addresses:

        1. Comment out `private_ips`, `private_ip_list`, `private_ip_list_enabled` in your configuration
        2. Set the desired `private_ips_count` (count of the number of secondaries, the primary is not included)
        3. Apply to assign the extra IPs
        4. Remove `private_ips_count` and restore your settings from the first step
        5. Add the new IPs to your current settings
        6. Apply again to update the stored state

        This process can also be used to remove IP addresses in addition to the option of manually removing them. Adding IP addresses in a manually is more difficult because it requires knowledge of which addresses are available.

        ## Import

        Using `pulumi import`, import Network Interfaces using the `id`. For example:

        ```sh
        $ pulumi import aws:ec2/networkInterface:NetworkInterface test eni-e5aa89a3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceAttachmentArgs', 'NetworkInterfaceAttachmentArgsDict']]]] attachments: Configuration block to define the attachment of the ENI. See Attachment below for more details!
        :param pulumi.Input[builtins.str] description: Description for the network interface.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: Enables assigning a primary IPv6 Global Unicast Address (GUA) to the network interface (ENI) in dual-stack or IPv6-only subnets. This ensures the instance attached to the ENI retains a consistent IPv6 address. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains assigned until the instance is terminated or the ENI is detached. Enabling and subsequent disabling forces recreation of the ENI.
        :param pulumi.Input[builtins.str] interface_type: Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
        :param pulumi.Input[builtins.int] ipv4_prefix_count: Number of IPv4 prefixes that AWS automatically assigns to the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv4_prefixes: One or more IPv4 prefixes assigned to the network interface.
        :param pulumi.Input[builtins.int] ipv6_address_count: Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
        :param pulumi.Input[builtins.bool] ipv6_address_list_enabled: Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_address_lists: List of private IPs to assign to the ENI in sequential order.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_addresses: One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
        :param pulumi.Input[builtins.int] ipv6_prefix_count: Number of IPv6 prefixes that AWS automatically assigns to the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_prefixes: One or more IPv6 prefixes assigned to the network interface.
        :param pulumi.Input[builtins.bool] private_ip_list_enabled: Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] private_ip_lists: List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] private_ips: List of private IPs to assign to the ENI without regard to order.
        :param pulumi.Input[builtins.int] private_ips_count: Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: List of security group IDs to assign to the ENI.
        :param pulumi.Input[builtins.bool] source_dest_check: Whether to enable source destination checking for the ENI. Default true.
        :param pulumi.Input[builtins.str] subnet_id: Subnet ID to create the ENI in.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic network interface (ENI) resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.ec2.NetworkInterface("test",
            subnet_id=public_a["id"],
            private_ips=["10.0.0.50"],
            security_groups=[web["id"]],
            attachments=[{
                "instance": test_aws_instance["id"],
                "device_index": 1,
            }])
        ```

        ### Example of Managing Multiple IPs on a Network Interface

        By default, private IPs are managed through the `private_ips` and `private_ips_count` arguments which manage IPs as a set of IPs that are configured without regard to order. For a new network interface, the same primary IP address is consistently selected from a given set of addresses, regardless of the order provided. However, modifications of the set of addresses of an existing interface will not alter the current primary IP address unless it has been removed from the set.

        In order to manage the private IPs as a sequentially ordered list, configure `private_ip_list_enabled` to `true` and use `private_ip_list` to manage the IPs. This will disable the `private_ips` and `private_ips_count` settings, which must be removed from the config file but are still exported. Note that changing the first address of `private_ip_list`, which is the primary, always requires a new interface.

        If you are managing a specific set or list of IPs, instead of just using `private_ips_count`, this is a potential workflow for also leveraging `private_ips_count` to have AWS automatically assign additional IP addresses:

        1. Comment out `private_ips`, `private_ip_list`, `private_ip_list_enabled` in your configuration
        2. Set the desired `private_ips_count` (count of the number of secondaries, the primary is not included)
        3. Apply to assign the extra IPs
        4. Remove `private_ips_count` and restore your settings from the first step
        5. Add the new IPs to your current settings
        6. Apply again to update the stored state

        This process can also be used to remove IP addresses in addition to the option of manually removing them. Adding IP addresses in a manually is more difficult because it requires knowledge of which addresses are available.

        ## Import

        Using `pulumi import`, import Network Interfaces using the `id`. For example:

        ```sh
        $ pulumi import aws:ec2/networkInterface:NetworkInterface test eni-e5aa89a3
        ```

        :param str resource_name: The name of the resource.
        :param NetworkInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceAttachmentArgs', 'NetworkInterfaceAttachmentArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 interface_type: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_address_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv6_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 private_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 private_ips_count: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInterfaceArgs.__new__(NetworkInterfaceArgs)

            __props__.__dict__["attachments"] = attachments
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_primary_ipv6"] = enable_primary_ipv6
            __props__.__dict__["interface_type"] = interface_type
            __props__.__dict__["ipv4_prefix_count"] = ipv4_prefix_count
            __props__.__dict__["ipv4_prefixes"] = ipv4_prefixes
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_address_list_enabled"] = ipv6_address_list_enabled
            __props__.__dict__["ipv6_address_lists"] = ipv6_address_lists
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["ipv6_prefix_count"] = ipv6_prefix_count
            __props__.__dict__["ipv6_prefixes"] = ipv6_prefixes
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["private_ip_list_enabled"] = private_ip_list_enabled
            __props__.__dict__["private_ip_lists"] = private_ip_lists
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_ips_count"] = private_ips_count
            __props__.__dict__["region"] = region
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["source_dest_check"] = source_dest_check
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["mac_address"] = None
            __props__.__dict__["outpost_arn"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["private_dns_name"] = None
            __props__.__dict__["tags_all"] = None
        super(NetworkInterface, __self__).__init__(
            'aws:ec2/networkInterface:NetworkInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceAttachmentArgs', 'NetworkInterfaceAttachmentArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enable_primary_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
            interface_type: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
            ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipv6_address_count: Optional[pulumi.Input[builtins.int]] = None,
            ipv6_address_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            ipv6_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipv6_prefix_count: Optional[pulumi.Input[builtins.int]] = None,
            ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            mac_address: Optional[pulumi.Input[builtins.str]] = None,
            outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
            owner_id: Optional[pulumi.Input[builtins.str]] = None,
            private_dns_name: Optional[pulumi.Input[builtins.str]] = None,
            private_ip: Optional[pulumi.Input[builtins.str]] = None,
            private_ip_list_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            private_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            private_ips_count: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            source_dest_check: Optional[pulumi.Input[builtins.bool]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'NetworkInterface':
        """
        Get an existing NetworkInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkInterfaceAttachmentArgs', 'NetworkInterfaceAttachmentArgsDict']]]] attachments: Configuration block to define the attachment of the ENI. See Attachment below for more details!
        :param pulumi.Input[builtins.str] description: Description for the network interface.
        :param pulumi.Input[builtins.bool] enable_primary_ipv6: Enables assigning a primary IPv6 Global Unicast Address (GUA) to the network interface (ENI) in dual-stack or IPv6-only subnets. This ensures the instance attached to the ENI retains a consistent IPv6 address. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains assigned until the instance is terminated or the ENI is detached. Enabling and subsequent disabling forces recreation of the ENI.
        :param pulumi.Input[builtins.str] interface_type: Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
        :param pulumi.Input[builtins.int] ipv4_prefix_count: Number of IPv4 prefixes that AWS automatically assigns to the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv4_prefixes: One or more IPv4 prefixes assigned to the network interface.
        :param pulumi.Input[builtins.int] ipv6_address_count: Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
        :param pulumi.Input[builtins.bool] ipv6_address_list_enabled: Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_address_lists: List of private IPs to assign to the ENI in sequential order.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_addresses: One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
        :param pulumi.Input[builtins.int] ipv6_prefix_count: Number of IPv6 prefixes that AWS automatically assigns to the network interface.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_prefixes: One or more IPv6 prefixes assigned to the network interface.
        :param pulumi.Input[builtins.str] mac_address: MAC address of the network interface.
        :param pulumi.Input[builtins.str] owner_id: AWS account ID of the owner of the network interface.
        :param pulumi.Input[builtins.str] private_dns_name: Private DNS name of the network interface (IPv4).
        :param pulumi.Input[builtins.bool] private_ip_list_enabled: Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] private_ip_lists: List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] private_ips: List of private IPs to assign to the ENI without regard to order.
        :param pulumi.Input[builtins.int] private_ips_count: Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_groups: List of security group IDs to assign to the ENI.
        :param pulumi.Input[builtins.bool] source_dest_check: Whether to enable source destination checking for the ENI. Default true.
        :param pulumi.Input[builtins.str] subnet_id: Subnet ID to create the ENI in.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkInterfaceState.__new__(_NetworkInterfaceState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["attachments"] = attachments
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_primary_ipv6"] = enable_primary_ipv6
        __props__.__dict__["interface_type"] = interface_type
        __props__.__dict__["ipv4_prefix_count"] = ipv4_prefix_count
        __props__.__dict__["ipv4_prefixes"] = ipv4_prefixes
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["ipv6_address_list_enabled"] = ipv6_address_list_enabled
        __props__.__dict__["ipv6_address_lists"] = ipv6_address_lists
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["ipv6_prefix_count"] = ipv6_prefix_count
        __props__.__dict__["ipv6_prefixes"] = ipv6_prefixes
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["outpost_arn"] = outpost_arn
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["private_dns_name"] = private_dns_name
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_ip_list_enabled"] = private_ip_list_enabled
        __props__.__dict__["private_ip_lists"] = private_ip_lists
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_ips_count"] = private_ips_count
        __props__.__dict__["region"] = region
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["source_dest_check"] = source_dest_check
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return NetworkInterface(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the network interface.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Sequence['outputs.NetworkInterfaceAttachment']]:
        """
        Configuration block to define the attachment of the ENI. See Attachment below for more details!
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description for the network interface.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enablePrimaryIpv6")
    def enable_primary_ipv6(self) -> pulumi.Output[builtins.bool]:
        """
        Enables assigning a primary IPv6 Global Unicast Address (GUA) to the network interface (ENI) in dual-stack or IPv6-only subnets. This ensures the instance attached to the ENI retains a consistent IPv6 address. Once enabled, the first IPv6 GUA becomes the primary IPv6 address and cannot be disabled. The primary IPv6 address remains assigned until the instance is terminated or the ENI is detached. Enabling and subsequent disabling forces recreation of the ENI.
        """
        return pulumi.get(self, "enable_primary_ipv6")

    @property
    @pulumi.getter(name="interfaceType")
    def interface_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of network interface to create. Set to `efa` for Elastic Fabric Adapter. Changing `interface_type` will cause the resource to be destroyed and re-created.
        """
        return pulumi.get(self, "interface_type")

    @property
    @pulumi.getter(name="ipv4PrefixCount")
    def ipv4_prefix_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of IPv4 prefixes that AWS automatically assigns to the network interface.
        """
        return pulumi.get(self, "ipv4_prefix_count")

    @property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        One or more IPv4 prefixes assigned to the network interface.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of IPv6 addresses to assign to a network interface. You can't use this option if specifying specific `ipv6_addresses`. If your subnet has the AssignIpv6AddressOnCreation attribute set to `true`, you can specify `0` to override this setting.
        """
        return pulumi.get(self, "ipv6_address_count")

    @property
    @pulumi.getter(name="ipv6AddressListEnabled")
    def ipv6_address_list_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether `ipv6_address_list` is allowed and controls the IPs to assign to the ENI and `ipv6_addresses` and `ipv6_address_count` become read-only. Default is `false`.
        """
        return pulumi.get(self, "ipv6_address_list_enabled")

    @property
    @pulumi.getter(name="ipv6AddressLists")
    def ipv6_address_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of private IPs to assign to the ENI in sequential order.
        """
        return pulumi.get(self, "ipv6_address_lists")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. Addresses are assigned without regard to order. You can't use this option if you're specifying `ipv6_address_count`.
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="ipv6PrefixCount")
    def ipv6_prefix_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of IPv6 prefixes that AWS automatically assigns to the network interface.
        """
        return pulumi.get(self, "ipv6_prefix_count")

    @property
    @pulumi.getter(name="ipv6Prefixes")
    def ipv6_prefixes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        One or more IPv6 prefixes assigned to the network interface.
        """
        return pulumi.get(self, "ipv6_prefixes")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[builtins.str]:
        """
        MAC address of the network interface.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[builtins.str]:
        """
        AWS account ID of the owner of the network interface.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="privateDnsName")
    def private_dns_name(self) -> pulumi.Output[builtins.str]:
        """
        Private DNS name of the network interface (IPv4).
        """
        return pulumi.get(self, "private_dns_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateIpListEnabled")
    def private_ip_list_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether `private_ip_list` is allowed and controls the IPs to assign to the ENI and `private_ips` and `private_ips_count` become read-only. Default is `false`.
        """
        return pulumi.get(self, "private_ip_list_enabled")

    @property
    @pulumi.getter(name="privateIpLists")
    def private_ip_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of private IPs to assign to the ENI in sequential order. Requires setting `private_ip_list_enabled` to `true`.
        """
        return pulumi.get(self, "private_ip_lists")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of private IPs to assign to the ENI without regard to order.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateIpsCount")
    def private_ips_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of secondary private IPs to assign to the ENI. The total number of private IPs will be 1 + `private_ips_count`, as a primary private IP will be assiged to an ENI by default.
        """
        return pulumi.get(self, "private_ips_count")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of security group IDs to assign to the ENI.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable source destination checking for the ENI. Default true.
        """
        return pulumi.get(self, "source_dest_check")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        Subnet ID to create the ENI in.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

