# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkInterfaceSecurityGroupAttachmentArgs', 'NetworkInterfaceSecurityGroupAttachment']

@pulumi.input_type
class NetworkInterfaceSecurityGroupAttachmentArgs:
    def __init__(__self__, *,
                 network_interface_id: pulumi.Input[builtins.str],
                 security_group_id: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkInterfaceSecurityGroupAttachment resource.
        :param pulumi.Input[builtins.str] network_interface_id: The ID of the network interface to attach to.
        :param pulumi.Input[builtins.str] security_group_id: The ID of the security group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the network interface to attach to.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NetworkInterfaceSecurityGroupAttachmentState:
    def __init__(__self__, *,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkInterfaceSecurityGroupAttachment resources.
        :param pulumi.Input[builtins.str] network_interface_id: The ID of the network interface to attach to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_group_id: The ID of the security group.
        """
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the network interface to attach to.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_group_id", value)


@pulumi.type_token("aws:ec2/networkInterfaceSecurityGroupAttachment:NetworkInterfaceSecurityGroupAttachment")
class NetworkInterfaceSecurityGroupAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource attaches a security group to an Elastic Network Interface (ENI).
        It can be used to attach a security group to any existing ENI, be it a
        secondary ENI or one attached as the primary interface on an instance.

        > **NOTE on instances, interfaces, and security groups:** This provider currently
        provides the capability to assign security groups via the [`ec2.Instance`][1]
        and the [`ec2.NetworkInterface`][2] resources. Using this resource in
        conjunction with security groups provided in-line in those resources will cause
        conflicts, and will lead to spurious diffs and undefined behavior - please use
        one or the other.

        ## Example Usage

        The following provides a very basic example of setting up an instance (provided
        by `instance`) in the default security group, creating a security group
        (provided by `sg`) and then attaching the security group to the instance's
        primary network interface via the `ec2.NetworkInterfaceSecurityGroupAttachment` resource,
        named `sg_attachment`:

        ```python
        import pulumi
        import pulumi_aws as aws

        ami = aws.ec2.get_ami(most_recent=True,
            filters=[{
                "name": "name",
                "values": ["amzn-ami-hvm-*"],
            }],
            owners=["amazon"])
        instance = aws.ec2.Instance("instance",
            instance_type=aws.ec2.InstanceType.T2_MICRO,
            ami=ami.id,
            tags={
                "type": "test-instance",
            })
        sg = aws.ec2.SecurityGroup("sg", tags={
            "type": "test-security-group",
        })
        sg_attachment = aws.ec2.NetworkInterfaceSecurityGroupAttachment("sg_attachment",
            security_group_id=sg.id,
            network_interface_id=instance.primary_network_interface_id)
        ```

        In this example, `instance` is provided by the `ec2.Instance` data source,
        fetching an external instance, possibly not managed by this provider.
        `sg_attachment` then attaches to the output instance's `network_interface_id`:

        ```python
        import pulumi
        import pulumi_aws as aws

        instance = aws.ec2.get_instance(instance_id="i-1234567890abcdef0")
        sg = aws.ec2.SecurityGroup("sg", tags={
            "type": "test-security-group",
        })
        sg_attachment = aws.ec2.NetworkInterfaceSecurityGroupAttachment("sg_attachment",
            security_group_id=sg.id,
            network_interface_id=instance.network_interface_id)
        ```

        ## Import

        Using `pulumi import`, import Network Interface Security Group attachments using the associated network interface ID and security group ID, separated by an underscore (`_`). For example:

        ```sh
        $ pulumi import aws:ec2/networkInterfaceSecurityGroupAttachment:NetworkInterfaceSecurityGroupAttachment sg_attachment eni-1234567890abcdef0_sg-1234567890abcdef0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_interface_id: The ID of the network interface to attach to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_group_id: The ID of the security group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInterfaceSecurityGroupAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource attaches a security group to an Elastic Network Interface (ENI).
        It can be used to attach a security group to any existing ENI, be it a
        secondary ENI or one attached as the primary interface on an instance.

        > **NOTE on instances, interfaces, and security groups:** This provider currently
        provides the capability to assign security groups via the [`ec2.Instance`][1]
        and the [`ec2.NetworkInterface`][2] resources. Using this resource in
        conjunction with security groups provided in-line in those resources will cause
        conflicts, and will lead to spurious diffs and undefined behavior - please use
        one or the other.

        ## Example Usage

        The following provides a very basic example of setting up an instance (provided
        by `instance`) in the default security group, creating a security group
        (provided by `sg`) and then attaching the security group to the instance's
        primary network interface via the `ec2.NetworkInterfaceSecurityGroupAttachment` resource,
        named `sg_attachment`:

        ```python
        import pulumi
        import pulumi_aws as aws

        ami = aws.ec2.get_ami(most_recent=True,
            filters=[{
                "name": "name",
                "values": ["amzn-ami-hvm-*"],
            }],
            owners=["amazon"])
        instance = aws.ec2.Instance("instance",
            instance_type=aws.ec2.InstanceType.T2_MICRO,
            ami=ami.id,
            tags={
                "type": "test-instance",
            })
        sg = aws.ec2.SecurityGroup("sg", tags={
            "type": "test-security-group",
        })
        sg_attachment = aws.ec2.NetworkInterfaceSecurityGroupAttachment("sg_attachment",
            security_group_id=sg.id,
            network_interface_id=instance.primary_network_interface_id)
        ```

        In this example, `instance` is provided by the `ec2.Instance` data source,
        fetching an external instance, possibly not managed by this provider.
        `sg_attachment` then attaches to the output instance's `network_interface_id`:

        ```python
        import pulumi
        import pulumi_aws as aws

        instance = aws.ec2.get_instance(instance_id="i-1234567890abcdef0")
        sg = aws.ec2.SecurityGroup("sg", tags={
            "type": "test-security-group",
        })
        sg_attachment = aws.ec2.NetworkInterfaceSecurityGroupAttachment("sg_attachment",
            security_group_id=sg.id,
            network_interface_id=instance.network_interface_id)
        ```

        ## Import

        Using `pulumi import`, import Network Interface Security Group attachments using the associated network interface ID and security group ID, separated by an underscore (`_`). For example:

        ```sh
        $ pulumi import aws:ec2/networkInterfaceSecurityGroupAttachment:NetworkInterfaceSecurityGroupAttachment sg_attachment eni-1234567890abcdef0_sg-1234567890abcdef0
        ```

        :param str resource_name: The name of the resource.
        :param NetworkInterfaceSecurityGroupAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInterfaceSecurityGroupAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInterfaceSecurityGroupAttachmentArgs.__new__(NetworkInterfaceSecurityGroupAttachmentArgs)

            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
        super(NetworkInterfaceSecurityGroupAttachment, __self__).__init__(
            'aws:ec2/networkInterfaceSecurityGroupAttachment:NetworkInterfaceSecurityGroupAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkInterfaceSecurityGroupAttachment':
        """
        Get an existing NetworkInterfaceSecurityGroupAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_interface_id: The ID of the network interface to attach to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_group_id: The ID of the security group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkInterfaceSecurityGroupAttachmentState.__new__(_NetworkInterfaceSecurityGroupAttachmentState)

        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        return NetworkInterfaceSecurityGroupAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the network interface to attach to.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

