# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 route_table_id: pulumi.Input[builtins.str],
                 carrier_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 destination_ipv6_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 destination_prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 egress_only_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 local_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_peering_connection_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[builtins.str] route_table_id: The ID of the routing table.
               
               One of the following destination arguments must be supplied:
        :param pulumi.Input[builtins.str] carrier_gateway_id: Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
        :param pulumi.Input[builtins.str] core_network_arn: The Amazon Resource Name (ARN) of a core network.
        :param pulumi.Input[builtins.str] destination_cidr_block: The destination CIDR block.
        :param pulumi.Input[builtins.str] destination_ipv6_cidr_block: The destination IPv6 CIDR block.
        :param pulumi.Input[builtins.str] destination_prefix_list_id: The ID of a managed prefix list destination.
               
               One of the following target arguments must be supplied:
        :param pulumi.Input[builtins.str] egress_only_gateway_id: Identifier of a VPC Egress Only Internet Gateway.
        :param pulumi.Input[builtins.str] gateway_id: Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
        :param pulumi.Input[builtins.str] local_gateway_id: Identifier of a Outpost local gateway.
        :param pulumi.Input[builtins.str] nat_gateway_id: Identifier of a VPC NAT gateway.
        :param pulumi.Input[builtins.str] network_interface_id: Identifier of an EC2 network interface.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] transit_gateway_id: Identifier of an EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] vpc_endpoint_id: Identifier of a VPC Endpoint.
        :param pulumi.Input[builtins.str] vpc_peering_connection_id: Identifier of a VPC peering connection.
               
               Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
        """
        pulumi.set(__self__, "route_table_id", route_table_id)
        if carrier_gateway_id is not None:
            pulumi.set(__self__, "carrier_gateway_id", carrier_gateway_id)
        if core_network_arn is not None:
            pulumi.set(__self__, "core_network_arn", core_network_arn)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_ipv6_cidr_block is not None:
            pulumi.set(__self__, "destination_ipv6_cidr_block", destination_ipv6_cidr_block)
        if destination_prefix_list_id is not None:
            pulumi.set(__self__, "destination_prefix_list_id", destination_prefix_list_id)
        if egress_only_gateway_id is not None:
            pulumi.set(__self__, "egress_only_gateway_id", egress_only_gateway_id)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if local_gateway_id is not None:
            pulumi.set(__self__, "local_gateway_id", local_gateway_id)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_peering_connection_id is not None:
            pulumi.set(__self__, "vpc_peering_connection_id", vpc_peering_connection_id)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the routing table.

        One of the following destination arguments must be supplied:
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter(name="carrierGatewayId")
    def carrier_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
        """
        return pulumi.get(self, "carrier_gateway_id")

    @carrier_gateway_id.setter
    def carrier_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "carrier_gateway_id", value)

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of a core network.
        """
        return pulumi.get(self, "core_network_arn")

    @core_network_arn.setter
    def core_network_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_arn", value)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination CIDR block.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @property
    @pulumi.getter(name="destinationIpv6CidrBlock")
    def destination_ipv6_cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination IPv6 CIDR block.
        """
        return pulumi.get(self, "destination_ipv6_cidr_block")

    @destination_ipv6_cidr_block.setter
    def destination_ipv6_cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="destinationPrefixListId")
    def destination_prefix_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of a managed prefix list destination.

        One of the following target arguments must be supplied:
        """
        return pulumi.get(self, "destination_prefix_list_id")

    @destination_prefix_list_id.setter
    def destination_prefix_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_prefix_list_id", value)

    @property
    @pulumi.getter(name="egressOnlyGatewayId")
    def egress_only_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC Egress Only Internet Gateway.
        """
        return pulumi.get(self, "egress_only_gateway_id")

    @egress_only_gateway_id.setter
    def egress_only_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "egress_only_gateway_id", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter(name="localGatewayId")
    def local_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a Outpost local gateway.
        """
        return pulumi.get(self, "local_gateway_id")

    @local_gateway_id.setter
    def local_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_gateway_id", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of an EC2 network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of an EC2 Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC Endpoint.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_endpoint_id", value)

    @property
    @pulumi.getter(name="vpcPeeringConnectionId")
    def vpc_peering_connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC peering connection.

        Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
        """
        return pulumi.get(self, "vpc_peering_connection_id")

    @vpc_peering_connection_id.setter
    def vpc_peering_connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_peering_connection_id", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 carrier_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 destination_ipv6_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 destination_prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 egress_only_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 local_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_peering_connection_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[builtins.str] carrier_gateway_id: Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
        :param pulumi.Input[builtins.str] core_network_arn: The Amazon Resource Name (ARN) of a core network.
        :param pulumi.Input[builtins.str] destination_cidr_block: The destination CIDR block.
        :param pulumi.Input[builtins.str] destination_ipv6_cidr_block: The destination IPv6 CIDR block.
        :param pulumi.Input[builtins.str] destination_prefix_list_id: The ID of a managed prefix list destination.
               
               One of the following target arguments must be supplied:
        :param pulumi.Input[builtins.str] egress_only_gateway_id: Identifier of a VPC Egress Only Internet Gateway.
        :param pulumi.Input[builtins.str] gateway_id: Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
        :param pulumi.Input[builtins.str] instance_id: Identifier of an EC2 instance.
        :param pulumi.Input[builtins.str] instance_owner_id: The AWS account ID of the owner of the EC2 instance.
        :param pulumi.Input[builtins.str] local_gateway_id: Identifier of a Outpost local gateway.
        :param pulumi.Input[builtins.str] nat_gateway_id: Identifier of a VPC NAT gateway.
        :param pulumi.Input[builtins.str] network_interface_id: Identifier of an EC2 network interface.
        :param pulumi.Input[builtins.str] origin: How the route was created - `CreateRouteTable`, `CreateRoute` or `EnableVgwRoutePropagation`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_table_id: The ID of the routing table.
               
               One of the following destination arguments must be supplied:
        :param pulumi.Input[builtins.str] state: The state of the route - `active` or `blackhole`.
        :param pulumi.Input[builtins.str] transit_gateway_id: Identifier of an EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] vpc_endpoint_id: Identifier of a VPC Endpoint.
        :param pulumi.Input[builtins.str] vpc_peering_connection_id: Identifier of a VPC peering connection.
               
               Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
        """
        if carrier_gateway_id is not None:
            pulumi.set(__self__, "carrier_gateway_id", carrier_gateway_id)
        if core_network_arn is not None:
            pulumi.set(__self__, "core_network_arn", core_network_arn)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_ipv6_cidr_block is not None:
            pulumi.set(__self__, "destination_ipv6_cidr_block", destination_ipv6_cidr_block)
        if destination_prefix_list_id is not None:
            pulumi.set(__self__, "destination_prefix_list_id", destination_prefix_list_id)
        if egress_only_gateway_id is not None:
            pulumi.set(__self__, "egress_only_gateway_id", egress_only_gateway_id)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_owner_id is not None:
            pulumi.set(__self__, "instance_owner_id", instance_owner_id)
        if local_gateway_id is not None:
            pulumi.set(__self__, "local_gateway_id", local_gateway_id)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_peering_connection_id is not None:
            pulumi.set(__self__, "vpc_peering_connection_id", vpc_peering_connection_id)

    @property
    @pulumi.getter(name="carrierGatewayId")
    def carrier_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
        """
        return pulumi.get(self, "carrier_gateway_id")

    @carrier_gateway_id.setter
    def carrier_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "carrier_gateway_id", value)

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of a core network.
        """
        return pulumi.get(self, "core_network_arn")

    @core_network_arn.setter
    def core_network_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_arn", value)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination CIDR block.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @property
    @pulumi.getter(name="destinationIpv6CidrBlock")
    def destination_ipv6_cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination IPv6 CIDR block.
        """
        return pulumi.get(self, "destination_ipv6_cidr_block")

    @destination_ipv6_cidr_block.setter
    def destination_ipv6_cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="destinationPrefixListId")
    def destination_prefix_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of a managed prefix list destination.

        One of the following target arguments must be supplied:
        """
        return pulumi.get(self, "destination_prefix_list_id")

    @destination_prefix_list_id.setter
    def destination_prefix_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_prefix_list_id", value)

    @property
    @pulumi.getter(name="egressOnlyGatewayId")
    def egress_only_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC Egress Only Internet Gateway.
        """
        return pulumi.get(self, "egress_only_gateway_id")

    @egress_only_gateway_id.setter
    def egress_only_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "egress_only_gateway_id", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of an EC2 instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceOwnerId")
    def instance_owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account ID of the owner of the EC2 instance.
        """
        return pulumi.get(self, "instance_owner_id")

    @instance_owner_id.setter
    def instance_owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_owner_id", value)

    @property
    @pulumi.getter(name="localGatewayId")
    def local_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a Outpost local gateway.
        """
        return pulumi.get(self, "local_gateway_id")

    @local_gateway_id.setter
    def local_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_gateway_id", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of an EC2 network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How the route was created - `CreateRouteTable`, `CreateRoute` or `EnableVgwRoutePropagation`.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the routing table.

        One of the following destination arguments must be supplied:
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the route - `active` or `blackhole`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of an EC2 Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC Endpoint.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_endpoint_id", value)

    @property
    @pulumi.getter(name="vpcPeeringConnectionId")
    def vpc_peering_connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a VPC peering connection.

        Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
        """
        return pulumi.get(self, "vpc_peering_connection_id")

    @vpc_peering_connection_id.setter
    def vpc_peering_connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_peering_connection_id", value)


@pulumi.type_token("aws:ec2/route:Route")
class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 carrier_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 destination_ipv6_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 destination_prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 egress_only_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 local_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_peering_connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create a routing table entry (a route) in a VPC routing table.

        > **NOTE on Route Tables and Routes:** This provider currently provides both a standalone Route resource and a Route Table resource with routes defined in-line. At this time you cannot use a Route Table with in-line routes in conjunction with any Route resources. Doing so will cause a conflict of rule settings and will overwrite rules.

        > **NOTE on `gateway_id` attribute:** The AWS API is very forgiving with the resource ID passed in the `gateway_id` attribute. For example an `ec2.Route` resource can be created with an `ec2.NatGateway` or `ec2.EgressOnlyInternetGateway` ID specified for the `gateway_id` attribute. Specifying anything other than an `ec2.InternetGateway` or `ec2.VpnGateway` ID will lead to this provider reporting a permanent diff between your configuration and recorded state, as the AWS API returns the more-specific attribute. If you are experiencing constant diffs with an `ec2.Route` resource, the first thing to check is that the correct attribute is being specified.

        > **NOTE on combining `vpc_endpoint_id` and `destination_prefix_list_id` attributes:** To associate a Gateway VPC Endpoint (such as S3) with destination prefix list, use the `ec2.VpcEndpointRouteTableAssociation` resource instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        r = aws.ec2.Route("r",
            route_table_id=testing["id"],
            destination_cidr_block="10.0.1.0/22",
            vpc_peering_connection_id="pcx-45ff3dc1")
        ```

        ## Example IPv6 Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        vpc = aws.ec2.Vpc("vpc",
            cidr_block="10.1.0.0/16",
            assign_generated_ipv6_cidr_block=True)
        egress = aws.ec2.EgressOnlyInternetGateway("egress", vpc_id=vpc.id)
        r = aws.ec2.Route("r",
            route_table_id="rtb-4fbb3ac4",
            destination_ipv6_cidr_block="::/0",
            egress_only_gateway_id=egress.id)
        ```

        ## Import

        Import a route in route table `rtb-656C65616E6F72` with an IPv6 destination CIDR of `2620:0:2d0:200::8/125`:

        Import a route in route table `rtb-656C65616E6F72` with a managed prefix list destination of `pl-0570a1d2d725c16be`:

        __Using `pulumi import` to import__ individual routes using `ROUTETABLEID_DESTINATION`. Import [local routes](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html#RouteTables) using the VPC's IPv4 or IPv6 CIDR blocks. For example:

        Import a route in route table `rtb-656C65616E6F72` with an IPv4 destination CIDR of `10.42.0.0/16`:

        ```sh
        $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_10.42.0.0/16
        ```
        Import a route in route table `rtb-656C65616E6F72` with an IPv6 destination CIDR of `2620:0:2d0:200::8/125`:

        ```sh
        $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_2620:0:2d0:200::8/125
        ```
        Import a route in route table `rtb-656C65616E6F72` with a managed prefix list destination of `pl-0570a1d2d725c16be`:

        ```sh
        $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_pl-0570a1d2d725c16be
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] carrier_gateway_id: Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
        :param pulumi.Input[builtins.str] core_network_arn: The Amazon Resource Name (ARN) of a core network.
        :param pulumi.Input[builtins.str] destination_cidr_block: The destination CIDR block.
        :param pulumi.Input[builtins.str] destination_ipv6_cidr_block: The destination IPv6 CIDR block.
        :param pulumi.Input[builtins.str] destination_prefix_list_id: The ID of a managed prefix list destination.
               
               One of the following target arguments must be supplied:
        :param pulumi.Input[builtins.str] egress_only_gateway_id: Identifier of a VPC Egress Only Internet Gateway.
        :param pulumi.Input[builtins.str] gateway_id: Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
        :param pulumi.Input[builtins.str] local_gateway_id: Identifier of a Outpost local gateway.
        :param pulumi.Input[builtins.str] nat_gateway_id: Identifier of a VPC NAT gateway.
        :param pulumi.Input[builtins.str] network_interface_id: Identifier of an EC2 network interface.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_table_id: The ID of the routing table.
               
               One of the following destination arguments must be supplied:
        :param pulumi.Input[builtins.str] transit_gateway_id: Identifier of an EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] vpc_endpoint_id: Identifier of a VPC Endpoint.
        :param pulumi.Input[builtins.str] vpc_peering_connection_id: Identifier of a VPC peering connection.
               
               Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a routing table entry (a route) in a VPC routing table.

        > **NOTE on Route Tables and Routes:** This provider currently provides both a standalone Route resource and a Route Table resource with routes defined in-line. At this time you cannot use a Route Table with in-line routes in conjunction with any Route resources. Doing so will cause a conflict of rule settings and will overwrite rules.

        > **NOTE on `gateway_id` attribute:** The AWS API is very forgiving with the resource ID passed in the `gateway_id` attribute. For example an `ec2.Route` resource can be created with an `ec2.NatGateway` or `ec2.EgressOnlyInternetGateway` ID specified for the `gateway_id` attribute. Specifying anything other than an `ec2.InternetGateway` or `ec2.VpnGateway` ID will lead to this provider reporting a permanent diff between your configuration and recorded state, as the AWS API returns the more-specific attribute. If you are experiencing constant diffs with an `ec2.Route` resource, the first thing to check is that the correct attribute is being specified.

        > **NOTE on combining `vpc_endpoint_id` and `destination_prefix_list_id` attributes:** To associate a Gateway VPC Endpoint (such as S3) with destination prefix list, use the `ec2.VpcEndpointRouteTableAssociation` resource instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        r = aws.ec2.Route("r",
            route_table_id=testing["id"],
            destination_cidr_block="10.0.1.0/22",
            vpc_peering_connection_id="pcx-45ff3dc1")
        ```

        ## Example IPv6 Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        vpc = aws.ec2.Vpc("vpc",
            cidr_block="10.1.0.0/16",
            assign_generated_ipv6_cidr_block=True)
        egress = aws.ec2.EgressOnlyInternetGateway("egress", vpc_id=vpc.id)
        r = aws.ec2.Route("r",
            route_table_id="rtb-4fbb3ac4",
            destination_ipv6_cidr_block="::/0",
            egress_only_gateway_id=egress.id)
        ```

        ## Import

        Import a route in route table `rtb-656C65616E6F72` with an IPv6 destination CIDR of `2620:0:2d0:200::8/125`:

        Import a route in route table `rtb-656C65616E6F72` with a managed prefix list destination of `pl-0570a1d2d725c16be`:

        __Using `pulumi import` to import__ individual routes using `ROUTETABLEID_DESTINATION`. Import [local routes](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html#RouteTables) using the VPC's IPv4 or IPv6 CIDR blocks. For example:

        Import a route in route table `rtb-656C65616E6F72` with an IPv4 destination CIDR of `10.42.0.0/16`:

        ```sh
        $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_10.42.0.0/16
        ```
        Import a route in route table `rtb-656C65616E6F72` with an IPv6 destination CIDR of `2620:0:2d0:200::8/125`:

        ```sh
        $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_2620:0:2d0:200::8/125
        ```
        Import a route in route table `rtb-656C65616E6F72` with a managed prefix list destination of `pl-0570a1d2d725c16be`:

        ```sh
        $ pulumi import aws:ec2/route:Route my_route rtb-656C65616E6F72_pl-0570a1d2d725c16be
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 carrier_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 destination_ipv6_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 destination_prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 egress_only_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 local_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_peering_connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            __props__.__dict__["carrier_gateway_id"] = carrier_gateway_id
            __props__.__dict__["core_network_arn"] = core_network_arn
            __props__.__dict__["destination_cidr_block"] = destination_cidr_block
            __props__.__dict__["destination_ipv6_cidr_block"] = destination_ipv6_cidr_block
            __props__.__dict__["destination_prefix_list_id"] = destination_prefix_list_id
            __props__.__dict__["egress_only_gateway_id"] = egress_only_gateway_id
            __props__.__dict__["gateway_id"] = gateway_id
            __props__.__dict__["local_gateway_id"] = local_gateway_id
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            __props__.__dict__["network_interface_id"] = network_interface_id
            __props__.__dict__["region"] = region
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["transit_gateway_id"] = transit_gateway_id
            __props__.__dict__["vpc_endpoint_id"] = vpc_endpoint_id
            __props__.__dict__["vpc_peering_connection_id"] = vpc_peering_connection_id
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["instance_owner_id"] = None
            __props__.__dict__["origin"] = None
            __props__.__dict__["state"] = None
        super(Route, __self__).__init__(
            'aws:ec2/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            carrier_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
            destination_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
            destination_ipv6_cidr_block: Optional[pulumi.Input[builtins.str]] = None,
            destination_prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
            egress_only_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            instance_owner_id: Optional[pulumi.Input[builtins.str]] = None,
            local_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            nat_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
            origin: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
            vpc_peering_connection_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] carrier_gateway_id: Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
        :param pulumi.Input[builtins.str] core_network_arn: The Amazon Resource Name (ARN) of a core network.
        :param pulumi.Input[builtins.str] destination_cidr_block: The destination CIDR block.
        :param pulumi.Input[builtins.str] destination_ipv6_cidr_block: The destination IPv6 CIDR block.
        :param pulumi.Input[builtins.str] destination_prefix_list_id: The ID of a managed prefix list destination.
               
               One of the following target arguments must be supplied:
        :param pulumi.Input[builtins.str] egress_only_gateway_id: Identifier of a VPC Egress Only Internet Gateway.
        :param pulumi.Input[builtins.str] gateway_id: Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
        :param pulumi.Input[builtins.str] instance_id: Identifier of an EC2 instance.
        :param pulumi.Input[builtins.str] instance_owner_id: The AWS account ID of the owner of the EC2 instance.
        :param pulumi.Input[builtins.str] local_gateway_id: Identifier of a Outpost local gateway.
        :param pulumi.Input[builtins.str] nat_gateway_id: Identifier of a VPC NAT gateway.
        :param pulumi.Input[builtins.str] network_interface_id: Identifier of an EC2 network interface.
        :param pulumi.Input[builtins.str] origin: How the route was created - `CreateRouteTable`, `CreateRoute` or `EnableVgwRoutePropagation`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_table_id: The ID of the routing table.
               
               One of the following destination arguments must be supplied:
        :param pulumi.Input[builtins.str] state: The state of the route - `active` or `blackhole`.
        :param pulumi.Input[builtins.str] transit_gateway_id: Identifier of an EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] vpc_endpoint_id: Identifier of a VPC Endpoint.
        :param pulumi.Input[builtins.str] vpc_peering_connection_id: Identifier of a VPC peering connection.
               
               Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["carrier_gateway_id"] = carrier_gateway_id
        __props__.__dict__["core_network_arn"] = core_network_arn
        __props__.__dict__["destination_cidr_block"] = destination_cidr_block
        __props__.__dict__["destination_ipv6_cidr_block"] = destination_ipv6_cidr_block
        __props__.__dict__["destination_prefix_list_id"] = destination_prefix_list_id
        __props__.__dict__["egress_only_gateway_id"] = egress_only_gateway_id
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_owner_id"] = instance_owner_id
        __props__.__dict__["local_gateway_id"] = local_gateway_id
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["origin"] = origin
        __props__.__dict__["region"] = region
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["state"] = state
        __props__.__dict__["transit_gateway_id"] = transit_gateway_id
        __props__.__dict__["vpc_endpoint_id"] = vpc_endpoint_id
        __props__.__dict__["vpc_peering_connection_id"] = vpc_peering_connection_id
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="carrierGatewayId")
    def carrier_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of a carrier gateway. This attribute can only be used when the VPC contains a subnet which is associated with a Wavelength Zone.
        """
        return pulumi.get(self, "carrier_gateway_id")

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of a core network.
        """
        return pulumi.get(self, "core_network_arn")

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The destination CIDR block.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter(name="destinationIpv6CidrBlock")
    def destination_ipv6_cidr_block(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The destination IPv6 CIDR block.
        """
        return pulumi.get(self, "destination_ipv6_cidr_block")

    @property
    @pulumi.getter(name="destinationPrefixListId")
    def destination_prefix_list_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of a managed prefix list destination.

        One of the following target arguments must be supplied:
        """
        return pulumi.get(self, "destination_prefix_list_id")

    @property
    @pulumi.getter(name="egressOnlyGatewayId")
    def egress_only_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of a VPC Egress Only Internet Gateway.
        """
        return pulumi.get(self, "egress_only_gateway_id")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of a VPC internet gateway or a virtual private gateway. Specify `local` when updating a previously imported local route.
        """
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of an EC2 instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceOwnerId")
    def instance_owner_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS account ID of the owner of the EC2 instance.
        """
        return pulumi.get(self, "instance_owner_id")

    @property
    @pulumi.getter(name="localGatewayId")
    def local_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of a Outpost local gateway.
        """
        return pulumi.get(self, "local_gateway_id")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of a VPC NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of an EC2 network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output[builtins.str]:
        """
        How the route was created - `CreateRouteTable`, `CreateRoute` or `EnableVgwRoutePropagation`.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the routing table.

        One of the following destination arguments must be supplied:
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the route - `active` or `blackhole`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of an EC2 Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_id")

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of a VPC Endpoint.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @property
    @pulumi.getter(name="vpcPeeringConnectionId")
    def vpc_peering_connection_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of a VPC peering connection.

        Note that the default route, mapping the VPC's CIDR block to "local", is created implicitly and cannot be specified.
        """
        return pulumi.get(self, "vpc_peering_connection_id")

