# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteTableAssociationArgs', 'RouteTableAssociation']

@pulumi.input_type
class RouteTableAssociationArgs:
    def __init__(__self__, *,
                 route_table_id: pulumi.Input[builtins.str],
                 gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RouteTableAssociation resource.
        :param pulumi.Input[builtins.str] route_table_id: The ID of the routing table to associate with.
               
               > **NOTE:** Please note that one of either `subnet_id` or `gateway_id` is required.
        :param pulumi.Input[builtins.str] gateway_id: The gateway ID to create an association. Conflicts with `subnet_id`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] subnet_id: The subnet ID to create an association. Conflicts with `gateway_id`.
        """
        pulumi.set(__self__, "route_table_id", route_table_id)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the routing table to associate with.

        > **NOTE:** Please note that one of either `subnet_id` or `gateway_id` is required.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The gateway ID to create an association. Conflicts with `subnet_id`.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subnet ID to create an association. Conflicts with `gateway_id`.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _RouteTableAssociationState:
    def __init__(__self__, *,
                 gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteTableAssociation resources.
        :param pulumi.Input[builtins.str] gateway_id: The gateway ID to create an association. Conflicts with `subnet_id`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_table_id: The ID of the routing table to associate with.
               
               > **NOTE:** Please note that one of either `subnet_id` or `gateway_id` is required.
        :param pulumi.Input[builtins.str] subnet_id: The subnet ID to create an association. Conflicts with `gateway_id`.
        """
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The gateway ID to create an association. Conflicts with `subnet_id`.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the routing table to associate with.

        > **NOTE:** Please note that one of either `subnet_id` or `gateway_id` is required.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subnet ID to create an association. Conflicts with `gateway_id`.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.type_token("aws:ec2/routeTableAssociation:RouteTableAssociation")
class RouteTableAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create an association between a route table and a subnet or a route table and an
        internet gateway or virtual private gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        a = aws.ec2.RouteTableAssociation("a",
            subnet_id=foo["id"],
            route_table_id=bar["id"])
        ```

        ```python
        import pulumi
        import pulumi_aws as aws

        b = aws.ec2.RouteTableAssociation("b",
            gateway_id=foo["id"],
            route_table_id=bar["id"])
        ```

        ## Import

        With EC2 Internet Gateways:

        __Using `pulumi import` to import__ EC2 Route Table Associations using the associated resource ID and Route Table ID separated by a forward slash (`/`). For example:

        With EC2 Subnets:

        ```sh
        $ pulumi import aws:ec2/routeTableAssociation:RouteTableAssociation assoc subnet-6777656e646f6c796e/rtb-656c65616e6f72
        ```
        With EC2 Internet Gateways:

        ```sh
        $ pulumi import aws:ec2/routeTableAssociation:RouteTableAssociation assoc igw-01b3a60780f8d034a/rtb-656c65616e6f72
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gateway_id: The gateway ID to create an association. Conflicts with `subnet_id`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_table_id: The ID of the routing table to associate with.
               
               > **NOTE:** Please note that one of either `subnet_id` or `gateway_id` is required.
        :param pulumi.Input[builtins.str] subnet_id: The subnet ID to create an association. Conflicts with `gateway_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteTableAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create an association between a route table and a subnet or a route table and an
        internet gateway or virtual private gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        a = aws.ec2.RouteTableAssociation("a",
            subnet_id=foo["id"],
            route_table_id=bar["id"])
        ```

        ```python
        import pulumi
        import pulumi_aws as aws

        b = aws.ec2.RouteTableAssociation("b",
            gateway_id=foo["id"],
            route_table_id=bar["id"])
        ```

        ## Import

        With EC2 Internet Gateways:

        __Using `pulumi import` to import__ EC2 Route Table Associations using the associated resource ID and Route Table ID separated by a forward slash (`/`). For example:

        With EC2 Subnets:

        ```sh
        $ pulumi import aws:ec2/routeTableAssociation:RouteTableAssociation assoc subnet-6777656e646f6c796e/rtb-656c65616e6f72
        ```
        With EC2 Internet Gateways:

        ```sh
        $ pulumi import aws:ec2/routeTableAssociation:RouteTableAssociation assoc igw-01b3a60780f8d034a/rtb-656c65616e6f72
        ```

        :param str resource_name: The name of the resource.
        :param RouteTableAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteTableAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteTableAssociationArgs.__new__(RouteTableAssociationArgs)

            __props__.__dict__["gateway_id"] = gateway_id
            __props__.__dict__["region"] = region
            if route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_table_id'")
            __props__.__dict__["route_table_id"] = route_table_id
            __props__.__dict__["subnet_id"] = subnet_id
        super(RouteTableAssociation, __self__).__init__(
            'aws:ec2/routeTableAssociation:RouteTableAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            route_table_id: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RouteTableAssociation':
        """
        Get an existing RouteTableAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gateway_id: The gateway ID to create an association. Conflicts with `subnet_id`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_table_id: The ID of the routing table to associate with.
               
               > **NOTE:** Please note that one of either `subnet_id` or `gateway_id` is required.
        :param pulumi.Input[builtins.str] subnet_id: The subnet ID to create an association. Conflicts with `gateway_id`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteTableAssociationState.__new__(_RouteTableAssociationState)

        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["region"] = region
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["subnet_id"] = subnet_id
        return RouteTableAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The gateway ID to create an association. Conflicts with `subnet_id`.
        """
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the routing table to associate with.

        > **NOTE:** Please note that one of either `subnet_id` or `gateway_id` is required.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The subnet ID to create an association. Conflicts with `gateway_id`.
        """
        return pulumi.get(self, "subnet_id")

