# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['SecurityGroupRuleArgs', 'SecurityGroupRule']

@pulumi.input_type
class SecurityGroupRuleArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[builtins.int],
                 protocol: pulumi.Input[Union[builtins.str, 'ProtocolType']],
                 security_group_id: pulumi.Input[builtins.str],
                 to_port: pulumi.Input[builtins.int],
                 type: pulumi.Input[builtins.str],
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 prefix_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 self: Optional[pulumi.Input[builtins.bool]] = None,
                 source_security_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityGroupRule resource.
        :param pulumi.Input[builtins.int] from_port: Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
        :param pulumi.Input[Union[builtins.str, 'ProtocolType']] protocol: Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
        :param pulumi.Input[builtins.str] security_group_id: Security group to apply this rule to.
        :param pulumi.Input[builtins.int] to_port: End port (or ICMP code if protocol is "icmp").
        :param pulumi.Input[builtins.str] type: Type of rule being created. Valid options are `ingress` (inbound)
               or `egress` (outbound).
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidr_blocks: List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        :param pulumi.Input[builtins.str] description: Description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_cidr_blocks: List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] prefix_list_ids: List of Prefix List IDs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
        :param pulumi.Input[builtins.bool] self: Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
        :param pulumi.Input[builtins.str] source_security_group_id: Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "to_port", to_port)
        pulumi.set(__self__, "type", type)
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ipv6_cidr_blocks is not None:
            pulumi.set(__self__, "ipv6_cidr_blocks", ipv6_cidr_blocks)
        if prefix_list_ids is not None:
            pulumi.set(__self__, "prefix_list_ids", prefix_list_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self is not None:
            pulumi.set(__self__, "self", self)
        if source_security_group_id is not None:
            pulumi.set(__self__, "source_security_group_id", source_security_group_id)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[builtins.int]:
        """
        Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[builtins.str, 'ProtocolType']]:
        """
        Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[builtins.str, 'ProtocolType']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[builtins.str]:
        """
        Security group to apply this rule to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[builtins.int]:
        """
        End port (or ICMP code if protocol is "icmp").
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "to_port", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of rule being created. Valid options are `ingress` (inbound)
        or `egress` (outbound).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        """
        return pulumi.get(self, "cidr_blocks")

    @cidr_blocks.setter
    def cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cidr_blocks", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipv6CidrBlocks")
    def ipv6_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        """
        return pulumi.get(self, "ipv6_cidr_blocks")

    @ipv6_cidr_blocks.setter
    def ipv6_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_cidr_blocks", value)

    @property
    @pulumi.getter(name="prefixListIds")
    def prefix_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of Prefix List IDs.
        """
        return pulumi.get(self, "prefix_list_ids")

    @prefix_list_ids.setter
    def prefix_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "prefix_list_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def self(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
        """
        return pulumi.get(self, "self")

    @self.setter
    def self(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "self", value)

    @property
    @pulumi.getter(name="sourceSecurityGroupId")
    def source_security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
        """
        return pulumi.get(self, "source_security_group_id")

    @source_security_group_id.setter
    def source_security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_security_group_id", value)


@pulumi.input_type
class _SecurityGroupRuleState:
    def __init__(__self__, *,
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 from_port: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 prefix_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[Union[builtins.str, 'ProtocolType']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 self: Optional[pulumi.Input[builtins.bool]] = None,
                 source_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 to_port: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityGroupRule resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidr_blocks: List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        :param pulumi.Input[builtins.str] description: Description of the rule.
        :param pulumi.Input[builtins.int] from_port: Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_cidr_blocks: List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] prefix_list_ids: List of Prefix List IDs.
        :param pulumi.Input[Union[builtins.str, 'ProtocolType']] protocol: Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
        :param pulumi.Input[builtins.str] security_group_id: Security group to apply this rule to.
        :param pulumi.Input[builtins.str] security_group_rule_id: If the `ec2.SecurityGroupRule` resource has a single source or destination then this is the AWS Security Group Rule resource ID. Otherwise it is empty.
        :param pulumi.Input[builtins.bool] self: Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
        :param pulumi.Input[builtins.str] source_security_group_id: Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
        :param pulumi.Input[builtins.int] to_port: End port (or ICMP code if protocol is "icmp").
        :param pulumi.Input[builtins.str] type: Type of rule being created. Valid options are `ingress` (inbound)
               or `egress` (outbound).
               
               The following arguments are optional:
        """
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if ipv6_cidr_blocks is not None:
            pulumi.set(__self__, "ipv6_cidr_blocks", ipv6_cidr_blocks)
        if prefix_list_ids is not None:
            pulumi.set(__self__, "prefix_list_ids", prefix_list_ids)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_rule_id is not None:
            pulumi.set(__self__, "security_group_rule_id", security_group_rule_id)
        if self is not None:
            pulumi.set(__self__, "self", self)
        if source_security_group_id is not None:
            pulumi.set(__self__, "source_security_group_id", source_security_group_id)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        """
        return pulumi.get(self, "cidr_blocks")

    @cidr_blocks.setter
    def cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cidr_blocks", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="ipv6CidrBlocks")
    def ipv6_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        """
        return pulumi.get(self, "ipv6_cidr_blocks")

    @ipv6_cidr_blocks.setter
    def ipv6_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6_cidr_blocks", value)

    @property
    @pulumi.getter(name="prefixListIds")
    def prefix_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of Prefix List IDs.
        """
        return pulumi.get(self, "prefix_list_ids")

    @prefix_list_ids.setter
    def prefix_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "prefix_list_ids", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[builtins.str, 'ProtocolType']]]:
        """
        Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[builtins.str, 'ProtocolType']]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Security group to apply this rule to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityGroupRuleId")
    def security_group_rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the `ec2.SecurityGroupRule` resource has a single source or destination then this is the AWS Security Group Rule resource ID. Otherwise it is empty.
        """
        return pulumi.get(self, "security_group_rule_id")

    @security_group_rule_id.setter
    def security_group_rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_group_rule_id", value)

    @property
    @pulumi.getter
    def self(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
        """
        return pulumi.get(self, "self")

    @self.setter
    def self(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "self", value)

    @property
    @pulumi.getter(name="sourceSecurityGroupId")
    def source_security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
        """
        return pulumi.get(self, "source_security_group_id")

    @source_security_group_id.setter
    def source_security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_security_group_id", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        End port (or ICMP code if protocol is "icmp").
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "to_port", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of rule being created. Valid options are `ingress` (inbound)
        or `egress` (outbound).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:ec2/securityGroupRule:SecurityGroupRule")
class SecurityGroupRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 from_port: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 prefix_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[Union[builtins.str, 'ProtocolType']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 self: Optional[pulumi.Input[builtins.bool]] = None,
                 source_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 to_port: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a security group rule resource. Represents a single `ingress` or `egress` group rule, which can be added to external Security Groups.

        > **NOTE:** Avoid using the `ec2.SecurityGroupRule` resource, as it struggles with managing multiple CIDR blocks, and, due to the historical lack of unique IDs, tags and descriptions. To avoid these problems, use the current best practice of the `vpc.SecurityGroupEgressRule` and `vpc.SecurityGroupIngressRule` resources with one CIDR block per rule.

        !> **WARNING:** You should not use the `ec2.SecurityGroupRule` resource in conjunction with `vpc.SecurityGroupEgressRule` and `vpc.SecurityGroupIngressRule` resources or with an `ec2.SecurityGroup` resource that has in-line rules. Doing so may cause rule conflicts, perpetual differences, and result in rules being overwritten.

        > **NOTE:** Setting `protocol = "all"` or `protocol = -1` with `from_port` and `to_port` will result in the EC2 API creating a security group rule with all ports open. This API behavior cannot be controlled by this provider and may generate warnings in the future.

        > **NOTE:** Referencing Security Groups across VPC peering has certain restrictions. More information is available in the [VPC Peering User Guide](https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html).

        ## Example Usage

        Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.SecurityGroupRule("example",
            type="ingress",
            from_port=0,
            to_port=65535,
            protocol=aws.ec2.ProtocolType.TCP,
            cidr_blocks=[example_aws_vpc["cidrBlock"]],
            ipv6_cidr_blocks=[example_aws_vpc["ipv6CidrBlock"]],
            security_group_id="sg-123456")
        ```

        ### Usage With Prefix List IDs

        Prefix Lists are either managed by AWS internally, or created by the customer using a
        Managed Prefix List resource. Prefix Lists provided by
        AWS are associated with a prefix list name, or service name, that is linked to a specific region.

        Prefix list IDs are exported on VPC Endpoints, so you can use this format:

        ```python
        import pulumi
        import pulumi_aws as aws

        # ...
        my_endpoint = aws.ec2.VpcEndpoint("my_endpoint")
        allow_all = aws.ec2.SecurityGroupRule("allow_all",
            type="egress",
            to_port=0,
            protocol="-1",
            prefix_list_ids=[my_endpoint.prefix_list_id],
            from_port=0,
            security_group_id="sg-123456")
        ```

        You can also find a specific Prefix List using the `ec2_get_prefix_list`
        or `ec2_managed_prefix_list` data sources:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        s3 = aws.ec2.get_prefix_list(name=f"com.amazonaws.{current.region}.s3")
        s3_gateway_egress = aws.ec2.SecurityGroupRule("s3_gateway_egress",
            description="S3 Gateway Egress",
            type="egress",
            security_group_id="sg-123456",
            from_port=443,
            to_port=443,
            protocol=aws.ec2.ProtocolType.TCP,
            prefix_list_ids=[s3.id])
        ```

        ## Import

        Import a rule with various IPv4 and IPv6 source CIDR blocks:

        Import a rule, applicable to all ports, with a protocol other than TCP/UDP/ICMP/ICMPV6/ALL, e.g., Multicast Transport Protocol (MTP), using the IANA protocol number. For example: 92.

        Import a default any/any egress rule to 0.0.0.0/0:

        Import an egress rule with a prefix list ID destination:

        Import a rule applicable to all protocols and ports with a security group source:

        Import a rule that has itself and an IPv6 CIDR block as sources:

        __Using `pulumi import` to import__ Security Group Rules using the `security_group_id`, `type`, `protocol`, `from_port`, `to_port`, and source(s)/destination(s) (such as a `cidr_block`) separated by underscores (`_`). All parts are required. For example:

        __NOTE:__ Not all rule permissions (e.g., not all of a rule's CIDR blocks) need to be imported for this provider to manage rule permissions. However, importing some of a rule's permissions but not others, and then making changes to the rule will result in the creation of an additional rule to capture the updated permissions. Rule permissions that were not imported are left intact in the original rule.

        Import an ingress rule in security group `sg-6e616f6d69` for TCP port 8000 with an IPv4 destination CIDR of `10.0.3.0/24`:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-6e616f6d69_ingress_tcp_8000_8000_10.0.3.0/24
        ```
        Import a rule with various IPv4 and IPv6 source CIDR blocks:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-4973616163_ingress_tcp_100_121_10.1.0.0/16_2001:db8::/48_10.2.0.0/16_2002:db8::/48
        ```
        Import a rule, applicable to all ports, with a protocol other than TCP/UDP/ICMP/ICMPV6/ALL, e.g., Multicast Transport Protocol (MTP), using the IANA protocol number. For example: 92.

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-6777656e646f6c796e_ingress_92_0_65536_10.0.3.0/24_10.0.4.0/24
        ```
        Import a default any/any egress rule to 0.0.0.0/0:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule default_egress sg-6777656e646f6c796e_egress_all_0_0_0.0.0.0/0
        ```
        Import an egress rule with a prefix list ID destination:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule egress sg-62726f6479_egress_tcp_8000_8000_pl-6469726b
        ```
        Import a rule applicable to all protocols and ports with a security group source:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress_rule sg-7472697374616e_ingress_all_0_65536_sg-6176657279
        ```
        Import a rule that has itself and an IPv6 CIDR block as sources:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule rule_name sg-656c65616e6f72_ingress_tcp_80_80_self_2001:db8::/48
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidr_blocks: List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        :param pulumi.Input[builtins.str] description: Description of the rule.
        :param pulumi.Input[builtins.int] from_port: Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_cidr_blocks: List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] prefix_list_ids: List of Prefix List IDs.
        :param pulumi.Input[Union[builtins.str, 'ProtocolType']] protocol: Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
        :param pulumi.Input[builtins.str] security_group_id: Security group to apply this rule to.
        :param pulumi.Input[builtins.bool] self: Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
        :param pulumi.Input[builtins.str] source_security_group_id: Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
        :param pulumi.Input[builtins.int] to_port: End port (or ICMP code if protocol is "icmp").
        :param pulumi.Input[builtins.str] type: Type of rule being created. Valid options are `ingress` (inbound)
               or `egress` (outbound).
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGroupRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a security group rule resource. Represents a single `ingress` or `egress` group rule, which can be added to external Security Groups.

        > **NOTE:** Avoid using the `ec2.SecurityGroupRule` resource, as it struggles with managing multiple CIDR blocks, and, due to the historical lack of unique IDs, tags and descriptions. To avoid these problems, use the current best practice of the `vpc.SecurityGroupEgressRule` and `vpc.SecurityGroupIngressRule` resources with one CIDR block per rule.

        !> **WARNING:** You should not use the `ec2.SecurityGroupRule` resource in conjunction with `vpc.SecurityGroupEgressRule` and `vpc.SecurityGroupIngressRule` resources or with an `ec2.SecurityGroup` resource that has in-line rules. Doing so may cause rule conflicts, perpetual differences, and result in rules being overwritten.

        > **NOTE:** Setting `protocol = "all"` or `protocol = -1` with `from_port` and `to_port` will result in the EC2 API creating a security group rule with all ports open. This API behavior cannot be controlled by this provider and may generate warnings in the future.

        > **NOTE:** Referencing Security Groups across VPC peering has certain restrictions. More information is available in the [VPC Peering User Guide](https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-security-groups.html).

        ## Example Usage

        Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.SecurityGroupRule("example",
            type="ingress",
            from_port=0,
            to_port=65535,
            protocol=aws.ec2.ProtocolType.TCP,
            cidr_blocks=[example_aws_vpc["cidrBlock"]],
            ipv6_cidr_blocks=[example_aws_vpc["ipv6CidrBlock"]],
            security_group_id="sg-123456")
        ```

        ### Usage With Prefix List IDs

        Prefix Lists are either managed by AWS internally, or created by the customer using a
        Managed Prefix List resource. Prefix Lists provided by
        AWS are associated with a prefix list name, or service name, that is linked to a specific region.

        Prefix list IDs are exported on VPC Endpoints, so you can use this format:

        ```python
        import pulumi
        import pulumi_aws as aws

        # ...
        my_endpoint = aws.ec2.VpcEndpoint("my_endpoint")
        allow_all = aws.ec2.SecurityGroupRule("allow_all",
            type="egress",
            to_port=0,
            protocol="-1",
            prefix_list_ids=[my_endpoint.prefix_list_id],
            from_port=0,
            security_group_id="sg-123456")
        ```

        You can also find a specific Prefix List using the `ec2_get_prefix_list`
        or `ec2_managed_prefix_list` data sources:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        s3 = aws.ec2.get_prefix_list(name=f"com.amazonaws.{current.region}.s3")
        s3_gateway_egress = aws.ec2.SecurityGroupRule("s3_gateway_egress",
            description="S3 Gateway Egress",
            type="egress",
            security_group_id="sg-123456",
            from_port=443,
            to_port=443,
            protocol=aws.ec2.ProtocolType.TCP,
            prefix_list_ids=[s3.id])
        ```

        ## Import

        Import a rule with various IPv4 and IPv6 source CIDR blocks:

        Import a rule, applicable to all ports, with a protocol other than TCP/UDP/ICMP/ICMPV6/ALL, e.g., Multicast Transport Protocol (MTP), using the IANA protocol number. For example: 92.

        Import a default any/any egress rule to 0.0.0.0/0:

        Import an egress rule with a prefix list ID destination:

        Import a rule applicable to all protocols and ports with a security group source:

        Import a rule that has itself and an IPv6 CIDR block as sources:

        __Using `pulumi import` to import__ Security Group Rules using the `security_group_id`, `type`, `protocol`, `from_port`, `to_port`, and source(s)/destination(s) (such as a `cidr_block`) separated by underscores (`_`). All parts are required. For example:

        __NOTE:__ Not all rule permissions (e.g., not all of a rule's CIDR blocks) need to be imported for this provider to manage rule permissions. However, importing some of a rule's permissions but not others, and then making changes to the rule will result in the creation of an additional rule to capture the updated permissions. Rule permissions that were not imported are left intact in the original rule.

        Import an ingress rule in security group `sg-6e616f6d69` for TCP port 8000 with an IPv4 destination CIDR of `10.0.3.0/24`:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-6e616f6d69_ingress_tcp_8000_8000_10.0.3.0/24
        ```
        Import a rule with various IPv4 and IPv6 source CIDR blocks:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-4973616163_ingress_tcp_100_121_10.1.0.0/16_2001:db8::/48_10.2.0.0/16_2002:db8::/48
        ```
        Import a rule, applicable to all ports, with a protocol other than TCP/UDP/ICMP/ICMPV6/ALL, e.g., Multicast Transport Protocol (MTP), using the IANA protocol number. For example: 92.

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress sg-6777656e646f6c796e_ingress_92_0_65536_10.0.3.0/24_10.0.4.0/24
        ```
        Import a default any/any egress rule to 0.0.0.0/0:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule default_egress sg-6777656e646f6c796e_egress_all_0_0_0.0.0.0/0
        ```
        Import an egress rule with a prefix list ID destination:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule egress sg-62726f6479_egress_tcp_8000_8000_pl-6469726b
        ```
        Import a rule applicable to all protocols and ports with a security group source:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule ingress_rule sg-7472697374616e_ingress_all_0_65536_sg-6176657279
        ```
        Import a rule that has itself and an IPv6 CIDR block as sources:

        ```sh
        $ pulumi import aws:ec2/securityGroupRule:SecurityGroupRule rule_name sg-656c65616e6f72_ingress_tcp_80_80_self_2001:db8::/48
        ```

        :param str resource_name: The name of the resource.
        :param SecurityGroupRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGroupRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 from_port: Optional[pulumi.Input[builtins.int]] = None,
                 ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 prefix_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[Union[builtins.str, 'ProtocolType']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 self: Optional[pulumi.Input[builtins.bool]] = None,
                 source_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 to_port: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGroupRuleArgs.__new__(SecurityGroupRuleArgs)

            __props__.__dict__["cidr_blocks"] = cidr_blocks
            __props__.__dict__["description"] = description
            if from_port is None and not opts.urn:
                raise TypeError("Missing required property 'from_port'")
            __props__.__dict__["from_port"] = from_port
            __props__.__dict__["ipv6_cidr_blocks"] = ipv6_cidr_blocks
            __props__.__dict__["prefix_list_ids"] = prefix_list_ids
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["self"] = self
            __props__.__dict__["source_security_group_id"] = source_security_group_id
            if to_port is None and not opts.urn:
                raise TypeError("Missing required property 'to_port'")
            __props__.__dict__["to_port"] = to_port
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["security_group_rule_id"] = None
        super(SecurityGroupRule, __self__).__init__(
            'aws:ec2/securityGroupRule:SecurityGroupRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            from_port: Optional[pulumi.Input[builtins.int]] = None,
            ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            prefix_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            protocol: Optional[pulumi.Input[Union[builtins.str, 'ProtocolType']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[builtins.str]] = None,
            security_group_rule_id: Optional[pulumi.Input[builtins.str]] = None,
            self: Optional[pulumi.Input[builtins.bool]] = None,
            source_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
            to_port: Optional[pulumi.Input[builtins.int]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'SecurityGroupRule':
        """
        Get an existing SecurityGroupRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidr_blocks: List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        :param pulumi.Input[builtins.str] description: Description of the rule.
        :param pulumi.Input[builtins.int] from_port: Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6_cidr_blocks: List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] prefix_list_ids: List of Prefix List IDs.
        :param pulumi.Input[Union[builtins.str, 'ProtocolType']] protocol: Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
        :param pulumi.Input[builtins.str] security_group_id: Security group to apply this rule to.
        :param pulumi.Input[builtins.str] security_group_rule_id: If the `ec2.SecurityGroupRule` resource has a single source or destination then this is the AWS Security Group Rule resource ID. Otherwise it is empty.
        :param pulumi.Input[builtins.bool] self: Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
        :param pulumi.Input[builtins.str] source_security_group_id: Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
        :param pulumi.Input[builtins.int] to_port: End port (or ICMP code if protocol is "icmp").
        :param pulumi.Input[builtins.str] type: Type of rule being created. Valid options are `ingress` (inbound)
               or `egress` (outbound).
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGroupRuleState.__new__(_SecurityGroupRuleState)

        __props__.__dict__["cidr_blocks"] = cidr_blocks
        __props__.__dict__["description"] = description
        __props__.__dict__["from_port"] = from_port
        __props__.__dict__["ipv6_cidr_blocks"] = ipv6_cidr_blocks
        __props__.__dict__["prefix_list_ids"] = prefix_list_ids
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_rule_id"] = security_group_rule_id
        __props__.__dict__["self"] = self
        __props__.__dict__["source_security_group_id"] = source_security_group_id
        __props__.__dict__["to_port"] = to_port
        __props__.__dict__["type"] = type
        return SecurityGroupRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        """
        return pulumi.get(self, "cidr_blocks")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Output[builtins.int]:
        """
        Start port (or ICMP type number if protocol is "icmp" or "icmpv6").
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="ipv6CidrBlocks")
    def ipv6_cidr_blocks(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of IPv6 CIDR blocks. Cannot be specified with `source_security_group_id` or `self`.
        """
        return pulumi.get(self, "ipv6_cidr_blocks")

    @property
    @pulumi.getter(name="prefixListIds")
    def prefix_list_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of Prefix List IDs.
        """
        return pulumi.get(self, "prefix_list_ids")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        Protocol. If not icmp, icmpv6, tcp, udp, or all use the [protocol number](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `source_security_group_id` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[builtins.str]:
        """
        Security group to apply this rule to.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityGroupRuleId")
    def security_group_rule_id(self) -> pulumi.Output[builtins.str]:
        """
        If the `ec2.SecurityGroupRule` resource has a single source or destination then this is the AWS Security Group Rule resource ID. Otherwise it is empty.
        """
        return pulumi.get(self, "security_group_rule_id")

    @property
    @pulumi.getter
    def self(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the security group itself will be added as a source to this ingress rule. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `source_security_group_id`.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter(name="sourceSecurityGroupId")
    def source_security_group_id(self) -> pulumi.Output[builtins.str]:
        """
        Security group id to allow access to/from, depending on the `type`. Cannot be specified with `cidr_blocks`, `ipv6_cidr_blocks`, or `self`.
        """
        return pulumi.get(self, "source_security_group_id")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Output[builtins.int]:
        """
        End port (or ICMP code if protocol is "icmp").
        """
        return pulumi.get(self, "to_port")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of rule being created. Valid options are `ingress` (inbound)
        or `egress` (outbound).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

