# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpotFleetRequestArgs', 'SpotFleetRequest']

@pulumi.input_type
class SpotFleetRequestArgs:
    def __init__(__self__, *,
                 iam_fleet_role: pulumi.Input[builtins.str],
                 target_capacity: pulumi.Input[builtins.int],
                 allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 context: Optional[pulumi.Input[builtins.str]] = None,
                 excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_interruption_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 instance_pools_to_use_count: Optional[pulumi.Input[builtins.int]] = None,
                 launch_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchSpecificationArgs']]]] = None,
                 launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchTemplateConfigArgs']]]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 on_demand_allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_max_total_price: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_target_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_maintenance_strategies: Optional[pulumi.Input['SpotFleetRequestSpotMaintenanceStrategiesArgs']] = None,
                 spot_price: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_capacity_unit_type: Optional[pulumi.Input[builtins.str]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 terminate_instances_on_delete: Optional[pulumi.Input[builtins.str]] = None,
                 terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[builtins.str]] = None,
                 wait_for_fulfillment: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a SpotFleetRequest resource.
        :param pulumi.Input[builtins.str] iam_fleet_role: Grants the Spot fleet permission to terminate
               Spot instances on your behalf when you cancel its Spot fleet request using
               CancelSpotFleetRequests or when the Spot fleet request expires, if you set
               terminateInstancesWithExpiration.
        :param pulumi.Input[builtins.int] target_capacity: The number of units to request. You can choose to set the
               target capacity in terms of instances or a performance characteristic that is
               important to your application workload, such as vCPUs, memory, or I/O.
        :param pulumi.Input[builtins.str] allocation_strategy: Indicates how to allocate the target capacity across
               the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
               `lowestPrice`.
        :param pulumi.Input[builtins.str] context: Reserved.
        :param pulumi.Input[builtins.str] excess_capacity_termination_policy: Indicates whether running Spot
               instances should be terminated if the target capacity of the Spot fleet
               request is decreased below the current size of the Spot fleet.
        :param pulumi.Input[builtins.str] fleet_type: The type of fleet request. Indicates whether the Spot Fleet only requests the target
               capacity or also attempts to maintain it. Default is `maintain`.
        :param pulumi.Input[builtins.str] instance_interruption_behaviour: Indicates whether a Spot
               instance stops or terminates when it is interrupted. Default is
               `terminate`.
        :param pulumi.Input[builtins.int] instance_pools_to_use_count: The number of Spot pools across which to allocate your target Spot capacity.
               Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
               the cheapest Spot pools and evenly allocates your target Spot capacity across
               the number of Spot pools that you specify.
        :param pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchSpecificationArgs']]] launch_specifications: Used to define the launch configuration of the
               spot-fleet request. Can be specified multiple times to define different bids
               across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
               
               **Note**: This takes in similar but not
               identical inputs as `ec2.Instance`.  There are limitations on
               what you can specify. See the list of officially supported inputs in the
               [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `ec2.Instance` parameter that corresponds to those inputs may be used and it have
               a additional parameter `iam_instance_profile_arn` takes `iam.InstanceProfile` attribute `arn` as input.
        :param pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchTemplateConfigArgs']]] launch_template_configs: Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] load_balancers: A list of elastic load balancer names to add to the Spot fleet.
        :param pulumi.Input[builtins.str] on_demand_allocation_strategy: The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
        :param pulumi.Input[builtins.str] on_demand_max_total_price: The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
        :param pulumi.Input[builtins.int] on_demand_target_capacity: The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_unhealthy_instances: Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
        :param pulumi.Input['SpotFleetRequestSpotMaintenanceStrategiesArgs'] spot_maintenance_strategies: Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
        :param pulumi.Input[builtins.str] spot_price: The maximum bid price per unit hour.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] target_capacity_unit_type: The unit for the target capacity. This can only be done with `instance_requirements` defined
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_group_arns: A list of `alb.TargetGroup` ARNs, for use with Application Load Balancing.
        :param pulumi.Input[builtins.str] terminate_instances_on_delete: Indicates whether running Spot
               instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
               If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
        :param pulumi.Input[builtins.bool] terminate_instances_with_expiration: Indicates whether running Spot
               instances should be terminated when the Spot fleet request expires.
        :param pulumi.Input[builtins.str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[builtins.str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
        :param pulumi.Input[builtins.bool] wait_for_fulfillment: If set, this provider will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        pulumi.set(__self__, "iam_fleet_role", iam_fleet_role)
        pulumi.set(__self__, "target_capacity", target_capacity)
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if excess_capacity_termination_policy is not None:
            pulumi.set(__self__, "excess_capacity_termination_policy", excess_capacity_termination_policy)
        if fleet_type is not None:
            pulumi.set(__self__, "fleet_type", fleet_type)
        if instance_interruption_behaviour is not None:
            pulumi.set(__self__, "instance_interruption_behaviour", instance_interruption_behaviour)
        if instance_pools_to_use_count is not None:
            pulumi.set(__self__, "instance_pools_to_use_count", instance_pools_to_use_count)
        if launch_specifications is not None:
            pulumi.set(__self__, "launch_specifications", launch_specifications)
        if launch_template_configs is not None:
            pulumi.set(__self__, "launch_template_configs", launch_template_configs)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if on_demand_allocation_strategy is not None:
            pulumi.set(__self__, "on_demand_allocation_strategy", on_demand_allocation_strategy)
        if on_demand_max_total_price is not None:
            pulumi.set(__self__, "on_demand_max_total_price", on_demand_max_total_price)
        if on_demand_target_capacity is not None:
            pulumi.set(__self__, "on_demand_target_capacity", on_demand_target_capacity)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replace_unhealthy_instances is not None:
            pulumi.set(__self__, "replace_unhealthy_instances", replace_unhealthy_instances)
        if spot_maintenance_strategies is not None:
            pulumi.set(__self__, "spot_maintenance_strategies", spot_maintenance_strategies)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_capacity_unit_type is not None:
            pulumi.set(__self__, "target_capacity_unit_type", target_capacity_unit_type)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if terminate_instances_on_delete is not None:
            pulumi.set(__self__, "terminate_instances_on_delete", terminate_instances_on_delete)
        if terminate_instances_with_expiration is not None:
            pulumi.set(__self__, "terminate_instances_with_expiration", terminate_instances_with_expiration)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)
        if wait_for_fulfillment is not None:
            pulumi.set(__self__, "wait_for_fulfillment", wait_for_fulfillment)

    @property
    @pulumi.getter(name="iamFleetRole")
    def iam_fleet_role(self) -> pulumi.Input[builtins.str]:
        """
        Grants the Spot fleet permission to terminate
        Spot instances on your behalf when you cancel its Spot fleet request using
        CancelSpotFleetRequests or when the Spot fleet request expires, if you set
        terminateInstancesWithExpiration.
        """
        return pulumi.get(self, "iam_fleet_role")

    @iam_fleet_role.setter
    def iam_fleet_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "iam_fleet_role", value)

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> pulumi.Input[builtins.int]:
        """
        The number of units to request. You can choose to set the
        target capacity in terms of instances or a performance characteristic that is
        important to your application workload, such as vCPUs, memory, or I/O.
        """
        return pulumi.get(self, "target_capacity")

    @target_capacity.setter
    def target_capacity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "target_capacity", value)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates how to allocate the target capacity across
        the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
        `lowestPrice`.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_strategy", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="excessCapacityTerminationPolicy")
    def excess_capacity_termination_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether running Spot
        instances should be terminated if the target capacity of the Spot fleet
        request is decreased below the current size of the Spot fleet.
        """
        return pulumi.get(self, "excess_capacity_termination_policy")

    @excess_capacity_termination_policy.setter
    def excess_capacity_termination_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "excess_capacity_termination_policy", value)

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of fleet request. Indicates whether the Spot Fleet only requests the target
        capacity or also attempts to maintain it. Default is `maintain`.
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_type", value)

    @property
    @pulumi.getter(name="instanceInterruptionBehaviour")
    def instance_interruption_behaviour(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether a Spot
        instance stops or terminates when it is interrupted. Default is
        `terminate`.
        """
        return pulumi.get(self, "instance_interruption_behaviour")

    @instance_interruption_behaviour.setter
    def instance_interruption_behaviour(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_interruption_behaviour", value)

    @property
    @pulumi.getter(name="instancePoolsToUseCount")
    def instance_pools_to_use_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Spot pools across which to allocate your target Spot capacity.
        Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
        the cheapest Spot pools and evenly allocates your target Spot capacity across
        the number of Spot pools that you specify.
        """
        return pulumi.get(self, "instance_pools_to_use_count")

    @instance_pools_to_use_count.setter
    def instance_pools_to_use_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_pools_to_use_count", value)

    @property
    @pulumi.getter(name="launchSpecifications")
    def launch_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchSpecificationArgs']]]]:
        """
        Used to define the launch configuration of the
        spot-fleet request. Can be specified multiple times to define different bids
        across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.

        **Note**: This takes in similar but not
        identical inputs as `ec2.Instance`.  There are limitations on
        what you can specify. See the list of officially supported inputs in the
        [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `ec2.Instance` parameter that corresponds to those inputs may be used and it have
        a additional parameter `iam_instance_profile_arn` takes `iam.InstanceProfile` attribute `arn` as input.
        """
        return pulumi.get(self, "launch_specifications")

    @launch_specifications.setter
    def launch_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchSpecificationArgs']]]]):
        pulumi.set(self, "launch_specifications", value)

    @property
    @pulumi.getter(name="launchTemplateConfigs")
    def launch_template_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchTemplateConfigArgs']]]]:
        """
        Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
        """
        return pulumi.get(self, "launch_template_configs")

    @launch_template_configs.setter
    def launch_template_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchTemplateConfigArgs']]]]):
        pulumi.set(self, "launch_template_configs", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of elastic load balancer names to add to the Spot fleet.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="onDemandAllocationStrategy")
    def on_demand_allocation_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
        """
        return pulumi.get(self, "on_demand_allocation_strategy")

    @on_demand_allocation_strategy.setter
    def on_demand_allocation_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_demand_allocation_strategy", value)

    @property
    @pulumi.getter(name="onDemandMaxTotalPrice")
    def on_demand_max_total_price(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
        """
        return pulumi.get(self, "on_demand_max_total_price")

    @on_demand_max_total_price.setter
    def on_demand_max_total_price(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_demand_max_total_price", value)

    @property
    @pulumi.getter(name="onDemandTargetCapacity")
    def on_demand_target_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
        """
        return pulumi.get(self, "on_demand_target_capacity")

    @on_demand_target_capacity.setter
    def on_demand_target_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "on_demand_target_capacity", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replaceUnhealthyInstances")
    def replace_unhealthy_instances(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
        """
        return pulumi.get(self, "replace_unhealthy_instances")

    @replace_unhealthy_instances.setter
    def replace_unhealthy_instances(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replace_unhealthy_instances", value)

    @property
    @pulumi.getter(name="spotMaintenanceStrategies")
    def spot_maintenance_strategies(self) -> Optional[pulumi.Input['SpotFleetRequestSpotMaintenanceStrategiesArgs']]:
        """
        Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
        """
        return pulumi.get(self, "spot_maintenance_strategies")

    @spot_maintenance_strategies.setter
    def spot_maintenance_strategies(self, value: Optional[pulumi.Input['SpotFleetRequestSpotMaintenanceStrategiesArgs']]):
        pulumi.set(self, "spot_maintenance_strategies", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum bid price per unit hour.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetCapacityUnitType")
    def target_capacity_unit_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unit for the target capacity. This can only be done with `instance_requirements` defined
        """
        return pulumi.get(self, "target_capacity_unit_type")

    @target_capacity_unit_type.setter
    def target_capacity_unit_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_capacity_unit_type", value)

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of `alb.TargetGroup` ARNs, for use with Application Load Balancing.
        """
        return pulumi.get(self, "target_group_arns")

    @target_group_arns.setter
    def target_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_group_arns", value)

    @property
    @pulumi.getter(name="terminateInstancesOnDelete")
    def terminate_instances_on_delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether running Spot
        instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
        If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
        """
        return pulumi.get(self, "terminate_instances_on_delete")

    @terminate_instances_on_delete.setter
    def terminate_instances_on_delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terminate_instances_on_delete", value)

    @property
    @pulumi.getter(name="terminateInstancesWithExpiration")
    def terminate_instances_with_expiration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether running Spot
        instances should be terminated when the Spot fleet request expires.
        """
        return pulumi.get(self, "terminate_instances_with_expiration")

    @terminate_instances_with_expiration.setter
    def terminate_instances_with_expiration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_instances_with_expiration", value)

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_from", value)

    @property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_until", value)

    @property
    @pulumi.getter(name="waitForFulfillment")
    def wait_for_fulfillment(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set, this provider will
        wait for the Spot Request to be fulfilled, and will throw an error if the
        timeout of 10m is reached.
        """
        return pulumi.get(self, "wait_for_fulfillment")

    @wait_for_fulfillment.setter
    def wait_for_fulfillment(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wait_for_fulfillment", value)


@pulumi.input_type
class _SpotFleetRequestState:
    def __init__(__self__, *,
                 allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 client_token: Optional[pulumi.Input[builtins.str]] = None,
                 context: Optional[pulumi.Input[builtins.str]] = None,
                 excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[builtins.str]] = None,
                 iam_fleet_role: Optional[pulumi.Input[builtins.str]] = None,
                 instance_interruption_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 instance_pools_to_use_count: Optional[pulumi.Input[builtins.int]] = None,
                 launch_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchSpecificationArgs']]]] = None,
                 launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchTemplateConfigArgs']]]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 on_demand_allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_max_total_price: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_target_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_maintenance_strategies: Optional[pulumi.Input['SpotFleetRequestSpotMaintenanceStrategiesArgs']] = None,
                 spot_price: Optional[pulumi.Input[builtins.str]] = None,
                 spot_request_state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 target_capacity_unit_type: Optional[pulumi.Input[builtins.str]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 terminate_instances_on_delete: Optional[pulumi.Input[builtins.str]] = None,
                 terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[builtins.str]] = None,
                 wait_for_fulfillment: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SpotFleetRequest resources.
        :param pulumi.Input[builtins.str] allocation_strategy: Indicates how to allocate the target capacity across
               the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
               `lowestPrice`.
        :param pulumi.Input[builtins.str] context: Reserved.
        :param pulumi.Input[builtins.str] excess_capacity_termination_policy: Indicates whether running Spot
               instances should be terminated if the target capacity of the Spot fleet
               request is decreased below the current size of the Spot fleet.
        :param pulumi.Input[builtins.str] fleet_type: The type of fleet request. Indicates whether the Spot Fleet only requests the target
               capacity or also attempts to maintain it. Default is `maintain`.
        :param pulumi.Input[builtins.str] iam_fleet_role: Grants the Spot fleet permission to terminate
               Spot instances on your behalf when you cancel its Spot fleet request using
               CancelSpotFleetRequests or when the Spot fleet request expires, if you set
               terminateInstancesWithExpiration.
        :param pulumi.Input[builtins.str] instance_interruption_behaviour: Indicates whether a Spot
               instance stops or terminates when it is interrupted. Default is
               `terminate`.
        :param pulumi.Input[builtins.int] instance_pools_to_use_count: The number of Spot pools across which to allocate your target Spot capacity.
               Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
               the cheapest Spot pools and evenly allocates your target Spot capacity across
               the number of Spot pools that you specify.
        :param pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchSpecificationArgs']]] launch_specifications: Used to define the launch configuration of the
               spot-fleet request. Can be specified multiple times to define different bids
               across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
               
               **Note**: This takes in similar but not
               identical inputs as `ec2.Instance`.  There are limitations on
               what you can specify. See the list of officially supported inputs in the
               [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `ec2.Instance` parameter that corresponds to those inputs may be used and it have
               a additional parameter `iam_instance_profile_arn` takes `iam.InstanceProfile` attribute `arn` as input.
        :param pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchTemplateConfigArgs']]] launch_template_configs: Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] load_balancers: A list of elastic load balancer names to add to the Spot fleet.
        :param pulumi.Input[builtins.str] on_demand_allocation_strategy: The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
        :param pulumi.Input[builtins.str] on_demand_max_total_price: The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
        :param pulumi.Input[builtins.int] on_demand_target_capacity: The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_unhealthy_instances: Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
        :param pulumi.Input['SpotFleetRequestSpotMaintenanceStrategiesArgs'] spot_maintenance_strategies: Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
        :param pulumi.Input[builtins.str] spot_price: The maximum bid price per unit hour.
        :param pulumi.Input[builtins.str] spot_request_state: The state of the Spot fleet request.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] target_capacity: The number of units to request. You can choose to set the
               target capacity in terms of instances or a performance characteristic that is
               important to your application workload, such as vCPUs, memory, or I/O.
        :param pulumi.Input[builtins.str] target_capacity_unit_type: The unit for the target capacity. This can only be done with `instance_requirements` defined
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_group_arns: A list of `alb.TargetGroup` ARNs, for use with Application Load Balancing.
        :param pulumi.Input[builtins.str] terminate_instances_on_delete: Indicates whether running Spot
               instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
               If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
        :param pulumi.Input[builtins.bool] terminate_instances_with_expiration: Indicates whether running Spot
               instances should be terminated when the Spot fleet request expires.
        :param pulumi.Input[builtins.str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[builtins.str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
        :param pulumi.Input[builtins.bool] wait_for_fulfillment: If set, this provider will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if excess_capacity_termination_policy is not None:
            pulumi.set(__self__, "excess_capacity_termination_policy", excess_capacity_termination_policy)
        if fleet_type is not None:
            pulumi.set(__self__, "fleet_type", fleet_type)
        if iam_fleet_role is not None:
            pulumi.set(__self__, "iam_fleet_role", iam_fleet_role)
        if instance_interruption_behaviour is not None:
            pulumi.set(__self__, "instance_interruption_behaviour", instance_interruption_behaviour)
        if instance_pools_to_use_count is not None:
            pulumi.set(__self__, "instance_pools_to_use_count", instance_pools_to_use_count)
        if launch_specifications is not None:
            pulumi.set(__self__, "launch_specifications", launch_specifications)
        if launch_template_configs is not None:
            pulumi.set(__self__, "launch_template_configs", launch_template_configs)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if on_demand_allocation_strategy is not None:
            pulumi.set(__self__, "on_demand_allocation_strategy", on_demand_allocation_strategy)
        if on_demand_max_total_price is not None:
            pulumi.set(__self__, "on_demand_max_total_price", on_demand_max_total_price)
        if on_demand_target_capacity is not None:
            pulumi.set(__self__, "on_demand_target_capacity", on_demand_target_capacity)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replace_unhealthy_instances is not None:
            pulumi.set(__self__, "replace_unhealthy_instances", replace_unhealthy_instances)
        if spot_maintenance_strategies is not None:
            pulumi.set(__self__, "spot_maintenance_strategies", spot_maintenance_strategies)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if spot_request_state is not None:
            pulumi.set(__self__, "spot_request_state", spot_request_state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)
        if target_capacity_unit_type is not None:
            pulumi.set(__self__, "target_capacity_unit_type", target_capacity_unit_type)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if terminate_instances_on_delete is not None:
            pulumi.set(__self__, "terminate_instances_on_delete", terminate_instances_on_delete)
        if terminate_instances_with_expiration is not None:
            pulumi.set(__self__, "terminate_instances_with_expiration", terminate_instances_with_expiration)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)
        if wait_for_fulfillment is not None:
            pulumi.set(__self__, "wait_for_fulfillment", wait_for_fulfillment)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates how to allocate the target capacity across
        the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
        `lowestPrice`.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_strategy", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="excessCapacityTerminationPolicy")
    def excess_capacity_termination_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether running Spot
        instances should be terminated if the target capacity of the Spot fleet
        request is decreased below the current size of the Spot fleet.
        """
        return pulumi.get(self, "excess_capacity_termination_policy")

    @excess_capacity_termination_policy.setter
    def excess_capacity_termination_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "excess_capacity_termination_policy", value)

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of fleet request. Indicates whether the Spot Fleet only requests the target
        capacity or also attempts to maintain it. Default is `maintain`.
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_type", value)

    @property
    @pulumi.getter(name="iamFleetRole")
    def iam_fleet_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Grants the Spot fleet permission to terminate
        Spot instances on your behalf when you cancel its Spot fleet request using
        CancelSpotFleetRequests or when the Spot fleet request expires, if you set
        terminateInstancesWithExpiration.
        """
        return pulumi.get(self, "iam_fleet_role")

    @iam_fleet_role.setter
    def iam_fleet_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_fleet_role", value)

    @property
    @pulumi.getter(name="instanceInterruptionBehaviour")
    def instance_interruption_behaviour(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether a Spot
        instance stops or terminates when it is interrupted. Default is
        `terminate`.
        """
        return pulumi.get(self, "instance_interruption_behaviour")

    @instance_interruption_behaviour.setter
    def instance_interruption_behaviour(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_interruption_behaviour", value)

    @property
    @pulumi.getter(name="instancePoolsToUseCount")
    def instance_pools_to_use_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Spot pools across which to allocate your target Spot capacity.
        Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
        the cheapest Spot pools and evenly allocates your target Spot capacity across
        the number of Spot pools that you specify.
        """
        return pulumi.get(self, "instance_pools_to_use_count")

    @instance_pools_to_use_count.setter
    def instance_pools_to_use_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_pools_to_use_count", value)

    @property
    @pulumi.getter(name="launchSpecifications")
    def launch_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchSpecificationArgs']]]]:
        """
        Used to define the launch configuration of the
        spot-fleet request. Can be specified multiple times to define different bids
        across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.

        **Note**: This takes in similar but not
        identical inputs as `ec2.Instance`.  There are limitations on
        what you can specify. See the list of officially supported inputs in the
        [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `ec2.Instance` parameter that corresponds to those inputs may be used and it have
        a additional parameter `iam_instance_profile_arn` takes `iam.InstanceProfile` attribute `arn` as input.
        """
        return pulumi.get(self, "launch_specifications")

    @launch_specifications.setter
    def launch_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchSpecificationArgs']]]]):
        pulumi.set(self, "launch_specifications", value)

    @property
    @pulumi.getter(name="launchTemplateConfigs")
    def launch_template_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchTemplateConfigArgs']]]]:
        """
        Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
        """
        return pulumi.get(self, "launch_template_configs")

    @launch_template_configs.setter
    def launch_template_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpotFleetRequestLaunchTemplateConfigArgs']]]]):
        pulumi.set(self, "launch_template_configs", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of elastic load balancer names to add to the Spot fleet.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="onDemandAllocationStrategy")
    def on_demand_allocation_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
        """
        return pulumi.get(self, "on_demand_allocation_strategy")

    @on_demand_allocation_strategy.setter
    def on_demand_allocation_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_demand_allocation_strategy", value)

    @property
    @pulumi.getter(name="onDemandMaxTotalPrice")
    def on_demand_max_total_price(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
        """
        return pulumi.get(self, "on_demand_max_total_price")

    @on_demand_max_total_price.setter
    def on_demand_max_total_price(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_demand_max_total_price", value)

    @property
    @pulumi.getter(name="onDemandTargetCapacity")
    def on_demand_target_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
        """
        return pulumi.get(self, "on_demand_target_capacity")

    @on_demand_target_capacity.setter
    def on_demand_target_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "on_demand_target_capacity", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replaceUnhealthyInstances")
    def replace_unhealthy_instances(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
        """
        return pulumi.get(self, "replace_unhealthy_instances")

    @replace_unhealthy_instances.setter
    def replace_unhealthy_instances(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replace_unhealthy_instances", value)

    @property
    @pulumi.getter(name="spotMaintenanceStrategies")
    def spot_maintenance_strategies(self) -> Optional[pulumi.Input['SpotFleetRequestSpotMaintenanceStrategiesArgs']]:
        """
        Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
        """
        return pulumi.get(self, "spot_maintenance_strategies")

    @spot_maintenance_strategies.setter
    def spot_maintenance_strategies(self, value: Optional[pulumi.Input['SpotFleetRequestSpotMaintenanceStrategiesArgs']]):
        pulumi.set(self, "spot_maintenance_strategies", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum bid price per unit hour.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter(name="spotRequestState")
    def spot_request_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the Spot fleet request.
        """
        return pulumi.get(self, "spot_request_state")

    @spot_request_state.setter
    def spot_request_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_request_state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of units to request. You can choose to set the
        target capacity in terms of instances or a performance characteristic that is
        important to your application workload, such as vCPUs, memory, or I/O.
        """
        return pulumi.get(self, "target_capacity")

    @target_capacity.setter
    def target_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "target_capacity", value)

    @property
    @pulumi.getter(name="targetCapacityUnitType")
    def target_capacity_unit_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unit for the target capacity. This can only be done with `instance_requirements` defined
        """
        return pulumi.get(self, "target_capacity_unit_type")

    @target_capacity_unit_type.setter
    def target_capacity_unit_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_capacity_unit_type", value)

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of `alb.TargetGroup` ARNs, for use with Application Load Balancing.
        """
        return pulumi.get(self, "target_group_arns")

    @target_group_arns.setter
    def target_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_group_arns", value)

    @property
    @pulumi.getter(name="terminateInstancesOnDelete")
    def terminate_instances_on_delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether running Spot
        instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
        If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
        """
        return pulumi.get(self, "terminate_instances_on_delete")

    @terminate_instances_on_delete.setter
    def terminate_instances_on_delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terminate_instances_on_delete", value)

    @property
    @pulumi.getter(name="terminateInstancesWithExpiration")
    def terminate_instances_with_expiration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether running Spot
        instances should be terminated when the Spot fleet request expires.
        """
        return pulumi.get(self, "terminate_instances_with_expiration")

    @terminate_instances_with_expiration.setter
    def terminate_instances_with_expiration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "terminate_instances_with_expiration", value)

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_from", value)

    @property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "valid_until", value)

    @property
    @pulumi.getter(name="waitForFulfillment")
    def wait_for_fulfillment(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set, this provider will
        wait for the Spot Request to be fulfilled, and will throw an error if the
        timeout of 10m is reached.
        """
        return pulumi.get(self, "wait_for_fulfillment")

    @wait_for_fulfillment.setter
    def wait_for_fulfillment(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wait_for_fulfillment", value)


@pulumi.type_token("aws:ec2/spotFleetRequest:SpotFleetRequest")
class SpotFleetRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 context: Optional[pulumi.Input[builtins.str]] = None,
                 excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[builtins.str]] = None,
                 iam_fleet_role: Optional[pulumi.Input[builtins.str]] = None,
                 instance_interruption_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 instance_pools_to_use_count: Optional[pulumi.Input[builtins.int]] = None,
                 launch_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchSpecificationArgs', 'SpotFleetRequestLaunchSpecificationArgsDict']]]]] = None,
                 launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchTemplateConfigArgs', 'SpotFleetRequestLaunchTemplateConfigArgsDict']]]]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 on_demand_allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_max_total_price: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_target_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_maintenance_strategies: Optional[pulumi.Input[Union['SpotFleetRequestSpotMaintenanceStrategiesArgs', 'SpotFleetRequestSpotMaintenanceStrategiesArgsDict']]] = None,
                 spot_price: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 target_capacity_unit_type: Optional[pulumi.Input[builtins.str]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 terminate_instances_on_delete: Optional[pulumi.Input[builtins.str]] = None,
                 terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[builtins.str]] = None,
                 wait_for_fulfillment: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Provides an EC2 Spot Fleet Request resource. This allows a fleet of Spot
        instances to be requested on the Spot market.

        > **NOTE [AWS strongly discourages](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use) the use of the legacy APIs called by this resource.
        We recommend using the EC2 Fleet or Auto Scaling Group resources instead.

        ## Example Usage

        ### Using launch specifications

        ```python
        import pulumi
        import pulumi_aws as aws

        # Request a Spot fleet
        cheap_compute = aws.ec2.SpotFleetRequest("cheap_compute",
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            spot_price="0.03",
            allocation_strategy="diversified",
            target_capacity=6,
            valid_until="2019-11-04T20:44:20Z",
            launch_specifications=[
                {
                    "instance_type": "m4.10xlarge",
                    "ami": "ami-1234",
                    "spot_price": "2.793",
                    "placement_tenancy": "dedicated",
                    "iam_instance_profile_arn": example["arn"],
                },
                {
                    "instance_type": "m4.4xlarge",
                    "ami": "ami-5678",
                    "key_name": "my-key",
                    "spot_price": "1.117",
                    "iam_instance_profile_arn": example["arn"],
                    "availability_zone": "us-west-1a",
                    "subnet_id": "subnet-1234",
                    "weighted_capacity": "35",
                    "root_block_devices": [{
                        "volume_size": 300,
                        "volume_type": "gp2",
                    }],
                    "tags": {
                        "Name": "spot-fleet-example",
                    },
                },
            ])
        ```

        ### Using launch templates

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ec2.LaunchTemplate("foo",
            name="launch-template",
            image_id="ami-516b9131",
            instance_type="m1.small",
            key_name="some-key")
        foo_spot_fleet_request = aws.ec2.SpotFleetRequest("foo",
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            spot_price="0.005",
            target_capacity=2,
            valid_until="2019-11-04T20:44:20Z",
            launch_template_configs=[{
                "launch_template_specification": {
                    "id": foo.id,
                    "version": foo.latest_version,
                },
            }],
            opts = pulumi.ResourceOptions(depends_on=[test_attach]))
        ```

        > **NOTE:** This provider does not support the functionality where multiple `subnet_id` or `availability_zone` parameters can be specified in the same
        launch configuration block. If you want to specify multiple values, then separate launch configuration blocks should be used or launch template overrides should be configured, one per subnet:

        ### Using multiple launch specifications

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ec2.SpotFleetRequest("foo",
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            spot_price="0.005",
            target_capacity=2,
            valid_until="2019-11-04T20:44:20Z",
            launch_specifications=[
                {
                    "instance_type": "m1.small",
                    "ami": "ami-d06a90b0",
                    "key_name": "my-key",
                    "availability_zone": "us-west-2a",
                },
                {
                    "instance_type": "m5.large",
                    "ami": "ami-d06a90b0",
                    "key_name": "my-key",
                    "availability_zone": "us-west-2a",
                },
            ])
        ```

        > In this example, we use a `dynamic` block to define zero or more `launch_specification` blocks, producing one for each element in the list of subnet ids.

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        subnets = config.require_object("subnets")
        example = aws.ec2.SpotFleetRequest("example",
            launch_specifications=[{
                "ami": "ami-1234",
                "instance_type": "m4.4xlarge",
                "subnet_id": entry["value"]["subnetId"],
                "vpc_security_group_ids": "sg-123456",
                "root_block_devices": [{
                    "volume_size": 8,
                    "volume_type": "gp2",
                    "delete_on_termination": True,
                }],
                "tags": {
                    "Name": "Spot Node",
                    "tag_builder": "builder",
                },
            } for entry in [{"key": k, "value": v} for k, v in [{
                "subnetId": s[1],
            } for s in subnets]]],
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            target_capacity=3,
            valid_until="2019-11-04T20:44:20Z",
            allocation_strategy="lowestPrice",
            fleet_type="request",
            wait_for_fulfillment=True,
            terminate_instances_with_expiration=True)
        ```

        ### Using multiple launch configurations

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.get_subnets(filters=[{
            "name": "vpc-id",
            "values": [vpc_id],
        }])
        foo = aws.ec2.LaunchTemplate("foo",
            name="launch-template",
            image_id="ami-516b9131",
            instance_type="m1.small",
            key_name="some-key")
        foo_spot_fleet_request = aws.ec2.SpotFleetRequest("foo",
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            spot_price="0.005",
            target_capacity=2,
            valid_until="2019-11-04T20:44:20Z",
            launch_template_configs=[{
                "launch_template_specification": {
                    "id": foo.id,
                    "version": foo.latest_version,
                },
                "overrides": [
                    {
                        "subnet_id": example.ids[0],
                    },
                    {
                        "subnet_id": example.ids[1],
                    },
                    {
                        "subnet_id": example.ids[2],
                    },
                ],
            }],
            opts = pulumi.ResourceOptions(depends_on=[test_attach]))
        ```

        ## Import

        Using `pulumi import`, import Spot Fleet Requests using `id`. For example:

        ```sh
        $ pulumi import aws:ec2/spotFleetRequest:SpotFleetRequest fleet sfr-005e9ec8-5546-4c31-b317-31a62325411e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allocation_strategy: Indicates how to allocate the target capacity across
               the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
               `lowestPrice`.
        :param pulumi.Input[builtins.str] context: Reserved.
        :param pulumi.Input[builtins.str] excess_capacity_termination_policy: Indicates whether running Spot
               instances should be terminated if the target capacity of the Spot fleet
               request is decreased below the current size of the Spot fleet.
        :param pulumi.Input[builtins.str] fleet_type: The type of fleet request. Indicates whether the Spot Fleet only requests the target
               capacity or also attempts to maintain it. Default is `maintain`.
        :param pulumi.Input[builtins.str] iam_fleet_role: Grants the Spot fleet permission to terminate
               Spot instances on your behalf when you cancel its Spot fleet request using
               CancelSpotFleetRequests or when the Spot fleet request expires, if you set
               terminateInstancesWithExpiration.
        :param pulumi.Input[builtins.str] instance_interruption_behaviour: Indicates whether a Spot
               instance stops or terminates when it is interrupted. Default is
               `terminate`.
        :param pulumi.Input[builtins.int] instance_pools_to_use_count: The number of Spot pools across which to allocate your target Spot capacity.
               Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
               the cheapest Spot pools and evenly allocates your target Spot capacity across
               the number of Spot pools that you specify.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchSpecificationArgs', 'SpotFleetRequestLaunchSpecificationArgsDict']]]] launch_specifications: Used to define the launch configuration of the
               spot-fleet request. Can be specified multiple times to define different bids
               across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
               
               **Note**: This takes in similar but not
               identical inputs as `ec2.Instance`.  There are limitations on
               what you can specify. See the list of officially supported inputs in the
               [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `ec2.Instance` parameter that corresponds to those inputs may be used and it have
               a additional parameter `iam_instance_profile_arn` takes `iam.InstanceProfile` attribute `arn` as input.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchTemplateConfigArgs', 'SpotFleetRequestLaunchTemplateConfigArgsDict']]]] launch_template_configs: Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] load_balancers: A list of elastic load balancer names to add to the Spot fleet.
        :param pulumi.Input[builtins.str] on_demand_allocation_strategy: The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
        :param pulumi.Input[builtins.str] on_demand_max_total_price: The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
        :param pulumi.Input[builtins.int] on_demand_target_capacity: The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_unhealthy_instances: Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
        :param pulumi.Input[Union['SpotFleetRequestSpotMaintenanceStrategiesArgs', 'SpotFleetRequestSpotMaintenanceStrategiesArgsDict']] spot_maintenance_strategies: Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
        :param pulumi.Input[builtins.str] spot_price: The maximum bid price per unit hour.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.int] target_capacity: The number of units to request. You can choose to set the
               target capacity in terms of instances or a performance characteristic that is
               important to your application workload, such as vCPUs, memory, or I/O.
        :param pulumi.Input[builtins.str] target_capacity_unit_type: The unit for the target capacity. This can only be done with `instance_requirements` defined
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_group_arns: A list of `alb.TargetGroup` ARNs, for use with Application Load Balancing.
        :param pulumi.Input[builtins.str] terminate_instances_on_delete: Indicates whether running Spot
               instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
               If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
        :param pulumi.Input[builtins.bool] terminate_instances_with_expiration: Indicates whether running Spot
               instances should be terminated when the Spot fleet request expires.
        :param pulumi.Input[builtins.str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[builtins.str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
        :param pulumi.Input[builtins.bool] wait_for_fulfillment: If set, this provider will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpotFleetRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EC2 Spot Fleet Request resource. This allows a fleet of Spot
        instances to be requested on the Spot market.

        > **NOTE [AWS strongly discourages](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use) the use of the legacy APIs called by this resource.
        We recommend using the EC2 Fleet or Auto Scaling Group resources instead.

        ## Example Usage

        ### Using launch specifications

        ```python
        import pulumi
        import pulumi_aws as aws

        # Request a Spot fleet
        cheap_compute = aws.ec2.SpotFleetRequest("cheap_compute",
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            spot_price="0.03",
            allocation_strategy="diversified",
            target_capacity=6,
            valid_until="2019-11-04T20:44:20Z",
            launch_specifications=[
                {
                    "instance_type": "m4.10xlarge",
                    "ami": "ami-1234",
                    "spot_price": "2.793",
                    "placement_tenancy": "dedicated",
                    "iam_instance_profile_arn": example["arn"],
                },
                {
                    "instance_type": "m4.4xlarge",
                    "ami": "ami-5678",
                    "key_name": "my-key",
                    "spot_price": "1.117",
                    "iam_instance_profile_arn": example["arn"],
                    "availability_zone": "us-west-1a",
                    "subnet_id": "subnet-1234",
                    "weighted_capacity": "35",
                    "root_block_devices": [{
                        "volume_size": 300,
                        "volume_type": "gp2",
                    }],
                    "tags": {
                        "Name": "spot-fleet-example",
                    },
                },
            ])
        ```

        ### Using launch templates

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ec2.LaunchTemplate("foo",
            name="launch-template",
            image_id="ami-516b9131",
            instance_type="m1.small",
            key_name="some-key")
        foo_spot_fleet_request = aws.ec2.SpotFleetRequest("foo",
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            spot_price="0.005",
            target_capacity=2,
            valid_until="2019-11-04T20:44:20Z",
            launch_template_configs=[{
                "launch_template_specification": {
                    "id": foo.id,
                    "version": foo.latest_version,
                },
            }],
            opts = pulumi.ResourceOptions(depends_on=[test_attach]))
        ```

        > **NOTE:** This provider does not support the functionality where multiple `subnet_id` or `availability_zone` parameters can be specified in the same
        launch configuration block. If you want to specify multiple values, then separate launch configuration blocks should be used or launch template overrides should be configured, one per subnet:

        ### Using multiple launch specifications

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ec2.SpotFleetRequest("foo",
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            spot_price="0.005",
            target_capacity=2,
            valid_until="2019-11-04T20:44:20Z",
            launch_specifications=[
                {
                    "instance_type": "m1.small",
                    "ami": "ami-d06a90b0",
                    "key_name": "my-key",
                    "availability_zone": "us-west-2a",
                },
                {
                    "instance_type": "m5.large",
                    "ami": "ami-d06a90b0",
                    "key_name": "my-key",
                    "availability_zone": "us-west-2a",
                },
            ])
        ```

        > In this example, we use a `dynamic` block to define zero or more `launch_specification` blocks, producing one for each element in the list of subnet ids.

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        subnets = config.require_object("subnets")
        example = aws.ec2.SpotFleetRequest("example",
            launch_specifications=[{
                "ami": "ami-1234",
                "instance_type": "m4.4xlarge",
                "subnet_id": entry["value"]["subnetId"],
                "vpc_security_group_ids": "sg-123456",
                "root_block_devices": [{
                    "volume_size": 8,
                    "volume_type": "gp2",
                    "delete_on_termination": True,
                }],
                "tags": {
                    "Name": "Spot Node",
                    "tag_builder": "builder",
                },
            } for entry in [{"key": k, "value": v} for k, v in [{
                "subnetId": s[1],
            } for s in subnets]]],
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            target_capacity=3,
            valid_until="2019-11-04T20:44:20Z",
            allocation_strategy="lowestPrice",
            fleet_type="request",
            wait_for_fulfillment=True,
            terminate_instances_with_expiration=True)
        ```

        ### Using multiple launch configurations

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.get_subnets(filters=[{
            "name": "vpc-id",
            "values": [vpc_id],
        }])
        foo = aws.ec2.LaunchTemplate("foo",
            name="launch-template",
            image_id="ami-516b9131",
            instance_type="m1.small",
            key_name="some-key")
        foo_spot_fleet_request = aws.ec2.SpotFleetRequest("foo",
            iam_fleet_role="arn:aws:iam::12345678:role/spot-fleet",
            spot_price="0.005",
            target_capacity=2,
            valid_until="2019-11-04T20:44:20Z",
            launch_template_configs=[{
                "launch_template_specification": {
                    "id": foo.id,
                    "version": foo.latest_version,
                },
                "overrides": [
                    {
                        "subnet_id": example.ids[0],
                    },
                    {
                        "subnet_id": example.ids[1],
                    },
                    {
                        "subnet_id": example.ids[2],
                    },
                ],
            }],
            opts = pulumi.ResourceOptions(depends_on=[test_attach]))
        ```

        ## Import

        Using `pulumi import`, import Spot Fleet Requests using `id`. For example:

        ```sh
        $ pulumi import aws:ec2/spotFleetRequest:SpotFleetRequest fleet sfr-005e9ec8-5546-4c31-b317-31a62325411e
        ```

        :param str resource_name: The name of the resource.
        :param SpotFleetRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpotFleetRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 context: Optional[pulumi.Input[builtins.str]] = None,
                 excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[builtins.str]] = None,
                 iam_fleet_role: Optional[pulumi.Input[builtins.str]] = None,
                 instance_interruption_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 instance_pools_to_use_count: Optional[pulumi.Input[builtins.int]] = None,
                 launch_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchSpecificationArgs', 'SpotFleetRequestLaunchSpecificationArgsDict']]]]] = None,
                 launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchTemplateConfigArgs', 'SpotFleetRequestLaunchTemplateConfigArgsDict']]]]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 on_demand_allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_max_total_price: Optional[pulumi.Input[builtins.str]] = None,
                 on_demand_target_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
                 spot_maintenance_strategies: Optional[pulumi.Input[Union['SpotFleetRequestSpotMaintenanceStrategiesArgs', 'SpotFleetRequestSpotMaintenanceStrategiesArgsDict']]] = None,
                 spot_price: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 target_capacity_unit_type: Optional[pulumi.Input[builtins.str]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 terminate_instances_on_delete: Optional[pulumi.Input[builtins.str]] = None,
                 terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
                 valid_from: Optional[pulumi.Input[builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[builtins.str]] = None,
                 wait_for_fulfillment: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpotFleetRequestArgs.__new__(SpotFleetRequestArgs)

            __props__.__dict__["allocation_strategy"] = allocation_strategy
            __props__.__dict__["context"] = context
            __props__.__dict__["excess_capacity_termination_policy"] = excess_capacity_termination_policy
            __props__.__dict__["fleet_type"] = fleet_type
            if iam_fleet_role is None and not opts.urn:
                raise TypeError("Missing required property 'iam_fleet_role'")
            __props__.__dict__["iam_fleet_role"] = iam_fleet_role
            __props__.__dict__["instance_interruption_behaviour"] = instance_interruption_behaviour
            __props__.__dict__["instance_pools_to_use_count"] = instance_pools_to_use_count
            __props__.__dict__["launch_specifications"] = launch_specifications
            __props__.__dict__["launch_template_configs"] = launch_template_configs
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["on_demand_allocation_strategy"] = on_demand_allocation_strategy
            __props__.__dict__["on_demand_max_total_price"] = on_demand_max_total_price
            __props__.__dict__["on_demand_target_capacity"] = on_demand_target_capacity
            __props__.__dict__["region"] = region
            __props__.__dict__["replace_unhealthy_instances"] = replace_unhealthy_instances
            __props__.__dict__["spot_maintenance_strategies"] = spot_maintenance_strategies
            __props__.__dict__["spot_price"] = spot_price
            __props__.__dict__["tags"] = tags
            if target_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'target_capacity'")
            __props__.__dict__["target_capacity"] = target_capacity
            __props__.__dict__["target_capacity_unit_type"] = target_capacity_unit_type
            __props__.__dict__["target_group_arns"] = target_group_arns
            __props__.__dict__["terminate_instances_on_delete"] = terminate_instances_on_delete
            __props__.__dict__["terminate_instances_with_expiration"] = terminate_instances_with_expiration
            __props__.__dict__["valid_from"] = valid_from
            __props__.__dict__["valid_until"] = valid_until
            __props__.__dict__["wait_for_fulfillment"] = wait_for_fulfillment
            __props__.__dict__["client_token"] = None
            __props__.__dict__["spot_request_state"] = None
            __props__.__dict__["tags_all"] = None
        super(SpotFleetRequest, __self__).__init__(
            'aws:ec2/spotFleetRequest:SpotFleetRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
            client_token: Optional[pulumi.Input[builtins.str]] = None,
            context: Optional[pulumi.Input[builtins.str]] = None,
            excess_capacity_termination_policy: Optional[pulumi.Input[builtins.str]] = None,
            fleet_type: Optional[pulumi.Input[builtins.str]] = None,
            iam_fleet_role: Optional[pulumi.Input[builtins.str]] = None,
            instance_interruption_behaviour: Optional[pulumi.Input[builtins.str]] = None,
            instance_pools_to_use_count: Optional[pulumi.Input[builtins.int]] = None,
            launch_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchSpecificationArgs', 'SpotFleetRequestLaunchSpecificationArgsDict']]]]] = None,
            launch_template_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchTemplateConfigArgs', 'SpotFleetRequestLaunchTemplateConfigArgsDict']]]]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            on_demand_allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
            on_demand_max_total_price: Optional[pulumi.Input[builtins.str]] = None,
            on_demand_target_capacity: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            replace_unhealthy_instances: Optional[pulumi.Input[builtins.bool]] = None,
            spot_maintenance_strategies: Optional[pulumi.Input[Union['SpotFleetRequestSpotMaintenanceStrategiesArgs', 'SpotFleetRequestSpotMaintenanceStrategiesArgsDict']]] = None,
            spot_price: Optional[pulumi.Input[builtins.str]] = None,
            spot_request_state: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_capacity: Optional[pulumi.Input[builtins.int]] = None,
            target_capacity_unit_type: Optional[pulumi.Input[builtins.str]] = None,
            target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            terminate_instances_on_delete: Optional[pulumi.Input[builtins.str]] = None,
            terminate_instances_with_expiration: Optional[pulumi.Input[builtins.bool]] = None,
            valid_from: Optional[pulumi.Input[builtins.str]] = None,
            valid_until: Optional[pulumi.Input[builtins.str]] = None,
            wait_for_fulfillment: Optional[pulumi.Input[builtins.bool]] = None) -> 'SpotFleetRequest':
        """
        Get an existing SpotFleetRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allocation_strategy: Indicates how to allocate the target capacity across
               the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
               `lowestPrice`.
        :param pulumi.Input[builtins.str] context: Reserved.
        :param pulumi.Input[builtins.str] excess_capacity_termination_policy: Indicates whether running Spot
               instances should be terminated if the target capacity of the Spot fleet
               request is decreased below the current size of the Spot fleet.
        :param pulumi.Input[builtins.str] fleet_type: The type of fleet request. Indicates whether the Spot Fleet only requests the target
               capacity or also attempts to maintain it. Default is `maintain`.
        :param pulumi.Input[builtins.str] iam_fleet_role: Grants the Spot fleet permission to terminate
               Spot instances on your behalf when you cancel its Spot fleet request using
               CancelSpotFleetRequests or when the Spot fleet request expires, if you set
               terminateInstancesWithExpiration.
        :param pulumi.Input[builtins.str] instance_interruption_behaviour: Indicates whether a Spot
               instance stops or terminates when it is interrupted. Default is
               `terminate`.
        :param pulumi.Input[builtins.int] instance_pools_to_use_count: The number of Spot pools across which to allocate your target Spot capacity.
               Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
               the cheapest Spot pools and evenly allocates your target Spot capacity across
               the number of Spot pools that you specify.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchSpecificationArgs', 'SpotFleetRequestLaunchSpecificationArgsDict']]]] launch_specifications: Used to define the launch configuration of the
               spot-fleet request. Can be specified multiple times to define different bids
               across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.
               
               **Note**: This takes in similar but not
               identical inputs as `ec2.Instance`.  There are limitations on
               what you can specify. See the list of officially supported inputs in the
               [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `ec2.Instance` parameter that corresponds to those inputs may be used and it have
               a additional parameter `iam_instance_profile_arn` takes `iam.InstanceProfile` attribute `arn` as input.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpotFleetRequestLaunchTemplateConfigArgs', 'SpotFleetRequestLaunchTemplateConfigArgsDict']]]] launch_template_configs: Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] load_balancers: A list of elastic load balancer names to add to the Spot fleet.
        :param pulumi.Input[builtins.str] on_demand_allocation_strategy: The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
        :param pulumi.Input[builtins.str] on_demand_max_total_price: The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
        :param pulumi.Input[builtins.int] on_demand_target_capacity: The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_unhealthy_instances: Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
        :param pulumi.Input[Union['SpotFleetRequestSpotMaintenanceStrategiesArgs', 'SpotFleetRequestSpotMaintenanceStrategiesArgsDict']] spot_maintenance_strategies: Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
        :param pulumi.Input[builtins.str] spot_price: The maximum bid price per unit hour.
        :param pulumi.Input[builtins.str] spot_request_state: The state of the Spot fleet request.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] target_capacity: The number of units to request. You can choose to set the
               target capacity in terms of instances or a performance characteristic that is
               important to your application workload, such as vCPUs, memory, or I/O.
        :param pulumi.Input[builtins.str] target_capacity_unit_type: The unit for the target capacity. This can only be done with `instance_requirements` defined
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_group_arns: A list of `alb.TargetGroup` ARNs, for use with Application Load Balancing.
        :param pulumi.Input[builtins.str] terminate_instances_on_delete: Indicates whether running Spot
               instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
               If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
        :param pulumi.Input[builtins.bool] terminate_instances_with_expiration: Indicates whether running Spot
               instances should be terminated when the Spot fleet request expires.
        :param pulumi.Input[builtins.str] valid_from: The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        :param pulumi.Input[builtins.str] valid_until: The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
        :param pulumi.Input[builtins.bool] wait_for_fulfillment: If set, this provider will
               wait for the Spot Request to be fulfilled, and will throw an error if the
               timeout of 10m is reached.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpotFleetRequestState.__new__(_SpotFleetRequestState)

        __props__.__dict__["allocation_strategy"] = allocation_strategy
        __props__.__dict__["client_token"] = client_token
        __props__.__dict__["context"] = context
        __props__.__dict__["excess_capacity_termination_policy"] = excess_capacity_termination_policy
        __props__.__dict__["fleet_type"] = fleet_type
        __props__.__dict__["iam_fleet_role"] = iam_fleet_role
        __props__.__dict__["instance_interruption_behaviour"] = instance_interruption_behaviour
        __props__.__dict__["instance_pools_to_use_count"] = instance_pools_to_use_count
        __props__.__dict__["launch_specifications"] = launch_specifications
        __props__.__dict__["launch_template_configs"] = launch_template_configs
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["on_demand_allocation_strategy"] = on_demand_allocation_strategy
        __props__.__dict__["on_demand_max_total_price"] = on_demand_max_total_price
        __props__.__dict__["on_demand_target_capacity"] = on_demand_target_capacity
        __props__.__dict__["region"] = region
        __props__.__dict__["replace_unhealthy_instances"] = replace_unhealthy_instances
        __props__.__dict__["spot_maintenance_strategies"] = spot_maintenance_strategies
        __props__.__dict__["spot_price"] = spot_price
        __props__.__dict__["spot_request_state"] = spot_request_state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_capacity"] = target_capacity
        __props__.__dict__["target_capacity_unit_type"] = target_capacity_unit_type
        __props__.__dict__["target_group_arns"] = target_group_arns
        __props__.__dict__["terminate_instances_on_delete"] = terminate_instances_on_delete
        __props__.__dict__["terminate_instances_with_expiration"] = terminate_instances_with_expiration
        __props__.__dict__["valid_from"] = valid_from
        __props__.__dict__["valid_until"] = valid_until
        __props__.__dict__["wait_for_fulfillment"] = wait_for_fulfillment
        return SpotFleetRequest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates how to allocate the target capacity across
        the Spot pools specified by the Spot fleet request. Valid values: `lowestPrice`, `diversified`, `capacityOptimized`, `capacityOptimizedPrioritized`, and `priceCapacityOptimized`. The default is
        `lowestPrice`.
        """
        return pulumi.get(self, "allocation_strategy")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="excessCapacityTerminationPolicy")
    def excess_capacity_termination_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates whether running Spot
        instances should be terminated if the target capacity of the Spot fleet
        request is decreased below the current size of the Spot fleet.
        """
        return pulumi.get(self, "excess_capacity_termination_policy")

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of fleet request. Indicates whether the Spot Fleet only requests the target
        capacity or also attempts to maintain it. Default is `maintain`.
        """
        return pulumi.get(self, "fleet_type")

    @property
    @pulumi.getter(name="iamFleetRole")
    def iam_fleet_role(self) -> pulumi.Output[builtins.str]:
        """
        Grants the Spot fleet permission to terminate
        Spot instances on your behalf when you cancel its Spot fleet request using
        CancelSpotFleetRequests or when the Spot fleet request expires, if you set
        terminateInstancesWithExpiration.
        """
        return pulumi.get(self, "iam_fleet_role")

    @property
    @pulumi.getter(name="instanceInterruptionBehaviour")
    def instance_interruption_behaviour(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates whether a Spot
        instance stops or terminates when it is interrupted. Default is
        `terminate`.
        """
        return pulumi.get(self, "instance_interruption_behaviour")

    @property
    @pulumi.getter(name="instancePoolsToUseCount")
    def instance_pools_to_use_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of Spot pools across which to allocate your target Spot capacity.
        Valid only when `allocation_strategy` is set to `lowestPrice`. Spot Fleet selects
        the cheapest Spot pools and evenly allocates your target Spot capacity across
        the number of Spot pools that you specify.
        """
        return pulumi.get(self, "instance_pools_to_use_count")

    @property
    @pulumi.getter(name="launchSpecifications")
    def launch_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.SpotFleetRequestLaunchSpecification']]]:
        """
        Used to define the launch configuration of the
        spot-fleet request. Can be specified multiple times to define different bids
        across different markets and instance types. Conflicts with `launch_template_config`. At least one of `launch_specification` or `launch_template_config` is required.

        **Note**: This takes in similar but not
        identical inputs as `ec2.Instance`.  There are limitations on
        what you can specify. See the list of officially supported inputs in the
        [reference documentation](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetLaunchSpecification.html). Any normal `ec2.Instance` parameter that corresponds to those inputs may be used and it have
        a additional parameter `iam_instance_profile_arn` takes `iam.InstanceProfile` attribute `arn` as input.
        """
        return pulumi.get(self, "launch_specifications")

    @property
    @pulumi.getter(name="launchTemplateConfigs")
    def launch_template_configs(self) -> pulumi.Output[Optional[Sequence['outputs.SpotFleetRequestLaunchTemplateConfig']]]:
        """
        Launch template configuration block. See Launch Template Configs below for more details. Conflicts with `launch_specification`. At least one of `launch_specification` or `launch_template_config` is required.
        """
        return pulumi.get(self, "launch_template_configs")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of elastic load balancer names to add to the Spot fleet.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="onDemandAllocationStrategy")
    def on_demand_allocation_strategy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The order of the launch template overrides to use in fulfilling On-Demand capacity. the possible values are: `lowestPrice` and `prioritized`. the default is `lowestPrice`.
        """
        return pulumi.get(self, "on_demand_allocation_strategy")

    @property
    @pulumi.getter(name="onDemandMaxTotalPrice")
    def on_demand_max_total_price(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The maximum amount per hour for On-Demand Instances that you're willing to pay. When the maximum amount you're willing to pay is reached, the fleet stops launching instances even if it hasn’t met the target capacity.
        """
        return pulumi.get(self, "on_demand_max_total_price")

    @property
    @pulumi.getter(name="onDemandTargetCapacity")
    def on_demand_target_capacity(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of On-Demand units to request. If the request type is `maintain`, you can specify a target capacity of 0 and add capacity later.
        """
        return pulumi.get(self, "on_demand_target_capacity")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replaceUnhealthyInstances")
    def replace_unhealthy_instances(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether Spot fleet should replace unhealthy instances. Default `false`.
        """
        return pulumi.get(self, "replace_unhealthy_instances")

    @property
    @pulumi.getter(name="spotMaintenanceStrategies")
    def spot_maintenance_strategies(self) -> pulumi.Output[Optional['outputs.SpotFleetRequestSpotMaintenanceStrategies']]:
        """
        Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
        """
        return pulumi.get(self, "spot_maintenance_strategies")

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The maximum bid price per unit hour.
        """
        return pulumi.get(self, "spot_price")

    @property
    @pulumi.getter(name="spotRequestState")
    def spot_request_state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the Spot fleet request.
        """
        return pulumi.get(self, "spot_request_state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> pulumi.Output[builtins.int]:
        """
        The number of units to request. You can choose to set the
        target capacity in terms of instances or a performance characteristic that is
        important to your application workload, such as vCPUs, memory, or I/O.
        """
        return pulumi.get(self, "target_capacity")

    @property
    @pulumi.getter(name="targetCapacityUnitType")
    def target_capacity_unit_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The unit for the target capacity. This can only be done with `instance_requirements` defined
        """
        return pulumi.get(self, "target_capacity_unit_type")

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of `alb.TargetGroup` ARNs, for use with Application Load Balancing.
        """
        return pulumi.get(self, "target_group_arns")

    @property
    @pulumi.getter(name="terminateInstancesOnDelete")
    def terminate_instances_on_delete(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates whether running Spot
        instances should be terminated when the resource is deleted (and the Spot fleet request cancelled).
        If no value is specified, the value of the `terminate_instances_with_expiration` argument is used.
        """
        return pulumi.get(self, "terminate_instances_on_delete")

    @property
    @pulumi.getter(name="terminateInstancesWithExpiration")
    def terminate_instances_with_expiration(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether running Spot
        instances should be terminated when the Spot fleet request expires.
        """
        return pulumi.get(self, "terminate_instances_with_expiration")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The end date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new Spot instance requests are placed or enabled to fulfill the request.
        """
        return pulumi.get(self, "valid_until")

    @property
    @pulumi.getter(name="waitForFulfillment")
    def wait_for_fulfillment(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set, this provider will
        wait for the Spot Request to be fulfilled, and will throw an error if the
        timeout of 10m is reached.
        """
        return pulumi.get(self, "wait_for_fulfillment")

