# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcBlockPublicAccessOptionsArgs', 'VpcBlockPublicAccessOptions']

@pulumi.input_type
class VpcBlockPublicAccessOptionsArgs:
    def __init__(__self__, *,
                 internet_gateway_block_mode: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['VpcBlockPublicAccessOptionsTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a VpcBlockPublicAccessOptions resource.
        :param pulumi.Input[builtins.str] internet_gateway_block_mode: Block mode. Needs to be one of `block-bidirectional`, `block-ingress`, `off`. If this resource is deleted, then this value will be set to `off` in the AWS account and region.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "internet_gateway_block_mode", internet_gateway_block_mode)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="internetGatewayBlockMode")
    def internet_gateway_block_mode(self) -> pulumi.Input[builtins.str]:
        """
        Block mode. Needs to be one of `block-bidirectional`, `block-ingress`, `off`. If this resource is deleted, then this value will be set to `off` in the AWS account and region.
        """
        return pulumi.get(self, "internet_gateway_block_mode")

    @internet_gateway_block_mode.setter
    def internet_gateway_block_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "internet_gateway_block_mode", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['VpcBlockPublicAccessOptionsTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['VpcBlockPublicAccessOptionsTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _VpcBlockPublicAccessOptionsState:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 internet_gateway_block_mode: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['VpcBlockPublicAccessOptionsTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering VpcBlockPublicAccessOptions resources.
        :param pulumi.Input[builtins.str] aws_account_id: The AWS account id to which these options apply.
        :param pulumi.Input[builtins.str] aws_region: The AWS region to which these options apply.
        :param pulumi.Input[builtins.str] internet_gateway_block_mode: Block mode. Needs to be one of `block-bidirectional`, `block-ingress`, `off`. If this resource is deleted, then this value will be set to `off` in the AWS account and region.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if internet_gateway_block_mode is not None:
            pulumi.set(__self__, "internet_gateway_block_mode", internet_gateway_block_mode)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account id to which these options apply.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS region to which these options apply.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter(name="internetGatewayBlockMode")
    def internet_gateway_block_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Block mode. Needs to be one of `block-bidirectional`, `block-ingress`, `off`. If this resource is deleted, then this value will be set to `off` in the AWS account and region.
        """
        return pulumi.get(self, "internet_gateway_block_mode")

    @internet_gateway_block_mode.setter
    def internet_gateway_block_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "internet_gateway_block_mode", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['VpcBlockPublicAccessOptionsTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['VpcBlockPublicAccessOptionsTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:ec2/vpcBlockPublicAccessOptions:VpcBlockPublicAccessOptions")
class VpcBlockPublicAccessOptions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_gateway_block_mode: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['VpcBlockPublicAccessOptionsTimeoutsArgs', 'VpcBlockPublicAccessOptionsTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS VPC Block Public Access Options.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.VpcBlockPublicAccessOptions("example", internet_gateway_block_mode="block-bidirectional")
        ```

        ## Import

        Using `pulumi import`, import VPC Block Public Access Options using the `aws_region`. For example:

        ```sh
        $ pulumi import aws:ec2/vpcBlockPublicAccessOptions:VpcBlockPublicAccessOptions example us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] internet_gateway_block_mode: Block mode. Needs to be one of `block-bidirectional`, `block-ingress`, `off`. If this resource is deleted, then this value will be set to `off` in the AWS account and region.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcBlockPublicAccessOptionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS VPC Block Public Access Options.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.VpcBlockPublicAccessOptions("example", internet_gateway_block_mode="block-bidirectional")
        ```

        ## Import

        Using `pulumi import`, import VPC Block Public Access Options using the `aws_region`. For example:

        ```sh
        $ pulumi import aws:ec2/vpcBlockPublicAccessOptions:VpcBlockPublicAccessOptions example us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param VpcBlockPublicAccessOptionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcBlockPublicAccessOptionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_gateway_block_mode: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['VpcBlockPublicAccessOptionsTimeoutsArgs', 'VpcBlockPublicAccessOptionsTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcBlockPublicAccessOptionsArgs.__new__(VpcBlockPublicAccessOptionsArgs)

            if internet_gateway_block_mode is None and not opts.urn:
                raise TypeError("Missing required property 'internet_gateway_block_mode'")
            __props__.__dict__["internet_gateway_block_mode"] = internet_gateway_block_mode
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["aws_account_id"] = None
            __props__.__dict__["aws_region"] = None
        super(VpcBlockPublicAccessOptions, __self__).__init__(
            'aws:ec2/vpcBlockPublicAccessOptions:VpcBlockPublicAccessOptions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
            aws_region: Optional[pulumi.Input[builtins.str]] = None,
            internet_gateway_block_mode: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['VpcBlockPublicAccessOptionsTimeoutsArgs', 'VpcBlockPublicAccessOptionsTimeoutsArgsDict']]] = None) -> 'VpcBlockPublicAccessOptions':
        """
        Get an existing VpcBlockPublicAccessOptions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_account_id: The AWS account id to which these options apply.
        :param pulumi.Input[builtins.str] aws_region: The AWS region to which these options apply.
        :param pulumi.Input[builtins.str] internet_gateway_block_mode: Block mode. Needs to be one of `block-bidirectional`, `block-ingress`, `off`. If this resource is deleted, then this value will be set to `off` in the AWS account and region.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcBlockPublicAccessOptionsState.__new__(_VpcBlockPublicAccessOptionsState)

        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["aws_region"] = aws_region
        __props__.__dict__["internet_gateway_block_mode"] = internet_gateway_block_mode
        __props__.__dict__["region"] = region
        __props__.__dict__["timeouts"] = timeouts
        return VpcBlockPublicAccessOptions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS account id to which these options apply.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Output[builtins.str]:
        """
        The AWS region to which these options apply.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="internetGatewayBlockMode")
    def internet_gateway_block_mode(self) -> pulumi.Output[builtins.str]:
        """
        Block mode. Needs to be one of `block-bidirectional`, `block-ingress`, `off`. If this resource is deleted, then this value will be set to `off` in the AWS account and region.
        """
        return pulumi.get(self, "internet_gateway_block_mode")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.VpcBlockPublicAccessOptionsTimeouts']]:
        return pulumi.get(self, "timeouts")

