# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcIpamPoolArgs', 'VpcIpamPool']

@pulumi.input_type
class VpcIpamPoolArgs:
    def __init__(__self__, *,
                 address_family: pulumi.Input[builtins.str],
                 ipam_scope_id: pulumi.Input[builtins.str],
                 allocation_default_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_max_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_min_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auto_import: Optional[pulumi.Input[builtins.bool]] = None,
                 aws_service: Optional[pulumi.Input[builtins.str]] = None,
                 cascade: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 locale: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_source: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_advertisable: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a VpcIpamPool resource.
        :param pulumi.Input[builtins.str] address_family: The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
        :param pulumi.Input[builtins.str] ipam_scope_id: The ID of the scope in which you would like to create the IPAM pool.
        :param pulumi.Input[builtins.int] allocation_default_netmask_length: A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
        :param pulumi.Input[builtins.int] allocation_max_netmask_length: The maximum netmask length that will be required for CIDR allocations in this pool.
        :param pulumi.Input[builtins.int] allocation_min_netmask_length: The minimum netmask length that will be required for CIDR allocations in this pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] allocation_resource_tags: Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
        :param pulumi.Input[builtins.bool] auto_import: If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
               within the CIDR range in the pool.
        :param pulumi.Input[builtins.str] aws_service: Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
        :param pulumi.Input[builtins.bool] cascade: Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs, allocations, and other pools.
        :param pulumi.Input[builtins.str] description: A description for the IPAM pool.
        :param pulumi.Input[builtins.str] locale: The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
        :param pulumi.Input[builtins.str] public_ip_source: The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
        :param pulumi.Input[builtins.bool] publicly_advertisable: Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`. Setting this argument to `true` when it is not available may result in erroneous differences being reported.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] source_ipam_pool_id: The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "address_family", address_family)
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if allocation_default_netmask_length is not None:
            pulumi.set(__self__, "allocation_default_netmask_length", allocation_default_netmask_length)
        if allocation_max_netmask_length is not None:
            pulumi.set(__self__, "allocation_max_netmask_length", allocation_max_netmask_length)
        if allocation_min_netmask_length is not None:
            pulumi.set(__self__, "allocation_min_netmask_length", allocation_min_netmask_length)
        if allocation_resource_tags is not None:
            pulumi.set(__self__, "allocation_resource_tags", allocation_resource_tags)
        if auto_import is not None:
            pulumi.set(__self__, "auto_import", auto_import)
        if aws_service is not None:
            pulumi.set(__self__, "aws_service", aws_service)
        if cascade is not None:
            pulumi.set(__self__, "cascade", cascade)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if public_ip_source is not None:
            pulumi.set(__self__, "public_ip_source", public_ip_source)
        if publicly_advertisable is not None:
            pulumi.set(__self__, "publicly_advertisable", publicly_advertisable)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_ipam_pool_id is not None:
            pulumi.set(__self__, "source_ipam_pool_id", source_ipam_pool_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> pulumi.Input[builtins.str]:
        """
        The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
        """
        return pulumi.get(self, "address_family")

    @address_family.setter
    def address_family(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "address_family", value)

    @property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the scope in which you would like to create the IPAM pool.
        """
        return pulumi.get(self, "ipam_scope_id")

    @ipam_scope_id.setter
    def ipam_scope_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ipam_scope_id", value)

    @property
    @pulumi.getter(name="allocationDefaultNetmaskLength")
    def allocation_default_netmask_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
        """
        return pulumi.get(self, "allocation_default_netmask_length")

    @allocation_default_netmask_length.setter
    def allocation_default_netmask_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocation_default_netmask_length", value)

    @property
    @pulumi.getter(name="allocationMaxNetmaskLength")
    def allocation_max_netmask_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum netmask length that will be required for CIDR allocations in this pool.
        """
        return pulumi.get(self, "allocation_max_netmask_length")

    @allocation_max_netmask_length.setter
    def allocation_max_netmask_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocation_max_netmask_length", value)

    @property
    @pulumi.getter(name="allocationMinNetmaskLength")
    def allocation_min_netmask_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum netmask length that will be required for CIDR allocations in this pool.
        """
        return pulumi.get(self, "allocation_min_netmask_length")

    @allocation_min_netmask_length.setter
    def allocation_min_netmask_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocation_min_netmask_length", value)

    @property
    @pulumi.getter(name="allocationResourceTags")
    def allocation_resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
        """
        return pulumi.get(self, "allocation_resource_tags")

    @allocation_resource_tags.setter
    def allocation_resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allocation_resource_tags", value)

    @property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
        within the CIDR range in the pool.
        """
        return pulumi.get(self, "auto_import")

    @auto_import.setter
    def auto_import(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_import", value)

    @property
    @pulumi.getter(name="awsService")
    def aws_service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
        """
        return pulumi.get(self, "aws_service")

    @aws_service.setter
    def aws_service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_service", value)

    @property
    @pulumi.getter
    def cascade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs, allocations, and other pools.
        """
        return pulumi.get(self, "cascade")

    @cascade.setter
    def cascade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cascade", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the IPAM pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter(name="publicIpSource")
    def public_ip_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
        """
        return pulumi.get(self, "public_ip_source")

    @public_ip_source.setter
    def public_ip_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip_source", value)

    @property
    @pulumi.getter(name="publiclyAdvertisable")
    def publicly_advertisable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`. Setting this argument to `true` when it is not available may result in erroneous differences being reported.
        """
        return pulumi.get(self, "publicly_advertisable")

    @publicly_advertisable.setter
    def publicly_advertisable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_advertisable", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @source_ipam_pool_id.setter
    def source_ipam_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_ipam_pool_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VpcIpamPoolState:
    def __init__(__self__, *,
                 address_family: Optional[pulumi.Input[builtins.str]] = None,
                 allocation_default_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_max_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_min_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 auto_import: Optional[pulumi.Input[builtins.bool]] = None,
                 aws_service: Optional[pulumi.Input[builtins.str]] = None,
                 cascade: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_scope_type: Optional[pulumi.Input[builtins.str]] = None,
                 locale: Optional[pulumi.Input[builtins.str]] = None,
                 pool_depth: Optional[pulumi.Input[builtins.int]] = None,
                 public_ip_source: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_advertisable: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VpcIpamPool resources.
        :param pulumi.Input[builtins.str] address_family: The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
        :param pulumi.Input[builtins.int] allocation_default_netmask_length: A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
        :param pulumi.Input[builtins.int] allocation_max_netmask_length: The maximum netmask length that will be required for CIDR allocations in this pool.
        :param pulumi.Input[builtins.int] allocation_min_netmask_length: The minimum netmask length that will be required for CIDR allocations in this pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] allocation_resource_tags: Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of IPAM
        :param pulumi.Input[builtins.bool] auto_import: If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
               within the CIDR range in the pool.
        :param pulumi.Input[builtins.str] aws_service: Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
        :param pulumi.Input[builtins.bool] cascade: Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs, allocations, and other pools.
        :param pulumi.Input[builtins.str] description: A description for the IPAM pool.
        :param pulumi.Input[builtins.str] ipam_scope_id: The ID of the scope in which you would like to create the IPAM pool.
        :param pulumi.Input[builtins.str] locale: The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
        :param pulumi.Input[builtins.str] public_ip_source: The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
        :param pulumi.Input[builtins.bool] publicly_advertisable: Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`. Setting this argument to `true` when it is not available may result in erroneous differences being reported.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] source_ipam_pool_id: The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
        :param pulumi.Input[builtins.str] state: The ID of the IPAM
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if address_family is not None:
            pulumi.set(__self__, "address_family", address_family)
        if allocation_default_netmask_length is not None:
            pulumi.set(__self__, "allocation_default_netmask_length", allocation_default_netmask_length)
        if allocation_max_netmask_length is not None:
            pulumi.set(__self__, "allocation_max_netmask_length", allocation_max_netmask_length)
        if allocation_min_netmask_length is not None:
            pulumi.set(__self__, "allocation_min_netmask_length", allocation_min_netmask_length)
        if allocation_resource_tags is not None:
            pulumi.set(__self__, "allocation_resource_tags", allocation_resource_tags)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_import is not None:
            pulumi.set(__self__, "auto_import", auto_import)
        if aws_service is not None:
            pulumi.set(__self__, "aws_service", aws_service)
        if cascade is not None:
            pulumi.set(__self__, "cascade", cascade)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ipam_scope_id is not None:
            pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if ipam_scope_type is not None:
            pulumi.set(__self__, "ipam_scope_type", ipam_scope_type)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if pool_depth is not None:
            pulumi.set(__self__, "pool_depth", pool_depth)
        if public_ip_source is not None:
            pulumi.set(__self__, "public_ip_source", public_ip_source)
        if publicly_advertisable is not None:
            pulumi.set(__self__, "publicly_advertisable", publicly_advertisable)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_ipam_pool_id is not None:
            pulumi.set(__self__, "source_ipam_pool_id", source_ipam_pool_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
        """
        return pulumi.get(self, "address_family")

    @address_family.setter
    def address_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_family", value)

    @property
    @pulumi.getter(name="allocationDefaultNetmaskLength")
    def allocation_default_netmask_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
        """
        return pulumi.get(self, "allocation_default_netmask_length")

    @allocation_default_netmask_length.setter
    def allocation_default_netmask_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocation_default_netmask_length", value)

    @property
    @pulumi.getter(name="allocationMaxNetmaskLength")
    def allocation_max_netmask_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum netmask length that will be required for CIDR allocations in this pool.
        """
        return pulumi.get(self, "allocation_max_netmask_length")

    @allocation_max_netmask_length.setter
    def allocation_max_netmask_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocation_max_netmask_length", value)

    @property
    @pulumi.getter(name="allocationMinNetmaskLength")
    def allocation_min_netmask_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum netmask length that will be required for CIDR allocations in this pool.
        """
        return pulumi.get(self, "allocation_min_netmask_length")

    @allocation_min_netmask_length.setter
    def allocation_min_netmask_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocation_min_netmask_length", value)

    @property
    @pulumi.getter(name="allocationResourceTags")
    def allocation_resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
        """
        return pulumi.get(self, "allocation_resource_tags")

    @allocation_resource_tags.setter
    def allocation_resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allocation_resource_tags", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of IPAM
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
        within the CIDR range in the pool.
        """
        return pulumi.get(self, "auto_import")

    @auto_import.setter
    def auto_import(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_import", value)

    @property
    @pulumi.getter(name="awsService")
    def aws_service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
        """
        return pulumi.get(self, "aws_service")

    @aws_service.setter
    def aws_service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_service", value)

    @property
    @pulumi.getter
    def cascade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs, allocations, and other pools.
        """
        return pulumi.get(self, "cascade")

    @cascade.setter
    def cascade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cascade", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the IPAM pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the scope in which you would like to create the IPAM pool.
        """
        return pulumi.get(self, "ipam_scope_id")

    @ipam_scope_id.setter
    def ipam_scope_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipam_scope_id", value)

    @property
    @pulumi.getter(name="ipamScopeType")
    def ipam_scope_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ipam_scope_type")

    @ipam_scope_type.setter
    def ipam_scope_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipam_scope_type", value)

    @property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter(name="poolDepth")
    def pool_depth(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "pool_depth")

    @pool_depth.setter
    def pool_depth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "pool_depth", value)

    @property
    @pulumi.getter(name="publicIpSource")
    def public_ip_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
        """
        return pulumi.get(self, "public_ip_source")

    @public_ip_source.setter
    def public_ip_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip_source", value)

    @property
    @pulumi.getter(name="publiclyAdvertisable")
    def publicly_advertisable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`. Setting this argument to `true` when it is not available may result in erroneous differences being reported.
        """
        return pulumi.get(self, "publicly_advertisable")

    @publicly_advertisable.setter
    def publicly_advertisable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_advertisable", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @source_ipam_pool_id.setter
    def source_ipam_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_ipam_pool_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the IPAM
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:ec2/vpcIpamPool:VpcIpamPool")
class VpcIpamPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_family: Optional[pulumi.Input[builtins.str]] = None,
                 allocation_default_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_max_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_min_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auto_import: Optional[pulumi.Input[builtins.bool]] = None,
                 aws_service: Optional[pulumi.Input[builtins.str]] = None,
                 cascade: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 locale: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_source: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_advertisable: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an IP address pool resource for IPAM.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        example = aws.ec2.VpcIpam("example", operating_regions=[{
            "region_name": current.region,
        }])
        example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
            address_family="ipv4",
            ipam_scope_id=example.private_default_scope_id,
            locale=current.region)
        ```

        Nested Pools:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        example = aws.ec2.VpcIpam("example", operating_regions=[{
            "region_name": current.region,
        }])
        parent = aws.ec2.VpcIpamPool("parent",
            address_family="ipv4",
            ipam_scope_id=example.private_default_scope_id)
        parent_test = aws.ec2.VpcIpamPoolCidr("parent_test",
            ipam_pool_id=parent.id,
            cidr="172.20.0.0/16")
        child = aws.ec2.VpcIpamPool("child",
            address_family="ipv4",
            ipam_scope_id=example.private_default_scope_id,
            locale=current.region,
            source_ipam_pool_id=parent.id)
        child_test = aws.ec2.VpcIpamPoolCidr("child_test",
            ipam_pool_id=child.id,
            cidr="172.20.0.0/24")
        ```

        ## Import

        Using `pulumi import`, import IPAMs using the IPAM pool `id`. For example:

        ```sh
        $ pulumi import aws:ec2/vpcIpamPool:VpcIpamPool example ipam-pool-0958f95207d978e1e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address_family: The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
        :param pulumi.Input[builtins.int] allocation_default_netmask_length: A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
        :param pulumi.Input[builtins.int] allocation_max_netmask_length: The maximum netmask length that will be required for CIDR allocations in this pool.
        :param pulumi.Input[builtins.int] allocation_min_netmask_length: The minimum netmask length that will be required for CIDR allocations in this pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] allocation_resource_tags: Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
        :param pulumi.Input[builtins.bool] auto_import: If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
               within the CIDR range in the pool.
        :param pulumi.Input[builtins.str] aws_service: Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
        :param pulumi.Input[builtins.bool] cascade: Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs, allocations, and other pools.
        :param pulumi.Input[builtins.str] description: A description for the IPAM pool.
        :param pulumi.Input[builtins.str] ipam_scope_id: The ID of the scope in which you would like to create the IPAM pool.
        :param pulumi.Input[builtins.str] locale: The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
        :param pulumi.Input[builtins.str] public_ip_source: The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
        :param pulumi.Input[builtins.bool] publicly_advertisable: Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`. Setting this argument to `true` when it is not available may result in erroneous differences being reported.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] source_ipam_pool_id: The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcIpamPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an IP address pool resource for IPAM.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        example = aws.ec2.VpcIpam("example", operating_regions=[{
            "region_name": current.region,
        }])
        example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
            address_family="ipv4",
            ipam_scope_id=example.private_default_scope_id,
            locale=current.region)
        ```

        Nested Pools:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        example = aws.ec2.VpcIpam("example", operating_regions=[{
            "region_name": current.region,
        }])
        parent = aws.ec2.VpcIpamPool("parent",
            address_family="ipv4",
            ipam_scope_id=example.private_default_scope_id)
        parent_test = aws.ec2.VpcIpamPoolCidr("parent_test",
            ipam_pool_id=parent.id,
            cidr="172.20.0.0/16")
        child = aws.ec2.VpcIpamPool("child",
            address_family="ipv4",
            ipam_scope_id=example.private_default_scope_id,
            locale=current.region,
            source_ipam_pool_id=parent.id)
        child_test = aws.ec2.VpcIpamPoolCidr("child_test",
            ipam_pool_id=child.id,
            cidr="172.20.0.0/24")
        ```

        ## Import

        Using `pulumi import`, import IPAMs using the IPAM pool `id`. For example:

        ```sh
        $ pulumi import aws:ec2/vpcIpamPool:VpcIpamPool example ipam-pool-0958f95207d978e1e
        ```

        :param str resource_name: The name of the resource.
        :param VpcIpamPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcIpamPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_family: Optional[pulumi.Input[builtins.str]] = None,
                 allocation_default_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_max_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_min_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 allocation_resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 auto_import: Optional[pulumi.Input[builtins.bool]] = None,
                 aws_service: Optional[pulumi.Input[builtins.str]] = None,
                 cascade: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 locale: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_source: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_advertisable: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcIpamPoolArgs.__new__(VpcIpamPoolArgs)

            if address_family is None and not opts.urn:
                raise TypeError("Missing required property 'address_family'")
            __props__.__dict__["address_family"] = address_family
            __props__.__dict__["allocation_default_netmask_length"] = allocation_default_netmask_length
            __props__.__dict__["allocation_max_netmask_length"] = allocation_max_netmask_length
            __props__.__dict__["allocation_min_netmask_length"] = allocation_min_netmask_length
            __props__.__dict__["allocation_resource_tags"] = allocation_resource_tags
            __props__.__dict__["auto_import"] = auto_import
            __props__.__dict__["aws_service"] = aws_service
            __props__.__dict__["cascade"] = cascade
            __props__.__dict__["description"] = description
            if ipam_scope_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_scope_id'")
            __props__.__dict__["ipam_scope_id"] = ipam_scope_id
            __props__.__dict__["locale"] = locale
            __props__.__dict__["public_ip_source"] = public_ip_source
            __props__.__dict__["publicly_advertisable"] = publicly_advertisable
            __props__.__dict__["region"] = region
            __props__.__dict__["source_ipam_pool_id"] = source_ipam_pool_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["ipam_scope_type"] = None
            __props__.__dict__["pool_depth"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags_all"] = None
        super(VpcIpamPool, __self__).__init__(
            'aws:ec2/vpcIpamPool:VpcIpamPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_family: Optional[pulumi.Input[builtins.str]] = None,
            allocation_default_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
            allocation_max_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
            allocation_min_netmask_length: Optional[pulumi.Input[builtins.int]] = None,
            allocation_resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            auto_import: Optional[pulumi.Input[builtins.bool]] = None,
            aws_service: Optional[pulumi.Input[builtins.str]] = None,
            cascade: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            ipam_scope_id: Optional[pulumi.Input[builtins.str]] = None,
            ipam_scope_type: Optional[pulumi.Input[builtins.str]] = None,
            locale: Optional[pulumi.Input[builtins.str]] = None,
            pool_depth: Optional[pulumi.Input[builtins.int]] = None,
            public_ip_source: Optional[pulumi.Input[builtins.str]] = None,
            publicly_advertisable: Optional[pulumi.Input[builtins.bool]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            source_ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'VpcIpamPool':
        """
        Get an existing VpcIpamPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address_family: The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
        :param pulumi.Input[builtins.int] allocation_default_netmask_length: A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
        :param pulumi.Input[builtins.int] allocation_max_netmask_length: The maximum netmask length that will be required for CIDR allocations in this pool.
        :param pulumi.Input[builtins.int] allocation_min_netmask_length: The minimum netmask length that will be required for CIDR allocations in this pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] allocation_resource_tags: Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of IPAM
        :param pulumi.Input[builtins.bool] auto_import: If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
               within the CIDR range in the pool.
        :param pulumi.Input[builtins.str] aws_service: Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
        :param pulumi.Input[builtins.bool] cascade: Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs, allocations, and other pools.
        :param pulumi.Input[builtins.str] description: A description for the IPAM pool.
        :param pulumi.Input[builtins.str] ipam_scope_id: The ID of the scope in which you would like to create the IPAM pool.
        :param pulumi.Input[builtins.str] locale: The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
        :param pulumi.Input[builtins.str] public_ip_source: The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
        :param pulumi.Input[builtins.bool] publicly_advertisable: Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`. Setting this argument to `true` when it is not available may result in erroneous differences being reported.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] source_ipam_pool_id: The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
        :param pulumi.Input[builtins.str] state: The ID of the IPAM
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcIpamPoolState.__new__(_VpcIpamPoolState)

        __props__.__dict__["address_family"] = address_family
        __props__.__dict__["allocation_default_netmask_length"] = allocation_default_netmask_length
        __props__.__dict__["allocation_max_netmask_length"] = allocation_max_netmask_length
        __props__.__dict__["allocation_min_netmask_length"] = allocation_min_netmask_length
        __props__.__dict__["allocation_resource_tags"] = allocation_resource_tags
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_import"] = auto_import
        __props__.__dict__["aws_service"] = aws_service
        __props__.__dict__["cascade"] = cascade
        __props__.__dict__["description"] = description
        __props__.__dict__["ipam_scope_id"] = ipam_scope_id
        __props__.__dict__["ipam_scope_type"] = ipam_scope_type
        __props__.__dict__["locale"] = locale
        __props__.__dict__["pool_depth"] = pool_depth
        __props__.__dict__["public_ip_source"] = public_ip_source
        __props__.__dict__["publicly_advertisable"] = publicly_advertisable
        __props__.__dict__["region"] = region
        __props__.__dict__["source_ipam_pool_id"] = source_ipam_pool_id
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return VpcIpamPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> pulumi.Output[builtins.str]:
        """
        The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter(name="allocationDefaultNetmaskLength")
    def allocation_default_netmask_length(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
        """
        return pulumi.get(self, "allocation_default_netmask_length")

    @property
    @pulumi.getter(name="allocationMaxNetmaskLength")
    def allocation_max_netmask_length(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum netmask length that will be required for CIDR allocations in this pool.
        """
        return pulumi.get(self, "allocation_max_netmask_length")

    @property
    @pulumi.getter(name="allocationMinNetmaskLength")
    def allocation_min_netmask_length(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum netmask length that will be required for CIDR allocations in this pool.
        """
        return pulumi.get(self, "allocation_min_netmask_length")

    @property
    @pulumi.getter(name="allocationResourceTags")
    def allocation_resource_tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
        """
        return pulumi.get(self, "allocation_resource_tags")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of IPAM
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
        within the CIDR range in the pool.
        """
        return pulumi.get(self, "auto_import")

    @property
    @pulumi.getter(name="awsService")
    def aws_service(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
        """
        return pulumi.get(self, "aws_service")

    @property
    @pulumi.getter
    def cascade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs, allocations, and other pools.
        """
        return pulumi.get(self, "cascade")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the IPAM pool.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the scope in which you would like to create the IPAM pool.
        """
        return pulumi.get(self, "ipam_scope_id")

    @property
    @pulumi.getter(name="ipamScopeType")
    def ipam_scope_type(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "ipam_scope_type")

    @property
    @pulumi.getter
    def locale(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter(name="poolDepth")
    def pool_depth(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "pool_depth")

    @property
    @pulumi.getter(name="publicIpSource")
    def public_ip_source(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
        """
        return pulumi.get(self, "public_ip_source")

    @property
    @pulumi.getter(name="publiclyAdvertisable")
    def publicly_advertisable(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`. Setting this argument to `true` when it is not available may result in erroneous differences being reported.
        """
        return pulumi.get(self, "publicly_advertisable")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the IPAM
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

