# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcIpamPoolCidrAllocationArgs', 'VpcIpamPoolCidrAllocation']

@pulumi.input_type
class VpcIpamPoolCidrAllocationArgs:
    def __init__(__self__, *,
                 ipam_pool_id: pulumi.Input[builtins.str],
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disallowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpcIpamPoolCidrAllocation resource.
        :param pulumi.Input[builtins.str] ipam_pool_id: The ID of the pool to which you want to assign a CIDR.
        :param pulumi.Input[builtins.str] cidr: The CIDR you want to assign to the pool.
        :param pulumi.Input[builtins.str] description: The description for the allocation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
        :param pulumi.Input[builtins.int] netmask_length: The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disallowed_cidrs is not None:
            pulumi.set(__self__, "disallowed_cidrs", disallowed_cidrs)
        if netmask_length is not None:
            pulumi.set(__self__, "netmask_length", netmask_length)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the pool to which you want to assign a CIDR.
        """
        return pulumi.get(self, "ipam_pool_id")

    @ipam_pool_id.setter
    def ipam_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ipam_pool_id", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR you want to assign to the pool.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the allocation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disallowedCidrs")
    def disallowed_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Exclude a particular CIDR range from being returned by the pool.
        """
        return pulumi.get(self, "disallowed_cidrs")

    @disallowed_cidrs.setter
    def disallowed_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "disallowed_cidrs", value)

    @property
    @pulumi.getter(name="netmaskLength")
    def netmask_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
        """
        return pulumi.get(self, "netmask_length")

    @netmask_length.setter
    def netmask_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "netmask_length", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _VpcIpamPoolCidrAllocationState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disallowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipam_pool_allocation_id: Optional[pulumi.Input[builtins.str]] = None,
                 ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_owner: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcIpamPoolCidrAllocation resources.
        :param pulumi.Input[builtins.str] cidr: The CIDR you want to assign to the pool.
        :param pulumi.Input[builtins.str] description: The description for the allocation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
        :param pulumi.Input[builtins.str] ipam_pool_id: The ID of the pool to which you want to assign a CIDR.
        :param pulumi.Input[builtins.int] netmask_length: The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_id: The ID of the resource.
        :param pulumi.Input[builtins.str] resource_owner: The owner of the resource.
        :param pulumi.Input[builtins.str] resource_type: The type of the resource.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disallowed_cidrs is not None:
            pulumi.set(__self__, "disallowed_cidrs", disallowed_cidrs)
        if ipam_pool_allocation_id is not None:
            pulumi.set(__self__, "ipam_pool_allocation_id", ipam_pool_allocation_id)
        if ipam_pool_id is not None:
            pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if netmask_length is not None:
            pulumi.set(__self__, "netmask_length", netmask_length)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_owner is not None:
            pulumi.set(__self__, "resource_owner", resource_owner)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR you want to assign to the pool.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description for the allocation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disallowedCidrs")
    def disallowed_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Exclude a particular CIDR range from being returned by the pool.
        """
        return pulumi.get(self, "disallowed_cidrs")

    @disallowed_cidrs.setter
    def disallowed_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "disallowed_cidrs", value)

    @property
    @pulumi.getter(name="ipamPoolAllocationId")
    def ipam_pool_allocation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ipam_pool_allocation_id")

    @ipam_pool_allocation_id.setter
    def ipam_pool_allocation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipam_pool_allocation_id", value)

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the pool to which you want to assign a CIDR.
        """
        return pulumi.get(self, "ipam_pool_id")

    @ipam_pool_id.setter
    def ipam_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipam_pool_id", value)

    @property
    @pulumi.getter(name="netmaskLength")
    def netmask_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
        """
        return pulumi.get(self, "netmask_length")

    @netmask_length.setter
    def netmask_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "netmask_length", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The owner of the resource.
        """
        return pulumi.get(self, "resource_owner")

    @resource_owner.setter
    def resource_owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_owner", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)


@pulumi.type_token("aws:ec2/vpcIpamPoolCidrAllocation:VpcIpamPoolCidrAllocation")
class VpcIpamPoolCidrAllocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disallowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Allocates (reserves) a CIDR from an IPAM address pool, preventing usage by IPAM. Only works for private IPv4.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        example_vpc_ipam = aws.ec2.VpcIpam("example", operating_regions=[{
            "region_name": current.region,
        }])
        example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
            address_family="ipv4",
            ipam_scope_id=example_vpc_ipam.private_default_scope_id,
            locale=current.region)
        example_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("example",
            ipam_pool_id=example_vpc_ipam_pool.id,
            cidr="172.20.0.0/16")
        example = aws.ec2.VpcIpamPoolCidrAllocation("example",
            ipam_pool_id=example_vpc_ipam_pool.id,
            cidr="172.20.0.0/24",
            opts = pulumi.ResourceOptions(depends_on=[example_vpc_ipam_pool_cidr]))
        ```

        With the `disallowed_cidrs` attribute:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        example_vpc_ipam = aws.ec2.VpcIpam("example", operating_regions=[{
            "region_name": current.region,
        }])
        example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
            address_family="ipv4",
            ipam_scope_id=example_vpc_ipam.private_default_scope_id,
            locale=current.region)
        example_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("example",
            ipam_pool_id=example_vpc_ipam_pool.id,
            cidr="172.20.0.0/16")
        example = aws.ec2.VpcIpamPoolCidrAllocation("example",
            ipam_pool_id=example_vpc_ipam_pool.id,
            netmask_length=28,
            disallowed_cidrs=["172.20.0.0/28"],
            opts = pulumi.ResourceOptions(depends_on=[example_vpc_ipam_pool_cidr]))
        ```

        ## Import

        Using `pulumi import`, import IPAM allocations using the allocation `id` and `pool id`, separated by `_`. For example:

        ```sh
        $ pulumi import aws:ec2/vpcIpamPoolCidrAllocation:VpcIpamPoolCidrAllocation example ipam-pool-alloc-0dc6d196509c049ba8b549ff99f639736_ipam-pool-07cfb559e0921fcbe
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cidr: The CIDR you want to assign to the pool.
        :param pulumi.Input[builtins.str] description: The description for the allocation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
        :param pulumi.Input[builtins.str] ipam_pool_id: The ID of the pool to which you want to assign a CIDR.
        :param pulumi.Input[builtins.int] netmask_length: The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcIpamPoolCidrAllocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allocates (reserves) a CIDR from an IPAM address pool, preventing usage by IPAM. Only works for private IPv4.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        example_vpc_ipam = aws.ec2.VpcIpam("example", operating_regions=[{
            "region_name": current.region,
        }])
        example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
            address_family="ipv4",
            ipam_scope_id=example_vpc_ipam.private_default_scope_id,
            locale=current.region)
        example_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("example",
            ipam_pool_id=example_vpc_ipam_pool.id,
            cidr="172.20.0.0/16")
        example = aws.ec2.VpcIpamPoolCidrAllocation("example",
            ipam_pool_id=example_vpc_ipam_pool.id,
            cidr="172.20.0.0/24",
            opts = pulumi.ResourceOptions(depends_on=[example_vpc_ipam_pool_cidr]))
        ```

        With the `disallowed_cidrs` attribute:

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_region()
        example_vpc_ipam = aws.ec2.VpcIpam("example", operating_regions=[{
            "region_name": current.region,
        }])
        example_vpc_ipam_pool = aws.ec2.VpcIpamPool("example",
            address_family="ipv4",
            ipam_scope_id=example_vpc_ipam.private_default_scope_id,
            locale=current.region)
        example_vpc_ipam_pool_cidr = aws.ec2.VpcIpamPoolCidr("example",
            ipam_pool_id=example_vpc_ipam_pool.id,
            cidr="172.20.0.0/16")
        example = aws.ec2.VpcIpamPoolCidrAllocation("example",
            ipam_pool_id=example_vpc_ipam_pool.id,
            netmask_length=28,
            disallowed_cidrs=["172.20.0.0/28"],
            opts = pulumi.ResourceOptions(depends_on=[example_vpc_ipam_pool_cidr]))
        ```

        ## Import

        Using `pulumi import`, import IPAM allocations using the allocation `id` and `pool id`, separated by `_`. For example:

        ```sh
        $ pulumi import aws:ec2/vpcIpamPoolCidrAllocation:VpcIpamPoolCidrAllocation example ipam-pool-alloc-0dc6d196509c049ba8b549ff99f639736_ipam-pool-07cfb559e0921fcbe
        ```

        :param str resource_name: The name of the resource.
        :param VpcIpamPoolCidrAllocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcIpamPoolCidrAllocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disallowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 netmask_length: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcIpamPoolCidrAllocationArgs.__new__(VpcIpamPoolCidrAllocationArgs)

            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["description"] = description
            __props__.__dict__["disallowed_cidrs"] = disallowed_cidrs
            if ipam_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_pool_id'")
            __props__.__dict__["ipam_pool_id"] = ipam_pool_id
            __props__.__dict__["netmask_length"] = netmask_length
            __props__.__dict__["region"] = region
            __props__.__dict__["ipam_pool_allocation_id"] = None
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["resource_owner"] = None
            __props__.__dict__["resource_type"] = None
        super(VpcIpamPoolCidrAllocation, __self__).__init__(
            'aws:ec2/vpcIpamPoolCidrAllocation:VpcIpamPoolCidrAllocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disallowed_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipam_pool_allocation_id: Optional[pulumi.Input[builtins.str]] = None,
            ipam_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            netmask_length: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resource_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_owner: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None) -> 'VpcIpamPoolCidrAllocation':
        """
        Get an existing VpcIpamPoolCidrAllocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cidr: The CIDR you want to assign to the pool.
        :param pulumi.Input[builtins.str] description: The description for the allocation.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
        :param pulumi.Input[builtins.str] ipam_pool_id: The ID of the pool to which you want to assign a CIDR.
        :param pulumi.Input[builtins.int] netmask_length: The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_id: The ID of the resource.
        :param pulumi.Input[builtins.str] resource_owner: The owner of the resource.
        :param pulumi.Input[builtins.str] resource_type: The type of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcIpamPoolCidrAllocationState.__new__(_VpcIpamPoolCidrAllocationState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["description"] = description
        __props__.__dict__["disallowed_cidrs"] = disallowed_cidrs
        __props__.__dict__["ipam_pool_allocation_id"] = ipam_pool_allocation_id
        __props__.__dict__["ipam_pool_id"] = ipam_pool_id
        __props__.__dict__["netmask_length"] = netmask_length
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_owner"] = resource_owner
        __props__.__dict__["resource_type"] = resource_type
        return VpcIpamPoolCidrAllocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[builtins.str]:
        """
        The CIDR you want to assign to the pool.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description for the allocation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disallowedCidrs")
    def disallowed_cidrs(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Exclude a particular CIDR range from being returned by the pool.
        """
        return pulumi.get(self, "disallowed_cidrs")

    @property
    @pulumi.getter(name="ipamPoolAllocationId")
    def ipam_pool_allocation_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "ipam_pool_allocation_id")

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the pool to which you want to assign a CIDR.
        """
        return pulumi.get(self, "ipam_pool_id")

    @property
    @pulumi.getter(name="netmaskLength")
    def netmask_length(self) -> pulumi.Output[builtins.int]:
        """
        The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
        """
        return pulumi.get(self, "netmask_length")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> pulumi.Output[builtins.str]:
        """
        The owner of the resource.
        """
        return pulumi.get(self, "resource_owner")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "resource_type")

