# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpnConnectionArgs', 'VpnConnection']

@pulumi.input_type
class VpnConnectionArgs:
    def __init__(__self__, *,
                 customer_gateway_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 enable_acceleration: Optional[pulumi.Input[builtins.bool]] = None,
                 local_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 local_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 outside_ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 preshared_key_storage: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 remote_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 remote_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 static_routes_only: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 transport_transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel1_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_log_options: Optional[pulumi.Input['VpnConnectionTunnel1LogOptionsArgs']] = None,
                 tunnel1_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel1_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel1_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_startup_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel2_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_log_options: Optional[pulumi.Input['VpnConnectionTunnel2LogOptionsArgs']] = None,
                 tunnel2_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel2_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel2_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_startup_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_inside_ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpnConnection resource.
        :param pulumi.Input[builtins.str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[builtins.str] type: The type of VPN connection. The only type AWS supports at this time is "ipsec.1".
        :param pulumi.Input[builtins.bool] enable_acceleration: Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] local_ipv4_network_cidr: The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
        :param pulumi.Input[builtins.str] local_ipv6_network_cidr: The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
        :param pulumi.Input[builtins.str] outside_ip_address_type: Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
        :param pulumi.Input[builtins.str] preshared_key_storage: Storage mode for the pre-shared key (PSK). Valid values are `Standard` (stored in the Site-to-Site VPN service) or `SecretsManager` (stored in AWS Secrets Manager).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] remote_ipv4_network_cidr: The IPv4 CIDR on the AWS side of the VPN connection.
        :param pulumi.Input[builtins.str] remote_ipv6_network_cidr: The IPv6 CIDR on the AWS side of the VPN connection.
        :param pulumi.Input[builtins.bool] static_routes_only: Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don't support BGP.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] transit_gateway_id: The ID of the EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] transport_transit_gateway_attachment_id: . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
        :param pulumi.Input[builtins.str] tunnel1_dpd_timeout_action: The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        :param pulumi.Input[builtins.int] tunnel1_dpd_timeout_seconds: The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
        :param pulumi.Input[builtins.bool] tunnel1_enable_tunnel_lifecycle_control: Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_ike_versions: The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
        :param pulumi.Input[builtins.str] tunnel1_inside_cidr: The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        :param pulumi.Input[builtins.str] tunnel1_inside_ipv6_cidr: The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        :param pulumi.Input['VpnConnectionTunnel1LogOptionsArgs'] tunnel1_log_options: Options for logging VPN tunnel activity. See Log Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel1_phase1_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase1_encryption_algorithms: List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase1_integrity_algorithms: One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel1_phase1_lifetime_seconds: The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel1_phase2_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase2_encryption_algorithms: List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase2_integrity_algorithms: List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel1_phase2_lifetime_seconds: The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        :param pulumi.Input[builtins.str] tunnel1_preshared_key: The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        :param pulumi.Input[builtins.int] tunnel1_rekey_fuzz_percentage: The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        :param pulumi.Input[builtins.int] tunnel1_rekey_margin_time_seconds: The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
        :param pulumi.Input[builtins.int] tunnel1_replay_window_size: The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
        :param pulumi.Input[builtins.str] tunnel1_startup_action: The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        :param pulumi.Input[builtins.str] tunnel2_dpd_timeout_action: The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        :param pulumi.Input[builtins.int] tunnel2_dpd_timeout_seconds: The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
        :param pulumi.Input[builtins.bool] tunnel2_enable_tunnel_lifecycle_control: Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_ike_versions: The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
        :param pulumi.Input[builtins.str] tunnel2_inside_cidr: The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        :param pulumi.Input[builtins.str] tunnel2_inside_ipv6_cidr: The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        :param pulumi.Input['VpnConnectionTunnel2LogOptionsArgs'] tunnel2_log_options: Options for logging VPN tunnel activity. See Log Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel2_phase1_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase1_encryption_algorithms: List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase1_integrity_algorithms: One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel2_phase1_lifetime_seconds: The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel2_phase2_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase2_encryption_algorithms: List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase2_integrity_algorithms: List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel2_phase2_lifetime_seconds: The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        :param pulumi.Input[builtins.str] tunnel2_preshared_key: The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        :param pulumi.Input[builtins.int] tunnel2_rekey_fuzz_percentage: The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        :param pulumi.Input[builtins.int] tunnel2_rekey_margin_time_seconds: The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
        :param pulumi.Input[builtins.int] tunnel2_replay_window_size: The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
        :param pulumi.Input[builtins.str] tunnel2_startup_action: The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        :param pulumi.Input[builtins.str] tunnel_inside_ip_version: Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the Virtual Private Gateway.
        """
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "type", type)
        if enable_acceleration is not None:
            pulumi.set(__self__, "enable_acceleration", enable_acceleration)
        if local_ipv4_network_cidr is not None:
            pulumi.set(__self__, "local_ipv4_network_cidr", local_ipv4_network_cidr)
        if local_ipv6_network_cidr is not None:
            pulumi.set(__self__, "local_ipv6_network_cidr", local_ipv6_network_cidr)
        if outside_ip_address_type is not None:
            pulumi.set(__self__, "outside_ip_address_type", outside_ip_address_type)
        if preshared_key_storage is not None:
            pulumi.set(__self__, "preshared_key_storage", preshared_key_storage)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_ipv4_network_cidr is not None:
            pulumi.set(__self__, "remote_ipv4_network_cidr", remote_ipv4_network_cidr)
        if remote_ipv6_network_cidr is not None:
            pulumi.set(__self__, "remote_ipv6_network_cidr", remote_ipv6_network_cidr)
        if static_routes_only is not None:
            pulumi.set(__self__, "static_routes_only", static_routes_only)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if transport_transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transport_transit_gateway_attachment_id", transport_transit_gateway_attachment_id)
        if tunnel1_dpd_timeout_action is not None:
            pulumi.set(__self__, "tunnel1_dpd_timeout_action", tunnel1_dpd_timeout_action)
        if tunnel1_dpd_timeout_seconds is not None:
            pulumi.set(__self__, "tunnel1_dpd_timeout_seconds", tunnel1_dpd_timeout_seconds)
        if tunnel1_enable_tunnel_lifecycle_control is not None:
            pulumi.set(__self__, "tunnel1_enable_tunnel_lifecycle_control", tunnel1_enable_tunnel_lifecycle_control)
        if tunnel1_ike_versions is not None:
            pulumi.set(__self__, "tunnel1_ike_versions", tunnel1_ike_versions)
        if tunnel1_inside_cidr is not None:
            pulumi.set(__self__, "tunnel1_inside_cidr", tunnel1_inside_cidr)
        if tunnel1_inside_ipv6_cidr is not None:
            pulumi.set(__self__, "tunnel1_inside_ipv6_cidr", tunnel1_inside_ipv6_cidr)
        if tunnel1_log_options is not None:
            pulumi.set(__self__, "tunnel1_log_options", tunnel1_log_options)
        if tunnel1_phase1_dh_group_numbers is not None:
            pulumi.set(__self__, "tunnel1_phase1_dh_group_numbers", tunnel1_phase1_dh_group_numbers)
        if tunnel1_phase1_encryption_algorithms is not None:
            pulumi.set(__self__, "tunnel1_phase1_encryption_algorithms", tunnel1_phase1_encryption_algorithms)
        if tunnel1_phase1_integrity_algorithms is not None:
            pulumi.set(__self__, "tunnel1_phase1_integrity_algorithms", tunnel1_phase1_integrity_algorithms)
        if tunnel1_phase1_lifetime_seconds is not None:
            pulumi.set(__self__, "tunnel1_phase1_lifetime_seconds", tunnel1_phase1_lifetime_seconds)
        if tunnel1_phase2_dh_group_numbers is not None:
            pulumi.set(__self__, "tunnel1_phase2_dh_group_numbers", tunnel1_phase2_dh_group_numbers)
        if tunnel1_phase2_encryption_algorithms is not None:
            pulumi.set(__self__, "tunnel1_phase2_encryption_algorithms", tunnel1_phase2_encryption_algorithms)
        if tunnel1_phase2_integrity_algorithms is not None:
            pulumi.set(__self__, "tunnel1_phase2_integrity_algorithms", tunnel1_phase2_integrity_algorithms)
        if tunnel1_phase2_lifetime_seconds is not None:
            pulumi.set(__self__, "tunnel1_phase2_lifetime_seconds", tunnel1_phase2_lifetime_seconds)
        if tunnel1_preshared_key is not None:
            pulumi.set(__self__, "tunnel1_preshared_key", tunnel1_preshared_key)
        if tunnel1_rekey_fuzz_percentage is not None:
            pulumi.set(__self__, "tunnel1_rekey_fuzz_percentage", tunnel1_rekey_fuzz_percentage)
        if tunnel1_rekey_margin_time_seconds is not None:
            pulumi.set(__self__, "tunnel1_rekey_margin_time_seconds", tunnel1_rekey_margin_time_seconds)
        if tunnel1_replay_window_size is not None:
            pulumi.set(__self__, "tunnel1_replay_window_size", tunnel1_replay_window_size)
        if tunnel1_startup_action is not None:
            pulumi.set(__self__, "tunnel1_startup_action", tunnel1_startup_action)
        if tunnel2_dpd_timeout_action is not None:
            pulumi.set(__self__, "tunnel2_dpd_timeout_action", tunnel2_dpd_timeout_action)
        if tunnel2_dpd_timeout_seconds is not None:
            pulumi.set(__self__, "tunnel2_dpd_timeout_seconds", tunnel2_dpd_timeout_seconds)
        if tunnel2_enable_tunnel_lifecycle_control is not None:
            pulumi.set(__self__, "tunnel2_enable_tunnel_lifecycle_control", tunnel2_enable_tunnel_lifecycle_control)
        if tunnel2_ike_versions is not None:
            pulumi.set(__self__, "tunnel2_ike_versions", tunnel2_ike_versions)
        if tunnel2_inside_cidr is not None:
            pulumi.set(__self__, "tunnel2_inside_cidr", tunnel2_inside_cidr)
        if tunnel2_inside_ipv6_cidr is not None:
            pulumi.set(__self__, "tunnel2_inside_ipv6_cidr", tunnel2_inside_ipv6_cidr)
        if tunnel2_log_options is not None:
            pulumi.set(__self__, "tunnel2_log_options", tunnel2_log_options)
        if tunnel2_phase1_dh_group_numbers is not None:
            pulumi.set(__self__, "tunnel2_phase1_dh_group_numbers", tunnel2_phase1_dh_group_numbers)
        if tunnel2_phase1_encryption_algorithms is not None:
            pulumi.set(__self__, "tunnel2_phase1_encryption_algorithms", tunnel2_phase1_encryption_algorithms)
        if tunnel2_phase1_integrity_algorithms is not None:
            pulumi.set(__self__, "tunnel2_phase1_integrity_algorithms", tunnel2_phase1_integrity_algorithms)
        if tunnel2_phase1_lifetime_seconds is not None:
            pulumi.set(__self__, "tunnel2_phase1_lifetime_seconds", tunnel2_phase1_lifetime_seconds)
        if tunnel2_phase2_dh_group_numbers is not None:
            pulumi.set(__self__, "tunnel2_phase2_dh_group_numbers", tunnel2_phase2_dh_group_numbers)
        if tunnel2_phase2_encryption_algorithms is not None:
            pulumi.set(__self__, "tunnel2_phase2_encryption_algorithms", tunnel2_phase2_encryption_algorithms)
        if tunnel2_phase2_integrity_algorithms is not None:
            pulumi.set(__self__, "tunnel2_phase2_integrity_algorithms", tunnel2_phase2_integrity_algorithms)
        if tunnel2_phase2_lifetime_seconds is not None:
            pulumi.set(__self__, "tunnel2_phase2_lifetime_seconds", tunnel2_phase2_lifetime_seconds)
        if tunnel2_preshared_key is not None:
            pulumi.set(__self__, "tunnel2_preshared_key", tunnel2_preshared_key)
        if tunnel2_rekey_fuzz_percentage is not None:
            pulumi.set(__self__, "tunnel2_rekey_fuzz_percentage", tunnel2_rekey_fuzz_percentage)
        if tunnel2_rekey_margin_time_seconds is not None:
            pulumi.set(__self__, "tunnel2_rekey_margin_time_seconds", tunnel2_rekey_margin_time_seconds)
        if tunnel2_replay_window_size is not None:
            pulumi.set(__self__, "tunnel2_replay_window_size", tunnel2_replay_window_size)
        if tunnel2_startup_action is not None:
            pulumi.set(__self__, "tunnel2_startup_action", tunnel2_startup_action)
        if tunnel_inside_ip_version is not None:
            pulumi.set(__self__, "tunnel_inside_ip_version", tunnel_inside_ip_version)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "customer_gateway_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of VPN connection. The only type AWS supports at this time is "ipsec.1".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="enableAcceleration")
    def enable_acceleration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
        """
        return pulumi.get(self, "enable_acceleration")

    @enable_acceleration.setter
    def enable_acceleration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_acceleration", value)

    @property
    @pulumi.getter(name="localIpv4NetworkCidr")
    def local_ipv4_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
        """
        return pulumi.get(self, "local_ipv4_network_cidr")

    @local_ipv4_network_cidr.setter
    def local_ipv4_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_ipv4_network_cidr", value)

    @property
    @pulumi.getter(name="localIpv6NetworkCidr")
    def local_ipv6_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
        """
        return pulumi.get(self, "local_ipv6_network_cidr")

    @local_ipv6_network_cidr.setter
    def local_ipv6_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_ipv6_network_cidr", value)

    @property
    @pulumi.getter(name="outsideIpAddressType")
    def outside_ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
        """
        return pulumi.get(self, "outside_ip_address_type")

    @outside_ip_address_type.setter
    def outside_ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outside_ip_address_type", value)

    @property
    @pulumi.getter(name="presharedKeyStorage")
    def preshared_key_storage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Storage mode for the pre-shared key (PSK). Valid values are `Standard` (stored in the Site-to-Site VPN service) or `SecretsManager` (stored in AWS Secrets Manager).
        """
        return pulumi.get(self, "preshared_key_storage")

    @preshared_key_storage.setter
    def preshared_key_storage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preshared_key_storage", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="remoteIpv4NetworkCidr")
    def remote_ipv4_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv4 CIDR on the AWS side of the VPN connection.
        """
        return pulumi.get(self, "remote_ipv4_network_cidr")

    @remote_ipv4_network_cidr.setter
    def remote_ipv4_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_ipv4_network_cidr", value)

    @property
    @pulumi.getter(name="remoteIpv6NetworkCidr")
    def remote_ipv6_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv6 CIDR on the AWS side of the VPN connection.
        """
        return pulumi.get(self, "remote_ipv6_network_cidr")

    @remote_ipv6_network_cidr.setter
    def remote_ipv6_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_ipv6_network_cidr", value)

    @property
    @pulumi.getter(name="staticRoutesOnly")
    def static_routes_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don't support BGP.
        """
        return pulumi.get(self, "static_routes_only")

    @static_routes_only.setter
    def static_routes_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "static_routes_only", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the EC2 Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="transportTransitGatewayAttachmentId")
    def transport_transit_gateway_attachment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
        """
        return pulumi.get(self, "transport_transit_gateway_attachment_id")

    @transport_transit_gateway_attachment_id.setter
    def transport_transit_gateway_attachment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transport_transit_gateway_attachment_id", value)

    @property
    @pulumi.getter(name="tunnel1DpdTimeoutAction")
    def tunnel1_dpd_timeout_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        """
        return pulumi.get(self, "tunnel1_dpd_timeout_action")

    @tunnel1_dpd_timeout_action.setter
    def tunnel1_dpd_timeout_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_dpd_timeout_action", value)

    @property
    @pulumi.getter(name="tunnel1DpdTimeoutSeconds")
    def tunnel1_dpd_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
        """
        return pulumi.get(self, "tunnel1_dpd_timeout_seconds")

    @tunnel1_dpd_timeout_seconds.setter
    def tunnel1_dpd_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_dpd_timeout_seconds", value)

    @property
    @pulumi.getter(name="tunnel1EnableTunnelLifecycleControl")
    def tunnel1_enable_tunnel_lifecycle_control(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
        """
        return pulumi.get(self, "tunnel1_enable_tunnel_lifecycle_control")

    @tunnel1_enable_tunnel_lifecycle_control.setter
    def tunnel1_enable_tunnel_lifecycle_control(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tunnel1_enable_tunnel_lifecycle_control", value)

    @property
    @pulumi.getter(name="tunnel1IkeVersions")
    def tunnel1_ike_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
        """
        return pulumi.get(self, "tunnel1_ike_versions")

    @tunnel1_ike_versions.setter
    def tunnel1_ike_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_ike_versions", value)

    @property
    @pulumi.getter(name="tunnel1InsideCidr")
    def tunnel1_inside_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        """
        return pulumi.get(self, "tunnel1_inside_cidr")

    @tunnel1_inside_cidr.setter
    def tunnel1_inside_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_inside_cidr", value)

    @property
    @pulumi.getter(name="tunnel1InsideIpv6Cidr")
    def tunnel1_inside_ipv6_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        """
        return pulumi.get(self, "tunnel1_inside_ipv6_cidr")

    @tunnel1_inside_ipv6_cidr.setter
    def tunnel1_inside_ipv6_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_inside_ipv6_cidr", value)

    @property
    @pulumi.getter(name="tunnel1LogOptions")
    def tunnel1_log_options(self) -> Optional[pulumi.Input['VpnConnectionTunnel1LogOptionsArgs']]:
        """
        Options for logging VPN tunnel activity. See Log Options below for more details.
        """
        return pulumi.get(self, "tunnel1_log_options")

    @tunnel1_log_options.setter
    def tunnel1_log_options(self, value: Optional[pulumi.Input['VpnConnectionTunnel1LogOptionsArgs']]):
        pulumi.set(self, "tunnel1_log_options", value)

    @property
    @pulumi.getter(name="tunnel1Phase1DhGroupNumbers")
    def tunnel1_phase1_dh_group_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel1_phase1_dh_group_numbers")

    @tunnel1_phase1_dh_group_numbers.setter
    def tunnel1_phase1_dh_group_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "tunnel1_phase1_dh_group_numbers", value)

    @property
    @pulumi.getter(name="tunnel1Phase1EncryptionAlgorithms")
    def tunnel1_phase1_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel1_phase1_encryption_algorithms")

    @tunnel1_phase1_encryption_algorithms.setter
    def tunnel1_phase1_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_phase1_encryption_algorithms", value)

    @property
    @pulumi.getter(name="tunnel1Phase1IntegrityAlgorithms")
    def tunnel1_phase1_integrity_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel1_phase1_integrity_algorithms")

    @tunnel1_phase1_integrity_algorithms.setter
    def tunnel1_phase1_integrity_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_phase1_integrity_algorithms", value)

    @property
    @pulumi.getter(name="tunnel1Phase1LifetimeSeconds")
    def tunnel1_phase1_lifetime_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        """
        return pulumi.get(self, "tunnel1_phase1_lifetime_seconds")

    @tunnel1_phase1_lifetime_seconds.setter
    def tunnel1_phase1_lifetime_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_phase1_lifetime_seconds", value)

    @property
    @pulumi.getter(name="tunnel1Phase2DhGroupNumbers")
    def tunnel1_phase2_dh_group_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel1_phase2_dh_group_numbers")

    @tunnel1_phase2_dh_group_numbers.setter
    def tunnel1_phase2_dh_group_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "tunnel1_phase2_dh_group_numbers", value)

    @property
    @pulumi.getter(name="tunnel1Phase2EncryptionAlgorithms")
    def tunnel1_phase2_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel1_phase2_encryption_algorithms")

    @tunnel1_phase2_encryption_algorithms.setter
    def tunnel1_phase2_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_phase2_encryption_algorithms", value)

    @property
    @pulumi.getter(name="tunnel1Phase2IntegrityAlgorithms")
    def tunnel1_phase2_integrity_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel1_phase2_integrity_algorithms")

    @tunnel1_phase2_integrity_algorithms.setter
    def tunnel1_phase2_integrity_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_phase2_integrity_algorithms", value)

    @property
    @pulumi.getter(name="tunnel1Phase2LifetimeSeconds")
    def tunnel1_phase2_lifetime_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        """
        return pulumi.get(self, "tunnel1_phase2_lifetime_seconds")

    @tunnel1_phase2_lifetime_seconds.setter
    def tunnel1_phase2_lifetime_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_phase2_lifetime_seconds", value)

    @property
    @pulumi.getter(name="tunnel1PresharedKey")
    def tunnel1_preshared_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        """
        return pulumi.get(self, "tunnel1_preshared_key")

    @tunnel1_preshared_key.setter
    def tunnel1_preshared_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_preshared_key", value)

    @property
    @pulumi.getter(name="tunnel1RekeyFuzzPercentage")
    def tunnel1_rekey_fuzz_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        """
        return pulumi.get(self, "tunnel1_rekey_fuzz_percentage")

    @tunnel1_rekey_fuzz_percentage.setter
    def tunnel1_rekey_fuzz_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_rekey_fuzz_percentage", value)

    @property
    @pulumi.getter(name="tunnel1RekeyMarginTimeSeconds")
    def tunnel1_rekey_margin_time_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
        """
        return pulumi.get(self, "tunnel1_rekey_margin_time_seconds")

    @tunnel1_rekey_margin_time_seconds.setter
    def tunnel1_rekey_margin_time_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_rekey_margin_time_seconds", value)

    @property
    @pulumi.getter(name="tunnel1ReplayWindowSize")
    def tunnel1_replay_window_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
        """
        return pulumi.get(self, "tunnel1_replay_window_size")

    @tunnel1_replay_window_size.setter
    def tunnel1_replay_window_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_replay_window_size", value)

    @property
    @pulumi.getter(name="tunnel1StartupAction")
    def tunnel1_startup_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        """
        return pulumi.get(self, "tunnel1_startup_action")

    @tunnel1_startup_action.setter
    def tunnel1_startup_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_startup_action", value)

    @property
    @pulumi.getter(name="tunnel2DpdTimeoutAction")
    def tunnel2_dpd_timeout_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        """
        return pulumi.get(self, "tunnel2_dpd_timeout_action")

    @tunnel2_dpd_timeout_action.setter
    def tunnel2_dpd_timeout_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_dpd_timeout_action", value)

    @property
    @pulumi.getter(name="tunnel2DpdTimeoutSeconds")
    def tunnel2_dpd_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
        """
        return pulumi.get(self, "tunnel2_dpd_timeout_seconds")

    @tunnel2_dpd_timeout_seconds.setter
    def tunnel2_dpd_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_dpd_timeout_seconds", value)

    @property
    @pulumi.getter(name="tunnel2EnableTunnelLifecycleControl")
    def tunnel2_enable_tunnel_lifecycle_control(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
        """
        return pulumi.get(self, "tunnel2_enable_tunnel_lifecycle_control")

    @tunnel2_enable_tunnel_lifecycle_control.setter
    def tunnel2_enable_tunnel_lifecycle_control(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tunnel2_enable_tunnel_lifecycle_control", value)

    @property
    @pulumi.getter(name="tunnel2IkeVersions")
    def tunnel2_ike_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
        """
        return pulumi.get(self, "tunnel2_ike_versions")

    @tunnel2_ike_versions.setter
    def tunnel2_ike_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_ike_versions", value)

    @property
    @pulumi.getter(name="tunnel2InsideCidr")
    def tunnel2_inside_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        """
        return pulumi.get(self, "tunnel2_inside_cidr")

    @tunnel2_inside_cidr.setter
    def tunnel2_inside_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_inside_cidr", value)

    @property
    @pulumi.getter(name="tunnel2InsideIpv6Cidr")
    def tunnel2_inside_ipv6_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        """
        return pulumi.get(self, "tunnel2_inside_ipv6_cidr")

    @tunnel2_inside_ipv6_cidr.setter
    def tunnel2_inside_ipv6_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_inside_ipv6_cidr", value)

    @property
    @pulumi.getter(name="tunnel2LogOptions")
    def tunnel2_log_options(self) -> Optional[pulumi.Input['VpnConnectionTunnel2LogOptionsArgs']]:
        """
        Options for logging VPN tunnel activity. See Log Options below for more details.
        """
        return pulumi.get(self, "tunnel2_log_options")

    @tunnel2_log_options.setter
    def tunnel2_log_options(self, value: Optional[pulumi.Input['VpnConnectionTunnel2LogOptionsArgs']]):
        pulumi.set(self, "tunnel2_log_options", value)

    @property
    @pulumi.getter(name="tunnel2Phase1DhGroupNumbers")
    def tunnel2_phase1_dh_group_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel2_phase1_dh_group_numbers")

    @tunnel2_phase1_dh_group_numbers.setter
    def tunnel2_phase1_dh_group_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "tunnel2_phase1_dh_group_numbers", value)

    @property
    @pulumi.getter(name="tunnel2Phase1EncryptionAlgorithms")
    def tunnel2_phase1_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel2_phase1_encryption_algorithms")

    @tunnel2_phase1_encryption_algorithms.setter
    def tunnel2_phase1_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_phase1_encryption_algorithms", value)

    @property
    @pulumi.getter(name="tunnel2Phase1IntegrityAlgorithms")
    def tunnel2_phase1_integrity_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel2_phase1_integrity_algorithms")

    @tunnel2_phase1_integrity_algorithms.setter
    def tunnel2_phase1_integrity_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_phase1_integrity_algorithms", value)

    @property
    @pulumi.getter(name="tunnel2Phase1LifetimeSeconds")
    def tunnel2_phase1_lifetime_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        """
        return pulumi.get(self, "tunnel2_phase1_lifetime_seconds")

    @tunnel2_phase1_lifetime_seconds.setter
    def tunnel2_phase1_lifetime_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_phase1_lifetime_seconds", value)

    @property
    @pulumi.getter(name="tunnel2Phase2DhGroupNumbers")
    def tunnel2_phase2_dh_group_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel2_phase2_dh_group_numbers")

    @tunnel2_phase2_dh_group_numbers.setter
    def tunnel2_phase2_dh_group_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "tunnel2_phase2_dh_group_numbers", value)

    @property
    @pulumi.getter(name="tunnel2Phase2EncryptionAlgorithms")
    def tunnel2_phase2_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel2_phase2_encryption_algorithms")

    @tunnel2_phase2_encryption_algorithms.setter
    def tunnel2_phase2_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_phase2_encryption_algorithms", value)

    @property
    @pulumi.getter(name="tunnel2Phase2IntegrityAlgorithms")
    def tunnel2_phase2_integrity_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel2_phase2_integrity_algorithms")

    @tunnel2_phase2_integrity_algorithms.setter
    def tunnel2_phase2_integrity_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_phase2_integrity_algorithms", value)

    @property
    @pulumi.getter(name="tunnel2Phase2LifetimeSeconds")
    def tunnel2_phase2_lifetime_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        """
        return pulumi.get(self, "tunnel2_phase2_lifetime_seconds")

    @tunnel2_phase2_lifetime_seconds.setter
    def tunnel2_phase2_lifetime_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_phase2_lifetime_seconds", value)

    @property
    @pulumi.getter(name="tunnel2PresharedKey")
    def tunnel2_preshared_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        """
        return pulumi.get(self, "tunnel2_preshared_key")

    @tunnel2_preshared_key.setter
    def tunnel2_preshared_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_preshared_key", value)

    @property
    @pulumi.getter(name="tunnel2RekeyFuzzPercentage")
    def tunnel2_rekey_fuzz_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        """
        return pulumi.get(self, "tunnel2_rekey_fuzz_percentage")

    @tunnel2_rekey_fuzz_percentage.setter
    def tunnel2_rekey_fuzz_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_rekey_fuzz_percentage", value)

    @property
    @pulumi.getter(name="tunnel2RekeyMarginTimeSeconds")
    def tunnel2_rekey_margin_time_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
        """
        return pulumi.get(self, "tunnel2_rekey_margin_time_seconds")

    @tunnel2_rekey_margin_time_seconds.setter
    def tunnel2_rekey_margin_time_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_rekey_margin_time_seconds", value)

    @property
    @pulumi.getter(name="tunnel2ReplayWindowSize")
    def tunnel2_replay_window_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
        """
        return pulumi.get(self, "tunnel2_replay_window_size")

    @tunnel2_replay_window_size.setter
    def tunnel2_replay_window_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_replay_window_size", value)

    @property
    @pulumi.getter(name="tunnel2StartupAction")
    def tunnel2_startup_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        """
        return pulumi.get(self, "tunnel2_startup_action")

    @tunnel2_startup_action.setter
    def tunnel2_startup_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_startup_action", value)

    @property
    @pulumi.getter(name="tunnelInsideIpVersion")
    def tunnel_inside_ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
        """
        return pulumi.get(self, "tunnel_inside_ip_version")

    @tunnel_inside_ip_version.setter
    def tunnel_inside_ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_inside_ip_version", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Virtual Private Gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpn_gateway_id", value)


@pulumi.input_type
class _VpnConnectionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_attachment_arn: Optional[pulumi.Input[builtins.str]] = None,
                 customer_gateway_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 customer_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_acceleration: Optional[pulumi.Input[builtins.bool]] = None,
                 local_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 local_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 outside_ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 preshared_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 preshared_key_storage: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 remote_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 remote_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionRouteArgs']]]] = None,
                 static_routes_only: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 transport_transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_bgp_asn: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_bgp_holdtime: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_cgw_inside_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel1_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_log_options: Optional[pulumi.Input['VpnConnectionTunnel1LogOptionsArgs']] = None,
                 tunnel1_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel1_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel1_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_startup_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_vgw_inside_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_bgp_asn: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_bgp_holdtime: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_cgw_inside_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel2_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_log_options: Optional[pulumi.Input['VpnConnectionTunnel2LogOptionsArgs']] = None,
                 tunnel2_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel2_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel2_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_startup_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_vgw_inside_address: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_inside_ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vgw_telemetries: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionVgwTelemetryArgs']]]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpnConnection resources.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the VPN Connection.
        :param pulumi.Input[builtins.str] core_network_arn: The ARN of the core network.
        :param pulumi.Input[builtins.str] core_network_attachment_arn: The ARN of the core network attachment.
        :param pulumi.Input[builtins.str] customer_gateway_configuration: The configuration information for the VPN connection's customer gateway (in the native XML format).
        :param pulumi.Input[builtins.str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[builtins.bool] enable_acceleration: Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] local_ipv4_network_cidr: The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
        :param pulumi.Input[builtins.str] local_ipv6_network_cidr: The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
        :param pulumi.Input[builtins.str] outside_ip_address_type: Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
        :param pulumi.Input[builtins.str] preshared_key_arn: ARN of the Secrets Manager secret storing the pre-shared key(s) for the VPN connection. Note that even if it returns a valid Secrets Manager ARN, the pre-shared key(s) will not be stored in Secrets Manager unless the `preshared_key_storage` argument is set to `SecretsManager`.
        :param pulumi.Input[builtins.str] preshared_key_storage: Storage mode for the pre-shared key (PSK). Valid values are `Standard` (stored in the Site-to-Site VPN service) or `SecretsManager` (stored in AWS Secrets Manager).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] remote_ipv4_network_cidr: The IPv4 CIDR on the AWS side of the VPN connection.
        :param pulumi.Input[builtins.str] remote_ipv6_network_cidr: The IPv6 CIDR on the AWS side of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input['VpnConnectionRouteArgs']]] routes: The static routes associated with the VPN connection. Detailed below.
        :param pulumi.Input[builtins.bool] static_routes_only: Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don't support BGP.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
        :param pulumi.Input[builtins.str] transit_gateway_id: The ID of the EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] transport_transit_gateway_attachment_id: . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
        :param pulumi.Input[builtins.str] tunnel1_address: The public IP address of the first VPN tunnel.
        :param pulumi.Input[builtins.str] tunnel1_bgp_asn: The bgp asn number of the first VPN tunnel.
        :param pulumi.Input[builtins.int] tunnel1_bgp_holdtime: The bgp holdtime of the first VPN tunnel.
        :param pulumi.Input[builtins.str] tunnel1_cgw_inside_address: The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
        :param pulumi.Input[builtins.str] tunnel1_dpd_timeout_action: The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        :param pulumi.Input[builtins.int] tunnel1_dpd_timeout_seconds: The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
        :param pulumi.Input[builtins.bool] tunnel1_enable_tunnel_lifecycle_control: Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_ike_versions: The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
        :param pulumi.Input[builtins.str] tunnel1_inside_cidr: The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        :param pulumi.Input[builtins.str] tunnel1_inside_ipv6_cidr: The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        :param pulumi.Input['VpnConnectionTunnel1LogOptionsArgs'] tunnel1_log_options: Options for logging VPN tunnel activity. See Log Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel1_phase1_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase1_encryption_algorithms: List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase1_integrity_algorithms: One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel1_phase1_lifetime_seconds: The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel1_phase2_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase2_encryption_algorithms: List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase2_integrity_algorithms: List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel1_phase2_lifetime_seconds: The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        :param pulumi.Input[builtins.str] tunnel1_preshared_key: The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        :param pulumi.Input[builtins.int] tunnel1_rekey_fuzz_percentage: The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        :param pulumi.Input[builtins.int] tunnel1_rekey_margin_time_seconds: The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
        :param pulumi.Input[builtins.int] tunnel1_replay_window_size: The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
        :param pulumi.Input[builtins.str] tunnel1_startup_action: The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        :param pulumi.Input[builtins.str] tunnel1_vgw_inside_address: The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
        :param pulumi.Input[builtins.str] tunnel2_address: The public IP address of the second VPN tunnel.
        :param pulumi.Input[builtins.str] tunnel2_bgp_asn: The bgp asn number of the second VPN tunnel.
        :param pulumi.Input[builtins.int] tunnel2_bgp_holdtime: The bgp holdtime of the second VPN tunnel.
        :param pulumi.Input[builtins.str] tunnel2_cgw_inside_address: The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
        :param pulumi.Input[builtins.str] tunnel2_dpd_timeout_action: The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        :param pulumi.Input[builtins.int] tunnel2_dpd_timeout_seconds: The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
        :param pulumi.Input[builtins.bool] tunnel2_enable_tunnel_lifecycle_control: Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_ike_versions: The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
        :param pulumi.Input[builtins.str] tunnel2_inside_cidr: The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        :param pulumi.Input[builtins.str] tunnel2_inside_ipv6_cidr: The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        :param pulumi.Input['VpnConnectionTunnel2LogOptionsArgs'] tunnel2_log_options: Options for logging VPN tunnel activity. See Log Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel2_phase1_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase1_encryption_algorithms: List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase1_integrity_algorithms: One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel2_phase1_lifetime_seconds: The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel2_phase2_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase2_encryption_algorithms: List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase2_integrity_algorithms: List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel2_phase2_lifetime_seconds: The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        :param pulumi.Input[builtins.str] tunnel2_preshared_key: The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        :param pulumi.Input[builtins.int] tunnel2_rekey_fuzz_percentage: The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        :param pulumi.Input[builtins.int] tunnel2_rekey_margin_time_seconds: The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
        :param pulumi.Input[builtins.int] tunnel2_replay_window_size: The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
        :param pulumi.Input[builtins.str] tunnel2_startup_action: The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        :param pulumi.Input[builtins.str] tunnel2_vgw_inside_address: The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
        :param pulumi.Input[builtins.str] tunnel_inside_ip_version: Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] type: The type of VPN connection. The only type AWS supports at this time is "ipsec.1".
        :param pulumi.Input[Sequence[pulumi.Input['VpnConnectionVgwTelemetryArgs']]] vgw_telemetries: Telemetry for the VPN tunnels. Detailed below.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the Virtual Private Gateway.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if core_network_arn is not None:
            pulumi.set(__self__, "core_network_arn", core_network_arn)
        if core_network_attachment_arn is not None:
            pulumi.set(__self__, "core_network_attachment_arn", core_network_attachment_arn)
        if customer_gateway_configuration is not None:
            pulumi.set(__self__, "customer_gateway_configuration", customer_gateway_configuration)
        if customer_gateway_id is not None:
            pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        if enable_acceleration is not None:
            pulumi.set(__self__, "enable_acceleration", enable_acceleration)
        if local_ipv4_network_cidr is not None:
            pulumi.set(__self__, "local_ipv4_network_cidr", local_ipv4_network_cidr)
        if local_ipv6_network_cidr is not None:
            pulumi.set(__self__, "local_ipv6_network_cidr", local_ipv6_network_cidr)
        if outside_ip_address_type is not None:
            pulumi.set(__self__, "outside_ip_address_type", outside_ip_address_type)
        if preshared_key_arn is not None:
            pulumi.set(__self__, "preshared_key_arn", preshared_key_arn)
        if preshared_key_storage is not None:
            pulumi.set(__self__, "preshared_key_storage", preshared_key_storage)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_ipv4_network_cidr is not None:
            pulumi.set(__self__, "remote_ipv4_network_cidr", remote_ipv4_network_cidr)
        if remote_ipv6_network_cidr is not None:
            pulumi.set(__self__, "remote_ipv6_network_cidr", remote_ipv6_network_cidr)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if static_routes_only is not None:
            pulumi.set(__self__, "static_routes_only", static_routes_only)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transit_gateway_attachment_id", transit_gateway_attachment_id)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if transport_transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transport_transit_gateway_attachment_id", transport_transit_gateway_attachment_id)
        if tunnel1_address is not None:
            pulumi.set(__self__, "tunnel1_address", tunnel1_address)
        if tunnel1_bgp_asn is not None:
            pulumi.set(__self__, "tunnel1_bgp_asn", tunnel1_bgp_asn)
        if tunnel1_bgp_holdtime is not None:
            pulumi.set(__self__, "tunnel1_bgp_holdtime", tunnel1_bgp_holdtime)
        if tunnel1_cgw_inside_address is not None:
            pulumi.set(__self__, "tunnel1_cgw_inside_address", tunnel1_cgw_inside_address)
        if tunnel1_dpd_timeout_action is not None:
            pulumi.set(__self__, "tunnel1_dpd_timeout_action", tunnel1_dpd_timeout_action)
        if tunnel1_dpd_timeout_seconds is not None:
            pulumi.set(__self__, "tunnel1_dpd_timeout_seconds", tunnel1_dpd_timeout_seconds)
        if tunnel1_enable_tunnel_lifecycle_control is not None:
            pulumi.set(__self__, "tunnel1_enable_tunnel_lifecycle_control", tunnel1_enable_tunnel_lifecycle_control)
        if tunnel1_ike_versions is not None:
            pulumi.set(__self__, "tunnel1_ike_versions", tunnel1_ike_versions)
        if tunnel1_inside_cidr is not None:
            pulumi.set(__self__, "tunnel1_inside_cidr", tunnel1_inside_cidr)
        if tunnel1_inside_ipv6_cidr is not None:
            pulumi.set(__self__, "tunnel1_inside_ipv6_cidr", tunnel1_inside_ipv6_cidr)
        if tunnel1_log_options is not None:
            pulumi.set(__self__, "tunnel1_log_options", tunnel1_log_options)
        if tunnel1_phase1_dh_group_numbers is not None:
            pulumi.set(__self__, "tunnel1_phase1_dh_group_numbers", tunnel1_phase1_dh_group_numbers)
        if tunnel1_phase1_encryption_algorithms is not None:
            pulumi.set(__self__, "tunnel1_phase1_encryption_algorithms", tunnel1_phase1_encryption_algorithms)
        if tunnel1_phase1_integrity_algorithms is not None:
            pulumi.set(__self__, "tunnel1_phase1_integrity_algorithms", tunnel1_phase1_integrity_algorithms)
        if tunnel1_phase1_lifetime_seconds is not None:
            pulumi.set(__self__, "tunnel1_phase1_lifetime_seconds", tunnel1_phase1_lifetime_seconds)
        if tunnel1_phase2_dh_group_numbers is not None:
            pulumi.set(__self__, "tunnel1_phase2_dh_group_numbers", tunnel1_phase2_dh_group_numbers)
        if tunnel1_phase2_encryption_algorithms is not None:
            pulumi.set(__self__, "tunnel1_phase2_encryption_algorithms", tunnel1_phase2_encryption_algorithms)
        if tunnel1_phase2_integrity_algorithms is not None:
            pulumi.set(__self__, "tunnel1_phase2_integrity_algorithms", tunnel1_phase2_integrity_algorithms)
        if tunnel1_phase2_lifetime_seconds is not None:
            pulumi.set(__self__, "tunnel1_phase2_lifetime_seconds", tunnel1_phase2_lifetime_seconds)
        if tunnel1_preshared_key is not None:
            pulumi.set(__self__, "tunnel1_preshared_key", tunnel1_preshared_key)
        if tunnel1_rekey_fuzz_percentage is not None:
            pulumi.set(__self__, "tunnel1_rekey_fuzz_percentage", tunnel1_rekey_fuzz_percentage)
        if tunnel1_rekey_margin_time_seconds is not None:
            pulumi.set(__self__, "tunnel1_rekey_margin_time_seconds", tunnel1_rekey_margin_time_seconds)
        if tunnel1_replay_window_size is not None:
            pulumi.set(__self__, "tunnel1_replay_window_size", tunnel1_replay_window_size)
        if tunnel1_startup_action is not None:
            pulumi.set(__self__, "tunnel1_startup_action", tunnel1_startup_action)
        if tunnel1_vgw_inside_address is not None:
            pulumi.set(__self__, "tunnel1_vgw_inside_address", tunnel1_vgw_inside_address)
        if tunnel2_address is not None:
            pulumi.set(__self__, "tunnel2_address", tunnel2_address)
        if tunnel2_bgp_asn is not None:
            pulumi.set(__self__, "tunnel2_bgp_asn", tunnel2_bgp_asn)
        if tunnel2_bgp_holdtime is not None:
            pulumi.set(__self__, "tunnel2_bgp_holdtime", tunnel2_bgp_holdtime)
        if tunnel2_cgw_inside_address is not None:
            pulumi.set(__self__, "tunnel2_cgw_inside_address", tunnel2_cgw_inside_address)
        if tunnel2_dpd_timeout_action is not None:
            pulumi.set(__self__, "tunnel2_dpd_timeout_action", tunnel2_dpd_timeout_action)
        if tunnel2_dpd_timeout_seconds is not None:
            pulumi.set(__self__, "tunnel2_dpd_timeout_seconds", tunnel2_dpd_timeout_seconds)
        if tunnel2_enable_tunnel_lifecycle_control is not None:
            pulumi.set(__self__, "tunnel2_enable_tunnel_lifecycle_control", tunnel2_enable_tunnel_lifecycle_control)
        if tunnel2_ike_versions is not None:
            pulumi.set(__self__, "tunnel2_ike_versions", tunnel2_ike_versions)
        if tunnel2_inside_cidr is not None:
            pulumi.set(__self__, "tunnel2_inside_cidr", tunnel2_inside_cidr)
        if tunnel2_inside_ipv6_cidr is not None:
            pulumi.set(__self__, "tunnel2_inside_ipv6_cidr", tunnel2_inside_ipv6_cidr)
        if tunnel2_log_options is not None:
            pulumi.set(__self__, "tunnel2_log_options", tunnel2_log_options)
        if tunnel2_phase1_dh_group_numbers is not None:
            pulumi.set(__self__, "tunnel2_phase1_dh_group_numbers", tunnel2_phase1_dh_group_numbers)
        if tunnel2_phase1_encryption_algorithms is not None:
            pulumi.set(__self__, "tunnel2_phase1_encryption_algorithms", tunnel2_phase1_encryption_algorithms)
        if tunnel2_phase1_integrity_algorithms is not None:
            pulumi.set(__self__, "tunnel2_phase1_integrity_algorithms", tunnel2_phase1_integrity_algorithms)
        if tunnel2_phase1_lifetime_seconds is not None:
            pulumi.set(__self__, "tunnel2_phase1_lifetime_seconds", tunnel2_phase1_lifetime_seconds)
        if tunnel2_phase2_dh_group_numbers is not None:
            pulumi.set(__self__, "tunnel2_phase2_dh_group_numbers", tunnel2_phase2_dh_group_numbers)
        if tunnel2_phase2_encryption_algorithms is not None:
            pulumi.set(__self__, "tunnel2_phase2_encryption_algorithms", tunnel2_phase2_encryption_algorithms)
        if tunnel2_phase2_integrity_algorithms is not None:
            pulumi.set(__self__, "tunnel2_phase2_integrity_algorithms", tunnel2_phase2_integrity_algorithms)
        if tunnel2_phase2_lifetime_seconds is not None:
            pulumi.set(__self__, "tunnel2_phase2_lifetime_seconds", tunnel2_phase2_lifetime_seconds)
        if tunnel2_preshared_key is not None:
            pulumi.set(__self__, "tunnel2_preshared_key", tunnel2_preshared_key)
        if tunnel2_rekey_fuzz_percentage is not None:
            pulumi.set(__self__, "tunnel2_rekey_fuzz_percentage", tunnel2_rekey_fuzz_percentage)
        if tunnel2_rekey_margin_time_seconds is not None:
            pulumi.set(__self__, "tunnel2_rekey_margin_time_seconds", tunnel2_rekey_margin_time_seconds)
        if tunnel2_replay_window_size is not None:
            pulumi.set(__self__, "tunnel2_replay_window_size", tunnel2_replay_window_size)
        if tunnel2_startup_action is not None:
            pulumi.set(__self__, "tunnel2_startup_action", tunnel2_startup_action)
        if tunnel2_vgw_inside_address is not None:
            pulumi.set(__self__, "tunnel2_vgw_inside_address", tunnel2_vgw_inside_address)
        if tunnel_inside_ip_version is not None:
            pulumi.set(__self__, "tunnel_inside_ip_version", tunnel_inside_ip_version)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vgw_telemetries is not None:
            pulumi.set(__self__, "vgw_telemetries", vgw_telemetries)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the VPN Connection.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the core network.
        """
        return pulumi.get(self, "core_network_arn")

    @core_network_arn.setter
    def core_network_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_arn", value)

    @property
    @pulumi.getter(name="coreNetworkAttachmentArn")
    def core_network_attachment_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the core network attachment.
        """
        return pulumi.get(self, "core_network_attachment_arn")

    @core_network_attachment_arn.setter
    def core_network_attachment_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_attachment_arn", value)

    @property
    @pulumi.getter(name="customerGatewayConfiguration")
    def customer_gateway_configuration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The configuration information for the VPN connection's customer gateway (in the native XML format).
        """
        return pulumi.get(self, "customer_gateway_configuration")

    @customer_gateway_configuration.setter
    def customer_gateway_configuration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_gateway_configuration", value)

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_gateway_id", value)

    @property
    @pulumi.getter(name="enableAcceleration")
    def enable_acceleration(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
        """
        return pulumi.get(self, "enable_acceleration")

    @enable_acceleration.setter
    def enable_acceleration(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_acceleration", value)

    @property
    @pulumi.getter(name="localIpv4NetworkCidr")
    def local_ipv4_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
        """
        return pulumi.get(self, "local_ipv4_network_cidr")

    @local_ipv4_network_cidr.setter
    def local_ipv4_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_ipv4_network_cidr", value)

    @property
    @pulumi.getter(name="localIpv6NetworkCidr")
    def local_ipv6_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
        """
        return pulumi.get(self, "local_ipv6_network_cidr")

    @local_ipv6_network_cidr.setter
    def local_ipv6_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_ipv6_network_cidr", value)

    @property
    @pulumi.getter(name="outsideIpAddressType")
    def outside_ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
        """
        return pulumi.get(self, "outside_ip_address_type")

    @outside_ip_address_type.setter
    def outside_ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outside_ip_address_type", value)

    @property
    @pulumi.getter(name="presharedKeyArn")
    def preshared_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Secrets Manager secret storing the pre-shared key(s) for the VPN connection. Note that even if it returns a valid Secrets Manager ARN, the pre-shared key(s) will not be stored in Secrets Manager unless the `preshared_key_storage` argument is set to `SecretsManager`.
        """
        return pulumi.get(self, "preshared_key_arn")

    @preshared_key_arn.setter
    def preshared_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preshared_key_arn", value)

    @property
    @pulumi.getter(name="presharedKeyStorage")
    def preshared_key_storage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Storage mode for the pre-shared key (PSK). Valid values are `Standard` (stored in the Site-to-Site VPN service) or `SecretsManager` (stored in AWS Secrets Manager).
        """
        return pulumi.get(self, "preshared_key_storage")

    @preshared_key_storage.setter
    def preshared_key_storage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preshared_key_storage", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="remoteIpv4NetworkCidr")
    def remote_ipv4_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv4 CIDR on the AWS side of the VPN connection.
        """
        return pulumi.get(self, "remote_ipv4_network_cidr")

    @remote_ipv4_network_cidr.setter
    def remote_ipv4_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_ipv4_network_cidr", value)

    @property
    @pulumi.getter(name="remoteIpv6NetworkCidr")
    def remote_ipv6_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv6 CIDR on the AWS side of the VPN connection.
        """
        return pulumi.get(self, "remote_ipv6_network_cidr")

    @remote_ipv6_network_cidr.setter
    def remote_ipv6_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_ipv6_network_cidr", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionRouteArgs']]]]:
        """
        The static routes associated with the VPN connection. Detailed below.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter(name="staticRoutesOnly")
    def static_routes_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don't support BGP.
        """
        return pulumi.get(self, "static_routes_only")

    @static_routes_only.setter
    def static_routes_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "static_routes_only", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @transit_gateway_attachment_id.setter
    def transit_gateway_attachment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_attachment_id", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the EC2 Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="transportTransitGatewayAttachmentId")
    def transport_transit_gateway_attachment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
        """
        return pulumi.get(self, "transport_transit_gateway_attachment_id")

    @transport_transit_gateway_attachment_id.setter
    def transport_transit_gateway_attachment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transport_transit_gateway_attachment_id", value)

    @property
    @pulumi.getter(name="tunnel1Address")
    def tunnel1_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The public IP address of the first VPN tunnel.
        """
        return pulumi.get(self, "tunnel1_address")

    @tunnel1_address.setter
    def tunnel1_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_address", value)

    @property
    @pulumi.getter(name="tunnel1BgpAsn")
    def tunnel1_bgp_asn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bgp asn number of the first VPN tunnel.
        """
        return pulumi.get(self, "tunnel1_bgp_asn")

    @tunnel1_bgp_asn.setter
    def tunnel1_bgp_asn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_bgp_asn", value)

    @property
    @pulumi.getter(name="tunnel1BgpHoldtime")
    def tunnel1_bgp_holdtime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The bgp holdtime of the first VPN tunnel.
        """
        return pulumi.get(self, "tunnel1_bgp_holdtime")

    @tunnel1_bgp_holdtime.setter
    def tunnel1_bgp_holdtime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_bgp_holdtime", value)

    @property
    @pulumi.getter(name="tunnel1CgwInsideAddress")
    def tunnel1_cgw_inside_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
        """
        return pulumi.get(self, "tunnel1_cgw_inside_address")

    @tunnel1_cgw_inside_address.setter
    def tunnel1_cgw_inside_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_cgw_inside_address", value)

    @property
    @pulumi.getter(name="tunnel1DpdTimeoutAction")
    def tunnel1_dpd_timeout_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        """
        return pulumi.get(self, "tunnel1_dpd_timeout_action")

    @tunnel1_dpd_timeout_action.setter
    def tunnel1_dpd_timeout_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_dpd_timeout_action", value)

    @property
    @pulumi.getter(name="tunnel1DpdTimeoutSeconds")
    def tunnel1_dpd_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
        """
        return pulumi.get(self, "tunnel1_dpd_timeout_seconds")

    @tunnel1_dpd_timeout_seconds.setter
    def tunnel1_dpd_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_dpd_timeout_seconds", value)

    @property
    @pulumi.getter(name="tunnel1EnableTunnelLifecycleControl")
    def tunnel1_enable_tunnel_lifecycle_control(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
        """
        return pulumi.get(self, "tunnel1_enable_tunnel_lifecycle_control")

    @tunnel1_enable_tunnel_lifecycle_control.setter
    def tunnel1_enable_tunnel_lifecycle_control(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tunnel1_enable_tunnel_lifecycle_control", value)

    @property
    @pulumi.getter(name="tunnel1IkeVersions")
    def tunnel1_ike_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
        """
        return pulumi.get(self, "tunnel1_ike_versions")

    @tunnel1_ike_versions.setter
    def tunnel1_ike_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_ike_versions", value)

    @property
    @pulumi.getter(name="tunnel1InsideCidr")
    def tunnel1_inside_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        """
        return pulumi.get(self, "tunnel1_inside_cidr")

    @tunnel1_inside_cidr.setter
    def tunnel1_inside_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_inside_cidr", value)

    @property
    @pulumi.getter(name="tunnel1InsideIpv6Cidr")
    def tunnel1_inside_ipv6_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        """
        return pulumi.get(self, "tunnel1_inside_ipv6_cidr")

    @tunnel1_inside_ipv6_cidr.setter
    def tunnel1_inside_ipv6_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_inside_ipv6_cidr", value)

    @property
    @pulumi.getter(name="tunnel1LogOptions")
    def tunnel1_log_options(self) -> Optional[pulumi.Input['VpnConnectionTunnel1LogOptionsArgs']]:
        """
        Options for logging VPN tunnel activity. See Log Options below for more details.
        """
        return pulumi.get(self, "tunnel1_log_options")

    @tunnel1_log_options.setter
    def tunnel1_log_options(self, value: Optional[pulumi.Input['VpnConnectionTunnel1LogOptionsArgs']]):
        pulumi.set(self, "tunnel1_log_options", value)

    @property
    @pulumi.getter(name="tunnel1Phase1DhGroupNumbers")
    def tunnel1_phase1_dh_group_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel1_phase1_dh_group_numbers")

    @tunnel1_phase1_dh_group_numbers.setter
    def tunnel1_phase1_dh_group_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "tunnel1_phase1_dh_group_numbers", value)

    @property
    @pulumi.getter(name="tunnel1Phase1EncryptionAlgorithms")
    def tunnel1_phase1_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel1_phase1_encryption_algorithms")

    @tunnel1_phase1_encryption_algorithms.setter
    def tunnel1_phase1_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_phase1_encryption_algorithms", value)

    @property
    @pulumi.getter(name="tunnel1Phase1IntegrityAlgorithms")
    def tunnel1_phase1_integrity_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel1_phase1_integrity_algorithms")

    @tunnel1_phase1_integrity_algorithms.setter
    def tunnel1_phase1_integrity_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_phase1_integrity_algorithms", value)

    @property
    @pulumi.getter(name="tunnel1Phase1LifetimeSeconds")
    def tunnel1_phase1_lifetime_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        """
        return pulumi.get(self, "tunnel1_phase1_lifetime_seconds")

    @tunnel1_phase1_lifetime_seconds.setter
    def tunnel1_phase1_lifetime_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_phase1_lifetime_seconds", value)

    @property
    @pulumi.getter(name="tunnel1Phase2DhGroupNumbers")
    def tunnel1_phase2_dh_group_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel1_phase2_dh_group_numbers")

    @tunnel1_phase2_dh_group_numbers.setter
    def tunnel1_phase2_dh_group_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "tunnel1_phase2_dh_group_numbers", value)

    @property
    @pulumi.getter(name="tunnel1Phase2EncryptionAlgorithms")
    def tunnel1_phase2_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel1_phase2_encryption_algorithms")

    @tunnel1_phase2_encryption_algorithms.setter
    def tunnel1_phase2_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_phase2_encryption_algorithms", value)

    @property
    @pulumi.getter(name="tunnel1Phase2IntegrityAlgorithms")
    def tunnel1_phase2_integrity_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel1_phase2_integrity_algorithms")

    @tunnel1_phase2_integrity_algorithms.setter
    def tunnel1_phase2_integrity_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel1_phase2_integrity_algorithms", value)

    @property
    @pulumi.getter(name="tunnel1Phase2LifetimeSeconds")
    def tunnel1_phase2_lifetime_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        """
        return pulumi.get(self, "tunnel1_phase2_lifetime_seconds")

    @tunnel1_phase2_lifetime_seconds.setter
    def tunnel1_phase2_lifetime_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_phase2_lifetime_seconds", value)

    @property
    @pulumi.getter(name="tunnel1PresharedKey")
    def tunnel1_preshared_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        """
        return pulumi.get(self, "tunnel1_preshared_key")

    @tunnel1_preshared_key.setter
    def tunnel1_preshared_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_preshared_key", value)

    @property
    @pulumi.getter(name="tunnel1RekeyFuzzPercentage")
    def tunnel1_rekey_fuzz_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        """
        return pulumi.get(self, "tunnel1_rekey_fuzz_percentage")

    @tunnel1_rekey_fuzz_percentage.setter
    def tunnel1_rekey_fuzz_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_rekey_fuzz_percentage", value)

    @property
    @pulumi.getter(name="tunnel1RekeyMarginTimeSeconds")
    def tunnel1_rekey_margin_time_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
        """
        return pulumi.get(self, "tunnel1_rekey_margin_time_seconds")

    @tunnel1_rekey_margin_time_seconds.setter
    def tunnel1_rekey_margin_time_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_rekey_margin_time_seconds", value)

    @property
    @pulumi.getter(name="tunnel1ReplayWindowSize")
    def tunnel1_replay_window_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
        """
        return pulumi.get(self, "tunnel1_replay_window_size")

    @tunnel1_replay_window_size.setter
    def tunnel1_replay_window_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel1_replay_window_size", value)

    @property
    @pulumi.getter(name="tunnel1StartupAction")
    def tunnel1_startup_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        """
        return pulumi.get(self, "tunnel1_startup_action")

    @tunnel1_startup_action.setter
    def tunnel1_startup_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_startup_action", value)

    @property
    @pulumi.getter(name="tunnel1VgwInsideAddress")
    def tunnel1_vgw_inside_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
        """
        return pulumi.get(self, "tunnel1_vgw_inside_address")

    @tunnel1_vgw_inside_address.setter
    def tunnel1_vgw_inside_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel1_vgw_inside_address", value)

    @property
    @pulumi.getter(name="tunnel2Address")
    def tunnel2_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The public IP address of the second VPN tunnel.
        """
        return pulumi.get(self, "tunnel2_address")

    @tunnel2_address.setter
    def tunnel2_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_address", value)

    @property
    @pulumi.getter(name="tunnel2BgpAsn")
    def tunnel2_bgp_asn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bgp asn number of the second VPN tunnel.
        """
        return pulumi.get(self, "tunnel2_bgp_asn")

    @tunnel2_bgp_asn.setter
    def tunnel2_bgp_asn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_bgp_asn", value)

    @property
    @pulumi.getter(name="tunnel2BgpHoldtime")
    def tunnel2_bgp_holdtime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The bgp holdtime of the second VPN tunnel.
        """
        return pulumi.get(self, "tunnel2_bgp_holdtime")

    @tunnel2_bgp_holdtime.setter
    def tunnel2_bgp_holdtime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_bgp_holdtime", value)

    @property
    @pulumi.getter(name="tunnel2CgwInsideAddress")
    def tunnel2_cgw_inside_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
        """
        return pulumi.get(self, "tunnel2_cgw_inside_address")

    @tunnel2_cgw_inside_address.setter
    def tunnel2_cgw_inside_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_cgw_inside_address", value)

    @property
    @pulumi.getter(name="tunnel2DpdTimeoutAction")
    def tunnel2_dpd_timeout_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        """
        return pulumi.get(self, "tunnel2_dpd_timeout_action")

    @tunnel2_dpd_timeout_action.setter
    def tunnel2_dpd_timeout_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_dpd_timeout_action", value)

    @property
    @pulumi.getter(name="tunnel2DpdTimeoutSeconds")
    def tunnel2_dpd_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
        """
        return pulumi.get(self, "tunnel2_dpd_timeout_seconds")

    @tunnel2_dpd_timeout_seconds.setter
    def tunnel2_dpd_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_dpd_timeout_seconds", value)

    @property
    @pulumi.getter(name="tunnel2EnableTunnelLifecycleControl")
    def tunnel2_enable_tunnel_lifecycle_control(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
        """
        return pulumi.get(self, "tunnel2_enable_tunnel_lifecycle_control")

    @tunnel2_enable_tunnel_lifecycle_control.setter
    def tunnel2_enable_tunnel_lifecycle_control(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tunnel2_enable_tunnel_lifecycle_control", value)

    @property
    @pulumi.getter(name="tunnel2IkeVersions")
    def tunnel2_ike_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
        """
        return pulumi.get(self, "tunnel2_ike_versions")

    @tunnel2_ike_versions.setter
    def tunnel2_ike_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_ike_versions", value)

    @property
    @pulumi.getter(name="tunnel2InsideCidr")
    def tunnel2_inside_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        """
        return pulumi.get(self, "tunnel2_inside_cidr")

    @tunnel2_inside_cidr.setter
    def tunnel2_inside_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_inside_cidr", value)

    @property
    @pulumi.getter(name="tunnel2InsideIpv6Cidr")
    def tunnel2_inside_ipv6_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        """
        return pulumi.get(self, "tunnel2_inside_ipv6_cidr")

    @tunnel2_inside_ipv6_cidr.setter
    def tunnel2_inside_ipv6_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_inside_ipv6_cidr", value)

    @property
    @pulumi.getter(name="tunnel2LogOptions")
    def tunnel2_log_options(self) -> Optional[pulumi.Input['VpnConnectionTunnel2LogOptionsArgs']]:
        """
        Options for logging VPN tunnel activity. See Log Options below for more details.
        """
        return pulumi.get(self, "tunnel2_log_options")

    @tunnel2_log_options.setter
    def tunnel2_log_options(self, value: Optional[pulumi.Input['VpnConnectionTunnel2LogOptionsArgs']]):
        pulumi.set(self, "tunnel2_log_options", value)

    @property
    @pulumi.getter(name="tunnel2Phase1DhGroupNumbers")
    def tunnel2_phase1_dh_group_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel2_phase1_dh_group_numbers")

    @tunnel2_phase1_dh_group_numbers.setter
    def tunnel2_phase1_dh_group_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "tunnel2_phase1_dh_group_numbers", value)

    @property
    @pulumi.getter(name="tunnel2Phase1EncryptionAlgorithms")
    def tunnel2_phase1_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel2_phase1_encryption_algorithms")

    @tunnel2_phase1_encryption_algorithms.setter
    def tunnel2_phase1_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_phase1_encryption_algorithms", value)

    @property
    @pulumi.getter(name="tunnel2Phase1IntegrityAlgorithms")
    def tunnel2_phase1_integrity_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel2_phase1_integrity_algorithms")

    @tunnel2_phase1_integrity_algorithms.setter
    def tunnel2_phase1_integrity_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_phase1_integrity_algorithms", value)

    @property
    @pulumi.getter(name="tunnel2Phase1LifetimeSeconds")
    def tunnel2_phase1_lifetime_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        """
        return pulumi.get(self, "tunnel2_phase1_lifetime_seconds")

    @tunnel2_phase1_lifetime_seconds.setter
    def tunnel2_phase1_lifetime_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_phase1_lifetime_seconds", value)

    @property
    @pulumi.getter(name="tunnel2Phase2DhGroupNumbers")
    def tunnel2_phase2_dh_group_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel2_phase2_dh_group_numbers")

    @tunnel2_phase2_dh_group_numbers.setter
    def tunnel2_phase2_dh_group_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "tunnel2_phase2_dh_group_numbers", value)

    @property
    @pulumi.getter(name="tunnel2Phase2EncryptionAlgorithms")
    def tunnel2_phase2_encryption_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel2_phase2_encryption_algorithms")

    @tunnel2_phase2_encryption_algorithms.setter
    def tunnel2_phase2_encryption_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_phase2_encryption_algorithms", value)

    @property
    @pulumi.getter(name="tunnel2Phase2IntegrityAlgorithms")
    def tunnel2_phase2_integrity_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel2_phase2_integrity_algorithms")

    @tunnel2_phase2_integrity_algorithms.setter
    def tunnel2_phase2_integrity_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tunnel2_phase2_integrity_algorithms", value)

    @property
    @pulumi.getter(name="tunnel2Phase2LifetimeSeconds")
    def tunnel2_phase2_lifetime_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        """
        return pulumi.get(self, "tunnel2_phase2_lifetime_seconds")

    @tunnel2_phase2_lifetime_seconds.setter
    def tunnel2_phase2_lifetime_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_phase2_lifetime_seconds", value)

    @property
    @pulumi.getter(name="tunnel2PresharedKey")
    def tunnel2_preshared_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        """
        return pulumi.get(self, "tunnel2_preshared_key")

    @tunnel2_preshared_key.setter
    def tunnel2_preshared_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_preshared_key", value)

    @property
    @pulumi.getter(name="tunnel2RekeyFuzzPercentage")
    def tunnel2_rekey_fuzz_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        """
        return pulumi.get(self, "tunnel2_rekey_fuzz_percentage")

    @tunnel2_rekey_fuzz_percentage.setter
    def tunnel2_rekey_fuzz_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_rekey_fuzz_percentage", value)

    @property
    @pulumi.getter(name="tunnel2RekeyMarginTimeSeconds")
    def tunnel2_rekey_margin_time_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
        """
        return pulumi.get(self, "tunnel2_rekey_margin_time_seconds")

    @tunnel2_rekey_margin_time_seconds.setter
    def tunnel2_rekey_margin_time_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_rekey_margin_time_seconds", value)

    @property
    @pulumi.getter(name="tunnel2ReplayWindowSize")
    def tunnel2_replay_window_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
        """
        return pulumi.get(self, "tunnel2_replay_window_size")

    @tunnel2_replay_window_size.setter
    def tunnel2_replay_window_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tunnel2_replay_window_size", value)

    @property
    @pulumi.getter(name="tunnel2StartupAction")
    def tunnel2_startup_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        """
        return pulumi.get(self, "tunnel2_startup_action")

    @tunnel2_startup_action.setter
    def tunnel2_startup_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_startup_action", value)

    @property
    @pulumi.getter(name="tunnel2VgwInsideAddress")
    def tunnel2_vgw_inside_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
        """
        return pulumi.get(self, "tunnel2_vgw_inside_address")

    @tunnel2_vgw_inside_address.setter
    def tunnel2_vgw_inside_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel2_vgw_inside_address", value)

    @property
    @pulumi.getter(name="tunnelInsideIpVersion")
    def tunnel_inside_ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
        """
        return pulumi.get(self, "tunnel_inside_ip_version")

    @tunnel_inside_ip_version.setter
    def tunnel_inside_ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_inside_ip_version", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of VPN connection. The only type AWS supports at this time is "ipsec.1".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vgwTelemetries")
    def vgw_telemetries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionVgwTelemetryArgs']]]]:
        """
        Telemetry for the VPN tunnels. Detailed below.
        """
        return pulumi.get(self, "vgw_telemetries")

    @vgw_telemetries.setter
    def vgw_telemetries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionVgwTelemetryArgs']]]]):
        pulumi.set(self, "vgw_telemetries", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Virtual Private Gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpn_gateway_id", value)


@pulumi.type_token("aws:ec2/vpnConnection:VpnConnection")
class VpnConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_acceleration: Optional[pulumi.Input[builtins.bool]] = None,
                 local_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 local_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 outside_ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 preshared_key_storage: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 remote_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 remote_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 static_routes_only: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 transport_transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel1_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_log_options: Optional[pulumi.Input[Union['VpnConnectionTunnel1LogOptionsArgs', 'VpnConnectionTunnel1LogOptionsArgsDict']]] = None,
                 tunnel1_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel1_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel1_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_startup_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel2_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_log_options: Optional[pulumi.Input[Union['VpnConnectionTunnel2LogOptionsArgs', 'VpnConnectionTunnel2LogOptionsArgsDict']]] = None,
                 tunnel2_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel2_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel2_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_startup_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_inside_ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Site-to-Site VPN connection. A Site-to-Site VPN connection is an Internet Protocol security (IPsec) VPN connection between a VPC and an on-premises network.
        Any new Site-to-Site VPN connection that you create is an [AWS VPN connection](https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-categories.html).

        > **Note:** The CIDR blocks in the arguments `tunnel1_inside_cidr` and `tunnel2_inside_cidr` must have a prefix of /30 and be a part of a specific range.
        [Read more about this in the AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnTunnelOptionsSpecification.html).

        ## Example Usage

        ### EC2 Transit Gateway

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2transitgateway.TransitGateway("example")
        example_customer_gateway = aws.ec2.CustomerGateway("example",
            bgp_asn="65000",
            ip_address="172.0.0.1",
            type="ipsec.1")
        example_vpn_connection = aws.ec2.VpnConnection("example",
            customer_gateway_id=example_customer_gateway.id,
            transit_gateway_id=example.id,
            type=example_customer_gateway.type)
        ```

        ### Virtual Private Gateway

        ```python
        import pulumi
        import pulumi_aws as aws

        vpc = aws.ec2.Vpc("vpc", cidr_block="10.0.0.0/16")
        vpn_gateway = aws.ec2.VpnGateway("vpn_gateway", vpc_id=vpc.id)
        customer_gateway = aws.ec2.CustomerGateway("customer_gateway",
            bgp_asn="65000",
            ip_address="172.0.0.1",
            type="ipsec.1")
        main = aws.ec2.VpnConnection("main",
            vpn_gateway_id=vpn_gateway.id,
            customer_gateway_id=customer_gateway.id,
            type="ipsec.1",
            static_routes_only=True)
        ```

        ### AWS Site to Site Private VPN

        ```python
        import pulumi
        import pulumi_aws as aws

        example_gateway = aws.directconnect.Gateway("example",
            name="example_ipsec_vpn_example",
            amazon_side_asn="64512")
        example_transit_gateway = aws.ec2transitgateway.TransitGateway("example",
            amazon_side_asn=64513,
            description="example_ipsec_vpn_example",
            transit_gateway_cidr_blocks=["10.0.0.0/24"])
        example_customer_gateway = aws.ec2.CustomerGateway("example",
            bgp_asn="64514",
            ip_address="10.0.0.1",
            type="ipsec.1",
            tags={
                "Name": "example_ipsec_vpn_example",
            })
        example_gateway_association = aws.directconnect.GatewayAssociation("example",
            dx_gateway_id=example_gateway.id,
            associated_gateway_id=example_transit_gateway.id,
            allowed_prefixes=["10.0.0.0/8"])
        example = aws.ec2transitgateway.get_direct_connect_gateway_attachment_output(transit_gateway_id=example_transit_gateway.id,
            dx_gateway_id=example_gateway.id)
        example_vpn_connection = aws.ec2.VpnConnection("example",
            customer_gateway_id=example_customer_gateway.id,
            outside_ip_address_type="PrivateIpv4",
            transit_gateway_id=example_transit_gateway.id,
            transport_transit_gateway_attachment_id=example.id,
            type="ipsec.1",
            tags={
                "Name": "example_ipsec_vpn_example",
            })
        ```

        ## Import

        Using `pulumi import`, import VPN Connections using the VPN connection `id`. For example:

        ```sh
        $ pulumi import aws:ec2/vpnConnection:VpnConnection testvpnconnection vpn-40f41529
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[builtins.bool] enable_acceleration: Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] local_ipv4_network_cidr: The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
        :param pulumi.Input[builtins.str] local_ipv6_network_cidr: The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
        :param pulumi.Input[builtins.str] outside_ip_address_type: Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
        :param pulumi.Input[builtins.str] preshared_key_storage: Storage mode for the pre-shared key (PSK). Valid values are `Standard` (stored in the Site-to-Site VPN service) or `SecretsManager` (stored in AWS Secrets Manager).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] remote_ipv4_network_cidr: The IPv4 CIDR on the AWS side of the VPN connection.
        :param pulumi.Input[builtins.str] remote_ipv6_network_cidr: The IPv6 CIDR on the AWS side of the VPN connection.
        :param pulumi.Input[builtins.bool] static_routes_only: Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don't support BGP.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] transit_gateway_id: The ID of the EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] transport_transit_gateway_attachment_id: . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
        :param pulumi.Input[builtins.str] tunnel1_dpd_timeout_action: The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        :param pulumi.Input[builtins.int] tunnel1_dpd_timeout_seconds: The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
        :param pulumi.Input[builtins.bool] tunnel1_enable_tunnel_lifecycle_control: Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_ike_versions: The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
        :param pulumi.Input[builtins.str] tunnel1_inside_cidr: The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        :param pulumi.Input[builtins.str] tunnel1_inside_ipv6_cidr: The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        :param pulumi.Input[Union['VpnConnectionTunnel1LogOptionsArgs', 'VpnConnectionTunnel1LogOptionsArgsDict']] tunnel1_log_options: Options for logging VPN tunnel activity. See Log Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel1_phase1_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase1_encryption_algorithms: List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase1_integrity_algorithms: One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel1_phase1_lifetime_seconds: The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel1_phase2_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase2_encryption_algorithms: List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase2_integrity_algorithms: List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel1_phase2_lifetime_seconds: The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        :param pulumi.Input[builtins.str] tunnel1_preshared_key: The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        :param pulumi.Input[builtins.int] tunnel1_rekey_fuzz_percentage: The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        :param pulumi.Input[builtins.int] tunnel1_rekey_margin_time_seconds: The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
        :param pulumi.Input[builtins.int] tunnel1_replay_window_size: The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
        :param pulumi.Input[builtins.str] tunnel1_startup_action: The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        :param pulumi.Input[builtins.str] tunnel2_dpd_timeout_action: The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        :param pulumi.Input[builtins.int] tunnel2_dpd_timeout_seconds: The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
        :param pulumi.Input[builtins.bool] tunnel2_enable_tunnel_lifecycle_control: Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_ike_versions: The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
        :param pulumi.Input[builtins.str] tunnel2_inside_cidr: The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        :param pulumi.Input[builtins.str] tunnel2_inside_ipv6_cidr: The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        :param pulumi.Input[Union['VpnConnectionTunnel2LogOptionsArgs', 'VpnConnectionTunnel2LogOptionsArgsDict']] tunnel2_log_options: Options for logging VPN tunnel activity. See Log Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel2_phase1_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase1_encryption_algorithms: List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase1_integrity_algorithms: One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel2_phase1_lifetime_seconds: The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel2_phase2_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase2_encryption_algorithms: List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase2_integrity_algorithms: List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel2_phase2_lifetime_seconds: The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        :param pulumi.Input[builtins.str] tunnel2_preshared_key: The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        :param pulumi.Input[builtins.int] tunnel2_rekey_fuzz_percentage: The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        :param pulumi.Input[builtins.int] tunnel2_rekey_margin_time_seconds: The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
        :param pulumi.Input[builtins.int] tunnel2_replay_window_size: The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
        :param pulumi.Input[builtins.str] tunnel2_startup_action: The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        :param pulumi.Input[builtins.str] tunnel_inside_ip_version: Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] type: The type of VPN connection. The only type AWS supports at this time is "ipsec.1".
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the Virtual Private Gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Site-to-Site VPN connection. A Site-to-Site VPN connection is an Internet Protocol security (IPsec) VPN connection between a VPC and an on-premises network.
        Any new Site-to-Site VPN connection that you create is an [AWS VPN connection](https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-categories.html).

        > **Note:** The CIDR blocks in the arguments `tunnel1_inside_cidr` and `tunnel2_inside_cidr` must have a prefix of /30 and be a part of a specific range.
        [Read more about this in the AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnTunnelOptionsSpecification.html).

        ## Example Usage

        ### EC2 Transit Gateway

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2transitgateway.TransitGateway("example")
        example_customer_gateway = aws.ec2.CustomerGateway("example",
            bgp_asn="65000",
            ip_address="172.0.0.1",
            type="ipsec.1")
        example_vpn_connection = aws.ec2.VpnConnection("example",
            customer_gateway_id=example_customer_gateway.id,
            transit_gateway_id=example.id,
            type=example_customer_gateway.type)
        ```

        ### Virtual Private Gateway

        ```python
        import pulumi
        import pulumi_aws as aws

        vpc = aws.ec2.Vpc("vpc", cidr_block="10.0.0.0/16")
        vpn_gateway = aws.ec2.VpnGateway("vpn_gateway", vpc_id=vpc.id)
        customer_gateway = aws.ec2.CustomerGateway("customer_gateway",
            bgp_asn="65000",
            ip_address="172.0.0.1",
            type="ipsec.1")
        main = aws.ec2.VpnConnection("main",
            vpn_gateway_id=vpn_gateway.id,
            customer_gateway_id=customer_gateway.id,
            type="ipsec.1",
            static_routes_only=True)
        ```

        ### AWS Site to Site Private VPN

        ```python
        import pulumi
        import pulumi_aws as aws

        example_gateway = aws.directconnect.Gateway("example",
            name="example_ipsec_vpn_example",
            amazon_side_asn="64512")
        example_transit_gateway = aws.ec2transitgateway.TransitGateway("example",
            amazon_side_asn=64513,
            description="example_ipsec_vpn_example",
            transit_gateway_cidr_blocks=["10.0.0.0/24"])
        example_customer_gateway = aws.ec2.CustomerGateway("example",
            bgp_asn="64514",
            ip_address="10.0.0.1",
            type="ipsec.1",
            tags={
                "Name": "example_ipsec_vpn_example",
            })
        example_gateway_association = aws.directconnect.GatewayAssociation("example",
            dx_gateway_id=example_gateway.id,
            associated_gateway_id=example_transit_gateway.id,
            allowed_prefixes=["10.0.0.0/8"])
        example = aws.ec2transitgateway.get_direct_connect_gateway_attachment_output(transit_gateway_id=example_transit_gateway.id,
            dx_gateway_id=example_gateway.id)
        example_vpn_connection = aws.ec2.VpnConnection("example",
            customer_gateway_id=example_customer_gateway.id,
            outside_ip_address_type="PrivateIpv4",
            transit_gateway_id=example_transit_gateway.id,
            transport_transit_gateway_attachment_id=example.id,
            type="ipsec.1",
            tags={
                "Name": "example_ipsec_vpn_example",
            })
        ```

        ## Import

        Using `pulumi import`, import VPN Connections using the VPN connection `id`. For example:

        ```sh
        $ pulumi import aws:ec2/vpnConnection:VpnConnection testvpnconnection vpn-40f41529
        ```

        :param str resource_name: The name of the resource.
        :param VpnConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 enable_acceleration: Optional[pulumi.Input[builtins.bool]] = None,
                 local_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 local_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 outside_ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 preshared_key_storage: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 remote_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 remote_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 static_routes_only: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 transport_transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel1_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_log_options: Optional[pulumi.Input[Union['VpnConnectionTunnel1LogOptionsArgs', 'VpnConnectionTunnel1LogOptionsArgsDict']]] = None,
                 tunnel1_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel1_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel1_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel1_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel1_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel1_startup_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel2_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_log_options: Optional[pulumi.Input[Union['VpnConnectionTunnel2LogOptionsArgs', 'VpnConnectionTunnel2LogOptionsArgsDict']]] = None,
                 tunnel2_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel2_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 tunnel2_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel2_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel2_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
                 tunnel2_startup_action: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_inside_ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnConnectionArgs.__new__(VpnConnectionArgs)

            if customer_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'customer_gateway_id'")
            __props__.__dict__["customer_gateway_id"] = customer_gateway_id
            __props__.__dict__["enable_acceleration"] = enable_acceleration
            __props__.__dict__["local_ipv4_network_cidr"] = local_ipv4_network_cidr
            __props__.__dict__["local_ipv6_network_cidr"] = local_ipv6_network_cidr
            __props__.__dict__["outside_ip_address_type"] = outside_ip_address_type
            __props__.__dict__["preshared_key_storage"] = preshared_key_storage
            __props__.__dict__["region"] = region
            __props__.__dict__["remote_ipv4_network_cidr"] = remote_ipv4_network_cidr
            __props__.__dict__["remote_ipv6_network_cidr"] = remote_ipv6_network_cidr
            __props__.__dict__["static_routes_only"] = static_routes_only
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_gateway_id"] = transit_gateway_id
            __props__.__dict__["transport_transit_gateway_attachment_id"] = transport_transit_gateway_attachment_id
            __props__.__dict__["tunnel1_dpd_timeout_action"] = tunnel1_dpd_timeout_action
            __props__.__dict__["tunnel1_dpd_timeout_seconds"] = tunnel1_dpd_timeout_seconds
            __props__.__dict__["tunnel1_enable_tunnel_lifecycle_control"] = tunnel1_enable_tunnel_lifecycle_control
            __props__.__dict__["tunnel1_ike_versions"] = tunnel1_ike_versions
            __props__.__dict__["tunnel1_inside_cidr"] = tunnel1_inside_cidr
            __props__.__dict__["tunnel1_inside_ipv6_cidr"] = tunnel1_inside_ipv6_cidr
            __props__.__dict__["tunnel1_log_options"] = tunnel1_log_options
            __props__.__dict__["tunnel1_phase1_dh_group_numbers"] = tunnel1_phase1_dh_group_numbers
            __props__.__dict__["tunnel1_phase1_encryption_algorithms"] = tunnel1_phase1_encryption_algorithms
            __props__.__dict__["tunnel1_phase1_integrity_algorithms"] = tunnel1_phase1_integrity_algorithms
            __props__.__dict__["tunnel1_phase1_lifetime_seconds"] = tunnel1_phase1_lifetime_seconds
            __props__.__dict__["tunnel1_phase2_dh_group_numbers"] = tunnel1_phase2_dh_group_numbers
            __props__.__dict__["tunnel1_phase2_encryption_algorithms"] = tunnel1_phase2_encryption_algorithms
            __props__.__dict__["tunnel1_phase2_integrity_algorithms"] = tunnel1_phase2_integrity_algorithms
            __props__.__dict__["tunnel1_phase2_lifetime_seconds"] = tunnel1_phase2_lifetime_seconds
            __props__.__dict__["tunnel1_preshared_key"] = None if tunnel1_preshared_key is None else pulumi.Output.secret(tunnel1_preshared_key)
            __props__.__dict__["tunnel1_rekey_fuzz_percentage"] = tunnel1_rekey_fuzz_percentage
            __props__.__dict__["tunnel1_rekey_margin_time_seconds"] = tunnel1_rekey_margin_time_seconds
            __props__.__dict__["tunnel1_replay_window_size"] = tunnel1_replay_window_size
            __props__.__dict__["tunnel1_startup_action"] = tunnel1_startup_action
            __props__.__dict__["tunnel2_dpd_timeout_action"] = tunnel2_dpd_timeout_action
            __props__.__dict__["tunnel2_dpd_timeout_seconds"] = tunnel2_dpd_timeout_seconds
            __props__.__dict__["tunnel2_enable_tunnel_lifecycle_control"] = tunnel2_enable_tunnel_lifecycle_control
            __props__.__dict__["tunnel2_ike_versions"] = tunnel2_ike_versions
            __props__.__dict__["tunnel2_inside_cidr"] = tunnel2_inside_cidr
            __props__.__dict__["tunnel2_inside_ipv6_cidr"] = tunnel2_inside_ipv6_cidr
            __props__.__dict__["tunnel2_log_options"] = tunnel2_log_options
            __props__.__dict__["tunnel2_phase1_dh_group_numbers"] = tunnel2_phase1_dh_group_numbers
            __props__.__dict__["tunnel2_phase1_encryption_algorithms"] = tunnel2_phase1_encryption_algorithms
            __props__.__dict__["tunnel2_phase1_integrity_algorithms"] = tunnel2_phase1_integrity_algorithms
            __props__.__dict__["tunnel2_phase1_lifetime_seconds"] = tunnel2_phase1_lifetime_seconds
            __props__.__dict__["tunnel2_phase2_dh_group_numbers"] = tunnel2_phase2_dh_group_numbers
            __props__.__dict__["tunnel2_phase2_encryption_algorithms"] = tunnel2_phase2_encryption_algorithms
            __props__.__dict__["tunnel2_phase2_integrity_algorithms"] = tunnel2_phase2_integrity_algorithms
            __props__.__dict__["tunnel2_phase2_lifetime_seconds"] = tunnel2_phase2_lifetime_seconds
            __props__.__dict__["tunnel2_preshared_key"] = None if tunnel2_preshared_key is None else pulumi.Output.secret(tunnel2_preshared_key)
            __props__.__dict__["tunnel2_rekey_fuzz_percentage"] = tunnel2_rekey_fuzz_percentage
            __props__.__dict__["tunnel2_rekey_margin_time_seconds"] = tunnel2_rekey_margin_time_seconds
            __props__.__dict__["tunnel2_replay_window_size"] = tunnel2_replay_window_size
            __props__.__dict__["tunnel2_startup_action"] = tunnel2_startup_action
            __props__.__dict__["tunnel_inside_ip_version"] = tunnel_inside_ip_version
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["core_network_arn"] = None
            __props__.__dict__["core_network_attachment_arn"] = None
            __props__.__dict__["customer_gateway_configuration"] = None
            __props__.__dict__["preshared_key_arn"] = None
            __props__.__dict__["routes"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["transit_gateway_attachment_id"] = None
            __props__.__dict__["tunnel1_address"] = None
            __props__.__dict__["tunnel1_bgp_asn"] = None
            __props__.__dict__["tunnel1_bgp_holdtime"] = None
            __props__.__dict__["tunnel1_cgw_inside_address"] = None
            __props__.__dict__["tunnel1_vgw_inside_address"] = None
            __props__.__dict__["tunnel2_address"] = None
            __props__.__dict__["tunnel2_bgp_asn"] = None
            __props__.__dict__["tunnel2_bgp_holdtime"] = None
            __props__.__dict__["tunnel2_cgw_inside_address"] = None
            __props__.__dict__["tunnel2_vgw_inside_address"] = None
            __props__.__dict__["vgw_telemetries"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["customerGatewayConfiguration", "tunnel1PresharedKey", "tunnel2PresharedKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VpnConnection, __self__).__init__(
            'aws:ec2/vpnConnection:VpnConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
            core_network_attachment_arn: Optional[pulumi.Input[builtins.str]] = None,
            customer_gateway_configuration: Optional[pulumi.Input[builtins.str]] = None,
            customer_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            enable_acceleration: Optional[pulumi.Input[builtins.bool]] = None,
            local_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
            local_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
            outside_ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
            preshared_key_arn: Optional[pulumi.Input[builtins.str]] = None,
            preshared_key_storage: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            remote_ipv4_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
            remote_ipv6_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionRouteArgs', 'VpnConnectionRouteArgsDict']]]]] = None,
            static_routes_only: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
            transit_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
            transport_transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_bgp_asn: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_bgp_holdtime: Optional[pulumi.Input[builtins.int]] = None,
            tunnel1_cgw_inside_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
            tunnel1_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
            tunnel1_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel1_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_log_options: Optional[pulumi.Input[Union['VpnConnectionTunnel1LogOptionsArgs', 'VpnConnectionTunnel1LogOptionsArgsDict']]] = None,
            tunnel1_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            tunnel1_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel1_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel1_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
            tunnel1_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            tunnel1_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel1_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel1_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
            tunnel1_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
            tunnel1_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
            tunnel1_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
            tunnel1_startup_action: Optional[pulumi.Input[builtins.str]] = None,
            tunnel1_vgw_inside_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_bgp_asn: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_bgp_holdtime: Optional[pulumi.Input[builtins.int]] = None,
            tunnel2_cgw_inside_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_dpd_timeout_action: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_dpd_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
            tunnel2_enable_tunnel_lifecycle_control: Optional[pulumi.Input[builtins.bool]] = None,
            tunnel2_ike_versions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel2_inside_cidr: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_inside_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_log_options: Optional[pulumi.Input[Union['VpnConnectionTunnel2LogOptionsArgs', 'VpnConnectionTunnel2LogOptionsArgsDict']]] = None,
            tunnel2_phase1_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            tunnel2_phase1_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel2_phase1_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel2_phase1_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
            tunnel2_phase2_dh_group_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            tunnel2_phase2_encryption_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel2_phase2_integrity_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tunnel2_phase2_lifetime_seconds: Optional[pulumi.Input[builtins.int]] = None,
            tunnel2_preshared_key: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_rekey_fuzz_percentage: Optional[pulumi.Input[builtins.int]] = None,
            tunnel2_rekey_margin_time_seconds: Optional[pulumi.Input[builtins.int]] = None,
            tunnel2_replay_window_size: Optional[pulumi.Input[builtins.int]] = None,
            tunnel2_startup_action: Optional[pulumi.Input[builtins.str]] = None,
            tunnel2_vgw_inside_address: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_inside_ip_version: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            vgw_telemetries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionVgwTelemetryArgs', 'VpnConnectionVgwTelemetryArgsDict']]]]] = None,
            vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None) -> 'VpnConnection':
        """
        Get an existing VpnConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the VPN Connection.
        :param pulumi.Input[builtins.str] core_network_arn: The ARN of the core network.
        :param pulumi.Input[builtins.str] core_network_attachment_arn: The ARN of the core network attachment.
        :param pulumi.Input[builtins.str] customer_gateway_configuration: The configuration information for the VPN connection's customer gateway (in the native XML format).
        :param pulumi.Input[builtins.str] customer_gateway_id: The ID of the customer gateway.
        :param pulumi.Input[builtins.bool] enable_acceleration: Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] local_ipv4_network_cidr: The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
        :param pulumi.Input[builtins.str] local_ipv6_network_cidr: The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
        :param pulumi.Input[builtins.str] outside_ip_address_type: Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
        :param pulumi.Input[builtins.str] preshared_key_arn: ARN of the Secrets Manager secret storing the pre-shared key(s) for the VPN connection. Note that even if it returns a valid Secrets Manager ARN, the pre-shared key(s) will not be stored in Secrets Manager unless the `preshared_key_storage` argument is set to `SecretsManager`.
        :param pulumi.Input[builtins.str] preshared_key_storage: Storage mode for the pre-shared key (PSK). Valid values are `Standard` (stored in the Site-to-Site VPN service) or `SecretsManager` (stored in AWS Secrets Manager).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] remote_ipv4_network_cidr: The IPv4 CIDR on the AWS side of the VPN connection.
        :param pulumi.Input[builtins.str] remote_ipv6_network_cidr: The IPv6 CIDR on the AWS side of the VPN connection.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionRouteArgs', 'VpnConnectionRouteArgsDict']]]] routes: The static routes associated with the VPN connection. Detailed below.
        :param pulumi.Input[builtins.bool] static_routes_only: Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don't support BGP.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
        :param pulumi.Input[builtins.str] transit_gateway_id: The ID of the EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] transport_transit_gateway_attachment_id: . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
        :param pulumi.Input[builtins.str] tunnel1_address: The public IP address of the first VPN tunnel.
        :param pulumi.Input[builtins.str] tunnel1_bgp_asn: The bgp asn number of the first VPN tunnel.
        :param pulumi.Input[builtins.int] tunnel1_bgp_holdtime: The bgp holdtime of the first VPN tunnel.
        :param pulumi.Input[builtins.str] tunnel1_cgw_inside_address: The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
        :param pulumi.Input[builtins.str] tunnel1_dpd_timeout_action: The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        :param pulumi.Input[builtins.int] tunnel1_dpd_timeout_seconds: The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
        :param pulumi.Input[builtins.bool] tunnel1_enable_tunnel_lifecycle_control: Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_ike_versions: The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
        :param pulumi.Input[builtins.str] tunnel1_inside_cidr: The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        :param pulumi.Input[builtins.str] tunnel1_inside_ipv6_cidr: The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        :param pulumi.Input[Union['VpnConnectionTunnel1LogOptionsArgs', 'VpnConnectionTunnel1LogOptionsArgsDict']] tunnel1_log_options: Options for logging VPN tunnel activity. See Log Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel1_phase1_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase1_encryption_algorithms: List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase1_integrity_algorithms: One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel1_phase1_lifetime_seconds: The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel1_phase2_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase2_encryption_algorithms: List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel1_phase2_integrity_algorithms: List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel1_phase2_lifetime_seconds: The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        :param pulumi.Input[builtins.str] tunnel1_preshared_key: The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        :param pulumi.Input[builtins.int] tunnel1_rekey_fuzz_percentage: The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        :param pulumi.Input[builtins.int] tunnel1_rekey_margin_time_seconds: The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
        :param pulumi.Input[builtins.int] tunnel1_replay_window_size: The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
        :param pulumi.Input[builtins.str] tunnel1_startup_action: The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        :param pulumi.Input[builtins.str] tunnel1_vgw_inside_address: The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
        :param pulumi.Input[builtins.str] tunnel2_address: The public IP address of the second VPN tunnel.
        :param pulumi.Input[builtins.str] tunnel2_bgp_asn: The bgp asn number of the second VPN tunnel.
        :param pulumi.Input[builtins.int] tunnel2_bgp_holdtime: The bgp holdtime of the second VPN tunnel.
        :param pulumi.Input[builtins.str] tunnel2_cgw_inside_address: The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
        :param pulumi.Input[builtins.str] tunnel2_dpd_timeout_action: The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        :param pulumi.Input[builtins.int] tunnel2_dpd_timeout_seconds: The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
        :param pulumi.Input[builtins.bool] tunnel2_enable_tunnel_lifecycle_control: Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_ike_versions: The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
        :param pulumi.Input[builtins.str] tunnel2_inside_cidr: The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        :param pulumi.Input[builtins.str] tunnel2_inside_ipv6_cidr: The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        :param pulumi.Input[Union['VpnConnectionTunnel2LogOptionsArgs', 'VpnConnectionTunnel2LogOptionsArgsDict']] tunnel2_log_options: Options for logging VPN tunnel activity. See Log Options below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel2_phase1_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase1_encryption_algorithms: List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase1_integrity_algorithms: One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel2_phase1_lifetime_seconds: The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] tunnel2_phase2_dh_group_numbers: List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase2_encryption_algorithms: List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tunnel2_phase2_integrity_algorithms: List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        :param pulumi.Input[builtins.int] tunnel2_phase2_lifetime_seconds: The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        :param pulumi.Input[builtins.str] tunnel2_preshared_key: The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        :param pulumi.Input[builtins.int] tunnel2_rekey_fuzz_percentage: The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        :param pulumi.Input[builtins.int] tunnel2_rekey_margin_time_seconds: The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
        :param pulumi.Input[builtins.int] tunnel2_replay_window_size: The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
        :param pulumi.Input[builtins.str] tunnel2_startup_action: The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        :param pulumi.Input[builtins.str] tunnel2_vgw_inside_address: The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
        :param pulumi.Input[builtins.str] tunnel_inside_ip_version: Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
        :param pulumi.Input[builtins.str] type: The type of VPN connection. The only type AWS supports at this time is "ipsec.1".
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionVgwTelemetryArgs', 'VpnConnectionVgwTelemetryArgsDict']]]] vgw_telemetries: Telemetry for the VPN tunnels. Detailed below.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the Virtual Private Gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnConnectionState.__new__(_VpnConnectionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["core_network_arn"] = core_network_arn
        __props__.__dict__["core_network_attachment_arn"] = core_network_attachment_arn
        __props__.__dict__["customer_gateway_configuration"] = customer_gateway_configuration
        __props__.__dict__["customer_gateway_id"] = customer_gateway_id
        __props__.__dict__["enable_acceleration"] = enable_acceleration
        __props__.__dict__["local_ipv4_network_cidr"] = local_ipv4_network_cidr
        __props__.__dict__["local_ipv6_network_cidr"] = local_ipv6_network_cidr
        __props__.__dict__["outside_ip_address_type"] = outside_ip_address_type
        __props__.__dict__["preshared_key_arn"] = preshared_key_arn
        __props__.__dict__["preshared_key_storage"] = preshared_key_storage
        __props__.__dict__["region"] = region
        __props__.__dict__["remote_ipv4_network_cidr"] = remote_ipv4_network_cidr
        __props__.__dict__["remote_ipv6_network_cidr"] = remote_ipv6_network_cidr
        __props__.__dict__["routes"] = routes
        __props__.__dict__["static_routes_only"] = static_routes_only
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["transit_gateway_attachment_id"] = transit_gateway_attachment_id
        __props__.__dict__["transit_gateway_id"] = transit_gateway_id
        __props__.__dict__["transport_transit_gateway_attachment_id"] = transport_transit_gateway_attachment_id
        __props__.__dict__["tunnel1_address"] = tunnel1_address
        __props__.__dict__["tunnel1_bgp_asn"] = tunnel1_bgp_asn
        __props__.__dict__["tunnel1_bgp_holdtime"] = tunnel1_bgp_holdtime
        __props__.__dict__["tunnel1_cgw_inside_address"] = tunnel1_cgw_inside_address
        __props__.__dict__["tunnel1_dpd_timeout_action"] = tunnel1_dpd_timeout_action
        __props__.__dict__["tunnel1_dpd_timeout_seconds"] = tunnel1_dpd_timeout_seconds
        __props__.__dict__["tunnel1_enable_tunnel_lifecycle_control"] = tunnel1_enable_tunnel_lifecycle_control
        __props__.__dict__["tunnel1_ike_versions"] = tunnel1_ike_versions
        __props__.__dict__["tunnel1_inside_cidr"] = tunnel1_inside_cidr
        __props__.__dict__["tunnel1_inside_ipv6_cidr"] = tunnel1_inside_ipv6_cidr
        __props__.__dict__["tunnel1_log_options"] = tunnel1_log_options
        __props__.__dict__["tunnel1_phase1_dh_group_numbers"] = tunnel1_phase1_dh_group_numbers
        __props__.__dict__["tunnel1_phase1_encryption_algorithms"] = tunnel1_phase1_encryption_algorithms
        __props__.__dict__["tunnel1_phase1_integrity_algorithms"] = tunnel1_phase1_integrity_algorithms
        __props__.__dict__["tunnel1_phase1_lifetime_seconds"] = tunnel1_phase1_lifetime_seconds
        __props__.__dict__["tunnel1_phase2_dh_group_numbers"] = tunnel1_phase2_dh_group_numbers
        __props__.__dict__["tunnel1_phase2_encryption_algorithms"] = tunnel1_phase2_encryption_algorithms
        __props__.__dict__["tunnel1_phase2_integrity_algorithms"] = tunnel1_phase2_integrity_algorithms
        __props__.__dict__["tunnel1_phase2_lifetime_seconds"] = tunnel1_phase2_lifetime_seconds
        __props__.__dict__["tunnel1_preshared_key"] = tunnel1_preshared_key
        __props__.__dict__["tunnel1_rekey_fuzz_percentage"] = tunnel1_rekey_fuzz_percentage
        __props__.__dict__["tunnel1_rekey_margin_time_seconds"] = tunnel1_rekey_margin_time_seconds
        __props__.__dict__["tunnel1_replay_window_size"] = tunnel1_replay_window_size
        __props__.__dict__["tunnel1_startup_action"] = tunnel1_startup_action
        __props__.__dict__["tunnel1_vgw_inside_address"] = tunnel1_vgw_inside_address
        __props__.__dict__["tunnel2_address"] = tunnel2_address
        __props__.__dict__["tunnel2_bgp_asn"] = tunnel2_bgp_asn
        __props__.__dict__["tunnel2_bgp_holdtime"] = tunnel2_bgp_holdtime
        __props__.__dict__["tunnel2_cgw_inside_address"] = tunnel2_cgw_inside_address
        __props__.__dict__["tunnel2_dpd_timeout_action"] = tunnel2_dpd_timeout_action
        __props__.__dict__["tunnel2_dpd_timeout_seconds"] = tunnel2_dpd_timeout_seconds
        __props__.__dict__["tunnel2_enable_tunnel_lifecycle_control"] = tunnel2_enable_tunnel_lifecycle_control
        __props__.__dict__["tunnel2_ike_versions"] = tunnel2_ike_versions
        __props__.__dict__["tunnel2_inside_cidr"] = tunnel2_inside_cidr
        __props__.__dict__["tunnel2_inside_ipv6_cidr"] = tunnel2_inside_ipv6_cidr
        __props__.__dict__["tunnel2_log_options"] = tunnel2_log_options
        __props__.__dict__["tunnel2_phase1_dh_group_numbers"] = tunnel2_phase1_dh_group_numbers
        __props__.__dict__["tunnel2_phase1_encryption_algorithms"] = tunnel2_phase1_encryption_algorithms
        __props__.__dict__["tunnel2_phase1_integrity_algorithms"] = tunnel2_phase1_integrity_algorithms
        __props__.__dict__["tunnel2_phase1_lifetime_seconds"] = tunnel2_phase1_lifetime_seconds
        __props__.__dict__["tunnel2_phase2_dh_group_numbers"] = tunnel2_phase2_dh_group_numbers
        __props__.__dict__["tunnel2_phase2_encryption_algorithms"] = tunnel2_phase2_encryption_algorithms
        __props__.__dict__["tunnel2_phase2_integrity_algorithms"] = tunnel2_phase2_integrity_algorithms
        __props__.__dict__["tunnel2_phase2_lifetime_seconds"] = tunnel2_phase2_lifetime_seconds
        __props__.__dict__["tunnel2_preshared_key"] = tunnel2_preshared_key
        __props__.__dict__["tunnel2_rekey_fuzz_percentage"] = tunnel2_rekey_fuzz_percentage
        __props__.__dict__["tunnel2_rekey_margin_time_seconds"] = tunnel2_rekey_margin_time_seconds
        __props__.__dict__["tunnel2_replay_window_size"] = tunnel2_replay_window_size
        __props__.__dict__["tunnel2_startup_action"] = tunnel2_startup_action
        __props__.__dict__["tunnel2_vgw_inside_address"] = tunnel2_vgw_inside_address
        __props__.__dict__["tunnel_inside_ip_version"] = tunnel_inside_ip_version
        __props__.__dict__["type"] = type
        __props__.__dict__["vgw_telemetries"] = vgw_telemetries
        __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
        return VpnConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the VPN Connection.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the core network.
        """
        return pulumi.get(self, "core_network_arn")

    @property
    @pulumi.getter(name="coreNetworkAttachmentArn")
    def core_network_attachment_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the core network attachment.
        """
        return pulumi.get(self, "core_network_attachment_arn")

    @property
    @pulumi.getter(name="customerGatewayConfiguration")
    def customer_gateway_configuration(self) -> pulumi.Output[builtins.str]:
        """
        The configuration information for the VPN connection's customer gateway (in the native XML format).
        """
        return pulumi.get(self, "customer_gateway_configuration")

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @property
    @pulumi.getter(name="enableAcceleration")
    def enable_acceleration(self) -> pulumi.Output[builtins.bool]:
        """
        Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
        """
        return pulumi.get(self, "enable_acceleration")

    @property
    @pulumi.getter(name="localIpv4NetworkCidr")
    def local_ipv4_network_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
        """
        return pulumi.get(self, "local_ipv4_network_cidr")

    @property
    @pulumi.getter(name="localIpv6NetworkCidr")
    def local_ipv6_network_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
        """
        return pulumi.get(self, "local_ipv6_network_cidr")

    @property
    @pulumi.getter(name="outsideIpAddressType")
    def outside_ip_address_type(self) -> pulumi.Output[builtins.str]:
        """
        Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
        """
        return pulumi.get(self, "outside_ip_address_type")

    @property
    @pulumi.getter(name="presharedKeyArn")
    def preshared_key_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Secrets Manager secret storing the pre-shared key(s) for the VPN connection. Note that even if it returns a valid Secrets Manager ARN, the pre-shared key(s) will not be stored in Secrets Manager unless the `preshared_key_storage` argument is set to `SecretsManager`.
        """
        return pulumi.get(self, "preshared_key_arn")

    @property
    @pulumi.getter(name="presharedKeyStorage")
    def preshared_key_storage(self) -> pulumi.Output[builtins.str]:
        """
        Storage mode for the pre-shared key (PSK). Valid values are `Standard` (stored in the Site-to-Site VPN service) or `SecretsManager` (stored in AWS Secrets Manager).
        """
        return pulumi.get(self, "preshared_key_storage")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="remoteIpv4NetworkCidr")
    def remote_ipv4_network_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The IPv4 CIDR on the AWS side of the VPN connection.
        """
        return pulumi.get(self, "remote_ipv4_network_cidr")

    @property
    @pulumi.getter(name="remoteIpv6NetworkCidr")
    def remote_ipv6_network_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The IPv6 CIDR on the AWS side of the VPN connection.
        """
        return pulumi.get(self, "remote_ipv6_network_cidr")

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Sequence['outputs.VpnConnectionRoute']]:
        """
        The static routes associated with the VPN connection. Detailed below.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="staticRoutesOnly")
    def static_routes_only(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don't support BGP.
        """
        return pulumi.get(self, "static_routes_only")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> pulumi.Output[builtins.str]:
        """
        When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the EC2 Transit Gateway.
        """
        return pulumi.get(self, "transit_gateway_id")

    @property
    @pulumi.getter(name="transportTransitGatewayAttachmentId")
    def transport_transit_gateway_attachment_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
        """
        return pulumi.get(self, "transport_transit_gateway_attachment_id")

    @property
    @pulumi.getter(name="tunnel1Address")
    def tunnel1_address(self) -> pulumi.Output[builtins.str]:
        """
        The public IP address of the first VPN tunnel.
        """
        return pulumi.get(self, "tunnel1_address")

    @property
    @pulumi.getter(name="tunnel1BgpAsn")
    def tunnel1_bgp_asn(self) -> pulumi.Output[builtins.str]:
        """
        The bgp asn number of the first VPN tunnel.
        """
        return pulumi.get(self, "tunnel1_bgp_asn")

    @property
    @pulumi.getter(name="tunnel1BgpHoldtime")
    def tunnel1_bgp_holdtime(self) -> pulumi.Output[builtins.int]:
        """
        The bgp holdtime of the first VPN tunnel.
        """
        return pulumi.get(self, "tunnel1_bgp_holdtime")

    @property
    @pulumi.getter(name="tunnel1CgwInsideAddress")
    def tunnel1_cgw_inside_address(self) -> pulumi.Output[builtins.str]:
        """
        The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
        """
        return pulumi.get(self, "tunnel1_cgw_inside_address")

    @property
    @pulumi.getter(name="tunnel1DpdTimeoutAction")
    def tunnel1_dpd_timeout_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        """
        return pulumi.get(self, "tunnel1_dpd_timeout_action")

    @property
    @pulumi.getter(name="tunnel1DpdTimeoutSeconds")
    def tunnel1_dpd_timeout_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
        """
        return pulumi.get(self, "tunnel1_dpd_timeout_seconds")

    @property
    @pulumi.getter(name="tunnel1EnableTunnelLifecycleControl")
    def tunnel1_enable_tunnel_lifecycle_control(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
        """
        return pulumi.get(self, "tunnel1_enable_tunnel_lifecycle_control")

    @property
    @pulumi.getter(name="tunnel1IkeVersions")
    def tunnel1_ike_versions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
        """
        return pulumi.get(self, "tunnel1_ike_versions")

    @property
    @pulumi.getter(name="tunnel1InsideCidr")
    def tunnel1_inside_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        """
        return pulumi.get(self, "tunnel1_inside_cidr")

    @property
    @pulumi.getter(name="tunnel1InsideIpv6Cidr")
    def tunnel1_inside_ipv6_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        """
        return pulumi.get(self, "tunnel1_inside_ipv6_cidr")

    @property
    @pulumi.getter(name="tunnel1LogOptions")
    def tunnel1_log_options(self) -> pulumi.Output['outputs.VpnConnectionTunnel1LogOptions']:
        """
        Options for logging VPN tunnel activity. See Log Options below for more details.
        """
        return pulumi.get(self, "tunnel1_log_options")

    @property
    @pulumi.getter(name="tunnel1Phase1DhGroupNumbers")
    def tunnel1_phase1_dh_group_numbers(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel1_phase1_dh_group_numbers")

    @property
    @pulumi.getter(name="tunnel1Phase1EncryptionAlgorithms")
    def tunnel1_phase1_encryption_algorithms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel1_phase1_encryption_algorithms")

    @property
    @pulumi.getter(name="tunnel1Phase1IntegrityAlgorithms")
    def tunnel1_phase1_integrity_algorithms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel1_phase1_integrity_algorithms")

    @property
    @pulumi.getter(name="tunnel1Phase1LifetimeSeconds")
    def tunnel1_phase1_lifetime_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        """
        return pulumi.get(self, "tunnel1_phase1_lifetime_seconds")

    @property
    @pulumi.getter(name="tunnel1Phase2DhGroupNumbers")
    def tunnel1_phase2_dh_group_numbers(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel1_phase2_dh_group_numbers")

    @property
    @pulumi.getter(name="tunnel1Phase2EncryptionAlgorithms")
    def tunnel1_phase2_encryption_algorithms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel1_phase2_encryption_algorithms")

    @property
    @pulumi.getter(name="tunnel1Phase2IntegrityAlgorithms")
    def tunnel1_phase2_integrity_algorithms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel1_phase2_integrity_algorithms")

    @property
    @pulumi.getter(name="tunnel1Phase2LifetimeSeconds")
    def tunnel1_phase2_lifetime_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        """
        return pulumi.get(self, "tunnel1_phase2_lifetime_seconds")

    @property
    @pulumi.getter(name="tunnel1PresharedKey")
    def tunnel1_preshared_key(self) -> pulumi.Output[builtins.str]:
        """
        The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        """
        return pulumi.get(self, "tunnel1_preshared_key")

    @property
    @pulumi.getter(name="tunnel1RekeyFuzzPercentage")
    def tunnel1_rekey_fuzz_percentage(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        """
        return pulumi.get(self, "tunnel1_rekey_fuzz_percentage")

    @property
    @pulumi.getter(name="tunnel1RekeyMarginTimeSeconds")
    def tunnel1_rekey_margin_time_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
        """
        return pulumi.get(self, "tunnel1_rekey_margin_time_seconds")

    @property
    @pulumi.getter(name="tunnel1ReplayWindowSize")
    def tunnel1_replay_window_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
        """
        return pulumi.get(self, "tunnel1_replay_window_size")

    @property
    @pulumi.getter(name="tunnel1StartupAction")
    def tunnel1_startup_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        """
        return pulumi.get(self, "tunnel1_startup_action")

    @property
    @pulumi.getter(name="tunnel1VgwInsideAddress")
    def tunnel1_vgw_inside_address(self) -> pulumi.Output[builtins.str]:
        """
        The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
        """
        return pulumi.get(self, "tunnel1_vgw_inside_address")

    @property
    @pulumi.getter(name="tunnel2Address")
    def tunnel2_address(self) -> pulumi.Output[builtins.str]:
        """
        The public IP address of the second VPN tunnel.
        """
        return pulumi.get(self, "tunnel2_address")

    @property
    @pulumi.getter(name="tunnel2BgpAsn")
    def tunnel2_bgp_asn(self) -> pulumi.Output[builtins.str]:
        """
        The bgp asn number of the second VPN tunnel.
        """
        return pulumi.get(self, "tunnel2_bgp_asn")

    @property
    @pulumi.getter(name="tunnel2BgpHoldtime")
    def tunnel2_bgp_holdtime(self) -> pulumi.Output[builtins.int]:
        """
        The bgp holdtime of the second VPN tunnel.
        """
        return pulumi.get(self, "tunnel2_bgp_holdtime")

    @property
    @pulumi.getter(name="tunnel2CgwInsideAddress")
    def tunnel2_cgw_inside_address(self) -> pulumi.Output[builtins.str]:
        """
        The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
        """
        return pulumi.get(self, "tunnel2_cgw_inside_address")

    @property
    @pulumi.getter(name="tunnel2DpdTimeoutAction")
    def tunnel2_dpd_timeout_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
        """
        return pulumi.get(self, "tunnel2_dpd_timeout_action")

    @property
    @pulumi.getter(name="tunnel2DpdTimeoutSeconds")
    def tunnel2_dpd_timeout_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
        """
        return pulumi.get(self, "tunnel2_dpd_timeout_seconds")

    @property
    @pulumi.getter(name="tunnel2EnableTunnelLifecycleControl")
    def tunnel2_enable_tunnel_lifecycle_control(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
        """
        return pulumi.get(self, "tunnel2_enable_tunnel_lifecycle_control")

    @property
    @pulumi.getter(name="tunnel2IkeVersions")
    def tunnel2_ike_versions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
        """
        return pulumi.get(self, "tunnel2_ike_versions")

    @property
    @pulumi.getter(name="tunnel2InsideCidr")
    def tunnel2_inside_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
        """
        return pulumi.get(self, "tunnel2_inside_cidr")

    @property
    @pulumi.getter(name="tunnel2InsideIpv6Cidr")
    def tunnel2_inside_ipv6_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
        """
        return pulumi.get(self, "tunnel2_inside_ipv6_cidr")

    @property
    @pulumi.getter(name="tunnel2LogOptions")
    def tunnel2_log_options(self) -> pulumi.Output['outputs.VpnConnectionTunnel2LogOptions']:
        """
        Options for logging VPN tunnel activity. See Log Options below for more details.
        """
        return pulumi.get(self, "tunnel2_log_options")

    @property
    @pulumi.getter(name="tunnel2Phase1DhGroupNumbers")
    def tunnel2_phase1_dh_group_numbers(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are ` 2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel2_phase1_dh_group_numbers")

    @property
    @pulumi.getter(name="tunnel2Phase1EncryptionAlgorithms")
    def tunnel2_phase1_encryption_algorithms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel2_phase1_encryption_algorithms")

    @property
    @pulumi.getter(name="tunnel2Phase1IntegrityAlgorithms")
    def tunnel2_phase1_integrity_algorithms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel2_phase1_integrity_algorithms")

    @property
    @pulumi.getter(name="tunnel2Phase1LifetimeSeconds")
    def tunnel2_phase1_lifetime_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
        """
        return pulumi.get(self, "tunnel2_phase1_lifetime_seconds")

    @property
    @pulumi.getter(name="tunnel2Phase2DhGroupNumbers")
    def tunnel2_phase2_dh_group_numbers(self) -> pulumi.Output[Optional[Sequence[builtins.int]]]:
        """
        List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
        """
        return pulumi.get(self, "tunnel2_phase2_dh_group_numbers")

    @property
    @pulumi.getter(name="tunnel2Phase2EncryptionAlgorithms")
    def tunnel2_phase2_encryption_algorithms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
        """
        return pulumi.get(self, "tunnel2_phase2_encryption_algorithms")

    @property
    @pulumi.getter(name="tunnel2Phase2IntegrityAlgorithms")
    def tunnel2_phase2_integrity_algorithms(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
        """
        return pulumi.get(self, "tunnel2_phase2_integrity_algorithms")

    @property
    @pulumi.getter(name="tunnel2Phase2LifetimeSeconds")
    def tunnel2_phase2_lifetime_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
        """
        return pulumi.get(self, "tunnel2_phase2_lifetime_seconds")

    @property
    @pulumi.getter(name="tunnel2PresharedKey")
    def tunnel2_preshared_key(self) -> pulumi.Output[builtins.str]:
        """
        The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
        """
        return pulumi.get(self, "tunnel2_preshared_key")

    @property
    @pulumi.getter(name="tunnel2RekeyFuzzPercentage")
    def tunnel2_rekey_fuzz_percentage(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
        """
        return pulumi.get(self, "tunnel2_rekey_fuzz_percentage")

    @property
    @pulumi.getter(name="tunnel2RekeyMarginTimeSeconds")
    def tunnel2_rekey_margin_time_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
        """
        return pulumi.get(self, "tunnel2_rekey_margin_time_seconds")

    @property
    @pulumi.getter(name="tunnel2ReplayWindowSize")
    def tunnel2_replay_window_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
        """
        return pulumi.get(self, "tunnel2_replay_window_size")

    @property
    @pulumi.getter(name="tunnel2StartupAction")
    def tunnel2_startup_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
        """
        return pulumi.get(self, "tunnel2_startup_action")

    @property
    @pulumi.getter(name="tunnel2VgwInsideAddress")
    def tunnel2_vgw_inside_address(self) -> pulumi.Output[builtins.str]:
        """
        The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
        """
        return pulumi.get(self, "tunnel2_vgw_inside_address")

    @property
    @pulumi.getter(name="tunnelInsideIpVersion")
    def tunnel_inside_ip_version(self) -> pulumi.Output[builtins.str]:
        """
        Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
        """
        return pulumi.get(self, "tunnel_inside_ip_version")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of VPN connection. The only type AWS supports at this time is "ipsec.1".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vgwTelemetries")
    def vgw_telemetries(self) -> pulumi.Output[Sequence['outputs.VpnConnectionVgwTelemetry']]:
        """
        Telemetry for the VPN tunnels. Detailed below.
        """
        return pulumi.get(self, "vgw_telemetries")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Virtual Private Gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

