# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrefixListReferenceArgs', 'PrefixListReference']

@pulumi.input_type
class PrefixListReferenceArgs:
    def __init__(__self__, *,
                 prefix_list_id: pulumi.Input[builtins.str],
                 transit_gateway_route_table_id: pulumi.Input[builtins.str],
                 blackhole: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PrefixListReference resource.
        :param pulumi.Input[builtins.str] prefix_list_id: Identifier of EC2 Prefix List.
        :param pulumi.Input[builtins.str] transit_gateway_route_table_id: Identifier of EC2 Transit Gateway Route Table.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] blackhole: Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: Identifier of EC2 Transit Gateway Attachment.
        """
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        pulumi.set(__self__, "transit_gateway_route_table_id", transit_gateway_route_table_id)
        if blackhole is not None:
            pulumi.set(__self__, "blackhole", blackhole)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transit_gateway_attachment_id", transit_gateway_attachment_id)

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of EC2 Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @prefix_list_id.setter
    def prefix_list_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "prefix_list_id", value)

    @property
    @pulumi.getter(name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of EC2 Transit Gateway Route Table.

        The following arguments are optional:
        """
        return pulumi.get(self, "transit_gateway_route_table_id")

    @transit_gateway_route_table_id.setter
    def transit_gateway_route_table_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "transit_gateway_route_table_id", value)

    @property
    @pulumi.getter
    def blackhole(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
        """
        return pulumi.get(self, "blackhole")

    @blackhole.setter
    def blackhole(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "blackhole", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of EC2 Transit Gateway Attachment.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @transit_gateway_attachment_id.setter
    def transit_gateway_attachment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_attachment_id", value)


@pulumi.input_type
class _PrefixListReferenceState:
    def __init__(__self__, *,
                 blackhole: Optional[pulumi.Input[builtins.bool]] = None,
                 prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 prefix_list_owner_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_route_table_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrefixListReference resources.
        :param pulumi.Input[builtins.bool] blackhole: Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
        :param pulumi.Input[builtins.str] prefix_list_id: Identifier of EC2 Prefix List.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: Identifier of EC2 Transit Gateway Attachment.
        :param pulumi.Input[builtins.str] transit_gateway_route_table_id: Identifier of EC2 Transit Gateway Route Table.
               
               The following arguments are optional:
        """
        if blackhole is not None:
            pulumi.set(__self__, "blackhole", blackhole)
        if prefix_list_id is not None:
            pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        if prefix_list_owner_id is not None:
            pulumi.set(__self__, "prefix_list_owner_id", prefix_list_owner_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transit_gateway_attachment_id", transit_gateway_attachment_id)
        if transit_gateway_route_table_id is not None:
            pulumi.set(__self__, "transit_gateway_route_table_id", transit_gateway_route_table_id)

    @property
    @pulumi.getter
    def blackhole(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
        """
        return pulumi.get(self, "blackhole")

    @blackhole.setter
    def blackhole(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "blackhole", value)

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of EC2 Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @prefix_list_id.setter
    def prefix_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix_list_id", value)

    @property
    @pulumi.getter(name="prefixListOwnerId")
    def prefix_list_owner_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "prefix_list_owner_id")

    @prefix_list_owner_id.setter
    def prefix_list_owner_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix_list_owner_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of EC2 Transit Gateway Attachment.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @transit_gateway_attachment_id.setter
    def transit_gateway_attachment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_attachment_id", value)

    @property
    @pulumi.getter(name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of EC2 Transit Gateway Route Table.

        The following arguments are optional:
        """
        return pulumi.get(self, "transit_gateway_route_table_id")

    @transit_gateway_route_table_id.setter
    def transit_gateway_route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transit_gateway_route_table_id", value)


@pulumi.type_token("aws:ec2transitgateway/prefixListReference:PrefixListReference")
class PrefixListReference(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blackhole: Optional[pulumi.Input[builtins.bool]] = None,
                 prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an EC2 Transit Gateway Prefix List Reference.

        ## Example Usage

        ### Attachment Routing

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2transitgateway.PrefixListReference("example",
            prefix_list_id=example_aws_ec2_managed_prefix_list["id"],
            transit_gateway_attachment_id=example_aws_ec2_transit_gateway_vpc_attachment["id"],
            transit_gateway_route_table_id=example_aws_ec2_transit_gateway["associationDefaultRouteTableId"])
        ```

        ### Blackhole Routing

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2transitgateway.PrefixListReference("example",
            blackhole=True,
            prefix_list_id=example_aws_ec2_managed_prefix_list["id"],
            transit_gateway_route_table_id=example_aws_ec2_transit_gateway["associationDefaultRouteTableId"])
        ```

        ## Import

        Using `pulumi import`, import `aws_ec2_transit_gateway_prefix_list_reference` using the EC2 Transit Gateway Route Table identifier and EC2 Prefix List identifier, separated by an underscore (`_`). For example:

        ```sh
        $ pulumi import aws:ec2transitgateway/prefixListReference:PrefixListReference example tgw-rtb-12345678_pl-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] blackhole: Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
        :param pulumi.Input[builtins.str] prefix_list_id: Identifier of EC2 Prefix List.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: Identifier of EC2 Transit Gateway Attachment.
        :param pulumi.Input[builtins.str] transit_gateway_route_table_id: Identifier of EC2 Transit Gateway Route Table.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrefixListReferenceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EC2 Transit Gateway Prefix List Reference.

        ## Example Usage

        ### Attachment Routing

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2transitgateway.PrefixListReference("example",
            prefix_list_id=example_aws_ec2_managed_prefix_list["id"],
            transit_gateway_attachment_id=example_aws_ec2_transit_gateway_vpc_attachment["id"],
            transit_gateway_route_table_id=example_aws_ec2_transit_gateway["associationDefaultRouteTableId"])
        ```

        ### Blackhole Routing

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2transitgateway.PrefixListReference("example",
            blackhole=True,
            prefix_list_id=example_aws_ec2_managed_prefix_list["id"],
            transit_gateway_route_table_id=example_aws_ec2_transit_gateway["associationDefaultRouteTableId"])
        ```

        ## Import

        Using `pulumi import`, import `aws_ec2_transit_gateway_prefix_list_reference` using the EC2 Transit Gateway Route Table identifier and EC2 Prefix List identifier, separated by an underscore (`_`). For example:

        ```sh
        $ pulumi import aws:ec2transitgateway/prefixListReference:PrefixListReference example tgw-rtb-12345678_pl-12345678
        ```

        :param str resource_name: The name of the resource.
        :param PrefixListReferenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrefixListReferenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blackhole: Optional[pulumi.Input[builtins.bool]] = None,
                 prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 transit_gateway_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrefixListReferenceArgs.__new__(PrefixListReferenceArgs)

            __props__.__dict__["blackhole"] = blackhole
            if prefix_list_id is None and not opts.urn:
                raise TypeError("Missing required property 'prefix_list_id'")
            __props__.__dict__["prefix_list_id"] = prefix_list_id
            __props__.__dict__["region"] = region
            __props__.__dict__["transit_gateway_attachment_id"] = transit_gateway_attachment_id
            if transit_gateway_route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_route_table_id'")
            __props__.__dict__["transit_gateway_route_table_id"] = transit_gateway_route_table_id
            __props__.__dict__["prefix_list_owner_id"] = None
        super(PrefixListReference, __self__).__init__(
            'aws:ec2transitgateway/prefixListReference:PrefixListReference',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blackhole: Optional[pulumi.Input[builtins.bool]] = None,
            prefix_list_id: Optional[pulumi.Input[builtins.str]] = None,
            prefix_list_owner_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            transit_gateway_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
            transit_gateway_route_table_id: Optional[pulumi.Input[builtins.str]] = None) -> 'PrefixListReference':
        """
        Get an existing PrefixListReference resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] blackhole: Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
        :param pulumi.Input[builtins.str] prefix_list_id: Identifier of EC2 Prefix List.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] transit_gateway_attachment_id: Identifier of EC2 Transit Gateway Attachment.
        :param pulumi.Input[builtins.str] transit_gateway_route_table_id: Identifier of EC2 Transit Gateway Route Table.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrefixListReferenceState.__new__(_PrefixListReferenceState)

        __props__.__dict__["blackhole"] = blackhole
        __props__.__dict__["prefix_list_id"] = prefix_list_id
        __props__.__dict__["prefix_list_owner_id"] = prefix_list_owner_id
        __props__.__dict__["region"] = region
        __props__.__dict__["transit_gateway_attachment_id"] = transit_gateway_attachment_id
        __props__.__dict__["transit_gateway_route_table_id"] = transit_gateway_route_table_id
        return PrefixListReference(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def blackhole(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
        """
        return pulumi.get(self, "blackhole")

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of EC2 Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @property
    @pulumi.getter(name="prefixListOwnerId")
    def prefix_list_owner_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "prefix_list_owner_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of EC2 Transit Gateway Attachment.
        """
        return pulumi.get(self, "transit_gateway_attachment_id")

    @property
    @pulumi.getter(name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of EC2 Transit Gateway Route Table.

        The following arguments are optional:
        """
        return pulumi.get(self, "transit_gateway_route_table_id")

