# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAuthorizationTokenResult',
    'AwaitableGetAuthorizationTokenResult',
    'get_authorization_token',
    'get_authorization_token_output',
]

@pulumi.output_type
class GetAuthorizationTokenResult:
    """
    A collection of values returned by getAuthorizationToken.
    """
    def __init__(__self__, authorization_token=None, expires_at=None, id=None, password=None, proxy_endpoint=None, region=None, registry_id=None, user_name=None):
        if authorization_token and not isinstance(authorization_token, str):
            raise TypeError("Expected argument 'authorization_token' to be a str")
        pulumi.set(__self__, "authorization_token", authorization_token)
        if expires_at and not isinstance(expires_at, str):
            raise TypeError("Expected argument 'expires_at' to be a str")
        pulumi.set(__self__, "expires_at", expires_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if proxy_endpoint and not isinstance(proxy_endpoint, str):
            raise TypeError("Expected argument 'proxy_endpoint' to be a str")
        pulumi.set(__self__, "proxy_endpoint", proxy_endpoint)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="authorizationToken")
    def authorization_token(self) -> builtins.str:
        """
        Temporary IAM authentication credentials to access the ECR repository encoded in base64 in the form of `user_name:password`.
        """
        return pulumi.get(self, "authorization_token")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> builtins.str:
        """
        Time in UTC RFC3339 format when the authorization token expires.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Password decoded from the authorization token.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="proxyEndpoint")
    def proxy_endpoint(self) -> builtins.str:
        """
        Registry URL to use in the docker login command.
        """
        return pulumi.get(self, "proxy_endpoint")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> builtins.str:
        """
        User name decoded from the authorization token.
        """
        return pulumi.get(self, "user_name")


class AwaitableGetAuthorizationTokenResult(GetAuthorizationTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthorizationTokenResult(
            authorization_token=self.authorization_token,
            expires_at=self.expires_at,
            id=self.id,
            password=self.password,
            proxy_endpoint=self.proxy_endpoint,
            region=self.region,
            registry_id=self.registry_id,
            user_name=self.user_name)


def get_authorization_token(region: Optional[builtins.str] = None,
                            registry_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthorizationTokenResult:
    """
    The ECR Authorization Token data source allows the authorization token, proxy endpoint, token expiration date, user name and password to be retrieved for an ECR repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    token = aws.ecr.get_authorization_token()
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str registry_id: AWS account ID of the ECR Repository. If not specified the default account is assumed.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['registryId'] = registry_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ecr/getAuthorizationToken:getAuthorizationToken', __args__, opts=opts, typ=GetAuthorizationTokenResult).value

    return AwaitableGetAuthorizationTokenResult(
        authorization_token=pulumi.get(__ret__, 'authorization_token'),
        expires_at=pulumi.get(__ret__, 'expires_at'),
        id=pulumi.get(__ret__, 'id'),
        password=pulumi.get(__ret__, 'password'),
        proxy_endpoint=pulumi.get(__ret__, 'proxy_endpoint'),
        region=pulumi.get(__ret__, 'region'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        user_name=pulumi.get(__ret__, 'user_name'))
def get_authorization_token_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   registry_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthorizationTokenResult]:
    """
    The ECR Authorization Token data source allows the authorization token, proxy endpoint, token expiration date, user name and password to be retrieved for an ECR repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    token = aws.ecr.get_authorization_token()
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str registry_id: AWS account ID of the ECR Repository. If not specified the default account is assumed.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['registryId'] = registry_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ecr/getAuthorizationToken:getAuthorizationToken', __args__, opts=opts, typ=GetAuthorizationTokenResult)
    return __ret__.apply(lambda __response__: GetAuthorizationTokenResult(
        authorization_token=pulumi.get(__response__, 'authorization_token'),
        expires_at=pulumi.get(__response__, 'expires_at'),
        id=pulumi.get(__response__, 'id'),
        password=pulumi.get(__response__, 'password'),
        proxy_endpoint=pulumi.get(__response__, 'proxy_endpoint'),
        region=pulumi.get(__response__, 'region'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        user_name=pulumi.get(__response__, 'user_name')))
