# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'RepositoryCatalogDataArgs',
    'RepositoryCatalogDataArgsDict',
]

MYPY = False

if not MYPY:
    class RepositoryCatalogDataArgsDict(TypedDict):
        about_text: NotRequired[pulumi.Input[builtins.str]]
        """
        A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
        """
        architectures: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
        """
        logo_image_blob: NotRequired[pulumi.Input[builtins.str]]
        """
        The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
        """
        operating_systems: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
        """
        usage_text: NotRequired[pulumi.Input[builtins.str]]
        """
        Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
        """
elif False:
    RepositoryCatalogDataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryCatalogDataArgs:
    def __init__(__self__, *,
                 about_text: Optional[pulumi.Input[builtins.str]] = None,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 logo_image_blob: Optional[pulumi.Input[builtins.str]] = None,
                 operating_systems: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 usage_text: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] about_text: A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] architectures: The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
        :param pulumi.Input[builtins.str] description: A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
        :param pulumi.Input[builtins.str] logo_image_blob: The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] operating_systems: The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
        :param pulumi.Input[builtins.str] usage_text: Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
        """
        if about_text is not None:
            pulumi.set(__self__, "about_text", about_text)
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if logo_image_blob is not None:
            pulumi.set(__self__, "logo_image_blob", logo_image_blob)
        if operating_systems is not None:
            pulumi.set(__self__, "operating_systems", operating_systems)
        if usage_text is not None:
            pulumi.set(__self__, "usage_text", usage_text)

    @property
    @pulumi.getter(name="aboutText")
    def about_text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
        """
        return pulumi.get(self, "about_text")

    @about_text.setter
    def about_text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "about_text", value)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "architectures", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="logoImageBlob")
    def logo_image_blob(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
        """
        return pulumi.get(self, "logo_image_blob")

    @logo_image_blob.setter
    def logo_image_blob(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logo_image_blob", value)

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
        """
        return pulumi.get(self, "operating_systems")

    @operating_systems.setter
    def operating_systems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "operating_systems", value)

    @property
    @pulumi.getter(name="usageText")
    def usage_text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
        """
        return pulumi.get(self, "usage_text")

    @usage_text.setter
    def usage_text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "usage_text", value)


