# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['ClusterConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_connect_defaults: Optional[pulumi.Input['ClusterServiceConnectDefaultsArgs']] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSettingArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['ClusterConfigurationArgs'] configuration: Execute command configuration for the cluster. See `configuration` Block for details.
        :param pulumi.Input[builtins.str] name: Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ClusterServiceConnectDefaultsArgs'] service_connect_defaults: Default Service Connect namespace. See `service_connect_defaults` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterSettingArgs']]] settings: Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_connect_defaults is not None:
            pulumi.set(__self__, "service_connect_defaults", service_connect_defaults)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ClusterConfigurationArgs']]:
        """
        Execute command configuration for the cluster. See `configuration` Block for details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ClusterConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceConnectDefaults")
    def service_connect_defaults(self) -> Optional[pulumi.Input['ClusterServiceConnectDefaultsArgs']]:
        """
        Default Service Connect namespace. See `service_connect_defaults` Block for details.
        """
        return pulumi.get(self, "service_connect_defaults")

    @service_connect_defaults.setter
    def service_connect_defaults(self, value: Optional[pulumi.Input['ClusterServiceConnectDefaultsArgs']]):
        pulumi.set(self, "service_connect_defaults", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSettingArgs']]]]:
        """
        Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input['ClusterConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_connect_defaults: Optional[pulumi.Input['ClusterServiceConnectDefaultsArgs']] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSettingArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[builtins.str] arn: ARN that identifies the cluster.
        :param pulumi.Input['ClusterConfigurationArgs'] configuration: Execute command configuration for the cluster. See `configuration` Block for details.
        :param pulumi.Input[builtins.str] name: Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ClusterServiceConnectDefaultsArgs'] service_connect_defaults: Default Service Connect namespace. See `service_connect_defaults` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterSettingArgs']]] settings: Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_connect_defaults is not None:
            pulumi.set(__self__, "service_connect_defaults", service_connect_defaults)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN that identifies the cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ClusterConfigurationArgs']]:
        """
        Execute command configuration for the cluster. See `configuration` Block for details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ClusterConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceConnectDefaults")
    def service_connect_defaults(self) -> Optional[pulumi.Input['ClusterServiceConnectDefaultsArgs']]:
        """
        Default Service Connect namespace. See `service_connect_defaults` Block for details.
        """
        return pulumi.get(self, "service_connect_defaults")

    @service_connect_defaults.setter
    def service_connect_defaults(self, value: Optional[pulumi.Input['ClusterServiceConnectDefaultsArgs']]):
        pulumi.set(self, "service_connect_defaults", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSettingArgs']]]]:
        """
        Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:ecs/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['ClusterConfigurationArgs', 'ClusterConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_connect_defaults: Optional[pulumi.Input[Union['ClusterServiceConnectDefaultsArgs', 'ClusterServiceConnectDefaultsArgsDict']]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterSettingArgs', 'ClusterSettingArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an ECS cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ecs.Cluster("foo",
            name="white-hart",
            settings=[{
                "name": "containerInsights",
                "value": "enabled",
            }])
        ```

        ### Execute Command Configuration with Override Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="example",
            deletion_window_in_days=7)
        example_log_group = aws.cloudwatch.LogGroup("example", name="example")
        test = aws.ecs.Cluster("test",
            name="example",
            configuration={
                "execute_command_configuration": {
                    "kms_key_id": example.arn,
                    "logging": "OVERRIDE",
                    "log_configuration": {
                        "cloud_watch_encryption_enabled": True,
                        "cloud_watch_log_group_name": example_log_group.name,
                    },
                },
            })
        ```

        ### Fargate Ephemeral Storage Encryption with Customer-Managed KMS Key

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.kms.Key("example",
            description="example",
            deletion_window_in_days=7)
        example_key_policy = aws.kms.KeyPolicy("example",
            key_id=example.id,
            policy=json.dumps({
                "Id": "ECSClusterFargatePolicy",
                "Statement": [
                    {
                        "Sid": "Enable IAM User Permissions",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": "*",
                        },
                        "Action": "kms:*",
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow generate data key access for Fargate tasks.",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "fargate.amazonaws.com",
                        },
                        "Action": ["kms:GenerateDataKeyWithoutPlaintext"],
                        "Condition": {
                            "StringEquals": {
                                "kms:EncryptionContext:aws:ecs:clusterAccount": [current.account_id],
                                "kms:EncryptionContext:aws:ecs:clusterName": ["example"],
                            },
                        },
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow grant creation permission for Fargate tasks.",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "fargate.amazonaws.com",
                        },
                        "Action": ["kms:CreateGrant"],
                        "Condition": {
                            "StringEquals": {
                                "kms:EncryptionContext:aws:ecs:clusterAccount": [current.account_id],
                                "kms:EncryptionContext:aws:ecs:clusterName": ["example"],
                            },
                            "ForAllValues:StringEquals": {
                                "kms:GrantOperations": ["Decrypt"],
                            },
                        },
                        "Resource": "*",
                    },
                ],
                "Version": "2012-10-17",
            }))
        test = aws.ecs.Cluster("test",
            name="example",
            configuration={
                "managed_storage_configuration": {
                    "fargate_ephemeral_storage_kms_key_id": example.id,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_key_policy]))
        ```

        ## Import

        Using `pulumi import`, import ECS clusters using the cluster name. For example:

        ```sh
        $ pulumi import aws:ecs/cluster:Cluster stateless stateless-app
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterConfigurationArgs', 'ClusterConfigurationArgsDict']] configuration: Execute command configuration for the cluster. See `configuration` Block for details.
        :param pulumi.Input[builtins.str] name: Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClusterServiceConnectDefaultsArgs', 'ClusterServiceConnectDefaultsArgsDict']] service_connect_defaults: Default Service Connect namespace. See `service_connect_defaults` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterSettingArgs', 'ClusterSettingArgsDict']]]] settings: Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an ECS cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        foo = aws.ecs.Cluster("foo",
            name="white-hart",
            settings=[{
                "name": "containerInsights",
                "value": "enabled",
            }])
        ```

        ### Execute Command Configuration with Override Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="example",
            deletion_window_in_days=7)
        example_log_group = aws.cloudwatch.LogGroup("example", name="example")
        test = aws.ecs.Cluster("test",
            name="example",
            configuration={
                "execute_command_configuration": {
                    "kms_key_id": example.arn,
                    "logging": "OVERRIDE",
                    "log_configuration": {
                        "cloud_watch_encryption_enabled": True,
                        "cloud_watch_log_group_name": example_log_group.name,
                    },
                },
            })
        ```

        ### Fargate Ephemeral Storage Encryption with Customer-Managed KMS Key

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.kms.Key("example",
            description="example",
            deletion_window_in_days=7)
        example_key_policy = aws.kms.KeyPolicy("example",
            key_id=example.id,
            policy=json.dumps({
                "Id": "ECSClusterFargatePolicy",
                "Statement": [
                    {
                        "Sid": "Enable IAM User Permissions",
                        "Effect": "Allow",
                        "Principal": {
                            "AWS": "*",
                        },
                        "Action": "kms:*",
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow generate data key access for Fargate tasks.",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "fargate.amazonaws.com",
                        },
                        "Action": ["kms:GenerateDataKeyWithoutPlaintext"],
                        "Condition": {
                            "StringEquals": {
                                "kms:EncryptionContext:aws:ecs:clusterAccount": [current.account_id],
                                "kms:EncryptionContext:aws:ecs:clusterName": ["example"],
                            },
                        },
                        "Resource": "*",
                    },
                    {
                        "Sid": "Allow grant creation permission for Fargate tasks.",
                        "Effect": "Allow",
                        "Principal": {
                            "Service": "fargate.amazonaws.com",
                        },
                        "Action": ["kms:CreateGrant"],
                        "Condition": {
                            "StringEquals": {
                                "kms:EncryptionContext:aws:ecs:clusterAccount": [current.account_id],
                                "kms:EncryptionContext:aws:ecs:clusterName": ["example"],
                            },
                            "ForAllValues:StringEquals": {
                                "kms:GrantOperations": ["Decrypt"],
                            },
                        },
                        "Resource": "*",
                    },
                ],
                "Version": "2012-10-17",
            }))
        test = aws.ecs.Cluster("test",
            name="example",
            configuration={
                "managed_storage_configuration": {
                    "fargate_ephemeral_storage_kms_key_id": example.id,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_key_policy]))
        ```

        ## Import

        Using `pulumi import`, import ECS clusters using the cluster name. For example:

        ```sh
        $ pulumi import aws:ecs/cluster:Cluster stateless stateless-app
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['ClusterConfigurationArgs', 'ClusterConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_connect_defaults: Optional[pulumi.Input[Union['ClusterServiceConnectDefaultsArgs', 'ClusterServiceConnectDefaultsArgsDict']]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterSettingArgs', 'ClusterSettingArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["service_connect_defaults"] = service_connect_defaults
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Cluster, __self__).__init__(
            'aws:ecs/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['ClusterConfigurationArgs', 'ClusterConfigurationArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            service_connect_defaults: Optional[pulumi.Input[Union['ClusterServiceConnectDefaultsArgs', 'ClusterServiceConnectDefaultsArgsDict']]] = None,
            settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterSettingArgs', 'ClusterSettingArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN that identifies the cluster.
        :param pulumi.Input[Union['ClusterConfigurationArgs', 'ClusterConfigurationArgsDict']] configuration: Execute command configuration for the cluster. See `configuration` Block for details.
        :param pulumi.Input[builtins.str] name: Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClusterServiceConnectDefaultsArgs', 'ClusterServiceConnectDefaultsArgsDict']] service_connect_defaults: Default Service Connect namespace. See `service_connect_defaults` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterSettingArgs', 'ClusterSettingArgsDict']]]] settings: Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["service_connect_defaults"] = service_connect_defaults
        __props__.__dict__["settings"] = settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN that identifies the cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.ClusterConfiguration']]:
        """
        Execute command configuration for the cluster. See `configuration` Block for details.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceConnectDefaults")
    def service_connect_defaults(self) -> pulumi.Output[Optional['outputs.ClusterServiceConnectDefaults']]:
        """
        Default Service Connect namespace. See `service_connect_defaults` Block for details.
        """
        return pulumi.get(self, "service_connect_defaults")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Sequence['outputs.ClusterSetting']]:
        """
        Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. See `setting` Block for details.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

