# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTaskExecutionResult',
    'AwaitableGetTaskExecutionResult',
    'get_task_execution',
    'get_task_execution_output',
]

@pulumi.output_type
class GetTaskExecutionResult:
    """
    A collection of values returned by getTaskExecution.
    """
    def __init__(__self__, capacity_provider_strategies=None, client_token=None, cluster=None, desired_count=None, enable_ecs_managed_tags=None, enable_execute_command=None, group=None, id=None, launch_type=None, network_configuration=None, overrides=None, placement_constraints=None, placement_strategies=None, platform_version=None, propagate_tags=None, reference_id=None, region=None, started_by=None, tags=None, task_arns=None, task_definition=None):
        if capacity_provider_strategies and not isinstance(capacity_provider_strategies, list):
            raise TypeError("Expected argument 'capacity_provider_strategies' to be a list")
        pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if client_token and not isinstance(client_token, str):
            raise TypeError("Expected argument 'client_token' to be a str")
        pulumi.set(__self__, "client_token", client_token)
        if cluster and not isinstance(cluster, str):
            raise TypeError("Expected argument 'cluster' to be a str")
        pulumi.set(__self__, "cluster", cluster)
        if desired_count and not isinstance(desired_count, int):
            raise TypeError("Expected argument 'desired_count' to be a int")
        pulumi.set(__self__, "desired_count", desired_count)
        if enable_ecs_managed_tags and not isinstance(enable_ecs_managed_tags, bool):
            raise TypeError("Expected argument 'enable_ecs_managed_tags' to be a bool")
        pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command and not isinstance(enable_execute_command, bool):
            raise TypeError("Expected argument 'enable_execute_command' to be a bool")
        pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if launch_type and not isinstance(launch_type, str):
            raise TypeError("Expected argument 'launch_type' to be a str")
        pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration and not isinstance(network_configuration, dict):
            raise TypeError("Expected argument 'network_configuration' to be a dict")
        pulumi.set(__self__, "network_configuration", network_configuration)
        if overrides and not isinstance(overrides, dict):
            raise TypeError("Expected argument 'overrides' to be a dict")
        pulumi.set(__self__, "overrides", overrides)
        if placement_constraints and not isinstance(placement_constraints, list):
            raise TypeError("Expected argument 'placement_constraints' to be a list")
        pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategies and not isinstance(placement_strategies, list):
            raise TypeError("Expected argument 'placement_strategies' to be a list")
        pulumi.set(__self__, "placement_strategies", placement_strategies)
        if platform_version and not isinstance(platform_version, str):
            raise TypeError("Expected argument 'platform_version' to be a str")
        pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags and not isinstance(propagate_tags, str):
            raise TypeError("Expected argument 'propagate_tags' to be a str")
        pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id and not isinstance(reference_id, str):
            raise TypeError("Expected argument 'reference_id' to be a str")
        pulumi.set(__self__, "reference_id", reference_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if started_by and not isinstance(started_by, str):
            raise TypeError("Expected argument 'started_by' to be a str")
        pulumi.set(__self__, "started_by", started_by)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if task_arns and not isinstance(task_arns, list):
            raise TypeError("Expected argument 'task_arns' to be a list")
        pulumi.set(__self__, "task_arns", task_arns)
        if task_definition and not isinstance(task_definition, str):
            raise TypeError("Expected argument 'task_definition' to be a str")
        pulumi.set(__self__, "task_definition", task_definition)

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[Sequence['outputs.GetTaskExecutionCapacityProviderStrategyResult']]:
        return pulumi.get(self, "capacity_provider_strategies")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[builtins.str]:
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter
    def cluster(self) -> builtins.str:
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="desiredCount")
    def desired_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "desired_count")

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_ecs_managed_tags")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.GetTaskExecutionNetworkConfigurationResult']:
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter
    def overrides(self) -> Optional['outputs.GetTaskExecutionOverridesResult']:
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[Sequence['outputs.GetTaskExecutionPlacementConstraintResult']]:
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="placementStrategies")
    def placement_strategies(self) -> Optional[Sequence['outputs.GetTaskExecutionPlacementStrategyResult']]:
        return pulumi.get(self, "placement_strategies")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[builtins.str]:
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[builtins.str]:
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="startedBy")
    def started_by(self) -> Optional[builtins.str]:
        return pulumi.get(self, "started_by")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskArns")
    def task_arns(self) -> Sequence[builtins.str]:
        """
        A list of the provisioned task ARNs.
        """
        return pulumi.get(self, "task_arns")

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> builtins.str:
        return pulumi.get(self, "task_definition")


class AwaitableGetTaskExecutionResult(GetTaskExecutionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskExecutionResult(
            capacity_provider_strategies=self.capacity_provider_strategies,
            client_token=self.client_token,
            cluster=self.cluster,
            desired_count=self.desired_count,
            enable_ecs_managed_tags=self.enable_ecs_managed_tags,
            enable_execute_command=self.enable_execute_command,
            group=self.group,
            id=self.id,
            launch_type=self.launch_type,
            network_configuration=self.network_configuration,
            overrides=self.overrides,
            placement_constraints=self.placement_constraints,
            placement_strategies=self.placement_strategies,
            platform_version=self.platform_version,
            propagate_tags=self.propagate_tags,
            reference_id=self.reference_id,
            region=self.region,
            started_by=self.started_by,
            tags=self.tags,
            task_arns=self.task_arns,
            task_definition=self.task_definition)


def get_task_execution(capacity_provider_strategies: Optional[Sequence[Union['GetTaskExecutionCapacityProviderStrategyArgs', 'GetTaskExecutionCapacityProviderStrategyArgsDict']]] = None,
                       client_token: Optional[builtins.str] = None,
                       cluster: Optional[builtins.str] = None,
                       desired_count: Optional[builtins.int] = None,
                       enable_ecs_managed_tags: Optional[builtins.bool] = None,
                       enable_execute_command: Optional[builtins.bool] = None,
                       group: Optional[builtins.str] = None,
                       launch_type: Optional[builtins.str] = None,
                       network_configuration: Optional[Union['GetTaskExecutionNetworkConfigurationArgs', 'GetTaskExecutionNetworkConfigurationArgsDict']] = None,
                       overrides: Optional[Union['GetTaskExecutionOverridesArgs', 'GetTaskExecutionOverridesArgsDict']] = None,
                       placement_constraints: Optional[Sequence[Union['GetTaskExecutionPlacementConstraintArgs', 'GetTaskExecutionPlacementConstraintArgsDict']]] = None,
                       placement_strategies: Optional[Sequence[Union['GetTaskExecutionPlacementStrategyArgs', 'GetTaskExecutionPlacementStrategyArgsDict']]] = None,
                       platform_version: Optional[builtins.str] = None,
                       propagate_tags: Optional[builtins.str] = None,
                       reference_id: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       started_by: Optional[builtins.str] = None,
                       tags: Optional[Mapping[str, builtins.str]] = None,
                       task_definition: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskExecutionResult:
    """
    Data source for managing an AWS ECS (Elastic Container) Task Execution. This data source calls the [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API, allowing execution of one-time tasks that don't fit a standard resource lifecycle. See the feature request issue for additional context.

    > **NOTE on preview operations:** This data source calls the `RunTask` API on every read operation, which means new task(s) may be created from a `pulumi preview` command if all attributes are known. Placing this functionality behind a data source is an intentional trade off to enable use cases requiring a one-time task execution without relying on provisioners. Caution should be taken to ensure the data source is only executed once, or that the resulting tasks can safely run in parallel.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ecs.get_task_execution(cluster=example_aws_ecs_cluster["id"],
        task_definition=example_aws_ecs_task_definition["arn"],
        desired_count=1,
        launch_type="FARGATE",
        network_configuration={
            "subnets": [__item["id"] for __item in example_aws_subnet],
            "security_groups": [example_aws_security_group["id"]],
            "assign_public_ip": False,
        })
    ```


    :param Sequence[Union['GetTaskExecutionCapacityProviderStrategyArgs', 'GetTaskExecutionCapacityProviderStrategyArgsDict']] capacity_provider_strategies: Set of capacity provider strategies to use for the cluster. See below.
    :param builtins.str client_token: An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 64 characters are allowed. The valid characters are characters in the range of 33-126, inclusive. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/ECS_Idempotency.html).
    :param builtins.str cluster: Short name or full Amazon Resource Name (ARN) of the cluster to run the task on.
    :param builtins.int desired_count: Number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.
    :param builtins.bool enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
    :param builtins.bool enable_execute_command: Specifies whether to enable Amazon ECS Exec for the tasks within the service.
    :param builtins.str group: Name of the task group to associate with the task. The default value is the family name of the task definition.
    :param builtins.str launch_type: Launch type on which to run your service. Valid values are `EC2`, `FARGATE`, and `EXTERNAL`.
    :param Union['GetTaskExecutionNetworkConfigurationArgs', 'GetTaskExecutionNetworkConfigurationArgsDict'] network_configuration: Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
    :param Union['GetTaskExecutionOverridesArgs', 'GetTaskExecutionOverridesArgsDict'] overrides: A list of container overrides that specify the name of a container in the specified task definition and the overrides it should receive.
    :param Sequence[Union['GetTaskExecutionPlacementConstraintArgs', 'GetTaskExecutionPlacementConstraintArgsDict']] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
    :param Sequence[Union['GetTaskExecutionPlacementStrategyArgs', 'GetTaskExecutionPlacementStrategyArgsDict']] placement_strategies: The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
    :param builtins.str platform_version: The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the `LATEST` platform version is used.
    :param builtins.str propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. An error will be received if you specify the `SERVICE` option when running a task. Valid values are `TASK_DEFINITION` or `NONE`.
    :param builtins.str reference_id: The reference ID to use for the task.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str started_by: An optional tag specified when a task is started.
    :param Mapping[str, builtins.str] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
    :param builtins.str task_definition: The `family` and `revision` (`family:revision`) or full ARN of the task definition to run. If a revision isn't specified, the latest `ACTIVE` revision is used.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['capacityProviderStrategies'] = capacity_provider_strategies
    __args__['clientToken'] = client_token
    __args__['cluster'] = cluster
    __args__['desiredCount'] = desired_count
    __args__['enableEcsManagedTags'] = enable_ecs_managed_tags
    __args__['enableExecuteCommand'] = enable_execute_command
    __args__['group'] = group
    __args__['launchType'] = launch_type
    __args__['networkConfiguration'] = network_configuration
    __args__['overrides'] = overrides
    __args__['placementConstraints'] = placement_constraints
    __args__['placementStrategies'] = placement_strategies
    __args__['platformVersion'] = platform_version
    __args__['propagateTags'] = propagate_tags
    __args__['referenceId'] = reference_id
    __args__['region'] = region
    __args__['startedBy'] = started_by
    __args__['tags'] = tags
    __args__['taskDefinition'] = task_definition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ecs/getTaskExecution:getTaskExecution', __args__, opts=opts, typ=GetTaskExecutionResult).value

    return AwaitableGetTaskExecutionResult(
        capacity_provider_strategies=pulumi.get(__ret__, 'capacity_provider_strategies'),
        client_token=pulumi.get(__ret__, 'client_token'),
        cluster=pulumi.get(__ret__, 'cluster'),
        desired_count=pulumi.get(__ret__, 'desired_count'),
        enable_ecs_managed_tags=pulumi.get(__ret__, 'enable_ecs_managed_tags'),
        enable_execute_command=pulumi.get(__ret__, 'enable_execute_command'),
        group=pulumi.get(__ret__, 'group'),
        id=pulumi.get(__ret__, 'id'),
        launch_type=pulumi.get(__ret__, 'launch_type'),
        network_configuration=pulumi.get(__ret__, 'network_configuration'),
        overrides=pulumi.get(__ret__, 'overrides'),
        placement_constraints=pulumi.get(__ret__, 'placement_constraints'),
        placement_strategies=pulumi.get(__ret__, 'placement_strategies'),
        platform_version=pulumi.get(__ret__, 'platform_version'),
        propagate_tags=pulumi.get(__ret__, 'propagate_tags'),
        reference_id=pulumi.get(__ret__, 'reference_id'),
        region=pulumi.get(__ret__, 'region'),
        started_by=pulumi.get(__ret__, 'started_by'),
        tags=pulumi.get(__ret__, 'tags'),
        task_arns=pulumi.get(__ret__, 'task_arns'),
        task_definition=pulumi.get(__ret__, 'task_definition'))
def get_task_execution_output(capacity_provider_strategies: Optional[pulumi.Input[Optional[Sequence[Union['GetTaskExecutionCapacityProviderStrategyArgs', 'GetTaskExecutionCapacityProviderStrategyArgsDict']]]]] = None,
                              client_token: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              cluster: Optional[pulumi.Input[builtins.str]] = None,
                              desired_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                              enable_ecs_managed_tags: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                              enable_execute_command: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                              group: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              launch_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              network_configuration: Optional[pulumi.Input[Optional[Union['GetTaskExecutionNetworkConfigurationArgs', 'GetTaskExecutionNetworkConfigurationArgsDict']]]] = None,
                              overrides: Optional[pulumi.Input[Optional[Union['GetTaskExecutionOverridesArgs', 'GetTaskExecutionOverridesArgsDict']]]] = None,
                              placement_constraints: Optional[pulumi.Input[Optional[Sequence[Union['GetTaskExecutionPlacementConstraintArgs', 'GetTaskExecutionPlacementConstraintArgsDict']]]]] = None,
                              placement_strategies: Optional[pulumi.Input[Optional[Sequence[Union['GetTaskExecutionPlacementStrategyArgs', 'GetTaskExecutionPlacementStrategyArgsDict']]]]] = None,
                              platform_version: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              propagate_tags: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              reference_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              started_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                              task_definition: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTaskExecutionResult]:
    """
    Data source for managing an AWS ECS (Elastic Container) Task Execution. This data source calls the [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API, allowing execution of one-time tasks that don't fit a standard resource lifecycle. See the feature request issue for additional context.

    > **NOTE on preview operations:** This data source calls the `RunTask` API on every read operation, which means new task(s) may be created from a `pulumi preview` command if all attributes are known. Placing this functionality behind a data source is an intentional trade off to enable use cases requiring a one-time task execution without relying on provisioners. Caution should be taken to ensure the data source is only executed once, or that the resulting tasks can safely run in parallel.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ecs.get_task_execution(cluster=example_aws_ecs_cluster["id"],
        task_definition=example_aws_ecs_task_definition["arn"],
        desired_count=1,
        launch_type="FARGATE",
        network_configuration={
            "subnets": [__item["id"] for __item in example_aws_subnet],
            "security_groups": [example_aws_security_group["id"]],
            "assign_public_ip": False,
        })
    ```


    :param Sequence[Union['GetTaskExecutionCapacityProviderStrategyArgs', 'GetTaskExecutionCapacityProviderStrategyArgsDict']] capacity_provider_strategies: Set of capacity provider strategies to use for the cluster. See below.
    :param builtins.str client_token: An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 64 characters are allowed. The valid characters are characters in the range of 33-126, inclusive. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/ECS_Idempotency.html).
    :param builtins.str cluster: Short name or full Amazon Resource Name (ARN) of the cluster to run the task on.
    :param builtins.int desired_count: Number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.
    :param builtins.bool enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
    :param builtins.bool enable_execute_command: Specifies whether to enable Amazon ECS Exec for the tasks within the service.
    :param builtins.str group: Name of the task group to associate with the task. The default value is the family name of the task definition.
    :param builtins.str launch_type: Launch type on which to run your service. Valid values are `EC2`, `FARGATE`, and `EXTERNAL`.
    :param Union['GetTaskExecutionNetworkConfigurationArgs', 'GetTaskExecutionNetworkConfigurationArgsDict'] network_configuration: Network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. See below.
    :param Union['GetTaskExecutionOverridesArgs', 'GetTaskExecutionOverridesArgsDict'] overrides: A list of container overrides that specify the name of a container in the specified task definition and the overrides it should receive.
    :param Sequence[Union['GetTaskExecutionPlacementConstraintArgs', 'GetTaskExecutionPlacementConstraintArgsDict']] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task. See below.
    :param Sequence[Union['GetTaskExecutionPlacementStrategyArgs', 'GetTaskExecutionPlacementStrategyArgsDict']] placement_strategies: The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task. See below.
    :param builtins.str platform_version: The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the `LATEST` platform version is used.
    :param builtins.str propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. An error will be received if you specify the `SERVICE` option when running a task. Valid values are `TASK_DEFINITION` or `NONE`.
    :param builtins.str reference_id: The reference ID to use for the task.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str started_by: An optional tag specified when a task is started.
    :param Mapping[str, builtins.str] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
    :param builtins.str task_definition: The `family` and `revision` (`family:revision`) or full ARN of the task definition to run. If a revision isn't specified, the latest `ACTIVE` revision is used.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['capacityProviderStrategies'] = capacity_provider_strategies
    __args__['clientToken'] = client_token
    __args__['cluster'] = cluster
    __args__['desiredCount'] = desired_count
    __args__['enableEcsManagedTags'] = enable_ecs_managed_tags
    __args__['enableExecuteCommand'] = enable_execute_command
    __args__['group'] = group
    __args__['launchType'] = launch_type
    __args__['networkConfiguration'] = network_configuration
    __args__['overrides'] = overrides
    __args__['placementConstraints'] = placement_constraints
    __args__['placementStrategies'] = placement_strategies
    __args__['platformVersion'] = platform_version
    __args__['propagateTags'] = propagate_tags
    __args__['referenceId'] = reference_id
    __args__['region'] = region
    __args__['startedBy'] = started_by
    __args__['tags'] = tags
    __args__['taskDefinition'] = task_definition
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ecs/getTaskExecution:getTaskExecution', __args__, opts=opts, typ=GetTaskExecutionResult)
    return __ret__.apply(lambda __response__: GetTaskExecutionResult(
        capacity_provider_strategies=pulumi.get(__response__, 'capacity_provider_strategies'),
        client_token=pulumi.get(__response__, 'client_token'),
        cluster=pulumi.get(__response__, 'cluster'),
        desired_count=pulumi.get(__response__, 'desired_count'),
        enable_ecs_managed_tags=pulumi.get(__response__, 'enable_ecs_managed_tags'),
        enable_execute_command=pulumi.get(__response__, 'enable_execute_command'),
        group=pulumi.get(__response__, 'group'),
        id=pulumi.get(__response__, 'id'),
        launch_type=pulumi.get(__response__, 'launch_type'),
        network_configuration=pulumi.get(__response__, 'network_configuration'),
        overrides=pulumi.get(__response__, 'overrides'),
        placement_constraints=pulumi.get(__response__, 'placement_constraints'),
        placement_strategies=pulumi.get(__response__, 'placement_strategies'),
        platform_version=pulumi.get(__response__, 'platform_version'),
        propagate_tags=pulumi.get(__response__, 'propagate_tags'),
        reference_id=pulumi.get(__response__, 'reference_id'),
        region=pulumi.get(__response__, 'region'),
        started_by=pulumi.get(__response__, 'started_by'),
        tags=pulumi.get(__response__, 'tags'),
        task_arns=pulumi.get(__response__, 'task_arns'),
        task_definition=pulumi.get(__response__, 'task_definition')))
