# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CapacityProviderAutoScalingGroupProvider',
    'CapacityProviderAutoScalingGroupProviderManagedScaling',
    'ClusterCapacityProvidersDefaultCapacityProviderStrategy',
    'ClusterConfiguration',
    'ClusterConfigurationExecuteCommandConfiguration',
    'ClusterConfigurationExecuteCommandConfigurationLogConfiguration',
    'ClusterConfigurationManagedStorageConfiguration',
    'ClusterServiceConnectDefaults',
    'ClusterSetting',
    'ServiceAlarms',
    'ServiceCapacityProviderStrategy',
    'ServiceDeploymentCircuitBreaker',
    'ServiceDeploymentController',
    'ServiceLoadBalancer',
    'ServiceNetworkConfiguration',
    'ServiceOrderedPlacementStrategy',
    'ServicePlacementConstraint',
    'ServiceServiceConnectConfiguration',
    'ServiceServiceConnectConfigurationLogConfiguration',
    'ServiceServiceConnectConfigurationLogConfigurationSecretOption',
    'ServiceServiceConnectConfigurationService',
    'ServiceServiceConnectConfigurationServiceClientAlias',
    'ServiceServiceConnectConfigurationServiceTimeout',
    'ServiceServiceConnectConfigurationServiceTls',
    'ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority',
    'ServiceServiceRegistries',
    'ServiceVolumeConfiguration',
    'ServiceVolumeConfigurationManagedEbsVolume',
    'ServiceVolumeConfigurationManagedEbsVolumeTagSpecification',
    'ServiceVpcLatticeConfiguration',
    'TaskDefinitionEphemeralStorage',
    'TaskDefinitionPlacementConstraint',
    'TaskDefinitionProxyConfiguration',
    'TaskDefinitionRuntimePlatform',
    'TaskDefinitionVolume',
    'TaskDefinitionVolumeDockerVolumeConfiguration',
    'TaskDefinitionVolumeEfsVolumeConfiguration',
    'TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig',
    'TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration',
    'TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig',
    'TaskSetCapacityProviderStrategy',
    'TaskSetLoadBalancer',
    'TaskSetNetworkConfiguration',
    'TaskSetScale',
    'TaskSetServiceRegistries',
    'GetClusterServiceConnectDefaultResult',
    'GetClusterSettingResult',
    'GetTaskDefinitionEphemeralStorageResult',
    'GetTaskDefinitionPlacementConstraintResult',
    'GetTaskDefinitionProxyConfigurationResult',
    'GetTaskDefinitionRuntimePlatformResult',
    'GetTaskDefinitionVolumeResult',
    'GetTaskDefinitionVolumeDockerVolumeConfigurationResult',
    'GetTaskDefinitionVolumeEfsVolumeConfigurationResult',
    'GetTaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigResult',
    'GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationResult',
    'GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigResult',
    'GetTaskExecutionCapacityProviderStrategyResult',
    'GetTaskExecutionNetworkConfigurationResult',
    'GetTaskExecutionOverridesResult',
    'GetTaskExecutionOverridesContainerOverrideResult',
    'GetTaskExecutionOverridesContainerOverrideEnvironmentResult',
    'GetTaskExecutionOverridesContainerOverrideResourceRequirementResult',
    'GetTaskExecutionPlacementConstraintResult',
    'GetTaskExecutionPlacementStrategyResult',
]

@pulumi.output_type
class CapacityProviderAutoScalingGroupProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScalingGroupArn":
            suggest = "auto_scaling_group_arn"
        elif key == "managedDraining":
            suggest = "managed_draining"
        elif key == "managedScaling":
            suggest = "managed_scaling"
        elif key == "managedTerminationProtection":
            suggest = "managed_termination_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityProviderAutoScalingGroupProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityProviderAutoScalingGroupProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityProviderAutoScalingGroupProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scaling_group_arn: builtins.str,
                 managed_draining: Optional[builtins.str] = None,
                 managed_scaling: Optional['outputs.CapacityProviderAutoScalingGroupProviderManagedScaling'] = None,
                 managed_termination_protection: Optional[builtins.str] = None):
        """
        :param builtins.str auto_scaling_group_arn: ARN of the associated auto scaling group.
        :param builtins.str managed_draining: Enables or disables a graceful shutdown of instances without disturbing workloads. Valid values are `ENABLED` and `DISABLED`. The default value is `ENABLED` when a capacity provider is created.
        :param 'CapacityProviderAutoScalingGroupProviderManagedScalingArgs' managed_scaling: Configuration block defining the parameters of the auto scaling. Detailed below.
        :param builtins.str managed_termination_protection: Enables or disables container-aware termination of instances in the auto scaling group when scale-in happens. Valid values are `ENABLED` and `DISABLED`.
        """
        pulumi.set(__self__, "auto_scaling_group_arn", auto_scaling_group_arn)
        if managed_draining is not None:
            pulumi.set(__self__, "managed_draining", managed_draining)
        if managed_scaling is not None:
            pulumi.set(__self__, "managed_scaling", managed_scaling)
        if managed_termination_protection is not None:
            pulumi.set(__self__, "managed_termination_protection", managed_termination_protection)

    @property
    @pulumi.getter(name="autoScalingGroupArn")
    def auto_scaling_group_arn(self) -> builtins.str:
        """
        ARN of the associated auto scaling group.
        """
        return pulumi.get(self, "auto_scaling_group_arn")

    @property
    @pulumi.getter(name="managedDraining")
    def managed_draining(self) -> Optional[builtins.str]:
        """
        Enables or disables a graceful shutdown of instances without disturbing workloads. Valid values are `ENABLED` and `DISABLED`. The default value is `ENABLED` when a capacity provider is created.
        """
        return pulumi.get(self, "managed_draining")

    @property
    @pulumi.getter(name="managedScaling")
    def managed_scaling(self) -> Optional['outputs.CapacityProviderAutoScalingGroupProviderManagedScaling']:
        """
        Configuration block defining the parameters of the auto scaling. Detailed below.
        """
        return pulumi.get(self, "managed_scaling")

    @property
    @pulumi.getter(name="managedTerminationProtection")
    def managed_termination_protection(self) -> Optional[builtins.str]:
        """
        Enables or disables container-aware termination of instances in the auto scaling group when scale-in happens. Valid values are `ENABLED` and `DISABLED`.
        """
        return pulumi.get(self, "managed_termination_protection")


@pulumi.output_type
class CapacityProviderAutoScalingGroupProviderManagedScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceWarmupPeriod":
            suggest = "instance_warmup_period"
        elif key == "maximumScalingStepSize":
            suggest = "maximum_scaling_step_size"
        elif key == "minimumScalingStepSize":
            suggest = "minimum_scaling_step_size"
        elif key == "targetCapacity":
            suggest = "target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityProviderAutoScalingGroupProviderManagedScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityProviderAutoScalingGroupProviderManagedScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityProviderAutoScalingGroupProviderManagedScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_warmup_period: Optional[builtins.int] = None,
                 maximum_scaling_step_size: Optional[builtins.int] = None,
                 minimum_scaling_step_size: Optional[builtins.int] = None,
                 status: Optional[builtins.str] = None,
                 target_capacity: Optional[builtins.int] = None):
        """
        :param builtins.int instance_warmup_period: Period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of 300 seconds is used.
               
               For more information on how the instance warmup period contributes to managed scale-out behavior, see [Control the instances Amazon ECS terminates](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/managed-termination-protection.html) in the _Amazon Elastic Container Service Developer Guide_.
        :param builtins.int maximum_scaling_step_size: Maximum step adjustment size. A number between 1 and 10,000.
        :param builtins.int minimum_scaling_step_size: Minimum step adjustment size. A number between 1 and 10,000.
        :param builtins.str status: Whether auto scaling is managed by ECS. Valid values are `ENABLED` and `DISABLED`.
        :param builtins.int target_capacity: Target utilization for the capacity provider. A number between 1 and 100.
        """
        if instance_warmup_period is not None:
            pulumi.set(__self__, "instance_warmup_period", instance_warmup_period)
        if maximum_scaling_step_size is not None:
            pulumi.set(__self__, "maximum_scaling_step_size", maximum_scaling_step_size)
        if minimum_scaling_step_size is not None:
            pulumi.set(__self__, "minimum_scaling_step_size", minimum_scaling_step_size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @property
    @pulumi.getter(name="instanceWarmupPeriod")
    def instance_warmup_period(self) -> Optional[builtins.int]:
        """
        Period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of 300 seconds is used.

        For more information on how the instance warmup period contributes to managed scale-out behavior, see [Control the instances Amazon ECS terminates](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/managed-termination-protection.html) in the _Amazon Elastic Container Service Developer Guide_.
        """
        return pulumi.get(self, "instance_warmup_period")

    @property
    @pulumi.getter(name="maximumScalingStepSize")
    def maximum_scaling_step_size(self) -> Optional[builtins.int]:
        """
        Maximum step adjustment size. A number between 1 and 10,000.
        """
        return pulumi.get(self, "maximum_scaling_step_size")

    @property
    @pulumi.getter(name="minimumScalingStepSize")
    def minimum_scaling_step_size(self) -> Optional[builtins.int]:
        """
        Minimum step adjustment size. A number between 1 and 10,000.
        """
        return pulumi.get(self, "minimum_scaling_step_size")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Whether auto scaling is managed by ECS. Valid values are `ENABLED` and `DISABLED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[builtins.int]:
        """
        Target utilization for the capacity provider. A number between 1 and 100.
        """
        return pulumi.get(self, "target_capacity")


@pulumi.output_type
class ClusterCapacityProvidersDefaultCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCapacityProvidersDefaultCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCapacityProvidersDefaultCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCapacityProvidersDefaultCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 base: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str capacity_provider: Name of the capacity provider.
        :param builtins.int base: The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
        :param builtins.int weight: The relative percentage of the total number of launched tasks that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` count of tasks has been satisfied. Defaults to `0`.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        """
        Name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The relative percentage of the total number of launched tasks that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` count of tasks has been satisfied. Defaults to `0`.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ClusterConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeCommandConfiguration":
            suggest = "execute_command_configuration"
        elif key == "managedStorageConfiguration":
            suggest = "managed_storage_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_command_configuration: Optional['outputs.ClusterConfigurationExecuteCommandConfiguration'] = None,
                 managed_storage_configuration: Optional['outputs.ClusterConfigurationManagedStorageConfiguration'] = None):
        """
        :param 'ClusterConfigurationExecuteCommandConfigurationArgs' execute_command_configuration: Details of the execute command configuration. See `execute_command_configuration` Block for details.
        :param 'ClusterConfigurationManagedStorageConfigurationArgs' managed_storage_configuration: Details of the managed storage configuration. See `managed_storage_configuration` Block for details.
        """
        if execute_command_configuration is not None:
            pulumi.set(__self__, "execute_command_configuration", execute_command_configuration)
        if managed_storage_configuration is not None:
            pulumi.set(__self__, "managed_storage_configuration", managed_storage_configuration)

    @property
    @pulumi.getter(name="executeCommandConfiguration")
    def execute_command_configuration(self) -> Optional['outputs.ClusterConfigurationExecuteCommandConfiguration']:
        """
        Details of the execute command configuration. See `execute_command_configuration` Block for details.
        """
        return pulumi.get(self, "execute_command_configuration")

    @property
    @pulumi.getter(name="managedStorageConfiguration")
    def managed_storage_configuration(self) -> Optional['outputs.ClusterConfigurationManagedStorageConfiguration']:
        """
        Details of the managed storage configuration. See `managed_storage_configuration` Block for details.
        """
        return pulumi.get(self, "managed_storage_configuration")


@pulumi.output_type
class ClusterConfigurationExecuteCommandConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "logConfiguration":
            suggest = "log_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfigurationExecuteCommandConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfigurationExecuteCommandConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfigurationExecuteCommandConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[builtins.str] = None,
                 log_configuration: Optional['outputs.ClusterConfigurationExecuteCommandConfigurationLogConfiguration'] = None,
                 logging: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key_id: AWS Key Management Service key ID to encrypt the data between the local client and the container.
        :param 'ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs' log_configuration: Log configuration for the results of the execute command actions. Required when `logging` is `OVERRIDE`. See `log_configuration` Block for details.
        :param builtins.str logging: Log setting to use for redirecting logs for your execute command results. Valid values: `NONE`, `DEFAULT`, `OVERRIDE`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        AWS Key Management Service key ID to encrypt the data between the local client and the container.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ClusterConfigurationExecuteCommandConfigurationLogConfiguration']:
        """
        Log configuration for the results of the execute command actions. Required when `logging` is `OVERRIDE`. See `log_configuration` Block for details.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def logging(self) -> Optional[builtins.str]:
        """
        Log setting to use for redirecting logs for your execute command results. Valid values: `NONE`, `DEFAULT`, `OVERRIDE`.
        """
        return pulumi.get(self, "logging")


@pulumi.output_type
class ClusterConfigurationExecuteCommandConfigurationLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchEncryptionEnabled":
            suggest = "cloud_watch_encryption_enabled"
        elif key == "cloudWatchLogGroupName":
            suggest = "cloud_watch_log_group_name"
        elif key == "s3BucketEncryptionEnabled":
            suggest = "s3_bucket_encryption_enabled"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfigurationExecuteCommandConfigurationLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfigurationExecuteCommandConfigurationLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfigurationExecuteCommandConfigurationLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_encryption_enabled: Optional[builtins.bool] = None,
                 cloud_watch_log_group_name: Optional[builtins.str] = None,
                 s3_bucket_encryption_enabled: Optional[builtins.bool] = None,
                 s3_bucket_name: Optional[builtins.str] = None,
                 s3_key_prefix: Optional[builtins.str] = None):
        """
        :param builtins.bool cloud_watch_encryption_enabled: Whether to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
        :param builtins.str cloud_watch_log_group_name: The name of the CloudWatch log group to send logs to.
        :param builtins.bool s3_bucket_encryption_enabled: Whether to enable encryption on the logs sent to S3. If not specified, encryption will be disabled.
        :param builtins.str s3_bucket_name: Name of the S3 bucket to send logs to.
        :param builtins.str s3_key_prefix: Optional folder in the S3 bucket to place logs in.
        """
        if cloud_watch_encryption_enabled is not None:
            pulumi.set(__self__, "cloud_watch_encryption_enabled", cloud_watch_encryption_enabled)
        if cloud_watch_log_group_name is not None:
            pulumi.set(__self__, "cloud_watch_log_group_name", cloud_watch_log_group_name)
        if s3_bucket_encryption_enabled is not None:
            pulumi.set(__self__, "s3_bucket_encryption_enabled", s3_bucket_encryption_enabled)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="cloudWatchEncryptionEnabled")
    def cloud_watch_encryption_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
        """
        return pulumi.get(self, "cloud_watch_encryption_enabled")

    @property
    @pulumi.getter(name="cloudWatchLogGroupName")
    def cloud_watch_log_group_name(self) -> Optional[builtins.str]:
        """
        The name of the CloudWatch log group to send logs to.
        """
        return pulumi.get(self, "cloud_watch_log_group_name")

    @property
    @pulumi.getter(name="s3BucketEncryptionEnabled")
    def s3_bucket_encryption_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable encryption on the logs sent to S3. If not specified, encryption will be disabled.
        """
        return pulumi.get(self, "s3_bucket_encryption_enabled")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[builtins.str]:
        """
        Name of the S3 bucket to send logs to.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[builtins.str]:
        """
        Optional folder in the S3 bucket to place logs in.
        """
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class ClusterConfigurationManagedStorageConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fargateEphemeralStorageKmsKeyId":
            suggest = "fargate_ephemeral_storage_kms_key_id"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfigurationManagedStorageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfigurationManagedStorageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfigurationManagedStorageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fargate_ephemeral_storage_kms_key_id: Optional[builtins.str] = None,
                 kms_key_id: Optional[builtins.str] = None):
        """
        :param builtins.str fargate_ephemeral_storage_kms_key_id: AWS Key Management Service key ID for the Fargate ephemeral storage.
        :param builtins.str kms_key_id: AWS Key Management Service key ID to encrypt the managed storage.
        """
        if fargate_ephemeral_storage_kms_key_id is not None:
            pulumi.set(__self__, "fargate_ephemeral_storage_kms_key_id", fargate_ephemeral_storage_kms_key_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="fargateEphemeralStorageKmsKeyId")
    def fargate_ephemeral_storage_kms_key_id(self) -> Optional[builtins.str]:
        """
        AWS Key Management Service key ID for the Fargate ephemeral storage.
        """
        return pulumi.get(self, "fargate_ephemeral_storage_kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        AWS Key Management Service key ID to encrypt the managed storage.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ClusterServiceConnectDefaults(dict):
    def __init__(__self__, *,
                 namespace: builtins.str):
        """
        :param builtins.str namespace: ARN of the `servicediscovery.HttpNamespace` that's used when you create a service and don't specify a Service Connect configuration.
        """
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        ARN of the `servicediscovery.HttpNamespace` that's used when you create a service and don't specify a Service Connect configuration.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ClusterSetting(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the setting to manage. Valid values: `containerInsights`.
        :param builtins.str value: Value to assign to the setting. Valid values: `enhanced`, `enabled`, `disabled`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the setting to manage. Valid values: `containerInsights`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value to assign to the setting. Valid values: `enhanced`, `enabled`, `disabled`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceAlarms(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmNames":
            suggest = "alarm_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAlarms. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAlarms.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAlarms.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_names: Sequence[builtins.str],
                 enable: builtins.bool,
                 rollback: builtins.bool):
        """
        :param Sequence[builtins.str] alarm_names: One or more CloudWatch alarm names.
        :param builtins.bool enable: Whether to use the CloudWatch alarm option in the service deployment process.
        :param builtins.bool rollback: Whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        pulumi.set(__self__, "alarm_names", alarm_names)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "rollback", rollback)

    @property
    @pulumi.getter(name="alarmNames")
    def alarm_names(self) -> Sequence[builtins.str]:
        """
        One or more CloudWatch alarm names.
        """
        return pulumi.get(self, "alarm_names")

    @property
    @pulumi.getter
    def enable(self) -> builtins.bool:
        """
        Whether to use the CloudWatch alarm option in the service deployment process.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def rollback(self) -> builtins.bool:
        """
        Whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        return pulumi.get(self, "rollback")


@pulumi.output_type
class ServiceCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 base: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str capacity_provider: Short name of the capacity provider.
        :param builtins.int base: Number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        :param builtins.int weight: Relative percentage of the total number of launched tasks that should use the specified capacity provider.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        """
        Short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        Number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Relative percentage of the total number of launched tasks that should use the specified capacity provider.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceDeploymentCircuitBreaker(dict):
    def __init__(__self__, *,
                 enable: builtins.bool,
                 rollback: builtins.bool):
        """
        :param builtins.bool enable: Whether to enable the deployment circuit breaker logic for the service.
        :param builtins.bool rollback: Whether to enable Amazon ECS to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "rollback", rollback)

    @property
    @pulumi.getter
    def enable(self) -> builtins.bool:
        """
        Whether to enable the deployment circuit breaker logic for the service.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def rollback(self) -> builtins.bool:
        """
        Whether to enable Amazon ECS to roll back the service if a service deployment fails. If rollback is enabled, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        return pulumi.get(self, "rollback")


@pulumi.output_type
class ServiceDeploymentController(dict):
    def __init__(__self__, *,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of deployment controller. Valid values: `CODE_DEPLOY`, `ECS`, `EXTERNAL`. Default: `ECS`.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Type of deployment controller. Valid values: `CODE_DEPLOY`, `ECS`, `EXTERNAL`. Default: `ECS`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "elbName":
            suggest = "elb_name"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: builtins.str,
                 container_port: builtins.int,
                 elb_name: Optional[builtins.str] = None,
                 target_group_arn: Optional[builtins.str] = None):
        """
        :param builtins.str container_name: Name of the container to associate with the load balancer (as it appears in a container definition).
        :param builtins.int container_port: Port on the container to associate with the load balancer.
               
               > **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
        :param builtins.str elb_name: Name of the ELB (Classic) to associate with the service.
        :param builtins.str target_group_arn: ARN of the Load Balancer target group to associate with the service.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "container_port", container_port)
        if elb_name is not None:
            pulumi.set(__self__, "elb_name", elb_name)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        Name of the container to associate with the load balancer (as it appears in a container definition).
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> builtins.int:
        """
        Port on the container to associate with the load balancer.

        > **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="elbName")
    def elb_name(self) -> Optional[builtins.str]:
        """
        Name of the ELB (Classic) to associate with the service.
        """
        return pulumi.get(self, "elb_name")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[builtins.str]:
        """
        ARN of the Load Balancer target group to associate with the service.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class ServiceNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[builtins.str],
                 assign_public_ip: Optional[builtins.bool] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] subnets: Subnets associated with the task or service.
        :param builtins.bool assign_public_ip: Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
               
               For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
        :param Sequence[builtins.str] security_groups: Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        Subnets associated with the task or service.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[builtins.bool]:
        """
        Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.

        For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class ServiceOrderedPlacementStrategy(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 field: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of placement strategy. Must be one of: `binpack`, `random`, or `spread`
        :param builtins.str field: For the `spread` placement strategy, valid values are `instanceId` (or `host`,
               which has the same effect), or any platform or custom attribute that is applied to a container instance.
               For the `binpack` type, valid values are `memory` and `cpu`. For the `random` type, this attribute is not
               needed. For more information, see [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html).
               
               > **Note:** for `spread`, `host` and `instanceId` will be normalized, by AWS, to be `instanceId`. This means the statefile will show `instanceId` but your config will differ if you use `host`.
        """
        pulumi.set(__self__, "type", type)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of placement strategy. Must be one of: `binpack`, `random`, or `spread`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def field(self) -> Optional[builtins.str]:
        """
        For the `spread` placement strategy, valid values are `instanceId` (or `host`,
        which has the same effect), or any platform or custom attribute that is applied to a container instance.
        For the `binpack` type, valid values are `memory` and `cpu`. For the `random` type, this attribute is not
        needed. For more information, see [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html).

        > **Note:** for `spread`, `host` and `instanceId` will be normalized, by AWS, to be `instanceId`. This means the statefile will show `instanceId` but your config will differ if you use `host`.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class ServicePlacementConstraint(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 expression: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
        :param builtins.str expression: Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class ServiceServiceConnectConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logConfiguration":
            suggest = "log_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceConnectConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceConnectConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceConnectConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 log_configuration: Optional['outputs.ServiceServiceConnectConfigurationLogConfiguration'] = None,
                 namespace: Optional[builtins.str] = None,
                 services: Optional[Sequence['outputs.ServiceServiceConnectConfigurationService']] = None):
        """
        :param builtins.bool enabled: Whether to use Service Connect with this service.
        :param 'ServiceServiceConnectConfigurationLogConfigurationArgs' log_configuration: Log configuration for the container. See below.
        :param builtins.str namespace: Namespace name or ARN of the `servicediscovery.HttpNamespace` for use with Service Connect.
        :param Sequence['ServiceServiceConnectConfigurationServiceArgs'] services: List of Service Connect service objects. See below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether to use Service Connect with this service.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ServiceServiceConnectConfigurationLogConfiguration']:
        """
        Log configuration for the container. See below.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        Namespace name or ARN of the `servicediscovery.HttpNamespace` for use with Service Connect.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.ServiceServiceConnectConfigurationService']]:
        """
        List of Service Connect service objects. See below.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class ServiceServiceConnectConfigurationLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDriver":
            suggest = "log_driver"
        elif key == "secretOptions":
            suggest = "secret_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceConnectConfigurationLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceConnectConfigurationLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceConnectConfigurationLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_driver: builtins.str,
                 options: Optional[Mapping[str, builtins.str]] = None,
                 secret_options: Optional[Sequence['outputs.ServiceServiceConnectConfigurationLogConfigurationSecretOption']] = None):
        """
        :param builtins.str log_driver: Log driver to use for the container.
        :param Mapping[str, builtins.str] options: Configuration options to send to the log driver.
        :param Sequence['ServiceServiceConnectConfigurationLogConfigurationSecretOptionArgs'] secret_options: Secrets to pass to the log configuration. See below.
        """
        pulumi.set(__self__, "log_driver", log_driver)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if secret_options is not None:
            pulumi.set(__self__, "secret_options", secret_options)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> builtins.str:
        """
        Log driver to use for the container.
        """
        return pulumi.get(self, "log_driver")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Configuration options to send to the log driver.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Optional[Sequence['outputs.ServiceServiceConnectConfigurationLogConfigurationSecretOption']]:
        """
        Secrets to pass to the log configuration. See below.
        """
        return pulumi.get(self, "secret_options")


@pulumi.output_type
class ServiceServiceConnectConfigurationLogConfigurationSecretOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceConnectConfigurationLogConfigurationSecretOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceConnectConfigurationLogConfigurationSecretOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceConnectConfigurationLogConfigurationSecretOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 value_from: builtins.str):
        """
        :param builtins.str name: Name of the secret.
        :param builtins.str value_from: Secret to expose to the container. The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> builtins.str:
        """
        Secret to expose to the container. The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class ServiceServiceConnectConfigurationService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "clientAlias":
            suggest = "client_alias"
        elif key == "discoveryName":
            suggest = "discovery_name"
        elif key == "ingressPortOverride":
            suggest = "ingress_port_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceConnectConfigurationService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceConnectConfigurationService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceConnectConfigurationService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port_name: builtins.str,
                 client_alias: Optional[Sequence['outputs.ServiceServiceConnectConfigurationServiceClientAlias']] = None,
                 discovery_name: Optional[builtins.str] = None,
                 ingress_port_override: Optional[builtins.int] = None,
                 timeout: Optional['outputs.ServiceServiceConnectConfigurationServiceTimeout'] = None,
                 tls: Optional['outputs.ServiceServiceConnectConfigurationServiceTls'] = None):
        """
        :param builtins.str port_name: Name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
        :param Sequence['ServiceServiceConnectConfigurationServiceClientAliasArgs'] client_alias: List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
        :param builtins.str discovery_name: Name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
        :param builtins.int ingress_port_override: Port number for the Service Connect proxy to listen on.
        :param 'ServiceServiceConnectConfigurationServiceTimeoutArgs' timeout: Configuration timeouts for Service Connect
        :param 'ServiceServiceConnectConfigurationServiceTlsArgs' tls: Configuration for enabling Transport Layer Security (TLS)
        """
        pulumi.set(__self__, "port_name", port_name)
        if client_alias is not None:
            pulumi.set(__self__, "client_alias", client_alias)
        if discovery_name is not None:
            pulumi.set(__self__, "discovery_name", discovery_name)
        if ingress_port_override is not None:
            pulumi.set(__self__, "ingress_port_override", ingress_port_override)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> builtins.str:
        """
        Name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="clientAlias")
    def client_alias(self) -> Optional[Sequence['outputs.ServiceServiceConnectConfigurationServiceClientAlias']]:
        """
        List of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1. See below.
        """
        return pulumi.get(self, "client_alias")

    @property
    @pulumi.getter(name="discoveryName")
    def discovery_name(self) -> Optional[builtins.str]:
        """
        Name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
        """
        return pulumi.get(self, "discovery_name")

    @property
    @pulumi.getter(name="ingressPortOverride")
    def ingress_port_override(self) -> Optional[builtins.int]:
        """
        Port number for the Service Connect proxy to listen on.
        """
        return pulumi.get(self, "ingress_port_override")

    @property
    @pulumi.getter
    def timeout(self) -> Optional['outputs.ServiceServiceConnectConfigurationServiceTimeout']:
        """
        Configuration timeouts for Service Connect
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def tls(self) -> Optional['outputs.ServiceServiceConnectConfigurationServiceTls']:
        """
        Configuration for enabling Transport Layer Security (TLS)
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class ServiceServiceConnectConfigurationServiceClientAlias(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceConnectConfigurationServiceClientAlias. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceConnectConfigurationServiceClientAlias.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceConnectConfigurationServiceClientAlias.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: builtins.int,
                 dns_name: Optional[builtins.str] = None):
        """
        :param builtins.int port: Listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
        :param builtins.str dns_name: Name that you use in the applications of client tasks to connect to this service.
        """
        pulumi.set(__self__, "port", port)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[builtins.str]:
        """
        Name that you use in the applications of client tasks to connect to this service.
        """
        return pulumi.get(self, "dns_name")


@pulumi.output_type
class ServiceServiceConnectConfigurationServiceTimeout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeoutSeconds":
            suggest = "idle_timeout_seconds"
        elif key == "perRequestTimeoutSeconds":
            suggest = "per_request_timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceConnectConfigurationServiceTimeout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceConnectConfigurationServiceTimeout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceConnectConfigurationServiceTimeout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_timeout_seconds: Optional[builtins.int] = None,
                 per_request_timeout_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int idle_timeout_seconds: Amount of time in seconds a connection will stay active while idle. A value of 0 can be set to disable idleTimeout.
        :param builtins.int per_request_timeout_seconds: Amount of time in seconds for the upstream to respond with a complete response per request. A value of 0 can be set to disable perRequestTimeout. Can only be set when appProtocol isn't TCP.
        """
        if idle_timeout_seconds is not None:
            pulumi.set(__self__, "idle_timeout_seconds", idle_timeout_seconds)
        if per_request_timeout_seconds is not None:
            pulumi.set(__self__, "per_request_timeout_seconds", per_request_timeout_seconds)

    @property
    @pulumi.getter(name="idleTimeoutSeconds")
    def idle_timeout_seconds(self) -> Optional[builtins.int]:
        """
        Amount of time in seconds a connection will stay active while idle. A value of 0 can be set to disable idleTimeout.
        """
        return pulumi.get(self, "idle_timeout_seconds")

    @property
    @pulumi.getter(name="perRequestTimeoutSeconds")
    def per_request_timeout_seconds(self) -> Optional[builtins.int]:
        """
        Amount of time in seconds for the upstream to respond with a complete response per request. A value of 0 can be set to disable perRequestTimeout. Can only be set when appProtocol isn't TCP.
        """
        return pulumi.get(self, "per_request_timeout_seconds")


@pulumi.output_type
class ServiceServiceConnectConfigurationServiceTls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerCertAuthority":
            suggest = "issuer_cert_authority"
        elif key == "kmsKey":
            suggest = "kms_key"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceConnectConfigurationServiceTls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceConnectConfigurationServiceTls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceConnectConfigurationServiceTls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer_cert_authority: 'outputs.ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority',
                 kms_key: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None):
        """
        :param 'ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthorityArgs' issuer_cert_authority: Details of the certificate authority which will issue the certificate.
        :param builtins.str kms_key: KMS key used to encrypt the private key in Secrets Manager.
        :param builtins.str role_arn: ARN of the IAM Role that's associated with the Service Connect TLS.
        """
        pulumi.set(__self__, "issuer_cert_authority", issuer_cert_authority)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="issuerCertAuthority")
    def issuer_cert_authority(self) -> 'outputs.ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority':
        """
        Details of the certificate authority which will issue the certificate.
        """
        return pulumi.get(self, "issuer_cert_authority")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[builtins.str]:
        """
        KMS key used to encrypt the private key in Secrets Manager.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        ARN of the IAM Role that's associated with the Service Connect TLS.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsPcaAuthorityArn":
            suggest = "aws_pca_authority_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceConnectConfigurationServiceTlsIssuerCertAuthority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_pca_authority_arn: builtins.str):
        """
        :param builtins.str aws_pca_authority_arn: ARN of the `acmpca.CertificateAuthority` used to create the TLS Certificates.
        """
        pulumi.set(__self__, "aws_pca_authority_arn", aws_pca_authority_arn)

    @property
    @pulumi.getter(name="awsPcaAuthorityArn")
    def aws_pca_authority_arn(self) -> builtins.str:
        """
        ARN of the `acmpca.CertificateAuthority` used to create the TLS Certificates.
        """
        return pulumi.get(self, "aws_pca_authority_arn")


@pulumi.output_type
class ServiceServiceRegistries(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryArn":
            suggest = "registry_arn"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceServiceRegistries. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceServiceRegistries.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceServiceRegistries.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_arn: builtins.str,
                 container_name: Optional[builtins.str] = None,
                 container_port: Optional[builtins.int] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str registry_arn: ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`servicediscovery.Service`). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html)
        :param builtins.str container_name: Container name value, already specified in the task definition, to be used for your service discovery service.
        :param builtins.int container_port: Port value, already specified in the task definition, to be used for your service discovery service.
        :param builtins.int port: Port value used if your Service Discovery service specified an SRV record.
        """
        pulumi.set(__self__, "registry_arn", registry_arn)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="registryArn")
    def registry_arn(self) -> builtins.str:
        """
        ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`servicediscovery.Service`). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html)
        """
        return pulumi.get(self, "registry_arn")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        Container name value, already specified in the task definition, to be used for your service discovery service.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        Port value, already specified in the task definition, to be used for your service discovery service.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Port value used if your Service Discovery service specified an SRV record.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedEbsVolume":
            suggest = "managed_ebs_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_ebs_volume: 'outputs.ServiceVolumeConfigurationManagedEbsVolume',
                 name: builtins.str):
        """
        :param 'ServiceVolumeConfigurationManagedEbsVolumeArgs' managed_ebs_volume: Configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. See below.
        :param builtins.str name: Name of the volume.
        """
        pulumi.set(__self__, "managed_ebs_volume", managed_ebs_volume)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="managedEbsVolume")
    def managed_ebs_volume(self) -> 'outputs.ServiceVolumeConfigurationManagedEbsVolume':
        """
        Configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. See below.
        """
        return pulumi.get(self, "managed_ebs_volume")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceVolumeConfigurationManagedEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "fileSystemType":
            suggest = "file_system_type"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "tagSpecifications":
            suggest = "tag_specifications"
        elif key == "volumeInitializationRate":
            suggest = "volume_initialization_rate"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVolumeConfigurationManagedEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVolumeConfigurationManagedEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVolumeConfigurationManagedEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 encrypted: Optional[builtins.bool] = None,
                 file_system_type: Optional[builtins.str] = None,
                 iops: Optional[builtins.int] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 size_in_gb: Optional[builtins.int] = None,
                 snapshot_id: Optional[builtins.str] = None,
                 tag_specifications: Optional[Sequence['outputs.ServiceVolumeConfigurationManagedEbsVolumeTagSpecification']] = None,
                 throughput: Optional[builtins.int] = None,
                 volume_initialization_rate: Optional[builtins.int] = None,
                 volume_type: Optional[builtins.str] = None):
        """
        :param builtins.str role_arn: Amazon ECS infrastructure IAM role that is used to manage your Amazon Web Services infrastructure. Recommended using the Amazon ECS-managed `AmazonECSInfrastructureRolePolicyForVolumes` IAM policy with this role.
        :param builtins.bool encrypted: Whether the volume should be encrypted. Default value is `true`.
        :param builtins.str file_system_type: Linux filesystem type for the volume. For volumes created from a snapshot, same filesystem type must be specified that the volume was using when the snapshot was created. Valid values are `ext3`, `ext4`, `xfs`. Default value is `xfs`.
        :param builtins.int iops: Number of I/O operations per second (IOPS).
        :param builtins.str kms_key_id: Amazon Resource Name (ARN) identifier of the Amazon Web Services Key Management Service key to use for Amazon EBS encryption.
        :param builtins.int size_in_gb: Size of the volume in GiB. You must specify either a `size_in_gb` or a `snapshot_id`. You can optionally specify a volume size greater than or equal to the snapshot size.
        :param builtins.str snapshot_id: Snapshot that Amazon ECS uses to create the volume. You must specify either a `size_in_gb` or a `snapshot_id`.
        :param Sequence['ServiceVolumeConfigurationManagedEbsVolumeTagSpecificationArgs'] tag_specifications: The tags to apply to the volume. See below.
        :param builtins.int throughput: Throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
        :param builtins.int volume_initialization_rate: Volume Initialization Rate in MiB/s. You must also specify a `snapshot_id`.
        :param builtins.str volume_type: Volume type.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tag_specifications is not None:
            pulumi.set(__self__, "tag_specifications", tag_specifications)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_initialization_rate is not None:
            pulumi.set(__self__, "volume_initialization_rate", volume_initialization_rate)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        Amazon ECS infrastructure IAM role that is used to manage your Amazon Web Services infrastructure. Recommended using the Amazon ECS-managed `AmazonECSInfrastructureRolePolicyForVolumes` IAM policy with this role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[builtins.bool]:
        """
        Whether the volume should be encrypted. Default value is `true`.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[builtins.str]:
        """
        Linux filesystem type for the volume. For volumes created from a snapshot, same filesystem type must be specified that the volume was using when the snapshot was created. Valid values are `ext3`, `ext4`, `xfs`. Default value is `xfs`.
        """
        return pulumi.get(self, "file_system_type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.int]:
        """
        Number of I/O operations per second (IOPS).
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) identifier of the Amazon Web Services Key Management Service key to use for Amazon EBS encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[builtins.int]:
        """
        Size of the volume in GiB. You must specify either a `size_in_gb` or a `snapshot_id`. You can optionally specify a volume size greater than or equal to the snapshot size.
        """
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[builtins.str]:
        """
        Snapshot that Amazon ECS uses to create the volume. You must specify either a `size_in_gb` or a `snapshot_id`.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="tagSpecifications")
    def tag_specifications(self) -> Optional[Sequence['outputs.ServiceVolumeConfigurationManagedEbsVolumeTagSpecification']]:
        """
        The tags to apply to the volume. See below.
        """
        return pulumi.get(self, "tag_specifications")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[builtins.int]:
        """
        Throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeInitializationRate")
    def volume_initialization_rate(self) -> Optional[builtins.int]:
        """
        Volume Initialization Rate in MiB/s. You must also specify a `snapshot_id`.
        """
        return pulumi.get(self, "volume_initialization_rate")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[builtins.str]:
        """
        Volume type.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ServiceVolumeConfigurationManagedEbsVolumeTagSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "propagateTags":
            suggest = "propagate_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVolumeConfigurationManagedEbsVolumeTagSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVolumeConfigurationManagedEbsVolumeTagSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVolumeConfigurationManagedEbsVolumeTagSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: builtins.str,
                 propagate_tags: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str resource_type: The type of volume resource. Valid values, `volume`.
        :param builtins.str propagate_tags: Determines whether to propagate the tags from the task definition to the Amazon EBS volume.
        :param Mapping[str, builtins.str] tags: The tags applied to this Amazon EBS volume. `AmazonECSCreated` and `AmazonECSManaged` are reserved tags that can't be used.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        The type of volume resource. Valid values, `volume`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[builtins.str]:
        """
        Determines whether to propagate the tags from the task definition to the Amazon EBS volume.
        """
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The tags applied to this Amazon EBS volume. `AmazonECSCreated` and `AmazonECSManaged` are reserved tags that can't be used.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ServiceVpcLatticeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVpcLatticeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVpcLatticeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVpcLatticeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port_name: builtins.str,
                 role_arn: builtins.str,
                 target_group_arn: builtins.str):
        """
        :param builtins.str port_name: The name of the port for a target group associated with the VPC Lattice configuration.
        :param builtins.str role_arn: The ARN of the IAM role to associate with this volume. This is the Amazon ECS infrastructure IAM role that is used to manage your AWS infrastructure.
        :param builtins.str target_group_arn: The full ARN of the target group or groups associated with the VPC Lattice configuration.
        """
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> builtins.str:
        """
        The name of the port for a target group associated with the VPC Lattice configuration.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the IAM role to associate with this volume. This is the Amazon ECS infrastructure IAM role that is used to manage your AWS infrastructure.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> builtins.str:
        """
        The full ARN of the target group or groups associated with the VPC Lattice configuration.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class TaskDefinitionEphemeralStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGib":
            suggest = "size_in_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionEphemeralStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionEphemeralStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionEphemeralStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gib: builtins.int):
        """
        :param builtins.int size_in_gib: The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        pulumi.set(__self__, "size_in_gib", size_in_gib)

    @property
    @pulumi.getter(name="sizeInGib")
    def size_in_gib(self) -> builtins.int:
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        return pulumi.get(self, "size_in_gib")


@pulumi.output_type
class TaskDefinitionPlacementConstraint(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 expression: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of constraint. Use `memberOf` to restrict selection to a group of valid candidates. Note that `distinctInstance` is not supported in task definitions.
        :param builtins.str expression: Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of constraint. Use `memberOf` to restrict selection to a group of valid candidates. Note that `distinctInstance` is not supported in task definitions.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class TaskDefinitionProxyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionProxyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionProxyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionProxyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: builtins.str,
                 properties: Optional[Mapping[str, builtins.str]] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str container_name: Name of the container that will serve as the App Mesh proxy.
        :param Mapping[str, builtins.str] properties: Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
        :param builtins.str type: Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        pulumi.set(__self__, "container_name", container_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        Name of the container that will serve as the App Mesh proxy.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TaskDefinitionRuntimePlatform(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuArchitecture":
            suggest = "cpu_architecture"
        elif key == "operatingSystemFamily":
            suggest = "operating_system_family"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionRuntimePlatform. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionRuntimePlatform.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionRuntimePlatform.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_architecture: Optional[builtins.str] = None,
                 operating_system_family: Optional[builtins.str] = None):
        """
        :param builtins.str cpu_architecture: Must be set to either `X86_64` or `ARM64`; see [cpu architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
        :param builtins.str operating_system_family: If the `requires_compatibilities` is `FARGATE` this field is required; must be set to a valid option from the [operating system family in the runtime platform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) setting
        """
        if cpu_architecture is not None:
            pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        if operating_system_family is not None:
            pulumi.set(__self__, "operating_system_family", operating_system_family)

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> Optional[builtins.str]:
        """
        Must be set to either `X86_64` or `ARM64`; see [cpu architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter(name="operatingSystemFamily")
    def operating_system_family(self) -> Optional[builtins.str]:
        """
        If the `requires_compatibilities` is `FARGATE` this field is required; must be set to a valid option from the [operating system family in the runtime platform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) setting
        """
        return pulumi.get(self, "operating_system_family")


@pulumi.output_type
class TaskDefinitionVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configureAtLaunch":
            suggest = "configure_at_launch"
        elif key == "dockerVolumeConfiguration":
            suggest = "docker_volume_configuration"
        elif key == "efsVolumeConfiguration":
            suggest = "efs_volume_configuration"
        elif key == "fsxWindowsFileServerVolumeConfiguration":
            suggest = "fsx_windows_file_server_volume_configuration"
        elif key == "hostPath":
            suggest = "host_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 configure_at_launch: Optional[builtins.bool] = None,
                 docker_volume_configuration: Optional['outputs.TaskDefinitionVolumeDockerVolumeConfiguration'] = None,
                 efs_volume_configuration: Optional['outputs.TaskDefinitionVolumeEfsVolumeConfiguration'] = None,
                 fsx_windows_file_server_volume_configuration: Optional['outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration'] = None,
                 host_path: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the volume. This name is referenced in the `sourceVolume`
               parameter of container definition in the `mountPoints` section.
        :param builtins.bool configure_at_launch: Whether the volume should be configured at launch time. This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
        :param 'TaskDefinitionVolumeDockerVolumeConfigurationArgs' docker_volume_configuration: Configuration block to configure a docker volume. Detailed below.
        :param 'TaskDefinitionVolumeEfsVolumeConfigurationArgs' efs_volume_configuration: Configuration block for an EFS volume. Detailed below.
        :param 'TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs' fsx_windows_file_server_volume_configuration: Configuration block for an FSX Windows File Server volume. Detailed below.
        :param builtins.str host_path: Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
        """
        pulumi.set(__self__, "name", name)
        if configure_at_launch is not None:
            pulumi.set(__self__, "configure_at_launch", configure_at_launch)
        if docker_volume_configuration is not None:
            pulumi.set(__self__, "docker_volume_configuration", docker_volume_configuration)
        if efs_volume_configuration is not None:
            pulumi.set(__self__, "efs_volume_configuration", efs_volume_configuration)
        if fsx_windows_file_server_volume_configuration is not None:
            pulumi.set(__self__, "fsx_windows_file_server_volume_configuration", fsx_windows_file_server_volume_configuration)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the volume. This name is referenced in the `sourceVolume`
        parameter of container definition in the `mountPoints` section.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="configureAtLaunch")
    def configure_at_launch(self) -> Optional[builtins.bool]:
        """
        Whether the volume should be configured at launch time. This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
        """
        return pulumi.get(self, "configure_at_launch")

    @property
    @pulumi.getter(name="dockerVolumeConfiguration")
    def docker_volume_configuration(self) -> Optional['outputs.TaskDefinitionVolumeDockerVolumeConfiguration']:
        """
        Configuration block to configure a docker volume. Detailed below.
        """
        return pulumi.get(self, "docker_volume_configuration")

    @property
    @pulumi.getter(name="efsVolumeConfiguration")
    def efs_volume_configuration(self) -> Optional['outputs.TaskDefinitionVolumeEfsVolumeConfiguration']:
        """
        Configuration block for an EFS volume. Detailed below.
        """
        return pulumi.get(self, "efs_volume_configuration")

    @property
    @pulumi.getter(name="fsxWindowsFileServerVolumeConfiguration")
    def fsx_windows_file_server_volume_configuration(self) -> Optional['outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration']:
        """
        Configuration block for an FSX Windows File Server volume. Detailed below.
        """
        return pulumi.get(self, "fsx_windows_file_server_volume_configuration")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[builtins.str]:
        """
        Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
        """
        return pulumi.get(self, "host_path")


@pulumi.output_type
class TaskDefinitionVolumeDockerVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverOpts":
            suggest = "driver_opts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeDockerVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeDockerVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeDockerVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoprovision: Optional[builtins.bool] = None,
                 driver: Optional[builtins.str] = None,
                 driver_opts: Optional[Mapping[str, builtins.str]] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 scope: Optional[builtins.str] = None):
        """
        :param builtins.bool autoprovision: If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
        :param builtins.str driver: Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
        :param Mapping[str, builtins.str] driver_opts: Map of Docker driver specific options.
        :param Mapping[str, builtins.str] labels: Map of custom metadata to add to your Docker volume.
        :param builtins.str scope: Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
        """
        if autoprovision is not None:
            pulumi.set(__self__, "autoprovision", autoprovision)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if driver_opts is not None:
            pulumi.set(__self__, "driver_opts", driver_opts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def autoprovision(self) -> Optional[builtins.bool]:
        """
        If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
        """
        return pulumi.get(self, "autoprovision")

    @property
    @pulumi.getter
    def driver(self) -> Optional[builtins.str]:
        """
        Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="driverOpts")
    def driver_opts(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Map of Docker driver specific options.
        """
        return pulumi.get(self, "driver_opts")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Map of custom metadata to add to your Docker volume.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class TaskDefinitionVolumeEfsVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "authorizationConfig":
            suggest = "authorization_config"
        elif key == "rootDirectory":
            suggest = "root_directory"
        elif key == "transitEncryption":
            suggest = "transit_encryption"
        elif key == "transitEncryptionPort":
            suggest = "transit_encryption_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeEfsVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeEfsVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeEfsVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: builtins.str,
                 authorization_config: Optional['outputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig'] = None,
                 root_directory: Optional[builtins.str] = None,
                 transit_encryption: Optional[builtins.str] = None,
                 transit_encryption_port: Optional[builtins.int] = None):
        """
        :param builtins.str file_system_id: ID of the EFS File System.
        :param 'TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs' authorization_config: Configuration block for authorization for the Amazon EFS file system. Detailed below.
        :param builtins.str root_directory: Directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying / will have the same effect as omitting this parameter. This argument is ignored when using `authorization_config`.
        :param builtins.str transit_encryption: Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        :param builtins.int transit_encryption_port: Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)
        if transit_encryption is not None:
            pulumi.set(__self__, "transit_encryption", transit_encryption)
        if transit_encryption_port is not None:
            pulumi.set(__self__, "transit_encryption_port", transit_encryption_port)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        ID of the EFS File System.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig']:
        """
        Configuration block for authorization for the Amazon EFS file system. Detailed below.
        """
        return pulumi.get(self, "authorization_config")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[builtins.str]:
        """
        Directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying / will have the same effect as omitting this parameter. This argument is ignored when using `authorization_config`.
        """
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="transitEncryption")
    def transit_encryption(self) -> Optional[builtins.str]:
        """
        Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        return pulumi.get(self, "transit_encryption")

    @property
    @pulumi.getter(name="transitEncryptionPort")
    def transit_encryption_port(self) -> Optional[builtins.int]:
        """
        Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
        """
        return pulumi.get(self, "transit_encryption_port")


@pulumi.output_type
class TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPointId":
            suggest = "access_point_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_point_id: Optional[builtins.str] = None,
                 iam: Optional[builtins.str] = None):
        """
        :param builtins.str access_point_id: Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
        :param builtins.str iam: Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[builtins.str]:
        """
        Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter
    def iam(self) -> Optional[builtins.str]:
        """
        Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationConfig":
            suggest = "authorization_config"
        elif key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_config: 'outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig',
                 file_system_id: builtins.str,
                 root_directory: builtins.str):
        """
        :param 'TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs' authorization_config: Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        :param builtins.str file_system_id: The Amazon FSx for Windows File Server file system ID to use.
        :param builtins.str root_directory: The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        pulumi.set(__self__, "authorization_config", authorization_config)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> 'outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig':
        """
        Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        """
        return pulumi.get(self, "authorization_config")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The Amazon FSx for Windows File Server file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> builtins.str:
        """
        The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsParameter":
            suggest = "credentials_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_parameter: builtins.str,
                 domain: builtins.str):
        """
        :param builtins.str credentials_parameter: The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
        :param builtins.str domain: A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
        """
        pulumi.set(__self__, "credentials_parameter", credentials_parameter)
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> builtins.str:
        """
        The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
        """
        return pulumi.get(self, "credentials_parameter")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class TaskSetCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 weight: builtins.int,
                 base: Optional[builtins.int] = None):
        """
        :param builtins.str capacity_provider: The short name or full Amazon Resource Name (ARN) of the capacity provider.
        :param builtins.int weight: The relative percentage of the total number of launched tasks that should use the specified capacity provider.
        :param builtins.int base: The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        pulumi.set(__self__, "weight", weight)
        if base is not None:
            pulumi.set(__self__, "base", base)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        """
        The short name or full Amazon Resource Name (ARN) of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def weight(self) -> builtins.int:
        """
        The relative percentage of the total number of launched tasks that should use the specified capacity provider.
        """
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        """
        return pulumi.get(self, "base")


@pulumi.output_type
class TaskSetLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "loadBalancerName":
            suggest = "load_balancer_name"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: builtins.str,
                 container_port: Optional[builtins.int] = None,
                 load_balancer_name: Optional[builtins.str] = None,
                 target_group_arn: Optional[builtins.str] = None):
        """
        :param builtins.str container_name: The name of the container to associate with the load balancer (as it appears in a container definition).
        :param builtins.int container_port: The port on the container to associate with the load balancer. Defaults to `0` if not specified.
               
               > **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
        :param builtins.str load_balancer_name: The name of the ELB (Classic) to associate with the service.
        :param builtins.str target_group_arn: The ARN of the Load Balancer target group to associate with the service.
        """
        pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        The name of the container to associate with the load balancer (as it appears in a container definition).
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port on the container to associate with the load balancer. Defaults to `0` if not specified.

        > **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[builtins.str]:
        """
        The name of the ELB (Classic) to associate with the service.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the Load Balancer target group to associate with the service.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class TaskSetNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[builtins.str],
                 assign_public_ip: Optional[builtins.bool] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] subnets: The subnets associated with the task or service. Maximum of 16.
        :param builtins.bool assign_public_ip: Whether to assign a public IP address to the ENI (`FARGATE` launch type only). Valid values are `true` or `false`. Default `false`.
               
               For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html).
        :param Sequence[builtins.str] security_groups: The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. Maximum of 5.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        The subnets associated with the task or service. Maximum of 16.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[builtins.bool]:
        """
        Whether to assign a public IP address to the ENI (`FARGATE` launch type only). Valid values are `true` or `false`. Default `false`.

        For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html).
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. Maximum of 5.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class TaskSetScale(dict):
    def __init__(__self__, *,
                 unit: Optional[builtins.str] = None,
                 value: Optional[builtins.float] = None):
        """
        :param builtins.str unit: The unit of measure for the scale value. Default: `PERCENT`.
        :param builtins.float value: The value, specified as a percent total of a service's `desiredCount`, to scale the task set. Defaults to `0` if not specified. Accepted values are numbers between 0.0 and 100.0.
        """
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[builtins.str]:
        """
        The unit of measure for the scale value. Default: `PERCENT`.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.float]:
        """
        The value, specified as a percent total of a service's `desiredCount`, to scale the task set. Defaults to `0` if not specified. Accepted values are numbers between 0.0 and 100.0.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskSetServiceRegistries(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryArn":
            suggest = "registry_arn"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetServiceRegistries. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetServiceRegistries.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetServiceRegistries.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_arn: builtins.str,
                 container_name: Optional[builtins.str] = None,
                 container_port: Optional[builtins.int] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str registry_arn: The ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`servicediscovery.Service` resource). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html).
        :param builtins.str container_name: The container name value, already specified in the task definition, to be used for your service discovery service.
        :param builtins.int container_port: The port value, already specified in the task definition, to be used for your service discovery service.
        :param builtins.int port: The port value used if your Service Discovery service specified an SRV record.
        """
        pulumi.set(__self__, "registry_arn", registry_arn)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="registryArn")
    def registry_arn(self) -> builtins.str:
        """
        The ARN of the Service Registry. The currently supported service registry is Amazon Route 53 Auto Naming Service(`servicediscovery.Service` resource). For more information, see [Service](https://docs.aws.amazon.com/Route53/latest/APIReference/API_autonaming_Service.html).
        """
        return pulumi.get(self, "registry_arn")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The container name value, already specified in the task definition, to be used for your service discovery service.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port value, already specified in the task definition, to be used for your service discovery service.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port value used if your Service Discovery service specified an SRV record.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetClusterServiceConnectDefaultResult(dict):
    def __init__(__self__, *,
                 namespace: builtins.str):
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetClusterSettingResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetTaskDefinitionEphemeralStorageResult(dict):
    def __init__(__self__, *,
                 size_in_gib: builtins.int):
        """
        :param builtins.int size_in_gib: The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        pulumi.set(__self__, "size_in_gib", size_in_gib)

    @property
    @pulumi.getter(name="sizeInGib")
    def size_in_gib(self) -> builtins.int:
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `21` GiB and the maximum supported value is `200` GiB.
        """
        return pulumi.get(self, "size_in_gib")


@pulumi.output_type
class GetTaskDefinitionPlacementConstraintResult(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str expression: Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        :param builtins.str type: Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Cluster Query Language expression to apply to the constraint. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTaskDefinitionProxyConfigurationResult(dict):
    def __init__(__self__, *,
                 container_name: builtins.str,
                 properties: Mapping[str, builtins.str],
                 type: builtins.str):
        """
        :param builtins.str container_name: Name of the container that will serve as the App Mesh proxy.
        :param Mapping[str, builtins.str] properties: Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
        :param builtins.str type: Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        Name of the container that will serve as the App Mesh proxy.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, builtins.str]:
        """
        Set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified a key-value mapping.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Proxy type. The default value is `APPMESH`. The only supported value is `APPMESH`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTaskDefinitionRuntimePlatformResult(dict):
    def __init__(__self__, *,
                 cpu_architecture: builtins.str,
                 operating_system_family: builtins.str):
        """
        :param builtins.str cpu_architecture: Must be set to either `X86_64` or `ARM64`; see [cpu architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
        :param builtins.str operating_system_family: If the `requires_compatibilities` is `FARGATE` this field is required; must be set to a valid option from the [operating system family in the runtime platform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) setting
        """
        pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        pulumi.set(__self__, "operating_system_family", operating_system_family)

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> builtins.str:
        """
        Must be set to either `X86_64` or `ARM64`; see [cpu architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform)
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter(name="operatingSystemFamily")
    def operating_system_family(self) -> builtins.str:
        """
        If the `requires_compatibilities` is `FARGATE` this field is required; must be set to a valid option from the [operating system family in the runtime platform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) setting
        """
        return pulumi.get(self, "operating_system_family")


@pulumi.output_type
class GetTaskDefinitionVolumeResult(dict):
    def __init__(__self__, *,
                 configure_at_launch: builtins.bool,
                 docker_volume_configurations: Sequence['outputs.GetTaskDefinitionVolumeDockerVolumeConfigurationResult'],
                 efs_volume_configurations: Sequence['outputs.GetTaskDefinitionVolumeEfsVolumeConfigurationResult'],
                 fsx_windows_file_server_volume_configurations: Sequence['outputs.GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationResult'],
                 host_path: builtins.str,
                 name: builtins.str):
        """
        :param builtins.bool configure_at_launch: Whether the volume should be configured at launch time. This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
        :param Sequence['GetTaskDefinitionVolumeDockerVolumeConfigurationArgs'] docker_volume_configurations: Configuration block to configure a docker volume. Detailed below.
        :param Sequence['GetTaskDefinitionVolumeEfsVolumeConfigurationArgs'] efs_volume_configurations: Configuration block for an EFS volume. Detailed below.
        :param Sequence['GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationArgs'] fsx_windows_file_server_volume_configurations: Configuration block for an FSX Windows File Server volume. Detailed below.
        :param builtins.str host_path: Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
        :param builtins.str name: Name of the volume. This name is referenced in the `sourceVolume`
               parameter of container definition in the `mountPoints` section.
        """
        pulumi.set(__self__, "configure_at_launch", configure_at_launch)
        pulumi.set(__self__, "docker_volume_configurations", docker_volume_configurations)
        pulumi.set(__self__, "efs_volume_configurations", efs_volume_configurations)
        pulumi.set(__self__, "fsx_windows_file_server_volume_configurations", fsx_windows_file_server_volume_configurations)
        pulumi.set(__self__, "host_path", host_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="configureAtLaunch")
    def configure_at_launch(self) -> builtins.bool:
        """
        Whether the volume should be configured at launch time. This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
        """
        return pulumi.get(self, "configure_at_launch")

    @property
    @pulumi.getter(name="dockerVolumeConfigurations")
    def docker_volume_configurations(self) -> Sequence['outputs.GetTaskDefinitionVolumeDockerVolumeConfigurationResult']:
        """
        Configuration block to configure a docker volume. Detailed below.
        """
        return pulumi.get(self, "docker_volume_configurations")

    @property
    @pulumi.getter(name="efsVolumeConfigurations")
    def efs_volume_configurations(self) -> Sequence['outputs.GetTaskDefinitionVolumeEfsVolumeConfigurationResult']:
        """
        Configuration block for an EFS volume. Detailed below.
        """
        return pulumi.get(self, "efs_volume_configurations")

    @property
    @pulumi.getter(name="fsxWindowsFileServerVolumeConfigurations")
    def fsx_windows_file_server_volume_configurations(self) -> Sequence['outputs.GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationResult']:
        """
        Configuration block for an FSX Windows File Server volume. Detailed below.
        """
        return pulumi.get(self, "fsx_windows_file_server_volume_configurations")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> builtins.str:
        """
        Path on the host container instance that is presented to the container. If not set, ECS will create a nonpersistent data volume that starts empty and is deleted after the task has finished.
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the volume. This name is referenced in the `sourceVolume`
        parameter of container definition in the `mountPoints` section.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetTaskDefinitionVolumeDockerVolumeConfigurationResult(dict):
    def __init__(__self__, *,
                 autoprovision: builtins.bool,
                 driver: builtins.str,
                 driver_opts: Mapping[str, builtins.str],
                 labels: Mapping[str, builtins.str],
                 scope: builtins.str):
        """
        :param builtins.bool autoprovision: If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
        :param builtins.str driver: Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
        :param Mapping[str, builtins.str] driver_opts: Map of Docker driver specific options.
        :param Mapping[str, builtins.str] labels: Map of custom metadata to add to your Docker volume.
        :param builtins.str scope: Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
        """
        pulumi.set(__self__, "autoprovision", autoprovision)
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "driver_opts", driver_opts)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def autoprovision(self) -> builtins.bool:
        """
        If this value is `true`, the Docker volume is created if it does not already exist. *Note*: This field is only used if the scope is `shared`.
        """
        return pulumi.get(self, "autoprovision")

    @property
    @pulumi.getter
    def driver(self) -> builtins.str:
        """
        Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="driverOpts")
    def driver_opts(self) -> Mapping[str, builtins.str]:
        """
        Map of Docker driver specific options.
        """
        return pulumi.get(self, "driver_opts")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        """
        Map of custom metadata to add to your Docker volume.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def scope(self) -> builtins.str:
        """
        Scope for the Docker volume, which determines its lifecycle, either `task` or `shared`.  Docker volumes that are scoped to a `task` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as `shared` persist after the task stops.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class GetTaskDefinitionVolumeEfsVolumeConfigurationResult(dict):
    def __init__(__self__, *,
                 authorization_configs: Sequence['outputs.GetTaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigResult'],
                 file_system_id: builtins.str,
                 root_directory: builtins.str,
                 transit_encryption: builtins.str,
                 transit_encryption_port: builtins.int):
        """
        :param Sequence['GetTaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigArgs'] authorization_configs: Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        :param builtins.str file_system_id: The Amazon FSx for Windows File Server file system ID to use.
        :param builtins.str root_directory: The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        :param builtins.str transit_encryption: Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        :param builtins.int transit_encryption_port: Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
        """
        pulumi.set(__self__, "authorization_configs", authorization_configs)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "root_directory", root_directory)
        pulumi.set(__self__, "transit_encryption", transit_encryption)
        pulumi.set(__self__, "transit_encryption_port", transit_encryption_port)

    @property
    @pulumi.getter(name="authorizationConfigs")
    def authorization_configs(self) -> Sequence['outputs.GetTaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigResult']:
        """
        Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        """
        return pulumi.get(self, "authorization_configs")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The Amazon FSx for Windows File Server file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> builtins.str:
        """
        The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="transitEncryption")
    def transit_encryption(self) -> builtins.str:
        """
        Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        return pulumi.get(self, "transit_encryption")

    @property
    @pulumi.getter(name="transitEncryptionPort")
    def transit_encryption_port(self) -> builtins.int:
        """
        Port to use for transit encryption. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses.
        """
        return pulumi.get(self, "transit_encryption_port")


@pulumi.output_type
class GetTaskDefinitionVolumeEfsVolumeConfigurationAuthorizationConfigResult(dict):
    def __init__(__self__, *,
                 access_point_id: builtins.str,
                 iam: builtins.str):
        """
        :param builtins.str access_point_id: Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
        :param builtins.str iam: Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> builtins.str:
        """
        Access point ID to use. If an access point is specified, the root directory value will be relative to the directory set for the access point. If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter
    def iam(self) -> builtins.str:
        """
        Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the EFSVolumeConfiguration. Valid values: `ENABLED`, `DISABLED`. If this parameter is omitted, the default value of `DISABLED` is used.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationResult(dict):
    def __init__(__self__, *,
                 authorization_configs: Sequence['outputs.GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigResult'],
                 file_system_id: builtins.str,
                 root_directory: builtins.str):
        """
        :param Sequence['GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigArgs'] authorization_configs: Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        :param builtins.str file_system_id: The Amazon FSx for Windows File Server file system ID to use.
        :param builtins.str root_directory: The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        pulumi.set(__self__, "authorization_configs", authorization_configs)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="authorizationConfigs")
    def authorization_configs(self) -> Sequence['outputs.GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigResult']:
        """
        Configuration block for authorization for the Amazon FSx for Windows File Server file system detailed below.
        """
        return pulumi.get(self, "authorization_configs")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The Amazon FSx for Windows File Server file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> builtins.str:
        """
        The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class GetTaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfigResult(dict):
    def __init__(__self__, *,
                 credentials_parameter: builtins.str,
                 domain: builtins.str):
        """
        :param builtins.str credentials_parameter: The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
        :param builtins.str domain: A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
        """
        pulumi.set(__self__, "credentials_parameter", credentials_parameter)
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> builtins.str:
        """
        The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
        """
        return pulumi.get(self, "credentials_parameter")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetTaskExecutionCapacityProviderStrategyResult(dict):
    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 base: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str capacity_provider: Name of the capacity provider.
        :param builtins.int base: The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
        :param builtins.int weight: The relative percentage of the total number of launched tasks that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` count of tasks has been satisfied. Defaults to `0`.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        """
        Name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The number of tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The relative percentage of the total number of launched tasks that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` count of tasks has been satisfied. Defaults to `0`.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetTaskExecutionNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 subnets: Sequence[builtins.str],
                 assign_public_ip: Optional[builtins.bool] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] subnets: Subnets associated with the task or service.
        :param builtins.bool assign_public_ip: Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.
               
               For more information, see the [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) documentation.
        :param Sequence[builtins.str] security_groups: Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        Subnets associated with the task or service.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[builtins.bool]:
        """
        Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Default `false`.

        For more information, see the [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) documentation.
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        Security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class GetTaskExecutionOverridesResult(dict):
    def __init__(__self__, *,
                 container_overrides: Optional[Sequence['outputs.GetTaskExecutionOverridesContainerOverrideResult']] = None,
                 cpu: Optional[builtins.str] = None,
                 execution_role_arn: Optional[builtins.str] = None,
                 memory: Optional[builtins.str] = None,
                 task_role_arn: Optional[builtins.str] = None):
        """
        :param Sequence['GetTaskExecutionOverridesContainerOverrideArgs'] container_overrides: One or more container overrides that are sent to a task. See below.
        :param builtins.str cpu: The CPU override for the task.
        :param builtins.str execution_role_arn: Amazon Resource Name (ARN) of the task execution role override for the task.
        :param builtins.str memory: The memory override for the task.
        :param builtins.str task_role_arn: Amazon Resource Name (ARN) of the role that containers in this task can assume.
        """
        if container_overrides is not None:
            pulumi.set(__self__, "container_overrides", container_overrides)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)

    @property
    @pulumi.getter(name="containerOverrides")
    def container_overrides(self) -> Optional[Sequence['outputs.GetTaskExecutionOverridesContainerOverrideResult']]:
        """
        One or more container overrides that are sent to a task. See below.
        """
        return pulumi.get(self, "container_overrides")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        The CPU override for the task.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of the task execution role override for the task.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        The memory override for the task.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of the role that containers in this task can assume.
        """
        return pulumi.get(self, "task_role_arn")


@pulumi.output_type
class GetTaskExecutionOverridesContainerOverrideResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 commands: Optional[Sequence[builtins.str]] = None,
                 cpu: Optional[builtins.int] = None,
                 environments: Optional[Sequence['outputs.GetTaskExecutionOverridesContainerOverrideEnvironmentResult']] = None,
                 memory: Optional[builtins.int] = None,
                 memory_reservation: Optional[builtins.int] = None,
                 resource_requirements: Optional[Sequence['outputs.GetTaskExecutionOverridesContainerOverrideResourceRequirementResult']] = None):
        """
        :param builtins.str name: The name of the container that receives the override. This parameter is required if any override is specified.
        :param Sequence[builtins.str] commands: The command to send to the container that overrides the default command from the Docker image or the task definition.
        :param builtins.int cpu: The number of cpu units reserved for the container, instead of the default value from the task definition.
        :param Sequence['GetTaskExecutionOverridesContainerOverrideEnvironmentArgs'] environments: The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. See below.
        :param builtins.int memory: The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed.
        :param builtins.int memory_reservation: The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition.
        :param Sequence['GetTaskExecutionOverridesContainerOverrideResourceRequirementArgs'] resource_requirements: The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. See below.
        """
        pulumi.set(__self__, "name", name)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the container that receives the override. This parameter is required if any override is specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[builtins.str]]:
        """
        The command to send to the container that overrides the default command from the Docker image or the task definition.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.int]:
        """
        The number of cpu units reserved for the container, instead of the default value from the task definition.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def environments(self) -> Optional[Sequence['outputs.GetTaskExecutionOverridesContainerOverrideEnvironmentResult']]:
        """
        The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. See below.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        """
        The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[builtins.int]:
        """
        The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition.
        """
        return pulumi.get(self, "memory_reservation")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.GetTaskExecutionOverridesContainerOverrideResourceRequirementResult']]:
        """
        The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. See below.
        """
        return pulumi.get(self, "resource_requirements")


@pulumi.output_type
class GetTaskExecutionOverridesContainerOverrideEnvironmentResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The name of the key-value pair. For environment variables, this is the name of the environment variable.
        :param builtins.str value: The value of the key-value pair. For environment variables, this is the value of the environment variable.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The name of the key-value pair. For environment variables, this is the name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the key-value pair. For environment variables, this is the value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetTaskExecutionOverridesContainerOverrideResourceRequirementResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str type: The type of resource to assign to a container. Valid values are `GPU`.
        :param builtins.str value: The value for the specified resource type. If the `GPU` type is used, the value is the number of physical GPUs the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of resource to assign to a container. Valid values are `GPU`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value for the specified resource type. If the `GPU` type is used, the value is the number of physical GPUs the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetTaskExecutionPlacementConstraintResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 expression: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of constraint. Valid values are `distinctInstance` or `memberOf`. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
        :param builtins.str expression: A cluster query language expression to apply to the constraint. The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is `distinctInstance`.
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of constraint. Valid values are `distinctInstance` or `memberOf`. Use `distinctInstance` to ensure that each task in a particular group is running on a different container instance. Use `memberOf` to restrict the selection to a group of valid candidates.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        A cluster query language expression to apply to the constraint. The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is `distinctInstance`.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class GetTaskExecutionPlacementStrategyResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 field: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of placement strategy. Valid values are `random`, `spread`, and `binpack`.
               
               For more information, see the [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html) documentation.
        :param builtins.str field: The field to apply the placement strategy against.
        """
        pulumi.set(__self__, "type", type)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of placement strategy. Valid values are `random`, `spread`, and `binpack`.

        For more information, see the [Placement Strategy](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PlacementStrategy.html) documentation.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def field(self) -> Optional[builtins.str]:
        """
        The field to apply the placement strategy against.
        """
        return pulumi.get(self, "field")


