# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccessPointPosixUserArgs',
    'AccessPointPosixUserArgsDict',
    'AccessPointRootDirectoryArgs',
    'AccessPointRootDirectoryArgsDict',
    'AccessPointRootDirectoryCreationInfoArgs',
    'AccessPointRootDirectoryCreationInfoArgsDict',
    'BackupPolicyBackupPolicyArgs',
    'BackupPolicyBackupPolicyArgsDict',
    'FileSystemLifecyclePolicyArgs',
    'FileSystemLifecyclePolicyArgsDict',
    'FileSystemProtectionArgs',
    'FileSystemProtectionArgsDict',
    'FileSystemSizeInByteArgs',
    'FileSystemSizeInByteArgsDict',
    'ReplicationConfigurationDestinationArgs',
    'ReplicationConfigurationDestinationArgsDict',
]

MYPY = False

if not MYPY:
    class AccessPointPosixUserArgsDict(TypedDict):
        gid: pulumi.Input[builtins.int]
        """
        POSIX group ID used for all file system operations using this access point.
        """
        uid: pulumi.Input[builtins.int]
        """
        POSIX user ID used for all file system operations using this access point.
        """
        secondary_gids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        Secondary POSIX group IDs used for all file system operations using this access point.
        """
elif False:
    AccessPointPosixUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPointPosixUserArgs:
    def __init__(__self__, *,
                 gid: pulumi.Input[builtins.int],
                 uid: pulumi.Input[builtins.int],
                 secondary_gids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None):
        """
        :param pulumi.Input[builtins.int] gid: POSIX group ID used for all file system operations using this access point.
        :param pulumi.Input[builtins.int] uid: POSIX user ID used for all file system operations using this access point.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] secondary_gids: Secondary POSIX group IDs used for all file system operations using this access point.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> pulumi.Input[builtins.int]:
        """
        POSIX group ID used for all file system operations using this access point.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[builtins.int]:
        """
        POSIX user ID used for all file system operations using this access point.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        Secondary POSIX group IDs used for all file system operations using this access point.
        """
        return pulumi.get(self, "secondary_gids")

    @secondary_gids.setter
    def secondary_gids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "secondary_gids", value)


if not MYPY:
    class AccessPointRootDirectoryArgsDict(TypedDict):
        creation_info: NotRequired[pulumi.Input['AccessPointRootDirectoryCreationInfoArgsDict']]
        """
        POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
        """
elif False:
    AccessPointRootDirectoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPointRootDirectoryArgs:
    def __init__(__self__, *,
                 creation_info: Optional[pulumi.Input['AccessPointRootDirectoryCreationInfoArgs']] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['AccessPointRootDirectoryCreationInfoArgs'] creation_info: POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
        :param pulumi.Input[builtins.str] path: Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
        """
        if creation_info is not None:
            pulumi.set(__self__, "creation_info", creation_info)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="creationInfo")
    def creation_info(self) -> Optional[pulumi.Input['AccessPointRootDirectoryCreationInfoArgs']]:
        """
        POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
        """
        return pulumi.get(self, "creation_info")

    @creation_info.setter
    def creation_info(self, value: Optional[pulumi.Input['AccessPointRootDirectoryCreationInfoArgs']]):
        pulumi.set(self, "creation_info", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class AccessPointRootDirectoryCreationInfoArgsDict(TypedDict):
        owner_gid: pulumi.Input[builtins.int]
        """
        POSIX group ID to apply to the `root_directory`.
        """
        owner_uid: pulumi.Input[builtins.int]
        """
        POSIX user ID to apply to the `root_directory`.
        """
        permissions: pulumi.Input[builtins.str]
        """
        POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
        """
elif False:
    AccessPointRootDirectoryCreationInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPointRootDirectoryCreationInfoArgs:
    def __init__(__self__, *,
                 owner_gid: pulumi.Input[builtins.int],
                 owner_uid: pulumi.Input[builtins.int],
                 permissions: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.int] owner_gid: POSIX group ID to apply to the `root_directory`.
        :param pulumi.Input[builtins.int] owner_uid: POSIX user ID to apply to the `root_directory`.
        :param pulumi.Input[builtins.str] permissions: POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
        """
        pulumi.set(__self__, "owner_gid", owner_gid)
        pulumi.set(__self__, "owner_uid", owner_uid)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="ownerGid")
    def owner_gid(self) -> pulumi.Input[builtins.int]:
        """
        POSIX group ID to apply to the `root_directory`.
        """
        return pulumi.get(self, "owner_gid")

    @owner_gid.setter
    def owner_gid(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "owner_gid", value)

    @property
    @pulumi.getter(name="ownerUid")
    def owner_uid(self) -> pulumi.Input[builtins.int]:
        """
        POSIX user ID to apply to the `root_directory`.
        """
        return pulumi.get(self, "owner_uid")

    @owner_uid.setter
    def owner_uid(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "owner_uid", value)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[builtins.str]:
        """
        POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permissions", value)


if not MYPY:
    class BackupPolicyBackupPolicyArgsDict(TypedDict):
        status: pulumi.Input[builtins.str]
        """
        A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
        """
elif False:
    BackupPolicyBackupPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupPolicyBackupPolicyArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] status: A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[builtins.str]:
        """
        A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status", value)


if not MYPY:
    class FileSystemLifecyclePolicyArgsDict(TypedDict):
        transition_to_archive: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        """
        transition_to_ia: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        """
        transition_to_primary_storage_class: NotRequired[pulumi.Input[builtins.str]]
        """
        Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
        """
elif False:
    FileSystemLifecyclePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FileSystemLifecyclePolicyArgs:
    def __init__(__self__, *,
                 transition_to_archive: Optional[pulumi.Input[builtins.str]] = None,
                 transition_to_ia: Optional[pulumi.Input[builtins.str]] = None,
                 transition_to_primary_storage_class: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] transition_to_archive: Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        :param pulumi.Input[builtins.str] transition_to_ia: Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        :param pulumi.Input[builtins.str] transition_to_primary_storage_class: Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
        """
        if transition_to_archive is not None:
            pulumi.set(__self__, "transition_to_archive", transition_to_archive)
        if transition_to_ia is not None:
            pulumi.set(__self__, "transition_to_ia", transition_to_ia)
        if transition_to_primary_storage_class is not None:
            pulumi.set(__self__, "transition_to_primary_storage_class", transition_to_primary_storage_class)

    @property
    @pulumi.getter(name="transitionToArchive")
    def transition_to_archive(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        """
        return pulumi.get(self, "transition_to_archive")

    @transition_to_archive.setter
    def transition_to_archive(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transition_to_archive", value)

    @property
    @pulumi.getter(name="transitionToIa")
    def transition_to_ia(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        """
        return pulumi.get(self, "transition_to_ia")

    @transition_to_ia.setter
    def transition_to_ia(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transition_to_ia", value)

    @property
    @pulumi.getter(name="transitionToPrimaryStorageClass")
    def transition_to_primary_storage_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
        """
        return pulumi.get(self, "transition_to_primary_storage_class")

    @transition_to_primary_storage_class.setter
    def transition_to_primary_storage_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transition_to_primary_storage_class", value)


if not MYPY:
    class FileSystemProtectionArgsDict(TypedDict):
        replication_overwrite: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates whether replication overwrite protection is enabled. Valid values: `ENABLED` or `DISABLED`.
        """
elif False:
    FileSystemProtectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FileSystemProtectionArgs:
    def __init__(__self__, *,
                 replication_overwrite: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] replication_overwrite: Indicates whether replication overwrite protection is enabled. Valid values: `ENABLED` or `DISABLED`.
        """
        if replication_overwrite is not None:
            pulumi.set(__self__, "replication_overwrite", replication_overwrite)

    @property
    @pulumi.getter(name="replicationOverwrite")
    def replication_overwrite(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether replication overwrite protection is enabled. Valid values: `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "replication_overwrite")

    @replication_overwrite.setter
    def replication_overwrite(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_overwrite", value)


if not MYPY:
    class FileSystemSizeInByteArgsDict(TypedDict):
        value: NotRequired[pulumi.Input[builtins.int]]
        """
        The latest known metered size (in bytes) of data stored in the file system.
        """
        value_in_ia: NotRequired[pulumi.Input[builtins.int]]
        """
        The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
        """
        value_in_standard: NotRequired[pulumi.Input[builtins.int]]
        """
        The latest known metered size (in bytes) of data stored in the Standard storage class.
        """
elif False:
    FileSystemSizeInByteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FileSystemSizeInByteArgs:
    def __init__(__self__, *,
                 value: Optional[pulumi.Input[builtins.int]] = None,
                 value_in_ia: Optional[pulumi.Input[builtins.int]] = None,
                 value_in_standard: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] value: The latest known metered size (in bytes) of data stored in the file system.
        :param pulumi.Input[builtins.int] value_in_ia: The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
        :param pulumi.Input[builtins.int] value_in_standard: The latest known metered size (in bytes) of data stored in the Standard storage class.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_in_ia is not None:
            pulumi.set(__self__, "value_in_ia", value_in_ia)
        if value_in_standard is not None:
            pulumi.set(__self__, "value_in_standard", value_in_standard)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The latest known metered size (in bytes) of data stored in the file system.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueInIa")
    def value_in_ia(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
        """
        return pulumi.get(self, "value_in_ia")

    @value_in_ia.setter
    def value_in_ia(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "value_in_ia", value)

    @property
    @pulumi.getter(name="valueInStandard")
    def value_in_standard(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The latest known metered size (in bytes) of data stored in the Standard storage class.
        """
        return pulumi.get(self, "value_in_standard")

    @value_in_standard.setter
    def value_in_standard(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "value_in_standard", value)


if not MYPY:
    class ReplicationConfigurationDestinationArgsDict(TypedDict):
        availability_zone_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
        """
        file_system_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the destination file system for the replication. If no ID is provided, then EFS creates a new file system with the default settings.
        """
        kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
        """
        region: NotRequired[pulumi.Input[builtins.str]]
        """
        The region in which the replica should be created.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ReplicationConfigurationDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationDestinationArgs:
    def __init__(__self__, *,
                 availability_zone_name: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] availability_zone_name: The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
        :param pulumi.Input[builtins.str] file_system_id: The ID of the destination file system for the replication. If no ID is provided, then EFS creates a new file system with the default settings.
        :param pulumi.Input[builtins.str] kms_key_id: The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
        :param pulumi.Input[builtins.str] region: The region in which the replica should be created.
        """
        if availability_zone_name is not None:
            pulumi.set(__self__, "availability_zone_name", availability_zone_name)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZoneName")
    def availability_zone_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
        """
        return pulumi.get(self, "availability_zone_name")

    @availability_zone_name.setter
    def availability_zone_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone_name", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the destination file system for the replication. If no ID is provided, then EFS creates a new file system with the default settings.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which the replica should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


