# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessPointPosixUser',
    'AccessPointRootDirectory',
    'AccessPointRootDirectoryCreationInfo',
    'BackupPolicyBackupPolicy',
    'FileSystemLifecyclePolicy',
    'FileSystemProtection',
    'FileSystemSizeInByte',
    'ReplicationConfigurationDestination',
    'GetAccessPointPosixUserResult',
    'GetAccessPointRootDirectoryResult',
    'GetAccessPointRootDirectoryCreationInfoResult',
    'GetFileSystemLifecyclePolicyResult',
    'GetFileSystemProtectionResult',
]

@pulumi.output_type
class AccessPointPosixUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secondaryGids":
            suggest = "secondary_gids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPosixUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPosixUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPosixUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: builtins.int,
                 uid: builtins.int,
                 secondary_gids: Optional[Sequence[builtins.int]] = None):
        """
        :param builtins.int gid: POSIX group ID used for all file system operations using this access point.
        :param builtins.int uid: POSIX user ID used for all file system operations using this access point.
        :param Sequence[builtins.int] secondary_gids: Secondary POSIX group IDs used for all file system operations using this access point.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> builtins.int:
        """
        POSIX group ID used for all file system operations using this access point.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def uid(self) -> builtins.int:
        """
        POSIX user ID used for all file system operations using this access point.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[Sequence[builtins.int]]:
        """
        Secondary POSIX group IDs used for all file system operations using this access point.
        """
        return pulumi.get(self, "secondary_gids")


@pulumi.output_type
class AccessPointRootDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationInfo":
            suggest = "creation_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointRootDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointRootDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointRootDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_info: Optional['outputs.AccessPointRootDirectoryCreationInfo'] = None,
                 path: Optional[builtins.str] = None):
        """
        :param 'AccessPointRootDirectoryCreationInfoArgs' creation_info: POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
        :param builtins.str path: Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
        """
        if creation_info is not None:
            pulumi.set(__self__, "creation_info", creation_info)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="creationInfo")
    def creation_info(self) -> Optional['outputs.AccessPointRootDirectoryCreationInfo']:
        """
        POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
        """
        return pulumi.get(self, "creation_info")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class AccessPointRootDirectoryCreationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ownerGid":
            suggest = "owner_gid"
        elif key == "ownerUid":
            suggest = "owner_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointRootDirectoryCreationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointRootDirectoryCreationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointRootDirectoryCreationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner_gid: builtins.int,
                 owner_uid: builtins.int,
                 permissions: builtins.str):
        """
        :param builtins.int owner_gid: POSIX group ID to apply to the `root_directory`.
        :param builtins.int owner_uid: POSIX user ID to apply to the `root_directory`.
        :param builtins.str permissions: POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
        """
        pulumi.set(__self__, "owner_gid", owner_gid)
        pulumi.set(__self__, "owner_uid", owner_uid)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="ownerGid")
    def owner_gid(self) -> builtins.int:
        """
        POSIX group ID to apply to the `root_directory`.
        """
        return pulumi.get(self, "owner_gid")

    @property
    @pulumi.getter(name="ownerUid")
    def owner_uid(self) -> builtins.int:
        """
        POSIX user ID to apply to the `root_directory`.
        """
        return pulumi.get(self, "owner_uid")

    @property
    @pulumi.getter
    def permissions(self) -> builtins.str:
        """
        POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class BackupPolicyBackupPolicy(dict):
    def __init__(__self__, *,
                 status: builtins.str):
        """
        :param builtins.str status: A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        A status of the backup policy. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class FileSystemLifecyclePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transitionToArchive":
            suggest = "transition_to_archive"
        elif key == "transitionToIa":
            suggest = "transition_to_ia"
        elif key == "transitionToPrimaryStorageClass":
            suggest = "transition_to_primary_storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemLifecyclePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemLifecyclePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemLifecyclePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transition_to_archive: Optional[builtins.str] = None,
                 transition_to_ia: Optional[builtins.str] = None,
                 transition_to_primary_storage_class: Optional[builtins.str] = None):
        """
        :param builtins.str transition_to_archive: Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        :param builtins.str transition_to_ia: Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        :param builtins.str transition_to_primary_storage_class: Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
        """
        if transition_to_archive is not None:
            pulumi.set(__self__, "transition_to_archive", transition_to_archive)
        if transition_to_ia is not None:
            pulumi.set(__self__, "transition_to_ia", transition_to_ia)
        if transition_to_primary_storage_class is not None:
            pulumi.set(__self__, "transition_to_primary_storage_class", transition_to_primary_storage_class)

    @property
    @pulumi.getter(name="transitionToArchive")
    def transition_to_archive(self) -> Optional[builtins.str]:
        """
        Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        """
        return pulumi.get(self, "transition_to_archive")

    @property
    @pulumi.getter(name="transitionToIa")
    def transition_to_ia(self) -> Optional[builtins.str]:
        """
        Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
        """
        return pulumi.get(self, "transition_to_ia")

    @property
    @pulumi.getter(name="transitionToPrimaryStorageClass")
    def transition_to_primary_storage_class(self) -> Optional[builtins.str]:
        """
        Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
        """
        return pulumi.get(self, "transition_to_primary_storage_class")


@pulumi.output_type
class FileSystemProtection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationOverwrite":
            suggest = "replication_overwrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemProtection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemProtection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemProtection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_overwrite: Optional[builtins.str] = None):
        """
        :param builtins.str replication_overwrite: Indicates whether replication overwrite protection is enabled. Valid values: `ENABLED` or `DISABLED`.
        """
        if replication_overwrite is not None:
            pulumi.set(__self__, "replication_overwrite", replication_overwrite)

    @property
    @pulumi.getter(name="replicationOverwrite")
    def replication_overwrite(self) -> Optional[builtins.str]:
        """
        Indicates whether replication overwrite protection is enabled. Valid values: `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "replication_overwrite")


@pulumi.output_type
class FileSystemSizeInByte(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueInIa":
            suggest = "value_in_ia"
        elif key == "valueInStandard":
            suggest = "value_in_standard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemSizeInByte. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemSizeInByte.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemSizeInByte.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: Optional[builtins.int] = None,
                 value_in_ia: Optional[builtins.int] = None,
                 value_in_standard: Optional[builtins.int] = None):
        """
        :param builtins.int value: The latest known metered size (in bytes) of data stored in the file system.
        :param builtins.int value_in_ia: The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
        :param builtins.int value_in_standard: The latest known metered size (in bytes) of data stored in the Standard storage class.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_in_ia is not None:
            pulumi.set(__self__, "value_in_ia", value_in_ia)
        if value_in_standard is not None:
            pulumi.set(__self__, "value_in_standard", value_in_standard)

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.int]:
        """
        The latest known metered size (in bytes) of data stored in the file system.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueInIa")
    def value_in_ia(self) -> Optional[builtins.int]:
        """
        The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
        """
        return pulumi.get(self, "value_in_ia")

    @property
    @pulumi.getter(name="valueInStandard")
    def value_in_standard(self) -> Optional[builtins.int]:
        """
        The latest known metered size (in bytes) of data stored in the Standard storage class.
        """
        return pulumi.get(self, "value_in_standard")


@pulumi.output_type
class ReplicationConfigurationDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZoneName":
            suggest = "availability_zone_name"
        elif key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone_name: Optional[builtins.str] = None,
                 file_system_id: Optional[builtins.str] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None):
        """
        :param builtins.str availability_zone_name: The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
        :param builtins.str file_system_id: The ID of the destination file system for the replication. If no ID is provided, then EFS creates a new file system with the default settings.
        :param builtins.str kms_key_id: The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
        :param builtins.str region: The region in which the replica should be created.
        """
        if availability_zone_name is not None:
            pulumi.set(__self__, "availability_zone_name", availability_zone_name)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZoneName")
    def availability_zone_name(self) -> Optional[builtins.str]:
        """
        The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
        """
        return pulumi.get(self, "availability_zone_name")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[builtins.str]:
        """
        The ID of the destination file system for the replication. If no ID is provided, then EFS creates a new file system with the default settings.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region in which the replica should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAccessPointPosixUserResult(dict):
    def __init__(__self__, *,
                 gid: builtins.int,
                 secondary_gids: Sequence[builtins.int],
                 uid: builtins.int):
        """
        :param builtins.int gid: Group ID
        :param Sequence[builtins.int] secondary_gids: Secondary group IDs
        :param builtins.int uid: User Id
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "secondary_gids", secondary_gids)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def gid(self) -> builtins.int:
        """
        Group ID
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Sequence[builtins.int]:
        """
        Secondary group IDs
        """
        return pulumi.get(self, "secondary_gids")

    @property
    @pulumi.getter
    def uid(self) -> builtins.int:
        """
        User Id
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetAccessPointRootDirectoryResult(dict):
    def __init__(__self__, *,
                 creation_infos: Sequence['outputs.GetAccessPointRootDirectoryCreationInfoResult'],
                 path: builtins.str):
        """
        :param Sequence['GetAccessPointRootDirectoryCreationInfoArgs'] creation_infos: Single element list containing information on the creation permissions of the directory
        :param builtins.str path: Path exposed as the root directory
        """
        pulumi.set(__self__, "creation_infos", creation_infos)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="creationInfos")
    def creation_infos(self) -> Sequence['outputs.GetAccessPointRootDirectoryCreationInfoResult']:
        """
        Single element list containing information on the creation permissions of the directory
        """
        return pulumi.get(self, "creation_infos")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path exposed as the root directory
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetAccessPointRootDirectoryCreationInfoResult(dict):
    def __init__(__self__, *,
                 owner_gid: builtins.int,
                 owner_uid: builtins.int,
                 permissions: builtins.str):
        """
        :param builtins.int owner_gid: POSIX owner group ID
        :param builtins.int owner_uid: POSIX owner user ID
        :param builtins.str permissions: POSIX permissions mode
        """
        pulumi.set(__self__, "owner_gid", owner_gid)
        pulumi.set(__self__, "owner_uid", owner_uid)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="ownerGid")
    def owner_gid(self) -> builtins.int:
        """
        POSIX owner group ID
        """
        return pulumi.get(self, "owner_gid")

    @property
    @pulumi.getter(name="ownerUid")
    def owner_uid(self) -> builtins.int:
        """
        POSIX owner user ID
        """
        return pulumi.get(self, "owner_uid")

    @property
    @pulumi.getter
    def permissions(self) -> builtins.str:
        """
        POSIX permissions mode
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetFileSystemLifecyclePolicyResult(dict):
    def __init__(__self__, *,
                 transition_to_archive: builtins.str,
                 transition_to_ia: builtins.str,
                 transition_to_primary_storage_class: builtins.str):
        pulumi.set(__self__, "transition_to_archive", transition_to_archive)
        pulumi.set(__self__, "transition_to_ia", transition_to_ia)
        pulumi.set(__self__, "transition_to_primary_storage_class", transition_to_primary_storage_class)

    @property
    @pulumi.getter(name="transitionToArchive")
    def transition_to_archive(self) -> builtins.str:
        return pulumi.get(self, "transition_to_archive")

    @property
    @pulumi.getter(name="transitionToIa")
    def transition_to_ia(self) -> builtins.str:
        return pulumi.get(self, "transition_to_ia")

    @property
    @pulumi.getter(name="transitionToPrimaryStorageClass")
    def transition_to_primary_storage_class(self) -> builtins.str:
        return pulumi.get(self, "transition_to_primary_storage_class")


@pulumi.output_type
class GetFileSystemProtectionResult(dict):
    def __init__(__self__, *,
                 replication_overwrite: builtins.str):
        pulumi.set(__self__, "replication_overwrite", replication_overwrite)

    @property
    @pulumi.getter(name="replicationOverwrite")
    def replication_overwrite(self) -> builtins.str:
        return pulumi.get(self, "replication_overwrite")


