# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccessPolicyAssociationAccessScopeArgs',
    'AccessPolicyAssociationAccessScopeArgsDict',
    'AddonPodIdentityAssociationArgs',
    'AddonPodIdentityAssociationArgsDict',
    'ClusterAccessConfigArgs',
    'ClusterAccessConfigArgsDict',
    'ClusterCertificateAuthorityArgs',
    'ClusterCertificateAuthorityArgsDict',
    'ClusterComputeConfigArgs',
    'ClusterComputeConfigArgsDict',
    'ClusterEncryptionConfigArgs',
    'ClusterEncryptionConfigArgsDict',
    'ClusterEncryptionConfigProviderArgs',
    'ClusterEncryptionConfigProviderArgsDict',
    'ClusterIdentityArgs',
    'ClusterIdentityArgsDict',
    'ClusterIdentityOidcArgs',
    'ClusterIdentityOidcArgsDict',
    'ClusterKubernetesNetworkConfigArgs',
    'ClusterKubernetesNetworkConfigArgsDict',
    'ClusterKubernetesNetworkConfigElasticLoadBalancingArgs',
    'ClusterKubernetesNetworkConfigElasticLoadBalancingArgsDict',
    'ClusterOutpostConfigArgs',
    'ClusterOutpostConfigArgsDict',
    'ClusterOutpostConfigControlPlanePlacementArgs',
    'ClusterOutpostConfigControlPlanePlacementArgsDict',
    'ClusterRemoteNetworkConfigArgs',
    'ClusterRemoteNetworkConfigArgsDict',
    'ClusterRemoteNetworkConfigRemoteNodeNetworksArgs',
    'ClusterRemoteNetworkConfigRemoteNodeNetworksArgsDict',
    'ClusterRemoteNetworkConfigRemotePodNetworksArgs',
    'ClusterRemoteNetworkConfigRemotePodNetworksArgsDict',
    'ClusterStorageConfigArgs',
    'ClusterStorageConfigArgsDict',
    'ClusterStorageConfigBlockStorageArgs',
    'ClusterStorageConfigBlockStorageArgsDict',
    'ClusterUpgradePolicyArgs',
    'ClusterUpgradePolicyArgsDict',
    'ClusterVpcConfigArgs',
    'ClusterVpcConfigArgsDict',
    'ClusterZonalShiftConfigArgs',
    'ClusterZonalShiftConfigArgsDict',
    'FargateProfileSelectorArgs',
    'FargateProfileSelectorArgsDict',
    'IdentityProviderConfigOidcArgs',
    'IdentityProviderConfigOidcArgsDict',
    'NodeGroupLaunchTemplateArgs',
    'NodeGroupLaunchTemplateArgsDict',
    'NodeGroupNodeRepairConfigArgs',
    'NodeGroupNodeRepairConfigArgsDict',
    'NodeGroupRemoteAccessArgs',
    'NodeGroupRemoteAccessArgsDict',
    'NodeGroupResourceArgs',
    'NodeGroupResourceArgsDict',
    'NodeGroupResourceAutoscalingGroupArgs',
    'NodeGroupResourceAutoscalingGroupArgsDict',
    'NodeGroupScalingConfigArgs',
    'NodeGroupScalingConfigArgsDict',
    'NodeGroupTaintArgs',
    'NodeGroupTaintArgsDict',
    'NodeGroupUpdateConfigArgs',
    'NodeGroupUpdateConfigArgsDict',
]

MYPY = False

if not MYPY:
    class AccessPolicyAssociationAccessScopeArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Valid values are `namespace` or `cluster`.
        """
        namespaces: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The namespaces to which the access scope applies when type is namespace.
        """
elif False:
    AccessPolicyAssociationAccessScopeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPolicyAssociationAccessScopeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] type: Valid values are `namespace` or `cluster`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] namespaces: The namespaces to which the access scope applies when type is namespace.
        """
        pulumi.set(__self__, "type", type)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Valid values are `namespace` or `cluster`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The namespaces to which the access scope applies when type is namespace.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "namespaces", value)


if not MYPY:
    class AddonPodIdentityAssociationArgsDict(TypedDict):
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the pods that use this service account.
        """
        service_account: pulumi.Input[builtins.str]
        """
        The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
        """
elif False:
    AddonPodIdentityAssociationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AddonPodIdentityAssociationArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[builtins.str],
                 service_account: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the pods that use this service account.
        :param pulumi.Input[builtins.str] service_account: The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the pods that use this service account.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_account", value)


if not MYPY:
    class ClusterAccessConfigArgsDict(TypedDict):
        authentication_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
        """
        bootstrap_cluster_creator_admin_permissions: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not to bootstrap the access config values to the cluster. Default is `false`.
        """
elif False:
    ClusterAccessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAccessConfigArgs:
    def __init__(__self__, *,
                 authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 bootstrap_cluster_creator_admin_permissions: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] authentication_mode: The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
        :param pulumi.Input[builtins.bool] bootstrap_cluster_creator_admin_permissions: Whether or not to bootstrap the access config values to the cluster. Default is `false`.
        """
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if bootstrap_cluster_creator_admin_permissions is not None:
            pulumi.set(__self__, "bootstrap_cluster_creator_admin_permissions", bootstrap_cluster_creator_admin_permissions)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="bootstrapClusterCreatorAdminPermissions")
    def bootstrap_cluster_creator_admin_permissions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to bootstrap the access config values to the cluster. Default is `false`.
        """
        return pulumi.get(self, "bootstrap_cluster_creator_admin_permissions")

    @bootstrap_cluster_creator_admin_permissions.setter
    def bootstrap_cluster_creator_admin_permissions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "bootstrap_cluster_creator_admin_permissions", value)


if not MYPY:
    class ClusterCertificateAuthorityArgsDict(TypedDict):
        data: NotRequired[pulumi.Input[builtins.str]]
        """
        Base64 encoded certificate data required to communicate with your cluster. Add this to the `certificate-authority-data` section of the `kubeconfig` file for your cluster.
        """
elif False:
    ClusterCertificateAuthorityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterCertificateAuthorityArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] data: Base64 encoded certificate data required to communicate with your cluster. Add this to the `certificate-authority-data` section of the `kubeconfig` file for your cluster.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64 encoded certificate data required to communicate with your cluster. Add this to the `certificate-authority-data` section of the `kubeconfig` file for your cluster.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data", value)


if not MYPY:
    class ClusterComputeConfigArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Request to enable or disable the compute capability on your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account.
        """
        node_pools: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. Valid options are `general-purpose` and `system`.
        """
        node_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled..
        """
elif False:
    ClusterComputeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterComputeConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 node_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 node_role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Request to enable or disable the compute capability on your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] node_pools: Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. Valid options are `general-purpose` and `system`.
        :param pulumi.Input[builtins.str] node_role_arn: The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled..
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if node_role_arn is not None:
            pulumi.set(__self__, "node_role_arn", node_role_arn)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Request to enable or disable the compute capability on your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. Valid options are `general-purpose` and `system`.
        """
        return pulumi.get(self, "node_pools")

    @node_pools.setter
    def node_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "node_pools", value)

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled..
        """
        return pulumi.get(self, "node_role_arn")

    @node_role_arn.setter
    def node_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_role_arn", value)


if not MYPY:
    class ClusterEncryptionConfigArgsDict(TypedDict):
        provider: pulumi.Input['ClusterEncryptionConfigProviderArgsDict']
        """
        Configuration block with provider for encryption. Detailed below.
        """
        resources: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of strings with resources to be encrypted. Valid values: `secrets`.
        """
elif False:
    ClusterEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionConfigArgs:
    def __init__(__self__, *,
                 provider: pulumi.Input['ClusterEncryptionConfigProviderArgs'],
                 resources: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input['ClusterEncryptionConfigProviderArgs'] provider: Configuration block with provider for encryption. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resources: List of strings with resources to be encrypted. Valid values: `secrets`.
        """
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def provider(self) -> pulumi.Input['ClusterEncryptionConfigProviderArgs']:
        """
        Configuration block with provider for encryption. Detailed below.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: pulumi.Input['ClusterEncryptionConfigProviderArgs']):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of strings with resources to be encrypted. Valid values: `secrets`.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "resources", value)


if not MYPY:
    class ClusterEncryptionConfigProviderArgsDict(TypedDict):
        key_arn: pulumi.Input[builtins.str]
        """
        ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
        """
elif False:
    ClusterEncryptionConfigProviderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionConfigProviderArgs:
    def __init__(__self__, *,
                 key_arn: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] key_arn: ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
        """
        pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
        """
        return pulumi.get(self, "key_arn")

    @key_arn.setter
    def key_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_arn", value)


if not MYPY:
    class ClusterIdentityArgsDict(TypedDict):
        oidcs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterIdentityOidcArgsDict']]]]
        """
        Nested block containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
        """
elif False:
    ClusterIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterIdentityArgs:
    def __init__(__self__, *,
                 oidcs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterIdentityOidcArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterIdentityOidcArgs']]] oidcs: Nested block containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
        """
        if oidcs is not None:
            pulumi.set(__self__, "oidcs", oidcs)

    @property
    @pulumi.getter
    def oidcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterIdentityOidcArgs']]]]:
        """
        Nested block containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
        """
        return pulumi.get(self, "oidcs")

    @oidcs.setter
    def oidcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterIdentityOidcArgs']]]]):
        pulumi.set(self, "oidcs", value)


if not MYPY:
    class ClusterIdentityOidcArgsDict(TypedDict):
        issuer: NotRequired[pulumi.Input[builtins.str]]
        """
        Issuer URL for the OpenID Connect identity provider.
        """
elif False:
    ClusterIdentityOidcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterIdentityOidcArgs:
    def __init__(__self__, *,
                 issuer: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] issuer: Issuer URL for the OpenID Connect identity provider.
        """
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Issuer URL for the OpenID Connect identity provider.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer", value)


if not MYPY:
    class ClusterKubernetesNetworkConfigArgsDict(TypedDict):
        elastic_load_balancing: NotRequired[pulumi.Input['ClusterKubernetesNetworkConfigElasticLoadBalancingArgsDict']]
        """
        Configuration block with elastic load balancing configuration for the cluster. Detailed below.
        """
        ip_family: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
        """
        service_ipv4_cidr: NotRequired[pulumi.Input[builtins.str]]
        """
        The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:

        * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.

        * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.

        * Between /24 and /12.
        """
        service_ipv6_cidr: NotRequired[pulumi.Input[builtins.str]]
        """
        The CIDR block that Kubernetes pod and service IP addresses are assigned from if you specify `ipv6` for `ip_family` when you create the cluster. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
        """
elif False:
    ClusterKubernetesNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterKubernetesNetworkConfigArgs:
    def __init__(__self__, *,
                 elastic_load_balancing: Optional[pulumi.Input['ClusterKubernetesNetworkConfigElasticLoadBalancingArgs']] = None,
                 ip_family: Optional[pulumi.Input[builtins.str]] = None,
                 service_ipv4_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 service_ipv6_cidr: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ClusterKubernetesNetworkConfigElasticLoadBalancingArgs'] elastic_load_balancing: Configuration block with elastic load balancing configuration for the cluster. Detailed below.
        :param pulumi.Input[builtins.str] ip_family: The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
        :param pulumi.Input[builtins.str] service_ipv4_cidr: The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:
               
               * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.
               
               * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
               
               * Between /24 and /12.
        :param pulumi.Input[builtins.str] service_ipv6_cidr: The CIDR block that Kubernetes pod and service IP addresses are assigned from if you specify `ipv6` for `ip_family` when you create the cluster. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
        """
        if elastic_load_balancing is not None:
            pulumi.set(__self__, "elastic_load_balancing", elastic_load_balancing)
        if ip_family is not None:
            pulumi.set(__self__, "ip_family", ip_family)
        if service_ipv4_cidr is not None:
            pulumi.set(__self__, "service_ipv4_cidr", service_ipv4_cidr)
        if service_ipv6_cidr is not None:
            pulumi.set(__self__, "service_ipv6_cidr", service_ipv6_cidr)

    @property
    @pulumi.getter(name="elasticLoadBalancing")
    def elastic_load_balancing(self) -> Optional[pulumi.Input['ClusterKubernetesNetworkConfigElasticLoadBalancingArgs']]:
        """
        Configuration block with elastic load balancing configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "elastic_load_balancing")

    @elastic_load_balancing.setter
    def elastic_load_balancing(self, value: Optional[pulumi.Input['ClusterKubernetesNetworkConfigElasticLoadBalancingArgs']]):
        pulumi.set(self, "elastic_load_balancing", value)

    @property
    @pulumi.getter(name="ipFamily")
    def ip_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
        """
        return pulumi.get(self, "ip_family")

    @ip_family.setter
    def ip_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_family", value)

    @property
    @pulumi.getter(name="serviceIpv4Cidr")
    def service_ipv4_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:

        * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.

        * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.

        * Between /24 and /12.
        """
        return pulumi.get(self, "service_ipv4_cidr")

    @service_ipv4_cidr.setter
    def service_ipv4_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_ipv4_cidr", value)

    @property
    @pulumi.getter(name="serviceIpv6Cidr")
    def service_ipv6_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block that Kubernetes pod and service IP addresses are assigned from if you specify `ipv6` for `ip_family` when you create the cluster. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
        """
        return pulumi.get(self, "service_ipv6_cidr")

    @service_ipv6_cidr.setter
    def service_ipv6_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_ipv6_cidr", value)


if not MYPY:
    class ClusterKubernetesNetworkConfigElasticLoadBalancingArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates if the load balancing capability is enabled on your EKS Auto Mode cluster. If the load balancing capability is enabled, EKS Auto Mode will create and delete load balancers in your Amazon Web Services account.
        """
elif False:
    ClusterKubernetesNetworkConfigElasticLoadBalancingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterKubernetesNetworkConfigElasticLoadBalancingArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Indicates if the load balancing capability is enabled on your EKS Auto Mode cluster. If the load balancing capability is enabled, EKS Auto Mode will create and delete load balancers in your Amazon Web Services account.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the load balancing capability is enabled on your EKS Auto Mode cluster. If the load balancing capability is enabled, EKS Auto Mode will create and delete load balancers in your Amazon Web Services account.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterOutpostConfigArgsDict(TypedDict):
        control_plane_instance_type: pulumi.Input[builtins.str]
        """
        The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:

        * 1–20 nodes, then we recommend specifying a large instance type.

        * 21–100 nodes, then we recommend specifying an xlarge instance type.

        * 101–250 nodes, then we recommend specifying a 2xlarge instance type.

        For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
        """
        outpost_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
        """
        control_plane_placement: NotRequired[pulumi.Input['ClusterOutpostConfigControlPlanePlacementArgsDict']]
        """
        An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
        The `control_plane_placement` configuration block supports the following arguments:
        """
elif False:
    ClusterOutpostConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterOutpostConfigArgs:
    def __init__(__self__, *,
                 control_plane_instance_type: pulumi.Input[builtins.str],
                 outpost_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 control_plane_placement: Optional[pulumi.Input['ClusterOutpostConfigControlPlanePlacementArgs']] = None):
        """
        :param pulumi.Input[builtins.str] control_plane_instance_type: The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
               
               * 1–20 nodes, then we recommend specifying a large instance type.
               
               * 21–100 nodes, then we recommend specifying an xlarge instance type.
               
               * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
               
               For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outpost_arns: The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
        :param pulumi.Input['ClusterOutpostConfigControlPlanePlacementArgs'] control_plane_placement: An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
               The `control_plane_placement` configuration block supports the following arguments:
        """
        pulumi.set(__self__, "control_plane_instance_type", control_plane_instance_type)
        pulumi.set(__self__, "outpost_arns", outpost_arns)
        if control_plane_placement is not None:
            pulumi.set(__self__, "control_plane_placement", control_plane_placement)

    @property
    @pulumi.getter(name="controlPlaneInstanceType")
    def control_plane_instance_type(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:

        * 1–20 nodes, then we recommend specifying a large instance type.

        * 21–100 nodes, then we recommend specifying an xlarge instance type.

        * 101–250 nodes, then we recommend specifying a 2xlarge instance type.

        For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
        """
        return pulumi.get(self, "control_plane_instance_type")

    @control_plane_instance_type.setter
    def control_plane_instance_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "control_plane_instance_type", value)

    @property
    @pulumi.getter(name="outpostArns")
    def outpost_arns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
        """
        return pulumi.get(self, "outpost_arns")

    @outpost_arns.setter
    def outpost_arns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "outpost_arns", value)

    @property
    @pulumi.getter(name="controlPlanePlacement")
    def control_plane_placement(self) -> Optional[pulumi.Input['ClusterOutpostConfigControlPlanePlacementArgs']]:
        """
        An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
        The `control_plane_placement` configuration block supports the following arguments:
        """
        return pulumi.get(self, "control_plane_placement")

    @control_plane_placement.setter
    def control_plane_placement(self, value: Optional[pulumi.Input['ClusterOutpostConfigControlPlanePlacementArgs']]):
        pulumi.set(self, "control_plane_placement", value)


if not MYPY:
    class ClusterOutpostConfigControlPlanePlacementArgsDict(TypedDict):
        group_name: pulumi.Input[builtins.str]
        """
        The name of the placement group for the Kubernetes control plane instances. This setting can't be changed after cluster creation.
        """
elif False:
    ClusterOutpostConfigControlPlanePlacementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterOutpostConfigControlPlanePlacementArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] group_name: The name of the placement group for the Kubernetes control plane instances. This setting can't be changed after cluster creation.
        """
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the placement group for the Kubernetes control plane instances. This setting can't be changed after cluster creation.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group_name", value)


if not MYPY:
    class ClusterRemoteNetworkConfigArgsDict(TypedDict):
        remote_node_networks: pulumi.Input['ClusterRemoteNetworkConfigRemoteNodeNetworksArgsDict']
        """
        Configuration block with remote node network configuration for EKS Hybrid Nodes. Detailed below.
        """
        remote_pod_networks: NotRequired[pulumi.Input['ClusterRemoteNetworkConfigRemotePodNetworksArgsDict']]
        """
        Configuration block with remote pod network configuration for EKS Hybrid Nodes. Detailed below.
        """
elif False:
    ClusterRemoteNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterRemoteNetworkConfigArgs:
    def __init__(__self__, *,
                 remote_node_networks: pulumi.Input['ClusterRemoteNetworkConfigRemoteNodeNetworksArgs'],
                 remote_pod_networks: Optional[pulumi.Input['ClusterRemoteNetworkConfigRemotePodNetworksArgs']] = None):
        """
        :param pulumi.Input['ClusterRemoteNetworkConfigRemoteNodeNetworksArgs'] remote_node_networks: Configuration block with remote node network configuration for EKS Hybrid Nodes. Detailed below.
        :param pulumi.Input['ClusterRemoteNetworkConfigRemotePodNetworksArgs'] remote_pod_networks: Configuration block with remote pod network configuration for EKS Hybrid Nodes. Detailed below.
        """
        pulumi.set(__self__, "remote_node_networks", remote_node_networks)
        if remote_pod_networks is not None:
            pulumi.set(__self__, "remote_pod_networks", remote_pod_networks)

    @property
    @pulumi.getter(name="remoteNodeNetworks")
    def remote_node_networks(self) -> pulumi.Input['ClusterRemoteNetworkConfigRemoteNodeNetworksArgs']:
        """
        Configuration block with remote node network configuration for EKS Hybrid Nodes. Detailed below.
        """
        return pulumi.get(self, "remote_node_networks")

    @remote_node_networks.setter
    def remote_node_networks(self, value: pulumi.Input['ClusterRemoteNetworkConfigRemoteNodeNetworksArgs']):
        pulumi.set(self, "remote_node_networks", value)

    @property
    @pulumi.getter(name="remotePodNetworks")
    def remote_pod_networks(self) -> Optional[pulumi.Input['ClusterRemoteNetworkConfigRemotePodNetworksArgs']]:
        """
        Configuration block with remote pod network configuration for EKS Hybrid Nodes. Detailed below.
        """
        return pulumi.get(self, "remote_pod_networks")

    @remote_pod_networks.setter
    def remote_pod_networks(self, value: Optional[pulumi.Input['ClusterRemoteNetworkConfigRemotePodNetworksArgs']]):
        pulumi.set(self, "remote_pod_networks", value)


if not MYPY:
    class ClusterRemoteNetworkConfigRemoteNodeNetworksArgsDict(TypedDict):
        cidrs: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of network CIDRs that can contain hybrid nodes.
        """
elif False:
    ClusterRemoteNetworkConfigRemoteNodeNetworksArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterRemoteNetworkConfigRemoteNodeNetworksArgs:
    def __init__(__self__, *,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidrs: List of network CIDRs that can contain hybrid nodes.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of network CIDRs that can contain hybrid nodes.
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cidrs", value)


if not MYPY:
    class ClusterRemoteNetworkConfigRemotePodNetworksArgsDict(TypedDict):
        cidrs: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
elif False:
    ClusterRemoteNetworkConfigRemotePodNetworksArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterRemoteNetworkConfigRemotePodNetworksArgs:
    def __init__(__self__, *,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidrs: List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cidrs", value)


if not MYPY:
    class ClusterStorageConfigArgsDict(TypedDict):
        block_storage: NotRequired[pulumi.Input['ClusterStorageConfigBlockStorageArgsDict']]
        """
        Configuration block with block storage configuration for the cluster. Detailed below.
        """
elif False:
    ClusterStorageConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterStorageConfigArgs:
    def __init__(__self__, *,
                 block_storage: Optional[pulumi.Input['ClusterStorageConfigBlockStorageArgs']] = None):
        """
        :param pulumi.Input['ClusterStorageConfigBlockStorageArgs'] block_storage: Configuration block with block storage configuration for the cluster. Detailed below.
        """
        if block_storage is not None:
            pulumi.set(__self__, "block_storage", block_storage)

    @property
    @pulumi.getter(name="blockStorage")
    def block_storage(self) -> Optional[pulumi.Input['ClusterStorageConfigBlockStorageArgs']]:
        """
        Configuration block with block storage configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "block_storage")

    @block_storage.setter
    def block_storage(self, value: Optional[pulumi.Input['ClusterStorageConfigBlockStorageArgs']]):
        pulumi.set(self, "block_storage", value)


if not MYPY:
    class ClusterStorageConfigBlockStorageArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates if the block storage capability is enabled on your EKS Auto Mode cluster. If the block storage capability is enabled, EKS Auto Mode will create and delete block storage volumes in your Amazon Web Services account.
        """
elif False:
    ClusterStorageConfigBlockStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterStorageConfigBlockStorageArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Indicates if the block storage capability is enabled on your EKS Auto Mode cluster. If the block storage capability is enabled, EKS Auto Mode will create and delete block storage volumes in your Amazon Web Services account.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the block storage capability is enabled on your EKS Auto Mode cluster. If the block storage capability is enabled, EKS Auto Mode will create and delete block storage volumes in your Amazon Web Services account.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ClusterUpgradePolicyArgsDict(TypedDict):
        support_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
        """
elif False:
    ClusterUpgradePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterUpgradePolicyArgs:
    def __init__(__self__, *,
                 support_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] support_type: Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
        """
        if support_type is not None:
            pulumi.set(__self__, "support_type", support_type)

    @property
    @pulumi.getter(name="supportType")
    def support_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
        """
        return pulumi.get(self, "support_type")

    @support_type.setter
    def support_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "support_type", value)


if not MYPY:
    class ClusterVpcConfigArgsDict(TypedDict):
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
        """
        cluster_security_group_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Cluster security group that is created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
        """
        endpoint_private_access: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
        """
        endpoint_public_access: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
        """
        public_access_cidrs: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
        """
        vpc_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID of the VPC associated with your cluster.
        """
elif False:
    ClusterVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterVpcConfigArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 cluster_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_private_access: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_public_access: Optional[pulumi.Input[builtins.bool]] = None,
                 public_access_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
        :param pulumi.Input[builtins.str] cluster_security_group_id: Cluster security group that is created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
        :param pulumi.Input[builtins.bool] endpoint_private_access: Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
        :param pulumi.Input[builtins.bool] endpoint_public_access: Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] public_access_cidrs: List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
        :param pulumi.Input[builtins.str] vpc_id: ID of the VPC associated with your cluster.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if cluster_security_group_id is not None:
            pulumi.set(__self__, "cluster_security_group_id", cluster_security_group_id)
        if endpoint_private_access is not None:
            pulumi.set(__self__, "endpoint_private_access", endpoint_private_access)
        if endpoint_public_access is not None:
            pulumi.set(__self__, "endpoint_public_access", endpoint_public_access)
        if public_access_cidrs is not None:
            pulumi.set(__self__, "public_access_cidrs", public_access_cidrs)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="clusterSecurityGroupId")
    def cluster_security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cluster security group that is created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
        """
        return pulumi.get(self, "cluster_security_group_id")

    @cluster_security_group_id.setter
    def cluster_security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_security_group_id", value)

    @property
    @pulumi.getter(name="endpointPrivateAccess")
    def endpoint_private_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
        """
        return pulumi.get(self, "endpoint_private_access")

    @endpoint_private_access.setter
    def endpoint_private_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "endpoint_private_access", value)

    @property
    @pulumi.getter(name="endpointPublicAccess")
    def endpoint_public_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
        """
        return pulumi.get(self, "endpoint_public_access")

    @endpoint_public_access.setter
    def endpoint_public_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "endpoint_public_access", value)

    @property
    @pulumi.getter(name="publicAccessCidrs")
    def public_access_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
        """
        return pulumi.get(self, "public_access_cidrs")

    @public_access_cidrs.setter
    def public_access_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "public_access_cidrs", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the VPC associated with your cluster.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class ClusterZonalShiftConfigArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether zonal shift is enabled for the cluster.
        """
elif False:
    ClusterZonalShiftConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterZonalShiftConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Whether zonal shift is enabled for the cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether zonal shift is enabled for the cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class FargateProfileSelectorArgsDict(TypedDict):
        namespace: pulumi.Input[builtins.str]
        """
        Kubernetes namespace for selection.

        The following arguments are optional:
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Key-value map of Kubernetes labels for selection.
        """
elif False:
    FargateProfileSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FargateProfileSelectorArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] namespace: Kubernetes namespace for selection.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Key-value map of Kubernetes labels for selection.
        """
        pulumi.set(__self__, "namespace", namespace)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        Kubernetes namespace for selection.

        The following arguments are optional:
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of Kubernetes labels for selection.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)


if not MYPY:
    class IdentityProviderConfigOidcArgsDict(TypedDict):
        client_id: pulumi.Input[builtins.str]
        """
        Client ID for the OpenID Connect identity provider.
        """
        identity_provider_config_name: pulumi.Input[builtins.str]
        """
        The name of the identity provider config.
        """
        issuer_url: pulumi.Input[builtins.str]
        """
        Issuer URL for the OpenID Connect identity provider.
        """
        groups_claim: NotRequired[pulumi.Input[builtins.str]]
        """
        The JWT claim that the provider will use to return groups.
        """
        groups_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        A prefix that is prepended to group claims e.g., `oidc:`.
        """
        required_claims: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The key value pairs that describe required claims in the identity token.
        """
        username_claim: NotRequired[pulumi.Input[builtins.str]]
        """
        The JWT claim that the provider will use as the username.
        """
        username_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        A prefix that is prepended to username claims.
        """
elif False:
    IdentityProviderConfigOidcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IdentityProviderConfigOidcArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[builtins.str],
                 identity_provider_config_name: pulumi.Input[builtins.str],
                 issuer_url: pulumi.Input[builtins.str],
                 groups_claim: Optional[pulumi.Input[builtins.str]] = None,
                 groups_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 required_claims: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 username_claim: Optional[pulumi.Input[builtins.str]] = None,
                 username_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] client_id: Client ID for the OpenID Connect identity provider.
        :param pulumi.Input[builtins.str] identity_provider_config_name: The name of the identity provider config.
        :param pulumi.Input[builtins.str] issuer_url: Issuer URL for the OpenID Connect identity provider.
        :param pulumi.Input[builtins.str] groups_claim: The JWT claim that the provider will use to return groups.
        :param pulumi.Input[builtins.str] groups_prefix: A prefix that is prepended to group claims e.g., `oidc:`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] required_claims: The key value pairs that describe required claims in the identity token.
        :param pulumi.Input[builtins.str] username_claim: The JWT claim that the provider will use as the username.
        :param pulumi.Input[builtins.str] username_prefix: A prefix that is prepended to username claims.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "identity_provider_config_name", identity_provider_config_name)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        Client ID for the OpenID Connect identity provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="identityProviderConfigName")
    def identity_provider_config_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the identity provider config.
        """
        return pulumi.get(self, "identity_provider_config_name")

    @identity_provider_config_name.setter
    def identity_provider_config_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_provider_config_name", value)

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Input[builtins.str]:
        """
        Issuer URL for the OpenID Connect identity provider.
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "issuer_url", value)

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The JWT claim that the provider will use to return groups.
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "groups_claim", value)

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A prefix that is prepended to group claims e.g., `oidc:`.
        """
        return pulumi.get(self, "groups_prefix")

    @groups_prefix.setter
    def groups_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "groups_prefix", value)

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The key value pairs that describe required claims in the identity token.
        """
        return pulumi.get(self, "required_claims")

    @required_claims.setter
    def required_claims(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "required_claims", value)

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The JWT claim that the provider will use as the username.
        """
        return pulumi.get(self, "username_claim")

    @username_claim.setter
    def username_claim(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username_claim", value)

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A prefix that is prepended to username claims.
        """
        return pulumi.get(self, "username_prefix")

    @username_prefix.setter
    def username_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username_prefix", value)


if not MYPY:
    class NodeGroupLaunchTemplateArgsDict(TypedDict):
        version: pulumi.Input[builtins.str]
        """
        EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `ec2.LaunchTemplate` resource or data source is recommended for this argument.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the EC2 Launch Template. Conflicts with `name`.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the EC2 Launch Template. Conflicts with `id`.
        """
elif False:
    NodeGroupLaunchTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeGroupLaunchTemplateArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[builtins.str],
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] version: EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `ec2.LaunchTemplate` resource or data source is recommended for this argument.
        :param pulumi.Input[builtins.str] id: Identifier of the EC2 Launch Template. Conflicts with `name`.
        :param pulumi.Input[builtins.str] name: Name of the EC2 Launch Template. Conflicts with `id`.
        """
        pulumi.set(__self__, "version", version)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `ec2.LaunchTemplate` resource or data source is recommended for this argument.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the EC2 Launch Template. Conflicts with `name`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the EC2 Launch Template. Conflicts with `id`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class NodeGroupNodeRepairConfigArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
        """
elif False:
    NodeGroupNodeRepairConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeGroupNodeRepairConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class NodeGroupRemoteAccessArgsDict(TypedDict):
        ec2_ssh_key: NotRequired[pulumi.Input[builtins.str]]
        """
        EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
        """
        source_security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
        """
elif False:
    NodeGroupRemoteAccessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeGroupRemoteAccessArgs:
    def __init__(__self__, *,
                 ec2_ssh_key: Optional[pulumi.Input[builtins.str]] = None,
                 source_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] ec2_ssh_key: EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_security_group_ids: Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
        """
        if ec2_ssh_key is not None:
            pulumi.set(__self__, "ec2_ssh_key", ec2_ssh_key)
        if source_security_group_ids is not None:
            pulumi.set(__self__, "source_security_group_ids", source_security_group_ids)

    @property
    @pulumi.getter(name="ec2SshKey")
    def ec2_ssh_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
        """
        return pulumi.get(self, "ec2_ssh_key")

    @ec2_ssh_key.setter
    def ec2_ssh_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ec2_ssh_key", value)

    @property
    @pulumi.getter(name="sourceSecurityGroupIds")
    def source_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
        """
        return pulumi.get(self, "source_security_group_ids")

    @source_security_group_ids.setter
    def source_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_security_group_ids", value)


if not MYPY:
    class NodeGroupResourceArgsDict(TypedDict):
        autoscaling_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceAutoscalingGroupArgsDict']]]]
        """
        List of objects containing information about AutoScaling Groups.
        """
        remote_access_security_group_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the remote access EC2 Security Group.
        """
elif False:
    NodeGroupResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeGroupResourceArgs:
    def __init__(__self__, *,
                 autoscaling_groups: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceAutoscalingGroupArgs']]]] = None,
                 remote_access_security_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceAutoscalingGroupArgs']]] autoscaling_groups: List of objects containing information about AutoScaling Groups.
        :param pulumi.Input[builtins.str] remote_access_security_group_id: Identifier of the remote access EC2 Security Group.
        """
        if autoscaling_groups is not None:
            pulumi.set(__self__, "autoscaling_groups", autoscaling_groups)
        if remote_access_security_group_id is not None:
            pulumi.set(__self__, "remote_access_security_group_id", remote_access_security_group_id)

    @property
    @pulumi.getter(name="autoscalingGroups")
    def autoscaling_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceAutoscalingGroupArgs']]]]:
        """
        List of objects containing information about AutoScaling Groups.
        """
        return pulumi.get(self, "autoscaling_groups")

    @autoscaling_groups.setter
    def autoscaling_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceAutoscalingGroupArgs']]]]):
        pulumi.set(self, "autoscaling_groups", value)

    @property
    @pulumi.getter(name="remoteAccessSecurityGroupId")
    def remote_access_security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the remote access EC2 Security Group.
        """
        return pulumi.get(self, "remote_access_security_group_id")

    @remote_access_security_group_id.setter
    def remote_access_security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "remote_access_security_group_id", value)


if not MYPY:
    class NodeGroupResourceAutoscalingGroupArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the AutoScaling Group.
        """
elif False:
    NodeGroupResourceAutoscalingGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeGroupResourceAutoscalingGroupArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: Name of the AutoScaling Group.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the AutoScaling Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class NodeGroupScalingConfigArgsDict(TypedDict):
        desired_size: pulumi.Input[builtins.int]
        """
        Desired number of worker nodes.
        """
        max_size: pulumi.Input[builtins.int]
        """
        Maximum number of worker nodes.
        """
        min_size: pulumi.Input[builtins.int]
        """
        Minimum number of worker nodes.
        """
elif False:
    NodeGroupScalingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeGroupScalingConfigArgs:
    def __init__(__self__, *,
                 desired_size: pulumi.Input[builtins.int],
                 max_size: pulumi.Input[builtins.int],
                 min_size: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] desired_size: Desired number of worker nodes.
        :param pulumi.Input[builtins.int] max_size: Maximum number of worker nodes.
        :param pulumi.Input[builtins.int] min_size: Minimum number of worker nodes.
        """
        pulumi.set(__self__, "desired_size", desired_size)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> pulumi.Input[builtins.int]:
        """
        Desired number of worker nodes.
        """
        return pulumi.get(self, "desired_size")

    @desired_size.setter
    def desired_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "desired_size", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[builtins.int]:
        """
        Maximum number of worker nodes.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[builtins.int]:
        """
        Minimum number of worker nodes.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_size", value)


if not MYPY:
    class NodeGroupTaintArgsDict(TypedDict):
        effect: pulumi.Input[builtins.str]
        """
        The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
        """
        key: pulumi.Input[builtins.str]
        """
        The key of the taint. Maximum length of 63.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the taint. Maximum length of 63.
        """
elif False:
    NodeGroupTaintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeGroupTaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] effect: The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
        :param pulumi.Input[builtins.str] key: The key of the taint. Maximum length of 63.
        :param pulumi.Input[builtins.str] value: The value of the taint. Maximum length of 63.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[builtins.str]:
        """
        The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The key of the taint. Maximum length of 63.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the taint. Maximum length of 63.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class NodeGroupUpdateConfigArgsDict(TypedDict):
        max_unavailable: NotRequired[pulumi.Input[builtins.int]]
        """
        Desired max number of unavailable worker nodes during node group update.
        """
        max_unavailable_percentage: NotRequired[pulumi.Input[builtins.int]]
        """
        Desired max percentage of unavailable worker nodes during node group update.
        """
elif False:
    NodeGroupUpdateConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeGroupUpdateConfigArgs:
    def __init__(__self__, *,
                 max_unavailable: Optional[pulumi.Input[builtins.int]] = None,
                 max_unavailable_percentage: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_unavailable: Desired max number of unavailable worker nodes during node group update.
        :param pulumi.Input[builtins.int] max_unavailable_percentage: Desired max percentage of unavailable worker nodes during node group update.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if max_unavailable_percentage is not None:
            pulumi.set(__self__, "max_unavailable_percentage", max_unavailable_percentage)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Desired max number of unavailable worker nodes during node group update.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_unavailable", value)

    @property
    @pulumi.getter(name="maxUnavailablePercentage")
    def max_unavailable_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Desired max percentage of unavailable worker nodes during node group update.
        """
        return pulumi.get(self, "max_unavailable_percentage")

    @max_unavailable_percentage.setter
    def max_unavailable_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_unavailable_percentage", value)


