# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddonResult',
    'AwaitableGetAddonResult',
    'get_addon',
    'get_addon_output',
]

@pulumi.output_type
class GetAddonResult:
    """
    A collection of values returned by getAddon.
    """
    def __init__(__self__, addon_name=None, addon_version=None, arn=None, cluster_name=None, configuration_values=None, created_at=None, id=None, modified_at=None, pod_identity_associations=None, region=None, service_account_role_arn=None, tags=None):
        if addon_name and not isinstance(addon_name, str):
            raise TypeError("Expected argument 'addon_name' to be a str")
        pulumi.set(__self__, "addon_name", addon_name)
        if addon_version and not isinstance(addon_version, str):
            raise TypeError("Expected argument 'addon_version' to be a str")
        pulumi.set(__self__, "addon_version", addon_version)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if configuration_values and not isinstance(configuration_values, str):
            raise TypeError("Expected argument 'configuration_values' to be a str")
        pulumi.set(__self__, "configuration_values", configuration_values)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if pod_identity_associations and not isinstance(pod_identity_associations, list):
            raise TypeError("Expected argument 'pod_identity_associations' to be a list")
        pulumi.set(__self__, "pod_identity_associations", pod_identity_associations)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_account_role_arn and not isinstance(service_account_role_arn, str):
            raise TypeError("Expected argument 'service_account_role_arn' to be a str")
        pulumi.set(__self__, "service_account_role_arn", service_account_role_arn)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> builtins.str:
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> builtins.str:
        """
        Version of EKS add-on.
        """
        return pulumi.get(self, "addon_version")

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the EKS add-on.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> builtins.str:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> builtins.str:
        """
        Configuration values for the addon with a single JSON string.
        """
        return pulumi.get(self, "configuration_values")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> builtins.str:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="podIdentityAssociations")
    def pod_identity_associations(self) -> Sequence['outputs.GetAddonPodIdentityAssociationResult']:
        """
        Pod identity association for the EKS add-on.
        """
        return pulumi.get(self, "pod_identity_associations")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> builtins.str:
        """
        ARN of IAM role used for EKS add-on. If value is empty -
        then add-on uses the IAM role assigned to the EKS Cluster node.
        """
        return pulumi.get(self, "service_account_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetAddonResult(GetAddonResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddonResult(
            addon_name=self.addon_name,
            addon_version=self.addon_version,
            arn=self.arn,
            cluster_name=self.cluster_name,
            configuration_values=self.configuration_values,
            created_at=self.created_at,
            id=self.id,
            modified_at=self.modified_at,
            pod_identity_associations=self.pod_identity_associations,
            region=self.region,
            service_account_role_arn=self.service_account_role_arn,
            tags=self.tags)


def get_addon(addon_name: Optional[builtins.str] = None,
              cluster_name: Optional[builtins.str] = None,
              region: Optional[builtins.str] = None,
              tags: Optional[Mapping[str, builtins.str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddonResult:
    """
    Retrieve information about an EKS add-on.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_addon(addon_name="vpc-cni",
        cluster_name=example_aws_eks_cluster["name"])
    pulumi.export("eksAddonOutputs", example_aws_eks_addon)
    ```


    :param builtins.str addon_name: Name of the EKS add-on. The name must match one of
           the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
    :param builtins.str cluster_name: Name of the EKS Cluster.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['clusterName'] = cluster_name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:eks/getAddon:getAddon', __args__, opts=opts, typ=GetAddonResult).value

    return AwaitableGetAddonResult(
        addon_name=pulumi.get(__ret__, 'addon_name'),
        addon_version=pulumi.get(__ret__, 'addon_version'),
        arn=pulumi.get(__ret__, 'arn'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        configuration_values=pulumi.get(__ret__, 'configuration_values'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        modified_at=pulumi.get(__ret__, 'modified_at'),
        pod_identity_associations=pulumi.get(__ret__, 'pod_identity_associations'),
        region=pulumi.get(__ret__, 'region'),
        service_account_role_arn=pulumi.get(__ret__, 'service_account_role_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_addon_output(addon_name: Optional[pulumi.Input[builtins.str]] = None,
                     cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                     region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddonResult]:
    """
    Retrieve information about an EKS add-on.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.eks.get_addon(addon_name="vpc-cni",
        cluster_name=example_aws_eks_cluster["name"])
    pulumi.export("eksAddonOutputs", example_aws_eks_addon)
    ```


    :param builtins.str addon_name: Name of the EKS add-on. The name must match one of
           the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
    :param builtins.str cluster_name: Name of the EKS Cluster.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['clusterName'] = cluster_name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:eks/getAddon:getAddon', __args__, opts=opts, typ=GetAddonResult)
    return __ret__.apply(lambda __response__: GetAddonResult(
        addon_name=pulumi.get(__response__, 'addon_name'),
        addon_version=pulumi.get(__response__, 'addon_version'),
        arn=pulumi.get(__response__, 'arn'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        configuration_values=pulumi.get(__response__, 'configuration_values'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        modified_at=pulumi.get(__response__, 'modified_at'),
        pod_identity_associations=pulumi.get(__response__, 'pod_identity_associations'),
        region=pulumi.get(__response__, 'region'),
        service_account_role_arn=pulumi.get(__response__, 'service_account_role_arn'),
        tags=pulumi.get(__response__, 'tags')))
