# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeGroupArgs', 'NodeGroup']

@pulumi.input_type
class NodeGroupArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[builtins.str],
                 node_role_arn: pulumi.Input[builtins.str],
                 scaling_config: pulumi.Input['NodeGroupScalingConfigArgs'],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_type: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 force_update_version: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input['NodeGroupLaunchTemplateArgs']] = None,
                 node_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_group_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 node_repair_config: Optional[pulumi.Input['NodeGroupNodeRepairConfigArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 release_version: Optional[pulumi.Input[builtins.str]] = None,
                 remote_access: Optional[pulumi.Input['NodeGroupRemoteAccessArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupTaintArgs']]]] = None,
                 update_config: Optional[pulumi.Input['NodeGroupUpdateConfigArgs']] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NodeGroup resource.
        :param pulumi.Input[builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[builtins.str] node_role_arn: Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
        :param pulumi.Input['NodeGroupScalingConfigArgs'] scaling_config: Configuration block with scaling settings. See `scaling_config` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: Identifiers of EC2 Subnets to associate with the EKS Node Group.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] ami_type: Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.str] capacity_type: Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.int] disk_size: Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.bool] force_update_version: Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: List of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        :param pulumi.Input['NodeGroupLaunchTemplateArgs'] launch_template: Configuration block with Launch Template settings. See `launch_template` below for details. Conflicts with `remote_access`.
        :param pulumi.Input[builtins.str] node_group_name: Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
        :param pulumi.Input[builtins.str] node_group_name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
        :param pulumi.Input['NodeGroupNodeRepairConfigArgs'] node_repair_config: The node auto repair configuration for the node group. See `node_repair_config` below for details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] release_version: AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        :param pulumi.Input['NodeGroupRemoteAccessArgs'] remote_access: Configuration block with remote access settings. See `remote_access` below for details. Conflicts with `launch_template`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupTaintArgs']]] taints: The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
        :param pulumi.Input['NodeGroupUpdateConfigArgs'] update_config: Configuration block with update settings. See `update_config` below for details.
        :param pulumi.Input[builtins.str] version: Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "node_role_arn", node_role_arn)
        pulumi.set(__self__, "scaling_config", scaling_config)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if ami_type is not None:
            pulumi.set(__self__, "ami_type", ami_type)
        if capacity_type is not None:
            pulumi.set(__self__, "capacity_type", capacity_type)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if force_update_version is not None:
            pulumi.set(__self__, "force_update_version", force_update_version)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if node_group_name_prefix is not None:
            pulumi.set(__self__, "node_group_name_prefix", node_group_name_prefix)
        if node_repair_config is not None:
            pulumi.set(__self__, "node_repair_config", node_repair_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_version is not None:
            pulumi.set(__self__, "release_version", release_version)
        if remote_access is not None:
            pulumi.set(__self__, "remote_access", remote_access)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_config is not None:
            pulumi.set(__self__, "update_config", update_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
        """
        return pulumi.get(self, "node_role_arn")

    @node_role_arn.setter
    def node_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_role_arn", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Input['NodeGroupScalingConfigArgs']:
        """
        Configuration block with scaling settings. See `scaling_config` below for details.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: pulumi.Input['NodeGroupScalingConfigArgs']):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Identifiers of EC2 Subnets to associate with the EKS Node Group.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "ami_type")

    @ami_type.setter
    def ami_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ami_type", value)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "capacity_type")

    @capacity_type.setter
    def capacity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_type", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="forceUpdateVersion")
    def force_update_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        """
        return pulumi.get(self, "force_update_version")

    @force_update_version.setter
    def force_update_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_update_version", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['NodeGroupLaunchTemplateArgs']]:
        """
        Configuration block with Launch Template settings. See `launch_template` below for details. Conflicts with `remote_access`.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['NodeGroupLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_group_name", value)

    @property
    @pulumi.getter(name="nodeGroupNamePrefix")
    def node_group_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
        """
        return pulumi.get(self, "node_group_name_prefix")

    @node_group_name_prefix.setter
    def node_group_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_group_name_prefix", value)

    @property
    @pulumi.getter(name="nodeRepairConfig")
    def node_repair_config(self) -> Optional[pulumi.Input['NodeGroupNodeRepairConfigArgs']]:
        """
        The node auto repair configuration for the node group. See `node_repair_config` below for details.
        """
        return pulumi.get(self, "node_repair_config")

    @node_repair_config.setter
    def node_repair_config(self, value: Optional[pulumi.Input['NodeGroupNodeRepairConfigArgs']]):
        pulumi.set(self, "node_repair_config", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_version", value)

    @property
    @pulumi.getter(name="remoteAccess")
    def remote_access(self) -> Optional[pulumi.Input['NodeGroupRemoteAccessArgs']]:
        """
        Configuration block with remote access settings. See `remote_access` below for details. Conflicts with `launch_template`.
        """
        return pulumi.get(self, "remote_access")

    @remote_access.setter
    def remote_access(self, value: Optional[pulumi.Input['NodeGroupRemoteAccessArgs']]):
        pulumi.set(self, "remote_access", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupTaintArgs']]]]:
        """
        The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="updateConfig")
    def update_config(self) -> Optional[pulumi.Input['NodeGroupUpdateConfigArgs']]:
        """
        Configuration block with update settings. See `update_config` below for details.
        """
        return pulumi.get(self, "update_config")

    @update_config.setter
    def update_config(self, value: Optional[pulumi.Input['NodeGroupUpdateConfigArgs']]):
        pulumi.set(self, "update_config", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _NodeGroupState:
    def __init__(__self__, *,
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_type: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 force_update_version: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input['NodeGroupLaunchTemplateArgs']] = None,
                 node_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_group_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 node_repair_config: Optional[pulumi.Input['NodeGroupNodeRepairConfigArgs']] = None,
                 node_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 release_version: Optional[pulumi.Input[builtins.str]] = None,
                 remote_access: Optional[pulumi.Input['NodeGroupRemoteAccessArgs']] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceArgs']]]] = None,
                 scaling_config: Optional[pulumi.Input['NodeGroupScalingConfigArgs']] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupTaintArgs']]]] = None,
                 update_config: Optional[pulumi.Input['NodeGroupUpdateConfigArgs']] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NodeGroup resources.
        :param pulumi.Input[builtins.str] ami_type: Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the EKS Node Group.
        :param pulumi.Input[builtins.str] capacity_type: Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[builtins.int] disk_size: Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.bool] force_update_version: Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: List of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        :param pulumi.Input['NodeGroupLaunchTemplateArgs'] launch_template: Configuration block with Launch Template settings. See `launch_template` below for details. Conflicts with `remote_access`.
        :param pulumi.Input[builtins.str] node_group_name: Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
        :param pulumi.Input[builtins.str] node_group_name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
        :param pulumi.Input['NodeGroupNodeRepairConfigArgs'] node_repair_config: The node auto repair configuration for the node group. See `node_repair_config` below for details.
        :param pulumi.Input[builtins.str] node_role_arn: Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] release_version: AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        :param pulumi.Input['NodeGroupRemoteAccessArgs'] remote_access: Configuration block with remote access settings. See `remote_access` below for details. Conflicts with `launch_template`.
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceArgs']]] resources: List of objects containing information about underlying resources.
        :param pulumi.Input['NodeGroupScalingConfigArgs'] scaling_config: Configuration block with scaling settings. See `scaling_config` below for details.
        :param pulumi.Input[builtins.str] status: Status of the EKS Node Group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: Identifiers of EC2 Subnets to associate with the EKS Node Group.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupTaintArgs']]] taints: The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
        :param pulumi.Input['NodeGroupUpdateConfigArgs'] update_config: Configuration block with update settings. See `update_config` below for details.
        :param pulumi.Input[builtins.str] version: Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
        """
        if ami_type is not None:
            pulumi.set(__self__, "ami_type", ami_type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if capacity_type is not None:
            pulumi.set(__self__, "capacity_type", capacity_type)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if force_update_version is not None:
            pulumi.set(__self__, "force_update_version", force_update_version)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if node_group_name_prefix is not None:
            pulumi.set(__self__, "node_group_name_prefix", node_group_name_prefix)
        if node_repair_config is not None:
            pulumi.set(__self__, "node_repair_config", node_repair_config)
        if node_role_arn is not None:
            pulumi.set(__self__, "node_role_arn", node_role_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_version is not None:
            pulumi.set(__self__, "release_version", release_version)
        if remote_access is not None:
            pulumi.set(__self__, "remote_access", remote_access)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_config is not None:
            pulumi.set(__self__, "update_config", update_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "ami_type")

    @ami_type.setter
    def ami_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ami_type", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the EKS Node Group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "capacity_type")

    @capacity_type.setter
    def capacity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_type", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="forceUpdateVersion")
    def force_update_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        """
        return pulumi.get(self, "force_update_version")

    @force_update_version.setter
    def force_update_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_update_version", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['NodeGroupLaunchTemplateArgs']]:
        """
        Configuration block with Launch Template settings. See `launch_template` below for details. Conflicts with `remote_access`.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['NodeGroupLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_group_name", value)

    @property
    @pulumi.getter(name="nodeGroupNamePrefix")
    def node_group_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
        """
        return pulumi.get(self, "node_group_name_prefix")

    @node_group_name_prefix.setter
    def node_group_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_group_name_prefix", value)

    @property
    @pulumi.getter(name="nodeRepairConfig")
    def node_repair_config(self) -> Optional[pulumi.Input['NodeGroupNodeRepairConfigArgs']]:
        """
        The node auto repair configuration for the node group. See `node_repair_config` below for details.
        """
        return pulumi.get(self, "node_repair_config")

    @node_repair_config.setter
    def node_repair_config(self, value: Optional[pulumi.Input['NodeGroupNodeRepairConfigArgs']]):
        pulumi.set(self, "node_repair_config", value)

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
        """
        return pulumi.get(self, "node_role_arn")

    @node_role_arn.setter
    def node_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_role_arn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_version", value)

    @property
    @pulumi.getter(name="remoteAccess")
    def remote_access(self) -> Optional[pulumi.Input['NodeGroupRemoteAccessArgs']]:
        """
        Configuration block with remote access settings. See `remote_access` below for details. Conflicts with `launch_template`.
        """
        return pulumi.get(self, "remote_access")

    @remote_access.setter
    def remote_access(self, value: Optional[pulumi.Input['NodeGroupRemoteAccessArgs']]):
        pulumi.set(self, "remote_access", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceArgs']]]]:
        """
        List of objects containing information about underlying resources.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['NodeGroupScalingConfigArgs']]:
        """
        Configuration block with scaling settings. See `scaling_config` below for details.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['NodeGroupScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the EKS Node Group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Identifiers of EC2 Subnets to associate with the EKS Node Group.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupTaintArgs']]]]:
        """
        The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="updateConfig")
    def update_config(self) -> Optional[pulumi.Input['NodeGroupUpdateConfigArgs']]:
        """
        Configuration block with update settings. See `update_config` below for details.
        """
        return pulumi.get(self, "update_config")

    @update_config.setter
    def update_config(self, value: Optional[pulumi.Input['NodeGroupUpdateConfigArgs']]):
        pulumi.set(self, "update_config", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:eks/nodeGroup:NodeGroup")
class NodeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_type: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 force_update_version: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input[Union['NodeGroupLaunchTemplateArgs', 'NodeGroupLaunchTemplateArgsDict']]] = None,
                 node_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_group_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 node_repair_config: Optional[pulumi.Input[Union['NodeGroupNodeRepairConfigArgs', 'NodeGroupNodeRepairConfigArgsDict']]] = None,
                 node_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 release_version: Optional[pulumi.Input[builtins.str]] = None,
                 remote_access: Optional[pulumi.Input[Union['NodeGroupRemoteAccessArgs', 'NodeGroupRemoteAccessArgsDict']]] = None,
                 scaling_config: Optional[pulumi.Input[Union['NodeGroupScalingConfigArgs', 'NodeGroupScalingConfigArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupTaintArgs', 'NodeGroupTaintArgsDict']]]]] = None,
                 update_config: Optional[pulumi.Input[Union['NodeGroupUpdateConfigArgs', 'NodeGroupUpdateConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an EKS Node Group, which can provision and optionally update an Auto Scaling Group of Kubernetes worker nodes compatible with EKS. Additional documentation about this functionality can be found in the [EKS User Guide](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.NodeGroup("example",
            cluster_name=example_aws_eks_cluster["name"],
            node_group_name="example",
            node_role_arn=example_aws_iam_role["arn"],
            subnet_ids=[__item["id"] for __item in example_aws_subnet],
            scaling_config={
                "desired_size": 1,
                "max_size": 2,
                "min_size": 1,
            },
            update_config={
                "max_unavailable": 1,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example__amazon_eks_worker_node_policy,
                    example__amazon_ekscni_policy,
                    example__amazon_ec2_container_registry_read_only,
                ]))
        ```

        ### Ignoring Changes to Desired Size

        You can utilize [ignoreChanges](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) create an EKS Node Group with an initial size of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.NodeGroup("example", scaling_config={
            "desired_size": 2,
        })
        ```

        ### Example IAM Role for EKS Node Group

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.iam.Role("example",
            name="eks-node-group-example",
            assume_role_policy=json.dumps({
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "ec2.amazonaws.com",
                    },
                }],
                "Version": "2012-10-17",
            }))
        example__amazon_eks_worker_node_policy = aws.iam.RolePolicyAttachment("example-AmazonEKSWorkerNodePolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy",
            role=example.name)
        example__amazon_ekscni_policy = aws.iam.RolePolicyAttachment("example-AmazonEKS_CNI_Policy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy",
            role=example.name)
        example__amazon_ec2_container_registry_read_only = aws.iam.RolePolicyAttachment("example-AmazonEC2ContainerRegistryReadOnly",
            policy_arn="arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly",
            role=example.name)
        ```

        ### Example Subnets for EKS Node Group

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        available = aws.get_availability_zones(state="available")
        example = []
        for range in [{"value": i} for i in range(0, 2)]:
            example.append(aws.ec2.Subnet(f"example-{range['value']}",
                availability_zone=available.names[range["value"]],
                cidr_block=std.cidrsubnet(input=example_aws_vpc["cidrBlock"],
                    newbits=8,
                    netnum=range["value"]).result,
                vpc_id=example_aws_vpc["id"]))
        ```

        ## Import

        Using `pulumi import`, import EKS Node Groups using the `cluster_name` and `node_group_name` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:eks/nodeGroup:NodeGroup my_node_group my_cluster:my_node_group
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ami_type: Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.str] capacity_type: Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[builtins.int] disk_size: Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.bool] force_update_version: Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: List of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        :param pulumi.Input[Union['NodeGroupLaunchTemplateArgs', 'NodeGroupLaunchTemplateArgsDict']] launch_template: Configuration block with Launch Template settings. See `launch_template` below for details. Conflicts with `remote_access`.
        :param pulumi.Input[builtins.str] node_group_name: Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
        :param pulumi.Input[builtins.str] node_group_name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
        :param pulumi.Input[Union['NodeGroupNodeRepairConfigArgs', 'NodeGroupNodeRepairConfigArgsDict']] node_repair_config: The node auto repair configuration for the node group. See `node_repair_config` below for details.
        :param pulumi.Input[builtins.str] node_role_arn: Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] release_version: AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        :param pulumi.Input[Union['NodeGroupRemoteAccessArgs', 'NodeGroupRemoteAccessArgsDict']] remote_access: Configuration block with remote access settings. See `remote_access` below for details. Conflicts with `launch_template`.
        :param pulumi.Input[Union['NodeGroupScalingConfigArgs', 'NodeGroupScalingConfigArgsDict']] scaling_config: Configuration block with scaling settings. See `scaling_config` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: Identifiers of EC2 Subnets to associate with the EKS Node Group.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupTaintArgs', 'NodeGroupTaintArgsDict']]]] taints: The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
        :param pulumi.Input[Union['NodeGroupUpdateConfigArgs', 'NodeGroupUpdateConfigArgsDict']] update_config: Configuration block with update settings. See `update_config` below for details.
        :param pulumi.Input[builtins.str] version: Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EKS Node Group, which can provision and optionally update an Auto Scaling Group of Kubernetes worker nodes compatible with EKS. Additional documentation about this functionality can be found in the [EKS User Guide](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.NodeGroup("example",
            cluster_name=example_aws_eks_cluster["name"],
            node_group_name="example",
            node_role_arn=example_aws_iam_role["arn"],
            subnet_ids=[__item["id"] for __item in example_aws_subnet],
            scaling_config={
                "desired_size": 1,
                "max_size": 2,
                "min_size": 1,
            },
            update_config={
                "max_unavailable": 1,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example__amazon_eks_worker_node_policy,
                    example__amazon_ekscni_policy,
                    example__amazon_ec2_container_registry_read_only,
                ]))
        ```

        ### Ignoring Changes to Desired Size

        You can utilize [ignoreChanges](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) create an EKS Node Group with an initial size of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.NodeGroup("example", scaling_config={
            "desired_size": 2,
        })
        ```

        ### Example IAM Role for EKS Node Group

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.iam.Role("example",
            name="eks-node-group-example",
            assume_role_policy=json.dumps({
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "ec2.amazonaws.com",
                    },
                }],
                "Version": "2012-10-17",
            }))
        example__amazon_eks_worker_node_policy = aws.iam.RolePolicyAttachment("example-AmazonEKSWorkerNodePolicy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy",
            role=example.name)
        example__amazon_ekscni_policy = aws.iam.RolePolicyAttachment("example-AmazonEKS_CNI_Policy",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy",
            role=example.name)
        example__amazon_ec2_container_registry_read_only = aws.iam.RolePolicyAttachment("example-AmazonEC2ContainerRegistryReadOnly",
            policy_arn="arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly",
            role=example.name)
        ```

        ### Example Subnets for EKS Node Group

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        available = aws.get_availability_zones(state="available")
        example = []
        for range in [{"value": i} for i in range(0, 2)]:
            example.append(aws.ec2.Subnet(f"example-{range['value']}",
                availability_zone=available.names[range["value"]],
                cidr_block=std.cidrsubnet(input=example_aws_vpc["cidrBlock"],
                    newbits=8,
                    netnum=range["value"]).result,
                vpc_id=example_aws_vpc["id"]))
        ```

        ## Import

        Using `pulumi import`, import EKS Node Groups using the `cluster_name` and `node_group_name` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:eks/nodeGroup:NodeGroup my_node_group my_cluster:my_node_group
        ```

        :param str resource_name: The name of the resource.
        :param NodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_type: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 force_update_version: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input[Union['NodeGroupLaunchTemplateArgs', 'NodeGroupLaunchTemplateArgsDict']]] = None,
                 node_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 node_group_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 node_repair_config: Optional[pulumi.Input[Union['NodeGroupNodeRepairConfigArgs', 'NodeGroupNodeRepairConfigArgsDict']]] = None,
                 node_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 release_version: Optional[pulumi.Input[builtins.str]] = None,
                 remote_access: Optional[pulumi.Input[Union['NodeGroupRemoteAccessArgs', 'NodeGroupRemoteAccessArgsDict']]] = None,
                 scaling_config: Optional[pulumi.Input[Union['NodeGroupScalingConfigArgs', 'NodeGroupScalingConfigArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupTaintArgs', 'NodeGroupTaintArgsDict']]]]] = None,
                 update_config: Optional[pulumi.Input[Union['NodeGroupUpdateConfigArgs', 'NodeGroupUpdateConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeGroupArgs.__new__(NodeGroupArgs)

            __props__.__dict__["ami_type"] = ami_type
            __props__.__dict__["capacity_type"] = capacity_type
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["force_update_version"] = force_update_version
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["node_group_name"] = node_group_name
            __props__.__dict__["node_group_name_prefix"] = node_group_name_prefix
            __props__.__dict__["node_repair_config"] = node_repair_config
            if node_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'node_role_arn'")
            __props__.__dict__["node_role_arn"] = node_role_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["release_version"] = release_version
            __props__.__dict__["remote_access"] = remote_access
            if scaling_config is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_config'")
            __props__.__dict__["scaling_config"] = scaling_config
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["update_config"] = update_config
            __props__.__dict__["version"] = version
            __props__.__dict__["arn"] = None
            __props__.__dict__["resources"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(NodeGroup, __self__).__init__(
            'aws:eks/nodeGroup:NodeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ami_type: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            capacity_type: Optional[pulumi.Input[builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[builtins.str]] = None,
            disk_size: Optional[pulumi.Input[builtins.int]] = None,
            force_update_version: Optional[pulumi.Input[builtins.bool]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            launch_template: Optional[pulumi.Input[Union['NodeGroupLaunchTemplateArgs', 'NodeGroupLaunchTemplateArgsDict']]] = None,
            node_group_name: Optional[pulumi.Input[builtins.str]] = None,
            node_group_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            node_repair_config: Optional[pulumi.Input[Union['NodeGroupNodeRepairConfigArgs', 'NodeGroupNodeRepairConfigArgsDict']]] = None,
            node_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            release_version: Optional[pulumi.Input[builtins.str]] = None,
            remote_access: Optional[pulumi.Input[Union['NodeGroupRemoteAccessArgs', 'NodeGroupRemoteAccessArgsDict']]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupResourceArgs', 'NodeGroupResourceArgsDict']]]]] = None,
            scaling_config: Optional[pulumi.Input[Union['NodeGroupScalingConfigArgs', 'NodeGroupScalingConfigArgsDict']]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupTaintArgs', 'NodeGroupTaintArgsDict']]]]] = None,
            update_config: Optional[pulumi.Input[Union['NodeGroupUpdateConfigArgs', 'NodeGroupUpdateConfigArgsDict']]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'NodeGroup':
        """
        Get an existing NodeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ami_type: Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of the EKS Node Group.
        :param pulumi.Input[builtins.str] capacity_type: Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[builtins.int] disk_size: Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[builtins.bool] force_update_version: Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: List of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. The provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        :param pulumi.Input[Union['NodeGroupLaunchTemplateArgs', 'NodeGroupLaunchTemplateArgsDict']] launch_template: Configuration block with Launch Template settings. See `launch_template` below for details. Conflicts with `remote_access`.
        :param pulumi.Input[builtins.str] node_group_name: Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
        :param pulumi.Input[builtins.str] node_group_name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
        :param pulumi.Input[Union['NodeGroupNodeRepairConfigArgs', 'NodeGroupNodeRepairConfigArgsDict']] node_repair_config: The node auto repair configuration for the node group. See `node_repair_config` below for details.
        :param pulumi.Input[builtins.str] node_role_arn: Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] release_version: AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        :param pulumi.Input[Union['NodeGroupRemoteAccessArgs', 'NodeGroupRemoteAccessArgsDict']] remote_access: Configuration block with remote access settings. See `remote_access` below for details. Conflicts with `launch_template`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupResourceArgs', 'NodeGroupResourceArgsDict']]]] resources: List of objects containing information about underlying resources.
        :param pulumi.Input[Union['NodeGroupScalingConfigArgs', 'NodeGroupScalingConfigArgsDict']] scaling_config: Configuration block with scaling settings. See `scaling_config` below for details.
        :param pulumi.Input[builtins.str] status: Status of the EKS Node Group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: Identifiers of EC2 Subnets to associate with the EKS Node Group.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupTaintArgs', 'NodeGroupTaintArgsDict']]]] taints: The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
        :param pulumi.Input[Union['NodeGroupUpdateConfigArgs', 'NodeGroupUpdateConfigArgsDict']] update_config: Configuration block with update settings. See `update_config` below for details.
        :param pulumi.Input[builtins.str] version: Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeGroupState.__new__(_NodeGroupState)

        __props__.__dict__["ami_type"] = ami_type
        __props__.__dict__["arn"] = arn
        __props__.__dict__["capacity_type"] = capacity_type
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["force_update_version"] = force_update_version
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["labels"] = labels
        __props__.__dict__["launch_template"] = launch_template
        __props__.__dict__["node_group_name"] = node_group_name
        __props__.__dict__["node_group_name_prefix"] = node_group_name_prefix
        __props__.__dict__["node_repair_config"] = node_repair_config
        __props__.__dict__["node_role_arn"] = node_role_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["release_version"] = release_version
        __props__.__dict__["remote_access"] = remote_access
        __props__.__dict__["resources"] = resources
        __props__.__dict__["scaling_config"] = scaling_config
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["taints"] = taints
        __props__.__dict__["update_config"] = update_config
        __props__.__dict__["version"] = version
        return NodeGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "ami_type")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the EKS Node Group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[builtins.int]:
        """
        Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="forceUpdateVersion")
    def force_update_version(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        """
        return pulumi.get(self, "force_update_version")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output[Optional['outputs.NodeGroupLaunchTemplate']]:
        """
        Configuration block with Launch Template settings. See `launch_template` below for details. Conflicts with `remote_access`.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
        """
        return pulumi.get(self, "node_group_name")

    @property
    @pulumi.getter(name="nodeGroupNamePrefix")
    def node_group_name_prefix(self) -> pulumi.Output[builtins.str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
        """
        return pulumi.get(self, "node_group_name_prefix")

    @property
    @pulumi.getter(name="nodeRepairConfig")
    def node_repair_config(self) -> pulumi.Output['outputs.NodeGroupNodeRepairConfig']:
        """
        The node auto repair configuration for the node group. See `node_repair_config` below for details.
        """
        return pulumi.get(self, "node_repair_config")

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
        """
        return pulumi.get(self, "node_role_arn")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> pulumi.Output[builtins.str]:
        """
        AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        """
        return pulumi.get(self, "release_version")

    @property
    @pulumi.getter(name="remoteAccess")
    def remote_access(self) -> pulumi.Output[Optional['outputs.NodeGroupRemoteAccess']]:
        """
        Configuration block with remote access settings. See `remote_access` below for details. Conflicts with `launch_template`.
        """
        return pulumi.get(self, "remote_access")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence['outputs.NodeGroupResource']]:
        """
        List of objects containing information about underlying resources.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Output['outputs.NodeGroupScalingConfig']:
        """
        Configuration block with scaling settings. See `scaling_config` below for details.
        """
        return pulumi.get(self, "scaling_config")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the EKS Node Group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Identifiers of EC2 Subnets to associate with the EKS Node Group.

        The following arguments are optional:
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodeGroupTaint']]]:
        """
        The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="updateConfig")
    def update_config(self) -> pulumi.Output['outputs.NodeGroupUpdateConfig']:
        """
        Configuration block with update settings. See `update_config` below for details.
        """
        return pulumi.get(self, "update_config")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "version")

