# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessPolicyAssociationAccessScope',
    'AddonPodIdentityAssociation',
    'ClusterAccessConfig',
    'ClusterCertificateAuthority',
    'ClusterComputeConfig',
    'ClusterEncryptionConfig',
    'ClusterEncryptionConfigProvider',
    'ClusterIdentity',
    'ClusterIdentityOidc',
    'ClusterKubernetesNetworkConfig',
    'ClusterKubernetesNetworkConfigElasticLoadBalancing',
    'ClusterOutpostConfig',
    'ClusterOutpostConfigControlPlanePlacement',
    'ClusterRemoteNetworkConfig',
    'ClusterRemoteNetworkConfigRemoteNodeNetworks',
    'ClusterRemoteNetworkConfigRemotePodNetworks',
    'ClusterStorageConfig',
    'ClusterStorageConfigBlockStorage',
    'ClusterUpgradePolicy',
    'ClusterVpcConfig',
    'ClusterZonalShiftConfig',
    'FargateProfileSelector',
    'IdentityProviderConfigOidc',
    'NodeGroupLaunchTemplate',
    'NodeGroupNodeRepairConfig',
    'NodeGroupRemoteAccess',
    'NodeGroupResource',
    'NodeGroupResourceAutoscalingGroup',
    'NodeGroupScalingConfig',
    'NodeGroupTaint',
    'NodeGroupUpdateConfig',
    'GetAddonPodIdentityAssociationResult',
    'GetClusterAccessConfigResult',
    'GetClusterCertificateAuthorityResult',
    'GetClusterComputeConfigResult',
    'GetClusterIdentityResult',
    'GetClusterIdentityOidcResult',
    'GetClusterKubernetesNetworkConfigResult',
    'GetClusterKubernetesNetworkConfigElasticLoadBalancingResult',
    'GetClusterOutpostConfigResult',
    'GetClusterOutpostConfigControlPlanePlacementResult',
    'GetClusterRemoteNetworkConfigResult',
    'GetClusterRemoteNetworkConfigRemoteNodeNetworkResult',
    'GetClusterRemoteNetworkConfigRemotePodNetworkResult',
    'GetClusterStorageConfigResult',
    'GetClusterStorageConfigBlockStorageResult',
    'GetClusterUpgradePolicyResult',
    'GetClusterVersionsClusterVersionResult',
    'GetClusterVpcConfigResult',
    'GetClusterZonalShiftConfigResult',
    'GetNodeGroupLaunchTemplateResult',
    'GetNodeGroupRemoteAccessResult',
    'GetNodeGroupResourceResult',
    'GetNodeGroupResourceAutoscalingGroupResult',
    'GetNodeGroupScalingConfigResult',
    'GetNodeGroupTaintResult',
]

@pulumi.output_type
class AccessPolicyAssociationAccessScope(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 namespaces: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str type: Valid values are `namespace` or `cluster`.
        :param Sequence[builtins.str] namespaces: The namespaces to which the access scope applies when type is namespace.
        """
        pulumi.set(__self__, "type", type)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Valid values are `namespace` or `cluster`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[builtins.str]]:
        """
        The namespaces to which the access scope applies when type is namespace.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class AddonPodIdentityAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonPodIdentityAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonPodIdentityAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonPodIdentityAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 service_account: builtins.str):
        """
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the pods that use this service account.
        :param builtins.str service_account: The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the IAM role to associate with the service account. The EKS Pod Identity agent manages credentials to assume this role for applications in the containers in the pods that use this service account.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> builtins.str:
        """
        The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class ClusterAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationMode":
            suggest = "authentication_mode"
        elif key == "bootstrapClusterCreatorAdminPermissions":
            suggest = "bootstrap_cluster_creator_admin_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_mode: Optional[builtins.str] = None,
                 bootstrap_cluster_creator_admin_permissions: Optional[builtins.bool] = None):
        """
        :param builtins.str authentication_mode: The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
        :param builtins.bool bootstrap_cluster_creator_admin_permissions: Whether or not to bootstrap the access config values to the cluster. Default is `false`.
        """
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if bootstrap_cluster_creator_admin_permissions is not None:
            pulumi.set(__self__, "bootstrap_cluster_creator_admin_permissions", bootstrap_cluster_creator_admin_permissions)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[builtins.str]:
        """
        The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
        """
        return pulumi.get(self, "authentication_mode")

    @property
    @pulumi.getter(name="bootstrapClusterCreatorAdminPermissions")
    def bootstrap_cluster_creator_admin_permissions(self) -> Optional[builtins.bool]:
        """
        Whether or not to bootstrap the access config values to the cluster. Default is `false`.
        """
        return pulumi.get(self, "bootstrap_cluster_creator_admin_permissions")


@pulumi.output_type
class ClusterCertificateAuthority(dict):
    def __init__(__self__, *,
                 data: Optional[builtins.str] = None):
        """
        :param builtins.str data: Base64 encoded certificate data required to communicate with your cluster. Add this to the `certificate-authority-data` section of the `kubeconfig` file for your cluster.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> Optional[builtins.str]:
        """
        Base64 encoded certificate data required to communicate with your cluster. Add this to the `certificate-authority-data` section of the `kubeconfig` file for your cluster.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class ClusterComputeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodePools":
            suggest = "node_pools"
        elif key == "nodeRoleArn":
            suggest = "node_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterComputeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterComputeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterComputeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 node_pools: Optional[Sequence[builtins.str]] = None,
                 node_role_arn: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Request to enable or disable the compute capability on your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account.
        :param Sequence[builtins.str] node_pools: Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. Valid options are `general-purpose` and `system`.
        :param builtins.str node_role_arn: The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled..
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if node_role_arn is not None:
            pulumi.set(__self__, "node_role_arn", node_role_arn)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Request to enable or disable the compute capability on your EKS Auto Mode cluster. If the compute capability is enabled, EKS Auto Mode will create and delete EC2 Managed Instances in your Amazon Web Services account.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence[builtins.str]]:
        """
        Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. Valid options are `general-purpose` and `system`.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled..
        """
        return pulumi.get(self, "node_role_arn")


@pulumi.output_type
class ClusterEncryptionConfig(dict):
    def __init__(__self__, *,
                 provider: 'outputs.ClusterEncryptionConfigProvider',
                 resources: Sequence[builtins.str]):
        """
        :param 'ClusterEncryptionConfigProviderArgs' provider: Configuration block with provider for encryption. Detailed below.
        :param Sequence[builtins.str] resources: List of strings with resources to be encrypted. Valid values: `secrets`.
        """
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def provider(self) -> 'outputs.ClusterEncryptionConfigProvider':
        """
        Configuration block with provider for encryption. Detailed below.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[builtins.str]:
        """
        List of strings with resources to be encrypted. Valid values: `secrets`.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ClusterEncryptionConfigProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyArn":
            suggest = "key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionConfigProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionConfigProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionConfigProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_arn: builtins.str):
        """
        :param builtins.str key_arn: ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
        """
        pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> builtins.str:
        """
        ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
        """
        return pulumi.get(self, "key_arn")


@pulumi.output_type
class ClusterIdentity(dict):
    def __init__(__self__, *,
                 oidcs: Optional[Sequence['outputs.ClusterIdentityOidc']] = None):
        """
        :param Sequence['ClusterIdentityOidcArgs'] oidcs: Nested block containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
        """
        if oidcs is not None:
            pulumi.set(__self__, "oidcs", oidcs)

    @property
    @pulumi.getter
    def oidcs(self) -> Optional[Sequence['outputs.ClusterIdentityOidc']]:
        """
        Nested block containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
        """
        return pulumi.get(self, "oidcs")


@pulumi.output_type
class ClusterIdentityOidc(dict):
    def __init__(__self__, *,
                 issuer: Optional[builtins.str] = None):
        """
        :param builtins.str issuer: Issuer URL for the OpenID Connect identity provider.
        """
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        Issuer URL for the OpenID Connect identity provider.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class ClusterKubernetesNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticLoadBalancing":
            suggest = "elastic_load_balancing"
        elif key == "ipFamily":
            suggest = "ip_family"
        elif key == "serviceIpv4Cidr":
            suggest = "service_ipv4_cidr"
        elif key == "serviceIpv6Cidr":
            suggest = "service_ipv6_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterKubernetesNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterKubernetesNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterKubernetesNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elastic_load_balancing: Optional['outputs.ClusterKubernetesNetworkConfigElasticLoadBalancing'] = None,
                 ip_family: Optional[builtins.str] = None,
                 service_ipv4_cidr: Optional[builtins.str] = None,
                 service_ipv6_cidr: Optional[builtins.str] = None):
        """
        :param 'ClusterKubernetesNetworkConfigElasticLoadBalancingArgs' elastic_load_balancing: Configuration block with elastic load balancing configuration for the cluster. Detailed below.
        :param builtins.str ip_family: The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
        :param builtins.str service_ipv4_cidr: The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:
               
               * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.
               
               * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
               
               * Between /24 and /12.
        :param builtins.str service_ipv6_cidr: The CIDR block that Kubernetes pod and service IP addresses are assigned from if you specify `ipv6` for `ip_family` when you create the cluster. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
        """
        if elastic_load_balancing is not None:
            pulumi.set(__self__, "elastic_load_balancing", elastic_load_balancing)
        if ip_family is not None:
            pulumi.set(__self__, "ip_family", ip_family)
        if service_ipv4_cidr is not None:
            pulumi.set(__self__, "service_ipv4_cidr", service_ipv4_cidr)
        if service_ipv6_cidr is not None:
            pulumi.set(__self__, "service_ipv6_cidr", service_ipv6_cidr)

    @property
    @pulumi.getter(name="elasticLoadBalancing")
    def elastic_load_balancing(self) -> Optional['outputs.ClusterKubernetesNetworkConfigElasticLoadBalancing']:
        """
        Configuration block with elastic load balancing configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "elastic_load_balancing")

    @property
    @pulumi.getter(name="ipFamily")
    def ip_family(self) -> Optional[builtins.str]:
        """
        The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
        """
        return pulumi.get(self, "ip_family")

    @property
    @pulumi.getter(name="serviceIpv4Cidr")
    def service_ipv4_cidr(self) -> Optional[builtins.str]:
        """
        The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:

        * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.

        * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.

        * Between /24 and /12.
        """
        return pulumi.get(self, "service_ipv4_cidr")

    @property
    @pulumi.getter(name="serviceIpv6Cidr")
    def service_ipv6_cidr(self) -> Optional[builtins.str]:
        """
        The CIDR block that Kubernetes pod and service IP addresses are assigned from if you specify `ipv6` for `ip_family` when you create the cluster. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
        """
        return pulumi.get(self, "service_ipv6_cidr")


@pulumi.output_type
class ClusterKubernetesNetworkConfigElasticLoadBalancing(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Indicates if the load balancing capability is enabled on your EKS Auto Mode cluster. If the load balancing capability is enabled, EKS Auto Mode will create and delete load balancers in your Amazon Web Services account.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Indicates if the load balancing capability is enabled on your EKS Auto Mode cluster. If the load balancing capability is enabled, EKS Auto Mode will create and delete load balancers in your Amazon Web Services account.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterOutpostConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controlPlaneInstanceType":
            suggest = "control_plane_instance_type"
        elif key == "outpostArns":
            suggest = "outpost_arns"
        elif key == "controlPlanePlacement":
            suggest = "control_plane_placement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOutpostConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOutpostConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOutpostConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 control_plane_instance_type: builtins.str,
                 outpost_arns: Sequence[builtins.str],
                 control_plane_placement: Optional['outputs.ClusterOutpostConfigControlPlanePlacement'] = None):
        """
        :param builtins.str control_plane_instance_type: The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
               
               * 1–20 nodes, then we recommend specifying a large instance type.
               
               * 21–100 nodes, then we recommend specifying an xlarge instance type.
               
               * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
               
               For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
        :param Sequence[builtins.str] outpost_arns: The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
        :param 'ClusterOutpostConfigControlPlanePlacementArgs' control_plane_placement: An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
               The `control_plane_placement` configuration block supports the following arguments:
        """
        pulumi.set(__self__, "control_plane_instance_type", control_plane_instance_type)
        pulumi.set(__self__, "outpost_arns", outpost_arns)
        if control_plane_placement is not None:
            pulumi.set(__self__, "control_plane_placement", control_plane_placement)

    @property
    @pulumi.getter(name="controlPlaneInstanceType")
    def control_plane_instance_type(self) -> builtins.str:
        """
        The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:

        * 1–20 nodes, then we recommend specifying a large instance type.

        * 21–100 nodes, then we recommend specifying an xlarge instance type.

        * 101–250 nodes, then we recommend specifying a 2xlarge instance type.

        For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
        """
        return pulumi.get(self, "control_plane_instance_type")

    @property
    @pulumi.getter(name="outpostArns")
    def outpost_arns(self) -> Sequence[builtins.str]:
        """
        The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
        """
        return pulumi.get(self, "outpost_arns")

    @property
    @pulumi.getter(name="controlPlanePlacement")
    def control_plane_placement(self) -> Optional['outputs.ClusterOutpostConfigControlPlanePlacement']:
        """
        An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
        The `control_plane_placement` configuration block supports the following arguments:
        """
        return pulumi.get(self, "control_plane_placement")


@pulumi.output_type
class ClusterOutpostConfigControlPlanePlacement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOutpostConfigControlPlanePlacement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOutpostConfigControlPlanePlacement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOutpostConfigControlPlanePlacement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: builtins.str):
        """
        :param builtins.str group_name: The name of the placement group for the Kubernetes control plane instances. This setting can't be changed after cluster creation.
        """
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> builtins.str:
        """
        The name of the placement group for the Kubernetes control plane instances. This setting can't be changed after cluster creation.
        """
        return pulumi.get(self, "group_name")


@pulumi.output_type
class ClusterRemoteNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remoteNodeNetworks":
            suggest = "remote_node_networks"
        elif key == "remotePodNetworks":
            suggest = "remote_pod_networks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRemoteNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRemoteNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRemoteNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 remote_node_networks: 'outputs.ClusterRemoteNetworkConfigRemoteNodeNetworks',
                 remote_pod_networks: Optional['outputs.ClusterRemoteNetworkConfigRemotePodNetworks'] = None):
        """
        :param 'ClusterRemoteNetworkConfigRemoteNodeNetworksArgs' remote_node_networks: Configuration block with remote node network configuration for EKS Hybrid Nodes. Detailed below.
        :param 'ClusterRemoteNetworkConfigRemotePodNetworksArgs' remote_pod_networks: Configuration block with remote pod network configuration for EKS Hybrid Nodes. Detailed below.
        """
        pulumi.set(__self__, "remote_node_networks", remote_node_networks)
        if remote_pod_networks is not None:
            pulumi.set(__self__, "remote_pod_networks", remote_pod_networks)

    @property
    @pulumi.getter(name="remoteNodeNetworks")
    def remote_node_networks(self) -> 'outputs.ClusterRemoteNetworkConfigRemoteNodeNetworks':
        """
        Configuration block with remote node network configuration for EKS Hybrid Nodes. Detailed below.
        """
        return pulumi.get(self, "remote_node_networks")

    @property
    @pulumi.getter(name="remotePodNetworks")
    def remote_pod_networks(self) -> Optional['outputs.ClusterRemoteNetworkConfigRemotePodNetworks']:
        """
        Configuration block with remote pod network configuration for EKS Hybrid Nodes. Detailed below.
        """
        return pulumi.get(self, "remote_pod_networks")


@pulumi.output_type
class ClusterRemoteNetworkConfigRemoteNodeNetworks(dict):
    def __init__(__self__, *,
                 cidrs: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] cidrs: List of network CIDRs that can contain hybrid nodes.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        List of network CIDRs that can contain hybrid nodes.
        """
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class ClusterRemoteNetworkConfigRemotePodNetworks(dict):
    def __init__(__self__, *,
                 cidrs: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] cidrs: List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class ClusterStorageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockStorage":
            suggest = "block_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_storage: Optional['outputs.ClusterStorageConfigBlockStorage'] = None):
        """
        :param 'ClusterStorageConfigBlockStorageArgs' block_storage: Configuration block with block storage configuration for the cluster. Detailed below.
        """
        if block_storage is not None:
            pulumi.set(__self__, "block_storage", block_storage)

    @property
    @pulumi.getter(name="blockStorage")
    def block_storage(self) -> Optional['outputs.ClusterStorageConfigBlockStorage']:
        """
        Configuration block with block storage configuration for the cluster. Detailed below.
        """
        return pulumi.get(self, "block_storage")


@pulumi.output_type
class ClusterStorageConfigBlockStorage(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Indicates if the block storage capability is enabled on your EKS Auto Mode cluster. If the block storage capability is enabled, EKS Auto Mode will create and delete block storage volumes in your Amazon Web Services account.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Indicates if the block storage capability is enabled on your EKS Auto Mode cluster. If the block storage capability is enabled, EKS Auto Mode will create and delete block storage volumes in your Amazon Web Services account.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supportType":
            suggest = "support_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 support_type: Optional[builtins.str] = None):
        """
        :param builtins.str support_type: Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
        """
        if support_type is not None:
            pulumi.set(__self__, "support_type", support_type)

    @property
    @pulumi.getter(name="supportType")
    def support_type(self) -> Optional[builtins.str]:
        """
        Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
        """
        return pulumi.get(self, "support_type")


@pulumi.output_type
class ClusterVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "clusterSecurityGroupId":
            suggest = "cluster_security_group_id"
        elif key == "endpointPrivateAccess":
            suggest = "endpoint_private_access"
        elif key == "endpointPublicAccess":
            suggest = "endpoint_public_access"
        elif key == "publicAccessCidrs":
            suggest = "public_access_cidrs"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[builtins.str],
                 cluster_security_group_id: Optional[builtins.str] = None,
                 endpoint_private_access: Optional[builtins.bool] = None,
                 endpoint_public_access: Optional[builtins.bool] = None,
                 public_access_cidrs: Optional[Sequence[builtins.str]] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] subnet_ids: List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
        :param builtins.str cluster_security_group_id: Cluster security group that is created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
        :param builtins.bool endpoint_private_access: Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
        :param builtins.bool endpoint_public_access: Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
        :param Sequence[builtins.str] public_access_cidrs: List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
        :param Sequence[builtins.str] security_group_ids: List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
        :param builtins.str vpc_id: ID of the VPC associated with your cluster.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if cluster_security_group_id is not None:
            pulumi.set(__self__, "cluster_security_group_id", cluster_security_group_id)
        if endpoint_private_access is not None:
            pulumi.set(__self__, "endpoint_private_access", endpoint_private_access)
        if endpoint_public_access is not None:
            pulumi.set(__self__, "endpoint_public_access", endpoint_public_access)
        if public_access_cidrs is not None:
            pulumi.set(__self__, "public_access_cidrs", public_access_cidrs)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="clusterSecurityGroupId")
    def cluster_security_group_id(self) -> Optional[builtins.str]:
        """
        Cluster security group that is created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
        """
        return pulumi.get(self, "cluster_security_group_id")

    @property
    @pulumi.getter(name="endpointPrivateAccess")
    def endpoint_private_access(self) -> Optional[builtins.bool]:
        """
        Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
        """
        return pulumi.get(self, "endpoint_private_access")

    @property
    @pulumi.getter(name="endpointPublicAccess")
    def endpoint_public_access(self) -> Optional[builtins.bool]:
        """
        Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
        """
        return pulumi.get(self, "endpoint_public_access")

    @property
    @pulumi.getter(name="publicAccessCidrs")
    def public_access_cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
        """
        return pulumi.get(self, "public_access_cidrs")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        ID of the VPC associated with your cluster.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class ClusterZonalShiftConfig(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Whether zonal shift is enabled for the cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether zonal shift is enabled for the cluster.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class FargateProfileSelector(dict):
    def __init__(__self__, *,
                 namespace: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str namespace: Kubernetes namespace for selection.
               
               The following arguments are optional:
        :param Mapping[str, builtins.str] labels: Key-value map of Kubernetes labels for selection.
        """
        pulumi.set(__self__, "namespace", namespace)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Kubernetes namespace for selection.

        The following arguments are optional:
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of Kubernetes labels for selection.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class IdentityProviderConfigOidc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "identityProviderConfigName":
            suggest = "identity_provider_config_name"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "groupsClaim":
            suggest = "groups_claim"
        elif key == "groupsPrefix":
            suggest = "groups_prefix"
        elif key == "requiredClaims":
            suggest = "required_claims"
        elif key == "usernameClaim":
            suggest = "username_claim"
        elif key == "usernamePrefix":
            suggest = "username_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityProviderConfigOidc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityProviderConfigOidc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityProviderConfigOidc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: builtins.str,
                 identity_provider_config_name: builtins.str,
                 issuer_url: builtins.str,
                 groups_claim: Optional[builtins.str] = None,
                 groups_prefix: Optional[builtins.str] = None,
                 required_claims: Optional[Mapping[str, builtins.str]] = None,
                 username_claim: Optional[builtins.str] = None,
                 username_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str client_id: Client ID for the OpenID Connect identity provider.
        :param builtins.str identity_provider_config_name: The name of the identity provider config.
        :param builtins.str issuer_url: Issuer URL for the OpenID Connect identity provider.
        :param builtins.str groups_claim: The JWT claim that the provider will use to return groups.
        :param builtins.str groups_prefix: A prefix that is prepended to group claims e.g., `oidc:`.
        :param Mapping[str, builtins.str] required_claims: The key value pairs that describe required claims in the identity token.
        :param builtins.str username_claim: The JWT claim that the provider will use as the username.
        :param builtins.str username_prefix: A prefix that is prepended to username claims.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "identity_provider_config_name", identity_provider_config_name)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        """
        Client ID for the OpenID Connect identity provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="identityProviderConfigName")
    def identity_provider_config_name(self) -> builtins.str:
        """
        The name of the identity provider config.
        """
        return pulumi.get(self, "identity_provider_config_name")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> builtins.str:
        """
        Issuer URL for the OpenID Connect identity provider.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[builtins.str]:
        """
        The JWT claim that the provider will use to return groups.
        """
        return pulumi.get(self, "groups_claim")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[builtins.str]:
        """
        A prefix that is prepended to group claims e.g., `oidc:`.
        """
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The key value pairs that describe required claims in the identity token.
        """
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[builtins.str]:
        """
        The JWT claim that the provider will use as the username.
        """
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[builtins.str]:
        """
        A prefix that is prepended to username claims.
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class NodeGroupLaunchTemplate(dict):
    def __init__(__self__, *,
                 version: builtins.str,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str version: EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `ec2.LaunchTemplate` resource or data source is recommended for this argument.
        :param builtins.str id: Identifier of the EC2 Launch Template. Conflicts with `name`.
        :param builtins.str name: Name of the EC2 Launch Template. Conflicts with `id`.
        """
        pulumi.set(__self__, "version", version)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `ec2.LaunchTemplate` resource or data source is recommended for this argument.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Identifier of the EC2 Launch Template. Conflicts with `name`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the EC2 Launch Template. Conflicts with `id`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NodeGroupNodeRepairConfig(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable node auto repair for the node group. Node auto repair is disabled by default.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class NodeGroupRemoteAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ec2SshKey":
            suggest = "ec2_ssh_key"
        elif key == "sourceSecurityGroupIds":
            suggest = "source_security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupRemoteAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupRemoteAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupRemoteAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ec2_ssh_key: Optional[builtins.str] = None,
                 source_security_group_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str ec2_ssh_key: EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
        :param Sequence[builtins.str] source_security_group_ids: Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
        """
        if ec2_ssh_key is not None:
            pulumi.set(__self__, "ec2_ssh_key", ec2_ssh_key)
        if source_security_group_ids is not None:
            pulumi.set(__self__, "source_security_group_ids", source_security_group_ids)

    @property
    @pulumi.getter(name="ec2SshKey")
    def ec2_ssh_key(self) -> Optional[builtins.str]:
        """
        EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
        """
        return pulumi.get(self, "ec2_ssh_key")

    @property
    @pulumi.getter(name="sourceSecurityGroupIds")
    def source_security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
        """
        return pulumi.get(self, "source_security_group_ids")


@pulumi.output_type
class NodeGroupResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingGroups":
            suggest = "autoscaling_groups"
        elif key == "remoteAccessSecurityGroupId":
            suggest = "remote_access_security_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_groups: Optional[Sequence['outputs.NodeGroupResourceAutoscalingGroup']] = None,
                 remote_access_security_group_id: Optional[builtins.str] = None):
        """
        :param Sequence['NodeGroupResourceAutoscalingGroupArgs'] autoscaling_groups: List of objects containing information about AutoScaling Groups.
        :param builtins.str remote_access_security_group_id: Identifier of the remote access EC2 Security Group.
        """
        if autoscaling_groups is not None:
            pulumi.set(__self__, "autoscaling_groups", autoscaling_groups)
        if remote_access_security_group_id is not None:
            pulumi.set(__self__, "remote_access_security_group_id", remote_access_security_group_id)

    @property
    @pulumi.getter(name="autoscalingGroups")
    def autoscaling_groups(self) -> Optional[Sequence['outputs.NodeGroupResourceAutoscalingGroup']]:
        """
        List of objects containing information about AutoScaling Groups.
        """
        return pulumi.get(self, "autoscaling_groups")

    @property
    @pulumi.getter(name="remoteAccessSecurityGroupId")
    def remote_access_security_group_id(self) -> Optional[builtins.str]:
        """
        Identifier of the remote access EC2 Security Group.
        """
        return pulumi.get(self, "remote_access_security_group_id")


@pulumi.output_type
class NodeGroupResourceAutoscalingGroup(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the AutoScaling Group.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the AutoScaling Group.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NodeGroupScalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredSize":
            suggest = "desired_size"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_size: builtins.int,
                 max_size: builtins.int,
                 min_size: builtins.int):
        """
        :param builtins.int desired_size: Desired number of worker nodes.
        :param builtins.int max_size: Maximum number of worker nodes.
        :param builtins.int min_size: Minimum number of worker nodes.
        """
        pulumi.set(__self__, "desired_size", desired_size)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> builtins.int:
        """
        Desired number of worker nodes.
        """
        return pulumi.get(self, "desired_size")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.int:
        """
        Maximum number of worker nodes.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.int:
        """
        Minimum number of worker nodes.
        """
        return pulumi.get(self, "min_size")


@pulumi.output_type
class NodeGroupTaint(dict):
    def __init__(__self__, *,
                 effect: builtins.str,
                 key: builtins.str,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str effect: The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
        :param builtins.str key: The key of the taint. Maximum length of 63.
        :param builtins.str value: The value of the taint. Maximum length of 63.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> builtins.str:
        """
        The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the taint. Maximum length of 63.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the taint. Maximum length of 63.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodeGroupUpdateConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"
        elif key == "maxUnavailablePercentage":
            suggest = "max_unavailable_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupUpdateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupUpdateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupUpdateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[builtins.int] = None,
                 max_unavailable_percentage: Optional[builtins.int] = None):
        """
        :param builtins.int max_unavailable: Desired max number of unavailable worker nodes during node group update.
        :param builtins.int max_unavailable_percentage: Desired max percentage of unavailable worker nodes during node group update.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if max_unavailable_percentage is not None:
            pulumi.set(__self__, "max_unavailable_percentage", max_unavailable_percentage)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[builtins.int]:
        """
        Desired max number of unavailable worker nodes during node group update.
        """
        return pulumi.get(self, "max_unavailable")

    @property
    @pulumi.getter(name="maxUnavailablePercentage")
    def max_unavailable_percentage(self) -> Optional[builtins.int]:
        """
        Desired max percentage of unavailable worker nodes during node group update.
        """
        return pulumi.get(self, "max_unavailable_percentage")


@pulumi.output_type
class GetAddonPodIdentityAssociationResult(dict):
    def __init__(__self__, *,
                 role_arn: builtins.str,
                 service_account: builtins.str):
        """
        :param builtins.str role_arn: ARN of the IAM role associated with the EKS add-on.
        :param builtins.str service_account: Service account associated with the EKS add-on.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        ARN of the IAM role associated with the EKS add-on.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> builtins.str:
        """
        Service account associated with the EKS add-on.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class GetClusterAccessConfigResult(dict):
    def __init__(__self__, *,
                 authentication_mode: builtins.str,
                 bootstrap_cluster_creator_admin_permissions: builtins.bool):
        """
        :param builtins.str authentication_mode: Values returned are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
        :param builtins.bool bootstrap_cluster_creator_admin_permissions: Default to `true`.
        """
        pulumi.set(__self__, "authentication_mode", authentication_mode)
        pulumi.set(__self__, "bootstrap_cluster_creator_admin_permissions", bootstrap_cluster_creator_admin_permissions)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> builtins.str:
        """
        Values returned are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
        """
        return pulumi.get(self, "authentication_mode")

    @property
    @pulumi.getter(name="bootstrapClusterCreatorAdminPermissions")
    def bootstrap_cluster_creator_admin_permissions(self) -> builtins.bool:
        """
        Default to `true`.
        """
        return pulumi.get(self, "bootstrap_cluster_creator_admin_permissions")


@pulumi.output_type
class GetClusterCertificateAuthorityResult(dict):
    def __init__(__self__, *,
                 data: builtins.str):
        """
        :param builtins.str data: The base64 encoded certificate data required to communicate with your cluster. Add this to the `certificate-authority-data` section of the `kubeconfig` file for your cluster.
        """
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> builtins.str:
        """
        The base64 encoded certificate data required to communicate with your cluster. Add this to the `certificate-authority-data` section of the `kubeconfig` file for your cluster.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class GetClusterComputeConfigResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 node_pools: Sequence[builtins.str],
                 node_role_arn: builtins.str):
        """
        :param builtins.bool enabled: Whether zonal shift is enabled.
        :param Sequence[builtins.str] node_pools: List of node pools for the EKS Auto Mode compute capability.
        :param builtins.str node_role_arn: The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "node_pools", node_pools)
        pulumi.set(__self__, "node_role_arn", node_role_arn)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether zonal shift is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Sequence[builtins.str]:
        """
        List of node pools for the EKS Auto Mode compute capability.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> builtins.str:
        """
        The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster.
        """
        return pulumi.get(self, "node_role_arn")


@pulumi.output_type
class GetClusterIdentityResult(dict):
    def __init__(__self__, *,
                 oidcs: Sequence['outputs.GetClusterIdentityOidcResult']):
        """
        :param Sequence['GetClusterIdentityOidcArgs'] oidcs: Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster.
        """
        pulumi.set(__self__, "oidcs", oidcs)

    @property
    @pulumi.getter
    def oidcs(self) -> Sequence['outputs.GetClusterIdentityOidcResult']:
        """
        Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster.
        """
        return pulumi.get(self, "oidcs")


@pulumi.output_type
class GetClusterIdentityOidcResult(dict):
    def __init__(__self__, *,
                 issuer: builtins.str):
        """
        :param builtins.str issuer: Issuer URL for the OpenID Connect identity provider.
        """
        pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        Issuer URL for the OpenID Connect identity provider.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class GetClusterKubernetesNetworkConfigResult(dict):
    def __init__(__self__, *,
                 elastic_load_balancings: Sequence['outputs.GetClusterKubernetesNetworkConfigElasticLoadBalancingResult'],
                 ip_family: builtins.str,
                 service_ipv4_cidr: builtins.str,
                 service_ipv6_cidr: builtins.str):
        """
        :param Sequence['GetClusterKubernetesNetworkConfigElasticLoadBalancingArgs'] elastic_load_balancings: Contains Elastic Load Balancing configuration for EKS Auto Mode enabled cluster.
        :param builtins.str ip_family: `ipv4` or `ipv6`.
        :param builtins.str service_ipv4_cidr: The CIDR block to assign Kubernetes pod and service IP addresses from if `ipv4` was specified when the cluster was created.
        :param builtins.str service_ipv6_cidr: The CIDR block to assign Kubernetes pod and service IP addresses from if `ipv6` was specified when the cluster was created. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
        """
        pulumi.set(__self__, "elastic_load_balancings", elastic_load_balancings)
        pulumi.set(__self__, "ip_family", ip_family)
        pulumi.set(__self__, "service_ipv4_cidr", service_ipv4_cidr)
        pulumi.set(__self__, "service_ipv6_cidr", service_ipv6_cidr)

    @property
    @pulumi.getter(name="elasticLoadBalancings")
    def elastic_load_balancings(self) -> Sequence['outputs.GetClusterKubernetesNetworkConfigElasticLoadBalancingResult']:
        """
        Contains Elastic Load Balancing configuration for EKS Auto Mode enabled cluster.
        """
        return pulumi.get(self, "elastic_load_balancings")

    @property
    @pulumi.getter(name="ipFamily")
    def ip_family(self) -> builtins.str:
        """
        `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_family")

    @property
    @pulumi.getter(name="serviceIpv4Cidr")
    def service_ipv4_cidr(self) -> builtins.str:
        """
        The CIDR block to assign Kubernetes pod and service IP addresses from if `ipv4` was specified when the cluster was created.
        """
        return pulumi.get(self, "service_ipv4_cidr")

    @property
    @pulumi.getter(name="serviceIpv6Cidr")
    def service_ipv6_cidr(self) -> builtins.str:
        """
        The CIDR block to assign Kubernetes pod and service IP addresses from if `ipv6` was specified when the cluster was created. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
        """
        return pulumi.get(self, "service_ipv6_cidr")


@pulumi.output_type
class GetClusterKubernetesNetworkConfigElasticLoadBalancingResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Whether zonal shift is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether zonal shift is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterOutpostConfigResult(dict):
    def __init__(__self__, *,
                 control_plane_instance_type: builtins.str,
                 control_plane_placements: Sequence['outputs.GetClusterOutpostConfigControlPlanePlacementResult'],
                 outpost_arns: Sequence[builtins.str]):
        """
        :param builtins.str control_plane_instance_type: The Amazon EC2 instance type for all Kubernetes control plane instances.
        :param Sequence['GetClusterOutpostConfigControlPlanePlacementArgs'] control_plane_placements: An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
        :param Sequence[builtins.str] outpost_arns: List of ARNs of the Outposts hosting the EKS cluster. Only a single ARN is supported currently.
        """
        pulumi.set(__self__, "control_plane_instance_type", control_plane_instance_type)
        pulumi.set(__self__, "control_plane_placements", control_plane_placements)
        pulumi.set(__self__, "outpost_arns", outpost_arns)

    @property
    @pulumi.getter(name="controlPlaneInstanceType")
    def control_plane_instance_type(self) -> builtins.str:
        """
        The Amazon EC2 instance type for all Kubernetes control plane instances.
        """
        return pulumi.get(self, "control_plane_instance_type")

    @property
    @pulumi.getter(name="controlPlanePlacements")
    def control_plane_placements(self) -> Sequence['outputs.GetClusterOutpostConfigControlPlanePlacementResult']:
        """
        An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
        """
        return pulumi.get(self, "control_plane_placements")

    @property
    @pulumi.getter(name="outpostArns")
    def outpost_arns(self) -> Sequence[builtins.str]:
        """
        List of ARNs of the Outposts hosting the EKS cluster. Only a single ARN is supported currently.
        """
        return pulumi.get(self, "outpost_arns")


@pulumi.output_type
class GetClusterOutpostConfigControlPlanePlacementResult(dict):
    def __init__(__self__, *,
                 group_name: builtins.str):
        """
        :param builtins.str group_name: The name of the placement group for the Kubernetes control plane instances.
        """
        pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> builtins.str:
        """
        The name of the placement group for the Kubernetes control plane instances.
        """
        return pulumi.get(self, "group_name")


@pulumi.output_type
class GetClusterRemoteNetworkConfigResult(dict):
    def __init__(__self__, *,
                 remote_node_networks: Sequence['outputs.GetClusterRemoteNetworkConfigRemoteNodeNetworkResult'],
                 remote_pod_networks: Sequence['outputs.GetClusterRemoteNetworkConfigRemotePodNetworkResult']):
        """
        :param Sequence['GetClusterRemoteNetworkConfigRemoteNodeNetworkArgs'] remote_node_networks: The networks that can contain hybrid nodes.
        :param Sequence['GetClusterRemoteNetworkConfigRemotePodNetworkArgs'] remote_pod_networks: The networks that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        pulumi.set(__self__, "remote_node_networks", remote_node_networks)
        pulumi.set(__self__, "remote_pod_networks", remote_pod_networks)

    @property
    @pulumi.getter(name="remoteNodeNetworks")
    def remote_node_networks(self) -> Sequence['outputs.GetClusterRemoteNetworkConfigRemoteNodeNetworkResult']:
        """
        The networks that can contain hybrid nodes.
        """
        return pulumi.get(self, "remote_node_networks")

    @property
    @pulumi.getter(name="remotePodNetworks")
    def remote_pod_networks(self) -> Sequence['outputs.GetClusterRemoteNetworkConfigRemotePodNetworkResult']:
        """
        The networks that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        return pulumi.get(self, "remote_pod_networks")


@pulumi.output_type
class GetClusterRemoteNetworkConfigRemoteNodeNetworkResult(dict):
    def __init__(__self__, *,
                 cidrs: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] cidrs: List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Sequence[builtins.str]:
        """
        List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class GetClusterRemoteNetworkConfigRemotePodNetworkResult(dict):
    def __init__(__self__, *,
                 cidrs: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] cidrs: List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Sequence[builtins.str]:
        """
        List of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
        """
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class GetClusterStorageConfigResult(dict):
    def __init__(__self__, *,
                 block_storages: Sequence['outputs.GetClusterStorageConfigBlockStorageResult']):
        """
        :param Sequence['GetClusterStorageConfigBlockStorageArgs'] block_storages: Contains block storage configuration for EKS Auto Mode enabled cluster.
        """
        pulumi.set(__self__, "block_storages", block_storages)

    @property
    @pulumi.getter(name="blockStorages")
    def block_storages(self) -> Sequence['outputs.GetClusterStorageConfigBlockStorageResult']:
        """
        Contains block storage configuration for EKS Auto Mode enabled cluster.
        """
        return pulumi.get(self, "block_storages")


@pulumi.output_type
class GetClusterStorageConfigBlockStorageResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Whether zonal shift is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether zonal shift is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetClusterUpgradePolicyResult(dict):
    def __init__(__self__, *,
                 support_type: builtins.str):
        """
        :param builtins.str support_type: Support type to use for the cluster.
        """
        pulumi.set(__self__, "support_type", support_type)

    @property
    @pulumi.getter(name="supportType")
    def support_type(self) -> builtins.str:
        """
        Support type to use for the cluster.
        """
        return pulumi.get(self, "support_type")


@pulumi.output_type
class GetClusterVersionsClusterVersionResult(dict):
    def __init__(__self__, *,
                 cluster_type: builtins.str,
                 cluster_version: builtins.str,
                 default_platform_version: builtins.str,
                 default_version: builtins.bool,
                 end_of_extended_support_date: builtins.str,
                 end_of_standard_support_date: builtins.str,
                 kubernetes_patch_version: builtins.str,
                 release_date: builtins.str,
                 version_status: builtins.str):
        """
        :param builtins.str cluster_type: Type of clusters to filter by.
               Currently, the only valid value is `eks`.
        :param builtins.str cluster_version: Kubernetes version supported by EKS.
        :param builtins.str default_platform_version: Default eks platform version for the cluster version.
        :param builtins.bool default_version: Default Kubernetes version for the cluster version.
        :param builtins.str end_of_extended_support_date: End of extended support date for the cluster version.
        :param builtins.str end_of_standard_support_date: End of standard support date for the cluster version.
        :param builtins.str kubernetes_patch_version: Kubernetes patch version for the cluster version.
        :param builtins.str release_date: Release date of the cluster version.
        :param builtins.str version_status: Status of the EKS cluster versions to list.
               Valid values are `STANDARD_SUPPORT` or `UNSUPPORTED` or `EXTENDED_SUPPORT`.
        """
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "default_platform_version", default_platform_version)
        pulumi.set(__self__, "default_version", default_version)
        pulumi.set(__self__, "end_of_extended_support_date", end_of_extended_support_date)
        pulumi.set(__self__, "end_of_standard_support_date", end_of_standard_support_date)
        pulumi.set(__self__, "kubernetes_patch_version", kubernetes_patch_version)
        pulumi.set(__self__, "release_date", release_date)
        pulumi.set(__self__, "version_status", version_status)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> builtins.str:
        """
        Type of clusters to filter by.
        Currently, the only valid value is `eks`.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> builtins.str:
        """
        Kubernetes version supported by EKS.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="defaultPlatformVersion")
    def default_platform_version(self) -> builtins.str:
        """
        Default eks platform version for the cluster version.
        """
        return pulumi.get(self, "default_platform_version")

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> builtins.bool:
        """
        Default Kubernetes version for the cluster version.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter(name="endOfExtendedSupportDate")
    def end_of_extended_support_date(self) -> builtins.str:
        """
        End of extended support date for the cluster version.
        """
        return pulumi.get(self, "end_of_extended_support_date")

    @property
    @pulumi.getter(name="endOfStandardSupportDate")
    def end_of_standard_support_date(self) -> builtins.str:
        """
        End of standard support date for the cluster version.
        """
        return pulumi.get(self, "end_of_standard_support_date")

    @property
    @pulumi.getter(name="kubernetesPatchVersion")
    def kubernetes_patch_version(self) -> builtins.str:
        """
        Kubernetes patch version for the cluster version.
        """
        return pulumi.get(self, "kubernetes_patch_version")

    @property
    @pulumi.getter(name="releaseDate")
    def release_date(self) -> builtins.str:
        """
        Release date of the cluster version.
        """
        return pulumi.get(self, "release_date")

    @property
    @pulumi.getter(name="versionStatus")
    def version_status(self) -> builtins.str:
        """
        Status of the EKS cluster versions to list.
        Valid values are `STANDARD_SUPPORT` or `UNSUPPORTED` or `EXTENDED_SUPPORT`.
        """
        return pulumi.get(self, "version_status")


@pulumi.output_type
class GetClusterVpcConfigResult(dict):
    def __init__(__self__, *,
                 cluster_security_group_id: builtins.str,
                 endpoint_private_access: builtins.bool,
                 endpoint_public_access: builtins.bool,
                 public_access_cidrs: Sequence[builtins.str],
                 security_group_ids: Sequence[builtins.str],
                 subnet_ids: Sequence[builtins.str],
                 vpc_id: builtins.str):
        """
        :param builtins.str cluster_security_group_id: The cluster security group that was created by Amazon EKS for the cluster.
        :param builtins.bool endpoint_private_access: Indicates whether or not the Amazon EKS private API server endpoint is enabled.
        :param builtins.bool endpoint_public_access: Indicates whether or not the Amazon EKS public API server endpoint is enabled.
        :param Sequence[builtins.str] public_access_cidrs: List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint.
        :param Sequence[builtins.str] security_group_ids: List of security group IDs
        :param Sequence[builtins.str] subnet_ids: List of subnet IDs
        :param builtins.str vpc_id: The VPC associated with your cluster.
        """
        pulumi.set(__self__, "cluster_security_group_id", cluster_security_group_id)
        pulumi.set(__self__, "endpoint_private_access", endpoint_private_access)
        pulumi.set(__self__, "endpoint_public_access", endpoint_public_access)
        pulumi.set(__self__, "public_access_cidrs", public_access_cidrs)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="clusterSecurityGroupId")
    def cluster_security_group_id(self) -> builtins.str:
        """
        The cluster security group that was created by Amazon EKS for the cluster.
        """
        return pulumi.get(self, "cluster_security_group_id")

    @property
    @pulumi.getter(name="endpointPrivateAccess")
    def endpoint_private_access(self) -> builtins.bool:
        """
        Indicates whether or not the Amazon EKS private API server endpoint is enabled.
        """
        return pulumi.get(self, "endpoint_private_access")

    @property
    @pulumi.getter(name="endpointPublicAccess")
    def endpoint_public_access(self) -> builtins.bool:
        """
        Indicates whether or not the Amazon EKS public API server endpoint is enabled.
        """
        return pulumi.get(self, "endpoint_public_access")

    @property
    @pulumi.getter(name="publicAccessCidrs")
    def public_access_cidrs(self) -> Sequence[builtins.str]:
        """
        List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint.
        """
        return pulumi.get(self, "public_access_cidrs")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        List of security group IDs
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        List of subnet IDs
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The VPC associated with your cluster.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetClusterZonalShiftConfigResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Whether zonal shift is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether zonal shift is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetNodeGroupLaunchTemplateResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str id: The ID of the launch template.
        :param builtins.str name: Name of the AutoScaling Group.
        :param builtins.str version: Kubernetes version.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the launch template.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the AutoScaling Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Kubernetes version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetNodeGroupRemoteAccessResult(dict):
    def __init__(__self__, *,
                 ec2_ssh_key: builtins.str,
                 source_security_group_ids: Sequence[builtins.str]):
        """
        :param builtins.str ec2_ssh_key: EC2 Key Pair name that provides access for SSH communication with the worker nodes in the EKS Node Group.
        :param Sequence[builtins.str] source_security_group_ids: Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes.
        """
        pulumi.set(__self__, "ec2_ssh_key", ec2_ssh_key)
        pulumi.set(__self__, "source_security_group_ids", source_security_group_ids)

    @property
    @pulumi.getter(name="ec2SshKey")
    def ec2_ssh_key(self) -> builtins.str:
        """
        EC2 Key Pair name that provides access for SSH communication with the worker nodes in the EKS Node Group.
        """
        return pulumi.get(self, "ec2_ssh_key")

    @property
    @pulumi.getter(name="sourceSecurityGroupIds")
    def source_security_group_ids(self) -> Sequence[builtins.str]:
        """
        Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes.
        """
        return pulumi.get(self, "source_security_group_ids")


@pulumi.output_type
class GetNodeGroupResourceResult(dict):
    def __init__(__self__, *,
                 autoscaling_groups: Sequence['outputs.GetNodeGroupResourceAutoscalingGroupResult'],
                 remote_access_security_group_id: builtins.str):
        """
        :param Sequence['GetNodeGroupResourceAutoscalingGroupArgs'] autoscaling_groups: List of objects containing information about AutoScaling Groups.
        :param builtins.str remote_access_security_group_id: Identifier of the remote access EC2 Security Group.
        """
        pulumi.set(__self__, "autoscaling_groups", autoscaling_groups)
        pulumi.set(__self__, "remote_access_security_group_id", remote_access_security_group_id)

    @property
    @pulumi.getter(name="autoscalingGroups")
    def autoscaling_groups(self) -> Sequence['outputs.GetNodeGroupResourceAutoscalingGroupResult']:
        """
        List of objects containing information about AutoScaling Groups.
        """
        return pulumi.get(self, "autoscaling_groups")

    @property
    @pulumi.getter(name="remoteAccessSecurityGroupId")
    def remote_access_security_group_id(self) -> builtins.str:
        """
        Identifier of the remote access EC2 Security Group.
        """
        return pulumi.get(self, "remote_access_security_group_id")


@pulumi.output_type
class GetNodeGroupResourceAutoscalingGroupResult(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: Name of the AutoScaling Group.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the AutoScaling Group.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetNodeGroupScalingConfigResult(dict):
    def __init__(__self__, *,
                 desired_size: builtins.int,
                 max_size: builtins.int,
                 min_size: builtins.int):
        """
        :param builtins.int desired_size: Desired number of worker nodes.
        :param builtins.int max_size: Maximum number of worker nodes.
        :param builtins.int min_size: Minimum number of worker nodes.
        """
        pulumi.set(__self__, "desired_size", desired_size)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> builtins.int:
        """
        Desired number of worker nodes.
        """
        return pulumi.get(self, "desired_size")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.int:
        """
        Maximum number of worker nodes.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.int:
        """
        Minimum number of worker nodes.
        """
        return pulumi.get(self, "min_size")


@pulumi.output_type
class GetNodeGroupTaintResult(dict):
    def __init__(__self__, *,
                 effect: builtins.str,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str effect: The effect of the taint.
        :param builtins.str key: The key of the taint.
        :param builtins.str value: The value of the taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> builtins.str:
        """
        The effect of the taint.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the taint.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the taint.
        """
        return pulumi.get(self, "value")


