# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetReservedCacheNodeOfferingResult',
    'AwaitableGetReservedCacheNodeOfferingResult',
    'get_reserved_cache_node_offering',
    'get_reserved_cache_node_offering_output',
]

@pulumi.output_type
class GetReservedCacheNodeOfferingResult:
    """
    A collection of values returned by getReservedCacheNodeOffering.
    """
    def __init__(__self__, cache_node_type=None, duration=None, fixed_price=None, id=None, offering_id=None, offering_type=None, product_description=None, region=None):
        if cache_node_type and not isinstance(cache_node_type, str):
            raise TypeError("Expected argument 'cache_node_type' to be a str")
        pulumi.set(__self__, "cache_node_type", cache_node_type)
        if duration and not isinstance(duration, str):
            raise TypeError("Expected argument 'duration' to be a str")
        pulumi.set(__self__, "duration", duration)
        if fixed_price and not isinstance(fixed_price, float):
            raise TypeError("Expected argument 'fixed_price' to be a float")
        pulumi.set(__self__, "fixed_price", fixed_price)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if offering_id and not isinstance(offering_id, str):
            raise TypeError("Expected argument 'offering_id' to be a str")
        pulumi.set(__self__, "offering_id", offering_id)
        if offering_type and not isinstance(offering_type, str):
            raise TypeError("Expected argument 'offering_type' to be a str")
        pulumi.set(__self__, "offering_type", offering_type)
        if product_description and not isinstance(product_description, str):
            raise TypeError("Expected argument 'product_description' to be a str")
        pulumi.set(__self__, "product_description", product_description)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="cacheNodeType")
    def cache_node_type(self) -> builtins.str:
        return pulumi.get(self, "cache_node_type")

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="fixedPrice")
    def fixed_price(self) -> builtins.float:
        """
        Fixed price charged for this reserved cache node.
        """
        return pulumi.get(self, "fixed_price")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="offeringId")
    def offering_id(self) -> builtins.str:
        """
        Unique identifier for the reservation.
        """
        return pulumi.get(self, "offering_id")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> builtins.str:
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="productDescription")
    def product_description(self) -> builtins.str:
        return pulumi.get(self, "product_description")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetReservedCacheNodeOfferingResult(GetReservedCacheNodeOfferingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReservedCacheNodeOfferingResult(
            cache_node_type=self.cache_node_type,
            duration=self.duration,
            fixed_price=self.fixed_price,
            id=self.id,
            offering_id=self.offering_id,
            offering_type=self.offering_type,
            product_description=self.product_description,
            region=self.region)


def get_reserved_cache_node_offering(cache_node_type: Optional[builtins.str] = None,
                                     duration: Optional[builtins.str] = None,
                                     offering_type: Optional[builtins.str] = None,
                                     product_description: Optional[builtins.str] = None,
                                     region: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReservedCacheNodeOfferingResult:
    """
    Information about a single ElastiCache Reserved Cache Node Offering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.elasticache.get_reserved_cache_node_offering(cache_node_type="cache.t4g.small",
        duration="P1Y",
        offering_type="No Upfront",
        product_description="redis")
    ```


    :param builtins.str cache_node_type: Node type for the reserved cache node.
           See AWS documentation for information on [supported node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
           See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/nodes-select-size.html).
    :param builtins.str duration: Duration of the reservation in RFC3339 duration format.
           Valid values are `P1Y` (one year) and `P3Y` (three years).
    :param builtins.str offering_type: Offering type of this reserved cache node.
           For the latest generation of nodes (e.g. M5, R5, T4 and newer) valid values are `No Upfront`, `Partial Upfront`, and `All Upfront`.
           For other current generation nodes (i.e. T2, M3, M4, R3, or R4) the only valid value is `Heavy Utilization`.
           For previous generation modes (i.e. T1, M1, M2, or C1) valid values are `Heavy Utilization`, `Medium Utilization`, and `Light Utilization`.
    :param builtins.str product_description: Engine type for the reserved cache node.
           Valid values are `redis`, `valkey` and `memcached`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['cacheNodeType'] = cache_node_type
    __args__['duration'] = duration
    __args__['offeringType'] = offering_type
    __args__['productDescription'] = product_description
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:elasticache/getReservedCacheNodeOffering:getReservedCacheNodeOffering', __args__, opts=opts, typ=GetReservedCacheNodeOfferingResult).value

    return AwaitableGetReservedCacheNodeOfferingResult(
        cache_node_type=pulumi.get(__ret__, 'cache_node_type'),
        duration=pulumi.get(__ret__, 'duration'),
        fixed_price=pulumi.get(__ret__, 'fixed_price'),
        id=pulumi.get(__ret__, 'id'),
        offering_id=pulumi.get(__ret__, 'offering_id'),
        offering_type=pulumi.get(__ret__, 'offering_type'),
        product_description=pulumi.get(__ret__, 'product_description'),
        region=pulumi.get(__ret__, 'region'))
def get_reserved_cache_node_offering_output(cache_node_type: Optional[pulumi.Input[builtins.str]] = None,
                                            duration: Optional[pulumi.Input[builtins.str]] = None,
                                            offering_type: Optional[pulumi.Input[builtins.str]] = None,
                                            product_description: Optional[pulumi.Input[builtins.str]] = None,
                                            region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReservedCacheNodeOfferingResult]:
    """
    Information about a single ElastiCache Reserved Cache Node Offering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.elasticache.get_reserved_cache_node_offering(cache_node_type="cache.t4g.small",
        duration="P1Y",
        offering_type="No Upfront",
        product_description="redis")
    ```


    :param builtins.str cache_node_type: Node type for the reserved cache node.
           See AWS documentation for information on [supported node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Redis](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
           See AWS documentation for information on [supported node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html) and [guidance on selecting node types for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/nodes-select-size.html).
    :param builtins.str duration: Duration of the reservation in RFC3339 duration format.
           Valid values are `P1Y` (one year) and `P3Y` (three years).
    :param builtins.str offering_type: Offering type of this reserved cache node.
           For the latest generation of nodes (e.g. M5, R5, T4 and newer) valid values are `No Upfront`, `Partial Upfront`, and `All Upfront`.
           For other current generation nodes (i.e. T2, M3, M4, R3, or R4) the only valid value is `Heavy Utilization`.
           For previous generation modes (i.e. T1, M1, M2, or C1) valid values are `Heavy Utilization`, `Medium Utilization`, and `Light Utilization`.
    :param builtins.str product_description: Engine type for the reserved cache node.
           Valid values are `redis`, `valkey` and `memcached`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['cacheNodeType'] = cache_node_type
    __args__['duration'] = duration
    __args__['offeringType'] = offering_type
    __args__['productDescription'] = product_description
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:elasticache/getReservedCacheNodeOffering:getReservedCacheNodeOffering', __args__, opts=opts, typ=GetReservedCacheNodeOfferingResult)
    return __ret__.apply(lambda __response__: GetReservedCacheNodeOfferingResult(
        cache_node_type=pulumi.get(__response__, 'cache_node_type'),
        duration=pulumi.get(__response__, 'duration'),
        fixed_price=pulumi.get(__response__, 'fixed_price'),
        id=pulumi.get(__response__, 'id'),
        offering_id=pulumi.get(__response__, 'offering_id'),
        offering_type=pulumi.get(__response__, 'offering_type'),
        product_description=pulumi.get(__response__, 'product_description'),
        region=pulumi.get(__response__, 'region')))
