# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterCacheNode',
    'ClusterLogDeliveryConfiguration',
    'GlobalReplicationGroupGlobalNodeGroup',
    'ParameterGroupParameter',
    'ReplicationGroupLogDeliveryConfiguration',
    'ReservedCacheNodeRecurringCharge',
    'ReservedCacheNodeTimeouts',
    'ServerlessCacheCacheUsageLimits',
    'ServerlessCacheCacheUsageLimitsDataStorage',
    'ServerlessCacheCacheUsageLimitsEcpuPerSecond',
    'ServerlessCacheEndpoint',
    'ServerlessCacheReaderEndpoint',
    'ServerlessCacheTimeouts',
    'UserAuthenticationMode',
    'GetClusterCacheNodeResult',
    'GetClusterLogDeliveryConfigurationResult',
    'GetReplicationGroupLogDeliveryConfigurationResult',
    'GetServerlessCacheCacheUsageLimitsResult',
    'GetServerlessCacheCacheUsageLimitsDataStorageResult',
    'GetServerlessCacheCacheUsageLimitsEcpuPerSecondResult',
    'GetServerlessCacheEndpointResult',
    'GetServerlessCacheReaderEndpointResult',
    'GetUserAuthenticationModeResult',
]

@pulumi.output_type
class ClusterCacheNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "outpostArn":
            suggest = "outpost_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCacheNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCacheNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCacheNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 availability_zone: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 outpost_arn: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str availability_zone: Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        :param builtins.int port: The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[builtins.str]:
        """
        Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ClusterLogDeliveryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"
        elif key == "logFormat":
            suggest = "log_format"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLogDeliveryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLogDeliveryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLogDeliveryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: builtins.str,
                 destination_type: builtins.str,
                 log_format: builtins.str,
                 log_type: builtins.str):
        """
        :param builtins.str destination: Name of either the CloudWatch Logs LogGroup or Kinesis Data Firehose resource.
        :param builtins.str destination_type: For CloudWatch Logs use `cloudwatch-logs` or for Kinesis Data Firehose use `kinesis-firehose`.
        :param builtins.str log_format: Valid values are `json` or `text`
        :param builtins.str log_type: Valid values are  `slow-log` or `engine-log`. Max 1 of each.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "log_format", log_format)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        """
        Name of either the CloudWatch Logs LogGroup or Kinesis Data Firehose resource.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> builtins.str:
        """
        For CloudWatch Logs use `cloudwatch-logs` or for Kinesis Data Firehose use `kinesis-firehose`.
        """
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> builtins.str:
        """
        Valid values are `json` or `text`
        """
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        """
        Valid values are  `slow-log` or `engine-log`. Max 1 of each.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GlobalReplicationGroupGlobalNodeGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "globalNodeGroupId":
            suggest = "global_node_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalReplicationGroupGlobalNodeGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalReplicationGroupGlobalNodeGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalReplicationGroupGlobalNodeGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 global_node_group_id: Optional[builtins.str] = None,
                 slots: Optional[builtins.str] = None):
        """
        :param builtins.str global_node_group_id: The ID of the global node group.
        :param builtins.str slots: The keyspace for this node group.
        """
        if global_node_group_id is not None:
            pulumi.set(__self__, "global_node_group_id", global_node_group_id)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)

    @property
    @pulumi.getter(name="globalNodeGroupId")
    def global_node_group_id(self) -> Optional[builtins.str]:
        """
        The ID of the global node group.
        """
        return pulumi.get(self, "global_node_group_id")

    @property
    @pulumi.getter
    def slots(self) -> Optional[builtins.str]:
        """
        The keyspace for this node group.
        """
        return pulumi.get(self, "slots")


@pulumi.output_type
class ParameterGroupParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the ElastiCache parameter.
        :param builtins.str value: The value of the ElastiCache parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the ElastiCache parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the ElastiCache parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ReplicationGroupLogDeliveryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"
        elif key == "logFormat":
            suggest = "log_format"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationGroupLogDeliveryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationGroupLogDeliveryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationGroupLogDeliveryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: builtins.str,
                 destination_type: builtins.str,
                 log_format: builtins.str,
                 log_type: builtins.str):
        """
        :param builtins.str destination: Name of either the CloudWatch Logs LogGroup or Kinesis Data Firehose resource.
        :param builtins.str destination_type: For CloudWatch Logs use `cloudwatch-logs` or for Kinesis Data Firehose use `kinesis-firehose`.
        :param builtins.str log_format: Valid values are `json` or `text`
        :param builtins.str log_type: Valid values are  `slow-log` or `engine-log`. Max 1 of each.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "log_format", log_format)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        """
        Name of either the CloudWatch Logs LogGroup or Kinesis Data Firehose resource.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> builtins.str:
        """
        For CloudWatch Logs use `cloudwatch-logs` or for Kinesis Data Firehose use `kinesis-firehose`.
        """
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> builtins.str:
        """
        Valid values are `json` or `text`
        """
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        """
        Valid values are  `slow-log` or `engine-log`. Max 1 of each.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class ReservedCacheNodeRecurringCharge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurringChargeAmount":
            suggest = "recurring_charge_amount"
        elif key == "recurringChargeFrequency":
            suggest = "recurring_charge_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservedCacheNodeRecurringCharge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservedCacheNodeRecurringCharge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservedCacheNodeRecurringCharge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurring_charge_amount: builtins.float,
                 recurring_charge_frequency: builtins.str):
        pulumi.set(__self__, "recurring_charge_amount", recurring_charge_amount)
        pulumi.set(__self__, "recurring_charge_frequency", recurring_charge_frequency)

    @property
    @pulumi.getter(name="recurringChargeAmount")
    def recurring_charge_amount(self) -> builtins.float:
        return pulumi.get(self, "recurring_charge_amount")

    @property
    @pulumi.getter(name="recurringChargeFrequency")
    def recurring_charge_frequency(self) -> builtins.str:
        return pulumi.get(self, "recurring_charge_frequency")


@pulumi.output_type
class ReservedCacheNodeTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class ServerlessCacheCacheUsageLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStorage":
            suggest = "data_storage"
        elif key == "ecpuPerSeconds":
            suggest = "ecpu_per_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessCacheCacheUsageLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessCacheCacheUsageLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessCacheCacheUsageLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_storage: Optional['outputs.ServerlessCacheCacheUsageLimitsDataStorage'] = None,
                 ecpu_per_seconds: Optional[Sequence['outputs.ServerlessCacheCacheUsageLimitsEcpuPerSecond']] = None):
        """
        :param 'ServerlessCacheCacheUsageLimitsDataStorageArgs' data_storage: The maximum data storage limit in the cache, expressed in Gigabytes. See `data_storage` Block for details.
        :param Sequence['ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs'] ecpu_per_seconds: The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second. See `ecpu_per_second` Block for details.
        """
        if data_storage is not None:
            pulumi.set(__self__, "data_storage", data_storage)
        if ecpu_per_seconds is not None:
            pulumi.set(__self__, "ecpu_per_seconds", ecpu_per_seconds)

    @property
    @pulumi.getter(name="dataStorage")
    def data_storage(self) -> Optional['outputs.ServerlessCacheCacheUsageLimitsDataStorage']:
        """
        The maximum data storage limit in the cache, expressed in Gigabytes. See `data_storage` Block for details.
        """
        return pulumi.get(self, "data_storage")

    @property
    @pulumi.getter(name="ecpuPerSeconds")
    def ecpu_per_seconds(self) -> Optional[Sequence['outputs.ServerlessCacheCacheUsageLimitsEcpuPerSecond']]:
        """
        The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second. See `ecpu_per_second` Block for details.
        """
        return pulumi.get(self, "ecpu_per_seconds")


@pulumi.output_type
class ServerlessCacheCacheUsageLimitsDataStorage(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 maximum: Optional[builtins.int] = None,
                 minimum: Optional[builtins.int] = None):
        """
        :param builtins.str unit: The unit that the storage is measured in, in GB.
        :param builtins.int maximum: The upper limit for data storage the cache is set to use. Must be between 1 and 5,000.
        :param builtins.int minimum: The lower limit for data storage the cache is set to use. Must be between 1 and 5,000.
        """
        pulumi.set(__self__, "unit", unit)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        """
        The unit that the storage is measured in, in GB.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[builtins.int]:
        """
        The upper limit for data storage the cache is set to use. Must be between 1 and 5,000.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[builtins.int]:
        """
        The lower limit for data storage the cache is set to use. Must be between 1 and 5,000.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class ServerlessCacheCacheUsageLimitsEcpuPerSecond(dict):
    def __init__(__self__, *,
                 maximum: Optional[builtins.int] = None,
                 minimum: Optional[builtins.int] = None):
        """
        :param builtins.int maximum: The maximum number of ECPUs the cache can consume per second. Must be between 1,000 and 15,000,000.
        :param builtins.int minimum: The minimum number of ECPUs the cache can consume per second. Must be between 1,000 and 15,000,000.
        """
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def maximum(self) -> Optional[builtins.int]:
        """
        The maximum number of ECPUs the cache can consume per second. Must be between 1,000 and 15,000,000.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[builtins.int]:
        """
        The minimum number of ECPUs the cache can consume per second. Must be between 1,000 and 15,000,000.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class ServerlessCacheEndpoint(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str address: The DNS hostname of the cache node.
        :param builtins.int port: The port number that the cache engine is listening on. Set as integer.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The DNS hostname of the cache node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port number that the cache engine is listening on. Set as integer.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServerlessCacheReaderEndpoint(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str address: The DNS hostname of the cache node.
        :param builtins.int port: The port number that the cache engine is listening on. Set as integer.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The DNS hostname of the cache node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port number that the cache engine is listening on. Set as integer.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServerlessCacheTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class UserAuthenticationMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordCount":
            suggest = "password_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAuthenticationMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAuthenticationMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAuthenticationMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 password_count: Optional[builtins.int] = None,
                 passwords: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str type: Specifies the authentication type. Possible options are: `password`, `no-password-required` or `iam`.
        :param Sequence[builtins.str] passwords: Specifies the passwords to use for authentication if `type` is set to `password`.
        """
        pulumi.set(__self__, "type", type)
        if password_count is not None:
            pulumi.set(__self__, "password_count", password_count)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the authentication type. Possible options are: `password`, `no-password-required` or `iam`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="passwordCount")
    def password_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "password_count")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the passwords to use for authentication if `type` is set to `password`.
        """
        return pulumi.get(self, "passwords")


@pulumi.output_type
class GetClusterCacheNodeResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 availability_zone: builtins.str,
                 id: builtins.str,
                 outpost_arn: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str availability_zone: Availability Zone for the cache cluster.
        :param builtins.int port: The port number on which each of the cache nodes will
               accept connections.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "outpost_arn", outpost_arn)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> builtins.str:
        """
        Availability Zone for the cache cluster.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> builtins.str:
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port number on which each of the cache nodes will
        accept connections.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetClusterLogDeliveryConfigurationResult(dict):
    def __init__(__self__, *,
                 destination: builtins.str,
                 destination_type: builtins.str,
                 log_format: builtins.str,
                 log_type: builtins.str):
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "log_format", log_format)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> builtins.str:
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> builtins.str:
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GetReplicationGroupLogDeliveryConfigurationResult(dict):
    def __init__(__self__, *,
                 destination: builtins.str,
                 destination_type: builtins.str,
                 log_format: builtins.str,
                 log_type: builtins.str):
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "log_format", log_format)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> builtins.str:
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> builtins.str:
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GetServerlessCacheCacheUsageLimitsResult(dict):
    def __init__(__self__, *,
                 data_storage: 'outputs.GetServerlessCacheCacheUsageLimitsDataStorageResult',
                 ecpu_per_second: 'outputs.GetServerlessCacheCacheUsageLimitsEcpuPerSecondResult'):
        """
        :param 'GetServerlessCacheCacheUsageLimitsDataStorageArgs' data_storage: The maximum data storage limit in the cache, expressed in Gigabytes. See `data_storage` Block for details.
        :param 'GetServerlessCacheCacheUsageLimitsEcpuPerSecondArgs' ecpu_per_second: The configured number of ElastiCache Processing Units (ECPU) the cache can consume per second. See `ecpu_per_second` Block for details.
        """
        pulumi.set(__self__, "data_storage", data_storage)
        pulumi.set(__self__, "ecpu_per_second", ecpu_per_second)

    @property
    @pulumi.getter(name="dataStorage")
    def data_storage(self) -> 'outputs.GetServerlessCacheCacheUsageLimitsDataStorageResult':
        """
        The maximum data storage limit in the cache, expressed in Gigabytes. See `data_storage` Block for details.
        """
        return pulumi.get(self, "data_storage")

    @property
    @pulumi.getter(name="ecpuPerSecond")
    def ecpu_per_second(self) -> 'outputs.GetServerlessCacheCacheUsageLimitsEcpuPerSecondResult':
        """
        The configured number of ElastiCache Processing Units (ECPU) the cache can consume per second. See `ecpu_per_second` Block for details.
        """
        return pulumi.get(self, "ecpu_per_second")


@pulumi.output_type
class GetServerlessCacheCacheUsageLimitsDataStorageResult(dict):
    def __init__(__self__, *,
                 maximum: builtins.int,
                 minimum: builtins.int,
                 unit: builtins.str):
        """
        :param builtins.int maximum: The maximum number of ECPUs the cache can consume per second.
        :param builtins.int minimum: The minimum number of ECPUs the cache can consume per second.
        :param builtins.str unit: The unit that the storage is measured in.
        """
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)
        pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def maximum(self) -> builtins.int:
        """
        The maximum number of ECPUs the cache can consume per second.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> builtins.int:
        """
        The minimum number of ECPUs the cache can consume per second.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        """
        The unit that the storage is measured in.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class GetServerlessCacheCacheUsageLimitsEcpuPerSecondResult(dict):
    def __init__(__self__, *,
                 maximum: builtins.int,
                 minimum: builtins.int):
        """
        :param builtins.int maximum: The maximum number of ECPUs the cache can consume per second.
        :param builtins.int minimum: The minimum number of ECPUs the cache can consume per second.
        """
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def maximum(self) -> builtins.int:
        """
        The maximum number of ECPUs the cache can consume per second.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> builtins.int:
        """
        The minimum number of ECPUs the cache can consume per second.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class GetServerlessCacheEndpointResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str address: The DNS hostname of the cache node.
        :param builtins.int port: The port number that the cache engine is listening on. Set as integer.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The DNS hostname of the cache node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port number that the cache engine is listening on. Set as integer.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServerlessCacheReaderEndpointResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str address: The DNS hostname of the cache node.
        :param builtins.int port: The port number that the cache engine is listening on. Set as integer.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The DNS hostname of the cache node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port number that the cache engine is listening on. Set as integer.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetUserAuthenticationModeResult(dict):
    def __init__(__self__, *,
                 password_count: Optional[builtins.int] = None,
                 type: Optional[builtins.str] = None):
        if password_count is not None:
            pulumi.set(__self__, "password_count", password_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="passwordCount")
    def password_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "password_count")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "type")


