# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerlessCacheArgs', 'ServerlessCache']

@pulumi.input_type
class ServerlessCacheArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[builtins.str],
                 cache_usage_limits: Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']] = None,
                 daily_snapshot_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 major_engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_arns_to_restores: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[builtins.int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ServerlessCacheTimeoutsArgs']] = None,
                 user_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServerlessCache resource.
        :param pulumi.Input[builtins.str] engine: Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` or `valkey`.
        :param pulumi.Input['ServerlessCacheCacheUsageLimitsArgs'] cache_usage_limits: Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See `cache_usage_limits` Block for details.
        :param pulumi.Input[builtins.str] daily_snapshot_time: The daily time that snapshots will be created from the new serverless cache. Only supported for engine types `"redis"` or `"valkey"`. Defaults to `0`.
        :param pulumi.Input[builtins.str] description: User-provided description for the serverless cache. The default is NULL.
        :param pulumi.Input[builtins.str] kms_key_id: ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
        :param pulumi.Input[builtins.str] major_engine_version: The version of the cache engine that will be used to create the serverless cache.
               See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        :param pulumi.Input[builtins.str] name: The Cluster name which serves as a unique identifier to the serverless cache
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snapshot_arns_to_restores: The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
        :param pulumi.Input[builtins.int] snapshot_retention_limit: The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_group_id: The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
        """
        pulumi.set(__self__, "engine", engine)
        if cache_usage_limits is not None:
            pulumi.set(__self__, "cache_usage_limits", cache_usage_limits)
        if daily_snapshot_time is not None:
            pulumi.set(__self__, "daily_snapshot_time", daily_snapshot_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if major_engine_version is not None:
            pulumi.set(__self__, "major_engine_version", major_engine_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if snapshot_arns_to_restores is not None:
            pulumi.set(__self__, "snapshot_arns_to_restores", snapshot_arns_to_restores)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[builtins.str]:
        """
        Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` or `valkey`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="cacheUsageLimits")
    def cache_usage_limits(self) -> Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']]:
        """
        Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See `cache_usage_limits` Block for details.
        """
        return pulumi.get(self, "cache_usage_limits")

    @cache_usage_limits.setter
    def cache_usage_limits(self, value: Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']]):
        pulumi.set(self, "cache_usage_limits", value)

    @property
    @pulumi.getter(name="dailySnapshotTime")
    def daily_snapshot_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The daily time that snapshots will be created from the new serverless cache. Only supported for engine types `"redis"` or `"valkey"`. Defaults to `0`.
        """
        return pulumi.get(self, "daily_snapshot_time")

    @daily_snapshot_time.setter
    def daily_snapshot_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "daily_snapshot_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description for the serverless cache. The default is NULL.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the cache engine that will be used to create the serverless cache.
        See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        """
        return pulumi.get(self, "major_engine_version")

    @major_engine_version.setter
    def major_engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "major_engine_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Cluster name which serves as a unique identifier to the serverless cache

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="snapshotArnsToRestores")
    def snapshot_arns_to_restores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
        """
        return pulumi.get(self, "snapshot_arns_to_restores")

    @snapshot_arns_to_restores.setter
    def snapshot_arns_to_restores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "snapshot_arns_to_restores", value)

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ServerlessCacheTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ServerlessCacheTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_group_id", value)


@pulumi.input_type
class _ServerlessCacheState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 cache_usage_limits: Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 daily_snapshot_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessCacheEndpointArgs']]]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 full_engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 major_engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 reader_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessCacheReaderEndpointArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_arns_to_restores: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[builtins.int]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ServerlessCacheTimeoutsArgs']] = None,
                 user_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerlessCache resources.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the serverless cache.
        :param pulumi.Input['ServerlessCacheCacheUsageLimitsArgs'] cache_usage_limits: Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See `cache_usage_limits` Block for details.
        :param pulumi.Input[builtins.str] create_time: Timestamp of when the serverless cache was created.
        :param pulumi.Input[builtins.str] daily_snapshot_time: The daily time that snapshots will be created from the new serverless cache. Only supported for engine types `"redis"` or `"valkey"`. Defaults to `0`.
        :param pulumi.Input[builtins.str] description: User-provided description for the serverless cache. The default is NULL.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessCacheEndpointArgs']]] endpoints: Represents the information required for client programs to connect to a cache node. See `endpoint` Block for details.
        :param pulumi.Input[builtins.str] engine: Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` or `valkey`.
        :param pulumi.Input[builtins.str] full_engine_version: The name and version number of the engine the serverless cache is compatible with.
        :param pulumi.Input[builtins.str] kms_key_id: ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
        :param pulumi.Input[builtins.str] major_engine_version: The version of the cache engine that will be used to create the serverless cache.
               See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        :param pulumi.Input[builtins.str] name: The Cluster name which serves as a unique identifier to the serverless cache
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessCacheReaderEndpointArgs']]] reader_endpoints: Represents the information required for client programs to connect to a cache node. See `reader_endpoint` Block for details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snapshot_arns_to_restores: The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
        :param pulumi.Input[builtins.int] snapshot_retention_limit: The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
        :param pulumi.Input[builtins.str] status: The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_group_id: The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cache_usage_limits is not None:
            pulumi.set(__self__, "cache_usage_limits", cache_usage_limits)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if daily_snapshot_time is not None:
            pulumi.set(__self__, "daily_snapshot_time", daily_snapshot_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if full_engine_version is not None:
            pulumi.set(__self__, "full_engine_version", full_engine_version)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if major_engine_version is not None:
            pulumi.set(__self__, "major_engine_version", major_engine_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reader_endpoints is not None:
            pulumi.set(__self__, "reader_endpoints", reader_endpoints)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if snapshot_arns_to_restores is not None:
            pulumi.set(__self__, "snapshot_arns_to_restores", snapshot_arns_to_restores)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the serverless cache.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cacheUsageLimits")
    def cache_usage_limits(self) -> Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']]:
        """
        Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See `cache_usage_limits` Block for details.
        """
        return pulumi.get(self, "cache_usage_limits")

    @cache_usage_limits.setter
    def cache_usage_limits(self, value: Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']]):
        pulumi.set(self, "cache_usage_limits", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp of when the serverless cache was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dailySnapshotTime")
    def daily_snapshot_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The daily time that snapshots will be created from the new serverless cache. Only supported for engine types `"redis"` or `"valkey"`. Defaults to `0`.
        """
        return pulumi.get(self, "daily_snapshot_time")

    @daily_snapshot_time.setter
    def daily_snapshot_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "daily_snapshot_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description for the serverless cache. The default is NULL.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessCacheEndpointArgs']]]]:
        """
        Represents the information required for client programs to connect to a cache node. See `endpoint` Block for details.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessCacheEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` or `valkey`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="fullEngineVersion")
    def full_engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name and version number of the engine the serverless cache is compatible with.
        """
        return pulumi.get(self, "full_engine_version")

    @full_engine_version.setter
    def full_engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "full_engine_version", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the cache engine that will be used to create the serverless cache.
        See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        """
        return pulumi.get(self, "major_engine_version")

    @major_engine_version.setter
    def major_engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "major_engine_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Cluster name which serves as a unique identifier to the serverless cache

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readerEndpoints")
    def reader_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessCacheReaderEndpointArgs']]]]:
        """
        Represents the information required for client programs to connect to a cache node. See `reader_endpoint` Block for details.
        """
        return pulumi.get(self, "reader_endpoints")

    @reader_endpoints.setter
    def reader_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessCacheReaderEndpointArgs']]]]):
        pulumi.set(self, "reader_endpoints", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="snapshotArnsToRestores")
    def snapshot_arns_to_restores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
        """
        return pulumi.get(self, "snapshot_arns_to_restores")

    @snapshot_arns_to_restores.setter
    def snapshot_arns_to_restores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "snapshot_arns_to_restores", value)

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ServerlessCacheTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ServerlessCacheTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_group_id", value)


@pulumi.type_token("aws:elasticache/serverlessCache:ServerlessCache")
class ServerlessCache(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_usage_limits: Optional[pulumi.Input[Union['ServerlessCacheCacheUsageLimitsArgs', 'ServerlessCacheCacheUsageLimitsArgsDict']]] = None,
                 daily_snapshot_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 major_engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_arns_to_restores: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[builtins.int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ServerlessCacheTimeoutsArgs', 'ServerlessCacheTimeoutsArgsDict']]] = None,
                 user_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an ElastiCache Serverless Cache resource which manages memcached, redis or valkey.

        ## Example Usage

        ### Memcached Serverless

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ServerlessCache("example",
            engine="memcached",
            name="example",
            cache_usage_limits={
                "data_storage": {
                    "maximum": 10,
                    "unit": "GB",
                },
                "ecpu_per_seconds": [{
                    "maximum": 5000,
                }],
            },
            description="Test Server",
            kms_key_id=test["arn"],
            major_engine_version="1.6",
            security_group_ids=[test_aws_security_group["id"]],
            subnet_ids=[__item["id"] for __item in test_aws_subnet])
        ```

        ### Redis OSS Serverless

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ServerlessCache("example",
            engine="redis",
            name="example",
            cache_usage_limits={
                "data_storage": {
                    "maximum": 10,
                    "unit": "GB",
                },
                "ecpu_per_seconds": [{
                    "maximum": 5000,
                }],
            },
            daily_snapshot_time="09:00",
            description="Test Server",
            kms_key_id=test["arn"],
            major_engine_version="7",
            snapshot_retention_limit=1,
            security_group_ids=[test_aws_security_group["id"]],
            subnet_ids=[__item["id"] for __item in test_aws_subnet])
        ```

        ### Valkey Serverless

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ServerlessCache("example",
            engine="valkey",
            name="example",
            cache_usage_limits={
                "data_storage": {
                    "maximum": 10,
                    "unit": "GB",
                },
                "ecpu_per_seconds": [{
                    "maximum": 5000,
                }],
            },
            daily_snapshot_time="09:00",
            description="Test Server",
            kms_key_id=test["arn"],
            major_engine_version="7",
            snapshot_retention_limit=1,
            security_group_ids=[test_aws_security_group["id"]],
            subnet_ids=[__item["id"] for __item in test_aws_subnet])
        ```

        ## Import

        Using `pulumi import`, import ElastiCache Serverless Cache using the `name`. For example:

        ```sh
        $ pulumi import aws:elasticache/serverlessCache:ServerlessCache my_cluster my_cluster
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerlessCacheCacheUsageLimitsArgs', 'ServerlessCacheCacheUsageLimitsArgsDict']] cache_usage_limits: Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See `cache_usage_limits` Block for details.
        :param pulumi.Input[builtins.str] daily_snapshot_time: The daily time that snapshots will be created from the new serverless cache. Only supported for engine types `"redis"` or `"valkey"`. Defaults to `0`.
        :param pulumi.Input[builtins.str] description: User-provided description for the serverless cache. The default is NULL.
        :param pulumi.Input[builtins.str] engine: Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` or `valkey`.
        :param pulumi.Input[builtins.str] kms_key_id: ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
        :param pulumi.Input[builtins.str] major_engine_version: The version of the cache engine that will be used to create the serverless cache.
               See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        :param pulumi.Input[builtins.str] name: The Cluster name which serves as a unique identifier to the serverless cache
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snapshot_arns_to_restores: The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
        :param pulumi.Input[builtins.int] snapshot_retention_limit: The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_group_id: The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerlessCacheArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an ElastiCache Serverless Cache resource which manages memcached, redis or valkey.

        ## Example Usage

        ### Memcached Serverless

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ServerlessCache("example",
            engine="memcached",
            name="example",
            cache_usage_limits={
                "data_storage": {
                    "maximum": 10,
                    "unit": "GB",
                },
                "ecpu_per_seconds": [{
                    "maximum": 5000,
                }],
            },
            description="Test Server",
            kms_key_id=test["arn"],
            major_engine_version="1.6",
            security_group_ids=[test_aws_security_group["id"]],
            subnet_ids=[__item["id"] for __item in test_aws_subnet])
        ```

        ### Redis OSS Serverless

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ServerlessCache("example",
            engine="redis",
            name="example",
            cache_usage_limits={
                "data_storage": {
                    "maximum": 10,
                    "unit": "GB",
                },
                "ecpu_per_seconds": [{
                    "maximum": 5000,
                }],
            },
            daily_snapshot_time="09:00",
            description="Test Server",
            kms_key_id=test["arn"],
            major_engine_version="7",
            snapshot_retention_limit=1,
            security_group_ids=[test_aws_security_group["id"]],
            subnet_ids=[__item["id"] for __item in test_aws_subnet])
        ```

        ### Valkey Serverless

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.elasticache.ServerlessCache("example",
            engine="valkey",
            name="example",
            cache_usage_limits={
                "data_storage": {
                    "maximum": 10,
                    "unit": "GB",
                },
                "ecpu_per_seconds": [{
                    "maximum": 5000,
                }],
            },
            daily_snapshot_time="09:00",
            description="Test Server",
            kms_key_id=test["arn"],
            major_engine_version="7",
            snapshot_retention_limit=1,
            security_group_ids=[test_aws_security_group["id"]],
            subnet_ids=[__item["id"] for __item in test_aws_subnet])
        ```

        ## Import

        Using `pulumi import`, import ElastiCache Serverless Cache using the `name`. For example:

        ```sh
        $ pulumi import aws:elasticache/serverlessCache:ServerlessCache my_cluster my_cluster
        ```

        :param str resource_name: The name of the resource.
        :param ServerlessCacheArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessCacheArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_usage_limits: Optional[pulumi.Input[Union['ServerlessCacheCacheUsageLimitsArgs', 'ServerlessCacheCacheUsageLimitsArgsDict']]] = None,
                 daily_snapshot_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 major_engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_arns_to_restores: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[builtins.int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ServerlessCacheTimeoutsArgs', 'ServerlessCacheTimeoutsArgsDict']]] = None,
                 user_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessCacheArgs.__new__(ServerlessCacheArgs)

            __props__.__dict__["cache_usage_limits"] = cache_usage_limits
            __props__.__dict__["daily_snapshot_time"] = daily_snapshot_time
            __props__.__dict__["description"] = description
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["major_engine_version"] = major_engine_version
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["snapshot_arns_to_restores"] = snapshot_arns_to_restores
            __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["user_group_id"] = user_group_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["full_engine_version"] = None
            __props__.__dict__["reader_endpoints"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(ServerlessCache, __self__).__init__(
            'aws:elasticache/serverlessCache:ServerlessCache',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            cache_usage_limits: Optional[pulumi.Input[Union['ServerlessCacheCacheUsageLimitsArgs', 'ServerlessCacheCacheUsageLimitsArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            daily_snapshot_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessCacheEndpointArgs', 'ServerlessCacheEndpointArgsDict']]]]] = None,
            engine: Optional[pulumi.Input[builtins.str]] = None,
            full_engine_version: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            major_engine_version: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            reader_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessCacheReaderEndpointArgs', 'ServerlessCacheReaderEndpointArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            snapshot_arns_to_restores: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            snapshot_retention_limit: Optional[pulumi.Input[builtins.int]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ServerlessCacheTimeoutsArgs', 'ServerlessCacheTimeoutsArgsDict']]] = None,
            user_group_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ServerlessCache':
        """
        Get an existing ServerlessCache resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the serverless cache.
        :param pulumi.Input[Union['ServerlessCacheCacheUsageLimitsArgs', 'ServerlessCacheCacheUsageLimitsArgsDict']] cache_usage_limits: Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See `cache_usage_limits` Block for details.
        :param pulumi.Input[builtins.str] create_time: Timestamp of when the serverless cache was created.
        :param pulumi.Input[builtins.str] daily_snapshot_time: The daily time that snapshots will be created from the new serverless cache. Only supported for engine types `"redis"` or `"valkey"`. Defaults to `0`.
        :param pulumi.Input[builtins.str] description: User-provided description for the serverless cache. The default is NULL.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessCacheEndpointArgs', 'ServerlessCacheEndpointArgsDict']]]] endpoints: Represents the information required for client programs to connect to a cache node. See `endpoint` Block for details.
        :param pulumi.Input[builtins.str] engine: Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` or `valkey`.
        :param pulumi.Input[builtins.str] full_engine_version: The name and version number of the engine the serverless cache is compatible with.
        :param pulumi.Input[builtins.str] kms_key_id: ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
        :param pulumi.Input[builtins.str] major_engine_version: The version of the cache engine that will be used to create the serverless cache.
               See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        :param pulumi.Input[builtins.str] name: The Cluster name which serves as a unique identifier to the serverless cache
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessCacheReaderEndpointArgs', 'ServerlessCacheReaderEndpointArgsDict']]]] reader_endpoints: Represents the information required for client programs to connect to a cache node. See `reader_endpoint` Block for details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] snapshot_arns_to_restores: The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
        :param pulumi.Input[builtins.int] snapshot_retention_limit: The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
        :param pulumi.Input[builtins.str] status: The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_group_id: The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerlessCacheState.__new__(_ServerlessCacheState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cache_usage_limits"] = cache_usage_limits
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["daily_snapshot_time"] = daily_snapshot_time
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["engine"] = engine
        __props__.__dict__["full_engine_version"] = full_engine_version
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["major_engine_version"] = major_engine_version
        __props__.__dict__["name"] = name
        __props__.__dict__["reader_endpoints"] = reader_endpoints
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["snapshot_arns_to_restores"] = snapshot_arns_to_restores
        __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["user_group_id"] = user_group_id
        return ServerlessCache(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the serverless cache.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cacheUsageLimits")
    def cache_usage_limits(self) -> pulumi.Output[Optional['outputs.ServerlessCacheCacheUsageLimits']]:
        """
        Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See `cache_usage_limits` Block for details.
        """
        return pulumi.get(self, "cache_usage_limits")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp of when the serverless cache was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dailySnapshotTime")
    def daily_snapshot_time(self) -> pulumi.Output[builtins.str]:
        """
        The daily time that snapshots will be created from the new serverless cache. Only supported for engine types `"redis"` or `"valkey"`. Defaults to `0`.
        """
        return pulumi.get(self, "daily_snapshot_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        User-provided description for the serverless cache. The default is NULL.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.ServerlessCacheEndpoint']]:
        """
        Represents the information required for client programs to connect to a cache node. See `endpoint` Block for details.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[builtins.str]:
        """
        Name of the cache engine to be used for this cache cluster. Valid values are `memcached`, `redis` or `valkey`.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="fullEngineVersion")
    def full_engine_version(self) -> pulumi.Output[builtins.str]:
        """
        The name and version number of the engine the serverless cache is compatible with.
        """
        return pulumi.get(self, "full_engine_version")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the cache engine that will be used to create the serverless cache.
        See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
        """
        return pulumi.get(self, "major_engine_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The Cluster name which serves as a unique identifier to the serverless cache

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readerEndpoints")
    def reader_endpoints(self) -> pulumi.Output[Sequence['outputs.ServerlessCacheReaderEndpoint']]:
        """
        Represents the information required for client programs to connect to a cache node. See `reader_endpoint` Block for details.
        """
        return pulumi.get(self, "reader_endpoints")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="snapshotArnsToRestores")
    def snapshot_arns_to_restores(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
        """
        return pulumi.get(self, "snapshot_arns_to_restores")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> pulumi.Output[builtins.int]:
        """
        The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ServerlessCacheTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
        """
        return pulumi.get(self, "user_group_id")

