# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    """
    A collection of values returned by getApplication.
    """
    def __init__(__self__, appversion_lifecycle=None, arn=None, description=None, id=None, name=None, region=None):
        if appversion_lifecycle and not isinstance(appversion_lifecycle, dict):
            raise TypeError("Expected argument 'appversion_lifecycle' to be a dict")
        pulumi.set(__self__, "appversion_lifecycle", appversion_lifecycle)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="appversionLifecycle")
    def appversion_lifecycle(self) -> 'outputs.GetApplicationAppversionLifecycleResult':
        return pulumi.get(self, "appversion_lifecycle")

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the application.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Short description of the application
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            appversion_lifecycle=self.appversion_lifecycle,
            arn=self.arn,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region)


def get_application(name: Optional[builtins.str] = None,
                    region: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Retrieve information about an Elastic Beanstalk Application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.elasticbeanstalk.get_application(name="example")
    pulumi.export("arn", example.arn)
    pulumi.export("description", example.description)
    ```


    :param builtins.str name: Name of the application
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:elasticbeanstalk/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        appversion_lifecycle=pulumi.get(__ret__, 'appversion_lifecycle'),
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_application_output(name: Optional[pulumi.Input[builtins.str]] = None,
                           region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Retrieve information about an Elastic Beanstalk Application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.elasticbeanstalk.get_application(name="example")
    pulumi.export("arn", example.arn)
    pulumi.export("description", example.description)
    ```


    :param builtins.str name: Name of the application
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:elasticbeanstalk/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        appversion_lifecycle=pulumi.get(__response__, 'appversion_lifecycle'),
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
