# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ApplicationAppversionLifecycle',
    'ConfigurationTemplateSetting',
    'EnvironmentAllSetting',
    'EnvironmentSetting',
    'GetApplicationAppversionLifecycleResult',
]

@pulumi.output_type
class ApplicationAppversionLifecycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceRole":
            suggest = "service_role"
        elif key == "deleteSourceFromS3":
            suggest = "delete_source_from_s3"
        elif key == "maxAgeInDays":
            suggest = "max_age_in_days"
        elif key == "maxCount":
            suggest = "max_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAppversionLifecycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAppversionLifecycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAppversionLifecycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_role: builtins.str,
                 delete_source_from_s3: Optional[builtins.bool] = None,
                 max_age_in_days: Optional[builtins.int] = None,
                 max_count: Optional[builtins.int] = None):
        """
        :param builtins.str service_role: The ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
        :param builtins.bool delete_source_from_s3: Set to `true` to delete a version's source bundle from S3 when the application version is deleted.
        :param builtins.int max_age_in_days: The number of days to retain an application version ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
        :param builtins.int max_count: The maximum number of application versions to retain ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
        """
        pulumi.set(__self__, "service_role", service_role)
        if delete_source_from_s3 is not None:
            pulumi.set(__self__, "delete_source_from_s3", delete_source_from_s3)
        if max_age_in_days is not None:
            pulumi.set(__self__, "max_age_in_days", max_age_in_days)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> builtins.str:
        """
        The ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
        """
        return pulumi.get(self, "service_role")

    @property
    @pulumi.getter(name="deleteSourceFromS3")
    def delete_source_from_s3(self) -> Optional[builtins.bool]:
        """
        Set to `true` to delete a version's source bundle from S3 when the application version is deleted.
        """
        return pulumi.get(self, "delete_source_from_s3")

    @property
    @pulumi.getter(name="maxAgeInDays")
    def max_age_in_days(self) -> Optional[builtins.int]:
        """
        The number of days to retain an application version ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
        """
        return pulumi.get(self, "max_age_in_days")

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[builtins.int]:
        """
        The maximum number of application versions to retain ('max_age_in_days' and 'max_count' cannot be enabled simultaneously.).
        """
        return pulumi.get(self, "max_count")


@pulumi.output_type
class ConfigurationTemplateSetting(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 namespace: builtins.str,
                 value: builtins.str,
                 resource: Optional[builtins.str] = None):
        """
        :param builtins.str name: A unique name for this Template.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name for this Template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def resource(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource")


@pulumi.output_type
class EnvironmentAllSetting(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 namespace: builtins.str,
                 value: builtins.str,
                 resource: Optional[builtins.str] = None):
        """
        :param builtins.str name: A unique name for this Environment. This name is used
               in the application URL
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name for this Environment. This name is used
        in the application URL
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def resource(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource")


@pulumi.output_type
class EnvironmentSetting(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 namespace: builtins.str,
                 value: builtins.str,
                 resource: Optional[builtins.str] = None):
        """
        :param builtins.str name: A unique name for this Environment. This name is used
               in the application URL
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique name for this Environment. This name is used
        in the application URL
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def resource(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource")


@pulumi.output_type
class GetApplicationAppversionLifecycleResult(dict):
    def __init__(__self__, *,
                 delete_source_from_s3: builtins.bool,
                 max_age_in_days: builtins.int,
                 max_count: builtins.int,
                 service_role: builtins.str):
        """
        :param builtins.bool delete_source_from_s3: Specifies whether delete a version's source bundle from S3 when the application version is deleted.
        :param builtins.int max_age_in_days: Number of days to retain an application version.
        :param builtins.int max_count: Maximum number of application versions to retain.
        :param builtins.str service_role: ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
        """
        pulumi.set(__self__, "delete_source_from_s3", delete_source_from_s3)
        pulumi.set(__self__, "max_age_in_days", max_age_in_days)
        pulumi.set(__self__, "max_count", max_count)
        pulumi.set(__self__, "service_role", service_role)

    @property
    @pulumi.getter(name="deleteSourceFromS3")
    def delete_source_from_s3(self) -> builtins.bool:
        """
        Specifies whether delete a version's source bundle from S3 when the application version is deleted.
        """
        return pulumi.get(self, "delete_source_from_s3")

    @property
    @pulumi.getter(name="maxAgeInDays")
    def max_age_in_days(self) -> builtins.int:
        """
        Number of days to retain an application version.
        """
        return pulumi.get(self, "max_age_in_days")

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> builtins.int:
        """
        Maximum number of application versions to retain.
        """
        return pulumi.get(self, "max_count")

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> builtins.str:
        """
        ARN of an IAM service role under which the application version is deleted.  Elastic Beanstalk must have permission to assume this role.
        """
        return pulumi.get(self, "service_role")


