# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import iam
from .. import iam as _iam

__all__ = [
    'DomainAdvancedSecurityOptionsArgs',
    'DomainAdvancedSecurityOptionsArgsDict',
    'DomainAdvancedSecurityOptionsMasterUserOptionsArgs',
    'DomainAdvancedSecurityOptionsMasterUserOptionsArgsDict',
    'DomainAutoTuneOptionsArgs',
    'DomainAutoTuneOptionsArgsDict',
    'DomainAutoTuneOptionsMaintenanceScheduleArgs',
    'DomainAutoTuneOptionsMaintenanceScheduleArgsDict',
    'DomainAutoTuneOptionsMaintenanceScheduleDurationArgs',
    'DomainAutoTuneOptionsMaintenanceScheduleDurationArgsDict',
    'DomainClusterConfigArgs',
    'DomainClusterConfigArgsDict',
    'DomainClusterConfigColdStorageOptionsArgs',
    'DomainClusterConfigColdStorageOptionsArgsDict',
    'DomainClusterConfigZoneAwarenessConfigArgs',
    'DomainClusterConfigZoneAwarenessConfigArgsDict',
    'DomainCognitoOptionsArgs',
    'DomainCognitoOptionsArgsDict',
    'DomainDomainEndpointOptionsArgs',
    'DomainDomainEndpointOptionsArgsDict',
    'DomainEbsOptionsArgs',
    'DomainEbsOptionsArgsDict',
    'DomainEncryptAtRestArgs',
    'DomainEncryptAtRestArgsDict',
    'DomainLogPublishingOptionArgs',
    'DomainLogPublishingOptionArgsDict',
    'DomainNodeToNodeEncryptionArgs',
    'DomainNodeToNodeEncryptionArgsDict',
    'DomainSamlOptionsSamlOptionsArgs',
    'DomainSamlOptionsSamlOptionsArgsDict',
    'DomainSamlOptionsSamlOptionsIdpArgs',
    'DomainSamlOptionsSamlOptionsIdpArgsDict',
    'DomainSnapshotOptionsArgs',
    'DomainSnapshotOptionsArgsDict',
    'DomainVpcOptionsArgs',
    'DomainVpcOptionsArgsDict',
    'PolicyDocumentArgs',
    'PolicyDocumentArgsDict',
    'VpcEndpointVpcOptionsArgs',
    'VpcEndpointVpcOptionsArgsDict',
]

MYPY = False

if not MYPY:
    class DomainAdvancedSecurityOptionsArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        Whether advanced security is enabled.
        """
        internal_user_database_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
        """
        master_user_options: NotRequired[pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgsDict']]
        """
        Configuration block for the main user. Detailed below.
        """
elif False:
    DomainAdvancedSecurityOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAdvancedSecurityOptionsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 internal_user_database_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 master_user_options: Optional[pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgs']] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Whether advanced security is enabled.
        :param pulumi.Input[builtins.bool] internal_user_database_enabled: Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
        :param pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgs'] master_user_options: Configuration block for the main user. Detailed below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if internal_user_database_enabled is not None:
            pulumi.set(__self__, "internal_user_database_enabled", internal_user_database_enabled)
        if master_user_options is not None:
            pulumi.set(__self__, "master_user_options", master_user_options)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether advanced security is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="internalUserDatabaseEnabled")
    def internal_user_database_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
        """
        return pulumi.get(self, "internal_user_database_enabled")

    @internal_user_database_enabled.setter
    def internal_user_database_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "internal_user_database_enabled", value)

    @property
    @pulumi.getter(name="masterUserOptions")
    def master_user_options(self) -> Optional[pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgs']]:
        """
        Configuration block for the main user. Detailed below.
        """
        return pulumi.get(self, "master_user_options")

    @master_user_options.setter
    def master_user_options(self, value: Optional[pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgs']]):
        pulumi.set(self, "master_user_options", value)


if not MYPY:
    class DomainAdvancedSecurityOptionsMasterUserOptionsArgsDict(TypedDict):
        master_user_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        """
        master_user_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Main user's username, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        master_user_password: NotRequired[pulumi.Input[builtins.str]]
        """
        Main user's password, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
elif False:
    DomainAdvancedSecurityOptionsMasterUserOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAdvancedSecurityOptionsMasterUserOptionsArgs:
    def __init__(__self__, *,
                 master_user_arn: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] master_user_arn: ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        :param pulumi.Input[builtins.str] master_user_name: Main user's username, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        :param pulumi.Input[builtins.str] master_user_password: Main user's password, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        if master_user_arn is not None:
            pulumi.set(__self__, "master_user_arn", master_user_arn)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)

    @property
    @pulumi.getter(name="masterUserArn")
    def master_user_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        """
        return pulumi.get(self, "master_user_arn")

    @master_user_arn.setter
    def master_user_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_user_arn", value)

    @property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Main user's username, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        return pulumi.get(self, "master_user_name")

    @master_user_name.setter
    def master_user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_user_name", value)

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Main user's password, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        return pulumi.get(self, "master_user_password")

    @master_user_password.setter
    def master_user_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_user_password", value)


if not MYPY:
    class DomainAutoTuneOptionsArgsDict(TypedDict):
        desired_state: pulumi.Input[builtins.str]
        """
        The Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        """
        maintenance_schedules: NotRequired[pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgsDict']]]]
        """
        Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
        """
        rollback_on_disable: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        """
elif False:
    DomainAutoTuneOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAutoTuneOptionsArgs:
    def __init__(__self__, *,
                 desired_state: pulumi.Input[builtins.str],
                 maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgs']]]] = None,
                 rollback_on_disable: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] desired_state: The Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        :param pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgs']]] maintenance_schedules: Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
        :param pulumi.Input[builtins.str] rollback_on_disable: Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if rollback_on_disable is not None:
            pulumi.set(__self__, "rollback_on_disable", rollback_on_disable)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Input[builtins.str]:
        """
        The Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgs']]]]:
        """
        Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @maintenance_schedules.setter
    def maintenance_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgs']]]]):
        pulumi.set(self, "maintenance_schedules", value)

    @property
    @pulumi.getter(name="rollbackOnDisable")
    def rollback_on_disable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        """
        return pulumi.get(self, "rollback_on_disable")

    @rollback_on_disable.setter
    def rollback_on_disable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rollback_on_disable", value)


if not MYPY:
    class DomainAutoTuneOptionsMaintenanceScheduleArgsDict(TypedDict):
        cron_expression_for_recurrence: pulumi.Input[builtins.str]
        """
        A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        """
        duration: pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgsDict']
        """
        Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        """
        start_at: pulumi.Input[builtins.str]
        """
        Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
elif False:
    DomainAutoTuneOptionsMaintenanceScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAutoTuneOptionsMaintenanceScheduleArgs:
    def __init__(__self__, *,
                 cron_expression_for_recurrence: pulumi.Input[builtins.str],
                 duration: pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgs'],
                 start_at: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] cron_expression_for_recurrence: A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        :param pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgs'] duration: Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        :param pulumi.Input[builtins.str] start_at: Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        pulumi.set(__self__, "cron_expression_for_recurrence", cron_expression_for_recurrence)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_at", start_at)

    @property
    @pulumi.getter(name="cronExpressionForRecurrence")
    def cron_expression_for_recurrence(self) -> pulumi.Input[builtins.str]:
        """
        A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        """
        return pulumi.get(self, "cron_expression_for_recurrence")

    @cron_expression_for_recurrence.setter
    def cron_expression_for_recurrence(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cron_expression_for_recurrence", value)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgs']:
        """
        Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgs']):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="startAt")
    def start_at(self) -> pulumi.Input[builtins.str]:
        """
        Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "start_at")

    @start_at.setter
    def start_at(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start_at", value)


if not MYPY:
    class DomainAutoTuneOptionsMaintenanceScheduleDurationArgsDict(TypedDict):
        unit: pulumi.Input[builtins.str]
        """
        The unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        """
        value: pulumi.Input[builtins.int]
        """
        An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
elif False:
    DomainAutoTuneOptionsMaintenanceScheduleDurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAutoTuneOptionsMaintenanceScheduleDurationArgs:
    def __init__(__self__, *,
                 unit: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] unit: The unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        :param pulumi.Input[builtins.int] value: An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Input[builtins.str]:
        """
        The unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.int]:
        """
        An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DomainClusterConfigArgsDict(TypedDict):
        cold_storage_options: NotRequired[pulumi.Input['DomainClusterConfigColdStorageOptionsArgsDict']]
        """
        Configuration block containing cold storage configuration. Detailed below.
        """
        dedicated_master_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of dedicated main nodes in the cluster.
        """
        dedicated_master_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether dedicated main nodes are enabled for the cluster.
        """
        dedicated_master_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Instance type of the dedicated main nodes in the cluster.
        """
        instance_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of instances in the cluster.
        """
        instance_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Instance type of data nodes in the cluster.
        """
        warm_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        """
        warm_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable warm storage.
        """
        warm_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        """
        zone_awareness_config: NotRequired[pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgsDict']]
        """
        Configuration block containing zone awareness settings. Detailed below.
        """
        zone_awareness_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
elif False:
    DomainClusterConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainClusterConfigArgs:
    def __init__(__self__, *,
                 cold_storage_options: Optional[pulumi.Input['DomainClusterConfigColdStorageOptionsArgs']] = None,
                 dedicated_master_count: Optional[pulumi.Input[builtins.int]] = None,
                 dedicated_master_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dedicated_master_type: Optional[pulumi.Input[builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 warm_count: Optional[pulumi.Input[builtins.int]] = None,
                 warm_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 warm_type: Optional[pulumi.Input[builtins.str]] = None,
                 zone_awareness_config: Optional[pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgs']] = None,
                 zone_awareness_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input['DomainClusterConfigColdStorageOptionsArgs'] cold_storage_options: Configuration block containing cold storage configuration. Detailed below.
        :param pulumi.Input[builtins.int] dedicated_master_count: Number of dedicated main nodes in the cluster.
        :param pulumi.Input[builtins.bool] dedicated_master_enabled: Whether dedicated main nodes are enabled for the cluster.
        :param pulumi.Input[builtins.str] dedicated_master_type: Instance type of the dedicated main nodes in the cluster.
        :param pulumi.Input[builtins.int] instance_count: Number of instances in the cluster.
        :param pulumi.Input[builtins.str] instance_type: Instance type of data nodes in the cluster.
        :param pulumi.Input[builtins.int] warm_count: Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        :param pulumi.Input[builtins.bool] warm_enabled: Whether to enable warm storage.
        :param pulumi.Input[builtins.str] warm_type: Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        :param pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgs'] zone_awareness_config: Configuration block containing zone awareness settings. Detailed below.
        :param pulumi.Input[builtins.bool] zone_awareness_enabled: Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
        if cold_storage_options is not None:
            pulumi.set(__self__, "cold_storage_options", cold_storage_options)
        if dedicated_master_count is not None:
            pulumi.set(__self__, "dedicated_master_count", dedicated_master_count)
        if dedicated_master_enabled is not None:
            pulumi.set(__self__, "dedicated_master_enabled", dedicated_master_enabled)
        if dedicated_master_type is not None:
            pulumi.set(__self__, "dedicated_master_type", dedicated_master_type)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if warm_count is not None:
            pulumi.set(__self__, "warm_count", warm_count)
        if warm_enabled is not None:
            pulumi.set(__self__, "warm_enabled", warm_enabled)
        if warm_type is not None:
            pulumi.set(__self__, "warm_type", warm_type)
        if zone_awareness_config is not None:
            pulumi.set(__self__, "zone_awareness_config", zone_awareness_config)
        if zone_awareness_enabled is not None:
            pulumi.set(__self__, "zone_awareness_enabled", zone_awareness_enabled)

    @property
    @pulumi.getter(name="coldStorageOptions")
    def cold_storage_options(self) -> Optional[pulumi.Input['DomainClusterConfigColdStorageOptionsArgs']]:
        """
        Configuration block containing cold storage configuration. Detailed below.
        """
        return pulumi.get(self, "cold_storage_options")

    @cold_storage_options.setter
    def cold_storage_options(self, value: Optional[pulumi.Input['DomainClusterConfigColdStorageOptionsArgs']]):
        pulumi.set(self, "cold_storage_options", value)

    @property
    @pulumi.getter(name="dedicatedMasterCount")
    def dedicated_master_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of dedicated main nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_count")

    @dedicated_master_count.setter
    def dedicated_master_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "dedicated_master_count", value)

    @property
    @pulumi.getter(name="dedicatedMasterEnabled")
    def dedicated_master_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether dedicated main nodes are enabled for the cluster.
        """
        return pulumi.get(self, "dedicated_master_enabled")

    @dedicated_master_enabled.setter
    def dedicated_master_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dedicated_master_enabled", value)

    @property
    @pulumi.getter(name="dedicatedMasterType")
    def dedicated_master_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Instance type of the dedicated main nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_type")

    @dedicated_master_type.setter
    def dedicated_master_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dedicated_master_type", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of instances in the cluster.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Instance type of data nodes in the cluster.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="warmCount")
    def warm_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        """
        return pulumi.get(self, "warm_count")

    @warm_count.setter
    def warm_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "warm_count", value)

    @property
    @pulumi.getter(name="warmEnabled")
    def warm_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable warm storage.
        """
        return pulumi.get(self, "warm_enabled")

    @warm_enabled.setter
    def warm_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "warm_enabled", value)

    @property
    @pulumi.getter(name="warmType")
    def warm_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        """
        return pulumi.get(self, "warm_type")

    @warm_type.setter
    def warm_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warm_type", value)

    @property
    @pulumi.getter(name="zoneAwarenessConfig")
    def zone_awareness_config(self) -> Optional[pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgs']]:
        """
        Configuration block containing zone awareness settings. Detailed below.
        """
        return pulumi.get(self, "zone_awareness_config")

    @zone_awareness_config.setter
    def zone_awareness_config(self, value: Optional[pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgs']]):
        pulumi.set(self, "zone_awareness_config", value)

    @property
    @pulumi.getter(name="zoneAwarenessEnabled")
    def zone_awareness_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
        return pulumi.get(self, "zone_awareness_enabled")

    @zone_awareness_enabled.setter
    def zone_awareness_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "zone_awareness_enabled", value)


if not MYPY:
    class DomainClusterConfigColdStorageOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Boolean to enable cold storage for an Elasticsearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
elif False:
    DomainClusterConfigColdStorageOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainClusterConfigColdStorageOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Boolean to enable cold storage for an Elasticsearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean to enable cold storage for an Elasticsearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainClusterConfigZoneAwarenessConfigArgsDict(TypedDict):
        availability_zone_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
elif False:
    DomainClusterConfigZoneAwarenessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainClusterConfigZoneAwarenessConfigArgs:
    def __init__(__self__, *,
                 availability_zone_count: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] availability_zone_count: Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
        if availability_zone_count is not None:
            pulumi.set(__self__, "availability_zone_count", availability_zone_count)

    @property
    @pulumi.getter(name="availabilityZoneCount")
    def availability_zone_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
        return pulumi.get(self, "availability_zone_count")

    @availability_zone_count.setter
    def availability_zone_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "availability_zone_count", value)


if not MYPY:
    class DomainCognitoOptionsArgsDict(TypedDict):
        identity_pool_id: pulumi.Input[builtins.str]
        """
        ID of the Cognito Identity Pool to use.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
        """
        user_pool_id: pulumi.Input[builtins.str]
        """
        ID of the Cognito User Pool to use.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether Amazon Cognito authentication with Kibana is enabled or not.
        """
elif False:
    DomainCognitoOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainCognitoOptionsArgs:
    def __init__(__self__, *,
                 identity_pool_id: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 user_pool_id: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] identity_pool_id: ID of the Cognito Identity Pool to use.
        :param pulumi.Input[builtins.str] role_arn: ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
        :param pulumi.Input[builtins.str] user_pool_id: ID of the Cognito User Pool to use.
        :param pulumi.Input[builtins.bool] enabled: Whether Amazon Cognito authentication with Kibana is enabled or not.
        """
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the Cognito Identity Pool to use.
        """
        return pulumi.get(self, "identity_pool_id")

    @identity_pool_id.setter
    def identity_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_pool_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the Cognito User Pool to use.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether Amazon Cognito authentication with Kibana is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainDomainEndpointOptionsArgsDict(TypedDict):
        custom_endpoint: NotRequired[pulumi.Input[builtins.str]]
        """
        Fully qualified domain for your custom endpoint.
        """
        custom_endpoint_certificate_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ACM certificate ARN for your custom endpoint.
        """
        custom_endpoint_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable custom endpoint for the Elasticsearch domain.
        """
        enforce_https: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not to require HTTPS. Defaults to `true`.
        """
        tls_security_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07`, `Policy-Min-TLS-1-2-2019-07`, and `Policy-Min-TLS-1-2-PFS-2023-10`. Pulumi will only perform drift detection if a configuration value is provided.
        """
elif False:
    DomainDomainEndpointOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainDomainEndpointOptionsArgs:
    def __init__(__self__, *,
                 custom_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint_certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enforce_https: Optional[pulumi.Input[builtins.bool]] = None,
                 tls_security_policy: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] custom_endpoint: Fully qualified domain for your custom endpoint.
        :param pulumi.Input[builtins.str] custom_endpoint_certificate_arn: ACM certificate ARN for your custom endpoint.
        :param pulumi.Input[builtins.bool] custom_endpoint_enabled: Whether to enable custom endpoint for the Elasticsearch domain.
        :param pulumi.Input[builtins.bool] enforce_https: Whether or not to require HTTPS. Defaults to `true`.
        :param pulumi.Input[builtins.str] tls_security_policy: Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07`, `Policy-Min-TLS-1-2-2019-07`, and `Policy-Min-TLS-1-2-PFS-2023-10`. Pulumi will only perform drift detection if a configuration value is provided.
        """
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if custom_endpoint_certificate_arn is not None:
            pulumi.set(__self__, "custom_endpoint_certificate_arn", custom_endpoint_certificate_arn)
        if custom_endpoint_enabled is not None:
            pulumi.set(__self__, "custom_endpoint_enabled", custom_endpoint_enabled)
        if enforce_https is not None:
            pulumi.set(__self__, "enforce_https", enforce_https)
        if tls_security_policy is not None:
            pulumi.set(__self__, "tls_security_policy", tls_security_policy)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified domain for your custom endpoint.
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_endpoint", value)

    @property
    @pulumi.getter(name="customEndpointCertificateArn")
    def custom_endpoint_certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ACM certificate ARN for your custom endpoint.
        """
        return pulumi.get(self, "custom_endpoint_certificate_arn")

    @custom_endpoint_certificate_arn.setter
    def custom_endpoint_certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_endpoint_certificate_arn", value)

    @property
    @pulumi.getter(name="customEndpointEnabled")
    def custom_endpoint_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable custom endpoint for the Elasticsearch domain.
        """
        return pulumi.get(self, "custom_endpoint_enabled")

    @custom_endpoint_enabled.setter
    def custom_endpoint_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "custom_endpoint_enabled", value)

    @property
    @pulumi.getter(name="enforceHttps")
    def enforce_https(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to require HTTPS. Defaults to `true`.
        """
        return pulumi.get(self, "enforce_https")

    @enforce_https.setter
    def enforce_https(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enforce_https", value)

    @property
    @pulumi.getter(name="tlsSecurityPolicy")
    def tls_security_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07`, `Policy-Min-TLS-1-2-2019-07`, and `Policy-Min-TLS-1-2-PFS-2023-10`. Pulumi will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "tls_security_policy")

    @tls_security_policy.setter
    def tls_security_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_security_policy", value)


if not MYPY:
    class DomainEbsOptionsArgsDict(TypedDict):
        ebs_enabled: pulumi.Input[builtins.bool]
        """
        Whether EBS volumes are attached to data nodes in the domain.
        """
        iops: NotRequired[pulumi.Input[builtins.int]]
        """
        Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        """
        throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        """
        volume_size: NotRequired[pulumi.Input[builtins.int]]
        """
        Size of EBS volumes attached to data nodes (in GiB).
        """
        volume_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of EBS volumes attached to data nodes.
        """
elif False:
    DomainEbsOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainEbsOptionsArgs:
    def __init__(__self__, *,
                 ebs_enabled: pulumi.Input[builtins.bool],
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None,
                 volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] ebs_enabled: Whether EBS volumes are attached to data nodes in the domain.
        :param pulumi.Input[builtins.int] iops: Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        :param pulumi.Input[builtins.int] throughput: Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        :param pulumi.Input[builtins.int] volume_size: Size of EBS volumes attached to data nodes (in GiB).
        :param pulumi.Input[builtins.str] volume_type: Type of EBS volumes attached to data nodes.
        """
        pulumi.set(__self__, "ebs_enabled", ebs_enabled)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="ebsEnabled")
    def ebs_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether EBS volumes are attached to data nodes in the domain.
        """
        return pulumi.get(self, "ebs_enabled")

    @ebs_enabled.setter
    def ebs_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "ebs_enabled", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size of EBS volumes attached to data nodes (in GiB).
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class DomainEncryptAtRestArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires `elasticsearch_version` 5.1 or greater.
        """
        kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
elif False:
    DomainEncryptAtRestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainEncryptAtRestArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires `elasticsearch_version` 5.1 or greater.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
        pulumi.set(__self__, "enabled", enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires `elasticsearch_version` 5.1 or greater.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)


if not MYPY:
    class DomainLogPublishingOptionArgsDict(TypedDict):
        cloudwatch_log_group_arn: pulumi.Input[builtins.str]
        """
        ARN of the Cloudwatch log group to which log needs to be published.
        """
        log_type: pulumi.Input[builtins.str]
        """
        Type of Elasticsearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether given log publishing option is enabled or not.
        """
elif False:
    DomainLogPublishingOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainLogPublishingOptionArgs:
    def __init__(__self__, *,
                 cloudwatch_log_group_arn: pulumi.Input[builtins.str],
                 log_type: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] cloudwatch_log_group_arn: ARN of the Cloudwatch log group to which log needs to be published.
        :param pulumi.Input[builtins.str] log_type: Type of Elasticsearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        :param pulumi.Input[builtins.bool] enabled: Whether given log publishing option is enabled or not.
        """
        pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        pulumi.set(__self__, "log_type", log_type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the Cloudwatch log group to which log needs to be published.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @cloudwatch_log_group_arn.setter
    def cloudwatch_log_group_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloudwatch_log_group_arn", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of Elasticsearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether given log publishing option is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainNodeToNodeEncryptionArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `elasticsearch_version` of `6.0` or greater.
        """
elif False:
    DomainNodeToNodeEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNodeToNodeEncryptionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.bool] enabled: Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `elasticsearch_version` of `6.0` or greater.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `elasticsearch_version` of `6.0` or greater.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainSamlOptionsSamlOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether SAML authentication is enabled.
        """
        idp: NotRequired[pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgsDict']]
        """
        Information from your identity provider.
        """
        master_backend_role: NotRequired[pulumi.Input[builtins.str]]
        """
        This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        master_user_name: NotRequired[pulumi.Input[builtins.str]]
        """
        This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        roles_key: NotRequired[pulumi.Input[builtins.str]]
        """
        Element of the SAML assertion to use for backend roles. Default is roles.
        """
        session_timeout_minutes: NotRequired[pulumi.Input[builtins.int]]
        """
        Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        """
        subject_key: NotRequired[pulumi.Input[builtins.str]]
        """
        Custom SAML attribute to use for user names. Default is an empty string - `""`. This will cause Elasticsearch to use the `NameID` element of the `Subject`, which is the default location for name identifiers in the SAML specification.
        """
elif False:
    DomainSamlOptionsSamlOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSamlOptionsSamlOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 idp: Optional[pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgs']] = None,
                 master_backend_role: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_name: Optional[pulumi.Input[builtins.str]] = None,
                 roles_key: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 subject_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Whether SAML authentication is enabled.
        :param pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgs'] idp: Information from your identity provider.
        :param pulumi.Input[builtins.str] master_backend_role: This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        :param pulumi.Input[builtins.str] master_user_name: This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        :param pulumi.Input[builtins.str] roles_key: Element of the SAML assertion to use for backend roles. Default is roles.
        :param pulumi.Input[builtins.int] session_timeout_minutes: Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        :param pulumi.Input[builtins.str] subject_key: Custom SAML attribute to use for user names. Default is an empty string - `""`. This will cause Elasticsearch to use the `NameID` element of the `Subject`, which is the default location for name identifiers in the SAML specification.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp is not None:
            pulumi.set(__self__, "idp", idp)
        if master_backend_role is not None:
            pulumi.set(__self__, "master_backend_role", master_backend_role)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if session_timeout_minutes is not None:
            pulumi.set(__self__, "session_timeout_minutes", session_timeout_minutes)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether SAML authentication is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def idp(self) -> Optional[pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgs']]:
        """
        Information from your identity provider.
        """
        return pulumi.get(self, "idp")

    @idp.setter
    def idp(self, value: Optional[pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgs']]):
        pulumi.set(self, "idp", value)

    @property
    @pulumi.getter(name="masterBackendRole")
    def master_backend_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        return pulumi.get(self, "master_backend_role")

    @master_backend_role.setter
    def master_backend_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_backend_role", value)

    @property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        return pulumi.get(self, "master_user_name")

    @master_user_name.setter
    def master_user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_user_name", value)

    @property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Element of the SAML assertion to use for backend roles. Default is roles.
        """
        return pulumi.get(self, "roles_key")

    @roles_key.setter
    def roles_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "roles_key", value)

    @property
    @pulumi.getter(name="sessionTimeoutMinutes")
    def session_timeout_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        """
        return pulumi.get(self, "session_timeout_minutes")

    @session_timeout_minutes.setter
    def session_timeout_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout_minutes", value)

    @property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom SAML attribute to use for user names. Default is an empty string - `""`. This will cause Elasticsearch to use the `NameID` element of the `Subject`, which is the default location for name identifiers in the SAML specification.
        """
        return pulumi.get(self, "subject_key")

    @subject_key.setter
    def subject_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subject_key", value)


if not MYPY:
    class DomainSamlOptionsSamlOptionsIdpArgsDict(TypedDict):
        entity_id: pulumi.Input[builtins.str]
        """
        The unique Entity ID of the application in SAML Identity Provider.
        """
        metadata_content: pulumi.Input[builtins.str]
        """
        The Metadata of the SAML application in xml format.
        """
elif False:
    DomainSamlOptionsSamlOptionsIdpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSamlOptionsSamlOptionsIdpArgs:
    def __init__(__self__, *,
                 entity_id: pulumi.Input[builtins.str],
                 metadata_content: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] entity_id: The unique Entity ID of the application in SAML Identity Provider.
        :param pulumi.Input[builtins.str] metadata_content: The Metadata of the SAML application in xml format.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "metadata_content", metadata_content)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique Entity ID of the application in SAML Identity Provider.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="metadataContent")
    def metadata_content(self) -> pulumi.Input[builtins.str]:
        """
        The Metadata of the SAML application in xml format.
        """
        return pulumi.get(self, "metadata_content")

    @metadata_content.setter
    def metadata_content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metadata_content", value)


if not MYPY:
    class DomainSnapshotOptionsArgsDict(TypedDict):
        automated_snapshot_start_hour: pulumi.Input[builtins.int]
        """
        Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
elif False:
    DomainSnapshotOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSnapshotOptionsArgs:
    def __init__(__self__, *,
                 automated_snapshot_start_hour: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] automated_snapshot_start_hour: Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        pulumi.set(__self__, "automated_snapshot_start_hour", automated_snapshot_start_hour)

    @property
    @pulumi.getter(name="automatedSnapshotStartHour")
    def automated_snapshot_start_hour(self) -> pulumi.Input[builtins.int]:
        """
        Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        return pulumi.get(self, "automated_snapshot_start_hour")

    @automated_snapshot_start_hour.setter
    def automated_snapshot_start_hour(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "automated_snapshot_start_hour", value)


if not MYPY:
    class DomainVpcOptionsArgsDict(TypedDict):
        availability_zones: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of VPC Security Group IDs to be applied to the Elasticsearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of VPC Subnet IDs for the Elasticsearch domain endpoints to be created in.
        """
        vpc_id: NotRequired[pulumi.Input[builtins.str]]
        """
        If the domain was created inside a VPC, the ID of the VPC.
        """
elif False:
    DomainVpcOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainVpcOptionsArgs:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: List of VPC Security Group IDs to be applied to the Elasticsearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: List of VPC Subnet IDs for the Elasticsearch domain endpoints to be created in.
        :param pulumi.Input[builtins.str] vpc_id: If the domain was created inside a VPC, the ID of the VPC.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of VPC Security Group IDs to be applied to the Elasticsearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of VPC Subnet IDs for the Elasticsearch domain endpoints to be created in.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the domain was created inside a VPC, the ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class PolicyDocumentArgsDict(TypedDict):
        """
        Represents an AWS IAM policy document that defines permissions for AWS resources and actions.
        """
        statement: pulumi.Input[Sequence[pulumi.Input['_iam.PolicyStatementArgsDict']]]
        version: pulumi.Input['iam.PolicyDocumentVersion']
        id: NotRequired[pulumi.Input[builtins.str]]
elif False:
    PolicyDocumentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyDocumentArgs:
    def __init__(__self__, *,
                 statement: pulumi.Input[Sequence[pulumi.Input['_iam.PolicyStatementArgs']]],
                 version: pulumi.Input['iam.PolicyDocumentVersion'],
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Represents an AWS IAM policy document that defines permissions for AWS resources and actions.
        """
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "version", version)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="Statement")
    def statement(self) -> pulumi.Input[Sequence[pulumi.Input['_iam.PolicyStatementArgs']]]:
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: pulumi.Input[Sequence[pulumi.Input['_iam.PolicyStatementArgs']]]):
        pulumi.set(self, "statement", value)

    @property
    @pulumi.getter(name="Version")
    def version(self) -> pulumi.Input['iam.PolicyDocumentVersion']:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input['iam.PolicyDocumentVersion']):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="Id")
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class VpcEndpointVpcOptionsArgsDict(TypedDict):
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        """
        availability_zones: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, elasticsearch Service uses the default security group for the VPC.
        """
        vpc_id: NotRequired[pulumi.Input[builtins.str]]
elif False:
    VpcEndpointVpcOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcEndpointVpcOptionsArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, elasticsearch Service uses the default security group for the VPC.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, elasticsearch Service uses the default security group for the VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


