# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DomainAdvancedSecurityOptions',
    'DomainAdvancedSecurityOptionsMasterUserOptions',
    'DomainAutoTuneOptions',
    'DomainAutoTuneOptionsMaintenanceSchedule',
    'DomainAutoTuneOptionsMaintenanceScheduleDuration',
    'DomainClusterConfig',
    'DomainClusterConfigColdStorageOptions',
    'DomainClusterConfigZoneAwarenessConfig',
    'DomainCognitoOptions',
    'DomainDomainEndpointOptions',
    'DomainEbsOptions',
    'DomainEncryptAtRest',
    'DomainLogPublishingOption',
    'DomainNodeToNodeEncryption',
    'DomainSamlOptionsSamlOptions',
    'DomainSamlOptionsSamlOptionsIdp',
    'DomainSnapshotOptions',
    'DomainVpcOptions',
    'VpcEndpointVpcOptions',
    'GetDomainAdvancedSecurityOptionResult',
    'GetDomainAutoTuneOptionResult',
    'GetDomainAutoTuneOptionMaintenanceScheduleResult',
    'GetDomainAutoTuneOptionMaintenanceScheduleDurationResult',
    'GetDomainClusterConfigResult',
    'GetDomainClusterConfigColdStorageOptionResult',
    'GetDomainClusterConfigZoneAwarenessConfigResult',
    'GetDomainCognitoOptionResult',
    'GetDomainEbsOptionResult',
    'GetDomainEncryptionAtRestResult',
    'GetDomainLogPublishingOptionResult',
    'GetDomainNodeToNodeEncryptionResult',
    'GetDomainSnapshotOptionResult',
    'GetDomainVpcOptionResult',
]

@pulumi.output_type
class DomainAdvancedSecurityOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalUserDatabaseEnabled":
            suggest = "internal_user_database_enabled"
        elif key == "masterUserOptions":
            suggest = "master_user_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAdvancedSecurityOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAdvancedSecurityOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAdvancedSecurityOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 internal_user_database_enabled: Optional[builtins.bool] = None,
                 master_user_options: Optional['outputs.DomainAdvancedSecurityOptionsMasterUserOptions'] = None):
        """
        :param builtins.bool enabled: Whether advanced security is enabled.
        :param builtins.bool internal_user_database_enabled: Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
        :param 'DomainAdvancedSecurityOptionsMasterUserOptionsArgs' master_user_options: Configuration block for the main user. Detailed below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if internal_user_database_enabled is not None:
            pulumi.set(__self__, "internal_user_database_enabled", internal_user_database_enabled)
        if master_user_options is not None:
            pulumi.set(__self__, "master_user_options", master_user_options)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether advanced security is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="internalUserDatabaseEnabled")
    def internal_user_database_enabled(self) -> Optional[builtins.bool]:
        """
        Whether the internal user database is enabled. If not set, defaults to `false` by the AWS API.
        """
        return pulumi.get(self, "internal_user_database_enabled")

    @property
    @pulumi.getter(name="masterUserOptions")
    def master_user_options(self) -> Optional['outputs.DomainAdvancedSecurityOptionsMasterUserOptions']:
        """
        Configuration block for the main user. Detailed below.
        """
        return pulumi.get(self, "master_user_options")


@pulumi.output_type
class DomainAdvancedSecurityOptionsMasterUserOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterUserArn":
            suggest = "master_user_arn"
        elif key == "masterUserName":
            suggest = "master_user_name"
        elif key == "masterUserPassword":
            suggest = "master_user_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAdvancedSecurityOptionsMasterUserOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAdvancedSecurityOptionsMasterUserOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAdvancedSecurityOptionsMasterUserOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_user_arn: Optional[builtins.str] = None,
                 master_user_name: Optional[builtins.str] = None,
                 master_user_password: Optional[builtins.str] = None):
        """
        :param builtins.str master_user_arn: ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        :param builtins.str master_user_name: Main user's username, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        :param builtins.str master_user_password: Main user's password, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        if master_user_arn is not None:
            pulumi.set(__self__, "master_user_arn", master_user_arn)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)

    @property
    @pulumi.getter(name="masterUserArn")
    def master_user_arn(self) -> Optional[builtins.str]:
        """
        ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        """
        return pulumi.get(self, "master_user_arn")

    @property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[builtins.str]:
        """
        Main user's username, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        return pulumi.get(self, "master_user_name")

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[builtins.str]:
        """
        Main user's password, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        return pulumi.get(self, "master_user_password")


@pulumi.output_type
class DomainAutoTuneOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"
        elif key == "maintenanceSchedules":
            suggest = "maintenance_schedules"
        elif key == "rollbackOnDisable":
            suggest = "rollback_on_disable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAutoTuneOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAutoTuneOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAutoTuneOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_state: builtins.str,
                 maintenance_schedules: Optional[Sequence['outputs.DomainAutoTuneOptionsMaintenanceSchedule']] = None,
                 rollback_on_disable: Optional[builtins.str] = None):
        """
        :param builtins.str desired_state: The Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        :param Sequence['DomainAutoTuneOptionsMaintenanceScheduleArgs'] maintenance_schedules: Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
        :param builtins.str rollback_on_disable: Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if rollback_on_disable is not None:
            pulumi.set(__self__, "rollback_on_disable", rollback_on_disable)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> builtins.str:
        """
        The Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[Sequence['outputs.DomainAutoTuneOptionsMaintenanceSchedule']]:
        """
        Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @property
    @pulumi.getter(name="rollbackOnDisable")
    def rollback_on_disable(self) -> Optional[builtins.str]:
        """
        Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        """
        return pulumi.get(self, "rollback_on_disable")


@pulumi.output_type
class DomainAutoTuneOptionsMaintenanceSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpressionForRecurrence":
            suggest = "cron_expression_for_recurrence"
        elif key == "startAt":
            suggest = "start_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAutoTuneOptionsMaintenanceSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAutoTuneOptionsMaintenanceSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAutoTuneOptionsMaintenanceSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression_for_recurrence: builtins.str,
                 duration: 'outputs.DomainAutoTuneOptionsMaintenanceScheduleDuration',
                 start_at: builtins.str):
        """
        :param builtins.str cron_expression_for_recurrence: A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        :param 'DomainAutoTuneOptionsMaintenanceScheduleDurationArgs' duration: Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        :param builtins.str start_at: Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        pulumi.set(__self__, "cron_expression_for_recurrence", cron_expression_for_recurrence)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_at", start_at)

    @property
    @pulumi.getter(name="cronExpressionForRecurrence")
    def cron_expression_for_recurrence(self) -> builtins.str:
        """
        A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        """
        return pulumi.get(self, "cron_expression_for_recurrence")

    @property
    @pulumi.getter
    def duration(self) -> 'outputs.DomainAutoTuneOptionsMaintenanceScheduleDuration':
        """
        Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startAt")
    def start_at(self) -> builtins.str:
        """
        Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "start_at")


@pulumi.output_type
class DomainAutoTuneOptionsMaintenanceScheduleDuration(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.int):
        """
        :param builtins.str unit: The unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        :param builtins.int value: An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        """
        The unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        """
        An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coldStorageOptions":
            suggest = "cold_storage_options"
        elif key == "dedicatedMasterCount":
            suggest = "dedicated_master_count"
        elif key == "dedicatedMasterEnabled":
            suggest = "dedicated_master_enabled"
        elif key == "dedicatedMasterType":
            suggest = "dedicated_master_type"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "warmCount":
            suggest = "warm_count"
        elif key == "warmEnabled":
            suggest = "warm_enabled"
        elif key == "warmType":
            suggest = "warm_type"
        elif key == "zoneAwarenessConfig":
            suggest = "zone_awareness_config"
        elif key == "zoneAwarenessEnabled":
            suggest = "zone_awareness_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cold_storage_options: Optional['outputs.DomainClusterConfigColdStorageOptions'] = None,
                 dedicated_master_count: Optional[builtins.int] = None,
                 dedicated_master_enabled: Optional[builtins.bool] = None,
                 dedicated_master_type: Optional[builtins.str] = None,
                 instance_count: Optional[builtins.int] = None,
                 instance_type: Optional[builtins.str] = None,
                 warm_count: Optional[builtins.int] = None,
                 warm_enabled: Optional[builtins.bool] = None,
                 warm_type: Optional[builtins.str] = None,
                 zone_awareness_config: Optional['outputs.DomainClusterConfigZoneAwarenessConfig'] = None,
                 zone_awareness_enabled: Optional[builtins.bool] = None):
        """
        :param 'DomainClusterConfigColdStorageOptionsArgs' cold_storage_options: Configuration block containing cold storage configuration. Detailed below.
        :param builtins.int dedicated_master_count: Number of dedicated main nodes in the cluster.
        :param builtins.bool dedicated_master_enabled: Whether dedicated main nodes are enabled for the cluster.
        :param builtins.str dedicated_master_type: Instance type of the dedicated main nodes in the cluster.
        :param builtins.int instance_count: Number of instances in the cluster.
        :param builtins.str instance_type: Instance type of data nodes in the cluster.
        :param builtins.int warm_count: Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        :param builtins.bool warm_enabled: Whether to enable warm storage.
        :param builtins.str warm_type: Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        :param 'DomainClusterConfigZoneAwarenessConfigArgs' zone_awareness_config: Configuration block containing zone awareness settings. Detailed below.
        :param builtins.bool zone_awareness_enabled: Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
        if cold_storage_options is not None:
            pulumi.set(__self__, "cold_storage_options", cold_storage_options)
        if dedicated_master_count is not None:
            pulumi.set(__self__, "dedicated_master_count", dedicated_master_count)
        if dedicated_master_enabled is not None:
            pulumi.set(__self__, "dedicated_master_enabled", dedicated_master_enabled)
        if dedicated_master_type is not None:
            pulumi.set(__self__, "dedicated_master_type", dedicated_master_type)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if warm_count is not None:
            pulumi.set(__self__, "warm_count", warm_count)
        if warm_enabled is not None:
            pulumi.set(__self__, "warm_enabled", warm_enabled)
        if warm_type is not None:
            pulumi.set(__self__, "warm_type", warm_type)
        if zone_awareness_config is not None:
            pulumi.set(__self__, "zone_awareness_config", zone_awareness_config)
        if zone_awareness_enabled is not None:
            pulumi.set(__self__, "zone_awareness_enabled", zone_awareness_enabled)

    @property
    @pulumi.getter(name="coldStorageOptions")
    def cold_storage_options(self) -> Optional['outputs.DomainClusterConfigColdStorageOptions']:
        """
        Configuration block containing cold storage configuration. Detailed below.
        """
        return pulumi.get(self, "cold_storage_options")

    @property
    @pulumi.getter(name="dedicatedMasterCount")
    def dedicated_master_count(self) -> Optional[builtins.int]:
        """
        Number of dedicated main nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_count")

    @property
    @pulumi.getter(name="dedicatedMasterEnabled")
    def dedicated_master_enabled(self) -> Optional[builtins.bool]:
        """
        Whether dedicated main nodes are enabled for the cluster.
        """
        return pulumi.get(self, "dedicated_master_enabled")

    @property
    @pulumi.getter(name="dedicatedMasterType")
    def dedicated_master_type(self) -> Optional[builtins.str]:
        """
        Instance type of the dedicated main nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_type")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[builtins.int]:
        """
        Number of instances in the cluster.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[builtins.str]:
        """
        Instance type of data nodes in the cluster.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="warmCount")
    def warm_count(self) -> Optional[builtins.int]:
        """
        Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        """
        return pulumi.get(self, "warm_count")

    @property
    @pulumi.getter(name="warmEnabled")
    def warm_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable warm storage.
        """
        return pulumi.get(self, "warm_enabled")

    @property
    @pulumi.getter(name="warmType")
    def warm_type(self) -> Optional[builtins.str]:
        """
        Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        """
        return pulumi.get(self, "warm_type")

    @property
    @pulumi.getter(name="zoneAwarenessConfig")
    def zone_awareness_config(self) -> Optional['outputs.DomainClusterConfigZoneAwarenessConfig']:
        """
        Configuration block containing zone awareness settings. Detailed below.
        """
        return pulumi.get(self, "zone_awareness_config")

    @property
    @pulumi.getter(name="zoneAwarenessEnabled")
    def zone_awareness_enabled(self) -> Optional[builtins.bool]:
        """
        Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
        return pulumi.get(self, "zone_awareness_enabled")


@pulumi.output_type
class DomainClusterConfigColdStorageOptions(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Boolean to enable cold storage for an Elasticsearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Boolean to enable cold storage for an Elasticsearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainClusterConfigZoneAwarenessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZoneCount":
            suggest = "availability_zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainClusterConfigZoneAwarenessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainClusterConfigZoneAwarenessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainClusterConfigZoneAwarenessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone_count: Optional[builtins.int] = None):
        """
        :param builtins.int availability_zone_count: Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
        if availability_zone_count is not None:
            pulumi.set(__self__, "availability_zone_count", availability_zone_count)

    @property
    @pulumi.getter(name="availabilityZoneCount")
    def availability_zone_count(self) -> Optional[builtins.int]:
        """
        Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
        return pulumi.get(self, "availability_zone_count")


@pulumi.output_type
class DomainCognitoOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityPoolId":
            suggest = "identity_pool_id"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "userPoolId":
            suggest = "user_pool_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainCognitoOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainCognitoOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainCognitoOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_pool_id: builtins.str,
                 role_arn: builtins.str,
                 user_pool_id: builtins.str,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str identity_pool_id: ID of the Cognito Identity Pool to use.
        :param builtins.str role_arn: ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
        :param builtins.str user_pool_id: ID of the Cognito User Pool to use.
        :param builtins.bool enabled: Whether Amazon Cognito authentication with Kibana is enabled or not.
        """
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> builtins.str:
        """
        ID of the Cognito Identity Pool to use.
        """
        return pulumi.get(self, "identity_pool_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> builtins.str:
        """
        ID of the Cognito User Pool to use.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether Amazon Cognito authentication with Kibana is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainDomainEndpointOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customEndpoint":
            suggest = "custom_endpoint"
        elif key == "customEndpointCertificateArn":
            suggest = "custom_endpoint_certificate_arn"
        elif key == "customEndpointEnabled":
            suggest = "custom_endpoint_enabled"
        elif key == "enforceHttps":
            suggest = "enforce_https"
        elif key == "tlsSecurityPolicy":
            suggest = "tls_security_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDomainEndpointOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDomainEndpointOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDomainEndpointOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_endpoint: Optional[builtins.str] = None,
                 custom_endpoint_certificate_arn: Optional[builtins.str] = None,
                 custom_endpoint_enabled: Optional[builtins.bool] = None,
                 enforce_https: Optional[builtins.bool] = None,
                 tls_security_policy: Optional[builtins.str] = None):
        """
        :param builtins.str custom_endpoint: Fully qualified domain for your custom endpoint.
        :param builtins.str custom_endpoint_certificate_arn: ACM certificate ARN for your custom endpoint.
        :param builtins.bool custom_endpoint_enabled: Whether to enable custom endpoint for the Elasticsearch domain.
        :param builtins.bool enforce_https: Whether or not to require HTTPS. Defaults to `true`.
        :param builtins.str tls_security_policy: Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07`, `Policy-Min-TLS-1-2-2019-07`, and `Policy-Min-TLS-1-2-PFS-2023-10`. Pulumi will only perform drift detection if a configuration value is provided.
        """
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if custom_endpoint_certificate_arn is not None:
            pulumi.set(__self__, "custom_endpoint_certificate_arn", custom_endpoint_certificate_arn)
        if custom_endpoint_enabled is not None:
            pulumi.set(__self__, "custom_endpoint_enabled", custom_endpoint_enabled)
        if enforce_https is not None:
            pulumi.set(__self__, "enforce_https", enforce_https)
        if tls_security_policy is not None:
            pulumi.set(__self__, "tls_security_policy", tls_security_policy)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[builtins.str]:
        """
        Fully qualified domain for your custom endpoint.
        """
        return pulumi.get(self, "custom_endpoint")

    @property
    @pulumi.getter(name="customEndpointCertificateArn")
    def custom_endpoint_certificate_arn(self) -> Optional[builtins.str]:
        """
        ACM certificate ARN for your custom endpoint.
        """
        return pulumi.get(self, "custom_endpoint_certificate_arn")

    @property
    @pulumi.getter(name="customEndpointEnabled")
    def custom_endpoint_enabled(self) -> Optional[builtins.bool]:
        """
        Whether to enable custom endpoint for the Elasticsearch domain.
        """
        return pulumi.get(self, "custom_endpoint_enabled")

    @property
    @pulumi.getter(name="enforceHttps")
    def enforce_https(self) -> Optional[builtins.bool]:
        """
        Whether or not to require HTTPS. Defaults to `true`.
        """
        return pulumi.get(self, "enforce_https")

    @property
    @pulumi.getter(name="tlsSecurityPolicy")
    def tls_security_policy(self) -> Optional[builtins.str]:
        """
        Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07`, `Policy-Min-TLS-1-2-2019-07`, and `Policy-Min-TLS-1-2-PFS-2023-10`. Pulumi will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "tls_security_policy")


@pulumi.output_type
class DomainEbsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsEnabled":
            suggest = "ebs_enabled"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainEbsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainEbsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainEbsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_enabled: builtins.bool,
                 iops: Optional[builtins.int] = None,
                 throughput: Optional[builtins.int] = None,
                 volume_size: Optional[builtins.int] = None,
                 volume_type: Optional[builtins.str] = None):
        """
        :param builtins.bool ebs_enabled: Whether EBS volumes are attached to data nodes in the domain.
        :param builtins.int iops: Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        :param builtins.int throughput: Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        :param builtins.int volume_size: Size of EBS volumes attached to data nodes (in GiB).
        :param builtins.str volume_type: Type of EBS volumes attached to data nodes.
        """
        pulumi.set(__self__, "ebs_enabled", ebs_enabled)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="ebsEnabled")
    def ebs_enabled(self) -> builtins.bool:
        """
        Whether EBS volumes are attached to data nodes in the domain.
        """
        return pulumi.get(self, "ebs_enabled")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.int]:
        """
        Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[builtins.int]:
        """
        Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[builtins.int]:
        """
        Size of EBS volumes attached to data nodes (in GiB).
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[builtins.str]:
        """
        Type of EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class DomainEncryptAtRest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainEncryptAtRest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainEncryptAtRest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainEncryptAtRest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 kms_key_id: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires `elasticsearch_version` 5.1 or greater.
        :param builtins.str kms_key_id: KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
        pulumi.set(__self__, "enabled", enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires `elasticsearch_version` 5.1 or greater.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class DomainLogPublishingOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogGroupArn":
            suggest = "cloudwatch_log_group_arn"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainLogPublishingOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainLogPublishingOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainLogPublishingOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_log_group_arn: builtins.str,
                 log_type: builtins.str,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str cloudwatch_log_group_arn: ARN of the Cloudwatch log group to which log needs to be published.
        :param builtins.str log_type: Type of Elasticsearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        :param builtins.bool enabled: Whether given log publishing option is enabled or not.
        """
        pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        pulumi.set(__self__, "log_type", log_type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> builtins.str:
        """
        ARN of the Cloudwatch log group to which log needs to be published.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        """
        Type of Elasticsearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether given log publishing option is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainNodeToNodeEncryption(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `elasticsearch_version` of `6.0` or greater.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `elasticsearch_version` of `6.0` or greater.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainSamlOptionsSamlOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterBackendRole":
            suggest = "master_backend_role"
        elif key == "masterUserName":
            suggest = "master_user_name"
        elif key == "rolesKey":
            suggest = "roles_key"
        elif key == "sessionTimeoutMinutes":
            suggest = "session_timeout_minutes"
        elif key == "subjectKey":
            suggest = "subject_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSamlOptionsSamlOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSamlOptionsSamlOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSamlOptionsSamlOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 idp: Optional['outputs.DomainSamlOptionsSamlOptionsIdp'] = None,
                 master_backend_role: Optional[builtins.str] = None,
                 master_user_name: Optional[builtins.str] = None,
                 roles_key: Optional[builtins.str] = None,
                 session_timeout_minutes: Optional[builtins.int] = None,
                 subject_key: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Whether SAML authentication is enabled.
        :param 'DomainSamlOptionsSamlOptionsIdpArgs' idp: Information from your identity provider.
        :param builtins.str master_backend_role: This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        :param builtins.str master_user_name: This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        :param builtins.str roles_key: Element of the SAML assertion to use for backend roles. Default is roles.
        :param builtins.int session_timeout_minutes: Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        :param builtins.str subject_key: Custom SAML attribute to use for user names. Default is an empty string - `""`. This will cause Elasticsearch to use the `NameID` element of the `Subject`, which is the default location for name identifiers in the SAML specification.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp is not None:
            pulumi.set(__self__, "idp", idp)
        if master_backend_role is not None:
            pulumi.set(__self__, "master_backend_role", master_backend_role)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if session_timeout_minutes is not None:
            pulumi.set(__self__, "session_timeout_minutes", session_timeout_minutes)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Whether SAML authentication is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def idp(self) -> Optional['outputs.DomainSamlOptionsSamlOptionsIdp']:
        """
        Information from your identity provider.
        """
        return pulumi.get(self, "idp")

    @property
    @pulumi.getter(name="masterBackendRole")
    def master_backend_role(self) -> Optional[builtins.str]:
        """
        This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        return pulumi.get(self, "master_backend_role")

    @property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[builtins.str]:
        """
        This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        return pulumi.get(self, "master_user_name")

    @property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[builtins.str]:
        """
        Element of the SAML assertion to use for backend roles. Default is roles.
        """
        return pulumi.get(self, "roles_key")

    @property
    @pulumi.getter(name="sessionTimeoutMinutes")
    def session_timeout_minutes(self) -> Optional[builtins.int]:
        """
        Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        """
        return pulumi.get(self, "session_timeout_minutes")

    @property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[builtins.str]:
        """
        Custom SAML attribute to use for user names. Default is an empty string - `""`. This will cause Elasticsearch to use the `NameID` element of the `Subject`, which is the default location for name identifiers in the SAML specification.
        """
        return pulumi.get(self, "subject_key")


@pulumi.output_type
class DomainSamlOptionsSamlOptionsIdp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"
        elif key == "metadataContent":
            suggest = "metadata_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSamlOptionsSamlOptionsIdp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSamlOptionsSamlOptionsIdp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSamlOptionsSamlOptionsIdp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_id: builtins.str,
                 metadata_content: builtins.str):
        """
        :param builtins.str entity_id: The unique Entity ID of the application in SAML Identity Provider.
        :param builtins.str metadata_content: The Metadata of the SAML application in xml format.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "metadata_content", metadata_content)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> builtins.str:
        """
        The unique Entity ID of the application in SAML Identity Provider.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="metadataContent")
    def metadata_content(self) -> builtins.str:
        """
        The Metadata of the SAML application in xml format.
        """
        return pulumi.get(self, "metadata_content")


@pulumi.output_type
class DomainSnapshotOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automatedSnapshotStartHour":
            suggest = "automated_snapshot_start_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSnapshotOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSnapshotOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSnapshotOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automated_snapshot_start_hour: builtins.int):
        """
        :param builtins.int automated_snapshot_start_hour: Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        pulumi.set(__self__, "automated_snapshot_start_hour", automated_snapshot_start_hour)

    @property
    @pulumi.getter(name="automatedSnapshotStartHour")
    def automated_snapshot_start_hour(self) -> builtins.int:
        """
        Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        return pulumi.get(self, "automated_snapshot_start_hour")


@pulumi.output_type
class DomainVpcOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainVpcOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainVpcOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainVpcOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zones: Optional[Sequence[builtins.str]] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] availability_zones: If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        :param Sequence[builtins.str] security_group_ids: List of VPC Security Group IDs to be applied to the Elasticsearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        :param Sequence[builtins.str] subnet_ids: List of VPC Subnet IDs for the Elasticsearch domain endpoints to be created in.
        :param builtins.str vpc_id: If the domain was created inside a VPC, the ID of the VPC.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[builtins.str]]:
        """
        If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of VPC Security Group IDs to be applied to the Elasticsearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of VPC Subnet IDs for the Elasticsearch domain endpoints to be created in.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        If the domain was created inside a VPC, the ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class VpcEndpointVpcOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcEndpointVpcOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcEndpointVpcOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcEndpointVpcOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[builtins.str],
                 availability_zones: Optional[Sequence[builtins.str]] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] subnet_ids: A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        :param Sequence[builtins.str] security_group_ids: The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, elasticsearch Service uses the default security group for the VPC.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, elasticsearch Service uses the default security group for the VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetDomainAdvancedSecurityOptionResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 internal_user_database_enabled: builtins.bool):
        """
        :param builtins.bool enabled: Whether node to node encryption is enabled.
        :param builtins.bool internal_user_database_enabled: Whether the internal user database is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "internal_user_database_enabled", internal_user_database_enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether node to node encryption is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="internalUserDatabaseEnabled")
    def internal_user_database_enabled(self) -> builtins.bool:
        """
        Whether the internal user database is enabled.
        """
        return pulumi.get(self, "internal_user_database_enabled")


@pulumi.output_type
class GetDomainAutoTuneOptionResult(dict):
    def __init__(__self__, *,
                 desired_state: builtins.str,
                 maintenance_schedules: Sequence['outputs.GetDomainAutoTuneOptionMaintenanceScheduleResult'],
                 rollback_on_disable: builtins.str):
        """
        :param builtins.str desired_state: The Auto-Tune desired state for the domain.
        :param Sequence['GetDomainAutoTuneOptionMaintenanceScheduleArgs'] maintenance_schedules: A list of the nested configurations for the Auto-Tune maintenance windows of the domain.
        :param builtins.str rollback_on_disable: Whether the domain is set to roll back to default Auto-Tune settings when disabling Auto-Tune.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        pulumi.set(__self__, "rollback_on_disable", rollback_on_disable)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> builtins.str:
        """
        The Auto-Tune desired state for the domain.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Sequence['outputs.GetDomainAutoTuneOptionMaintenanceScheduleResult']:
        """
        A list of the nested configurations for the Auto-Tune maintenance windows of the domain.
        """
        return pulumi.get(self, "maintenance_schedules")

    @property
    @pulumi.getter(name="rollbackOnDisable")
    def rollback_on_disable(self) -> builtins.str:
        """
        Whether the domain is set to roll back to default Auto-Tune settings when disabling Auto-Tune.
        """
        return pulumi.get(self, "rollback_on_disable")


@pulumi.output_type
class GetDomainAutoTuneOptionMaintenanceScheduleResult(dict):
    def __init__(__self__, *,
                 cron_expression_for_recurrence: builtins.str,
                 durations: Sequence['outputs.GetDomainAutoTuneOptionMaintenanceScheduleDurationResult'],
                 start_at: builtins.str):
        """
        :param builtins.str cron_expression_for_recurrence: Cron expression for an Auto-Tune maintenance schedule.
        :param Sequence['GetDomainAutoTuneOptionMaintenanceScheduleDurationArgs'] durations: Configuration block for the duration of the Auto-Tune maintenance window.
        :param builtins.str start_at: Date and time at which the Auto-Tune maintenance schedule starts in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        pulumi.set(__self__, "cron_expression_for_recurrence", cron_expression_for_recurrence)
        pulumi.set(__self__, "durations", durations)
        pulumi.set(__self__, "start_at", start_at)

    @property
    @pulumi.getter(name="cronExpressionForRecurrence")
    def cron_expression_for_recurrence(self) -> builtins.str:
        """
        Cron expression for an Auto-Tune maintenance schedule.
        """
        return pulumi.get(self, "cron_expression_for_recurrence")

    @property
    @pulumi.getter
    def durations(self) -> Sequence['outputs.GetDomainAutoTuneOptionMaintenanceScheduleDurationResult']:
        """
        Configuration block for the duration of the Auto-Tune maintenance window.
        """
        return pulumi.get(self, "durations")

    @property
    @pulumi.getter(name="startAt")
    def start_at(self) -> builtins.str:
        """
        Date and time at which the Auto-Tune maintenance schedule starts in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "start_at")


@pulumi.output_type
class GetDomainAutoTuneOptionMaintenanceScheduleDurationResult(dict):
    def __init__(__self__, *,
                 unit: builtins.str,
                 value: builtins.int):
        """
        :param builtins.str unit: Unit of time.
        :param builtins.int value: Duration of an Auto-Tune maintenance window.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> builtins.str:
        """
        Unit of time.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> builtins.int:
        """
        Duration of an Auto-Tune maintenance window.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDomainClusterConfigResult(dict):
    def __init__(__self__, *,
                 cold_storage_options: Sequence['outputs.GetDomainClusterConfigColdStorageOptionResult'],
                 dedicated_master_count: builtins.int,
                 dedicated_master_enabled: builtins.bool,
                 dedicated_master_type: builtins.str,
                 instance_count: builtins.int,
                 instance_type: builtins.str,
                 warm_count: builtins.int,
                 warm_enabled: builtins.bool,
                 warm_type: builtins.str,
                 zone_awareness_configs: Sequence['outputs.GetDomainClusterConfigZoneAwarenessConfigResult'],
                 zone_awareness_enabled: builtins.bool):
        """
        :param Sequence['GetDomainClusterConfigColdStorageOptionArgs'] cold_storage_options: Configuration block containing cold storage configuration.
        :param builtins.int dedicated_master_count: Number of dedicated master nodes in the cluster.
        :param builtins.bool dedicated_master_enabled: Indicates whether dedicated master nodes are enabled for the cluster.
        :param builtins.str dedicated_master_type: Instance type of the dedicated master nodes in the cluster.
        :param builtins.int instance_count: Number of instances in the cluster.
        :param builtins.str instance_type: Instance type of data nodes in the cluster.
        :param builtins.int warm_count: The number of warm nodes in the cluster.
        :param builtins.bool warm_enabled: Warm storage is enabled.
        :param builtins.str warm_type: The instance type for the Elasticsearch cluster's warm nodes.
        :param Sequence['GetDomainClusterConfigZoneAwarenessConfigArgs'] zone_awareness_configs: Configuration block containing zone awareness settings.
        :param builtins.bool zone_awareness_enabled: Indicates whether zone awareness is enabled.
        """
        pulumi.set(__self__, "cold_storage_options", cold_storage_options)
        pulumi.set(__self__, "dedicated_master_count", dedicated_master_count)
        pulumi.set(__self__, "dedicated_master_enabled", dedicated_master_enabled)
        pulumi.set(__self__, "dedicated_master_type", dedicated_master_type)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "warm_count", warm_count)
        pulumi.set(__self__, "warm_enabled", warm_enabled)
        pulumi.set(__self__, "warm_type", warm_type)
        pulumi.set(__self__, "zone_awareness_configs", zone_awareness_configs)
        pulumi.set(__self__, "zone_awareness_enabled", zone_awareness_enabled)

    @property
    @pulumi.getter(name="coldStorageOptions")
    def cold_storage_options(self) -> Sequence['outputs.GetDomainClusterConfigColdStorageOptionResult']:
        """
        Configuration block containing cold storage configuration.
        """
        return pulumi.get(self, "cold_storage_options")

    @property
    @pulumi.getter(name="dedicatedMasterCount")
    def dedicated_master_count(self) -> builtins.int:
        """
        Number of dedicated master nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_count")

    @property
    @pulumi.getter(name="dedicatedMasterEnabled")
    def dedicated_master_enabled(self) -> builtins.bool:
        """
        Indicates whether dedicated master nodes are enabled for the cluster.
        """
        return pulumi.get(self, "dedicated_master_enabled")

    @property
    @pulumi.getter(name="dedicatedMasterType")
    def dedicated_master_type(self) -> builtins.str:
        """
        Instance type of the dedicated master nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_type")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> builtins.int:
        """
        Number of instances in the cluster.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        """
        Instance type of data nodes in the cluster.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="warmCount")
    def warm_count(self) -> builtins.int:
        """
        The number of warm nodes in the cluster.
        """
        return pulumi.get(self, "warm_count")

    @property
    @pulumi.getter(name="warmEnabled")
    def warm_enabled(self) -> builtins.bool:
        """
        Warm storage is enabled.
        """
        return pulumi.get(self, "warm_enabled")

    @property
    @pulumi.getter(name="warmType")
    def warm_type(self) -> builtins.str:
        """
        The instance type for the Elasticsearch cluster's warm nodes.
        """
        return pulumi.get(self, "warm_type")

    @property
    @pulumi.getter(name="zoneAwarenessConfigs")
    def zone_awareness_configs(self) -> Sequence['outputs.GetDomainClusterConfigZoneAwarenessConfigResult']:
        """
        Configuration block containing zone awareness settings.
        """
        return pulumi.get(self, "zone_awareness_configs")

    @property
    @pulumi.getter(name="zoneAwarenessEnabled")
    def zone_awareness_enabled(self) -> builtins.bool:
        """
        Indicates whether zone awareness is enabled.
        """
        return pulumi.get(self, "zone_awareness_enabled")


@pulumi.output_type
class GetDomainClusterConfigColdStorageOptionResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Whether node to node encryption is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether node to node encryption is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetDomainClusterConfigZoneAwarenessConfigResult(dict):
    def __init__(__self__, *,
                 availability_zone_count: builtins.int):
        """
        :param builtins.int availability_zone_count: Number of availability zones used.
        """
        pulumi.set(__self__, "availability_zone_count", availability_zone_count)

    @property
    @pulumi.getter(name="availabilityZoneCount")
    def availability_zone_count(self) -> builtins.int:
        """
        Number of availability zones used.
        """
        return pulumi.get(self, "availability_zone_count")


@pulumi.output_type
class GetDomainCognitoOptionResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 identity_pool_id: builtins.str,
                 role_arn: builtins.str,
                 user_pool_id: builtins.str):
        """
        :param builtins.bool enabled: Whether node to node encryption is enabled.
        :param builtins.str identity_pool_id: The Cognito Identity pool used by the domain.
        :param builtins.str role_arn: The IAM Role with the AmazonESCognitoAccess policy attached.
        :param builtins.str user_pool_id: The Cognito User pool used by the domain.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "user_pool_id", user_pool_id)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether node to node encryption is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> builtins.str:
        """
        The Cognito Identity pool used by the domain.
        """
        return pulumi.get(self, "identity_pool_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The IAM Role with the AmazonESCognitoAccess policy attached.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> builtins.str:
        """
        The Cognito User pool used by the domain.
        """
        return pulumi.get(self, "user_pool_id")


@pulumi.output_type
class GetDomainEbsOptionResult(dict):
    def __init__(__self__, *,
                 ebs_enabled: builtins.bool,
                 iops: builtins.int,
                 throughput: builtins.int,
                 volume_size: builtins.int,
                 volume_type: builtins.str):
        """
        :param builtins.bool ebs_enabled: Whether EBS volumes are attached to data nodes in the domain.
        :param builtins.int iops: The baseline input/output (I/O) performance of EBS volumes attached to data nodes.
        :param builtins.int throughput: The throughput (in MiB/s) of the EBS volumes attached to data nodes.
        :param builtins.int volume_size: The size of EBS volumes attached to data nodes (in GB).
        :param builtins.str volume_type: The type of EBS volumes attached to data nodes.
        """
        pulumi.set(__self__, "ebs_enabled", ebs_enabled)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "throughput", throughput)
        pulumi.set(__self__, "volume_size", volume_size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="ebsEnabled")
    def ebs_enabled(self) -> builtins.bool:
        """
        Whether EBS volumes are attached to data nodes in the domain.
        """
        return pulumi.get(self, "ebs_enabled")

    @property
    @pulumi.getter
    def iops(self) -> builtins.int:
        """
        The baseline input/output (I/O) performance of EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def throughput(self) -> builtins.int:
        """
        The throughput (in MiB/s) of the EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> builtins.int:
        """
        The size of EBS volumes attached to data nodes (in GB).
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> builtins.str:
        """
        The type of EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetDomainEncryptionAtRestResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 kms_key_id: builtins.str):
        """
        :param builtins.bool enabled: Whether node to node encryption is enabled.
        :param builtins.str kms_key_id: The KMS key id used to encrypt data at rest.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether node to node encryption is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The KMS key id used to encrypt data at rest.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetDomainLogPublishingOptionResult(dict):
    def __init__(__self__, *,
                 cloudwatch_log_group_arn: builtins.str,
                 enabled: builtins.bool,
                 log_type: builtins.str):
        """
        :param builtins.str cloudwatch_log_group_arn: The CloudWatch Log Group where the logs are published.
        :param builtins.bool enabled: Whether node to node encryption is enabled.
        :param builtins.str log_type: The type of Elasticsearch log being published.
        """
        pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> builtins.str:
        """
        The CloudWatch Log Group where the logs are published.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether node to node encryption is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> builtins.str:
        """
        The type of Elasticsearch log being published.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GetDomainNodeToNodeEncryptionResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Whether node to node encryption is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether node to node encryption is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetDomainSnapshotOptionResult(dict):
    def __init__(__self__, *,
                 automated_snapshot_start_hour: builtins.int):
        """
        :param builtins.int automated_snapshot_start_hour: Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        pulumi.set(__self__, "automated_snapshot_start_hour", automated_snapshot_start_hour)

    @property
    @pulumi.getter(name="automatedSnapshotStartHour")
    def automated_snapshot_start_hour(self) -> builtins.int:
        """
        Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        return pulumi.get(self, "automated_snapshot_start_hour")


@pulumi.output_type
class GetDomainVpcOptionResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[builtins.str],
                 security_group_ids: Sequence[builtins.str],
                 subnet_ids: Sequence[builtins.str],
                 vpc_id: builtins.str):
        """
        :param Sequence[builtins.str] availability_zones: The availability zones used by the domain.
        :param Sequence[builtins.str] security_group_ids: The security groups used by the domain.
        :param Sequence[builtins.str] subnet_ids: The subnets used by the domain.
        :param builtins.str vpc_id: The VPC used by the domain.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[builtins.str]:
        """
        The availability zones used by the domain.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        The security groups used by the domain.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        The subnets used by the domain.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The VPC used by the domain.
        """
        return pulumi.get(self, "vpc_id")


