# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PipelineContentConfig',
    'PipelineContentConfigPermission',
    'PipelineNotifications',
    'PipelineThumbnailConfig',
    'PipelineThumbnailConfigPermission',
    'PresetAudio',
    'PresetAudioCodecOptions',
    'PresetThumbnails',
    'PresetVideo',
    'PresetVideoWatermark',
]

@pulumi.output_type
class PipelineContentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineContentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineContentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineContentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 storage_class: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
        :param builtins.str storage_class: The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the files and playlists that it stores in your Amazon S3 bucket.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[builtins.str]:
        """
        The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the files and playlists that it stores in your Amazon S3 bucket.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class PipelineContentConfigPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "granteeType":
            suggest = "grantee_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineContentConfigPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineContentConfigPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineContentConfigPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accesses: Optional[Sequence[builtins.str]] = None,
                 grantee: Optional[builtins.str] = None,
                 grantee_type: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] accesses: The permission that you want to give to the AWS user that you specified in `content_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
        :param builtins.str grantee: The AWS user or group that you want to have access to transcoded files and playlists.
        :param builtins.str grantee_type: Specify the type of value that appears in the `content_config_permissions.grantee` object. Valid values are `Canonical`, `Email` or `Group`.
        """
        if accesses is not None:
            pulumi.set(__self__, "accesses", accesses)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)
        if grantee_type is not None:
            pulumi.set(__self__, "grantee_type", grantee_type)

    @property
    @pulumi.getter
    def accesses(self) -> Optional[Sequence[builtins.str]]:
        """
        The permission that you want to give to the AWS user that you specified in `content_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
        """
        return pulumi.get(self, "accesses")

    @property
    @pulumi.getter
    def grantee(self) -> Optional[builtins.str]:
        """
        The AWS user or group that you want to have access to transcoded files and playlists.
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter(name="granteeType")
    def grantee_type(self) -> Optional[builtins.str]:
        """
        Specify the type of value that appears in the `content_config_permissions.grantee` object. Valid values are `Canonical`, `Email` or `Group`.
        """
        return pulumi.get(self, "grantee_type")


@pulumi.output_type
class PipelineNotifications(dict):
    def __init__(__self__, *,
                 completed: Optional[builtins.str] = None,
                 error: Optional[builtins.str] = None,
                 progressing: Optional[builtins.str] = None,
                 warning: Optional[builtins.str] = None):
        """
        :param builtins.str completed: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline.
        :param builtins.str error: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline.
        :param builtins.str progressing: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline.
        :param builtins.str warning: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline.
               
               The `thumbnail_config` object specifies information about the Amazon S3 bucket in
               which you want Elastic Transcoder to save thumbnail files: which bucket to use,
               which users you want to have access to the files, the type of access you want
               users to have, and the storage class that you want to assign to the files. If
               you specify values for `content_config`, you must also specify values for
               `thumbnail_config` even if you don't want to create thumbnails. (You control
               whether to create thumbnails when you create a job. For more information, see
               ThumbnailPattern in the topic Create Job.) If you specify values for
               `content_config` and `thumbnail_config`, omit the OutputBucket object.
        """
        if completed is not None:
            pulumi.set(__self__, "completed", completed)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if progressing is not None:
            pulumi.set(__self__, "progressing", progressing)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @property
    @pulumi.getter
    def completed(self) -> Optional[builtins.str]:
        """
        The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline.
        """
        return pulumi.get(self, "completed")

    @property
    @pulumi.getter
    def error(self) -> Optional[builtins.str]:
        """
        The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def progressing(self) -> Optional[builtins.str]:
        """
        The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline.
        """
        return pulumi.get(self, "progressing")

    @property
    @pulumi.getter
    def warning(self) -> Optional[builtins.str]:
        """
        The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline.

        The `thumbnail_config` object specifies information about the Amazon S3 bucket in
        which you want Elastic Transcoder to save thumbnail files: which bucket to use,
        which users you want to have access to the files, the type of access you want
        users to have, and the storage class that you want to assign to the files. If
        you specify values for `content_config`, you must also specify values for
        `thumbnail_config` even if you don't want to create thumbnails. (You control
        whether to create thumbnails when you create a job. For more information, see
        ThumbnailPattern in the topic Create Job.) If you specify values for
        `content_config` and `thumbnail_config`, omit the OutputBucket object.
        """
        return pulumi.get(self, "warning")


@pulumi.output_type
class PipelineThumbnailConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineThumbnailConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineThumbnailConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineThumbnailConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 storage_class: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
        :param builtins.str storage_class: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[builtins.str]:
        """
        The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class PipelineThumbnailConfigPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "granteeType":
            suggest = "grantee_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineThumbnailConfigPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineThumbnailConfigPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineThumbnailConfigPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accesses: Optional[Sequence[builtins.str]] = None,
                 grantee: Optional[builtins.str] = None,
                 grantee_type: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] accesses: The permission that you want to give to the AWS user that you specified in `thumbnail_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
        :param builtins.str grantee: The AWS user or group that you want to have access to thumbnail files.
        :param builtins.str grantee_type: Specify the type of value that appears in the `thumbnail_config_permissions.grantee` object. Valid values are `Canonical`, `Email` or `Group`.
        """
        if accesses is not None:
            pulumi.set(__self__, "accesses", accesses)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)
        if grantee_type is not None:
            pulumi.set(__self__, "grantee_type", grantee_type)

    @property
    @pulumi.getter
    def accesses(self) -> Optional[Sequence[builtins.str]]:
        """
        The permission that you want to give to the AWS user that you specified in `thumbnail_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
        """
        return pulumi.get(self, "accesses")

    @property
    @pulumi.getter
    def grantee(self) -> Optional[builtins.str]:
        """
        The AWS user or group that you want to have access to thumbnail files.
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter(name="granteeType")
    def grantee_type(self) -> Optional[builtins.str]:
        """
        Specify the type of value that appears in the `thumbnail_config_permissions.grantee` object. Valid values are `Canonical`, `Email` or `Group`.
        """
        return pulumi.get(self, "grantee_type")


@pulumi.output_type
class PresetAudio(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioPackingMode":
            suggest = "audio_packing_mode"
        elif key == "bitRate":
            suggest = "bit_rate"
        elif key == "sampleRate":
            suggest = "sample_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PresetAudio. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PresetAudio.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PresetAudio.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_packing_mode: Optional[builtins.str] = None,
                 bit_rate: Optional[builtins.str] = None,
                 channels: Optional[builtins.str] = None,
                 codec: Optional[builtins.str] = None,
                 sample_rate: Optional[builtins.str] = None):
        """
        :param builtins.str audio_packing_mode: The method of organizing audio channels and tracks. Use Audio:Channels to specify the number of channels in your output, and Audio:AudioPackingMode to specify the number of tracks and their relation to the channels. If you do not specify an Audio:AudioPackingMode, Elastic Transcoder uses SingleTrack.
        :param builtins.str bit_rate: The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.
        :param builtins.str channels: The number of audio channels in the output file
        :param builtins.str codec: The audio codec for the output file. Valid values are `AAC`, `flac`, `mp2`, `mp3`, `pcm`, and `vorbis`.
        :param builtins.str sample_rate: The sample rate of the audio stream in the output file, in hertz. Valid values are: `auto`, `22050`, `32000`, `44100`, `48000`, `96000`
        """
        if audio_packing_mode is not None:
            pulumi.set(__self__, "audio_packing_mode", audio_packing_mode)
        if bit_rate is not None:
            pulumi.set(__self__, "bit_rate", bit_rate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if sample_rate is not None:
            pulumi.set(__self__, "sample_rate", sample_rate)

    @property
    @pulumi.getter(name="audioPackingMode")
    def audio_packing_mode(self) -> Optional[builtins.str]:
        """
        The method of organizing audio channels and tracks. Use Audio:Channels to specify the number of channels in your output, and Audio:AudioPackingMode to specify the number of tracks and their relation to the channels. If you do not specify an Audio:AudioPackingMode, Elastic Transcoder uses SingleTrack.
        """
        return pulumi.get(self, "audio_packing_mode")

    @property
    @pulumi.getter(name="bitRate")
    def bit_rate(self) -> Optional[builtins.str]:
        """
        The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.
        """
        return pulumi.get(self, "bit_rate")

    @property
    @pulumi.getter
    def channels(self) -> Optional[builtins.str]:
        """
        The number of audio channels in the output file
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def codec(self) -> Optional[builtins.str]:
        """
        The audio codec for the output file. Valid values are `AAC`, `flac`, `mp2`, `mp3`, `pcm`, and `vorbis`.
        """
        return pulumi.get(self, "codec")

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> Optional[builtins.str]:
        """
        The sample rate of the audio stream in the output file, in hertz. Valid values are: `auto`, `22050`, `32000`, `44100`, `48000`, `96000`
        """
        return pulumi.get(self, "sample_rate")


@pulumi.output_type
class PresetAudioCodecOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitDepth":
            suggest = "bit_depth"
        elif key == "bitOrder":
            suggest = "bit_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PresetAudioCodecOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PresetAudioCodecOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PresetAudioCodecOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bit_depth: Optional[builtins.str] = None,
                 bit_order: Optional[builtins.str] = None,
                 profile: Optional[builtins.str] = None,
                 signed: Optional[builtins.str] = None):
        """
        :param builtins.str bit_depth: The bit depth of a sample is how many bits of information are included in the audio samples. Valid values are `16` and `24`. (FLAC/PCM Only)
        :param builtins.str bit_order: The order the bits of a PCM sample are stored in. The supported value is LittleEndian. (PCM Only)
        :param builtins.str profile: If you specified AAC for Audio:Codec, choose the AAC profile for the output file.
        :param builtins.str signed: Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned). The supported value is Signed. (PCM Only)
        """
        if bit_depth is not None:
            pulumi.set(__self__, "bit_depth", bit_depth)
        if bit_order is not None:
            pulumi.set(__self__, "bit_order", bit_order)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if signed is not None:
            pulumi.set(__self__, "signed", signed)

    @property
    @pulumi.getter(name="bitDepth")
    def bit_depth(self) -> Optional[builtins.str]:
        """
        The bit depth of a sample is how many bits of information are included in the audio samples. Valid values are `16` and `24`. (FLAC/PCM Only)
        """
        return pulumi.get(self, "bit_depth")

    @property
    @pulumi.getter(name="bitOrder")
    def bit_order(self) -> Optional[builtins.str]:
        """
        The order the bits of a PCM sample are stored in. The supported value is LittleEndian. (PCM Only)
        """
        return pulumi.get(self, "bit_order")

    @property
    @pulumi.getter
    def profile(self) -> Optional[builtins.str]:
        """
        If you specified AAC for Audio:Codec, choose the AAC profile for the output file.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def signed(self) -> Optional[builtins.str]:
        """
        Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned). The supported value is Signed. (PCM Only)
        """
        return pulumi.get(self, "signed")


@pulumi.output_type
class PresetThumbnails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aspectRatio":
            suggest = "aspect_ratio"
        elif key == "maxHeight":
            suggest = "max_height"
        elif key == "maxWidth":
            suggest = "max_width"
        elif key == "paddingPolicy":
            suggest = "padding_policy"
        elif key == "sizingPolicy":
            suggest = "sizing_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PresetThumbnails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PresetThumbnails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PresetThumbnails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aspect_ratio: Optional[builtins.str] = None,
                 format: Optional[builtins.str] = None,
                 interval: Optional[builtins.str] = None,
                 max_height: Optional[builtins.str] = None,
                 max_width: Optional[builtins.str] = None,
                 padding_policy: Optional[builtins.str] = None,
                 resolution: Optional[builtins.str] = None,
                 sizing_policy: Optional[builtins.str] = None):
        """
        :param builtins.str aspect_ratio: The aspect ratio of thumbnails. The following values are valid: auto, 1:1, 4:3, 3:2, 16:9
        :param builtins.str format: The format of thumbnails, if any. Valid formats are jpg and png.
        :param builtins.str interval: The approximate number of seconds between thumbnails. The value must be an integer. The actual interval can vary by several seconds from one thumbnail to the next.
        :param builtins.str max_height: The maximum height of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
        :param builtins.str max_width: The maximum width of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
        :param builtins.str padding_policy: When you set PaddingPolicy to Pad, Elastic Transcoder might add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail MaxWidth and MaxHeight settings.
        :param builtins.str resolution: The width and height of thumbnail files in pixels, in the format WidthxHeight, where both values are even integers. The values cannot exceed the width and height that you specified in the Video:Resolution object. (To better control resolution and aspect ratio of thumbnails, we recommend that you use the thumbnail values `max_width`, `max_height`, `sizing_policy`, and `padding_policy` instead of `resolution` and `aspect_ratio`. The two groups of settings are mutually exclusive. Do not use them together)
        :param builtins.str sizing_policy: A value that controls scaling of thumbnails. Valid values are: `Fit`, `Fill`, `Stretch`, `Keep`, `ShrinkToFit`, and `ShrinkToFill`.
        """
        if aspect_ratio is not None:
            pulumi.set(__self__, "aspect_ratio", aspect_ratio)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if max_height is not None:
            pulumi.set(__self__, "max_height", max_height)
        if max_width is not None:
            pulumi.set(__self__, "max_width", max_width)
        if padding_policy is not None:
            pulumi.set(__self__, "padding_policy", padding_policy)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if sizing_policy is not None:
            pulumi.set(__self__, "sizing_policy", sizing_policy)

    @property
    @pulumi.getter(name="aspectRatio")
    def aspect_ratio(self) -> Optional[builtins.str]:
        """
        The aspect ratio of thumbnails. The following values are valid: auto, 1:1, 4:3, 3:2, 16:9
        """
        return pulumi.get(self, "aspect_ratio")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        The format of thumbnails, if any. Valid formats are jpg and png.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def interval(self) -> Optional[builtins.str]:
        """
        The approximate number of seconds between thumbnails. The value must be an integer. The actual interval can vary by several seconds from one thumbnail to the next.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="maxHeight")
    def max_height(self) -> Optional[builtins.str]:
        """
        The maximum height of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
        """
        return pulumi.get(self, "max_height")

    @property
    @pulumi.getter(name="maxWidth")
    def max_width(self) -> Optional[builtins.str]:
        """
        The maximum width of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
        """
        return pulumi.get(self, "max_width")

    @property
    @pulumi.getter(name="paddingPolicy")
    def padding_policy(self) -> Optional[builtins.str]:
        """
        When you set PaddingPolicy to Pad, Elastic Transcoder might add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail MaxWidth and MaxHeight settings.
        """
        return pulumi.get(self, "padding_policy")

    @property
    @pulumi.getter
    def resolution(self) -> Optional[builtins.str]:
        """
        The width and height of thumbnail files in pixels, in the format WidthxHeight, where both values are even integers. The values cannot exceed the width and height that you specified in the Video:Resolution object. (To better control resolution and aspect ratio of thumbnails, we recommend that you use the thumbnail values `max_width`, `max_height`, `sizing_policy`, and `padding_policy` instead of `resolution` and `aspect_ratio`. The two groups of settings are mutually exclusive. Do not use them together)
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter(name="sizingPolicy")
    def sizing_policy(self) -> Optional[builtins.str]:
        """
        A value that controls scaling of thumbnails. Valid values are: `Fit`, `Fill`, `Stretch`, `Keep`, `ShrinkToFit`, and `ShrinkToFill`.
        """
        return pulumi.get(self, "sizing_policy")


@pulumi.output_type
class PresetVideo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aspectRatio":
            suggest = "aspect_ratio"
        elif key == "bitRate":
            suggest = "bit_rate"
        elif key == "displayAspectRatio":
            suggest = "display_aspect_ratio"
        elif key == "fixedGop":
            suggest = "fixed_gop"
        elif key == "frameRate":
            suggest = "frame_rate"
        elif key == "keyframesMaxDist":
            suggest = "keyframes_max_dist"
        elif key == "maxFrameRate":
            suggest = "max_frame_rate"
        elif key == "maxHeight":
            suggest = "max_height"
        elif key == "maxWidth":
            suggest = "max_width"
        elif key == "paddingPolicy":
            suggest = "padding_policy"
        elif key == "sizingPolicy":
            suggest = "sizing_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PresetVideo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PresetVideo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PresetVideo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aspect_ratio: Optional[builtins.str] = None,
                 bit_rate: Optional[builtins.str] = None,
                 codec: Optional[builtins.str] = None,
                 display_aspect_ratio: Optional[builtins.str] = None,
                 fixed_gop: Optional[builtins.str] = None,
                 frame_rate: Optional[builtins.str] = None,
                 keyframes_max_dist: Optional[builtins.str] = None,
                 max_frame_rate: Optional[builtins.str] = None,
                 max_height: Optional[builtins.str] = None,
                 max_width: Optional[builtins.str] = None,
                 padding_policy: Optional[builtins.str] = None,
                 resolution: Optional[builtins.str] = None,
                 sizing_policy: Optional[builtins.str] = None):
        """
        :param builtins.str aspect_ratio: The display aspect ratio of the video in the output file. Valid values are: `auto`, `1:1`, `4:3`, `3:2`, `16:9`. (Note; to better control resolution and aspect ratio of output videos, we recommend that you use the values `max_width`, `max_height`, `sizing_policy`, `padding_policy`, and `display_aspect_ratio` instead of `resolution` and `aspect_ratio`.)
        :param builtins.str bit_rate: The bit rate of the video stream in the output file, in kilobits/second. You can configure variable bit rate or constant bit rate encoding.
        :param builtins.str codec: The video codec for the output file. Valid values are `gif`, `H.264`, `mpeg2`, `vp8`, and `vp9`.
        :param builtins.str display_aspect_ratio: The value that Elastic Transcoder adds to the metadata in the output file. If you set DisplayAspectRatio to auto, Elastic Transcoder chooses an aspect ratio that ensures square pixels. If you specify another option, Elastic Transcoder sets that value in the output file.
        :param builtins.str fixed_gop: Whether to use a fixed value for Video:FixedGOP. Not applicable for containers of type gif. Valid values are true and false. Also known as, Fixed Number of Frames Between Keyframes.
        :param builtins.str frame_rate: The frames per second for the video stream in the output file. The following values are valid: `auto`, `10`, `15`, `23.97`, `24`, `25`, `29.97`, `30`, `50`, `60`.
        :param builtins.str keyframes_max_dist: The maximum number of frames between key frames. Not applicable for containers of type gif.
        :param builtins.str max_frame_rate: If you specify auto for FrameRate, Elastic Transcoder uses the frame rate of the input video for the frame rate of the output video, up to the maximum frame rate. If you do not specify a MaxFrameRate, Elastic Transcoder will use a default of 30.
        :param builtins.str max_height: The maximum height of the output video in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 96 and 3072, inclusive.
        :param builtins.str max_width: The maximum width of the output video in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 128 and 4096, inclusive.
        :param builtins.str padding_policy: When you set PaddingPolicy to Pad, Elastic Transcoder might add black bars to the top and bottom and/or left and right sides of the output video to make the total size of the output video match the values that you specified for `max_width` and `max_height`.
        :param builtins.str resolution: The width and height of the video in the output file, in pixels. Valid values are `auto` and `widthxheight`. (see note for `aspect_ratio`)
        :param builtins.str sizing_policy: A value that controls scaling of the output video. Valid values are: `Fit`, `Fill`, `Stretch`, `Keep`, `ShrinkToFit`, `ShrinkToFill`.
        """
        if aspect_ratio is not None:
            pulumi.set(__self__, "aspect_ratio", aspect_ratio)
        if bit_rate is not None:
            pulumi.set(__self__, "bit_rate", bit_rate)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if display_aspect_ratio is not None:
            pulumi.set(__self__, "display_aspect_ratio", display_aspect_ratio)
        if fixed_gop is not None:
            pulumi.set(__self__, "fixed_gop", fixed_gop)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if keyframes_max_dist is not None:
            pulumi.set(__self__, "keyframes_max_dist", keyframes_max_dist)
        if max_frame_rate is not None:
            pulumi.set(__self__, "max_frame_rate", max_frame_rate)
        if max_height is not None:
            pulumi.set(__self__, "max_height", max_height)
        if max_width is not None:
            pulumi.set(__self__, "max_width", max_width)
        if padding_policy is not None:
            pulumi.set(__self__, "padding_policy", padding_policy)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if sizing_policy is not None:
            pulumi.set(__self__, "sizing_policy", sizing_policy)

    @property
    @pulumi.getter(name="aspectRatio")
    def aspect_ratio(self) -> Optional[builtins.str]:
        """
        The display aspect ratio of the video in the output file. Valid values are: `auto`, `1:1`, `4:3`, `3:2`, `16:9`. (Note; to better control resolution and aspect ratio of output videos, we recommend that you use the values `max_width`, `max_height`, `sizing_policy`, `padding_policy`, and `display_aspect_ratio` instead of `resolution` and `aspect_ratio`.)
        """
        return pulumi.get(self, "aspect_ratio")

    @property
    @pulumi.getter(name="bitRate")
    def bit_rate(self) -> Optional[builtins.str]:
        """
        The bit rate of the video stream in the output file, in kilobits/second. You can configure variable bit rate or constant bit rate encoding.
        """
        return pulumi.get(self, "bit_rate")

    @property
    @pulumi.getter
    def codec(self) -> Optional[builtins.str]:
        """
        The video codec for the output file. Valid values are `gif`, `H.264`, `mpeg2`, `vp8`, and `vp9`.
        """
        return pulumi.get(self, "codec")

    @property
    @pulumi.getter(name="displayAspectRatio")
    def display_aspect_ratio(self) -> Optional[builtins.str]:
        """
        The value that Elastic Transcoder adds to the metadata in the output file. If you set DisplayAspectRatio to auto, Elastic Transcoder chooses an aspect ratio that ensures square pixels. If you specify another option, Elastic Transcoder sets that value in the output file.
        """
        return pulumi.get(self, "display_aspect_ratio")

    @property
    @pulumi.getter(name="fixedGop")
    def fixed_gop(self) -> Optional[builtins.str]:
        """
        Whether to use a fixed value for Video:FixedGOP. Not applicable for containers of type gif. Valid values are true and false. Also known as, Fixed Number of Frames Between Keyframes.
        """
        return pulumi.get(self, "fixed_gop")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[builtins.str]:
        """
        The frames per second for the video stream in the output file. The following values are valid: `auto`, `10`, `15`, `23.97`, `24`, `25`, `29.97`, `30`, `50`, `60`.
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter(name="keyframesMaxDist")
    def keyframes_max_dist(self) -> Optional[builtins.str]:
        """
        The maximum number of frames between key frames. Not applicable for containers of type gif.
        """
        return pulumi.get(self, "keyframes_max_dist")

    @property
    @pulumi.getter(name="maxFrameRate")
    def max_frame_rate(self) -> Optional[builtins.str]:
        """
        If you specify auto for FrameRate, Elastic Transcoder uses the frame rate of the input video for the frame rate of the output video, up to the maximum frame rate. If you do not specify a MaxFrameRate, Elastic Transcoder will use a default of 30.
        """
        return pulumi.get(self, "max_frame_rate")

    @property
    @pulumi.getter(name="maxHeight")
    def max_height(self) -> Optional[builtins.str]:
        """
        The maximum height of the output video in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 96 and 3072, inclusive.
        """
        return pulumi.get(self, "max_height")

    @property
    @pulumi.getter(name="maxWidth")
    def max_width(self) -> Optional[builtins.str]:
        """
        The maximum width of the output video in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 128 and 4096, inclusive.
        """
        return pulumi.get(self, "max_width")

    @property
    @pulumi.getter(name="paddingPolicy")
    def padding_policy(self) -> Optional[builtins.str]:
        """
        When you set PaddingPolicy to Pad, Elastic Transcoder might add black bars to the top and bottom and/or left and right sides of the output video to make the total size of the output video match the values that you specified for `max_width` and `max_height`.
        """
        return pulumi.get(self, "padding_policy")

    @property
    @pulumi.getter
    def resolution(self) -> Optional[builtins.str]:
        """
        The width and height of the video in the output file, in pixels. Valid values are `auto` and `widthxheight`. (see note for `aspect_ratio`)
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter(name="sizingPolicy")
    def sizing_policy(self) -> Optional[builtins.str]:
        """
        A value that controls scaling of the output video. Valid values are: `Fit`, `Fill`, `Stretch`, `Keep`, `ShrinkToFit`, `ShrinkToFill`.
        """
        return pulumi.get(self, "sizing_policy")


@pulumi.output_type
class PresetVideoWatermark(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "horizontalAlign":
            suggest = "horizontal_align"
        elif key == "horizontalOffset":
            suggest = "horizontal_offset"
        elif key == "maxHeight":
            suggest = "max_height"
        elif key == "maxWidth":
            suggest = "max_width"
        elif key == "sizingPolicy":
            suggest = "sizing_policy"
        elif key == "verticalAlign":
            suggest = "vertical_align"
        elif key == "verticalOffset":
            suggest = "vertical_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PresetVideoWatermark. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PresetVideoWatermark.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PresetVideoWatermark.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 horizontal_align: Optional[builtins.str] = None,
                 horizontal_offset: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 max_height: Optional[builtins.str] = None,
                 max_width: Optional[builtins.str] = None,
                 opacity: Optional[builtins.str] = None,
                 sizing_policy: Optional[builtins.str] = None,
                 target: Optional[builtins.str] = None,
                 vertical_align: Optional[builtins.str] = None,
                 vertical_offset: Optional[builtins.str] = None):
        """
        :param builtins.str horizontal_align: The horizontal position of the watermark unless you specify a nonzero value for `horzontal_offset`.
        :param builtins.str horizontal_offset: The amount by which you want the horizontal position of the watermark to be offset from the position specified by `horizontal_align`.
        :param builtins.str id: A unique identifier for the settings for one watermark. The value of Id can be up to 40 characters long. You can specify settings for up to four watermarks.
        :param builtins.str max_height: The maximum height of the watermark.
        :param builtins.str max_width: The maximum width of the watermark.
        :param builtins.str opacity: A percentage that indicates how much you want a watermark to obscure the video in the location where it appears.
        :param builtins.str sizing_policy: A value that controls scaling of the watermark. Valid values are: `Fit`, `Stretch`, `ShrinkToFit`
        :param builtins.str target: A value that determines how Elastic Transcoder interprets values that you specified for `video_watermarks.horizontal_offset`, `video_watermarks.vertical_offset`, `video_watermarks.max_width`, and `video_watermarks.max_height`. Valid values are `Content` and `Frame`.
        :param builtins.str vertical_align: The vertical position of the watermark unless you specify a nonzero value for `vertical_align`. Valid values are `Top`, `Bottom`, `Center`.
        :param builtins.str vertical_offset: The amount by which you want the vertical position of the watermark to be offset from the position specified by `vertical_align`
        """
        if horizontal_align is not None:
            pulumi.set(__self__, "horizontal_align", horizontal_align)
        if horizontal_offset is not None:
            pulumi.set(__self__, "horizontal_offset", horizontal_offset)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_height is not None:
            pulumi.set(__self__, "max_height", max_height)
        if max_width is not None:
            pulumi.set(__self__, "max_width", max_width)
        if opacity is not None:
            pulumi.set(__self__, "opacity", opacity)
        if sizing_policy is not None:
            pulumi.set(__self__, "sizing_policy", sizing_policy)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if vertical_align is not None:
            pulumi.set(__self__, "vertical_align", vertical_align)
        if vertical_offset is not None:
            pulumi.set(__self__, "vertical_offset", vertical_offset)

    @property
    @pulumi.getter(name="horizontalAlign")
    def horizontal_align(self) -> Optional[builtins.str]:
        """
        The horizontal position of the watermark unless you specify a nonzero value for `horzontal_offset`.
        """
        return pulumi.get(self, "horizontal_align")

    @property
    @pulumi.getter(name="horizontalOffset")
    def horizontal_offset(self) -> Optional[builtins.str]:
        """
        The amount by which you want the horizontal position of the watermark to be offset from the position specified by `horizontal_align`.
        """
        return pulumi.get(self, "horizontal_offset")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        A unique identifier for the settings for one watermark. The value of Id can be up to 40 characters long. You can specify settings for up to four watermarks.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxHeight")
    def max_height(self) -> Optional[builtins.str]:
        """
        The maximum height of the watermark.
        """
        return pulumi.get(self, "max_height")

    @property
    @pulumi.getter(name="maxWidth")
    def max_width(self) -> Optional[builtins.str]:
        """
        The maximum width of the watermark.
        """
        return pulumi.get(self, "max_width")

    @property
    @pulumi.getter
    def opacity(self) -> Optional[builtins.str]:
        """
        A percentage that indicates how much you want a watermark to obscure the video in the location where it appears.
        """
        return pulumi.get(self, "opacity")

    @property
    @pulumi.getter(name="sizingPolicy")
    def sizing_policy(self) -> Optional[builtins.str]:
        """
        A value that controls scaling of the watermark. Valid values are: `Fit`, `Stretch`, `ShrinkToFit`
        """
        return pulumi.get(self, "sizing_policy")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        A value that determines how Elastic Transcoder interprets values that you specified for `video_watermarks.horizontal_offset`, `video_watermarks.vertical_offset`, `video_watermarks.max_width`, and `video_watermarks.max_height`. Valid values are `Content` and `Frame`.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="verticalAlign")
    def vertical_align(self) -> Optional[builtins.str]:
        """
        The vertical position of the watermark unless you specify a nonzero value for `vertical_align`. Valid values are `Top`, `Bottom`, `Center`.
        """
        return pulumi.get(self, "vertical_align")

    @property
    @pulumi.getter(name="verticalOffset")
    def vertical_offset(self) -> Optional[builtins.str]:
        """
        The amount by which you want the vertical position of the watermark to be offset from the position specified by `vertical_align`
        """
        return pulumi.get(self, "vertical_offset")


