# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerPolicyArgs', 'LoadBalancerPolicy']

@pulumi.input_type
class LoadBalancerPolicyArgs:
    def __init__(__self__, *,
                 load_balancer_name: pulumi.Input[builtins.str],
                 policy_name: pulumi.Input[builtins.str],
                 policy_type_name: pulumi.Input[builtins.str],
                 policy_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPolicyPolicyAttributeArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancerPolicy resource.
        :param pulumi.Input[builtins.str] load_balancer_name: The load balancer on which the policy is defined.
        :param pulumi.Input[builtins.str] policy_name: The name of the load balancer policy.
        :param pulumi.Input[builtins.str] policy_type_name: The policy type.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPolicyPolicyAttributeArgs']]] policy_attributes: Policy attribute to apply to the policy.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "policy_type_name", policy_type_name)
        if policy_attributes is not None:
            pulumi.set(__self__, "policy_attributes", policy_attributes)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Input[builtins.str]:
        """
        The load balancer on which the policy is defined.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the load balancer policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter(name="policyTypeName")
    def policy_type_name(self) -> pulumi.Input[builtins.str]:
        """
        The policy type.
        """
        return pulumi.get(self, "policy_type_name")

    @policy_type_name.setter
    def policy_type_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_type_name", value)

    @property
    @pulumi.getter(name="policyAttributes")
    def policy_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPolicyPolicyAttributeArgs']]]]:
        """
        Policy attribute to apply to the policy.
        """
        return pulumi.get(self, "policy_attributes")

    @policy_attributes.setter
    def policy_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPolicyPolicyAttributeArgs']]]]):
        pulumi.set(self, "policy_attributes", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LoadBalancerPolicyState:
    def __init__(__self__, *,
                 load_balancer_name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPolicyPolicyAttributeArgs']]]] = None,
                 policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_type_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerPolicy resources.
        :param pulumi.Input[builtins.str] load_balancer_name: The load balancer on which the policy is defined.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPolicyPolicyAttributeArgs']]] policy_attributes: Policy attribute to apply to the policy.
        :param pulumi.Input[builtins.str] policy_name: The name of the load balancer policy.
        :param pulumi.Input[builtins.str] policy_type_name: The policy type.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if policy_attributes is not None:
            pulumi.set(__self__, "policy_attributes", policy_attributes)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if policy_type_name is not None:
            pulumi.set(__self__, "policy_type_name", policy_type_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The load balancer on which the policy is defined.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="policyAttributes")
    def policy_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPolicyPolicyAttributeArgs']]]]:
        """
        Policy attribute to apply to the policy.
        """
        return pulumi.get(self, "policy_attributes")

    @policy_attributes.setter
    def policy_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPolicyPolicyAttributeArgs']]]]):
        pulumi.set(self, "policy_attributes", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the load balancer policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter(name="policyTypeName")
    def policy_type_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy type.
        """
        return pulumi.get(self, "policy_type_name")

    @policy_type_name.setter
    def policy_type_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_type_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:elb/loadBalancerPolicy:LoadBalancerPolicy")
class LoadBalancerPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 load_balancer_name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPolicyPolicyAttributeArgs', 'LoadBalancerPolicyPolicyAttributeArgsDict']]]]] = None,
                 policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_type_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a load balancer policy, which can be attached to an ELB listener or backend server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        wu_tang = aws.elb.LoadBalancer("wu-tang",
            name="wu-tang",
            availability_zones=["us-east-1a"],
            listeners=[{
                "instance_port": 443,
                "instance_protocol": "http",
                "lb_port": 443,
                "lb_protocol": "https",
                "ssl_certificate_id": "arn:aws:iam::000000000000:server-certificate/wu-tang.net",
            }],
            tags={
                "Name": "wu-tang",
            })
        wu_tang_ca_pubkey_policy = aws.elb.LoadBalancerPolicy("wu-tang-ca-pubkey-policy",
            load_balancer_name=wu_tang.name,
            policy_name="wu-tang-ca-pubkey-policy",
            policy_type_name="PublicKeyPolicyType",
            policy_attributes=[{
                "name": "PublicKey",
                "value": std.file(input="wu-tang-pubkey").result,
            }])
        wu_tang_root_ca_backend_auth_policy = aws.elb.LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy",
            load_balancer_name=wu_tang.name,
            policy_name="wu-tang-root-ca-backend-auth-policy",
            policy_type_name="BackendServerAuthenticationPolicyType",
            policy_attributes=[{
                "name": "PublicKeyPolicyName",
                "value": wu_tang_root_ca_pubkey_policy["policyName"],
            }])
        wu_tang_ssl = aws.elb.LoadBalancerPolicy("wu-tang-ssl",
            load_balancer_name=wu_tang.name,
            policy_name="wu-tang-ssl",
            policy_type_name="SSLNegotiationPolicyType",
            policy_attributes=[
                {
                    "name": "ECDHE-ECDSA-AES128-GCM-SHA256",
                    "value": "true",
                },
                {
                    "name": "Protocol-TLSv1.2",
                    "value": "true",
                },
            ])
        wu_tang_ssl_tls_1_1 = aws.elb.LoadBalancerPolicy("wu-tang-ssl-tls-1-1",
            load_balancer_name=wu_tang.name,
            policy_name="wu-tang-ssl",
            policy_type_name="SSLNegotiationPolicyType",
            policy_attributes=[{
                "name": "Reference-Security-Policy",
                "value": "ELBSecurityPolicy-TLS-1-1-2017-01",
            }])
        wu_tang_backend_auth_policies_443 = aws.elb.LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443",
            load_balancer_name=wu_tang.name,
            instance_port=443,
            policy_names=[wu_tang_root_ca_backend_auth_policy.policy_name])
        wu_tang_listener_policies_443 = aws.elb.ListenerPolicy("wu-tang-listener-policies-443",
            load_balancer_name=wu_tang.name,
            load_balancer_port=443,
            policy_names=[wu_tang_ssl.policy_name])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] load_balancer_name: The load balancer on which the policy is defined.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPolicyPolicyAttributeArgs', 'LoadBalancerPolicyPolicyAttributeArgsDict']]]] policy_attributes: Policy attribute to apply to the policy.
        :param pulumi.Input[builtins.str] policy_name: The name of the load balancer policy.
        :param pulumi.Input[builtins.str] policy_type_name: The policy type.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a load balancer policy, which can be attached to an ELB listener or backend server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        wu_tang = aws.elb.LoadBalancer("wu-tang",
            name="wu-tang",
            availability_zones=["us-east-1a"],
            listeners=[{
                "instance_port": 443,
                "instance_protocol": "http",
                "lb_port": 443,
                "lb_protocol": "https",
                "ssl_certificate_id": "arn:aws:iam::000000000000:server-certificate/wu-tang.net",
            }],
            tags={
                "Name": "wu-tang",
            })
        wu_tang_ca_pubkey_policy = aws.elb.LoadBalancerPolicy("wu-tang-ca-pubkey-policy",
            load_balancer_name=wu_tang.name,
            policy_name="wu-tang-ca-pubkey-policy",
            policy_type_name="PublicKeyPolicyType",
            policy_attributes=[{
                "name": "PublicKey",
                "value": std.file(input="wu-tang-pubkey").result,
            }])
        wu_tang_root_ca_backend_auth_policy = aws.elb.LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy",
            load_balancer_name=wu_tang.name,
            policy_name="wu-tang-root-ca-backend-auth-policy",
            policy_type_name="BackendServerAuthenticationPolicyType",
            policy_attributes=[{
                "name": "PublicKeyPolicyName",
                "value": wu_tang_root_ca_pubkey_policy["policyName"],
            }])
        wu_tang_ssl = aws.elb.LoadBalancerPolicy("wu-tang-ssl",
            load_balancer_name=wu_tang.name,
            policy_name="wu-tang-ssl",
            policy_type_name="SSLNegotiationPolicyType",
            policy_attributes=[
                {
                    "name": "ECDHE-ECDSA-AES128-GCM-SHA256",
                    "value": "true",
                },
                {
                    "name": "Protocol-TLSv1.2",
                    "value": "true",
                },
            ])
        wu_tang_ssl_tls_1_1 = aws.elb.LoadBalancerPolicy("wu-tang-ssl-tls-1-1",
            load_balancer_name=wu_tang.name,
            policy_name="wu-tang-ssl",
            policy_type_name="SSLNegotiationPolicyType",
            policy_attributes=[{
                "name": "Reference-Security-Policy",
                "value": "ELBSecurityPolicy-TLS-1-1-2017-01",
            }])
        wu_tang_backend_auth_policies_443 = aws.elb.LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443",
            load_balancer_name=wu_tang.name,
            instance_port=443,
            policy_names=[wu_tang_root_ca_backend_auth_policy.policy_name])
        wu_tang_listener_policies_443 = aws.elb.ListenerPolicy("wu-tang-listener-policies-443",
            load_balancer_name=wu_tang.name,
            load_balancer_port=443,
            policy_names=[wu_tang_ssl.policy_name])
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 load_balancer_name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPolicyPolicyAttributeArgs', 'LoadBalancerPolicyPolicyAttributeArgsDict']]]]] = None,
                 policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_type_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerPolicyArgs.__new__(LoadBalancerPolicyArgs)

            if load_balancer_name is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_name'")
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            __props__.__dict__["policy_attributes"] = policy_attributes
            if policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_name'")
            __props__.__dict__["policy_name"] = policy_name
            if policy_type_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_type_name'")
            __props__.__dict__["policy_type_name"] = policy_type_name
            __props__.__dict__["region"] = region
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:elasticloadbalancing/loadBalancerPolicy:LoadBalancerPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(LoadBalancerPolicy, __self__).__init__(
            'aws:elb/loadBalancerPolicy:LoadBalancerPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            load_balancer_name: Optional[pulumi.Input[builtins.str]] = None,
            policy_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPolicyPolicyAttributeArgs', 'LoadBalancerPolicyPolicyAttributeArgsDict']]]]] = None,
            policy_name: Optional[pulumi.Input[builtins.str]] = None,
            policy_type_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'LoadBalancerPolicy':
        """
        Get an existing LoadBalancerPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] load_balancer_name: The load balancer on which the policy is defined.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerPolicyPolicyAttributeArgs', 'LoadBalancerPolicyPolicyAttributeArgsDict']]]] policy_attributes: Policy attribute to apply to the policy.
        :param pulumi.Input[builtins.str] policy_name: The name of the load balancer policy.
        :param pulumi.Input[builtins.str] policy_type_name: The policy type.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerPolicyState.__new__(_LoadBalancerPolicyState)

        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["policy_attributes"] = policy_attributes
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["policy_type_name"] = policy_type_name
        __props__.__dict__["region"] = region
        return LoadBalancerPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[builtins.str]:
        """
        The load balancer on which the policy is defined.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="policyAttributes")
    def policy_attributes(self) -> pulumi.Output[Sequence['outputs.LoadBalancerPolicyPolicyAttribute']]:
        """
        Policy attribute to apply to the policy.
        """
        return pulumi.get(self, "policy_attributes")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the load balancer policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyTypeName")
    def policy_type_name(self) -> pulumi.Output[builtins.str]:
        """
        The policy type.
        """
        return pulumi.get(self, "policy_type_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

