# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 release_label: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 auto_start_configuration: Optional[pulumi.Input['ApplicationAutoStartConfigurationArgs']] = None,
                 auto_stop_configuration: Optional[pulumi.Input['ApplicationAutoStopConfigurationArgs']] = None,
                 image_configuration: Optional[pulumi.Input['ApplicationImageConfigurationArgs']] = None,
                 initial_capacities: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationInitialCapacityArgs']]]] = None,
                 interactive_configuration: Optional[pulumi.Input['ApplicationInteractiveConfigurationArgs']] = None,
                 maximum_capacity: Optional[pulumi.Input['ApplicationMaximumCapacityArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['ApplicationNetworkConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[builtins.str] release_label: The EMR release version associated with the application.
        :param pulumi.Input[builtins.str] type: The type of application you want to start, such as `spark` or `hive`.
        :param pulumi.Input[builtins.str] architecture: The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
        :param pulumi.Input['ApplicationAutoStartConfigurationArgs'] auto_start_configuration: The configuration for an application to automatically start on job submission.
        :param pulumi.Input['ApplicationAutoStopConfigurationArgs'] auto_stop_configuration: The configuration for an application to automatically stop after a certain amount of time being idle.
        :param pulumi.Input['ApplicationImageConfigurationArgs'] image_configuration: The image configuration applied to all worker types.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationInitialCapacityArgs']]] initial_capacities: The capacity to initialize when the application is created.
        :param pulumi.Input['ApplicationInteractiveConfigurationArgs'] interactive_configuration: Enables the interactive use cases to use when running an application.
        :param pulumi.Input['ApplicationMaximumCapacityArgs'] maximum_capacity: The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input['ApplicationNetworkConfigurationArgs'] network_configuration: The network configuration for customer VPC connectivity.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "release_label", release_label)
        pulumi.set(__self__, "type", type)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if auto_start_configuration is not None:
            pulumi.set(__self__, "auto_start_configuration", auto_start_configuration)
        if auto_stop_configuration is not None:
            pulumi.set(__self__, "auto_stop_configuration", auto_stop_configuration)
        if image_configuration is not None:
            pulumi.set(__self__, "image_configuration", image_configuration)
        if initial_capacities is not None:
            pulumi.set(__self__, "initial_capacities", initial_capacities)
        if interactive_configuration is not None:
            pulumi.set(__self__, "interactive_configuration", interactive_configuration)
        if maximum_capacity is not None:
            pulumi.set(__self__, "maximum_capacity", maximum_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Input[builtins.str]:
        """
        The EMR release version associated with the application.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "release_label", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of application you want to start, such as `spark` or `hive`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="autoStartConfiguration")
    def auto_start_configuration(self) -> Optional[pulumi.Input['ApplicationAutoStartConfigurationArgs']]:
        """
        The configuration for an application to automatically start on job submission.
        """
        return pulumi.get(self, "auto_start_configuration")

    @auto_start_configuration.setter
    def auto_start_configuration(self, value: Optional[pulumi.Input['ApplicationAutoStartConfigurationArgs']]):
        pulumi.set(self, "auto_start_configuration", value)

    @property
    @pulumi.getter(name="autoStopConfiguration")
    def auto_stop_configuration(self) -> Optional[pulumi.Input['ApplicationAutoStopConfigurationArgs']]:
        """
        The configuration for an application to automatically stop after a certain amount of time being idle.
        """
        return pulumi.get(self, "auto_stop_configuration")

    @auto_stop_configuration.setter
    def auto_stop_configuration(self, value: Optional[pulumi.Input['ApplicationAutoStopConfigurationArgs']]):
        pulumi.set(self, "auto_stop_configuration", value)

    @property
    @pulumi.getter(name="imageConfiguration")
    def image_configuration(self) -> Optional[pulumi.Input['ApplicationImageConfigurationArgs']]:
        """
        The image configuration applied to all worker types.
        """
        return pulumi.get(self, "image_configuration")

    @image_configuration.setter
    def image_configuration(self, value: Optional[pulumi.Input['ApplicationImageConfigurationArgs']]):
        pulumi.set(self, "image_configuration", value)

    @property
    @pulumi.getter(name="initialCapacities")
    def initial_capacities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationInitialCapacityArgs']]]]:
        """
        The capacity to initialize when the application is created.
        """
        return pulumi.get(self, "initial_capacities")

    @initial_capacities.setter
    def initial_capacities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationInitialCapacityArgs']]]]):
        pulumi.set(self, "initial_capacities", value)

    @property
    @pulumi.getter(name="interactiveConfiguration")
    def interactive_configuration(self) -> Optional[pulumi.Input['ApplicationInteractiveConfigurationArgs']]:
        """
        Enables the interactive use cases to use when running an application.
        """
        return pulumi.get(self, "interactive_configuration")

    @interactive_configuration.setter
    def interactive_configuration(self, value: Optional[pulumi.Input['ApplicationInteractiveConfigurationArgs']]):
        pulumi.set(self, "interactive_configuration", value)

    @property
    @pulumi.getter(name="maximumCapacity")
    def maximum_capacity(self) -> Optional[pulumi.Input['ApplicationMaximumCapacityArgs']]:
        """
        The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
        """
        return pulumi.get(self, "maximum_capacity")

    @maximum_capacity.setter
    def maximum_capacity(self, value: Optional[pulumi.Input['ApplicationMaximumCapacityArgs']]):
        pulumi.set(self, "maximum_capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['ApplicationNetworkConfigurationArgs']]:
        """
        The network configuration for customer VPC connectivity.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['ApplicationNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 auto_start_configuration: Optional[pulumi.Input['ApplicationAutoStartConfigurationArgs']] = None,
                 auto_stop_configuration: Optional[pulumi.Input['ApplicationAutoStopConfigurationArgs']] = None,
                 image_configuration: Optional[pulumi.Input['ApplicationImageConfigurationArgs']] = None,
                 initial_capacities: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationInitialCapacityArgs']]]] = None,
                 interactive_configuration: Optional[pulumi.Input['ApplicationInteractiveConfigurationArgs']] = None,
                 maximum_capacity: Optional[pulumi.Input['ApplicationMaximumCapacityArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input['ApplicationNetworkConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 release_label: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[builtins.str] architecture: The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
        :param pulumi.Input[builtins.str] arn: ARN of the cluster.
        :param pulumi.Input['ApplicationAutoStartConfigurationArgs'] auto_start_configuration: The configuration for an application to automatically start on job submission.
        :param pulumi.Input['ApplicationAutoStopConfigurationArgs'] auto_stop_configuration: The configuration for an application to automatically stop after a certain amount of time being idle.
        :param pulumi.Input['ApplicationImageConfigurationArgs'] image_configuration: The image configuration applied to all worker types.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationInitialCapacityArgs']]] initial_capacities: The capacity to initialize when the application is created.
        :param pulumi.Input['ApplicationInteractiveConfigurationArgs'] interactive_configuration: Enables the interactive use cases to use when running an application.
        :param pulumi.Input['ApplicationMaximumCapacityArgs'] maximum_capacity: The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input['ApplicationNetworkConfigurationArgs'] network_configuration: The network configuration for customer VPC connectivity.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] release_label: The EMR release version associated with the application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] type: The type of application you want to start, such as `spark` or `hive`.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_start_configuration is not None:
            pulumi.set(__self__, "auto_start_configuration", auto_start_configuration)
        if auto_stop_configuration is not None:
            pulumi.set(__self__, "auto_stop_configuration", auto_stop_configuration)
        if image_configuration is not None:
            pulumi.set(__self__, "image_configuration", image_configuration)
        if initial_capacities is not None:
            pulumi.set(__self__, "initial_capacities", initial_capacities)
        if interactive_configuration is not None:
            pulumi.set(__self__, "interactive_configuration", interactive_configuration)
        if maximum_capacity is not None:
            pulumi.set(__self__, "maximum_capacity", maximum_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_label is not None:
            pulumi.set(__self__, "release_label", release_label)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoStartConfiguration")
    def auto_start_configuration(self) -> Optional[pulumi.Input['ApplicationAutoStartConfigurationArgs']]:
        """
        The configuration for an application to automatically start on job submission.
        """
        return pulumi.get(self, "auto_start_configuration")

    @auto_start_configuration.setter
    def auto_start_configuration(self, value: Optional[pulumi.Input['ApplicationAutoStartConfigurationArgs']]):
        pulumi.set(self, "auto_start_configuration", value)

    @property
    @pulumi.getter(name="autoStopConfiguration")
    def auto_stop_configuration(self) -> Optional[pulumi.Input['ApplicationAutoStopConfigurationArgs']]:
        """
        The configuration for an application to automatically stop after a certain amount of time being idle.
        """
        return pulumi.get(self, "auto_stop_configuration")

    @auto_stop_configuration.setter
    def auto_stop_configuration(self, value: Optional[pulumi.Input['ApplicationAutoStopConfigurationArgs']]):
        pulumi.set(self, "auto_stop_configuration", value)

    @property
    @pulumi.getter(name="imageConfiguration")
    def image_configuration(self) -> Optional[pulumi.Input['ApplicationImageConfigurationArgs']]:
        """
        The image configuration applied to all worker types.
        """
        return pulumi.get(self, "image_configuration")

    @image_configuration.setter
    def image_configuration(self, value: Optional[pulumi.Input['ApplicationImageConfigurationArgs']]):
        pulumi.set(self, "image_configuration", value)

    @property
    @pulumi.getter(name="initialCapacities")
    def initial_capacities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationInitialCapacityArgs']]]]:
        """
        The capacity to initialize when the application is created.
        """
        return pulumi.get(self, "initial_capacities")

    @initial_capacities.setter
    def initial_capacities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationInitialCapacityArgs']]]]):
        pulumi.set(self, "initial_capacities", value)

    @property
    @pulumi.getter(name="interactiveConfiguration")
    def interactive_configuration(self) -> Optional[pulumi.Input['ApplicationInteractiveConfigurationArgs']]:
        """
        Enables the interactive use cases to use when running an application.
        """
        return pulumi.get(self, "interactive_configuration")

    @interactive_configuration.setter
    def interactive_configuration(self, value: Optional[pulumi.Input['ApplicationInteractiveConfigurationArgs']]):
        pulumi.set(self, "interactive_configuration", value)

    @property
    @pulumi.getter(name="maximumCapacity")
    def maximum_capacity(self) -> Optional[pulumi.Input['ApplicationMaximumCapacityArgs']]:
        """
        The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
        """
        return pulumi.get(self, "maximum_capacity")

    @maximum_capacity.setter
    def maximum_capacity(self, value: Optional[pulumi.Input['ApplicationMaximumCapacityArgs']]):
        pulumi.set(self, "maximum_capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['ApplicationNetworkConfigurationArgs']]:
        """
        The network configuration for customer VPC connectivity.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['ApplicationNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EMR release version associated with the application.
        """
        return pulumi.get(self, "release_label")

    @release_label.setter
    def release_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_label", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of application you want to start, such as `spark` or `hive`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:emrserverless/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 auto_start_configuration: Optional[pulumi.Input[Union['ApplicationAutoStartConfigurationArgs', 'ApplicationAutoStartConfigurationArgsDict']]] = None,
                 auto_stop_configuration: Optional[pulumi.Input[Union['ApplicationAutoStopConfigurationArgs', 'ApplicationAutoStopConfigurationArgsDict']]] = None,
                 image_configuration: Optional[pulumi.Input[Union['ApplicationImageConfigurationArgs', 'ApplicationImageConfigurationArgsDict']]] = None,
                 initial_capacities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationInitialCapacityArgs', 'ApplicationInitialCapacityArgsDict']]]]] = None,
                 interactive_configuration: Optional[pulumi.Input[Union['ApplicationInteractiveConfigurationArgs', 'ApplicationInteractiveConfigurationArgsDict']]] = None,
                 maximum_capacity: Optional[pulumi.Input[Union['ApplicationMaximumCapacityArgs', 'ApplicationMaximumCapacityArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['ApplicationNetworkConfigurationArgs', 'ApplicationNetworkConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 release_label: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an EMR Serverless Application.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emrserverless.Application("example",
            name="example",
            release_label="emr-6.6.0",
            type="hive")
        ```

        ### Initial Capacity Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emrserverless.Application("example",
            name="example",
            release_label="emr-6.6.0",
            type="hive",
            initial_capacities=[{
                "initial_capacity_type": "HiveDriver",
                "initial_capacity_config": {
                    "worker_count": 1,
                    "worker_configuration": {
                        "cpu": "2 vCPU",
                        "memory": "10 GB",
                    },
                },
            }])
        ```

        ### Maximum Capacity Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emrserverless.Application("example",
            name="example",
            release_label="emr-6.6.0",
            type="hive",
            maximum_capacity={
                "cpu": "2 vCPU",
                "memory": "10 GB",
            })
        ```

        ## Import

        Using `pulumi import`, import EMR Severless applications using the `id`. For example:

        ```sh
        $ pulumi import aws:emrserverless/application:Application example id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] architecture: The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
        :param pulumi.Input[Union['ApplicationAutoStartConfigurationArgs', 'ApplicationAutoStartConfigurationArgsDict']] auto_start_configuration: The configuration for an application to automatically start on job submission.
        :param pulumi.Input[Union['ApplicationAutoStopConfigurationArgs', 'ApplicationAutoStopConfigurationArgsDict']] auto_stop_configuration: The configuration for an application to automatically stop after a certain amount of time being idle.
        :param pulumi.Input[Union['ApplicationImageConfigurationArgs', 'ApplicationImageConfigurationArgsDict']] image_configuration: The image configuration applied to all worker types.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationInitialCapacityArgs', 'ApplicationInitialCapacityArgsDict']]]] initial_capacities: The capacity to initialize when the application is created.
        :param pulumi.Input[Union['ApplicationInteractiveConfigurationArgs', 'ApplicationInteractiveConfigurationArgsDict']] interactive_configuration: Enables the interactive use cases to use when running an application.
        :param pulumi.Input[Union['ApplicationMaximumCapacityArgs', 'ApplicationMaximumCapacityArgsDict']] maximum_capacity: The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input[Union['ApplicationNetworkConfigurationArgs', 'ApplicationNetworkConfigurationArgsDict']] network_configuration: The network configuration for customer VPC connectivity.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] release_label: The EMR release version associated with the application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] type: The type of application you want to start, such as `spark` or `hive`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EMR Serverless Application.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emrserverless.Application("example",
            name="example",
            release_label="emr-6.6.0",
            type="hive")
        ```

        ### Initial Capacity Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emrserverless.Application("example",
            name="example",
            release_label="emr-6.6.0",
            type="hive",
            initial_capacities=[{
                "initial_capacity_type": "HiveDriver",
                "initial_capacity_config": {
                    "worker_count": 1,
                    "worker_configuration": {
                        "cpu": "2 vCPU",
                        "memory": "10 GB",
                    },
                },
            }])
        ```

        ### Maximum Capacity Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emrserverless.Application("example",
            name="example",
            release_label="emr-6.6.0",
            type="hive",
            maximum_capacity={
                "cpu": "2 vCPU",
                "memory": "10 GB",
            })
        ```

        ## Import

        Using `pulumi import`, import EMR Severless applications using the `id`. For example:

        ```sh
        $ pulumi import aws:emrserverless/application:Application example id
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[builtins.str]] = None,
                 auto_start_configuration: Optional[pulumi.Input[Union['ApplicationAutoStartConfigurationArgs', 'ApplicationAutoStartConfigurationArgsDict']]] = None,
                 auto_stop_configuration: Optional[pulumi.Input[Union['ApplicationAutoStopConfigurationArgs', 'ApplicationAutoStopConfigurationArgsDict']]] = None,
                 image_configuration: Optional[pulumi.Input[Union['ApplicationImageConfigurationArgs', 'ApplicationImageConfigurationArgsDict']]] = None,
                 initial_capacities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationInitialCapacityArgs', 'ApplicationInitialCapacityArgsDict']]]]] = None,
                 interactive_configuration: Optional[pulumi.Input[Union['ApplicationInteractiveConfigurationArgs', 'ApplicationInteractiveConfigurationArgsDict']]] = None,
                 maximum_capacity: Optional[pulumi.Input[Union['ApplicationMaximumCapacityArgs', 'ApplicationMaximumCapacityArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['ApplicationNetworkConfigurationArgs', 'ApplicationNetworkConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 release_label: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["auto_start_configuration"] = auto_start_configuration
            __props__.__dict__["auto_stop_configuration"] = auto_stop_configuration
            __props__.__dict__["image_configuration"] = image_configuration
            __props__.__dict__["initial_capacities"] = initial_capacities
            __props__.__dict__["interactive_configuration"] = interactive_configuration
            __props__.__dict__["maximum_capacity"] = maximum_capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["region"] = region
            if release_label is None and not opts.urn:
                raise TypeError("Missing required property 'release_label'")
            __props__.__dict__["release_label"] = release_label
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Application, __self__).__init__(
            'aws:emrserverless/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architecture: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            auto_start_configuration: Optional[pulumi.Input[Union['ApplicationAutoStartConfigurationArgs', 'ApplicationAutoStartConfigurationArgsDict']]] = None,
            auto_stop_configuration: Optional[pulumi.Input[Union['ApplicationAutoStopConfigurationArgs', 'ApplicationAutoStopConfigurationArgsDict']]] = None,
            image_configuration: Optional[pulumi.Input[Union['ApplicationImageConfigurationArgs', 'ApplicationImageConfigurationArgsDict']]] = None,
            initial_capacities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationInitialCapacityArgs', 'ApplicationInitialCapacityArgsDict']]]]] = None,
            interactive_configuration: Optional[pulumi.Input[Union['ApplicationInteractiveConfigurationArgs', 'ApplicationInteractiveConfigurationArgsDict']]] = None,
            maximum_capacity: Optional[pulumi.Input[Union['ApplicationMaximumCapacityArgs', 'ApplicationMaximumCapacityArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_configuration: Optional[pulumi.Input[Union['ApplicationNetworkConfigurationArgs', 'ApplicationNetworkConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            release_label: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] architecture: The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
        :param pulumi.Input[builtins.str] arn: ARN of the cluster.
        :param pulumi.Input[Union['ApplicationAutoStartConfigurationArgs', 'ApplicationAutoStartConfigurationArgsDict']] auto_start_configuration: The configuration for an application to automatically start on job submission.
        :param pulumi.Input[Union['ApplicationAutoStopConfigurationArgs', 'ApplicationAutoStopConfigurationArgsDict']] auto_stop_configuration: The configuration for an application to automatically stop after a certain amount of time being idle.
        :param pulumi.Input[Union['ApplicationImageConfigurationArgs', 'ApplicationImageConfigurationArgsDict']] image_configuration: The image configuration applied to all worker types.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationInitialCapacityArgs', 'ApplicationInitialCapacityArgsDict']]]] initial_capacities: The capacity to initialize when the application is created.
        :param pulumi.Input[Union['ApplicationInteractiveConfigurationArgs', 'ApplicationInteractiveConfigurationArgsDict']] interactive_configuration: Enables the interactive use cases to use when running an application.
        :param pulumi.Input[Union['ApplicationMaximumCapacityArgs', 'ApplicationMaximumCapacityArgsDict']] maximum_capacity: The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input[Union['ApplicationNetworkConfigurationArgs', 'ApplicationNetworkConfigurationArgsDict']] network_configuration: The network configuration for customer VPC connectivity.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] release_label: The EMR release version associated with the application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] type: The type of application you want to start, such as `spark` or `hive`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_start_configuration"] = auto_start_configuration
        __props__.__dict__["auto_stop_configuration"] = auto_stop_configuration
        __props__.__dict__["image_configuration"] = image_configuration
        __props__.__dict__["initial_capacities"] = initial_capacities
        __props__.__dict__["interactive_configuration"] = interactive_configuration
        __props__.__dict__["maximum_capacity"] = maximum_capacity
        __props__.__dict__["name"] = name
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["release_label"] = release_label
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The CPU architecture of an application. Valid values are `ARM64` or `X86_64`. Default value is `X86_64`.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoStartConfiguration")
    def auto_start_configuration(self) -> pulumi.Output['outputs.ApplicationAutoStartConfiguration']:
        """
        The configuration for an application to automatically start on job submission.
        """
        return pulumi.get(self, "auto_start_configuration")

    @property
    @pulumi.getter(name="autoStopConfiguration")
    def auto_stop_configuration(self) -> pulumi.Output['outputs.ApplicationAutoStopConfiguration']:
        """
        The configuration for an application to automatically stop after a certain amount of time being idle.
        """
        return pulumi.get(self, "auto_stop_configuration")

    @property
    @pulumi.getter(name="imageConfiguration")
    def image_configuration(self) -> pulumi.Output['outputs.ApplicationImageConfiguration']:
        """
        The image configuration applied to all worker types.
        """
        return pulumi.get(self, "image_configuration")

    @property
    @pulumi.getter(name="initialCapacities")
    def initial_capacities(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationInitialCapacity']]]:
        """
        The capacity to initialize when the application is created.
        """
        return pulumi.get(self, "initial_capacities")

    @property
    @pulumi.getter(name="interactiveConfiguration")
    def interactive_configuration(self) -> pulumi.Output['outputs.ApplicationInteractiveConfiguration']:
        """
        Enables the interactive use cases to use when running an application.
        """
        return pulumi.get(self, "interactive_configuration")

    @property
    @pulumi.getter(name="maximumCapacity")
    def maximum_capacity(self) -> pulumi.Output['outputs.ApplicationMaximumCapacity']:
        """
        The maximum capacity to allocate when the application is created. This is cumulative across all workers at any given point in time, not just when an application is created. No new resources will be created once any one of the defined limits is hit.
        """
        return pulumi.get(self, "maximum_capacity")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationNetworkConfiguration']]:
        """
        The network configuration for customer VPC connectivity.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> pulumi.Output[builtins.str]:
        """
        The EMR release version associated with the application.
        """
        return pulumi.get(self, "release_label")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of application you want to start, such as `spark` or `hive`.
        """
        return pulumi.get(self, "type")

