# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationAutoStartConfiguration',
    'ApplicationAutoStopConfiguration',
    'ApplicationImageConfiguration',
    'ApplicationInitialCapacity',
    'ApplicationInitialCapacityInitialCapacityConfig',
    'ApplicationInitialCapacityInitialCapacityConfigWorkerConfiguration',
    'ApplicationInteractiveConfiguration',
    'ApplicationMaximumCapacity',
    'ApplicationNetworkConfiguration',
]

@pulumi.output_type
class ApplicationAutoStartConfiguration(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool enabled: Enables the application to automatically start on job submission. Defaults to `true`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enables the application to automatically start on job submission. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ApplicationAutoStopConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeoutMinutes":
            suggest = "idle_timeout_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAutoStopConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAutoStopConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAutoStopConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 idle_timeout_minutes: Optional[builtins.int] = None):
        """
        :param builtins.bool enabled: Enables the application to automatically stop after a certain amount of time being idle. Defaults to `true`.
        :param builtins.int idle_timeout_minutes: The amount of idle time in minutes after which your application will automatically stop. Defaults to `15` minutes.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idle_timeout_minutes is not None:
            pulumi.set(__self__, "idle_timeout_minutes", idle_timeout_minutes)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enables the application to automatically stop after a certain amount of time being idle. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="idleTimeoutMinutes")
    def idle_timeout_minutes(self) -> Optional[builtins.int]:
        """
        The amount of idle time in minutes after which your application will automatically stop. Defaults to `15` minutes.
        """
        return pulumi.get(self, "idle_timeout_minutes")


@pulumi.output_type
class ApplicationImageConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationImageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationImageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationImageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_uri: builtins.str):
        """
        :param builtins.str image_uri: The image URI.
        """
        pulumi.set(__self__, "image_uri", image_uri)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> builtins.str:
        """
        The image URI.
        """
        return pulumi.get(self, "image_uri")


@pulumi.output_type
class ApplicationInitialCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialCapacityType":
            suggest = "initial_capacity_type"
        elif key == "initialCapacityConfig":
            suggest = "initial_capacity_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInitialCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInitialCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInitialCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_capacity_type: builtins.str,
                 initial_capacity_config: Optional['outputs.ApplicationInitialCapacityInitialCapacityConfig'] = None):
        """
        :param builtins.str initial_capacity_type: The worker type for an analytics framework. For Spark applications, the key can either be set to `Driver` or `Executor`. For Hive applications, it can be set to `HiveDriver` or `TezTask`.
        :param 'ApplicationInitialCapacityInitialCapacityConfigArgs' initial_capacity_config: The initial capacity configuration per worker.
        """
        pulumi.set(__self__, "initial_capacity_type", initial_capacity_type)
        if initial_capacity_config is not None:
            pulumi.set(__self__, "initial_capacity_config", initial_capacity_config)

    @property
    @pulumi.getter(name="initialCapacityType")
    def initial_capacity_type(self) -> builtins.str:
        """
        The worker type for an analytics framework. For Spark applications, the key can either be set to `Driver` or `Executor`. For Hive applications, it can be set to `HiveDriver` or `TezTask`.
        """
        return pulumi.get(self, "initial_capacity_type")

    @property
    @pulumi.getter(name="initialCapacityConfig")
    def initial_capacity_config(self) -> Optional['outputs.ApplicationInitialCapacityInitialCapacityConfig']:
        """
        The initial capacity configuration per worker.
        """
        return pulumi.get(self, "initial_capacity_config")


@pulumi.output_type
class ApplicationInitialCapacityInitialCapacityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workerCount":
            suggest = "worker_count"
        elif key == "workerConfiguration":
            suggest = "worker_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInitialCapacityInitialCapacityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInitialCapacityInitialCapacityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInitialCapacityInitialCapacityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 worker_count: builtins.int,
                 worker_configuration: Optional['outputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfiguration'] = None):
        """
        :param builtins.int worker_count: The number of workers in the initial capacity configuration.
        :param 'ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs' worker_configuration: The resource configuration of the initial capacity configuration.
        """
        pulumi.set(__self__, "worker_count", worker_count)
        if worker_configuration is not None:
            pulumi.set(__self__, "worker_configuration", worker_configuration)

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> builtins.int:
        """
        The number of workers in the initial capacity configuration.
        """
        return pulumi.get(self, "worker_count")

    @property
    @pulumi.getter(name="workerConfiguration")
    def worker_configuration(self) -> Optional['outputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfiguration']:
        """
        The resource configuration of the initial capacity configuration.
        """
        return pulumi.get(self, "worker_configuration")


@pulumi.output_type
class ApplicationInitialCapacityInitialCapacityConfigWorkerConfiguration(dict):
    def __init__(__self__, *,
                 cpu: builtins.str,
                 memory: builtins.str,
                 disk: Optional[builtins.str] = None):
        """
        :param builtins.str cpu: The CPU requirements for every worker instance of the worker type.
        :param builtins.str memory: The memory requirements for every worker instance of the worker type.
        :param builtins.str disk: The disk requirements for every worker instance of the worker type.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory", memory)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)

    @property
    @pulumi.getter
    def cpu(self) -> builtins.str:
        """
        The CPU requirements for every worker instance of the worker type.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> builtins.str:
        """
        The memory requirements for every worker instance of the worker type.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def disk(self) -> Optional[builtins.str]:
        """
        The disk requirements for every worker instance of the worker type.
        """
        return pulumi.get(self, "disk")


@pulumi.output_type
class ApplicationInteractiveConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "livyEndpointEnabled":
            suggest = "livy_endpoint_enabled"
        elif key == "studioEnabled":
            suggest = "studio_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInteractiveConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInteractiveConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInteractiveConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 livy_endpoint_enabled: Optional[builtins.bool] = None,
                 studio_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.bool livy_endpoint_enabled: Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
        :param builtins.bool studio_enabled: Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
        """
        if livy_endpoint_enabled is not None:
            pulumi.set(__self__, "livy_endpoint_enabled", livy_endpoint_enabled)
        if studio_enabled is not None:
            pulumi.set(__self__, "studio_enabled", studio_enabled)

    @property
    @pulumi.getter(name="livyEndpointEnabled")
    def livy_endpoint_enabled(self) -> Optional[builtins.bool]:
        """
        Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
        """
        return pulumi.get(self, "livy_endpoint_enabled")

    @property
    @pulumi.getter(name="studioEnabled")
    def studio_enabled(self) -> Optional[builtins.bool]:
        """
        Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
        """
        return pulumi.get(self, "studio_enabled")


@pulumi.output_type
class ApplicationMaximumCapacity(dict):
    def __init__(__self__, *,
                 cpu: builtins.str,
                 memory: builtins.str,
                 disk: Optional[builtins.str] = None):
        """
        :param builtins.str cpu: The maximum allowed CPU for an application.
        :param builtins.str memory: The maximum allowed resources for an application.
        :param builtins.str disk: The maximum allowed disk for an application.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory", memory)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)

    @property
    @pulumi.getter
    def cpu(self) -> builtins.str:
        """
        The maximum allowed CPU for an application.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> builtins.str:
        """
        The maximum allowed resources for an application.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def disk(self) -> Optional[builtins.str]:
        """
        The maximum allowed disk for an application.
        """
        return pulumi.get(self, "disk")


@pulumi.output_type
class ApplicationNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] security_group_ids: The array of security group Ids for customer VPC connectivity.
        :param Sequence[builtins.str] subnet_ids: The array of subnet Ids for customer VPC connectivity.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The array of security group Ids for customer VPC connectivity.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The array of subnet Ids for customer VPC connectivity.
        """
        return pulumi.get(self, "subnet_ids")


