# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'KxClusterAutoScalingConfigurationArgs',
    'KxClusterAutoScalingConfigurationArgsDict',
    'KxClusterCacheStorageConfigurationArgs',
    'KxClusterCacheStorageConfigurationArgsDict',
    'KxClusterCapacityConfigurationArgs',
    'KxClusterCapacityConfigurationArgsDict',
    'KxClusterCodeArgs',
    'KxClusterCodeArgsDict',
    'KxClusterDatabaseArgs',
    'KxClusterDatabaseArgsDict',
    'KxClusterDatabaseCacheConfigurationArgs',
    'KxClusterDatabaseCacheConfigurationArgsDict',
    'KxClusterSavedownStorageConfigurationArgs',
    'KxClusterSavedownStorageConfigurationArgsDict',
    'KxClusterScalingGroupConfigurationArgs',
    'KxClusterScalingGroupConfigurationArgsDict',
    'KxClusterTickerplantLogConfigurationArgs',
    'KxClusterTickerplantLogConfigurationArgsDict',
    'KxClusterVpcConfigurationArgs',
    'KxClusterVpcConfigurationArgsDict',
    'KxDataviewSegmentConfigurationArgs',
    'KxDataviewSegmentConfigurationArgsDict',
    'KxEnvironmentCustomDnsConfigurationArgs',
    'KxEnvironmentCustomDnsConfigurationArgsDict',
    'KxEnvironmentTransitGatewayConfigurationArgs',
    'KxEnvironmentTransitGatewayConfigurationArgsDict',
    'KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs',
    'KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsDict',
    'KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs',
    'KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgsDict',
    'KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs',
    'KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgsDict',
    'KxVolumeAttachedClusterArgs',
    'KxVolumeAttachedClusterArgsDict',
    'KxVolumeNas1ConfigurationArgs',
    'KxVolumeNas1ConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class KxClusterAutoScalingConfigurationArgsDict(TypedDict):
        auto_scaling_metric: pulumi.Input[builtins.str]
        """
        Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
        """
        max_node_count: pulumi.Input[builtins.int]
        """
        Highest number of nodes to scale. Cannot be greater than 5
        """
        metric_target: pulumi.Input[builtins.float]
        """
        Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
        """
        min_node_count: pulumi.Input[builtins.int]
        """
        Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
        """
        scale_in_cooldown_seconds: pulumi.Input[builtins.float]
        """
        Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
        """
        scale_out_cooldown_seconds: pulumi.Input[builtins.float]
        """
        Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
        """
elif False:
    KxClusterAutoScalingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterAutoScalingConfigurationArgs:
    def __init__(__self__, *,
                 auto_scaling_metric: pulumi.Input[builtins.str],
                 max_node_count: pulumi.Input[builtins.int],
                 metric_target: pulumi.Input[builtins.float],
                 min_node_count: pulumi.Input[builtins.int],
                 scale_in_cooldown_seconds: pulumi.Input[builtins.float],
                 scale_out_cooldown_seconds: pulumi.Input[builtins.float]):
        """
        :param pulumi.Input[builtins.str] auto_scaling_metric: Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
        :param pulumi.Input[builtins.int] max_node_count: Highest number of nodes to scale. Cannot be greater than 5
        :param pulumi.Input[builtins.float] metric_target: Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
        :param pulumi.Input[builtins.int] min_node_count: Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
        :param pulumi.Input[builtins.float] scale_in_cooldown_seconds: Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
        :param pulumi.Input[builtins.float] scale_out_cooldown_seconds: Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
        """
        pulumi.set(__self__, "auto_scaling_metric", auto_scaling_metric)
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "metric_target", metric_target)
        pulumi.set(__self__, "min_node_count", min_node_count)
        pulumi.set(__self__, "scale_in_cooldown_seconds", scale_in_cooldown_seconds)
        pulumi.set(__self__, "scale_out_cooldown_seconds", scale_out_cooldown_seconds)

    @property
    @pulumi.getter(name="autoScalingMetric")
    def auto_scaling_metric(self) -> pulumi.Input[builtins.str]:
        """
        Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
        """
        return pulumi.get(self, "auto_scaling_metric")

    @auto_scaling_metric.setter
    def auto_scaling_metric(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "auto_scaling_metric", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Input[builtins.int]:
        """
        Highest number of nodes to scale. Cannot be greater than 5
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="metricTarget")
    def metric_target(self) -> pulumi.Input[builtins.float]:
        """
        Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
        """
        return pulumi.get(self, "metric_target")

    @metric_target.setter
    def metric_target(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "metric_target", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> pulumi.Input[builtins.int]:
        """
        Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter(name="scaleInCooldownSeconds")
    def scale_in_cooldown_seconds(self) -> pulumi.Input[builtins.float]:
        """
        Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
        """
        return pulumi.get(self, "scale_in_cooldown_seconds")

    @scale_in_cooldown_seconds.setter
    def scale_in_cooldown_seconds(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "scale_in_cooldown_seconds", value)

    @property
    @pulumi.getter(name="scaleOutCooldownSeconds")
    def scale_out_cooldown_seconds(self) -> pulumi.Input[builtins.float]:
        """
        Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
        """
        return pulumi.get(self, "scale_out_cooldown_seconds")

    @scale_out_cooldown_seconds.setter
    def scale_out_cooldown_seconds(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "scale_out_cooldown_seconds", value)


if not MYPY:
    class KxClusterCacheStorageConfigurationArgsDict(TypedDict):
        size: pulumi.Input[builtins.int]
        type: pulumi.Input[builtins.str]
        """
        Type of KDB database. The following types are available:
        * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
        * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
        * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        * GP - A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only `SINGLE` AZ mode.
        * Tickerplant - A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
        """
elif False:
    KxClusterCacheStorageConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterCacheStorageConfigurationArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[builtins.int],
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] type: Type of KDB database. The following types are available:
               * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
               * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
               * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
               * GP - A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only `SINGLE` AZ mode.
               * Tickerplant - A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[builtins.int]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of KDB database. The following types are available:
        * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
        * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
        * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
        * GP - A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only `SINGLE` AZ mode.
        * Tickerplant - A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class KxClusterCapacityConfigurationArgsDict(TypedDict):
        node_count: pulumi.Input[builtins.int]
        """
        Number of instances running in a cluster. Must be at least 1 and at most 5.
        """
        node_type: pulumi.Input[builtins.str]
        """
        Determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.

        You can only specify one of the following values:
        * kx.s.large - The node type with a configuration of 12 GiB memory and 2 vCPUs.
        * kx.s.xlarge - The node type with a configuration of 27 GiB memory and 4 vCPUs.
        * kx.s.2xlarge - The node type with a configuration of 54 GiB memory and 8 vCPUs.
        * kx.s.4xlarge - The node type with a configuration of 108 GiB memory and 16 vCPUs.
        * kx.s.8xlarge - The node type with a configuration of 216 GiB memory and 32 vCPUs.
        * kx.s.16xlarge - The node type with a configuration of 432 GiB memory and 64 vCPUs.
        * kx.s.32xlarge - The node type with a configuration of 864 GiB memory and 128 vCPUs.
        """
elif False:
    KxClusterCapacityConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterCapacityConfigurationArgs:
    def __init__(__self__, *,
                 node_count: pulumi.Input[builtins.int],
                 node_type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.int] node_count: Number of instances running in a cluster. Must be at least 1 and at most 5.
        :param pulumi.Input[builtins.str] node_type: Determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.
               
               You can only specify one of the following values:
               * kx.s.large - The node type with a configuration of 12 GiB memory and 2 vCPUs.
               * kx.s.xlarge - The node type with a configuration of 27 GiB memory and 4 vCPUs.
               * kx.s.2xlarge - The node type with a configuration of 54 GiB memory and 8 vCPUs.
               * kx.s.4xlarge - The node type with a configuration of 108 GiB memory and 16 vCPUs.
               * kx.s.8xlarge - The node type with a configuration of 216 GiB memory and 32 vCPUs.
               * kx.s.16xlarge - The node type with a configuration of 432 GiB memory and 64 vCPUs.
               * kx.s.32xlarge - The node type with a configuration of 864 GiB memory and 128 vCPUs.
        """
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type", node_type)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[builtins.int]:
        """
        Number of instances running in a cluster. Must be at least 1 and at most 5.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[builtins.str]:
        """
        Determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.

        You can only specify one of the following values:
        * kx.s.large - The node type with a configuration of 12 GiB memory and 2 vCPUs.
        * kx.s.xlarge - The node type with a configuration of 27 GiB memory and 4 vCPUs.
        * kx.s.2xlarge - The node type with a configuration of 54 GiB memory and 8 vCPUs.
        * kx.s.4xlarge - The node type with a configuration of 108 GiB memory and 16 vCPUs.
        * kx.s.8xlarge - The node type with a configuration of 216 GiB memory and 32 vCPUs.
        * kx.s.16xlarge - The node type with a configuration of 432 GiB memory and 64 vCPUs.
        * kx.s.32xlarge - The node type with a configuration of 864 GiB memory and 128 vCPUs.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_type", value)


if not MYPY:
    class KxClusterCodeArgsDict(TypedDict):
        s3_bucket: pulumi.Input[builtins.str]
        """
        Unique name for the S3 bucket.
        """
        s3_key: pulumi.Input[builtins.str]
        """
        Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
        """
        s3_object_version: NotRequired[pulumi.Input[builtins.str]]
        """
        Version of an S3 Object.
        """
elif False:
    KxClusterCodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterCodeArgs:
    def __init__(__self__, *,
                 s3_bucket: pulumi.Input[builtins.str],
                 s3_key: pulumi.Input[builtins.str],
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] s3_bucket: Unique name for the S3 bucket.
        :param pulumi.Input[builtins.str] s3_key: Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
        :param pulumi.Input[builtins.str] s3_object_version: Version of an S3 Object.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Input[builtins.str]:
        """
        Unique name for the S3 bucket.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> pulumi.Input[builtins.str]:
        """
        Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of an S3 Object.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_object_version", value)


if not MYPY:
    class KxClusterDatabaseArgsDict(TypedDict):
        database_name: pulumi.Input[builtins.str]
        """
        Name of the KX database.
        """
        cache_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgsDict']]]]
        """
        Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
        """
        changeset_id: NotRequired[pulumi.Input[builtins.str]]
        """
        A unique identifier of the changeset that is associated with the cluster.
        """
        dataview_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the dataview to be used for caching historical data on disk. You cannot update to a different dataview name once a cluster is created. Use `lifecycle` `ignore_changes` for database to prevent any undesirable behaviors.
        """
elif False:
    KxClusterDatabaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterDatabaseArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[builtins.str],
                 cache_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgs']]]] = None,
                 changeset_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataview_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] database_name: Name of the KX database.
        :param pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgs']]] cache_configurations: Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
        :param pulumi.Input[builtins.str] changeset_id: A unique identifier of the changeset that is associated with the cluster.
        :param pulumi.Input[builtins.str] dataview_name: The name of the dataview to be used for caching historical data on disk. You cannot update to a different dataview name once a cluster is created. Use `lifecycle` `ignore_changes` for database to prevent any undesirable behaviors.
        """
        pulumi.set(__self__, "database_name", database_name)
        if cache_configurations is not None:
            pulumi.set(__self__, "cache_configurations", cache_configurations)
        if changeset_id is not None:
            pulumi.set(__self__, "changeset_id", changeset_id)
        if dataview_name is not None:
            pulumi.set(__self__, "dataview_name", dataview_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the KX database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="cacheConfigurations")
    def cache_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgs']]]]:
        """
        Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
        """
        return pulumi.get(self, "cache_configurations")

    @cache_configurations.setter
    def cache_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxClusterDatabaseCacheConfigurationArgs']]]]):
        pulumi.set(self, "cache_configurations", value)

    @property
    @pulumi.getter(name="changesetId")
    def changeset_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier of the changeset that is associated with the cluster.
        """
        return pulumi.get(self, "changeset_id")

    @changeset_id.setter
    def changeset_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "changeset_id", value)

    @property
    @pulumi.getter(name="dataviewName")
    def dataview_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the dataview to be used for caching historical data on disk. You cannot update to a different dataview name once a cluster is created. Use `lifecycle` `ignore_changes` for database to prevent any undesirable behaviors.
        """
        return pulumi.get(self, "dataview_name")

    @dataview_name.setter
    def dataview_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataview_name", value)


if not MYPY:
    class KxClusterDatabaseCacheConfigurationArgsDict(TypedDict):
        cache_type: pulumi.Input[builtins.str]
        """
        Type of disk cache.
        """
        db_paths: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Paths within the database to cache.
        """
elif False:
    KxClusterDatabaseCacheConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterDatabaseCacheConfigurationArgs:
    def __init__(__self__, *,
                 cache_type: pulumi.Input[builtins.str],
                 db_paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] cache_type: Type of disk cache.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] db_paths: Paths within the database to cache.
        """
        pulumi.set(__self__, "cache_type", cache_type)
        if db_paths is not None:
            pulumi.set(__self__, "db_paths", db_paths)

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of disk cache.
        """
        return pulumi.get(self, "cache_type")

    @cache_type.setter
    def cache_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cache_type", value)

    @property
    @pulumi.getter(name="dbPaths")
    def db_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Paths within the database to cache.
        """
        return pulumi.get(self, "db_paths")

    @db_paths.setter
    def db_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "db_paths", value)


if not MYPY:
    class KxClusterSavedownStorageConfigurationArgsDict(TypedDict):
        size: NotRequired[pulumi.Input[builtins.int]]
        """
        Size of temporary storage in gigabytes. Must be between 10 and 16000.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of writeable storage space for temporarily storing your savedown data. The valid values are:
        * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
        """
        volume_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the kdb volume that you want to use as writeable save-down storage for clusters.
        """
elif False:
    KxClusterSavedownStorageConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterSavedownStorageConfigurationArgs:
    def __init__(__self__, *,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 volume_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] size: Size of temporary storage in gigabytes. Must be between 10 and 16000.
        :param pulumi.Input[builtins.str] type: Type of writeable storage space for temporarily storing your savedown data. The valid values are:
               * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
        :param pulumi.Input[builtins.str] volume_name: The name of the kdb volume that you want to use as writeable save-down storage for clusters.
        """
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size of temporary storage in gigabytes. Must be between 10 and 16000.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of writeable storage space for temporarily storing your savedown data. The valid values are:
        * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the kdb volume that you want to use as writeable save-down storage for clusters.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_name", value)


if not MYPY:
    class KxClusterScalingGroupConfigurationArgsDict(TypedDict):
        memory_reservation: pulumi.Input[builtins.int]
        """
        A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
        """
        node_count: pulumi.Input[builtins.int]
        """
        The number of kdb cluster nodes.
        """
        scaling_group_name: pulumi.Input[builtins.str]
        """
        A unique identifier for the kdb scaling group.
        """
        cpu: NotRequired[pulumi.Input[builtins.float]]
        """
        The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
        """
        memory_limit: NotRequired[pulumi.Input[builtins.int]]
        """
        An optional hard limit on the amount of memory a kdb cluster can use.
        """
elif False:
    KxClusterScalingGroupConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterScalingGroupConfigurationArgs:
    def __init__(__self__, *,
                 memory_reservation: pulumi.Input[builtins.int],
                 node_count: pulumi.Input[builtins.int],
                 scaling_group_name: pulumi.Input[builtins.str],
                 cpu: Optional[pulumi.Input[builtins.float]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] memory_reservation: A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
        :param pulumi.Input[builtins.int] node_count: The number of kdb cluster nodes.
        :param pulumi.Input[builtins.str] scaling_group_name: A unique identifier for the kdb scaling group.
        :param pulumi.Input[builtins.float] cpu: The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
        :param pulumi.Input[builtins.int] memory_limit: An optional hard limit on the amount of memory a kdb cluster can use.
        """
        pulumi.set(__self__, "memory_reservation", memory_reservation)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> pulumi.Input[builtins.int]:
        """
        A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
        """
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "memory_reservation", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[builtins.int]:
        """
        The number of kdb cluster nodes.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> pulumi.Input[builtins.str]:
        """
        A unique identifier for the kdb scaling group.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "scaling_group_name", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An optional hard limit on the amount of memory a kdb cluster can use.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_limit", value)


if not MYPY:
    class KxClusterTickerplantLogConfigurationArgsDict(TypedDict):
        tickerplant_log_volumes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
elif False:
    KxClusterTickerplantLogConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterTickerplantLogConfigurationArgs:
    def __init__(__self__, *,
                 tickerplant_log_volumes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(__self__, "tickerplant_log_volumes", tickerplant_log_volumes)

    @property
    @pulumi.getter(name="tickerplantLogVolumes")
    def tickerplant_log_volumes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "tickerplant_log_volumes")

    @tickerplant_log_volumes.setter
    def tickerplant_log_volumes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "tickerplant_log_volumes", value)


if not MYPY:
    class KxClusterVpcConfigurationArgsDict(TypedDict):
        ip_address_type: pulumi.Input[builtins.str]
        """
        IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
        """
        security_group_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
        * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
        """
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        vpc_id: pulumi.Input[builtins.str]
        """
        Identifier of the VPC endpoint
        """
elif False:
    KxClusterVpcConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxClusterVpcConfigurationArgs:
    def __init__(__self__, *,
                 ip_address_type: pulumi.Input[builtins.str],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 vpc_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] ip_address_type: IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
               * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
        :param pulumi.Input[builtins.str] vpc_id: Identifier of the VPC endpoint
        """
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Input[builtins.str]:
        """
        IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
        * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the VPC endpoint
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class KxDataviewSegmentConfigurationArgsDict(TypedDict):
        db_paths: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
        """
        volume_name: pulumi.Input[builtins.str]
        """
        The name of the volume that you want to attach to a dataview. This volume must be in the same availability zone as the dataview that you are attaching to.
        """
        on_demand: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
        """
elif False:
    KxDataviewSegmentConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxDataviewSegmentConfigurationArgs:
    def __init__(__self__, *,
                 db_paths: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 volume_name: pulumi.Input[builtins.str],
                 on_demand: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] db_paths: The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
        :param pulumi.Input[builtins.str] volume_name: The name of the volume that you want to attach to a dataview. This volume must be in the same availability zone as the dataview that you are attaching to.
        :param pulumi.Input[builtins.bool] on_demand: Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
        """
        pulumi.set(__self__, "db_paths", db_paths)
        pulumi.set(__self__, "volume_name", volume_name)
        if on_demand is not None:
            pulumi.set(__self__, "on_demand", on_demand)

    @property
    @pulumi.getter(name="dbPaths")
    def db_paths(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
        """
        return pulumi.get(self, "db_paths")

    @db_paths.setter
    def db_paths(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "db_paths", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the volume that you want to attach to a dataview. This volume must be in the same availability zone as the dataview that you are attaching to.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "volume_name", value)

    @property
    @pulumi.getter(name="onDemand")
    def on_demand(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
        """
        return pulumi.get(self, "on_demand")

    @on_demand.setter
    def on_demand(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "on_demand", value)


if not MYPY:
    class KxEnvironmentCustomDnsConfigurationArgsDict(TypedDict):
        custom_dns_server_ip: pulumi.Input[builtins.str]
        """
        IP address of the DNS server.
        """
        custom_dns_server_name: pulumi.Input[builtins.str]
        """
        Name of the DNS server.
        """
elif False:
    KxEnvironmentCustomDnsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxEnvironmentCustomDnsConfigurationArgs:
    def __init__(__self__, *,
                 custom_dns_server_ip: pulumi.Input[builtins.str],
                 custom_dns_server_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] custom_dns_server_ip: IP address of the DNS server.
        :param pulumi.Input[builtins.str] custom_dns_server_name: Name of the DNS server.
        """
        pulumi.set(__self__, "custom_dns_server_ip", custom_dns_server_ip)
        pulumi.set(__self__, "custom_dns_server_name", custom_dns_server_name)

    @property
    @pulumi.getter(name="customDnsServerIp")
    def custom_dns_server_ip(self) -> pulumi.Input[builtins.str]:
        """
        IP address of the DNS server.
        """
        return pulumi.get(self, "custom_dns_server_ip")

    @custom_dns_server_ip.setter
    def custom_dns_server_ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "custom_dns_server_ip", value)

    @property
    @pulumi.getter(name="customDnsServerName")
    def custom_dns_server_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the DNS server.
        """
        return pulumi.get(self, "custom_dns_server_name")

    @custom_dns_server_name.setter
    def custom_dns_server_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "custom_dns_server_name", value)


if not MYPY:
    class KxEnvironmentTransitGatewayConfigurationArgsDict(TypedDict):
        routable_cidr_space: pulumi.Input[builtins.str]
        """
        Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
        """
        transit_gateway_id: pulumi.Input[builtins.str]
        """
        Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
        """
        attachment_network_acl_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsDict']]]]
        """
        Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
        """
elif False:
    KxEnvironmentTransitGatewayConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxEnvironmentTransitGatewayConfigurationArgs:
    def __init__(__self__, *,
                 routable_cidr_space: pulumi.Input[builtins.str],
                 transit_gateway_id: pulumi.Input[builtins.str],
                 attachment_network_acl_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] routable_cidr_space: Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
        :param pulumi.Input[builtins.str] transit_gateway_id: Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
        :param pulumi.Input[Sequence[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs']]] attachment_network_acl_configurations: Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
        """
        pulumi.set(__self__, "routable_cidr_space", routable_cidr_space)
        pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if attachment_network_acl_configurations is not None:
            pulumi.set(__self__, "attachment_network_acl_configurations", attachment_network_acl_configurations)

    @property
    @pulumi.getter(name="routableCidrSpace")
    def routable_cidr_space(self) -> pulumi.Input[builtins.str]:
        """
        Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
        """
        return pulumi.get(self, "routable_cidr_space")

    @routable_cidr_space.setter
    def routable_cidr_space(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "routable_cidr_space", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="attachmentNetworkAclConfigurations")
    def attachment_network_acl_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs']]]]:
        """
        Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
        """
        return pulumi.get(self, "attachment_network_acl_configurations")

    @attachment_network_acl_configurations.setter
    def attachment_network_acl_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs']]]]):
        pulumi.set(self, "attachment_network_acl_configurations", value)


if not MYPY:
    class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsDict(TypedDict):
        cidr_block: pulumi.Input[builtins.str]
        """
        The IPv4 network range to allow or deny, in CIDR notation. The specified CIDR block is modified to its canonical form. For example, `100.68.0.18/18` will be converted to `100.68.0.0/18`.
        """
        protocol: pulumi.Input[builtins.str]
        """
        Protocol number. A value of `1` means all the protocols.
        """
        rule_action: pulumi.Input[builtins.str]
        """
        Indicates whether to `allow` or `deny` the traffic that matches the rule.
        """
        rule_number: pulumi.Input[builtins.int]
        """
        Rule number for the entry. All the network ACL entries are processed in ascending order by rule number.
        """
        icmp_type_code: NotRequired[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgsDict']]
        """
        Defines the ICMP protocol that consists of the ICMP type and code. Defined below.
        """
        port_range: NotRequired[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgsDict']]
        """
        Range of ports the rule applies to. Defined below.
        """
elif False:
    KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[builtins.str],
                 protocol: pulumi.Input[builtins.str],
                 rule_action: pulumi.Input[builtins.str],
                 rule_number: pulumi.Input[builtins.int],
                 icmp_type_code: Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs']] = None,
                 port_range: Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs']] = None):
        """
        :param pulumi.Input[builtins.str] cidr_block: The IPv4 network range to allow or deny, in CIDR notation. The specified CIDR block is modified to its canonical form. For example, `100.68.0.18/18` will be converted to `100.68.0.0/18`.
        :param pulumi.Input[builtins.str] protocol: Protocol number. A value of `1` means all the protocols.
        :param pulumi.Input[builtins.str] rule_action: Indicates whether to `allow` or `deny` the traffic that matches the rule.
        :param pulumi.Input[builtins.int] rule_number: Rule number for the entry. All the network ACL entries are processed in ascending order by rule number.
        :param pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs'] icmp_type_code: Defines the ICMP protocol that consists of the ICMP type and code. Defined below.
        :param pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs'] port_range: Range of ports the rule applies to. Defined below.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "rule_action", rule_action)
        pulumi.set(__self__, "rule_number", rule_number)
        if icmp_type_code is not None:
            pulumi.set(__self__, "icmp_type_code", icmp_type_code)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[builtins.str]:
        """
        The IPv4 network range to allow or deny, in CIDR notation. The specified CIDR block is modified to its canonical form. For example, `100.68.0.18/18` will be converted to `100.68.0.0/18`.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        Protocol number. A value of `1` means all the protocols.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> pulumi.Input[builtins.str]:
        """
        Indicates whether to `allow` or `deny` the traffic that matches the rule.
        """
        return pulumi.get(self, "rule_action")

    @rule_action.setter
    def rule_action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rule_action", value)

    @property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> pulumi.Input[builtins.int]:
        """
        Rule number for the entry. All the network ACL entries are processed in ascending order by rule number.
        """
        return pulumi.get(self, "rule_number")

    @rule_number.setter
    def rule_number(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "rule_number", value)

    @property
    @pulumi.getter(name="icmpTypeCode")
    def icmp_type_code(self) -> Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs']]:
        """
        Defines the ICMP protocol that consists of the ICMP type and code. Defined below.
        """
        return pulumi.get(self, "icmp_type_code")

    @icmp_type_code.setter
    def icmp_type_code(self, value: Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs']]):
        pulumi.set(self, "icmp_type_code", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs']]:
        """
        Range of ports the rule applies to. Defined below.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs']]):
        pulumi.set(self, "port_range", value)


if not MYPY:
    class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgsDict(TypedDict):
        code: pulumi.Input[builtins.int]
        """
        ICMP code. A value of `-1` means all codes for the specified ICMP type.
        """
        type: pulumi.Input[builtins.int]
        """
        ICMP type. A value of `-1` means all types.
        """
elif False:
    KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[builtins.int],
                 type: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] code: ICMP code. A value of `-1` means all codes for the specified ICMP type.
        :param pulumi.Input[builtins.int] type: ICMP type. A value of `-1` means all types.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Input[builtins.int]:
        """
        ICMP code. A value of `-1` means all codes for the specified ICMP type.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.int]:
        """
        ICMP type. A value of `-1` means all types.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "type", value)


if not MYPY:
    class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgsDict(TypedDict):
        from_: pulumi.Input[builtins.int]
        """
        First port in the range.
        """
        to: pulumi.Input[builtins.int]
        """
        Last port in the range.
        """
elif False:
    KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input[builtins.int],
                 to: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] from_: First port in the range.
        :param pulumi.Input[builtins.int] to: Last port in the range.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input[builtins.int]:
        """
        First port in the range.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def to(self) -> pulumi.Input[builtins.int]:
        """
        Last port in the range.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "to", value)


if not MYPY:
    class KxVolumeAttachedClusterArgsDict(TypedDict):
        cluster_name: pulumi.Input[builtins.str]
        cluster_status: pulumi.Input[builtins.str]
        cluster_type: pulumi.Input[builtins.str]
elif False:
    KxVolumeAttachedClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxVolumeAttachedClusterArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[builtins.str],
                 cluster_status: pulumi.Input[builtins.str],
                 cluster_type: pulumi.Input[builtins.str]):
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_status", cluster_status)
        pulumi.set(__self__, "cluster_type", cluster_type)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="clusterStatus")
    def cluster_status(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "cluster_status")

    @cluster_status.setter
    def cluster_status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_status", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_type", value)


if not MYPY:
    class KxVolumeNas1ConfigurationArgsDict(TypedDict):
        size: pulumi.Input[builtins.int]
        """
        The size of the network attached storage.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of the network attached storage.
        """
elif False:
    KxVolumeNas1ConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KxVolumeNas1ConfigurationArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[builtins.int],
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.int] size: The size of the network attached storage.
        :param pulumi.Input[builtins.str] type: The type of the network attached storage.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[builtins.int]:
        """
        The size of the network attached storage.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the network attached storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


