# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KxEnvironmentArgs', 'KxEnvironment']

@pulumi.input_type
class KxEnvironmentArgs:
    def __init__(__self__, *,
                 kms_key_id: pulumi.Input[builtins.str],
                 custom_dns_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentCustomDnsConfigurationArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transit_gateway_configuration: Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationArgs']] = None):
        """
        The set of arguments for constructing a KxEnvironment resource.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ID to encrypt your data in the FinSpace environment.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['KxEnvironmentCustomDnsConfigurationArgs']]] custom_dns_configurations: List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
        :param pulumi.Input[builtins.str] description: Description for the KX environment.
        :param pulumi.Input[builtins.str] name: Name of the KX environment that you want to create.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['KxEnvironmentTransitGatewayConfigurationArgs'] transit_gateway_configuration: Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if custom_dns_configurations is not None:
            pulumi.set(__self__, "custom_dns_configurations", custom_dns_configurations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_gateway_configuration is not None:
            pulumi.set(__self__, "transit_gateway_configuration", transit_gateway_configuration)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Input[builtins.str]:
        """
        KMS key ID to encrypt your data in the FinSpace environment.

        The following arguments are optional:
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="customDnsConfigurations")
    def custom_dns_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentCustomDnsConfigurationArgs']]]]:
        """
        List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
        """
        return pulumi.get(self, "custom_dns_configurations")

    @custom_dns_configurations.setter
    def custom_dns_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentCustomDnsConfigurationArgs']]]]):
        pulumi.set(self, "custom_dns_configurations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the KX environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the KX environment that you want to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="transitGatewayConfiguration")
    def transit_gateway_configuration(self) -> Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationArgs']]:
        """
        Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
        """
        return pulumi.get(self, "transit_gateway_configuration")

    @transit_gateway_configuration.setter
    def transit_gateway_configuration(self, value: Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationArgs']]):
        pulumi.set(self, "transit_gateway_configuration", value)


@pulumi.input_type
class _KxEnvironmentState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 created_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 custom_dns_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentCustomDnsConfigurationArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_modified_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transit_gateway_configuration: Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering KxEnvironment resources.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) identifier of the KX environment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: AWS Availability Zone IDs that this environment is available in. Important when selecting VPC subnets to use in cluster creation.
        :param pulumi.Input[builtins.str] created_timestamp: Timestamp at which the environment is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        :param pulumi.Input[Sequence[pulumi.Input['KxEnvironmentCustomDnsConfigurationArgs']]] custom_dns_configurations: List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
        :param pulumi.Input[builtins.str] description: Description for the KX environment.
        :param pulumi.Input[builtins.str] infrastructure_account_id: Unique identifier for the AWS environment infrastructure account.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ID to encrypt your data in the FinSpace environment.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] last_modified_timestamp: Last timestamp at which the environment was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        :param pulumi.Input[builtins.str] name: Name of the KX environment that you want to create.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: Status of environment creation
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['KxEnvironmentTransitGatewayConfigurationArgs'] transit_gateway_configuration: Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if created_timestamp is not None:
            pulumi.set(__self__, "created_timestamp", created_timestamp)
        if custom_dns_configurations is not None:
            pulumi.set(__self__, "custom_dns_configurations", custom_dns_configurations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if infrastructure_account_id is not None:
            pulumi.set(__self__, "infrastructure_account_id", infrastructure_account_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if last_modified_timestamp is not None:
            pulumi.set(__self__, "last_modified_timestamp", last_modified_timestamp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if transit_gateway_configuration is not None:
            pulumi.set(__self__, "transit_gateway_configuration", transit_gateway_configuration)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) identifier of the KX environment.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        AWS Availability Zone IDs that this environment is available in. Important when selecting VPC subnets to use in cluster creation.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp at which the environment is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        """
        return pulumi.get(self, "created_timestamp")

    @created_timestamp.setter
    def created_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_timestamp", value)

    @property
    @pulumi.getter(name="customDnsConfigurations")
    def custom_dns_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentCustomDnsConfigurationArgs']]]]:
        """
        List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
        """
        return pulumi.get(self, "custom_dns_configurations")

    @custom_dns_configurations.setter
    def custom_dns_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxEnvironmentCustomDnsConfigurationArgs']]]]):
        pulumi.set(self, "custom_dns_configurations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the KX environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="infrastructureAccountId")
    def infrastructure_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier for the AWS environment infrastructure account.
        """
        return pulumi.get(self, "infrastructure_account_id")

    @infrastructure_account_id.setter
    def infrastructure_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "infrastructure_account_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS key ID to encrypt your data in the FinSpace environment.

        The following arguments are optional:
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lastModifiedTimestamp")
    def last_modified_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last timestamp at which the environment was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        """
        return pulumi.get(self, "last_modified_timestamp")

    @last_modified_timestamp.setter
    def last_modified_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified_timestamp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the KX environment that you want to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of environment creation
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="transitGatewayConfiguration")
    def transit_gateway_configuration(self) -> Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationArgs']]:
        """
        Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
        """
        return pulumi.get(self, "transit_gateway_configuration")

    @transit_gateway_configuration.setter
    def transit_gateway_configuration(self, value: Optional[pulumi.Input['KxEnvironmentTransitGatewayConfigurationArgs']]):
        pulumi.set(self, "transit_gateway_configuration", value)


@pulumi.type_token("aws:finspace/kxEnvironment:KxEnvironment")
class KxEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_dns_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KxEnvironmentCustomDnsConfigurationArgs', 'KxEnvironmentCustomDnsConfigurationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transit_gateway_configuration: Optional[pulumi.Input[Union['KxEnvironmentTransitGatewayConfigurationArgs', 'KxEnvironmentTransitGatewayConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS FinSpace Kx Environment.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="Sample KMS Key",
            deletion_window_in_days=7)
        example_kx_environment = aws.finspace.KxEnvironment("example",
            name="my-tf-kx-environment",
            kms_key_id=example.arn)
        ```

        ### With Transit Gateway Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="Sample KMS Key",
            deletion_window_in_days=7)
        example_transit_gateway = aws.ec2transitgateway.TransitGateway("example", description="example")
        example_env = aws.finspace.KxEnvironment("example_env",
            name="my-tf-kx-environment",
            description="Environment description",
            kms_key_id=example.arn,
            transit_gateway_configuration={
                "transit_gateway_id": example_transit_gateway.id,
                "routable_cidr_space": "100.64.0.0/26",
            },
            custom_dns_configurations=[{
                "custom_dns_server_name": "example.finspace.amazonaws.com",
                "custom_dns_server_ip": "10.0.0.76",
            }])
        ```

        ### With Transit Gateway Attachment Network ACL Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="Sample KMS Key",
            deletion_window_in_days=7)
        example_transit_gateway = aws.ec2transitgateway.TransitGateway("example", description="example")
        example_env = aws.finspace.KxEnvironment("example_env",
            name="my-tf-kx-environment",
            description="Environment description",
            kms_key_id=example.arn,
            transit_gateway_configuration={
                "transit_gateway_id": example_transit_gateway.id,
                "routable_cidr_space": "100.64.0.0/26",
                "attachment_network_acl_configurations": [{
                    "rule_number": 1,
                    "protocol": "6",
                    "rule_action": "allow",
                    "cidr_block": "0.0.0.0/0",
                    "port_range": {
                        "from_": 53,
                        "to": 53,
                    },
                    "icmp_type_code": {
                        "type": -1,
                        "code": -1,
                    },
                }],
            },
            custom_dns_configurations=[{
                "custom_dns_server_name": "example.finspace.amazonaws.com",
                "custom_dns_server_ip": "10.0.0.76",
            }])
        ```

        ## Import

        Using `pulumi import`, import an AWS FinSpace Kx Environment using the `id`. For example:

        ```sh
        $ pulumi import aws:finspace/kxEnvironment:KxEnvironment example n3ceo7wqxoxcti5tujqwzs
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KxEnvironmentCustomDnsConfigurationArgs', 'KxEnvironmentCustomDnsConfigurationArgsDict']]]] custom_dns_configurations: List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
        :param pulumi.Input[builtins.str] description: Description for the KX environment.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ID to encrypt your data in the FinSpace environment.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] name: Name of the KX environment that you want to create.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['KxEnvironmentTransitGatewayConfigurationArgs', 'KxEnvironmentTransitGatewayConfigurationArgsDict']] transit_gateway_configuration: Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KxEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS FinSpace Kx Environment.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="Sample KMS Key",
            deletion_window_in_days=7)
        example_kx_environment = aws.finspace.KxEnvironment("example",
            name="my-tf-kx-environment",
            kms_key_id=example.arn)
        ```

        ### With Transit Gateway Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="Sample KMS Key",
            deletion_window_in_days=7)
        example_transit_gateway = aws.ec2transitgateway.TransitGateway("example", description="example")
        example_env = aws.finspace.KxEnvironment("example_env",
            name="my-tf-kx-environment",
            description="Environment description",
            kms_key_id=example.arn,
            transit_gateway_configuration={
                "transit_gateway_id": example_transit_gateway.id,
                "routable_cidr_space": "100.64.0.0/26",
            },
            custom_dns_configurations=[{
                "custom_dns_server_name": "example.finspace.amazonaws.com",
                "custom_dns_server_ip": "10.0.0.76",
            }])
        ```

        ### With Transit Gateway Attachment Network ACL Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="Sample KMS Key",
            deletion_window_in_days=7)
        example_transit_gateway = aws.ec2transitgateway.TransitGateway("example", description="example")
        example_env = aws.finspace.KxEnvironment("example_env",
            name="my-tf-kx-environment",
            description="Environment description",
            kms_key_id=example.arn,
            transit_gateway_configuration={
                "transit_gateway_id": example_transit_gateway.id,
                "routable_cidr_space": "100.64.0.0/26",
                "attachment_network_acl_configurations": [{
                    "rule_number": 1,
                    "protocol": "6",
                    "rule_action": "allow",
                    "cidr_block": "0.0.0.0/0",
                    "port_range": {
                        "from_": 53,
                        "to": 53,
                    },
                    "icmp_type_code": {
                        "type": -1,
                        "code": -1,
                    },
                }],
            },
            custom_dns_configurations=[{
                "custom_dns_server_name": "example.finspace.amazonaws.com",
                "custom_dns_server_ip": "10.0.0.76",
            }])
        ```

        ## Import

        Using `pulumi import`, import an AWS FinSpace Kx Environment using the `id`. For example:

        ```sh
        $ pulumi import aws:finspace/kxEnvironment:KxEnvironment example n3ceo7wqxoxcti5tujqwzs
        ```

        :param str resource_name: The name of the resource.
        :param KxEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KxEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_dns_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KxEnvironmentCustomDnsConfigurationArgs', 'KxEnvironmentCustomDnsConfigurationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 transit_gateway_configuration: Optional[pulumi.Input[Union['KxEnvironmentTransitGatewayConfigurationArgs', 'KxEnvironmentTransitGatewayConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KxEnvironmentArgs.__new__(KxEnvironmentArgs)

            __props__.__dict__["custom_dns_configurations"] = custom_dns_configurations
            __props__.__dict__["description"] = description
            if kms_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'kms_key_id'")
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_gateway_configuration"] = transit_gateway_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["availability_zones"] = None
            __props__.__dict__["created_timestamp"] = None
            __props__.__dict__["infrastructure_account_id"] = None
            __props__.__dict__["last_modified_timestamp"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(KxEnvironment, __self__).__init__(
            'aws:finspace/kxEnvironment:KxEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            created_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            custom_dns_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KxEnvironmentCustomDnsConfigurationArgs', 'KxEnvironmentCustomDnsConfigurationArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            infrastructure_account_id: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            last_modified_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            transit_gateway_configuration: Optional[pulumi.Input[Union['KxEnvironmentTransitGatewayConfigurationArgs', 'KxEnvironmentTransitGatewayConfigurationArgsDict']]] = None) -> 'KxEnvironment':
        """
        Get an existing KxEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) identifier of the KX environment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: AWS Availability Zone IDs that this environment is available in. Important when selecting VPC subnets to use in cluster creation.
        :param pulumi.Input[builtins.str] created_timestamp: Timestamp at which the environment is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KxEnvironmentCustomDnsConfigurationArgs', 'KxEnvironmentCustomDnsConfigurationArgsDict']]]] custom_dns_configurations: List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
        :param pulumi.Input[builtins.str] description: Description for the KX environment.
        :param pulumi.Input[builtins.str] infrastructure_account_id: Unique identifier for the AWS environment infrastructure account.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ID to encrypt your data in the FinSpace environment.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] last_modified_timestamp: Last timestamp at which the environment was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        :param pulumi.Input[builtins.str] name: Name of the KX environment that you want to create.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: Status of environment creation
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['KxEnvironmentTransitGatewayConfigurationArgs', 'KxEnvironmentTransitGatewayConfigurationArgsDict']] transit_gateway_configuration: Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KxEnvironmentState.__new__(_KxEnvironmentState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["created_timestamp"] = created_timestamp
        __props__.__dict__["custom_dns_configurations"] = custom_dns_configurations
        __props__.__dict__["description"] = description
        __props__.__dict__["infrastructure_account_id"] = infrastructure_account_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["last_modified_timestamp"] = last_modified_timestamp
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["transit_gateway_configuration"] = transit_gateway_configuration
        return KxEnvironment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) identifier of the KX environment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        AWS Availability Zone IDs that this environment is available in. Important when selecting VPC subnets to use in cluster creation.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp at which the environment is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="customDnsConfigurations")
    def custom_dns_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.KxEnvironmentCustomDnsConfiguration']]]:
        """
        List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
        """
        return pulumi.get(self, "custom_dns_configurations")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description for the KX environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="infrastructureAccountId")
    def infrastructure_account_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier for the AWS environment infrastructure account.
        """
        return pulumi.get(self, "infrastructure_account_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        KMS key ID to encrypt your data in the FinSpace environment.

        The following arguments are optional:
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lastModifiedTimestamp")
    def last_modified_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Last timestamp at which the environment was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
        """
        return pulumi.get(self, "last_modified_timestamp")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the KX environment that you want to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of environment creation
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="transitGatewayConfiguration")
    def transit_gateway_configuration(self) -> pulumi.Output[Optional['outputs.KxEnvironmentTransitGatewayConfiguration']]:
        """
        Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
        """
        return pulumi.get(self, "transit_gateway_configuration")

