# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOntapFileSystemResult',
    'AwaitableGetOntapFileSystemResult',
    'get_ontap_file_system',
    'get_ontap_file_system_output',
]

@pulumi.output_type
class GetOntapFileSystemResult:
    """
    A collection of values returned by getOntapFileSystem.
    """
    def __init__(__self__, arn=None, automatic_backup_retention_days=None, daily_automatic_backup_start_time=None, deployment_type=None, disk_iops_configurations=None, dns_name=None, endpoint_ip_address_range=None, endpoints=None, ha_pairs=None, id=None, kms_key_id=None, network_interface_ids=None, owner_id=None, preferred_subnet_id=None, region=None, route_table_ids=None, storage_capacity=None, storage_type=None, subnet_ids=None, tags=None, throughput_capacity=None, throughput_capacity_per_ha_pair=None, vpc_id=None, weekly_maintenance_start_time=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if automatic_backup_retention_days and not isinstance(automatic_backup_retention_days, int):
            raise TypeError("Expected argument 'automatic_backup_retention_days' to be a int")
        pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if daily_automatic_backup_start_time and not isinstance(daily_automatic_backup_start_time, str):
            raise TypeError("Expected argument 'daily_automatic_backup_start_time' to be a str")
        pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if disk_iops_configurations and not isinstance(disk_iops_configurations, list):
            raise TypeError("Expected argument 'disk_iops_configurations' to be a list")
        pulumi.set(__self__, "disk_iops_configurations", disk_iops_configurations)
        if dns_name and not isinstance(dns_name, str):
            raise TypeError("Expected argument 'dns_name' to be a str")
        pulumi.set(__self__, "dns_name", dns_name)
        if endpoint_ip_address_range and not isinstance(endpoint_ip_address_range, str):
            raise TypeError("Expected argument 'endpoint_ip_address_range' to be a str")
        pulumi.set(__self__, "endpoint_ip_address_range", endpoint_ip_address_range)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if ha_pairs and not isinstance(ha_pairs, int):
            raise TypeError("Expected argument 'ha_pairs' to be a int")
        pulumi.set(__self__, "ha_pairs", ha_pairs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if network_interface_ids and not isinstance(network_interface_ids, list):
            raise TypeError("Expected argument 'network_interface_ids' to be a list")
        pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if preferred_subnet_id and not isinstance(preferred_subnet_id, str):
            raise TypeError("Expected argument 'preferred_subnet_id' to be a str")
        pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if route_table_ids and not isinstance(route_table_ids, list):
            raise TypeError("Expected argument 'route_table_ids' to be a list")
        pulumi.set(__self__, "route_table_ids", route_table_ids)
        if storage_capacity and not isinstance(storage_capacity, int):
            raise TypeError("Expected argument 'storage_capacity' to be a int")
        pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type and not isinstance(storage_type, str):
            raise TypeError("Expected argument 'storage_type' to be a str")
        pulumi.set(__self__, "storage_type", storage_type)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if throughput_capacity and not isinstance(throughput_capacity, int):
            raise TypeError("Expected argument 'throughput_capacity' to be a int")
        pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if throughput_capacity_per_ha_pair and not isinstance(throughput_capacity_per_ha_pair, int):
            raise TypeError("Expected argument 'throughput_capacity_per_ha_pair' to be a int")
        pulumi.set(__self__, "throughput_capacity_per_ha_pair", throughput_capacity_per_ha_pair)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if weekly_maintenance_start_time and not isinstance(weekly_maintenance_start_time, str):
            raise TypeError("Expected argument 'weekly_maintenance_start_time' to be a str")
        pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> builtins.int:
        """
        The number of days to retain automatic backups.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> builtins.str:
        """
        The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> builtins.str:
        """
        The file system deployment type.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="diskIopsConfigurations")
    def disk_iops_configurations(self) -> Sequence['outputs.GetOntapFileSystemDiskIopsConfigurationResult']:
        """
        The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system, specifying the number of provisioned IOPS and the provision mode. See Disk IOPS Below.
        """
        return pulumi.get(self, "disk_iops_configurations")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> builtins.str:
        """
        DNS name for the file system.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> builtins.str:
        """
        (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system exist.
        """
        return pulumi.get(self, "endpoint_ip_address_range")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetOntapFileSystemEndpointResult']:
        """
        The Management and Intercluster FileSystemEndpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See FileSystemEndpoints below.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="haPairs")
    def ha_pairs(self) -> builtins.int:
        """
        The number of HA pairs for the file system.
        """
        return pulumi.get(self, "ha_pairs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier of the file system (e.g. `fs-12345678`).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        ARN for the KMS Key to encrypt the file system at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> Sequence[builtins.str]:
        """
        The IDs of the elastic network interfaces from which a specific file system is accessible.
        """
        return pulumi.get(self, "network_interface_ids")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> builtins.str:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> builtins.str:
        """
        Specifies the subnet in which you want the preferred file server to be located.
        """
        return pulumi.get(self, "preferred_subnet_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Sequence[builtins.str]:
        """
        (Multi-AZ only) The VPC route tables in which your file system's endpoints exist.
        """
        return pulumi.get(self, "route_table_ids")

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> builtins.int:
        """
        The storage capacity of the file system in gibibytes (GiB).
        """
        return pulumi.get(self, "storage_capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> builtins.str:
        """
        The type of storage the file system is using. If set to `SSD`, the file system uses solid state drive storage. If set to `HDD`, the file system uses hard disk drive storage.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        Specifies the IDs of the subnets that the file system is accessible from. For the MULTI_AZ_1 file system deployment type, there are two subnet IDs, one for the preferred file server and one for the standby file server. The preferred file server subnet identified in the `preferred_subnet_id` property.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        The tags associated with the file system.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> builtins.int:
        """
        The sustained throughput of an Amazon FSx file system in Megabytes per second (MBps). If the file system uses multiple HA pairs this will equal throuthput_capacity_per_ha_pair x ha_pairs
        """
        return pulumi.get(self, "throughput_capacity")

    @property
    @pulumi.getter(name="throughputCapacityPerHaPair")
    def throughput_capacity_per_ha_pair(self) -> builtins.int:
        """
        The sustained throughput of each HA pair for an Amazon FSx file system in Megabytes per second (MBps).
        """
        return pulumi.get(self, "throughput_capacity_per_ha_pair")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The ID of the primary virtual private cloud (VPC) for the file system.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> builtins.str:
        """
        The preferred start time (in `D:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")


class AwaitableGetOntapFileSystemResult(GetOntapFileSystemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOntapFileSystemResult(
            arn=self.arn,
            automatic_backup_retention_days=self.automatic_backup_retention_days,
            daily_automatic_backup_start_time=self.daily_automatic_backup_start_time,
            deployment_type=self.deployment_type,
            disk_iops_configurations=self.disk_iops_configurations,
            dns_name=self.dns_name,
            endpoint_ip_address_range=self.endpoint_ip_address_range,
            endpoints=self.endpoints,
            ha_pairs=self.ha_pairs,
            id=self.id,
            kms_key_id=self.kms_key_id,
            network_interface_ids=self.network_interface_ids,
            owner_id=self.owner_id,
            preferred_subnet_id=self.preferred_subnet_id,
            region=self.region,
            route_table_ids=self.route_table_ids,
            storage_capacity=self.storage_capacity,
            storage_type=self.storage_type,
            subnet_ids=self.subnet_ids,
            tags=self.tags,
            throughput_capacity=self.throughput_capacity,
            throughput_capacity_per_ha_pair=self.throughput_capacity_per_ha_pair,
            vpc_id=self.vpc_id,
            weekly_maintenance_start_time=self.weekly_maintenance_start_time)


def get_ontap_file_system(id: Optional[builtins.str] = None,
                          region: Optional[builtins.str] = None,
                          tags: Optional[Mapping[str, builtins.str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOntapFileSystemResult:
    """
    Retrieve information on FSx ONTAP File System.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.fsx.get_ontap_file_system(id="fs-12345678")
    ```


    :param builtins.str id: Identifier of the file system (e.g. `fs-12345678`).
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: The tags associated with the file system.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:fsx/getOntapFileSystem:getOntapFileSystem', __args__, opts=opts, typ=GetOntapFileSystemResult).value

    return AwaitableGetOntapFileSystemResult(
        arn=pulumi.get(__ret__, 'arn'),
        automatic_backup_retention_days=pulumi.get(__ret__, 'automatic_backup_retention_days'),
        daily_automatic_backup_start_time=pulumi.get(__ret__, 'daily_automatic_backup_start_time'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        disk_iops_configurations=pulumi.get(__ret__, 'disk_iops_configurations'),
        dns_name=pulumi.get(__ret__, 'dns_name'),
        endpoint_ip_address_range=pulumi.get(__ret__, 'endpoint_ip_address_range'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        ha_pairs=pulumi.get(__ret__, 'ha_pairs'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        network_interface_ids=pulumi.get(__ret__, 'network_interface_ids'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        preferred_subnet_id=pulumi.get(__ret__, 'preferred_subnet_id'),
        region=pulumi.get(__ret__, 'region'),
        route_table_ids=pulumi.get(__ret__, 'route_table_ids'),
        storage_capacity=pulumi.get(__ret__, 'storage_capacity'),
        storage_type=pulumi.get(__ret__, 'storage_type'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        tags=pulumi.get(__ret__, 'tags'),
        throughput_capacity=pulumi.get(__ret__, 'throughput_capacity'),
        throughput_capacity_per_ha_pair=pulumi.get(__ret__, 'throughput_capacity_per_ha_pair'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        weekly_maintenance_start_time=pulumi.get(__ret__, 'weekly_maintenance_start_time'))
def get_ontap_file_system_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                 region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOntapFileSystemResult]:
    """
    Retrieve information on FSx ONTAP File System.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.fsx.get_ontap_file_system(id="fs-12345678")
    ```


    :param builtins.str id: Identifier of the file system (e.g. `fs-12345678`).
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: The tags associated with the file system.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:fsx/getOntapFileSystem:getOntapFileSystem', __args__, opts=opts, typ=GetOntapFileSystemResult)
    return __ret__.apply(lambda __response__: GetOntapFileSystemResult(
        arn=pulumi.get(__response__, 'arn'),
        automatic_backup_retention_days=pulumi.get(__response__, 'automatic_backup_retention_days'),
        daily_automatic_backup_start_time=pulumi.get(__response__, 'daily_automatic_backup_start_time'),
        deployment_type=pulumi.get(__response__, 'deployment_type'),
        disk_iops_configurations=pulumi.get(__response__, 'disk_iops_configurations'),
        dns_name=pulumi.get(__response__, 'dns_name'),
        endpoint_ip_address_range=pulumi.get(__response__, 'endpoint_ip_address_range'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        ha_pairs=pulumi.get(__response__, 'ha_pairs'),
        id=pulumi.get(__response__, 'id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        network_interface_ids=pulumi.get(__response__, 'network_interface_ids'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        preferred_subnet_id=pulumi.get(__response__, 'preferred_subnet_id'),
        region=pulumi.get(__response__, 'region'),
        route_table_ids=pulumi.get(__response__, 'route_table_ids'),
        storage_capacity=pulumi.get(__response__, 'storage_capacity'),
        storage_type=pulumi.get(__response__, 'storage_type'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        tags=pulumi.get(__response__, 'tags'),
        throughput_capacity=pulumi.get(__response__, 'throughput_capacity'),
        throughput_capacity_per_ha_pair=pulumi.get(__response__, 'throughput_capacity_per_ha_pair'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        weekly_maintenance_start_time=pulumi.get(__response__, 'weekly_maintenance_start_time')))
