# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OpenZfsVolumeArgs', 'OpenZfsVolume']

@pulumi.input_type
class OpenZfsVolumeArgs:
    def __init__(__self__, *,
                 parent_volume_id: pulumi.Input[builtins.str],
                 copy_tags_to_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
                 data_compression_type: Optional[pulumi.Input[builtins.str]] = None,
                 delete_volume_options: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nfs_exports: Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']] = None,
                 origin_snapshot: Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']] = None,
                 read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 record_size_kib: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_capacity_quota_gib: Optional[pulumi.Input[builtins.int]] = None,
                 storage_capacity_reservation_gib: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OpenZfsVolume resource.
        :param pulumi.Input[builtins.str] parent_volume_id: The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[builtins.str] data_compression_type: Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input[builtins.str] delete_volume_options: Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
        :param pulumi.Input[builtins.str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input['OpenZfsVolumeNfsExportsArgs'] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
        :param pulumi.Input['OpenZfsVolumeOriginSnapshotArgs'] origin_snapshot: Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
        :param pulumi.Input[builtins.bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[builtins.int] record_size_kib: The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] storage_capacity_quota_gib: The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        :param pulumi.Input[builtins.int] storage_capacity_reservation_gib: The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
        """
        pulumi.set(__self__, "parent_volume_id", parent_volume_id)
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if delete_volume_options is not None:
            pulumi.set(__self__, "delete_volume_options", delete_volume_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if origin_snapshot is not None:
            pulumi.set(__self__, "origin_snapshot", origin_snapshot)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_kib is not None:
            pulumi.set(__self__, "record_size_kib", record_size_kib)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_capacity_quota_gib is not None:
            pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        if storage_capacity_reservation_gib is not None:
            pulumi.set(__self__, "storage_capacity_reservation_gib", storage_capacity_reservation_gib)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="parentVolumeId")
    def parent_volume_id(self) -> pulumi.Input[builtins.str]:
        """
        The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        """
        return pulumi.get(self, "parent_volume_id")

    @parent_volume_id.setter
    def parent_volume_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent_volume_id", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @copy_tags_to_snapshots.setter
    def copy_tags_to_snapshots(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_tags_to_snapshots", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter(name="deleteVolumeOptions")
    def delete_volume_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
        """
        return pulumi.get(self, "delete_volume_options")

    @delete_volume_options.setter
    def delete_volume_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_volume_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']]:
        """
        NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
        """
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter(name="originSnapshot")
    def origin_snapshot(self) -> Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']]:
        """
        Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
        """
        return pulumi.get(self, "origin_snapshot")

    @origin_snapshot.setter
    def origin_snapshot(self, value: Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']]):
        pulumi.set(self, "origin_snapshot", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recordSizeKib")
    def record_size_kib(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        """
        return pulumi.get(self, "record_size_kib")

    @record_size_kib.setter
    def record_size_kib(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "record_size_kib", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @storage_capacity_quota_gib.setter
    def storage_capacity_quota_gib(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_capacity_quota_gib", value)

    @property
    @pulumi.getter(name="storageCapacityReservationGib")
    def storage_capacity_reservation_gib(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        """
        return pulumi.get(self, "storage_capacity_reservation_gib")

    @storage_capacity_reservation_gib.setter
    def storage_capacity_reservation_gib(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_capacity_reservation_gib", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]]:
        """
        Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
        """
        return pulumi.get(self, "user_and_group_quotas")

    @user_and_group_quotas.setter
    def user_and_group_quotas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]]):
        pulumi.set(self, "user_and_group_quotas", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _OpenZfsVolumeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
                 data_compression_type: Optional[pulumi.Input[builtins.str]] = None,
                 delete_volume_options: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nfs_exports: Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']] = None,
                 origin_snapshot: Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']] = None,
                 parent_volume_id: Optional[pulumi.Input[builtins.str]] = None,
                 read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 record_size_kib: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_capacity_quota_gib: Optional[pulumi.Input[builtins.int]] = None,
                 storage_capacity_reservation_gib: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OpenZfsVolume resources.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[builtins.str] data_compression_type: Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input[builtins.str] delete_volume_options: Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
        :param pulumi.Input[builtins.str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input['OpenZfsVolumeNfsExportsArgs'] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
        :param pulumi.Input['OpenZfsVolumeOriginSnapshotArgs'] origin_snapshot: Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
        :param pulumi.Input[builtins.str] parent_volume_id: The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        :param pulumi.Input[builtins.bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[builtins.int] record_size_kib: The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] storage_capacity_quota_gib: The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        :param pulumi.Input[builtins.int] storage_capacity_reservation_gib: The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if delete_volume_options is not None:
            pulumi.set(__self__, "delete_volume_options", delete_volume_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if origin_snapshot is not None:
            pulumi.set(__self__, "origin_snapshot", origin_snapshot)
        if parent_volume_id is not None:
            pulumi.set(__self__, "parent_volume_id", parent_volume_id)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_kib is not None:
            pulumi.set(__self__, "record_size_kib", record_size_kib)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_capacity_quota_gib is not None:
            pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        if storage_capacity_reservation_gib is not None:
            pulumi.set(__self__, "storage_capacity_reservation_gib", storage_capacity_reservation_gib)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @copy_tags_to_snapshots.setter
    def copy_tags_to_snapshots(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_tags_to_snapshots", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter(name="deleteVolumeOptions")
    def delete_volume_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
        """
        return pulumi.get(self, "delete_volume_options")

    @delete_volume_options.setter
    def delete_volume_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete_volume_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']]:
        """
        NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
        """
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input['OpenZfsVolumeNfsExportsArgs']]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter(name="originSnapshot")
    def origin_snapshot(self) -> Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']]:
        """
        Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
        """
        return pulumi.get(self, "origin_snapshot")

    @origin_snapshot.setter
    def origin_snapshot(self, value: Optional[pulumi.Input['OpenZfsVolumeOriginSnapshotArgs']]):
        pulumi.set(self, "origin_snapshot", value)

    @property
    @pulumi.getter(name="parentVolumeId")
    def parent_volume_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        """
        return pulumi.get(self, "parent_volume_id")

    @parent_volume_id.setter
    def parent_volume_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_volume_id", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recordSizeKib")
    def record_size_kib(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        """
        return pulumi.get(self, "record_size_kib")

    @record_size_kib.setter
    def record_size_kib(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "record_size_kib", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @storage_capacity_quota_gib.setter
    def storage_capacity_quota_gib(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_capacity_quota_gib", value)

    @property
    @pulumi.getter(name="storageCapacityReservationGib")
    def storage_capacity_reservation_gib(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        """
        return pulumi.get(self, "storage_capacity_reservation_gib")

    @storage_capacity_reservation_gib.setter
    def storage_capacity_reservation_gib(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_capacity_reservation_gib", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]]:
        """
        Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
        """
        return pulumi.get(self, "user_and_group_quotas")

    @user_and_group_quotas.setter
    def user_and_group_quotas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeUserAndGroupQuotaArgs']]]]):
        pulumi.set(self, "user_and_group_quotas", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("aws:fsx/openZfsVolume:OpenZfsVolume")
class OpenZfsVolume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_tags_to_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
                 data_compression_type: Optional[pulumi.Input[builtins.str]] = None,
                 delete_volume_options: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nfs_exports: Optional[pulumi.Input[Union['OpenZfsVolumeNfsExportsArgs', 'OpenZfsVolumeNfsExportsArgsDict']]] = None,
                 origin_snapshot: Optional[pulumi.Input[Union['OpenZfsVolumeOriginSnapshotArgs', 'OpenZfsVolumeOriginSnapshotArgsDict']]] = None,
                 parent_volume_id: Optional[pulumi.Input[builtins.str]] = None,
                 read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 record_size_kib: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_capacity_quota_gib: Optional[pulumi.Input[builtins.int]] = None,
                 storage_capacity_reservation_gib: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpenZfsVolumeUserAndGroupQuotaArgs', 'OpenZfsVolumeUserAndGroupQuotaArgsDict']]]]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Amazon FSx for OpenZFS volume.
        See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OpenZfsVolume("test",
            name="testvolume",
            parent_volume_id=test_aws_fsx_openzfs_file_system["rootVolumeId"])
        ```

        ## Import

        Using `pulumi import`, import FSx Volumes using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/openZfsVolume:OpenZfsVolume example fsvol-543ab12b1ca672f33
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[builtins.str] data_compression_type: Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input[builtins.str] delete_volume_options: Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
        :param pulumi.Input[builtins.str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input[Union['OpenZfsVolumeNfsExportsArgs', 'OpenZfsVolumeNfsExportsArgsDict']] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
        :param pulumi.Input[Union['OpenZfsVolumeOriginSnapshotArgs', 'OpenZfsVolumeOriginSnapshotArgsDict']] origin_snapshot: Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
        :param pulumi.Input[builtins.str] parent_volume_id: The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        :param pulumi.Input[builtins.bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[builtins.int] record_size_kib: The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] storage_capacity_quota_gib: The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        :param pulumi.Input[builtins.int] storage_capacity_reservation_gib: The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OpenZfsVolumeUserAndGroupQuotaArgs', 'OpenZfsVolumeUserAndGroupQuotaArgsDict']]]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OpenZfsVolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon FSx for OpenZFS volume.
        See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OpenZfsVolume("test",
            name="testvolume",
            parent_volume_id=test_aws_fsx_openzfs_file_system["rootVolumeId"])
        ```

        ## Import

        Using `pulumi import`, import FSx Volumes using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/openZfsVolume:OpenZfsVolume example fsvol-543ab12b1ca672f33
        ```

        :param str resource_name: The name of the resource.
        :param OpenZfsVolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OpenZfsVolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_tags_to_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
                 data_compression_type: Optional[pulumi.Input[builtins.str]] = None,
                 delete_volume_options: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nfs_exports: Optional[pulumi.Input[Union['OpenZfsVolumeNfsExportsArgs', 'OpenZfsVolumeNfsExportsArgsDict']]] = None,
                 origin_snapshot: Optional[pulumi.Input[Union['OpenZfsVolumeOriginSnapshotArgs', 'OpenZfsVolumeOriginSnapshotArgsDict']]] = None,
                 parent_volume_id: Optional[pulumi.Input[builtins.str]] = None,
                 read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 record_size_kib: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_capacity_quota_gib: Optional[pulumi.Input[builtins.int]] = None,
                 storage_capacity_reservation_gib: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpenZfsVolumeUserAndGroupQuotaArgs', 'OpenZfsVolumeUserAndGroupQuotaArgsDict']]]]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OpenZfsVolumeArgs.__new__(OpenZfsVolumeArgs)

            __props__.__dict__["copy_tags_to_snapshots"] = copy_tags_to_snapshots
            __props__.__dict__["data_compression_type"] = data_compression_type
            __props__.__dict__["delete_volume_options"] = delete_volume_options
            __props__.__dict__["name"] = name
            __props__.__dict__["nfs_exports"] = nfs_exports
            __props__.__dict__["origin_snapshot"] = origin_snapshot
            if parent_volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_volume_id'")
            __props__.__dict__["parent_volume_id"] = parent_volume_id
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["record_size_kib"] = record_size_kib
            __props__.__dict__["region"] = region
            __props__.__dict__["storage_capacity_quota_gib"] = storage_capacity_quota_gib
            __props__.__dict__["storage_capacity_reservation_gib"] = storage_capacity_reservation_gib
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_and_group_quotas"] = user_and_group_quotas
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(OpenZfsVolume, __self__).__init__(
            'aws:fsx/openZfsVolume:OpenZfsVolume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            copy_tags_to_snapshots: Optional[pulumi.Input[builtins.bool]] = None,
            data_compression_type: Optional[pulumi.Input[builtins.str]] = None,
            delete_volume_options: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nfs_exports: Optional[pulumi.Input[Union['OpenZfsVolumeNfsExportsArgs', 'OpenZfsVolumeNfsExportsArgsDict']]] = None,
            origin_snapshot: Optional[pulumi.Input[Union['OpenZfsVolumeOriginSnapshotArgs', 'OpenZfsVolumeOriginSnapshotArgsDict']]] = None,
            parent_volume_id: Optional[pulumi.Input[builtins.str]] = None,
            read_only: Optional[pulumi.Input[builtins.bool]] = None,
            record_size_kib: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            storage_capacity_quota_gib: Optional[pulumi.Input[builtins.int]] = None,
            storage_capacity_reservation_gib: Optional[pulumi.Input[builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OpenZfsVolumeUserAndGroupQuotaArgs', 'OpenZfsVolumeUserAndGroupQuotaArgsDict']]]]] = None,
            volume_type: Optional[pulumi.Input[builtins.str]] = None) -> 'OpenZfsVolume':
        """
        Get an existing OpenZfsVolume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[builtins.str] data_compression_type: Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input[builtins.str] delete_volume_options: Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
        :param pulumi.Input[builtins.str] name: The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        :param pulumi.Input[Union['OpenZfsVolumeNfsExportsArgs', 'OpenZfsVolumeNfsExportsArgsDict']] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
        :param pulumi.Input[Union['OpenZfsVolumeOriginSnapshotArgs', 'OpenZfsVolumeOriginSnapshotArgsDict']] origin_snapshot: Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
        :param pulumi.Input[builtins.str] parent_volume_id: The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        :param pulumi.Input[builtins.bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[builtins.int] record_size_kib: The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] storage_capacity_quota_gib: The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        :param pulumi.Input[builtins.int] storage_capacity_reservation_gib: The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OpenZfsVolumeUserAndGroupQuotaArgs', 'OpenZfsVolumeUserAndGroupQuotaArgsDict']]]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OpenZfsVolumeState.__new__(_OpenZfsVolumeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["copy_tags_to_snapshots"] = copy_tags_to_snapshots
        __props__.__dict__["data_compression_type"] = data_compression_type
        __props__.__dict__["delete_volume_options"] = delete_volume_options
        __props__.__dict__["name"] = name
        __props__.__dict__["nfs_exports"] = nfs_exports
        __props__.__dict__["origin_snapshot"] = origin_snapshot
        __props__.__dict__["parent_volume_id"] = parent_volume_id
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["record_size_kib"] = record_size_kib
        __props__.__dict__["region"] = region
        __props__.__dict__["storage_capacity_quota_gib"] = storage_capacity_quota_gib
        __props__.__dict__["storage_capacity_reservation_gib"] = storage_capacity_reservation_gib
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_and_group_quotas"] = user_and_group_quotas
        __props__.__dict__["volume_type"] = volume_type
        return OpenZfsVolume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @property
    @pulumi.getter(name="deleteVolumeOptions")
    def delete_volume_options(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
        """
        return pulumi.get(self, "delete_volume_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> pulumi.Output[Optional['outputs.OpenZfsVolumeNfsExports']]:
        """
        NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
        """
        return pulumi.get(self, "nfs_exports")

    @property
    @pulumi.getter(name="originSnapshot")
    def origin_snapshot(self) -> pulumi.Output[Optional['outputs.OpenZfsVolumeOriginSnapshot']]:
        """
        Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
        """
        return pulumi.get(self, "origin_snapshot")

    @property
    @pulumi.getter(name="parentVolumeId")
    def parent_volume_id(self) -> pulumi.Output[builtins.str]:
        """
        The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `fsx.OpenZfsVolume`.
        """
        return pulumi.get(self, "parent_volume_id")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[builtins.bool]:
        """
        specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="recordSizeKib")
    def record_size_kib(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        """
        return pulumi.get(self, "record_size_kib")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> pulumi.Output[builtins.int]:
        """
        The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @property
    @pulumi.getter(name="storageCapacityReservationGib")
    def storage_capacity_reservation_gib(self) -> pulumi.Output[builtins.int]:
        """
        The amount of storage in gibibytes (GiB) to reserve from the parent volume.
        """
        return pulumi.get(self, "storage_capacity_reservation_gib")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> pulumi.Output[Sequence['outputs.OpenZfsVolumeUserAndGroupQuota']]:
        """
        Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
        """
        return pulumi.get(self, "user_and_group_quotas")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "volume_type")

